/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.ContrassenhaExames;
import jalis.laboratorio.util.RequisitarContrassenhaUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RequisitarContrassenha
extends JDialog {
    JLabel labelMensagem = new JLabel();
    JLabel labelRequisitar = new JLabel("Insira a contrassenha:");
    TTextField textRequisitar = new TTextField(ContrassenhaExames.QTDE_CARACTERES, 1);
    JPanel panelRequisitar = new JPanel(new FlowLayout(0));
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonOk = new JButton("OK");
    JButton buttonCancelar = new JButton("Cancelar");
    private boolean ok = false;
    private String senha = null;

    public String getSenhaGerada() {
        return this.senha;
    }

    public RequisitarContrassenha(JFrame pai, Integer codPaciente, Integer codConvenio, String medConselho, String medCRM, String medUf, ArrayList<Registro> examesMateriais, Double percentualBalcao) throws Exception {
        super((Frame)pai, true);
        this.construirTela(codPaciente, codConvenio, medConselho, medCRM, medUf, examesMateriais, percentualBalcao);
    }

    public RequisitarContrassenha(JDialog pai, Integer codPaciente, Integer codConvenio, String medConselho, String medCRM, String medUf, ArrayList<Registro> examesMateriais, Double percentualBalcao) throws Exception {
        super((Dialog)pai, true);
        this.construirTela(codPaciente, codConvenio, medConselho, medCRM, medUf, examesMateriais, percentualBalcao);
    }

    public RequisitarContrassenha() {
    }

    private void construirTela(Integer codPaciente, Integer codConvenio, String medConselho, String medCRM, String medUf, ArrayList<Registro> examesMateriais, Double percentualBalcao) throws Exception {
        try {
            Statement st = Conexao.getStatement();
            this.executaInserts(false, codPaciente, codConvenio, medConselho, medCRM, medUf, examesMateriais, percentualBalcao, st);
            Conexao.arquivaSQL();
            Conexao.fecharStatement(st);
            this.montaTela();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar dados da senha do exame.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    public void executaInserts(boolean isColetaWeb, Integer codPaciente, Integer codConvenio, String medConselho, String medCRM, String medUf, ArrayList<Registro> examesMateriais, Double percentualBalcao, Statement st) throws Exception {
        this.senha = ContrassenhaExames.gerarSenha(st);
        RequisitarContrassenhaUtil.gravarContrassenha(isColetaWeb, codPaciente, codConvenio, medConselho, medCRM, medUf, examesMateriais, percentualBalcao, st, this.senha);
    }

    private void montaTela() {
        this.setTitle("Contrassenha");
        StringBuilder buf = new StringBuilder();
        buf.append("<html><font size = 3>O exame exige uma contrassenha para ser adicionado.<br>");
        buf.append("A senha gerada para o exame \u00e9: </font><font size = 4 color='red'>").append(this.senha).append("</font>.</html>");
        this.labelMensagem.setText(buf.toString());
        Dimension d = new Dimension(100, 20);
        this.textRequisitar.setPreferredSize(d);
        this.textRequisitar.setMinimumSize(d);
        this.panelRequisitar.setBorder(BorderFactory.createTitledBorder(""));
        this.panelRequisitar.add(this.labelRequisitar);
        this.panelRequisitar.add(this.textRequisitar);
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(RequisitarContrassenha.this.textRequisitar)) {
                    Funcoes.mensagem(RequisitarContrassenha.this, "Insira uma contrassenha.", 2);
                    ScreenUtil.requisitarFoco(RequisitarContrassenha.this.textRequisitar);
                    return;
                }
                if (!RequisitarContrassenha.this.validarContrassenha()) {
                    Funcoes.mensagem(RequisitarContrassenha.this, "A contrassenha informada n\u00e3o combina com a senha.", 2);
                    RequisitarContrassenha.this.textRequisitar.selectAll();
                    ScreenUtil.requisitarFoco(RequisitarContrassenha.this.textRequisitar);
                    return;
                }
                RequisitarContrassenha.this.ok = true;
                RequisitarContrassenha.this.setVisible(false);
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Statement st = Conexao.getStatement();
                RequisitarContrassenhaUtil.executaDeletes(RequisitarContrassenha.this.senha, st, false, () -> {
                    try {
                        Conexao.arquivaSQL();
                        return true;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }, () -> {
                    try {
                        Conexao.anulaSQL();
                        return true;
                    }
                    catch (Exception e3) {
                        return false;
                    }
                });
                Conexao.fecharStatement(st);
                RequisitarContrassenha.this.ok = false;
                RequisitarContrassenha.this.setVisible(false);
            }
        });
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        JPanel panelTemp = new JPanel(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panelTemp, "Center");
        panelTemp.add((Component)this.labelMensagem, "North");
        panelTemp.add((Component)this.panelRequisitar, "Center");
        panelTemp.add((Component)this.panelBotoes, "South");
        panelTemp.setBorder(ScreenUtil.criarBordaVazia());
        this.setSize(new Dimension(375, 144));
        this.setResizable(false);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.centralizar(this);
    }

    private boolean validarContrassenha() {
        try {
            return ContrassenhaExames.validaContraSenha(this.textRequisitar.getText(), this.senha);
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Contrassenha inv\u00e1lida.", 2);
            return false;
        }
    }

    public boolean isOk() {
        return this.ok;
    }
}

