/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.laboratorio.recepcao.Agendamento;
import jalis.laboratorio.recepcao.Horario;
import jalis.model.bean.recepcao.AgendamentoBean;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class RepresentacaoAgendamento
extends JPanel
implements MouseListener,
Comparable {
    public static final Color[] COR_ABERTO = new Color[]{ScreenUtil.clarearCor(Color.BLUE, 70), ScreenUtil.escurecerCor(Color.BLUE, 70)};
    public static final Color[] COR_ATRASADO = new Color[]{ScreenUtil.clarearCor(Color.RED, 70), ScreenUtil.escurecerCor(Color.RED, 70)};
    public static final Color[] COR_FINALIZADO = new Color[]{new Color(250, 120, 30), new Color(200, 125, 50)};
    public static final Color[] COR_COLETANDO = new Color[]{new Color(0, 170, 0), new Color(0, 100, 0)};
    public static RepresentacaoAgendamento agendamentoSelecionado;
    private AgendamentoBean agendamento;
    private boolean permiteSelecionar = false;
    private Horario horario = null;
    private JLabel labelMensagem = new JLabel();

    public RepresentacaoAgendamento(AgendamentoBean agendamento, boolean selecionado, boolean permiteSelecionar) {
        this.setName("RepresentacaoAgendamento");
        this.agendamento = agendamento;
        this.labelMensagem.setName("labelMensagem");
        this.labelMensagem.setHorizontalAlignment(0);
        this.labelMensagem.setFont(this.getFont().deriveFont(0, 10.0f));
        this.labelMensagem.setForeground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelMensagem, "Center");
        if (permiteSelecionar) {
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.setOpaque(true);
        this.montaRepresentacao();
    }

    public void setHorario(Horario horario) {
        this.horario = horario;
    }

    public Horario getHorario() {
        return this.horario;
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponent(g);
        super.paintComponents(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Color[] cores = new Color[2];
        if (this.agendamento.getSituacao().equalsIgnoreCase("A")) {
            cores = this.agendamento.getDataHoraAgendamento().compareTo(new Date()) < 0 && this.agendamento.getSalaAtendimento().getApresentarContador() != null && !this.agendamento.getSalaAtendimento().getApresentarContador().booleanValue() ? COR_ATRASADO : COR_ABERTO;
        } else if (this.agendamento.getSituacao().equalsIgnoreCase("T")) {
            cores = COR_COLETANDO;
        } else if (this.agendamento.getSituacao().equalsIgnoreCase("F")) {
            cores = COR_FINALIZADO;
        }
        if (agendamentoSelecionado == this) {
            ((Graphics2D)g).setColor(cores[1]);
        } else {
            ((Graphics2D)g).setColor(cores[0]);
        }
        ((Graphics2D)g).fillRect(0, 0, this.getWidth(), this.getHeight());
        ((Graphics2D)g).setColor(Color.BLACK);
        ((Graphics2D)g).drawRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void montaRepresentacao() {
        if (this.agendamento.getRequisicao() != null) {
            if (!Funcoes.textoVazio(this.agendamento.getRequisicao().getPaciente().getNomeSocial())) {
                this.labelMensagem.setText(this.agendamento.getRequisicao().getPaciente().getNomeSocial());
            } else {
                this.labelMensagem.setText(this.agendamento.getRequisicao().getPaciente().getNome());
            }
        }
    }

    public AgendamentoBean getAgendamento() {
        return this.agendamento;
    }

    public void setAgendamento(AgendamentoBean agendamento) {
        this.agendamento = agendamento;
        this.labelMensagem.setText(agendamento.getRequisicao().getPaciente().getNome());
    }

    private void setSelecionado(boolean isSelecionado) {
        if (Horario.horarioSelecionado != null) {
            Horario.horarioSelecionado.desselecionar();
        }
        agendamentoSelecionado = isSelecionado ? this : null;
        Agendamento.getInstancia().controlaCampos();
        this.repaint();
    }

    public void selecionar(final boolean posicionarComponente) {
        this.selecionar();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (posicionarComponente) {
                    Agendamento.getInstancia().posicionarAgendamento(RepresentacaoAgendamento.this);
                }
            }
        });
    }

    public void selecionar() {
        if (agendamentoSelecionado != null) {
            agendamentoSelecionado.setSelecionado(false);
        }
        this.setSelecionado(true);
        if (this.horario != null && this.horario.getPanelAgendamento() != null) {
            Agendamento.getInstancia().controlaCampos();
            Agendamento.getInstancia().setAgendamentoSelecionado(this.agendamento);
        }
        this.repaint();
    }

    public void desselecionar() {
        this.setSelecionado(false);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.equals(agendamentoSelecionado)) {
            this.desselecionar();
        } else {
            this.selecionar(true);
        }
    }

    @Override
    @Deprecated
    public void mousePressed(MouseEvent e) {
    }

    @Override
    @Deprecated
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    @Deprecated
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    @Deprecated
    public void mouseExited(MouseEvent e) {
    }

    public int compareTo(Object o) {
        if (!(o instanceof RepresentacaoAgendamento)) {
            return 0;
        }
        return this.agendamento.getDataHora().compareTo(((RepresentacaoAgendamento)o).agendamento.getDataHora());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof RepresentacaoAgendamento) {
            RepresentacaoAgendamento aux = (RepresentacaoAgendamento)o;
            if (this.getAgendamento() != null && aux.getAgendamento() != null) {
                return this.getAgendamento().getCodigo().intValue() == aux.getAgendamento().getCodigo().intValue();
            }
            return false;
        }
        return false;
    }
}

