/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.DetalhesMotivoContato;
import jalis.model.bean.configuracao.UsuarioCompromissoBean;
import jalis.model.dao.cadastro.auxiliares.UsuarioCompromissoDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.configuracao.UsuarioCompromissoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class RegistroContato
extends AbstractDialogoOKCancelar {
    private JPanel panelRegistro = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder(""));
    private JPanel panelBotoes = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder(""));
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelHora = new JLabel("Hora:");
    private JLabel labelLembrete = new JLabel("Lembrete:");
    private JLabel labelMotivo = new JLabel("Motivo:");
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private JButton buttonBuscaData = new JButton();
    private final JComboBox comboMotivo = new JComboBox();
    private final JComboBox comboLembrete = new JComboBox();
    private JTextArea observacoes = new JTextArea(new TTextAreaDocument(999));
    private TTextField textData = new TTextField(10, 4);
    private TTextField textHora = new TTextField(5, 6);
    private String codigoRequisicao;
    private String codigoFilial;
    private String codigoPaciente;
    private String nomePaciente;
    List<DetalhesMotivoContato> detalhesMotivoContato = new ArrayList<DetalhesMotivoContato>();
    private Boolean acaoSalvar = false;
    private Boolean manterTela = false;

    public static RegistroContato novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new RegistroContato((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new RegistroContato((Frame)pai);
        }
        return null;
    }

    public RegistroContato(Dialog pai) {
        super(pai, "Registro de Contato");
        this.montaTela();
        this.carregaMotivoContato();
        this.setLocationRelativeTo(pai);
    }

    public RegistroContato(Frame pai) {
        super(pai, "Registro de Contato");
        this.montaTela();
        this.carregaMotivoContato();
        this.setLocationRelativeTo(pai);
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public String getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public void setCodigoRequisicao(String codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
    }

    public String getCodigoPaciente() {
        return this.codigoPaciente;
    }

    public void setCodigoPaciente(String codigoPaciente) {
        this.codigoPaciente = codigoPaciente;
    }

    public Boolean getAcaoSalvar() {
        return this.acaoSalvar;
    }

    public String getNomePaciente() {
        return this.nomePaciente;
    }

    public void setNomePaciente(String nomePaciente) {
        this.nomePaciente = nomePaciente;
    }

    private void montaTela() {
        this.setSize(new Dimension(370, 495));
        this.buttonOK.setText("Salvar");
        GridBagConstraints c = new GridBagConstraints();
        Date data = new Date();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 15);
        c.fill = 0;
        c.anchor = 17;
        this.labelData.setLabelFor(this.textData);
        this.panelRegistro.add((Component)this.labelData, c);
        ++c.gridx;
        c.insets = new Insets(0, 15, 0, 0);
        c.anchor = 17;
        this.textData.setPreferredSize(new Dimension(100, 20));
        this.textData.setMinimumSize(new Dimension(100, 20));
        this.textData.setText(Funcoes.formataData(data));
        this.panelRegistro.add((Component)this.textData, c);
        c.insets = new Insets(0, 115, 0, 0);
        this.buttonBuscaData.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaData.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonBuscaData);
        this.buttonBuscaData.setFocusable(false);
        this.panelRegistro.add((Component)this.buttonBuscaData, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.labelHora.setLabelFor(this.textHora);
        this.panelRegistro.add((Component)this.labelHora, c);
        ++c.gridx;
        c.insets = new Insets(0, 15, 0, 0);
        this.textHora.setPreferredSize(new Dimension(70, 20));
        this.textHora.setMinimumSize(new Dimension(70, 20));
        this.textHora.setText(Funcoes.formataHora(data, false));
        this.panelRegistro.add((Component)this.textHora, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.panelRegistro.add((Component)this.labelMotivo, c);
        ++c.gridx;
        c.insets = new Insets(0, 15, 0, 0);
        c.fill = 2;
        this.comboMotivo.setPreferredSize(new Dimension(200, 20));
        this.comboMotivo.setMinimumSize(new Dimension(200, 20));
        this.panelRegistro.add((Component)this.comboMotivo, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.panelRegistro.add((Component)this.labelLembrete, c);
        ++c.gridx;
        c.insets = new Insets(0, 15, 0, 0);
        c.fill = 2;
        this.comboLembrete.setPreferredSize(new Dimension(200, 20));
        this.comboLembrete.setMinimumSize(new Dimension(200, 20));
        this.panelRegistro.add((Component)this.comboLembrete, c);
        this.comboLembrete.addItem("N\u00e3o lembrar");
        this.comboLembrete.addItem("10 minutos");
        this.comboLembrete.addItem("15 minutos");
        this.comboLembrete.addItem("20 minutos");
        this.comboLembrete.addItem("30 minutos");
        this.comboLembrete.addItem("60 minutos");
        this.comboLembrete.addItem("2 horas");
        this.comboLembrete.addItem("4 horas");
        this.comboLembrete.addItem("6 horas");
        this.comboLembrete.addItem("8 horas");
        this.comboLembrete.addItem("10 horas");
        this.comboLembrete.addItem("12 horas");
        this.comboLembrete.addItem("14 horas");
        this.comboLembrete.addItem("16 horas");
        this.comboLembrete.addItem("18 horas");
        this.comboLembrete.addItem("20 horas");
        this.comboLembrete.addItem("22 horas");
        this.comboLembrete.addItem("1 dia");
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.panelRegistro.add((Component)this.labelObservacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.observacoes.setPreferredSize(new Dimension(350, 310));
        this.observacoes.setMinimumSize(new Dimension(350, 300));
        this.observacoes.setLineWrap(true);
        this.observacoes.setWrapStyleWord(true);
        ScreenUtil.setBorda(new Component[]{this.observacoes}, new TitledBorder(""));
        this.panelRegistro.add((Component)this.observacoes, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 2;
        c.weightx = 3.0;
        c.insets = new Insets(0, 2, 0, 2);
        c.anchor = 13;
        this.panelBotoes.add((Component)this.buttonOK, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelBotoes.add((Component)this.buttonCancelar, c);
        this.panelBotoes.setPreferredSize(new Dimension(350, 40));
        this.buttonBuscaData.addActionListener(this);
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    RegistroContato.this.buttonBuscaData.doClick();
                }
            }
        });
        this.getContentPane().add((Component)this.panelRegistro, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistroContato.this.dispose();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RegistroContato.this.validaCampos()) {
                    RegistroContato.this.salvarRegistroContato();
                    RegistroContato.this.setVisible(RegistroContato.this.manterTela);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonBuscaData) {
            Funcoes.mostraData(this.textData, this.buttonBuscaData, (JPanel)this.getContentPane(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaMotivoContato() {
        StringBuilder bui = new StringBuilder();
        bui.append(" SELECT mct_codigo, mct_descricao, mct_exigeobservacao FROM motivocontato WHERE fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" ORDER BY mct_codigo ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                this.detalhesMotivoContato.add(new DetalhesMotivoContato(rs.getInt("mct_codigo"), rs.getString("mct_descricao"), rs.getBoolean("mct_exigeobservacao")));
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.detalhesMotivoContato.forEach(value -> this.comboMotivo.addItem(value.getDescricaoMotivoContato()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvarRegistroContato() {
        Optional<DetalhesMotivoContato> optional = this.detalhesMotivoContato.stream().filter(a -> a.getDescricaoMotivoContato().equalsIgnoreCase(this.comboMotivo.getSelectedItem().toString())).findAny();
        String sequencia = "";
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            sequencia = DBUtil.getSequencia(st, "historicoregistrocontato", this.getCodigoFilial());
            bui.append("insert into\thistoricoregistrocontato(");
            bui.append("fil_codigo, hrc_codigo, hrc_datahoracadastro, usr_codigo, req_codigo, pac_codigo, hrc_datacontato, hrc_horacontato, hrc_observacao, hrc_lembrete, mct_codigo, hrc_filial) values(");
            bui.append(this.getCodigoFilial()).append(", ");
            bui.append(sequencia).append(", '");
            bui.append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("', '");
            bui.append(Variaveis.login).append("', ");
            bui.append(this.getCodigoRequisicao()).append(", ");
            bui.append(this.getCodigoPaciente()).append(", '");
            bui.append(Funcoes.formataData("yyyy-MM-dd", this.textData.getData())).append("', '");
            bui.append(this.textHora.getText()).append("', ");
            bui.append(StringUtil.textoDBEscape(this.observacoes.getText())).append(" , '");
            bui.append(Tipos.getTipoLembrete(this.comboLembrete.getSelectedItem().toString())).append("', ");
            bui.append(optional.get().getCodigoMotivoContato());
            if (!ParametrosGerais.getTipoIntegracao().equals("M")) {
                bui.append(", 'F'");
            } else {
                bui.append(", 'N'");
            }
            bui.append(")");
            try {
                Conexao.executeUpdate(this.getCodigoFilial(), st2, bui.toString(), false);
                Conexao.arquivaSQL();
                this.acaoSalvar = true;
                this.manterTela = false;
                if (!Tipos.getTipoLembrete(this.comboLembrete.getSelectedItem().toString()).equals(Tipos.getTipoLembrete("N\u00e3o lembrar"))) {
                    this.criarLembrete();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
    }

    private boolean validaCampos() {
        Optional<DetalhesMotivoContato> optional = this.detalhesMotivoContato.stream().filter(a -> a.getDescricaoMotivoContato().equalsIgnoreCase(this.comboMotivo.getSelectedItem().toString())).findAny();
        if (this.comboMotivo.getItemCount() <= 0) {
            Funcoes.mensagem(this, "Motivo vazio", 3);
            return false;
        }
        Boolean motivoContatoExigeObservacao = optional.get().getExigeObservacao();
        if (motivoContatoExigeObservacao.booleanValue() && Funcoes.textoVazio(this.observacoes.getText())) {
            Funcoes.mensagem(this, "Para o Motivo selecionado \u00e9 obrigat\u00f3rio o preenchimento da Observa\u00e7\u00e3o", 3);
            return false;
        }
        Date data = this.textData.getData();
        if (data == null) {
            return false;
        }
        return Funcoes.verificaHora(this.textHora.getText());
    }

    private void criarLembrete() throws SQLException {
        String sequenciaCompromisso = this.getSequencia();
        if (Funcoes.textoVazio(sequenciaCompromisso)) {
            return;
        }
        String data = this.textData.getText() + " " + this.textHora.getText();
        UsuarioCompromissoBean usrCompromissoBean = new UsuarioCompromissoBean();
        UsuarioVO usuarioVo = new UsuarioVO();
        FilialVO filialVo = new FilialVO();
        filialVo.setCodigo(Integer.valueOf(this.getCodigoFilial()));
        usuarioVo.setFilial(filialVo);
        usuarioVo.setCodigo(Variaveis.login);
        usrCompromissoBean.setUsuario(usuarioVo);
        usrCompromissoBean.setCodigo(Integer.valueOf(sequenciaCompromisso));
        usrCompromissoBean.setDataHora(this.calculaDataLembrete(data));
        usrCompromissoBean.setDuracao(10);
        usrCompromissoBean.setTitulo("Ligar para paciente: " + this.getNomePaciente());
        String requisicao = this.getCodigoRequisicao() == null ? "" : "\nRequisi\u00e7\u00e3o: " + this.getCodigoRequisicao();
        usrCompromissoBean.setAssunto("Paciente: " + this.getNomePaciente() + requisicao + "\n" + this.observacoes.getText());
        usrCompromissoBean.setTempoLembrete(1);
        usrCompromissoBean.setLembrado(false);
        try {
            new UsuarioCompromissoService().insert(usrCompromissoBean, null, this.getCodigoFilial(), null);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            Conexao.anulaSQL();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSequencia() {
        Statement st = Conexao.getStatement();
        String sequenciaCompromisso = "";
        try {
            sequenciaCompromisso = UsuarioCompromissoDao.getSequenciaCompromisso(st, "usuariocompromisso");
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return sequenciaCompromisso;
    }

    private String calculaDataLembrete(String dataContato) {
        String dataCalculada = "";
        String tempoLembrete = Tipos.getTipoLembrete(this.comboLembrete.getSelectedItem().toString());
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(Funcoes.stringToDate("dd/MM/yyyy HH:mm", dataContato));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Integer valorHorasDataLembrete = this.calculaHorasDataLembrete();
        if (null == valorHorasDataLembrete) {
            gc.add(12, Integer.valueOf(tempoLembrete));
        } else {
            gc.add(10, valorHorasDataLembrete);
        }
        dataCalculada = gc.getTime().toString();
        return dataCalculada;
    }

    private Integer calculaHorasDataLembrete() {
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("2 horas")) {
            return 2;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("4 horas")) {
            return 4;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("6 horas")) {
            return 6;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("8 horas")) {
            return 8;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("10 horas")) {
            return 10;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("12 horas")) {
            return 12;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("14 horas")) {
            return 14;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("16 horas")) {
            return 16;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("18 horas")) {
            return 18;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("20 horas")) {
            return 20;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("22 horas")) {
            return 22;
        }
        if (this.comboLembrete.getSelectedItem().toString().equalsIgnoreCase("1 dia")) {
            return 24;
        }
        return null;
    }
}

