/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.SolicitarDataHoraAgendamento;
import jalis.laboratorio.recepcao.preagendamento.CadastrarPacientePreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.ExamesPreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.ImagensPreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.MotivoCancelamentoPreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.MotivoPreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.RequisicaoPreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.VisualizarRastreabilidadePreAgendamento;
import jalis.model.bean.cadastro.SalaAtendimentoBean;
import jalis.model.bean.recepcao.AgendamentoBean;
import jalis.model.bean.recepcao.AgendamentoExameRequisicaoBean;
import jalis.model.bean.recepcao.PreAgendamentoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.SalaAtendimentoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.SalaAtendimentoService;
import jalis.service.recepcao.AgendamentoService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.CheckItemFiltro;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TAvisoLabel;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class PreAgendamento
extends FrmPadrao
implements ActionListener,
ListSelectionListener {
    private static final Long ACESSO = Long.parseLong("0200400128");
    private static final Long ACESSO_ALTERAR = Long.parseLong("0200400129");
    private static final Long ACESSO_CANCELAR = Long.parseLong("0200400130");
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private TTextField textPaciente = new TTextField(80, 3);
    private JPopupMenu popUpRastreabilidade = null;
    private JButton buttonAgendar = ComponenteFactory.novoJButton("Agendar", 'A', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar pr\u00e9-agendamento", 'p', this);
    private JButton buttonAlterarDados = ComponenteFactory.novoJButton("Alterar dados", 'd', this);
    private JButton buttonImagens = ComponenteFactory.novoJButton("Imagens", 'I', this);
    private JButton buttonExames = ComponenteFactory.novoJButton("Exames", 'E', this);
    private JButton buttonRastreabilidade = ComponenteFactory.novoJButton("Rastreabilidade \u25bc", 'R', this);
    private JPopupMenu menuRastreabilidade = new JPopupMenu();
    private JMenuItem itemNovo = ComponenteFactory.novoJMenuItem(this.menuRastreabilidade, "Novo", (ActionListener)this);
    private JMenuItem itemVisualizar = ComponenteFactory.novoJMenuItem(this.menuRastreabilidade, "Visualizar", (ActionListener)this);
    private JLabel labelDataAgenda = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelHoraAgenda = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelUnidadeAgenda = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private TAvisoLabel tLabelNomePaciente = new TAvisoLabel();
    private JLabel labelEnderecoPaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelMedico = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelConvenio = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelAlterarDadosPaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private TAvisoLabel tLabelSexoPaciente = new TAvisoLabel();
    private JLabel labelCelularPaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelFonePaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelBairroPaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelCodigoPaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelCidadePaciente = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JLabel labelCancelamentoAgendamento = ComponenteFactory.novoJLabel("", new Dimension(100, 20));
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelDatas = new JPanel(new GridBagLayout());
    private JPanel panelPaciente = new JPanel(new GridBagLayout());
    private JPanel panelConsulta = new JPanel(new GridBagLayout());
    private Color foregroundAlterarDados = this.buttonAlterarDados.getForeground();
    private Timer chamaAtencao = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PreAgendamento.this.buttonAlterarDados.setForeground(PreAgendamento.this.buttonAlterarDados.getForeground() == PreAgendamento.this.foregroundAlterarDados ? Color.red : PreAgendamento.this.foregroundAlterarDados);
        }
    });
    private JComboBox comboSituacao = new JComboBox<String>(new String[]{Tipos.tipoSituacaoPreAgendamento("A"), Tipos.tipoSituacaoPreAgendamento("G"), Tipos.tipoSituacaoPreAgendamento("C")});
    private ModeloResultSet modelo;
    private JTable table;
    private CheckItemFiltro itemFilial;
    private RequisicaoPreAgendamento telaRequisicao;
    private SolicitarDataHoraAgendamento agenda;

    public PreAgendamento() {
        this.montaTela();
    }

    private void montaTela() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PreAgendamento.this.getParent() != null) {
                    PreAgendamento.this.getParent().removeAll();
                }
            }
        });
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Pr\u00e9-agendamento", "Listagem de pr\u00e9-agendamentos realizados pelo site", "recepcao/recep_pre_agendamento.jpg");
        this.add((Component)this.buildPanelBotoes(), "South");
        JPanel panelCentral = this.buildPanelCentral();
        this.add((Component)panelCentral, "Center");
        panelCentral.add((Component)this.buildPanelFiltros(), "North");
        panelCentral.add((Component)this.buildPanelListagem(), "Center");
        if (this.buttonAlterarDados.isVisible()) {
            this.chamaAtencao.start();
        } else {
            this.chamaAtencao.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAgendar) {
            this.agendar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.buttonDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.buttonDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonConsultar) {
            this.consultar();
        } else if (e.getSource() == this.buttonAlterarDados) {
            this.alterarDadosPaciente();
        } else if (e.getSource() == this.buttonImagens) {
            this.visualizarImagem();
        } else if (e.getSource() == this.buttonExames) {
            this.getExames();
        } else if (e.getSource() == this.itemNovo) {
            this.novaRastreabilidade();
        } else if (e.getSource() == this.itemVisualizar) {
            this.visualizarRastreabilidade();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelarPreAgendamento();
        } else if (e.getSource() == this.buttonRastreabilidade) {
            if (this.validaRastreabilidade()) {
                this.menuRastreabilidade.show(this.buttonRastreabilidade.getParent(), this.buttonRastreabilidade.getX(), this.buttonRastreabilidade.getY() + this.buttonRastreabilidade.getHeight());
            } else {
                this.novaRastreabilidade();
            }
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    public static long getModuloAcessoalterar() {
        return ACESSO_ALTERAR;
    }

    public static long getModuloAcessoCancelar() {
        return ACESSO_CANCELAR;
    }

    private void visualizarImagem() {
        Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
        this.apresentarImagem(r.getInt("fil_codigo"), r.getInt("pre_codigo"));
    }

    private void getExames() {
        ExamesPreAgendamento exames = new ExamesPreAgendamento(Laboratorio.getInstancia());
        Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
        exames.setFilial(r.getInt("fil_codigo"));
        exames.setPreAgendamento(r.getInt("pre_codigo"));
        exames.buscaExames();
    }

    private void alterarDadosPaciente() {
        if (this.table.getSelectedRow() > -1) {
            Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
            CadastrarPacientePreAgendamento cadastro = new CadastrarPacientePreAgendamento((Frame)Laboratorio.getInstancia(), r.getString("pre_codigofilialpaciente"), r.getString("pre_codigopaciente"), r);
            if (cadastro != null) {
                cadastro.setVisible(true);
            }
        }
    }

    private void cancelarPreAgendamento() {
        if (this.table.getSelectedRow() > -1) {
            Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
            MotivoCancelamentoPreAgendamento motivo = new MotivoCancelamentoPreAgendamento(Laboratorio.getInstancia());
            motivo.setVisible(true);
            if (motivo.getOK()) {
                this.atualizarMotivoCancelamento(r, motivo.getDescricaoMotivo());
                this.atualizarInformacoes(r);
                this.consultar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validaRastreabilidade() {
        boolean retorno = false;
        Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
        StringBuilder bui = new StringBuilder();
        bui.append(" SELECT * ");
        bui.append(" FROM preagendamentoevento ");
        bui.append(" WHERE fil_codigo = ").append(r.getInt("fil_codigo"));
        bui.append(" AND pre_codigo = ").append(r.getInt("pre_codigo"));
        bui.append(" AND (pee_tipo = '").append("P").append("'");
        bui.append(" OR pee_tipo = '").append("C").append("')");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                retorno = true;
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void visualizarRastreabilidade() {
        VisualizarRastreabilidadePreAgendamento visualizar = new VisualizarRastreabilidadePreAgendamento(Laboratorio.getInstancia());
        Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
        visualizar.setFilial(r.getInt("fil_codigo"));
        visualizar.setCodigo(r.getInt("pre_codigo"));
        visualizar.buscaRastreabilidade();
    }

    private void novaRastreabilidade() {
        MotivoPreAgendamento motivo = new MotivoPreAgendamento(Laboratorio.getInstancia());
        Registro r = this.modelo.getRegistro(this.table.getSelectedRow());
        motivo.setVisible(true);
        if (motivo.getOK()) {
            this.atualizarMotivoPreAgendamento(r, motivo.getDescricaoMotivo());
            this.atualizarInformacoes(r);
        }
    }

    private void atualizarMotivoPreAgendamento(Registro r, String motivo) {
        Statement st = Conexao.getStatement();
        int filial = r.getInt("fil_codigo");
        int codigo = r.getInt("pre_codigo");
        try {
            String sequence = DBUtil.getSequencia(st, "preagendamentoevento", r.getString("fil_codigo"));
            StringBuilder sql = new StringBuilder(" INSERT INTO preagendamentoevento ");
            sql.append(" (fil_codigo, pre_codigo, pee_codigo, pee_tipo, pee_datahora, pee_motivo, usr_codigo) VALUES ");
            sql.append(" (").append(filial).append(", ");
            sql.append(codigo).append(", ");
            sql.append(sequence).append(", ");
            sql.append("'").append("P").append("', ");
            sql.append("current_timestamp").append(", ");
            sql.append("'").append(motivo).append("', ");
            sql.append("'").append(Variaveis.login).append("') ");
            Conexao.executeUpdate(String.valueOf(filial), st, sql);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "Erro ao atualizar o motivo de pr\u00e9-agendamento " + e.getMessage(), e.getStackTrace());
        }
    }

    private void atualizarMotivoCancelamento(Registro r, String motivo) {
        Statement st = Conexao.getStatement();
        int filial = r.getInt("fil_codigo");
        int codigo = r.getInt("pre_codigo");
        try {
            StringBuilder sql = new StringBuilder("UPDATE preagendamento SET pre_situacao = '").append("C").append("',");
            sql.append(" pre_datacancelamento = current_timestamp, usr_codcancelamento = '").append(Variaveis.login).append("', ");
            sql.append(" pre_motivosituacao = ").append(StringUtil.textoDBEscape(motivo));
            sql.append(" WHERE fil_codigo = ").append(filial);
            sql.append(" AND pre_codigo = ").append(codigo);
            Conexao.executeUpdate(String.valueOf(filial), st, sql);
            Conexao.arquivaSQL();
            r.setValor("pre_situacao", "C");
            r.setValor("pre_motivosituacao", motivo);
            r.setValor("pre_datacancelamento", new Date());
            r.setValor("usr_codcancelamento", Variaveis.login);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "Erro ao atualizar o motivo de cancelamento do pr\u00e9-agendamento", e.getStackTrace());
        }
    }

    private JPanel buildPanelCentral() {
        JPanel panel = new JPanel(new BorderLayout());
        return panel;
    }

    private JPanel buildPanelListagem() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.buildJTable()), "Center");
        panel.add((Component)this.buildPanelDados(), "South");
        return panel;
    }

    private JPanel buildPanelDados() {
        ScreenUtil.setBorda(new Component[]{this.tLabelNomePaciente, this.labelEnderecoPaciente, this.labelMedico, this.labelCidadePaciente, this.labelConvenio, this.tLabelSexoPaciente, this.labelCelularPaciente, this.labelDataAgenda, this.labelFonePaciente, this.labelBairroPaciente, this.labelCodigoPaciente, this.labelHoraAgenda, this.labelUnidadeAgenda}, BorderFactory.createTitledBorder(""));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Informa\u00e7\u00f5es"));
        this.labelAlterarDadosPaciente.setForeground(Color.decode("#FFAA00"));
        this.labelAlterarDadosPaciente.setHorizontalAlignment(4);
        this.labelAlterarDadosPaciente.setFont(this.labelAlterarDadosPaciente.getFont().deriveFont(1));
        this.labelCancelamentoAgendamento.setForeground(Color.decode("#FFAA00"));
        this.labelCancelamentoAgendamento.setHorizontalAlignment(0);
        this.labelCancelamentoAgendamento.setFont(this.labelCancelamentoAgendamento.getFont().deriveFont(1));
        this.labelDataAgenda.setFont(this.labelDataAgenda.getFont().deriveFont(1));
        this.labelHoraAgenda.setFont(this.labelHoraAgenda.getFont().deriveFont(1));
        this.labelUnidadeAgenda.setFont(this.labelUnidadeAgenda.getFont().deriveFont(1));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)new JLabel("Data:"), c);
        c.gridx = 1;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)this.labelDataAgenda, c);
        c.gridx = 2;
        c.insets = new Insets(0, 100, 0, 0);
        panel.add((Component)new JLabel("Hor\u00e1rio:"), c);
        c.insets = new Insets(0, 150, 0, 0);
        panel.add((Component)this.labelHoraAgenda, c);
        c.gridx = 3;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)new JLabel("Local:"), c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.insets = new Insets(0, 100, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelUnidadeAgenda, c);
        c.gridy = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)new JLabel("Nome:"), c);
        c.gridx = 1;
        c.fill = 2;
        c.insets = new Insets(0, 40, 0, 0);
        this.tLabelNomePaciente.setPreferredSize(new Dimension(100, 20));
        this.tLabelNomePaciente.setMinimumSize(new Dimension(100, 20));
        c.gridwidth = 2;
        panel.add((Component)this.tLabelNomePaciente, c);
        c.gridx = 3;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)new JLabel("C\u00f3digo:"), c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.insets = new Insets(0, 100, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelCodigoPaciente, c);
        c.gridy = 2;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)new JLabel("Endere\u00e7o:"), c);
        c.gridx = 1;
        c.fill = 2;
        c.insets = new Insets(0, 40, 0, 0);
        c.gridwidth = 2;
        panel.add((Component)this.labelEnderecoPaciente, c);
        c.gridx = 3;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)new JLabel("Bairro:"), c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.insets = new Insets(0, 100, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelBairroPaciente, c);
        c.gridy = 3;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)new JLabel("Cidade:"), c);
        c.gridx = 1;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)this.labelCidadePaciente, c);
        c.gridx = 2;
        c.insets = new Insets(0, 100, 0, 0);
        panel.add((Component)new JLabel("Fone:"), c);
        c.insets = new Insets(0, 150, 0, 0);
        panel.add((Component)this.labelFonePaciente, c);
        c.gridx = 3;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)new JLabel("Celular:"), c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.insets = new Insets(0, 100, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelCelularPaciente, c);
        c.gridy = 4;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)new JLabel("Sexo:"), c);
        c.gridx = 1;
        c.insets = new Insets(0, 40, 0, 0);
        this.tLabelSexoPaciente.setPreferredSize(new Dimension(100, 20));
        this.tLabelSexoPaciente.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.tLabelSexoPaciente, c);
        c.gridy = 5;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)new JLabel("M\u00e9dico:"), c);
        c.gridx = 1;
        c.fill = 2;
        c.insets = new Insets(0, 40, 0, 0);
        c.gridwidth = 2;
        panel.add((Component)this.labelMedico, c);
        c.gridx = 3;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)new JLabel("Conv\u00eanio:"), c);
        c.gridx = 3;
        c.gridwidth = 2;
        c.insets = new Insets(0, 100, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelConvenio, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 9;
        c.fill = 2;
        panel.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonRastreabilidade, this.buttonAlterarDados, this.buttonAgendar, this.buttonCancelar, this.buttonImagens, this.buttonExames), c);
        this.menuRastreabilidade.add(this.itemNovo);
        this.menuRastreabilidade.add(this.itemVisualizar);
        this.chamaAtencao.setInitialDelay(500);
        this.labelCancelamentoAgendamento.setVisible(false);
        this.buttonAlterarDados.setVisible(false);
        this.buttonRastreabilidade.setVisible(false);
        this.buttonCancelar.setVisible(false);
        this.buttonCancelar.setEnabled(false);
        this.buttonExames.setEnabled(false);
        this.buttonImagens.setEnabled(false);
        this.controlaBotoes();
        return panel;
    }

    private JPanel buildPanelBotoes() {
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(this.buttonNovo);
        panel.add(this.buttonFechar);
        return panel;
    }

    private JPanel buildPanelFiltros() {
        this.panelFiltros.setBorder(new TitledBorder("Filtro"));
        this.panelFiltros.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 17;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(1, 0, 0, 1);
        GridBagConstraints constraintsDatas = new GridBagConstraints();
        constraintsDatas.fill = 17;
        constraintsDatas.anchor = 17;
        constraintsDatas.gridx = 0;
        constraintsDatas.gridy = 0;
        constraintsDatas.weightx = 0.0;
        constraintsDatas.weighty = 0.0;
        constraintsDatas.insets = new Insets(1, 0, 0, 1);
        GridBagConstraints constraintsUser = new GridBagConstraints();
        constraintsUser.fill = 17;
        constraintsUser.anchor = 17;
        constraintsUser.gridx = 0;
        constraintsUser.gridy = 0;
        constraintsUser.weightx = 0.0;
        constraintsUser.weighty = 0.0;
        constraintsUser.insets = new Insets(1, 0, 0, 1);
        GridBagConstraints constraintsConsulta = new GridBagConstraints();
        constraintsConsulta.gridx = 0;
        constraintsConsulta.gridy = 0;
        constraintsConsulta.weightx = 0.0;
        constraintsConsulta.weighty = 0.0;
        constraintsConsulta.insets = new Insets(1, 0, 1, 1);
        this.itemFilial = this.getFiltroFilial();
        this.panelDatas.add((Component)this.itemFilial, constraintsDatas);
        ++constraintsDatas.gridx;
        constraintsDatas.insets = new Insets(0, 20, 0, 0);
        this.panelDatas.add((Component)new JLabel("Data inicial:"), constraintsDatas);
        constraintsDatas.insets = new Insets(0, 1, 0, 0);
        ++constraintsDatas.gridx;
        this.textDataInicial.setPreferredSize(new Dimension(100, 20));
        this.textDataInicial.setMinimumSize(new Dimension(100, 20));
        this.panelDatas.add((Component)this.textDataInicial, constraintsDatas);
        ++constraintsDatas.gridx;
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PreAgendamento.this.buttonDataInicial.doClick();
                }
            }
        });
        this.panelDatas.add((Component)this.buttonDataInicial, constraintsDatas);
        ++constraintsDatas.gridx;
        constraintsDatas.insets = new Insets(0, 20, 0, 0);
        this.panelDatas.add((Component)new JLabel("Data final:"), constraintsDatas);
        constraintsDatas.insets = new Insets(0, 1, 0, 0);
        ++constraintsDatas.gridx;
        this.textDataFinal.setPreferredSize(new Dimension(100, 20));
        this.textDataFinal.setMinimumSize(new Dimension(100, 20));
        this.panelDatas.add((Component)this.textDataFinal, constraintsDatas);
        ++constraintsDatas.gridx;
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PreAgendamento.this.buttonDataFinal.doClick();
                }
            }
        });
        this.panelDatas.add((Component)this.buttonDataFinal, constraintsDatas);
        ++constraintsDatas.gridx;
        constraintsDatas.insets = new Insets(0, 20, 0, 0);
        this.panelDatas.add((Component)new JLabel("Situa\u00e7\u00e3o:"), constraintsDatas);
        constraintsDatas.insets = new Insets(0, 1, 0, 0);
        ++constraintsDatas.gridx;
        constraintsDatas.insets = new Insets(0, 10, 0, 0);
        this.panelDatas.add((Component)this.comboSituacao, constraintsDatas);
        constraintsUser.gridx = 0;
        this.panelPaciente.add((Component)new JLabel("Paciente:"), constraintsUser);
        ++constraintsUser.gridx;
        this.textPaciente.setPreferredSize(new Dimension(635, 20));
        this.textPaciente.setMinimumSize(new Dimension(635, 20));
        this.panelPaciente.add((Component)this.textPaciente, constraintsUser);
        constraintsConsulta.weightx = 1.0;
        constraintsConsulta.fill = 2;
        this.panelConsulta.add((Component)new JLabel(), constraintsConsulta);
        constraintsConsulta.weightx = 0.0;
        constraintsConsulta.fill = 0;
        ++constraintsConsulta.gridx;
        this.buttonConsultar.setPreferredSize(new Dimension(95, 25));
        this.buttonConsultar.setMinimumSize(new Dimension(95, 25));
        this.panelConsulta.add((Component)this.buttonConsultar, constraintsConsulta);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.fill = 17;
        this.panelFiltros.add((Component)this.panelDatas, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.fill = 17;
        this.panelFiltros.add((Component)this.panelPaciente, constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.panelFiltros.add((Component)this.panelConsulta, constraints);
        return this.panelFiltros;
    }

    private JTable buildJTable() {
        this.modelo = new ModeloResultSet(new String[]{"Filial", "fil_codigo", "Data/hora", "pre_datahora", "Previs\u00e3o", "pre_dataprevista", "Hor\u00e1rio", "pre_horarioprevisto", "Paciente", "pre_nomepaciente"}){

            @Override
            public Object getValueAt(int row, int col) {
                Registro reg = this.getRegistro(row);
                if (reg != null) {
                    if (reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                        try {
                            return Funcoes.formataData("dd/MM/yyyy HH:mm", reg.getDate(this.cols[col * 2 + 1]));
                        }
                        catch (Exception e) {
                            return reg.getValor(this.cols[col * 2 + 1]);
                        }
                    }
                    if (reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01])")) {
                        try {
                            return Funcoes.formataData("dd/MM/yyyy", reg.getDate(this.cols[col * 2 + 1]));
                        }
                        catch (Exception e) {
                            return reg.getValor(this.cols[col * 2 + 1]);
                        }
                    }
                    return super.getValueAt(row, col);
                }
                return null;
            }
        };
        this.table = ComponenteFactory.novoJTable((TableModel)this.modelo, (ListSelectionListener)this, 50, 150, 100, 80, 0);
        return this.table;
    }

    private CheckItemFiltro getFiltroFilial() {
        CheckItemFiltro item = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", null);
        item.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        item.setColunaHint(1);
        return item;
    }

    private void controlaBotoes() {
        this.buttonAgendar.setEnabled(this.table.getSelectedRow() >= 0);
        this.buttonImagens.setEnabled(this.table.getSelectedRow() >= 0);
        this.buttonExames.setEnabled(this.table.getSelectedRow() >= 0);
        this.buttonRastreabilidade.setEnabled(this.table.getSelectedRow() >= 0);
        this.buttonAlterarDados.setEnabled(this.table.getSelectedRow() >= 0);
        this.buttonCancelar.setEnabled(this.table.getSelectedRow() >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultar() {
        String situacao;
        this.modelo.limpar(true);
        this.controlaBotoes();
        String[] filtroFiliais = new String[]{Variaveis.filialPadrao};
        if (this.temFilialSelecionada()) {
            filtroFiliais = this.itemFilial.getSelecionados();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT a.fil_codigo, a.pre_bairropaciente, a.pre_cidadepaciente, a.pre_estadopaciente, a.pre_fonepaciente, a.pre_celularpaciente, a.pre_sexopaciente, a.pre_situacao, ");
        buf.append("( select pac_nomesocial from paciente p where fil_codigo = a.fil_codigo and pac_codigo = a.pre_codigopaciente) as nomesocialpaciente,");
        buf.append("( select coalesce(pac_genero, 0) from paciente p where fil_codigo = a.fil_codigo and pac_codigo = a.pre_codigopaciente) as generopaciente,");
        buf.append("a.pre_dataprevista, a.pre_horarioprevisto, a.pre_unidadeselecionada, a.pre_convenio, a.pre_medico, a.pre_datahora, a.pre_enderecopaciente, a.pre_numeroenderecopaciente, ");
        buf.append("a.pre_convenionaoinformado, a.pre_mediconaoinformado, a.pre_tipoexamesinformados, a.pre_descritivoexames, a.pre_motivosituacao, a.pre_datahoraagendou, ");
        buf.append("a.usr_codagendou, a.pre_codigofilialpaciente, a.pre_nomepaciente, a.pre_codigopaciente, a.pre_alterardadospaciente, a.pre_codigo, a.pre_datacancelamento, a.usr_codcancelamento,  ");
        buf.append("(SELECT array_to_string(array_agg(exames.exa_descricao), ';;') FROM preagendamentoexame JOIN exames ON preagendamentoexame.fil_codigo = exames.fil_codigo and preagendamentoexame.exa_codigo = exames.exa_codigo  ");
        buf.append("        WHERE preagendamentoexame.fil_codigo = a.fil_codigo AND preagendamentoexame.pre_codigo = a.pre_codigo) AS exames ");
        buf.append(" FROM preagendamento a ");
        buf.append(" WHERE a.fil_codigo in (");
        for (int i = 0; i < filtroFiliais.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(filtroFiliais[i]);
        }
        buf.append(") ");
        if (Funcoes.verificaData(this.textDataInicial.getText())) {
            buf.append(" AND cast(a.pre_datahora AS date) >= ").append(StringUtil.textoDBEscape(Funcoes.formataData("MM/dd/yyyy", this.textDataInicial.getText())));
        }
        if (Funcoes.verificaData(this.textDataFinal.getText())) {
            buf.append(" AND cast(a.pre_datahora AS date) <= ").append(StringUtil.textoDBEscape(Funcoes.formataData("MM/dd/yyyy", this.textDataFinal.getText())));
        }
        if (!Funcoes.textoVazio(situacao = Tipos.tipoSituacaoPreAgendamentoPorDescricao(this.comboSituacao.getSelectedItem().toString()))) {
            buf.append(" AND a.pre_situacao = '").append(situacao).append("' ");
        }
        if (!Funcoes.textoVazio(this.textPaciente.getText())) {
            buf.append(" AND lower(a.pre_nomepaciente) like lower('%").append(this.textPaciente.getText()).append("%') ");
        }
        buf.append(" ORDER BY a.fil_codigo, a.pre_datahora ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                this.modelo.carregarDeResultSet(rs);
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean temFilialSelecionada() {
        return this.itemFilial.isSelected() && this.itemFilial.getSelecionados() != null && this.itemFilial.getSelecionados().length > 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg;
        if (this.table != null && this.table.getSelectedRow() >= 0 && (reg = this.modelo.getRegistro(this.table.getSelectedRow())) != null) {
            this.atualizarInformacoes(reg);
        }
    }

    private void atualizarInformacoes(Registro reg) {
        this.limparInformacoes();
        if (reg != null) {
            Date d;
            try {
                this.labelDataAgenda.setText(Funcoes.formataData("dd/MM/yyyy", reg.getDate("pre_dataprevista")));
            }
            catch (Exception e) {
                this.labelDataAgenda.setText("-");
            }
            String endereco = reg.getString("pre_enderecopaciente").isEmpty() ? "N\u00e3o informado" : reg.getString("pre_enderecopaciente") + ", " + reg.getString("pre_numeroenderecopaciente");
            this.labelHoraAgenda.setText(reg.getString("pre_horarioprevisto"));
            this.labelUnidadeAgenda.setText(reg.getString("pre_unidadeselecionada"));
            this.tLabelNomePaciente.setText(reg.getString("pre_nomepaciente"));
            this.tLabelNomePaciente.setNomeSocial(reg.getString("nomesocialpaciente"));
            this.labelCodigoPaciente.setText(reg.getString("pre_codigofilialpaciente") + "." + reg.getString("pre_codigopaciente"));
            this.labelEnderecoPaciente.setText(endereco);
            this.labelBairroPaciente.setText(reg.getString("pre_bairropaciente"));
            this.labelCidadePaciente.setText(reg.getString("pre_cidadepaciente") + " (" + reg.getString("pre_estadopaciente") + ")");
            this.tLabelSexoPaciente.setText(Tipos.tipoSexo(reg.getString("pre_sexopaciente")));
            this.tLabelSexoPaciente.setGenero(reg.getString("generopaciente"));
            this.labelCelularPaciente.setText(reg.getString("pre_celularpaciente"));
            this.labelFonePaciente.setText(reg.getString("pre_fonepaciente"));
            if (reg.getBoolean("pre_convenionaoinformado")) {
                this.labelConvenio.setText("N\u00e3o informado");
            } else {
                this.labelConvenio.setText(reg.getString("pre_convenio"));
            }
            if (reg.getBoolean("pre_mediconaoinformado")) {
                this.labelMedico.setText("N\u00e3o informado");
            } else {
                this.labelMedico.setText(reg.getString("pre_medico"));
            }
            boolean cancelado = reg.getString("pre_situacao").equals("C");
            boolean agendado = reg.getString("pre_situacao").equals("G");
            if (cancelado) {
                d = new Date();
                try {
                    d = reg.getDate("pre_datacancelamento");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.labelCancelamentoAgendamento.setText("Cancelado em " + Funcoes.formataData("dd/MM/yyyy kk:mm", d) + " por " + reg.getString("usr_codcancelamento"));
                this.labelCancelamentoAgendamento.setToolTipText("<html>Motivo de cancelamento:<br>" + reg.getString("pre_motivosituacao") + "</html>");
            }
            if (agendado) {
                d = new Date();
                try {
                    d = reg.getDate("pre_datahoragendou");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.labelCancelamentoAgendamento.setText("Agendado em " + Funcoes.formataData("dd/MM/yyyy kk:mm", d) + " por " + reg.getString("usr_codagendou"));
            }
            this.controlaBotoes();
            this.labelAlterarDadosPaciente.setVisible(reg.getBoolean("pre_alterardadospaciente"));
            this.labelCancelamentoAgendamento.setVisible(cancelado || agendado);
            this.buttonAlterarDados.setVisible(Acesso.getAcesso(ACESSO_ALTERAR) && this.labelAlterarDadosPaciente.isVisible() && !cancelado && !agendado);
            this.buttonAgendar.setVisible(!cancelado && !agendado);
            this.buttonCancelar.setVisible(Acesso.getAcesso(ACESSO_CANCELAR) && !cancelado && !agendado);
            this.buttonCancelar.setEnabled(!cancelado && !agendado);
            this.buttonImagens.setVisible(!cancelado && !agendado);
            this.buttonImagens.setEnabled(!cancelado && !agendado);
            this.buttonExames.setVisible(!cancelado && !agendado);
            this.buttonExames.setEnabled(!cancelado && !agendado);
            this.buttonRastreabilidade.setVisible(!cancelado && !agendado);
        }
    }

    private void limparInformacoes() {
        this.labelDataAgenda.setText("");
        this.labelHoraAgenda.setText("");
        this.labelUnidadeAgenda.setText("");
        this.tLabelNomePaciente.setText("");
        this.tLabelNomePaciente.setNomeSocial(null);
        this.labelCodigoPaciente.setText("");
        this.labelEnderecoPaciente.setText("");
        this.labelBairroPaciente.setText("");
        this.labelCidadePaciente.setText("");
        this.tLabelSexoPaciente.setText("");
        this.tLabelSexoPaciente.setGenero(null);
        this.labelCelularPaciente.setText("");
        this.labelFonePaciente.setText("");
        this.labelConvenio.setText("");
        this.labelMedico.setText("");
        this.labelAlterarDadosPaciente.setVisible(false);
        this.labelCancelamentoAgendamento.setVisible(false);
        this.labelCancelamentoAgendamento.setToolTipText("");
    }

    private PreAgendamentoBean registroToBean(Registro r) {
        PreAgendamentoBean bean = new PreAgendamentoBean();
        if (r == null) {
            return null;
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(r.getInt("fil_codigo"));
        UsuarioVO usuarioCancelamento = null;
        if (!Funcoes.textoVazio(r.getString("usr_codcancelamento"))) {
            usuarioCancelamento = new UsuarioVO();
            usuarioCancelamento.setCodigo(r.getString("usr_codcancelamento"));
        }
        bean.setAlterarDadosPaciente(r.getBoolean("pre_alterardadospaciente"));
        bean.setBairroPaciente(r.getString("pre_bairropaciente"));
        bean.setCelularPaciente(r.getString("pre_celularpaciente"));
        bean.setCidadePaciente(r.getString("pre_cidadepaciente"));
        bean.setCodigo(r.getInt("pre_codigo"));
        bean.setCodigoFilialPaciente(r.getInt("pre_codigofilialpaciente"));
        bean.setCodigoPaciente(r.getInt("pre_codigopaciente"));
        bean.setConvenio(r.getString("pre_convenio"));
        bean.setConvenioNaoInformado(r.getBoolean("pre_convenionaoinformado"));
        bean.setDescritivoExames(r.getString("pre_descritivoexames"));
        bean.setEnderecoPaciente(r.getString("pre_enderecopaciente"));
        bean.setEstadoPaciente(r.getString("pre_estadopaciente"));
        bean.setFilial(filial);
        bean.setFonePaciente(r.getString("pre_fonepaciente"));
        bean.setHorarioPrevisto(r.getString("pre_horarioprevisto"));
        bean.setMedico(r.getString("pre_medico"));
        bean.setMedicoNaoInformado(r.getBoolean("pre_mediconaoinformado"));
        bean.setMotivoSituacao(r.getString("pre_motivosituacao"));
        bean.setNomePaciente(r.getString("pre_nomepaciente"));
        bean.setNumeroEnderecoPaciente(r.getString("pre_numeroenderecopaciente"));
        bean.setSexoPaciente(r.getString("pac_sexo"));
        bean.setSituacao(r.getString("pre_situacao"));
        bean.setTipoExamesInformados(r.getString("pre_tipoexamesinformados"));
        bean.setUnidade(r.getString("pre_unidadeselecionada"));
        bean.setUsuarioCancelamento(usuarioCancelamento);
        try {
            bean.setDataPrevista(r.getDate("pre_dataprevista"));
            bean.setDataHora(r.getDate("pre_datahora"));
            bean.setDataHoraAgendou(r.getDate("pre_dataagendou"));
            bean.setDataCancelamento(r.getDate("pre_datacancelamento"));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do pr\u00e9-agendamento", e.getStackTrace());
        }
        return bean;
    }

    private SalaAtendimentoBean salaAtendimento() {
        try {
            ArrayList salas = new ArrayList(new SalaAtendimentoService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and sal_inativa = false order by sal_descricao limit 1"));
            if (salas != null && !salas.isEmpty()) {
                return (SalaAtendimentoBean)salas.get(0);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Erro ao buscar salas de atendimento." + e.getMessage(), e.getStackTrace());
        }
        return new SalaAtendimentoBean();
    }

    private JList buildListagemExames(String exames) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        JList list = new JList(listModel);
        if (!Funcoes.textoVazio(exames)) {
            String[] exms;
            for (String o : exms = exames.split(";;")) {
                listModel.addElement(o.toString());
            }
        }
        return list;
    }

    private void apresentarImagem(int filial, int codigo) {
        ImagensPreAgendamento imgs = new ImagensPreAgendamento((Frame)Laboratorio.getInstancia(), "Visualizar imagem");
        if (imgs.setPreAgendamento(filial, codigo)) {
            imgs.setLocationRelativeTo(this);
            imgs.setVisible(true);
        }
    }

    private void agendar() {
        Registro reg;
        if (this.table.getSelectedRow() > -1 && (reg = this.modelo.getRegistro(this.table.getSelectedRow())) != null) {
            String data;
            this.agenda = new SolicitarDataHoraAgendamento(this.salaAtendimento(), false, true, new Date(), true);
            try {
                data = Funcoes.formataData("dd/MM/yyyy", reg.getDate("pre_dataprevista"));
            }
            catch (Exception e) {
                data = "-";
            }
            String horario = reg.getString("pre_horarioprevisto");
            String unidade = reg.getString("pre_unidadeselecionada");
            this.agenda.setDadosPreAgendamento(data, horario, unidade);
            this.agenda.setVisible(true);
            if (this.agenda.isOk()) {
                GlassPaneMensagem glassPaneMensagemReq = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
                this.telaRequisicao = new RequisicaoPreAgendamento(Laboratorio.getInstancia(), false, "A", this.agenda.getDataHora(), reg, glassPaneMensagemReq);
                this.telaRequisicao.setVisible(true);
                if (this.telaRequisicao.requisicao.isRequisicaoSalva()) {
                    this.telaRequisicao.getDialogoZoom().salvarImagens(this.telaRequisicao.getImagens());
                    this.validaPreAgendamento(reg.getInt("fil_codigo"), reg.getInt("pre_codigo"));
                }
                Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagemReq);
            }
        }
    }

    private void novo() {
        this.limparInformacoes();
        this.itemFilial.clear();
        this.itemFilial.setSelected(false);
        this.textDataFinal.clear();
        this.textDataInicial.clear();
        this.modelo.limpar(true);
    }

    private void validaPreAgendamento(int codFilial, int codPreAgendamento) {
        StringBuilder sql = new StringBuilder();
        sql.append("update preagendamento set pre_situacao = '").append("G");
        sql.append("' where fil_codigo = ").append(codFilial).append(" and pre_codigo = ").append(codPreAgendamento);
        try {
            Statement st = Conexao.getStatement();
            Conexao.executeUpdate(String.valueOf(codFilial), st, sql.toString(), false);
            st.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.criaAgendamento();
        this.consultar();
    }

    private void criaAgendamento() {
        RequisicaoVO requisicao = null;
        if (this.telaRequisicao.requisicao != null && this.telaRequisicao.requisicao.getRetornoParaPesquisa() != null && !Funcoes.textoVazio(this.telaRequisicao.requisicao.getRetornoParaPesquisa())) {
            HashMap<String, Object> chave = new HashMap<String, Object>();
            chave.put("fil_codigo", Integer.parseInt(Variaveis.filialPadrao));
            chave.put("req_codigo", Integer.parseInt(this.telaRequisicao.requisicao.getRetornoParaPesquisa()));
            try {
                Conexao.setSessaoConexao(true);
                requisicao = (RequisicaoVO)new RequisicaoService().getVO(chave);
            }
            catch (ThreadDaoException e2) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da requisi\u00e7\u00e3o.\n" + e2.getMessage(), e2.getStackTrace());
            }
            if (this.agenda.isOk()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                SalaAtendimentoVO sala = (SalaAtendimentoVO)this.agenda.getSalaAtendimento().toVO();
                UsuarioVO usuario = new UsuarioVO();
                usuario.setFilial(filial);
                usuario.setCodigo(Variaveis.login);
                AgendamentoBean agendamento = new AgendamentoBean();
                agendamento.setDataHora(new Date());
                agendamento.setDataHoraAgendamento(this.agenda.getDataHora());
                agendamento.setFilial(filial);
                agendamento.setObservacao(this.agenda.getObservacao());
                agendamento.setRequisicao(requisicao);
                agendamento.setSalaAtendimento(sala);
                agendamento.setSituacao("A");
                agendamento.setUsuario(usuario);
                agendamento.setBloqueado(false);
                agendamento.setHorarioAberto(false);
                try {
                    this.salvaAgendamentoExameRequisicao(new RequisicaoService(), requisicao, filial, agendamento);
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar agendamento.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    private void salvaAgendamentoExameRequisicao(RequisicaoService requisicaoService, RequisicaoVO requisicao, FilialVO filial, AgendamentoBean agendamento) throws Exception, SQLException {
        AgendamentoExameRequisicaoBean agendamentoExameRequisicaoBean;
        ExameRequisicaoVO exameRequisicaoVO;
        int i;
        Integer[] mult = requisicao.getRequisicoesMultiguia();
        new AgendamentoService().gravaAutoCopiaSemCommit(agendamento, 0, Variaveis.filialPadrao, null);
        ArrayList<AgendamentoExameRequisicaoBean> agendamentoExameRequisicao = new ArrayList<AgendamentoExameRequisicaoBean>();
        for (i = 0; i < requisicao.getExames().size(); ++i) {
            exameRequisicaoVO = requisicao.getExames().get(i);
            agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
            agendamentoExameRequisicaoBean.setFilial(filial);
            agendamentoExameRequisicaoBean.setCodigo(agendamento.getCodigo());
            agendamentoExameRequisicaoBean.setRequisicao(requisicao.getCodigo());
            agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
            agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
            agendamentoExameRequisicao.add(agendamentoExameRequisicaoBean);
            new AgendamentoService().insertAgendamentoExame(agendamentoExameRequisicaoBean, agendamento.getCodigo(), Variaveis.filialPadrao, null);
        }
        if (mult != null) {
            for (i = 0; i < requisicao.getExamesMultiguia().size(); ++i) {
                exameRequisicaoVO = requisicao.getExamesMultiguia().get(i);
                agendamentoExameRequisicaoBean = new AgendamentoExameRequisicaoBean();
                agendamentoExameRequisicaoBean.setFilial(filial);
                agendamentoExameRequisicaoBean.setCodigo(agendamento.getCodigo());
                agendamentoExameRequisicaoBean.setRequisicao(exameRequisicaoVO.getRequisicao());
                agendamentoExameRequisicaoBean.setExame(exameRequisicaoVO.getExame().getCodigo());
                agendamentoExameRequisicaoBean.setMaterial(exameRequisicaoVO.getMaterial().getCodigo());
                agendamentoExameRequisicao.add(agendamentoExameRequisicaoBean);
                new AgendamentoService().insertAgendamentoExame(agendamentoExameRequisicaoBean, agendamento.getCodigo(), Variaveis.filialPadrao, null);
            }
        }
        agendamento.setAgendamentoExameRequisicaoBean(agendamentoExameRequisicao);
        requisicaoService.atualizarSituacaoExamesSemResultadoSemCommit(agendamento, "F");
        if (!Funcoes.objectIsNull(mult)) {
            int codigoRequisicaoAgendada = agendamento.getRequisicao().getCodigo();
            for (Integer codigoRequisicao : mult) {
                agendamento.getRequisicao().setCodigo(codigoRequisicao);
                requisicaoService.atualizarSituacaoExamesSemResultadoSemCommit(agendamento, "F");
            }
            agendamento.getRequisicao().setCodigo(codigoRequisicaoAgendada);
        }
        requisicaoService.marcarOrigemRequisicaoAgendamentoSemCommit(requisicao.getFilial().getCodigo().toString(), requisicao.getCodigo().toString(), false);
        if (mult != null) {
            for (i = 0; i < mult.length; ++i) {
                requisicaoService.marcarOrigemRequisicaoAgendamentoSemCommit(requisicao.getFilial().getCodigo().toString(), mult[i].toString(), false);
            }
        }
        Conexao.arquivaSQL();
    }
}

