/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.AlteraGuiasFaturamento;
import jalis.laboratorio.recepcao.PendenciasPacienteRender;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.CaixaListener;
import jalis.laboratorio.recepcao.util.MostraCaixa;
import jalis.model.vo.recepcao.PendenciasPacienteVO;
import jalis.service.recepcao.PendenciasPacienteService;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PendenciasPaciente
extends AbstractDialogoOKCancelar
implements CaixaListener {
    private long ACESSO_INFORMAR_GUIA = Long.parseLong("0200900119");
    private long ACESSO_ALTERAR_DATA_VALIDADE_GUIA = Long.parseLong("0200500159");
    private long ACESSO_MOVIMENTA_CAIXA_REQUISICAO = Long.parseLong("0200500124");
    private long ACESSO_MOVIMENTA_CAIXA_RECEPCAO = Long.parseLong("0201000103");
    private long ACESSO_MOVIMENTA_CAIXA_RESULTADO = Long.parseLong("0200900105");
    private final long ACESSO_ALTERAR_ACRESCIMO = Long.parseLong("0200700104");
    private final long ACESSO_ALTERAR_DESCONTO = Long.parseLong("0200700103");
    private final long ACESSO_ESTORNAR_PAGAMENTO = Long.parseLong("0200700119");
    private final long ACESSO_MOVIMENTAR_CAIXA = Long.parseLong("0200700105");
    private final long ACESSO_ALTERAR_DATA_CAIXA = Long.parseLong("0200700117");
    private final long ACESSO_SALVAR_SEM_PAGADOR = Long.parseLong("0200700124");
    private final long ACESSO_ALTERAR_CONTA_CAIXA = Long.parseLong("0200700118");
    private final long ACESSO_MOVIMENTAR_SEM_PAGAMENTO = Long.parseLong("0200700120");
    private final int COLUNA_REQUISICAO_CODIGO = 0;
    private final int COLUNA_REQUISICAO_DATA = 1;
    private final int COLUNA_REQUISICAO_DATA_ENTREGA = 2;
    public static final int COLUNA_REQUISICAO_GUIA_SITUACAO = 3;
    private final int COLUNA_REQUISICAO_MEDICO = 4;
    private final int COLUNA_REQUISICAO_CONVENIO = 5;
    private final int COLUNA_REQUISICAO_DESTINO = 6;
    private final int COLUNA_REQUISICAO_VALOR_EXAME = 7;
    private final int COLUNA_REQUISICAO_VALOR_PAGO = 8;
    public static final int COLUNA_REQUISICAO_SALDO_DEVEDOR = 9;
    private final int COLUNA_REQUISICAO_GUIA_REQUISICAO = 10;
    private final int COLUNA_REQUISICAO_GUIA_PRINCIPAL = 11;
    private final int COLUNA_REQUISICAO_DEVE_GUIA = 12;
    private final int COLUNA_REQUISICAO_VO = 13;
    private final int COLUNA_EXAME_CODIGO = 0;
    private final int COLUNA_EXAME_DESCRICAO = 1;
    public static final int COLUNA_EXAME_SITUACAO = 2;
    private final int COLUNA_EXAME_GUIA = 3;
    private final int COLUNA_EXAME_CODIGO_MATERIAL = 4;
    private final int COLUNA_EXAME_ABREVIATURA_MATERIAL = 5;
    private final int COLUNA_EXAME_QNT_GUIA = 6;
    private final int COLUNA_EXAME_CODIGO_GUIA = 7;
    private final int COLUNA_EXAME_VALIDADE_GUIA = 8;
    private final int COLUNA_EXAME_DATA_GUIA = 9;
    private final int COLUNA_EXAME_DATA_VALIDADE_GUIA = 10;
    private final int COLUNA_EXAME_DEVE_GUIA = 11;
    private final int COLUNA_EXAME_VO = 12;
    private final Caixa caixa = new Caixa(this);
    private JTable tableRequisicao;
    private JTable tableExame;
    private ModeloGridTable modeloRequisicao;
    private ModeloGridTable modeloExame;
    private JButton buttonPagamento;
    private JButton buttonGuia;
    private String codigoPaciente = "";
    private String codigoFilial = "";
    private String codigoRequisicao = "";
    public static final String[] colunasModeloRequisicao = new String[]{"C\u00f3digo", "Data", "Entrega", "Guia", "M\u00e9dico", "Conv\u00eanio", "Destino", "Valor Requisi\u00e7\u00e3o", "Valor Pago", "Saldo Devedor"};
    public static final String[] colunasModeloExame = new String[]{"Exame", "Descri\u00e7\u00e3o", "Situa\u00e7\u00e3o", "Guia"};
    private static boolean isRequisicao;

    public static PendenciasPaciente novaInstancia(Object owner) {
        isRequisicao = false;
        if (owner != null) {
            isRequisicao = true;
            return new PendenciasPaciente((Frame)Laboratorio.getInstancia(), "Pend\u00eancia do paciente");
        }
        if (owner instanceof Frame) {
            return new PendenciasPaciente((Frame)owner, "Pend\u00eancias do paciente");
        }
        return null;
    }

    public PendenciasPaciente(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public PendenciasPaciente(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public void montaTela() {
        this.setSize(new Dimension(950, 480));
        this.setLocationRelativeTo(this.getParent());
        this.setUsuarioPodeCancelar(false);
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setVisible(false);
        this.setDefaultCloseOperation(0);
        JPanel panelCentral = this.getPanelCentral();
        JPanel panelRequisicoes = new JPanel();
        JPanel panelExames = new JPanel();
        JPanel panelBotoes = this.getPanelBotoesDireita();
        panelCentral.setLayout(new BorderLayout());
        panelRequisicoes.setLayout(new BorderLayout());
        panelExames.setLayout(new BorderLayout());
        panelRequisicoes.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        panelExames.setBorder(new TitledBorder("Exames"));
        this.buttonPagamento = ComponenteFactory.novoJButton("Adicionar Pagamento", 'P', this);
        this.buttonGuia = ComponenteFactory.novoJButton("Informar Guia", 'G', this);
        JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
        this.buttonPagamento.setVisible(false);
        this.buttonGuia.setVisible(false);
        this.modeloRequisicao = new ModeloGridTable(colunasModeloRequisicao);
        this.modeloExame = new ModeloGridTable(colunasModeloExame);
        this.tableRequisicao = ComponenteFactory.novoJTable(this.modeloRequisicao);
        this.tableExame = ComponenteFactory.novoJTable(this.modeloExame);
        this.modeloRequisicao.setColumnSize(new int[]{60, 75, 75, 120, 0, 100, 60, 115, 80, 100}, this.tableRequisicao);
        this.modeloExame.setColumnSize(new int[]{70, 0, 95, 120}, this.tableExame);
        this.modeloRequisicao.ordenarColuna(this.modeloRequisicao.findColumn("C\u00f3digo"));
        this.modeloExame.ordenarColuna(this.modeloExame.findColumn("Exame"));
        this.tableRequisicao.setDefaultRenderer(Object.class, new PendenciasPacienteRender(this.modeloRequisicao));
        this.tableExame.setDefaultRenderer(Object.class, new PendenciasPacienteRender(this.modeloExame));
        this.tableRequisicao.setSelectionMode(0);
        this.tableExame.setSelectionMode(0);
        this.tableRequisicao.getTableHeader().addMouseListener(this.modeloRequisicao);
        this.tableExame.getTableHeader().addMouseListener(this.modeloExame);
        JScrollPane scrollRequisicao = new JScrollPane(this.tableRequisicao);
        JScrollPane scrollExame = new JScrollPane(this.tableExame);
        panelRequisicoes.add((Component)scrollRequisicao, "Center");
        panelExames.add((Component)scrollExame, "Center");
        panelCentral.add((Component)panelRequisicoes, "North");
        panelCentral.add((Component)panelExames, "Center");
        panelBotoes.add(this.buttonPagamento);
        panelBotoes.add(this.buttonGuia);
        panelBotoes.add(buttonFechar);
        Dimension dimensionPanelRequisicoes = new Dimension((int)((double)this.getWidth() / 2.1), (int)((double)this.getHeight() / 2.2));
        scrollRequisicao.setPreferredSize(dimensionPanelRequisicoes);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenUtil.requisitarFoco(PendenciasPaciente.this.tableRequisicao);
                if (PendenciasPaciente.this.contemLinhas(PendenciasPaciente.this.tableRequisicao)) {
                    PendenciasPaciente.this.tableRequisicao.setRowSelectionInterval(0, 0);
                }
            }
        });
        this.buttonPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PendenciasPaciente.this.processaPagamento();
                }
                catch (Exception error) {
                    ErrorLogger.mostraMensagem(PendenciasPaciente.this, error.getMessage(), error.getStackTrace());
                }
            }
        });
        this.buttonGuia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PendenciasPaciente.this.processaGuia();
                }
                catch (Exception error) {
                    ErrorLogger.mostraMensagem(PendenciasPaciente.this, error.getMessage(), error.getStackTrace());
                }
            }
        });
        buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PendenciasPaciente.this.setVisible(false);
            }
        });
        this.tableRequisicao.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PendenciasPaciente.this.controleBotoes();
                if (PendenciasPaciente.this.contemLinhaSelecionada(PendenciasPaciente.this.tableRequisicao)) {
                    String codigoRequisicao = PendenciasPaciente.this.tableRequisicao.getValueAt(PendenciasPaciente.this.linhaSelecionada(PendenciasPaciente.this.tableRequisicao), 0).toString();
                    PendenciasPaciente.this.carregaExames(PendenciasPaciente.this.codigoFilial, codigoRequisicao);
                } else {
                    PendenciasPaciente.this.modeloExame.clear();
                }
            }
        });
    }

    private boolean contemLinhaSelecionada(JTable table) {
        return table.getSelectedRow() > -1;
    }

    private boolean contemLinhas(JTable table) {
        return table.getRowCount() > 0;
    }

    private int linhaSelecionada(JTable table) {
        return table.getSelectedRow();
    }

    private void controleBotoes() {
        this.buttonGuia.setVisible(false);
        this.buttonPagamento.setVisible(false);
        if (this.contemLinhaSelecionada(this.tableRequisicao)) {
            if (this.isDeveGuia() && this.acessoBotaoGuia()) {
                this.buttonGuia.setVisible(true);
            }
            if (this.isDevePagamento() && this.acessoBotaPagamento()) {
                this.buttonPagamento.setVisible(true);
            }
        }
    }

    private boolean isDeveGuia() {
        if (this.contemLinhaSelecionada(this.tableRequisicao)) {
            return this.tableRequisicao.getValueAt(this.linhaSelecionada(this.tableRequisicao), 3).toString().contains("guia");
        }
        return false;
    }

    private boolean isDevePagamento() {
        if (this.contemLinhaSelecionada(this.tableRequisicao)) {
            return this.tableRequisicao.getValueAt(this.linhaSelecionada(this.tableRequisicao), 3).toString().contains("pagamento") || Double.parseDouble(Funcoes.limpaDecimal(this.tableRequisicao.getValueAt(this.linhaSelecionada(this.tableRequisicao), 9).toString())) > 0.0;
        }
        return false;
    }

    private boolean acessoBotaoGuia() {
        if (isRequisicao) {
            return Acesso.getAcesso(this.ACESSO_ALTERAR_DATA_VALIDADE_GUIA);
        }
        return Acesso.getAcesso(this.ACESSO_INFORMAR_GUIA);
    }

    private boolean acessoBotaPagamento() {
        if (isRequisicao) {
            return Acesso.getAcesso(this.ACESSO_MOVIMENTA_CAIXA_REQUISICAO) && Acesso.getAcesso(this.ACESSO_MOVIMENTA_CAIXA_RECEPCAO);
        }
        return Acesso.getAcesso(this.ACESSO_MOVIMENTA_CAIXA_RESULTADO);
    }

    private void recaregarRequisicaoComLinhaSelecionada(String codigoRequisicao) {
        this.carregaRequisicoes(this.codigoFilial, this.codigoPaciente, this.codigoRequisicao);
        int linhaRequisicao = this.modeloRequisicao.localizarContendo(0, codigoRequisicao);
        if (this.requisicaoFinalizada(linhaRequisicao)) {
            linhaRequisicao = 0;
        }
        if (this.contemLinhas(this.tableRequisicao)) {
            this.tableRequisicao.setRowSelectionInterval(linhaRequisicao, linhaRequisicao);
        }
    }

    private boolean requisicaoFinalizada(int linha) {
        return linha == -1;
    }

    private void processaGuia() throws Exception {
        String codigoConvenioRequisicao;
        Statement st2;
        Statement st1 = Conexao.getStatement();
        boolean convenioRepasse = !ConvenioUtil.getConveniosRepasse(st1, st2 = Conexao.getStatement(), this.codigoFilial, codigoConvenioRequisicao = String.valueOf(((PendenciasPacienteVO)this.modeloRequisicao.getValueAt(this.linhaSelecionada(this.tableRequisicao), 13)).getCodigoConvenio())).isEmpty();
        AlteraGuiasFaturamento alteraGuiasFaturamento = AlteraGuiasFaturamento.novaInstancia(Laboratorio.getInstancia(), convenioRepasse, false);
        if (!Funcoes.objectIsNull(alteraGuiasFaturamento)) {
            PendenciasPacienteVO pendenciasPacienteVO;
            Object[] registroRequisicao = this.modeloRequisicao.getLineValue(this.linhaSelecionada(this.tableRequisicao));
            String guiaRequisicao = registroRequisicao[10].toString();
            String guiaPrincipalRequisicao = registroRequisicao[11].toString();
            Boolean deveGuiaRequisicao = (Boolean)registroRequisicao[12];
            alteraGuiasFaturamento.setGuiasRequisicao(guiaRequisicao, guiaPrincipalRequisicao, false);
            for (int linha = 0; linha < this.modeloExame.getRowCount(); ++linha) {
                pendenciasPacienteVO = (PendenciasPacienteVO)this.modeloExame.getValueAt(linha, 12);
                alteraGuiasFaturamento.adicionarExame(pendenciasPacienteVO.getCodigoExame(), pendenciasPacienteVO.getDescricaoExame(), pendenciasPacienteVO.getGuiaExame(), pendenciasPacienteVO.getDataGuiaExame(), pendenciasPacienteVO.isDeveGuiaExame(), pendenciasPacienteVO.getQntPorGuiaExame(), pendenciasPacienteVO.isCodigoGuiaExame(), pendenciasPacienteVO.isValidadeGuiaExame(), pendenciasPacienteVO.getDataValidadeGuiaExame(), pendenciasPacienteVO.getAbreviaturaMaterialExame(), pendenciasPacienteVO.getCodigoMaterialExame());
            }
            alteraGuiasFaturamento.setVisible(true);
            if (alteraGuiasFaturamento.getOK()) {
                PendenciasPacienteService pps = new PendenciasPacienteService();
                pendenciasPacienteVO = (PendenciasPacienteVO)this.modeloRequisicao.getValueAt(this.linhaSelecionada(this.tableRequisicao), 13);
                pendenciasPacienteVO.setDeveGuiaRequisicao(alteraGuiasFaturamento.getGuiaRequisicao().isEmpty() && alteraGuiasFaturamento.getGuiaPrincipalRequisicao().isEmpty());
                pendenciasPacienteVO.setGuiaRequisicao(alteraGuiasFaturamento.getGuiaRequisicao());
                pendenciasPacienteVO.setGuiaPrincipalRequisicao(alteraGuiasFaturamento.getGuiaPrincipalRequisicao());
                pps.atualizaRequisicao(pendenciasPacienteVO);
                ArrayList<DadosExameFaturamento> listaExames = alteraGuiasFaturamento.getExames();
                for (DadosExameFaturamento dadosExameFaturamento : listaExames) {
                    pendenciasPacienteVO.setDeveGuiaExame(dadosExameFaturamento.getDeveGuia());
                    pendenciasPacienteVO.setGuiaExame(dadosExameFaturamento.getCodigoGuia());
                    pendenciasPacienteVO.setDataValidadeGuiaExame(dadosExameFaturamento.getValidadeGuia());
                    pendenciasPacienteVO.setDataGuiaExame(dadosExameFaturamento.getDataGuia());
                    pendenciasPacienteVO.setCodigoExame(dadosExameFaturamento.getCodigoExame());
                    pendenciasPacienteVO.setCodigoMaterialExame(dadosExameFaturamento.getCodigoMaterial());
                    if (pendenciasPacienteVO.isDeveGuiaExame()) {
                        pendenciasPacienteVO.setGuiaExame("");
                        pendenciasPacienteVO.setDataValidadeGuiaExame(null);
                        pendenciasPacienteVO.setDataGuiaExame(null);
                    }
                    pps.atualizaExame(pendenciasPacienteVO);
                }
                this.recaregarRequisicaoComLinhaSelecionada(String.valueOf(pendenciasPacienteVO.getCodigoRequisicao()));
            }
        }
    }

    private void processaPagamento() throws Exception {
        PendenciasPacienteVO pendenciasPacienteVO = (PendenciasPacienteVO)this.modeloRequisicao.getValueAt(this.linhaSelecionada(this.tableRequisicao), 13);
        if (!Funcoes.objectIsNull(pendenciasPacienteVO)) {
            Statement st1 = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            ArrayList<DadosConvenios> listaDadosConvenio = null;
            DadosConvenios convenio = null;
            listaDadosConvenio = ConvenioUtil.getConveniosRepasse(st1, st2, String.valueOf(pendenciasPacienteVO.getCodigoFilial()), String.valueOf(pendenciasPacienteVO.getCodigoConvenio()));
            convenio = ConvenioUtil.getDadosConvenios(String.valueOf(pendenciasPacienteVO.getCodigoFilial()), pendenciasPacienteVO.getCodigoConvenio());
            this.caixa.limpaValores();
            this.caixa.setHabilitaAcrescimoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_ACRESCIMO));
            this.caixa.setHabilitaDescontoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_DESCONTO));
            this.caixa.setPermitirEstornoPagamento(Acesso.getAcesso(this.ACESSO_ESTORNAR_PAGAMENTO));
            this.caixa.setMovimentarCaixa(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_CAIXA));
            this.caixa.setAlterarData(Acesso.getAcesso(this.ACESSO_ALTERAR_DATA_CAIXA));
            boolean exigir = ParametrosGerais.getExigirDadosPagadorDmed() ? !Acesso.getAcesso(this.ACESSO_SALVAR_SEM_PAGADOR) : false;
            this.caixa.setSalvarSemPagador(!exigir);
            this.caixa.setAlterarConta(Acesso.getAcesso(this.ACESSO_ALTERAR_CONTA_CAIXA));
            this.caixa.setNaoMovimentarCaixaSemPagamento(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_SEM_PAGAMENTO));
            this.caixa.setObs(pendenciasPacienteVO.getNotaCaixa());
            this.caixa.setGuiaPrincipalRepasse(pendenciasPacienteVO.getGuiaPrincipalRepasse());
            this.caixa.setGuiaRepasse(pendenciasPacienteVO.getGuiaRepasse());
            this.caixa.setMatriculaRepasse(pendenciasPacienteVO.getMatriculaRepasse());
            this.caixa.setDeveGuiaRepasse(pendenciasPacienteVO.isDeveGuiaRepasse());
            this.caixa.setValidadeCarteiraRepasse(pendenciasPacienteVO.getValidadeCarteira());
            this.caixa.setValidadeGuiaRepasse(pendenciasPacienteVO.getValidadeGuiaRepasse());
            this.caixa.setPlanoRepasse(pendenciasPacienteVO.getNomePlanoRepasse());
            this.caixa.setConveniosRepasse(listaDadosConvenio);
            this.caixa.setValorExames(pendenciasPacienteVO.getVlrExames());
            this.caixa.setValorMateriais(pendenciasPacienteVO.getVlrMateriais());
            this.caixa.setTotalTaxa(BigDecimal.valueOf(pendenciasPacienteVO.getTotalTaxa()));
            this.caixa.setPercentualDesconto(pendenciasPacienteVO.getDesconto());
            this.caixa.setValorDesconto(pendenciasPacienteVO.getVlrDesconto());
            this.caixa.setPercentualAcrescimo(pendenciasPacienteVO.getAcrescimo());
            this.caixa.setValorAcrescimo(pendenciasPacienteVO.getVlrAcrescimo());
            this.caixa.setDadosPagador(pendenciasPacienteVO.getCodigoConvenio(), pendenciasPacienteVO.getNomePagador(), pendenciasPacienteVO.getCpfPagador());
            this.caixa.setDadosConvenio(convenio);
            this.caixa.setCodigoRequisicao(String.valueOf(pendenciasPacienteVO.getCodigoFilial()), pendenciasPacienteVO.getCodigoRequisicao(), true);
            this.caixa.posicionaFoco(1);
            MostraCaixa mostraCaixa = new MostraCaixa((Frame)this.getParent(), this.caixa);
            mostraCaixa.setVisible(true);
            if (mostraCaixa.isOK()) {
                pendenciasPacienteVO.setValorPagoRequisicao(this.caixa.getValorRecebido());
                pendenciasPacienteVO.setDesconto(this.caixa.getDesconto());
                pendenciasPacienteVO.setVlrDesconto(this.caixa.getValorDesconto());
                pendenciasPacienteVO.setAcrescimo(this.caixa.getAcrescimo());
                pendenciasPacienteVO.setVlrAcrescimo(this.caixa.getValorAcrescimo());
                pendenciasPacienteVO.setValorTotalRequisicao(this.caixa.getSubTotal().add(new BigDecimal(String.valueOf(this.caixa.getValorAcrescimo()))).subtract(new BigDecimal(String.valueOf(this.caixa.getValorDesconto()))).doubleValue());
                this.caixa.gravarValores(String.valueOf(pendenciasPacienteVO.getCodigoFilial()), pendenciasPacienteVO.getCodigoRequisicao(), true, true);
                PendenciasPacienteService pps = new PendenciasPacienteService();
                pps.atualizaValorPagoRequisicao(pendenciasPacienteVO);
                this.recaregarRequisicaoComLinhaSelecionada(String.valueOf(pendenciasPacienteVO.getCodigoRequisicao()));
            } else {
                Conexao.anulaSQL();
            }
        }
    }

    private double retornaValorTotalCaixa(double valorTotalCaixa) {
        String valorTotal = Funcoes.formataDecimal(valorTotalCaixa);
        valorTotal = Funcoes.limpaDecimal(valorTotal);
        return Double.parseDouble(valorTotal);
    }

    public void carregaRequisicoes(String codigoFilial, String codigoPaciente, String codigo) {
        this.codigoFilial = codigoFilial;
        this.codigoPaciente = codigoPaciente;
        this.codigoRequisicao = codigo;
        this.modeloRequisicao.clear();
        ArrayList listaRequisicao = new ArrayList();
        try {
            listaRequisicao = new PendenciasPacienteService().getListaRequisicao(codigoFilial, codigoPaciente, codigo);
        }
        catch (Exception error) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da requisi\u00e7\u00e3o.\n" + error.getMessage(), error.getStackTrace());
        }
        for (PendenciasPacienteVO pendenciasPacienteVO : listaRequisicao) {
            this.modeloRequisicao.addLine(new Object[]{pendenciasPacienteVO.getCodigoRequisicao(), pendenciasPacienteVO.getDataRequisicaoFormatada(), pendenciasPacienteVO.getDataEntregaRequisicaoFormatada(), pendenciasPacienteVO.getGuiaSituacaoRequisicao(), pendenciasPacienteVO.getMedicoRequisicao(), pendenciasPacienteVO.getConvenioRequisicao(), pendenciasPacienteVO.getDestinoRequisicao(), pendenciasPacienteVO.getValorTotalRequisicaoFormatada(), pendenciasPacienteVO.getValorPagoRequisicaoFormatada(), pendenciasPacienteVO.getSaldoDevedorRequisicaoFormatada(), pendenciasPacienteVO.getGuiaRequisicao(), pendenciasPacienteVO.getGuiaPrincipalRequisicao(), pendenciasPacienteVO.isDeveGuiaRequisicao(), pendenciasPacienteVO});
        }
        this.modeloRequisicao.ordenarColunaSemTrocarSentido(this.modeloRequisicao.getColunaOrdenacao());
    }

    private void carregaExames(String codigoFilial, String codigoRequisicao) {
        this.modeloExame.clear();
        ArrayList listaExame = new ArrayList();
        try {
            listaExame = new PendenciasPacienteService().getListaExame(codigoFilial, codigoRequisicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        for (PendenciasPacienteVO pendenciasPacienteVO : listaExame) {
            this.modeloExame.addLine(new Object[]{pendenciasPacienteVO.getCodigoExame(), pendenciasPacienteVO.getDescricaoExame(), pendenciasPacienteVO.getSituacaoExameFormatada(), pendenciasPacienteVO.getGuiaExame(), pendenciasPacienteVO.getCodigoMaterialExame(), pendenciasPacienteVO.getAbreviaturaMaterialExame(), pendenciasPacienteVO.getQntPorGuiaExame(), pendenciasPacienteVO.isCodigoGuiaExame(), pendenciasPacienteVO.isValidadeGuiaExame(), pendenciasPacienteVO.getDataGuiaExame(), pendenciasPacienteVO.getDataValidadeGuiaExame(), pendenciasPacienteVO.isDeveGuiaExame(), pendenciasPacienteVO});
        }
        this.modeloExame.ordenarColunaSemTrocarSentido(this.modeloExame.getColunaOrdenacao());
    }

    @Override
    public Registro getDadosPagador() {
        return null;
    }
}

