/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.ContrassenhaDesconto;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class PedirContraSenha
extends JDialog
implements DisposeListener {
    JLabel label1 = new JLabel("O valor informado para desconto excedeu o limite permitido.");
    JLabel label2 = new JLabel("Para liberar o desconto informe a contrassenha.");
    JLabel labelSenha = new JLabel("Senha");
    JLabel labelContraSenha = new JLabel("Contrassenha");
    JLabel labelValorSenha = new JLabel();
    TTextField txtContraSenha = new TTextField(8, 1);
    JButton buttonOK = new JButton("OK");
    JButton buttonCancelar = new JButton("Cancelar");
    JPanel panelCentro = new JPanel(null);
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    boolean ok = false;
    String senha = "";

    public PedirContraSenha(Frame owner, String senha) {
        super(owner, true);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.senha = senha;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public PedirContraSenha(Dialog owner, String senha) {
        super(owner, true);
        this.senha = senha;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit() throws Exception {
        this.setTitle("Contrassenha de desconto");
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(450, 220));
        this.setLocationRelativeTo(this.getParent());
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentro.add(this.label1);
        this.panelCentro.add(this.label2);
        this.panelCentro.add(this.labelSenha);
        this.panelCentro.add(this.labelValorSenha);
        this.panelCentro.add(this.labelContraSenha);
        this.panelCentro.add(this.txtContraSenha);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.label1.setBounds(new Rectangle(5, 5, 430, 18));
        this.label2.setBounds(new Rectangle(5, 20, 430, 18));
        this.labelSenha.setBounds(new Rectangle(5, 38, 430, 18));
        this.labelValorSenha.setBounds(new Rectangle(5, 55, 430, 24));
        this.labelContraSenha.setBounds(new Rectangle(5, 76, 430, 18));
        this.txtContraSenha.setBounds(new Rectangle(5, 91, 430, 24));
        this.labelValorSenha.setBorder(new TitledBorder(""));
        this.labelValorSenha.setText(this.senha);
        this.txtContraSenha.requestFocus();
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(PedirContraSenha.this.txtContraSenha.getText())) {
                    PedirContraSenha.this.ok = ContrassenhaDesconto.validaContraSenha(PedirContraSenha.this.labelValorSenha.getText(), PedirContraSenha.this.txtContraSenha.getText());
                    if (!PedirContraSenha.this.ok) {
                        Funcoes.mensagem(PedirContraSenha.this, "Contrassenha incorreta", 5);
                        PedirContraSenha.this.txtContraSenha.requestFocus();
                        return;
                    }
                }
                PedirContraSenha.this.setVisible(false);
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PedirContraSenha.this.ok = false;
                PedirContraSenha.this.setVisible(false);
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }

    public void setMensagem(String mensagem) {
        this.label1.setText(mensagem);
    }

    public void setMensagem2(String mensagem) {
        this.label2.setText(mensagem);
    }
}

