/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.recepcao.Agendamento;
import jalis.laboratorio.recepcao.Horario;
import jalis.laboratorio.recepcao.RepresentacaoAgendamento;
import jalis.model.bean.cadastro.FeriadoBean;
import jalis.model.bean.cadastro.SalaAtendimentoBean;
import jalis.model.bean.recepcao.AgendamentoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.SalaAtendimentoVO;
import jalis.service.cadastro.FeriadoService;
import jalis.service.recepcao.AgendamentoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JPanel;

class PanelAgendamento
extends JPanel {
    private ArrayList<RepresentacaoAgendamento> agendamentos = new ArrayList();
    private int intervalo = 15;
    private int quantidadeColetadores = 1;
    private Time horaInicial = null;
    private Time horaFinal = null;
    private Time horaInicialAlmoco = null;
    private Time horaFinalAlmoco = null;
    private boolean naoPermiteAgendamento = false;
    private boolean permiteSelecionar = true;
    private boolean apresentarContador = false;
    protected FeriadoBean feriado = null;
    private SalaAtendimentoBean salaAtendimento = null;
    private Date data = null;
    public Agendamento tela = null;
    private ThreadAtualizaSituacoes threadSituacao = null;
    protected boolean threadAtiva = true;
    protected boolean atualizacaoAutomatica = true;

    public PanelAgendamento(SalaAtendimentoBean salaAtendimento, Date data, boolean permiteSelecionar) {
        this.setName("PanelAgendamento");
        this.setDoubleBuffered(false);
        this.salaAtendimento = salaAtendimento;
        this.data = data;
        this.permiteSelecionar = permiteSelecionar;
        if (salaAtendimento != null) {
            this.quantidadeColetadores = salaAtendimento.getQtdeColetadores();
        }
        if (salaAtendimento != null && data != null) {
            this.validaDiaSemana(salaAtendimento, data);
        }
        if (salaAtendimento != null) {
            this.buscaAgendamentos(salaAtendimento, Integer.parseInt(Variaveis.filialPadrao), data);
        }
        this.threadSituacao = new ThreadAtualizaSituacoes(this);
        this.threadSituacao.start();
    }

    public PanelAgendamento(Agendamento tela, SalaAtendimentoBean salaAtendimento, Date data, boolean permiteSelecionar) {
        this.setName("PanelAgendamento");
        this.setDoubleBuffered(false);
        this.salaAtendimento = salaAtendimento;
        this.data = data;
        this.tela = tela;
        this.permiteSelecionar = permiteSelecionar;
        if (salaAtendimento != null) {
            this.quantidadeColetadores = salaAtendimento.getQtdeColetadores();
        }
        if (salaAtendimento != null && data != null) {
            this.validaDiaSemana(salaAtendimento, data);
        }
        if (salaAtendimento != null) {
            this.buscaAgendamentos(salaAtendimento, Integer.parseInt(Variaveis.filialPadrao), data);
        }
        this.threadSituacao = new ThreadAtualizaSituacoes(this);
        this.threadSituacao.start();
    }

    public Horario getHorario(Time hora) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(hora);
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Horario)) continue;
            Horario aux = (Horario)comps[i];
            if (aux.horaInicial.intValue() != cal.get(11) || aux.minutoInicial.intValue() != cal.get(12)) continue;
            return aux;
        }
        return null;
    }

    public Rectangle getRetanguloHorarioAtual() {
        Calendar atual = Calendar.getInstance();
        atual.setTime(new Date());
        int indiceMaisProxima = -1;
        int diferenca = Integer.MAX_VALUE;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Horario)) continue;
            Horario aux = (Horario)comps[i];
            if (aux.horaInicial.intValue() == atual.get(11)) {
                Rectangle rec = aux.getBounds();
                rec.y += aux.getHeight();
                return rec;
            }
            if (Math.abs(aux.horaInicial - atual.get(11)) > diferenca) continue;
            diferenca = Math.abs(aux.horaInicial - atual.get(11));
            indiceMaisProxima = i;
        }
        if (indiceMaisProxima > -1) {
            Horario aux = (Horario)comps[indiceMaisProxima];
            return aux.getBounds();
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void setAgendamentos(ArrayList<RepresentacaoAgendamento> agendamentos) {
        this.agendamentos = agendamentos;
    }

    public ArrayList<RepresentacaoAgendamento> getAgendamentos() {
        return this.agendamentos;
    }

    public void setHoraInicial(Time horaInicial) {
        this.horaInicial = horaInicial;
    }

    public void setHoraFinal(Time horaFinal) {
        this.horaFinal = horaFinal;
    }

    public void setIntervalo(int intervalo) {
        this.intervalo = intervalo;
    }

    public void setFeriado(FeriadoBean feriado) {
        this.feriado = feriado;
    }

    public void setQuantidadeColetadores(int qtde) {
        this.quantidadeColetadores = qtde;
    }

    public void setHoraInicialAlmoco(Time horaInicialAlmoco) {
        this.horaInicialAlmoco = horaInicialAlmoco;
    }

    public void setHoraFinalAlmoco(Time horaFinalAlmoco) {
        this.horaFinalAlmoco = horaFinalAlmoco;
    }

    public void setApresentarContador(boolean b) {
        this.apresentarContador = b;
    }

    public Time getHoraInicial() {
        return this.horaInicial;
    }

    public Time getHoraFinal() {
        return this.horaFinal;
    }

    public int getIntervalo() {
        return this.intervalo;
    }

    public int getQuantidadeColetadores() {
        return this.quantidadeColetadores;
    }

    public void setNaoPermiteAgendamento(boolean b) {
        this.naoPermiteAgendamento = b;
    }

    public Time getHoraInicialAlmoco() {
        return this.horaInicialAlmoco;
    }

    public Time getHoraFinalAlmoco() {
        return this.horaFinalAlmoco;
    }

    public void buscaAgendamentos(SalaAtendimentoBean salaAtendimento, int filial, Date data) {
        if (salaAtendimento == null || data == null) {
            return;
        }
        boolean desativarAtualizacao = this.atualizacaoAutomatica;
        if (this.atualizacaoAutomatica) {
            this.atualizacaoAutomatica = false;
        }
        this.salaAtendimento = salaAtendimento;
        this.data = data;
        this.agendamentos.clear();
        try {
            ArrayList<AgendamentoBean> agendamentosLocalizados = new ArrayList<AgendamentoBean>(new AgendamentoService().buscaAgendamentosPorData(String.valueOf(filial), (SalaAtendimentoVO)salaAtendimento.toVO(), data));
            Collections.sort(agendamentosLocalizados, new Comparator<AgendamentoBean>(){

                @Override
                public int compare(AgendamentoBean o1, AgendamentoBean o2) {
                    if (o1 != null && o2 != null && o1.getCodigo() < o2.getCodigo()) {
                        return o1.getDataHoraAgendamento().compareTo(o2.getDataHoraAgendamento()) + o1.getCodigo().compareTo(o2.getCodigo());
                    }
                    return 0;
                }
            });
            for (int i = 0; i < agendamentosLocalizados.size(); ++i) {
                AgendamentoBean agendamentoSelecionado;
                AgendamentoBean agendamento = agendamentosLocalizados.get(i);
                AgendamentoBean agendamentoBean = agendamentoSelecionado = RepresentacaoAgendamento.agendamentoSelecionado != null ? RepresentacaoAgendamento.agendamentoSelecionado.getAgendamento() : null;
                RepresentacaoAgendamento rep = new RepresentacaoAgendamento(agendamento, agendamentoSelecionado != null ? agendamento.getCodigo().intValue() == agendamentoSelecionado.getCodigo().intValue() : false, this.permiteSelecionar);
                this.agendamentos.add(rep);
            }
            Rectangle retanguloAtual = this.getVisibleRect();
            this.setIgnoreRepaint(true);
            this.montaPainel();
            Thread thread = new Thread("Thread_painel_agendamento"){

                @Override
                public void run() {
                    PanelAgendamento.this.setIgnoreRepaint(false);
                    PanelAgendamento.this.validate();
                    PanelAgendamento.this.repaint();
                    Agendamento.getInstancia().selecionarAgendamento(RepresentacaoAgendamento.agendamentoSelecionado);
                }
            };
            thread.start();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar agendamentos.\n" + e.getMessage(), e.getStackTrace());
        }
        if (desativarAtualizacao) {
            this.atualizacaoAutomatica = true;
        }
    }

    public void montaPainel() {
        this.removeAll();
        if (this.naoPermiteAgendamento) {
            this.setLayout(new BorderLayout());
            this.add((Component)new Horario(this, this.feriado), "Center");
            ArrayList<Horario> horarios = new ArrayList<Horario>();
            this.verificarHorariosComProblema(horarios);
            if (horarios.size() > 0) {
                JPanel panelProblema = new JPanel(new GridBagLayout());
                this.add((Component)panelProblema, "South");
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 17;
                c.fill = 2;
                c.gridheight = 1;
                c.gridwidth = 1;
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.insets = new Insets(3, 15, 3, 3);
                for (int i = 0; i < horarios.size(); ++i) {
                    Horario aux = horarios.get(i);
                    if (aux.equals(Horario.horarioSelecionado) && Horario.horarioSelecionado.getPanelAgendamento() == this) {
                        aux.selecionar();
                    }
                    panelProblema.add((Component)aux, c);
                    ++c.gridy;
                }
            }
        } else {
            Horario horario;
            Calendar calendarInicioDia = Calendar.getInstance();
            calendarInicioDia.setTime(this.horaInicial);
            Calendar calendarFimDia = Calendar.getInstance();
            calendarFimDia.setTime(this.horaFinal);
            ArrayList<Horario> horarios = new ArrayList<Horario>();
            int contador = 0;
            Calendar calendarInicioHorario = Calendar.getInstance();
            calendarInicioHorario.setTime(this.horaInicial);
            Calendar calendarFimHorario = Calendar.getInstance();
            calendarFimHorario.setTime(this.horaInicial);
            boolean almocoEncontrado = false;
            while (calendarInicioHorario.getTime().compareTo(this.horaFinal) < 0) {
                int intervaloAux = -1;
                calendarFimHorario.add(12, this.intervalo);
                boolean inicio = false;
                if (this.horaInicialAlmoco != null && this.horaFinalAlmoco != null && calendarInicioHorario.getTime().compareTo(this.horaInicialAlmoco) >= 0 && calendarInicioHorario.getTime().compareTo(this.horaFinalAlmoco) < 0) {
                    inicio = true;
                }
                boolean fim = false;
                if (this.horaInicialAlmoco != null && this.horaFinalAlmoco != null && calendarFimHorario.getTime().compareTo(this.horaInicialAlmoco) > 0 && calendarFimHorario.getTime().compareTo(this.horaFinalAlmoco) <= 0) {
                    fim = true;
                }
                if (inicio || fim) {
                    almocoEncontrado = true;
                }
                if (fim && !inicio) {
                    intervaloAux = Funcoes.diferencaEmMinutos(calendarInicioHorario.getTime(), this.horaInicialAlmoco);
                }
                if (Funcoes.diferencaEmMinutos(calendarInicioHorario.getTime(), this.horaFinal) < this.intervalo) {
                    intervaloAux = Funcoes.diferencaEmMinutos(calendarInicioHorario.getTime(), this.horaFinal);
                }
                if (!almocoEncontrado || intervaloAux > -1) {
                    horario = new Horario(this, false, false, calendarInicioHorario.get(11), calendarInicioHorario.get(12), intervaloAux > -1 ? intervaloAux : this.intervalo, this.quantidadeColetadores, this.apresentarContador ? Integer.valueOf(contador + 1) : null, -1, -1);
                    horarios.add(horario);
                }
                if (almocoEncontrado) {
                    Calendar aux = Calendar.getInstance();
                    aux.setTime(this.horaFinalAlmoco);
                    calendarInicioHorario.set(11, aux.get(11));
                    calendarInicioHorario.set(12, aux.get(12));
                    calendarFimHorario.set(11, aux.get(11));
                    calendarFimHorario.set(12, aux.get(12));
                    almocoEncontrado = false;
                } else {
                    calendarInicioHorario.add(12, this.intervalo);
                }
                ++contador;
            }
            if (this.horaInicialAlmoco != null && this.horaFinalAlmoco != null) {
                Calendar auxIni = Calendar.getInstance();
                auxIni.setTime(this.horaInicialAlmoco);
                Calendar auxFim = Calendar.getInstance();
                auxFim.setTime(Funcoes.somaMinutos(this.horaFinalAlmoco, -1));
                Horario horario2 = new Horario(this, false, false, auxIni.get(11), auxIni.get(12), this.intervalo, 0, null, auxFim.get(11), auxFim.get(12));
                horario2.setBloqueado(true, true);
                horarios.add(horario2);
            }
            for (int j = 0; j < this.agendamentos.size(); ++j) {
                RepresentacaoAgendamento rep = this.agendamentos.get(j);
                if (rep.getAgendamento().getHorarioAberto() == null || !rep.getAgendamento().getHorarioAberto().booleanValue()) continue;
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Time(rep.getAgendamento().getDataHoraAgendamento().getTime()));
                horario = null;
                for (int i = 0; i < horarios.size(); ++i) {
                    Horario aux = horarios.get(i);
                    if (aux.horaInicial.intValue() != cal.get(11) || aux.minutoInicial.intValue() != cal.get(12)) continue;
                    horario = aux;
                    break;
                }
                if (horario == null) {
                    horario = new Horario(this, true, false, cal.get(11), cal.get(12), this.intervalo, this.quantidadeColetadores, null, -1, -1);
                    horarios.add(horario);
                }
                if (rep.equals(RepresentacaoAgendamento.agendamentoSelecionado)) {
                    rep.selecionar();
                }
                horario.addAgendamento(rep);
            }
            this.verificarHorariosComProblema(horarios);
            Collections.sort(horarios);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.setLayout(new GridBagLayout());
            for (int i = 0; i < horarios.size(); ++i) {
                Horario aux = horarios.get(i);
                c.insets = aux.isHorarioDiferenciado ? new Insets(3, 15, 3, 3) : new Insets(3, 3, 3, 3);
                for (int j = 0; j < this.agendamentos.size(); ++j) {
                    RepresentacaoAgendamento rep = this.agendamentos.get(j);
                    if (rep.getAgendamento().getHorarioAberto() != null && rep.getAgendamento().getHorarioAberto().booleanValue()) continue;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(rep.getAgendamento().getDataHoraAgendamento());
                    int hora = cal.get(11);
                    int minuto = cal.get(12);
                    if (hora != aux.horaInicial || minuto != aux.minutoInicial) continue;
                    if (rep.getAgendamento().getBloqueado() != null && rep.getAgendamento().getBloqueado().booleanValue()) {
                        aux.setBloqueado(true, false);
                        aux.addAgendamento(rep);
                        break;
                    }
                    aux.addAgendamento(rep);
                }
                if (aux.equals(Horario.horarioSelecionado) && Horario.horarioSelecionado.getPanelAgendamento() == this) {
                    aux.selecionar();
                }
                this.add((Component)aux, c);
                ++c.gridy;
            }
            ++c.gridy;
            c.fill = 1;
            c.weighty = 1.0;
            c.insets = new Insets(3, 3, 3, 3);
            this.add((Component)new Horario(this, this.feriado), c);
        }
    }

    private void verificarHorariosComProblema(ArrayList<Horario> horarios) {
        for (int j = 0; j < this.agendamentos.size(); ++j) {
            RepresentacaoAgendamento rep = this.agendamentos.get(j);
            if (rep.getHorario() != null) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Time(rep.getAgendamento().getDataHoraAgendamento().getTime()));
            boolean encontrado = false;
            Horario horario = null;
            for (int i = 0; i < horarios.size(); ++i) {
                Horario aux = horarios.get(i);
                if (aux.horaInicial.intValue() != cal.get(11) || aux.minutoInicial.intValue() != cal.get(12)) continue;
                horario = aux;
                encontrado = true;
                break;
            }
            if (encontrado) continue;
            horario = new Horario(this, true, true, cal.get(11), cal.get(12), this.intervalo, this.quantidadeColetadores, null, -1, -1);
            horarios.add(horario);
            if (rep.equals(RepresentacaoAgendamento.agendamentoSelecionado)) {
                rep.selecionar();
            }
            horario.addAgendamento(rep);
        }
    }

    public void validaDiaSemana(SalaAtendimentoBean sala, Date data) {
        if (sala == null || data == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        int diaSemana = calendar.get(7);
        int intervalo = sala.getIntervaloPadrao();
        Date horaInicial = sala.getHoraInicialPadrao();
        Date horaFinal = sala.getHoraFinalPadrao();
        Date almocoInicial = sala.getHoraInicialAlmocoPadrao();
        Date almocoFinal = sala.getHoraFinalAlmocoPadrao();
        boolean podeAgendar = true;
        if (sala.getUtilizarHorariosDiferenciados().booleanValue()) {
            switch (diaSemana) {
                case 1: {
                    podeAgendar = sala.getAgendarDomingo();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloDomingo();
                    horaInicial = sala.getHoraInicialDomingo();
                    horaFinal = sala.getHoraFinalDomingo();
                    almocoInicial = sala.getHoraInicialAlmocoDomingo();
                    almocoFinal = sala.getHoraFinalAlmocoDomingo();
                    break;
                }
                case 2: {
                    podeAgendar = sala.getAgendarSegunda();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloSegunda();
                    horaInicial = sala.getHoraInicialSegunda();
                    horaFinal = sala.getHoraFinalSegunda();
                    almocoInicial = sala.getHoraInicialAlmocoSegunda();
                    almocoFinal = sala.getHoraFinalAlmocoSegunda();
                    break;
                }
                case 3: {
                    podeAgendar = sala.getAgendarTerca();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloTerca();
                    horaInicial = sala.getHoraInicialTerca();
                    horaFinal = sala.getHoraFinalTerca();
                    almocoInicial = sala.getHoraInicialAlmocoTerca();
                    almocoFinal = sala.getHoraFinalAlmocoTerca();
                    break;
                }
                case 4: {
                    podeAgendar = sala.getAgendarQuarta();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloQuarta();
                    horaInicial = sala.getHoraInicialQuarta();
                    horaFinal = sala.getHoraFinalQuarta();
                    almocoInicial = sala.getHoraInicialAlmocoQuarta();
                    almocoFinal = sala.getHoraFinalAlmocoQuarta();
                    break;
                }
                case 5: {
                    podeAgendar = sala.getAgendarQuinta();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloQuinta();
                    horaInicial = sala.getHoraInicialQuinta();
                    horaFinal = sala.getHoraFinalQuinta();
                    almocoInicial = sala.getHoraInicialAlmocoQuinta();
                    almocoFinal = sala.getHoraFinalAlmocoQuinta();
                    break;
                }
                case 6: {
                    podeAgendar = sala.getAgendarSexta();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloSexta();
                    horaInicial = sala.getHoraInicialSexta();
                    horaFinal = sala.getHoraFinalSexta();
                    almocoInicial = sala.getHoraInicialAlmocoSexta();
                    almocoFinal = sala.getHoraFinalAlmocoSexta();
                    break;
                }
                default: {
                    podeAgendar = sala.getAgendarSabado();
                    if (!podeAgendar) break;
                    intervalo = sala.getIntervaloSabado();
                    horaInicial = sala.getHoraInicialSabado();
                    horaFinal = sala.getHoraFinalSabado();
                    almocoInicial = sala.getHoraInicialAlmocoSabado();
                    almocoFinal = sala.getHoraFinalAlmocoSabado();
                }
            }
        }
        this.setApresentarContador(sala.getApresentarContador());
        this.setNaoPermiteAgendamento(!podeAgendar);
        if (podeAgendar) {
            try {
                Conexao.setSessaoConexao(true);
                FeriadoBean feriado = (FeriadoBean)new FeriadoService().getFeriado(Variaveis.filialPadrao, data);
                Conexao.setSessaoConexao(false);
                this.setFeriado(feriado);
                if (feriado != null) {
                    podeAgendar = feriado.getPermitirAgendamento() == null ? false : feriado.getPermitirAgendamento();
                    this.setNaoPermiteAgendamento(!podeAgendar);
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar feriados.\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            this.setFeriado(null);
        }
        if (podeAgendar) {
            this.setIntervalo(intervalo);
            this.setHoraInicial(new Time(horaInicial.getTime()));
            this.setHoraFinal(new Time(horaFinal.getTime()));
            this.setHoraInicialAlmoco(almocoInicial == null ? null : new Time(almocoInicial.getTime()));
            this.setHoraFinalAlmoco(almocoFinal == null ? null : new Time(almocoFinal.getTime()));
        }
    }

    public void atualizaAgendamentos() {
        if (StringUtil.validaInteiro(Variaveis.filialPadrao)) {
            this.buscaAgendamentos(this.salaAtendimento, Integer.parseInt(Variaveis.filialPadrao), this.data);
        }
    }

    public SalaAtendimentoBean getSalaAtendimento() {
        return this.salaAtendimento;
    }

    public Date getData() {
        return this.data;
    }

    public void pararThread() {
        this.threadAtiva = false;
        this.atualizacaoAutomatica = false;
    }

    public void setPodeAtualizarAgenda(boolean podeAtualizar) {
        this.atualizacaoAutomatica = podeAtualizar;
    }

    public FeriadoBean getFeriado() {
        return this.feriado;
    }

    public void desselecionarTodosAgendamentos() {
        if (this.agendamentos != null && !this.agendamentos.isEmpty()) {
            for (RepresentacaoAgendamento aux : this.agendamentos) {
                aux.desselecionar();
            }
        }
    }

    class ThreadAtualizaSituacoes
    extends Thread {
        private PanelAgendamento panelAgendamento = null;

        public ThreadAtualizaSituacoes(PanelAgendamento panelAgendamento) {
            this.panelAgendamento = panelAgendamento;
            this.setPriority(5);
        }

        @Override
        public void run() {
            while (this.panelAgendamento.threadAtiva) {
                try {
                    ThreadAtualizaSituacoes.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.panelAgendamento.atualizacaoAutomatica) continue;
                this.panelAgendamento.atualizaAgendamentos();
            }
            this.interrupt();
        }
    }
}

