/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.ExameMaterialPagina;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.recepcao.CriarRequisicao_;
import jalis.laboratorio.recepcao.ItemMenuImpressao;
import jalis.laboratorio.recepcao.JanelaRequisicoesOrcamento;
import jalis.laboratorio.recepcao.NovoEscolheConvenio;
import jalis.laboratorio.recepcao.ObjetoTotalExame;
import jalis.laboratorio.recepcao.Orcamento;
import jalis.laboratorio.recepcao.RetornoAcrescimo;
import jalis.laboratorio.recepcao.RetornoDesconto;
import jalis.laboratorio.recepcao.SelecionarMaterialAlimentos;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.exame.LayoutBean;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.model.bean.recepcao.OrcamentoBean;
import jalis.model.bean.recepcao.OrcamentoConvenioBean;
import jalis.model.bean.recepcao.OrcamentoConvenioExameBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.LayoutVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.relatorio.Gerador;
import jalis.relatorio.bean.ExameTerceirizadoBean;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.ExameMatColetaService;
import jalis.service.cadastro.exame.LayoutService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.recepcao.OrcamentoService;
import jalis.servidor.Cliente;
import jalis.util.ArraysUtil;
import jalis.util.CheckItemFiltro;
import jalis.util.ConvenioUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class OrcamentoAprovado
extends FrmCadPadraoBean
implements ActionListener {
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private int CASAS = ParametrosGerais.getCasasPrecoExame();
    private static final int COLUNA_ORCAMENTO = 6;
    private final String CAMPO_ORDENACAO_INMETRO = "ordenarcolunainmetro";
    private JPopupMenu menuImprimir = new JPopupMenu();
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Data", "Usu\u00e1rio", "Aprova\u00e7\u00e3o", "Solicitante", "Vencimento"});
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scrollPaneTabela = new JScrollPane(this.tabela);
    private JMenu menuInstrucoesColeta = new JMenu("Instru\u00e7\u00f5es de Coleta");
    private JMenu menuProposta = new JMenu("Proposta");
    private JMenu menuOrcamento = new JMenu("Or\u00e7amento");
    private JMenuItem menuPadraoOrcamento = ComponenteFactory.novoJMenuItem(null, "Modelo padr\u00e3o", (ActionListener)this);
    private JMenuItem menuPadraoProposta = ComponenteFactory.novoJMenuItem(null, "Modelo padr\u00e3o", (ActionListener)this);
    private JMenuItem menuInstrucoesColetaSelecionado = ComponenteFactory.novoJMenuItem(this.menuInstrucoesColeta, "Selecionar o exame", (ActionListener)this);
    private JMenu menuInstrucoesColetaTodos = ComponenteFactory.novoJMenu(this.menuInstrucoesColeta, "Todos os Exames", '\u0000');
    private JMenuItem menuInstrucoesColetaTodosPagina = ComponenteFactory.novoJMenuItem(this.menuInstrucoesColetaTodos, "P\u00e1gina separada", (ActionListener)this);
    private JMenuItem menuInstrucoesColetaTodosAgrupada = ComponenteFactory.novoJMenuItem(this.menuInstrucoesColetaTodos, "Agrupada", (ActionListener)this);
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel painelCrud = new JPanel(new FlowLayout());
    private JPanel panelFiltros = new JPanel(new BorderLayout());
    private JPanel panelConsulta = new JPanel(new BorderLayout());
    private JPanel panelUser = new JPanel(new GridBagLayout());
    private JPanel painelLegenda = new JPanel(new FlowLayout(0));
    private JButton buttonVisualizaExame = ComponenteFactory.novoJButton("Visualizar exames", 'V', this);
    private JButton buttonImprimir = new JButton("Imprimir \u25bc");
    private JButton buttonFiltrarFilial = new JButton("Filtrar");
    private JButton buttonFiltarUsuario = new JButton("Filtrar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataInicialAprovacao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinalAprovacao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton("Requisi\u00e7\u00e3o", 'R', this);
    private CheckItemFiltro itemFiltroUsuario = new CheckItemFiltro("Usu\u00e1rio", "Filtrar", "Filtrando usu\u00e1rios", "");
    private CheckItemFiltro itemFiltroCliente;
    private JCheckBox exibiOrcamentoComRequisicao = new JCheckBox("Or\u00e7amento com requisi\u00e7\u00e3o");
    private TTextField textFieldDataInicial = ComponenteFactory.novoTTextField(10, 4);
    private TTextField textFieldDataFinal = ComponenteFactory.novoTTextField(10, 4);
    private TTextField textFieldSolicitante = ComponenteFactory.novoTTextField(100, 3);
    private TTextField textFieldDataInicialAprovacao = ComponenteFactory.novoTTextField(10, 4);
    private TTextField textFieldDataFinalAprovacao = ComponenteFactory.novoTTextField(10, 4);
    private JLabel labelDataInicial = new JLabel("Data inicial:");
    private JLabel labelDataFinal = new JLabel("Data final:");
    private JLabel labelDataInicialAprovacao = new JLabel("Apr.  inicial:");
    private JLabel labelDataFinalAprovacao = new JLabel("Apr.  final:");
    private JLabel labelSolicitante = new JLabel("Solicitante:");
    private OrcamentoService orcamentoService = new OrcamentoService();
    private ExameMatColetaService exameMatColetaService = new ExameMatColetaService();
    private OrcamentoBean orcamentoBean = new OrcamentoBean();
    private DadosConvenios[] colunasConvenios = null;
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private JLabel legendaVermelha = new JLabel("Or\u00e7amento vencido");
    private JLabel legendaPink = new JLabel("Or\u00e7amento possui requisi\u00e7\u00e3o e se encontra vencido");
    private JLabel legendaAmarela = new JLabel("Or\u00e7amento possui requisi\u00e7\u00e3o");
    private boolean possuiRequisicao = false;

    public OrcamentoAprovado() {
        try {
            this.init();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void init() {
        Funcoes.criaBarraDescricao(this, "Or\u00e7amentos aprovados", "Or\u00e7amentos aprovados", "recepcao/orcamento_aprovado.jpg");
        this.setModuloAcesso(OrcamentoAprovado.getModuloAcesso());
        this.legendaVermelha.setIcon(ImagemUtils.criarImagemLegenda(8, 8, Color.RED, Color.BLACK));
        this.legendaVermelha.setFont(new Font(this.legendaVermelha.getFont().getName(), 0, 8));
        this.legendaAmarela.setIcon(ImagemUtils.criarImagemLegenda(8, 8, Color.YELLOW, Color.BLACK));
        this.legendaAmarela.setFont(new Font(this.legendaAmarela.getFont().getName(), 0, 8));
        this.legendaPink.setIcon(ImagemUtils.criarImagemLegenda(8, 8, Color.PINK, Color.BLACK));
        this.legendaPink.setFont(new Font(this.legendaPink.getFont().getName(), 0, 8));
        this.buttonConsultar.setMnemonic('s');
        this.buttonImprimir.setMnemonic('i');
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.buttonImprimir.setVisible(Acesso.getAcesso(OrcamentoAprovado.getModuloAcessoImprimir()));
        this.menuImprimir.add(this.menuProposta);
        this.menuImprimir.add(this.menuOrcamento);
        this.menuImprimir.add(this.menuInstrucoesColeta);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelOpcoes.add(this.buttonImprimir);
        this.painelOpcoes.add(this.buttonRequisicao);
        this.painelOpcoes.add(this.buttonVisualizaExame);
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)this.painelCrud, "East");
        this.painelCrud.add(this.botaoNovo);
        this.painelCrud.add(this.botaoFechar);
        this.buttonImprimir.addActionListener(this);
        this.buttonConsultar.addActionListener(this);
        this.buttonFiltrarFilial.addActionListener(this);
        this.buttonFiltarUsuario.addActionListener(this);
        String descricaoFiltro = "";
        descricaoFiltro = Variaveis.tipoFilialPadrao.equalsIgnoreCase("V") ? "Animais" : (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") ? "Empresas" : (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C") ? "Pacientes" : "Clientes"));
        this.itemFiltroCliente = new CheckItemFiltro(descricaoFiltro, "Filtrar", "Filtrando " + descricaoFiltro, "fil_codigo = " + Variaveis.filialPadrao, 0, true);
        this.montarPainelFiltro();
        this.tabela.getTableHeader().addMouseListener(this.modelo);
        this.modelo.setColumnSize(new int[]{75, 123, 80, 123, 0, 100}, this.tabela);
        this.tabela.setDefaultRenderer(Object.class, this.renderer);
        this.controlaCampos();
    }

    private void montarPainelFiltro() {
        this.painelCentral.setLayout(new BorderLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 17;
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        Insets insetsOriginal = cons.insets;
        Insets insetsEspaco = new Insets(insetsOriginal.top, 20, insetsOriginal.bottom, insetsOriginal.right);
        this.panelFiltros.setBorder(new TitledBorder("Filtros"));
        this.itemFiltroUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemFiltroUsuario.setTamanhoMinimoCheck(new Dimension(130, 20));
        this.itemFiltroUsuario.setTamanhoPreferidoCheck(new Dimension(130, 20));
        this.itemFiltroCliente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, 1, false, true, false);
        this.itemFiltroCliente.setTamanhoMinimoCheck(new Dimension(130, 20));
        this.itemFiltroCliente.setTamanhoPreferidoCheck(new Dimension(130, 20));
        cons.gridx = 0;
        this.panelUser.add((Component)this.labelDataInicial, cons);
        ++cons.gridx;
        this.textFieldDataInicial.setPreferredSize(new Dimension(87, 20));
        this.textFieldDataInicial.setMinimumSize(new Dimension(87, 20));
        this.panelUser.add((Component)this.textFieldDataInicial, cons);
        ++cons.gridx;
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.panelUser.add((Component)this.buttonDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetsEspaco;
        this.panelUser.add((Component)this.labelDataFinal, cons);
        cons.insets = insetsOriginal;
        ++cons.gridx;
        this.textFieldDataFinal.setPreferredSize(new Dimension(87, 20));
        this.textFieldDataFinal.setMinimumSize(new Dimension(87, 20));
        this.panelUser.add((Component)this.textFieldDataFinal, cons);
        ++cons.gridx;
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.panelUser.add((Component)this.buttonDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetsEspaco;
        this.panelUser.add((Component)this.itemFiltroUsuario, cons);
        cons.insets = insetsOriginal;
        cons.gridx = 0;
        ++cons.gridy;
        this.panelUser.add((Component)this.labelDataInicialAprovacao, cons);
        ++cons.gridx;
        this.textFieldDataInicialAprovacao.setPreferredSize(new Dimension(87, 20));
        this.textFieldDataInicialAprovacao.setMinimumSize(new Dimension(87, 20));
        this.panelUser.add((Component)this.textFieldDataInicialAprovacao, cons);
        ++cons.gridx;
        this.buttonDataInicialAprovacao.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicialAprovacao.setMinimumSize(new Dimension(20, 20));
        this.panelUser.add((Component)this.buttonDataInicialAprovacao, cons);
        ++cons.gridx;
        cons.insets = insetsEspaco;
        this.panelUser.add((Component)this.labelDataFinalAprovacao, cons);
        cons.insets = insetsOriginal;
        ++cons.gridx;
        this.textFieldDataFinalAprovacao.setPreferredSize(new Dimension(87, 20));
        this.textFieldDataFinalAprovacao.setMinimumSize(new Dimension(87, 20));
        this.panelUser.add((Component)this.textFieldDataFinalAprovacao, cons);
        ++cons.gridx;
        this.buttonDataFinalAprovacao.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinalAprovacao.setMinimumSize(new Dimension(20, 20));
        this.panelUser.add((Component)this.buttonDataFinalAprovacao, cons);
        ++cons.gridx;
        cons.insets = insetsEspaco;
        this.panelUser.add((Component)this.itemFiltroCliente, cons);
        cons.insets = insetsOriginal;
        ++cons.gridy;
        cons.gridx = 0;
        this.panelUser.add((Component)this.labelSolicitante, cons);
        ++cons.gridx;
        cons.gridwidth = 5;
        cons.fill = 2;
        this.panelUser.add((Component)this.textFieldSolicitante, cons);
        cons.gridwidth = 1;
        cons.gridx = 6;
        cons.insets = insetsEspaco;
        this.panelUser.add((Component)this.exibiOrcamentoComRequisicao, cons);
        cons.insets = insetsOriginal;
        ++cons.gridx;
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.anchor = 256;
        this.panelUser.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonConsultar), cons);
        this.panelFiltros.add((Component)this.panelUser, "Center");
        this.painelCentral.add((Component)this.panelFiltros, "North");
        this.painelCentral.add((Component)this.scrollPaneTabela, "Center");
        this.painelLegenda.add(this.legendaVermelha);
        this.painelLegenda.add(this.legendaAmarela);
        this.painelLegenda.add(this.legendaPink);
        this.painelCentral.add((Component)this.painelLegenda, "South");
        this.textFieldDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    OrcamentoAprovado.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textFieldDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    OrcamentoAprovado.this.buttonDataFinal.doClick();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            this.abrirMenuImprimirOrcamento();
            this.abrirMenuImprimirProposta();
            this.menuImprimir.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() + this.buttonImprimir.getHeight());
        } else if (e.getSource().equals(this.buttonConsultar)) {
            this.consultar();
        } else if (e.getSource().equals(this.buttonDataInicial)) {
            Funcoes.mostraData(this.textFieldDataInicial, this.buttonDataInicial, this.panelUser, true);
        } else if (e.getSource().equals(this.buttonDataFinal)) {
            Funcoes.mostraData(this.textFieldDataFinal, this.buttonDataFinal, this.panelUser, true);
        } else if (e.getSource().equals(this.buttonDataInicialAprovacao)) {
            Funcoes.mostraData(this.textFieldDataInicialAprovacao, this.buttonDataInicialAprovacao, this.panelUser, true);
        } else if (e.getSource().equals(this.buttonDataFinalAprovacao)) {
            Funcoes.mostraData(this.textFieldDataFinalAprovacao, this.buttonDataFinalAprovacao, this.panelUser, true);
        } else if (e.getSource() == this.menuPadraoOrcamento) {
            this.imprimir(true, null);
        } else if (e.getSource() == this.menuPadraoProposta) {
            this.imprimirProposta(true, null);
        } else if (e.getSource() == this.menuInstrucoesColetaTodosAgrupada || e.getSource() == this.menuInstrucoesColetaTodosPagina) {
            try {
                this.imprimirTodasInstrucoesColeta(e.getSource() == this.menuInstrucoesColetaTodosAgrupada);
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir instru\u00e7\u00f5es de coleta.\n" + e1.getMessage(), e1.getStackTrace());
            }
        } else if (e.getSource() == this.menuInstrucoesColetaSelecionado) {
            try {
                this.imprimirInstrucaoColetadaSelecionada();
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir instru\u00e7\u00f5es de coleta.\n" + e1.getMessage(), e1.getStackTrace());
            }
        } else if (e.getSource() == this.buttonRequisicao) {
            this.criarRequisicao();
        } else if (e.getSource() == this.buttonVisualizaExame) {
            if (this.getLinhaSelecionada() < 0) {
                this.selecioneOrcamento();
                this.focarTabela();
                return;
            }
            ArrayList<OrcamentoConvenioBean> oc = this.getOrcamentoSelecionado().getConvenios();
            this.colunasConvenios = new DadosConvenios[oc.size()];
            for (int i = 0; i < oc.size(); ++i) {
                OrcamentoConvenioBean b = oc.get(i);
                try {
                    this.colunasConvenios[i] = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, b.getConvenio().getCodigo());
                    continue;
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            }
            if (this.colunasConvenios.length == 1) {
                DadosConvenios dados = this.colunasConvenios[0];
                new VisualizaExameOrcamento(this.getTopLevelAncestor(), "Exames do conv\u00eanio - " + dados.getFantasia().toLowerCase(), this.getOrcamentoSelecionado(), dados, true);
            } else {
                boolean ok = true;
                NovoEscolheConvenio ec = new NovoEscolheConvenio((JFrame)this.getTopLevelAncestor(), "Selecionando conv\u00eanio");
                ec.setTipo(3);
                ec.setConvenios(this.colunasConvenios);
                ec.setVisible(true);
                ok = ec.getOK();
                if (ok) {
                    DadosConvenios dados = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                    new VisualizaExameOrcamento(this.getTopLevelAncestor(), "Exames do conv\u00eanio - " + dados.getFantasia().toLowerCase(), this.getOrcamentoSelecionado(), dados, true);
                }
            }
        }
    }

    private boolean validaCampos(boolean mostrarMensagem) {
        if (mostrarMensagem && this.modelo.getRowCount() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 or\u00e7amento", 1);
            return false;
        }
        return true;
    }

    private void criarRequisicao() {
        if (this.getLinhaSelecionada() < 0) {
            this.selecioneOrcamento();
            this.focarTabela();
            return;
        }
        this.orcamentoBean = this.getOrcamentoSelecionado();
        ArrayList<String> listaRequisicoes = new OrcamentoService().verificaOrcamentoUtilizadoLista(this.orcamentoBean);
        String requisicoes = StringUtil.limpaString(listaRequisicoes.toString(), new String[]{"[", "]"});
        if (!Funcoes.textoVazio(requisicoes) && Acesso.getAcesso(OrcamentoAprovado.getModuloAcessoGerarVariasRequisicoes())) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel criar requisi\u00e7\u00f5es, pois as requisi\u00e7\u00f5es " + requisicoes + " j\u00e1 est\u00e3o associadas ao or\u00e7amento.", 2);
            return;
        }
        if (new OrcamentoService().verificaOrcamentoUtilizado(this.orcamentoBean) && !Acesso.getAcesso(OrcamentoAprovado.getModuloAcessoGerarVariasRequisicoes()) && Funcoes.mensagem(this, "H\u00e1 requisi\u00e7\u00f5es associadas \u00e0 este or\u00e7amento.\n Deseja criar novas requisi\u00e7\u00f5es?", 4) == 1) {
            return;
        }
        if (!this.validaCampos(true)) {
            return;
        }
        ArrayList<OrcamentoConvenioBean> oc = this.orcamentoBean.getConvenios();
        this.colunasConvenios = new DadosConvenios[oc.size()];
        for (int i = 0; i < oc.size(); ++i) {
            OrcamentoConvenioBean b = oc.get(i);
            try {
                this.colunasConvenios[i] = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, b.getConvenio().getCodigo());
                continue;
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
        boolean ok = true;
        NovoEscolheConvenio ec = new NovoEscolheConvenio((JFrame)this.getTopLevelAncestor(), "Selecionando conv\u00eanio");
        if (this.colunasConvenios.length > 1) {
            ec.setConvenios(this.colunasConvenios);
            ec.setTipo(1);
            ec.setVisible(true);
            ok = ec.getOK();
        }
        int materialSelecionado = -1;
        int qtdeExames = 0;
        try {
            if (ok && Variaveis.tipoFilialPadrao.equals("A")) {
                DadosConvenios dados = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                HashMap<Integer, MaterialColetaVO> materiais = new HashMap<Integer, MaterialColetaVO>();
                List<OrcamentoConvenioExameBean> orcamentoConvenioExameBeans = this.getExameOrcamentoConvenioSelecionado(dados);
                for (OrcamentoConvenioExameBean orcamentoConvenioExameBean : orcamentoConvenioExameBeans) {
                    if (!materiais.containsKey(orcamentoConvenioExameBean.getMaterial().getCodigo())) {
                        materiais.put(orcamentoConvenioExameBean.getMaterial().getCodigo(), orcamentoConvenioExameBean.getMaterial());
                    }
                    qtdeExames += orcamentoConvenioExameBean.getQuantidadeExame().intValue();
                }
                if (materiais.size() > 1) {
                    SelecionarMaterialAlimentos sel = SelecionarMaterialAlimentos.novaInstancia(this.getTopLevelAncestor());
                    if (sel != null) {
                        for (Integer i : materiais.keySet()) {
                            sel.adicionaMaterial((MaterialColetaVO)materiais.get(i));
                        }
                    }
                    if (sel != null) {
                        sel.setVisible(true);
                        ok = sel.getOK();
                        if (ok) {
                            materialSelecionado = sel.getMaterialSelecionado();
                        }
                    }
                }
                if (materiais.size() == 1) {
                    materialSelecionado = Integer.valueOf(materiais.keySet().toArray()[0].toString());
                }
                HashMap<ExameMatColetaVO, Integer> listaExames = new HashMap<ExameMatColetaVO, Integer>();
                HashMap<ExameMatColetaVO, ObjetoTotalExame> hashMap = new HashMap<ExameMatColetaVO, ObjetoTotalExame>();
                int casasDecimais = ParametrosGerais.getCasasPrecoExame();
                RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
                if (!Funcoes.objectIsNull(dados) && dados.getConvenioUtilizarCasasDecimais()) {
                    casasDecimais = dados.getConvenioCasasPrecoExame();
                    arredondamentoPreco = dados.getConvenioTipoArredondamentoPrecoRoundingMode();
                }
                if (qtdeExames >= 1 || materialSelecionado > -1) {
                    if (qtdeExames > 1) {
                        for (OrcamentoConvenioExameBean bean : orcamentoConvenioExameBeans) {
                            ExameMatColetaVO exameMatColetaVO = (ExameMatColetaVO)this.exameMatColetaService.getVO(Variaveis.filialPadrao, bean.getExame().getCodigo().toString(), bean.getMaterial().getCodigo().toString());
                            ObjetoTotalExame ob = new ObjetoTotalExame(new BigDecimal(bean.getValor().toString()).setScale(casasDecimais, arredondamentoPreco));
                            ob.setArredondamentoPrecoExame(arredondamentoPreco);
                            ob.setCasasPrecoExame(casasDecimais);
                            ob.setNaoPermitido(bean.getNaoPermitido());
                            ob.setValorDesconto(new BigDecimal(bean.getValorDesconto().toString()));
                            ob.setValorAcrescimo(new BigDecimal(bean.getValorAcrescimo().toString()));
                            hashMap.put(exameMatColetaVO, ob);
                            MaterialColetaVO materialVO = bean.getMaterial();
                            if (materialSelecionado > -1 && materialVO != null && materialVO.getCodigo() != materialSelecionado) continue;
                            listaExames.put(exameMatColetaVO, bean.getQuantidadeExame());
                        }
                        JanelaRequisicoesOrcamento janelaRequisicoes = JanelaRequisicoesOrcamento.novaInstancia(this.getTopLevelAncestor());
                        janelaRequisicoes.setConvenioSelecionado(dados);
                        janelaRequisicoes.setMaterialSelecionado(materialSelecionado);
                        janelaRequisicoes.setOrcamentoBean(this.getOrcamentoSelecionado());
                        janelaRequisicoes.setListaValoresExame(hashMap);
                        janelaRequisicoes.setListaExames(listaExames);
                        janelaRequisicoes.setVisible(true);
                        this.controlaCampos();
                    } else {
                        CriarRequisicao_ criarRequisicao = new CriarRequisicao_((Frame)this.getTopLevelAncestor());
                        DadosConvenios dadosConvenio = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                        criarRequisicao.requisicao.setConvenioOrcamento(String.valueOf(dadosConvenio.getCodigo()));
                        criarRequisicao.requisicao.setCodigoOrcamento(this.orcamentoBean.getCodigo());
                        criarRequisicao.requisicao.setPacienteOrcamento(this.getCodigoPaciente());
                        criarRequisicao.requisicao.setDescontoOrcamento(this.orcamentoBean.getValorDesconto().toString());
                        criarRequisicao.requisicao.setAcrescimoOrcamento(this.orcamentoBean.getValorAcrescimo().toString());
                        criarRequisicao.requisicao.setPercentualAcrescimoOrcamento(this.orcamentoBean.getPercentualAcrescimo().toString());
                        criarRequisicao.requisicao.setPercentualDescontoOrcamento(this.orcamentoBean.getPercentualDesconto().toString());
                        List<OrcamentoConvenioExameBean> orcamentoConvenioExameBean = this.getExameOrcamentoConvenioSelecionado(dadosConvenio);
                        for (OrcamentoConvenioExameBean bean : orcamentoConvenioExameBean) {
                            criarRequisicao.requisicao.adicionaExameOrcamento(bean.getExame().getCodigo(), bean.getExame().getDescricao(), ExameUtil.getDadosMaterial(Variaveis.filialPadrao, bean.getMaterial().getCodigo()), bean.getMetodologia(), BigDecimal.valueOf(bean.getValorDesconto()), BigDecimal.valueOf(bean.getValorAcrescimo()));
                        }
                        criarRequisicao.setVisible(true);
                        this.controlaCampos();
                        this.consultar();
                    }
                }
            } else if (ok && !Variaveis.tipoFilialPadrao.equals("A")) {
                CriarRequisicao_ criarRequisicao = new CriarRequisicao_((Frame)this.getTopLevelAncestor());
                DadosConvenios dados = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                criarRequisicao.requisicao.setConvenioOrcamento(String.valueOf(dados.getCodigo()));
                criarRequisicao.requisicao.setCodigoOrcamento(this.orcamentoBean.getCodigo());
                criarRequisicao.requisicao.setPacienteOrcamento(this.getCodigoPaciente());
                criarRequisicao.requisicao.setDescontoOrcamento(this.orcamentoBean.getValorDesconto().toString());
                criarRequisicao.requisicao.setAcrescimoOrcamento(this.orcamentoBean.getValorAcrescimo().toString());
                criarRequisicao.requisicao.setPercentualAcrescimoOrcamento(this.orcamentoBean.getPercentualAcrescimo().toString());
                criarRequisicao.requisicao.setPercentualDescontoOrcamento(this.orcamentoBean.getPercentualDesconto().toString());
                criarRequisicao.requisicao.adicionaTaxasOrcamento(this.orcamentoBean.getTaxas());
                List<OrcamentoConvenioExameBean> orcamentoConvenioExameBeans = this.getExameOrcamentoConvenioSelecionado(dados);
                for (OrcamentoConvenioExameBean orcamentoConvenioExameBean : orcamentoConvenioExameBeans) {
                    criarRequisicao.requisicao.adicionaExameOrcamento(orcamentoConvenioExameBean.getExame().getCodigo(), orcamentoConvenioExameBean.getExame().getDescricao(), ExameUtil.getDadosMaterial(Variaveis.filialPadrao, orcamentoConvenioExameBean.getMaterial().getCodigo()), orcamentoConvenioExameBean.getMetodologia(), BigDecimal.valueOf(orcamentoConvenioExameBean.getValorDesconto()), BigDecimal.valueOf(orcamentoConvenioExameBean.getValorAcrescimo()));
                }
                criarRequisicao.setVisible(true);
                this.controlaCampos();
                this.consultar();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private String getCodigoPaciente() {
        if (this.orcamentoBean.getPaciente() == null) {
            return "";
        }
        return this.orcamentoBean.getPaciente().getCodigo().toString();
    }

    private List<OrcamentoConvenioExameBean> getExameOrcamentoConvenioSelecionado(DadosConvenios dados) {
        ArrayList<OrcamentoConvenioExameBean> orcamentoConvenioExameBeans = new ArrayList<OrcamentoConvenioExameBean>();
        for (OrcamentoConvenioBean orcamentoConvenioBean : this.getOrcamentoSelecionado().getConvenios()) {
            if (orcamentoConvenioBean.getConvenio().getCodigo().intValue() != dados.getCodigo()) continue;
            orcamentoConvenioExameBeans.addAll(orcamentoConvenioBean.getExames());
            break;
        }
        return orcamentoConvenioExameBeans;
    }

    private void focarTabela() {
        this.tabela.getSelectionModel().setSelectionInterval(-1, -1);
        ScreenUtil.requisitarFoco(this.tabela);
    }

    private void selecioneOrcamento() {
        Funcoes.mensagem(this, "Selecione um or\u00e7amento.", 2);
    }

    private OrcamentoBean getOrcamentoSelecionado() {
        if (this.getLinhaSelecionada() > -1) {
            this.orcamentoBean = (OrcamentoBean)this.modelo.getValueAt(this.getLinhaSelecionada(), 6);
        }
        return this.orcamentoBean;
    }

    private int getLinhaSelecionada() {
        return this.tabela.getSelectedRow();
    }

    private void imprimirInstrucaoColetadaSelecionada() throws SQLException {
        try {
            if (this.getLinhaSelecionada() == -1) {
                return;
            }
            ArrayList<OrcamentoConvenioBean> oc = this.getOrcamentoSelecionado().getConvenios();
            this.colunasConvenios = new DadosConvenios[oc.size()];
            for (int i = 0; i < oc.size(); ++i) {
                OrcamentoConvenioBean b = oc.get(i);
                this.colunasConvenios[i] = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, b.getConvenio().getCodigo());
            }
            boolean ok = true;
            NovoEscolheConvenio ec = new NovoEscolheConvenio((JFrame)this.getTopLevelAncestor(), "Selecionando conv\u00eanio");
            ec.setConvenios(this.colunasConvenios);
            ec.setTipo(3);
            ec.setVisible(true);
            ok = ec.getOK();
            if (ok) {
                DadosConvenios dados = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                VisualizaExameOrcamento visualizaExameOrcamento = new VisualizaExameOrcamento(this.getTopLevelAncestor(), "Exames do or\u00e7amento selecionado", this.getOrcamentoSelecionado(), dados, false);
                if (!visualizaExameOrcamento.getOK()) {
                    return;
                }
                OrcamentoConvenioExameBean exameConvenio = visualizaExameOrcamento.getOrcamentoConvenioExameBeanSelcionado();
                if (exameConvenio == null) {
                    return;
                }
                ExameMatColetaVO exame = (ExameMatColetaVO)this.exameMatColetaService.getVO(Variaveis.filialPadrao, exameConvenio.getExame().getCodigo().toString(), exameConvenio.getMaterial().getCodigo().toString());
                if (exame == null || exame.getInstrucoesColeta() == null || Funcoes.textoVazio(exame.getInstrucoesColeta())) {
                    return;
                }
                Statement st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder();
                buf.append(" select lay_geral ");
                buf.append("   from layout ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and lay_codigo = ").append(ParametrosGerais.getLayCodigo());
                ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
                if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_geral"))) {
                    String layout = rsLayout.getString("lay_geral");
                    Impressao impressao = new Impressao(ParametrosLocais.getParametro("impressoraInstrucaoColeta"));
                    Documento doc = new Documento();
                    doc.setSempreReposicionarEntrePaginas(true);
                    doc.setCabecalhoRodape(layout);
                    doc.addResultados(null, new String[]{new Resultado(exame.getInstrucoesColeta()).getResultado()});
                    impressao.imprimir(doc);
                    impressao = null;
                } else {
                    Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
                }
                rsLayout.close();
                st.close();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void imprimirTodasInstrucoesColeta(boolean agrupada) throws SQLException {
        try {
            ArrayList<OrcamentoConvenioBean> oc = this.getOrcamentoSelecionado().getConvenios();
            this.colunasConvenios = new DadosConvenios[oc.size()];
            for (int i = 0; i < oc.size(); ++i) {
                OrcamentoConvenioBean b = oc.get(i);
                this.colunasConvenios[i] = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, b.getConvenio().getCodigo());
            }
            boolean ok = true;
            NovoEscolheConvenio ec = new NovoEscolheConvenio((JFrame)this.getTopLevelAncestor(), "Selecionando conv\u00eanio");
            ec.setConvenios(this.colunasConvenios);
            ec.setTipo(2);
            ec.setVisible(true);
            ok = ec.getOK();
            if (ok) {
                Statement st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder();
                buf.append(" select lay_geral ");
                buf.append("   from layout ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and lay_codigo = ").append(ParametrosGerais.getLayCodigo());
                DadosConvenios dados = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
                if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_geral"))) {
                    String layout = rsLayout.getString("lay_geral");
                    Impressao impressao = new Impressao(ParametrosLocais.getParametro("impressoraInstrucaoColeta"));
                    Documento doc = new Documento();
                    doc.setSempreReposicionarEntrePaginas(true);
                    doc.setCabecalhoRodape(layout);
                    ArrayList<String> resultadoInstrucao = new ArrayList<String>();
                    ArrayList<ExameMaterialPagina> examePaginaInstrucao = new ArrayList<ExameMaterialPagina>();
                    for (OrcamentoConvenioExameBean exameConvenio : this.getExameOrcamentoConvenioSelecionado(dados)) {
                        ExameMatColetaVO exame = (ExameMatColetaVO)this.exameMatColetaService.getVO(Variaveis.filialPadrao, exameConvenio.getExame().getCodigo().toString(), exameConvenio.getMaterial().getCodigo().toString());
                        if (exame == null || exame.getInstrucoesColeta() == null || Funcoes.textoVazio(exame.getInstrucoesColeta())) continue;
                        if (!agrupada) {
                            doc.addResultados(null, new String[]{new Resultado(exame.getInstrucoesColeta()).getResultado()});
                            continue;
                        }
                        String tmp = new Resultado(exame.getInstrucoesColeta()).getResultado();
                        if (this.textoAdicionado(resultadoInstrucao, tmp)) continue;
                        resultadoInstrucao.add(tmp);
                        examePaginaInstrucao.add(new ExameMaterialPagina(exame.getExame().getCodigo(), exame.getMaterial().getCodigo(), null));
                    }
                    if (agrupada) {
                        doc.addResultados(examePaginaInstrucao.toArray(new ExameMaterialPagina[examePaginaInstrucao.size()]), resultadoInstrucao.toArray(new String[resultadoInstrucao.size()]));
                    }
                    impressao.imprimir(doc);
                    impressao = null;
                } else {
                    Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
                }
                rsLayout.close();
                st.close();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean textoAdicionado(ArrayList<String> lista, String texto) {
        boolean retorno = false;
        if (null != lista) {
            for (String s : lista) {
                if (!s.equalsIgnoreCase(texto)) continue;
                retorno = true;
                break;
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultar() {
        SplashMensagem mensagem = SplashMensagem.getInstancia(this);
        mensagem.mostrar("Aguarde...");
        try {
            this.modelo.clear();
            this.renderer.limpar();
            Set<OrcamentoBean> orcamentoBeans = this.orcamentoService.loadAprovados(this.textFieldDataFinal.getText(), this.textFieldDataFinalAprovacao.getText(), this.textFieldDataInicial.getText(), this.textFieldDataInicialAprovacao.getText(), this.textFieldSolicitante.getText(), this.getUsuariosSelecionados(), this.textFieldSolicitante.getText(), this.getClientesSelecionados());
            if (orcamentoBeans != null) {
                boolean vencido;
                boolean possuiRequisicao;
                for (OrcamentoBean orcamentoBean : orcamentoBeans) {
                    possuiRequisicao = new OrcamentoService().verificaOrcamentoUtilizado(orcamentoBean);
                    vencido = false;
                    if (orcamentoBean.getValidade() != null && !orcamentoBean.getValidade().isEmpty()) {
                        Date vencimento = Funcoes.stringToDate("dd/MM/yyyy", orcamentoBean.getValidade());
                        Date hoje = Funcoes.stringToDate("dd/MM/yyyy", Funcoes.formataData("dd/MM/yyyy", Calendar.getInstance().getTime()));
                        vencido = hoje.after(vencimento);
                    }
                    if (this.exibiOrcamentoComRequisicao.isSelected() && !possuiRequisicao || !this.exibiOrcamentoComRequisicao.isSelected() && possuiRequisicao) continue;
                    boolean possuiRequisicaoVencido = possuiRequisicao && vencido;
                    this.modelo.addLine(new Object[]{orcamentoBean.getCodigo(), Funcoes.formataData("dd/MM/yyyy HH:mm", orcamentoBean.getDataHora()), orcamentoBean.getUsuarioAprovacao().getCodigo(), Funcoes.formataData("dd/MM/yyyy HH:mm", orcamentoBean.getDataHoraAprovacao()), orcamentoBean.getSolicitante(), orcamentoBean.getValidade(), orcamentoBean, possuiRequisicaoVencido, possuiRequisicao, vencido});
                }
                this.modelo.ordenarColunaSemTrocarSentido(0);
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    boolean possuiRequisicaoVencido = (Boolean)this.modelo.getValueAt(i, 7);
                    possuiRequisicao = (Boolean)this.modelo.getValueAt(i, 8);
                    vencido = (Boolean)this.modelo.getValueAt(i, 9);
                    if (possuiRequisicaoVencido) {
                        this.renderer.setCorLinha(Color.PINK, i);
                        continue;
                    }
                    if (possuiRequisicao) {
                        this.renderer.setCorLinha(Color.YELLOW, i);
                        continue;
                    }
                    if (!vencido) continue;
                    this.renderer.setCorLinha(Color.RED, i);
                }
            }
            if (orcamentoBeans != null && !orcamentoBeans.isEmpty()) {
                this.focarTabela();
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar or\u00e7amentos", e.getStackTrace());
        }
        finally {
            mensagem.apagar();
            this.controlaCampos();
        }
    }

    private String getUsuariosSelecionados() {
        StringBuilder users = new StringBuilder();
        if (this.itemFiltroUsuario.getSelecionados(0) == null) {
            return "";
        }
        for (String registro : this.itemFiltroUsuario.getSelecionados(0)) {
            users.append("'");
            users.append(registro);
            users.append("'");
            users.append(",");
        }
        return users.toString().substring(0, users.length() - 1);
    }

    private String getClientesSelecionados() {
        StringBuilder cliente = new StringBuilder();
        if (this.itemFiltroCliente.getSelecionadosAvancado(0) == null || !this.itemFiltroCliente.isSelected()) {
            return "";
        }
        for (String registro : this.itemFiltroCliente.getSelecionadosAvancado(0)) {
            cliente.append(registro);
            cliente.append(",");
        }
        return cliente.toString().substring(0, cliente.length() - 1);
    }

    private void abrirMenuImprimirOrcamento() {
        this.menuOrcamento.removeAll();
        this.menuOrcamento.add(this.menuPadraoOrcamento);
        try {
            Set layouts = new LayoutService().loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
            if (layouts != null) {
                ArrayList array = new ArrayList(layouts);
                Collections.sort(array, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof LayoutVO && o2 instanceof LayoutVO) {
                            return ((LayoutVO)o1).getDescricao().compareTo(((LayoutVO)o2).getDescricao());
                        }
                        return 0;
                    }
                });
                for (LayoutVO vo : array) {
                    ItemMenuImpressao menuSel = new ItemMenuImpressao(vo);
                    menuSel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OrcamentoAprovado.this.imprimir(false, (ItemMenuImpressao)e.getSource());
                        }
                    });
                    this.menuOrcamento.add(menuSel);
                }
            }
        }
        catch (Exception ex) {
            this.menuImprimir.remove(this.menuOrcamento);
        }
    }

    private void abrirMenuImprimirProposta() {
        this.menuProposta.removeAll();
        this.menuProposta.add(this.menuPadraoProposta);
        try {
            Set layouts = new LayoutService().loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
            if (layouts != null) {
                ArrayList array = new ArrayList(layouts);
                Collections.sort(array, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof LayoutVO && o2 instanceof LayoutVO) {
                            return ((LayoutVO)o1).getDescricao().compareTo(((LayoutVO)o2).getDescricao());
                        }
                        return 0;
                    }
                });
                for (LayoutVO vo : array) {
                    ItemMenuImpressao menuSel = new ItemMenuImpressao(vo);
                    menuSel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OrcamentoAprovado.this.imprimirProposta(false, (ItemMenuImpressao)e.getSource());
                        }
                    });
                    this.menuProposta.add(menuSel);
                }
            }
        }
        catch (Exception ex) {
            this.menuImprimir.remove(this.menuProposta);
        }
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0200200100");
    }

    public static long getModuloAcessoImprimir() {
        return Long.valueOf("0200200101");
    }

    public static long getModuloAcessoGerarVariasRequisicoes() {
        return Long.valueOf("0200200102");
    }

    private void imprimir(boolean usarPadrao, ItemMenuImpressao item) {
        ArrayList<OrcamentoConvenioBean> oc = this.getOrcamentoSelecionado().getConvenios();
        this.colunasConvenios = new DadosConvenios[oc.size()];
        for (int i = 0; i < oc.size(); ++i) {
            OrcamentoConvenioBean b = oc.get(i);
            try {
                this.colunasConvenios[i] = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, b.getConvenio().getCodigo());
                continue;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
        }
        int posicaoConvenio = Orcamento.QTDE_COLUNAS_FIXAS + 1;
        boolean ok = true;
        NovoEscolheConvenio ec = new NovoEscolheConvenio((JFrame)this.getTopLevelAncestor(), "Selecionando conv\u00eanio");
        ec.setConvenios(this.colunasConvenios);
        ec.setTipo(2);
        ec.setVisible(true);
        ok = ec.getOK();
        if (ok) {
            try {
                OrcamentoConvenioExameBean exameConvenio4;
                this.orcamentoBean = this.getOrcamentoSelecionado();
                DadosConvenios dadosConvenios = this.colunasConvenios[this.colunasConvenios.length > 1 ? ec.getPosicaoSelecionada() : 0];
                int casasDecimais = ParametrosGerais.getCasasPrecoExame();
                RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
                if (!Funcoes.objectIsNull(dadosConvenios) && dadosConvenios.getConvenioUtilizarCasasDecimais()) {
                    casasDecimais = dadosConvenios.getConvenioCasasPrecoExame();
                    arredondamentoPreco = dadosConvenios.getConvenioTipoArredondamentoPrecoRoundingMode();
                }
                ModeloGridTable modeloImpressao = new ModeloGridTable(ArraysUtil.concatenar(jalis.laboratorio.util.impressao.Impressao.CAMPOS_ORCAMENTO, new String[]{"ordenarcolunainmetro"}));
                FilialBean filial = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
                LayoutBean layout = (LayoutBean)new LayoutService().get(Variaveis.filialPadrao, usarPadrao ? String.valueOf(ParametrosGerais.getLayCodigo()) : String.valueOf(item.getLayoutVO().getCodigo()));
                RetornoDesconto desconto = new RetornoDesconto(7);
                desconto.setPercentual(BigDecimal.valueOf(this.orcamentoBean.getPercentualDesconto()));
                desconto.setValor(BigDecimal.valueOf(this.orcamentoBean.getValorDesconto()));
                RetornoAcrescimo acrescimo = new RetornoAcrescimo();
                acrescimo.setPercentual(BigDecimal.valueOf(this.orcamentoBean.getPercentualAcrescimo()));
                acrescimo.setValor(BigDecimal.valueOf(this.orcamentoBean.getValorAcrescimo()));
                UsuarioBean usuarioBean = (UsuarioBean)new UsuarioService().get(this.orcamentoBean.getCodigo().toString());
                UsuarioBean usuarioLogado = (UsuarioBean)new UsuarioService().get(Variaveis.login);
                StringBuilder referencias = new StringBuilder();
                for (OrcamentoConvenioExameBean exameConvenio3 : this.getExameOrcamentoConvenioSelecionado(dadosConvenios)) {
                    ExameMatColetaVO exame = (ExameMatColetaVO)this.exameMatColetaService.getVO(Variaveis.filialPadrao, exameConvenio3.getExame().getCodigo().toString(), exameConvenio3.getMaterial().getCodigo().toString());
                    if (exame == null || exame.getMetodologia() == null || Funcoes.textoVazio(exame.getMetodologia().getReferencia()) || referencias.indexOf(exame.getMetodologia().getReferencia()) >= 0) continue;
                    referencias.append("\n").append(exame.getMetodologia().getReferencia());
                }
                BigDecimal valorTotal = BigDecimal.ZERO;
                BigDecimal valorTotalOrcamento = BigDecimal.ZERO;
                for (OrcamentoConvenioExameBean orcamentoConvenioExameBean : this.getExameOrcamentoConvenioSelecionado(dadosConvenios)) {
                    ObjetoTotalExame ob = new ObjetoTotalExame(new BigDecimal(orcamentoConvenioExameBean.getValor().toString()).setScale(casasDecimais, arredondamentoPreco));
                    ob.setCasasPrecoExame(casasDecimais);
                    ob.setArredondamentoPrecoExame(arredondamentoPreco);
                    ob.setNaoPermitido(orcamentoConvenioExameBean.getNaoPermitido());
                    BigDecimal total = ob.getValorTotal();
                    if (ob.getNaoPermitido()) continue;
                    valorTotal = valorTotal.add(total);
                }
                boolean temExameCertificadoInmetro = false;
                Iterator<OrcamentoConvenioExameBean> iterator = this.getExameOrcamentoConvenioSelecionado(dadosConvenios).iterator();
                while (iterator.hasNext() && !(temExameCertificadoInmetro = (exameConvenio4 = iterator.next()).getExame().isInmetro().booleanValue())) {
                }
                for (OrcamentoConvenioExameBean exameConvenio : this.getExameOrcamentoConvenioSelecionado(dadosConvenios)) {
                    ExameMatColetaVO exame = (ExameMatColetaVO)this.exameMatColetaService.getVO(Variaveis.filialPadrao, exameConvenio.getExame().getCodigo().toString(), exameConvenio.getMaterial().getCodigo().toString());
                    ObjetoTotalExame ob = new ObjetoTotalExame(new BigDecimal(exameConvenio.getValor().toString()).setScale(casasDecimais, arredondamentoPreco));
                    ob.setCasasPrecoExame(casasDecimais);
                    ob.setArredondamentoPrecoExame(arredondamentoPreco);
                    ob.setNaoPermitido(exameConvenio.getNaoPermitido());
                    ob.setValorDesconto(BigDecimal.valueOf(exameConvenio.getValorDesconto()));
                    ob.setValorAcrescimo(BigDecimal.valueOf(exameConvenio.getValorAcrescimo()));
                    Object[] linha = new Object[modeloImpressao.getColumnCount()];
                    for (String s : jalis.laboratorio.util.impressao.Impressao.CAMPOS_ORCAMENTO) {
                        int col = modeloImpressao.findColumn(s);
                        if (col <= -1) continue;
                        if (s.equalsIgnoreCase("codigoExame")) {
                            linha[col] = exame.getExame().getCodigo();
                            continue;
                        }
                        if (s.equalsIgnoreCase("descricaoExame")) {
                            linha[col] = exame.getExame().getDescricao();
                            continue;
                        }
                        if (s.equalsIgnoreCase("materialColetadoExame")) {
                            linha[col] = exame.getMaterial().getDescricao();
                            continue;
                        }
                        if (s.equalsIgnoreCase("abreviaturaMaterialColetadoExame")) {
                            linha[col] = exame.getMaterial().getAbreviatura();
                            continue;
                        }
                        if (s.equalsIgnoreCase("certificadoInmetroExame")) {
                            linha[col] = exame.getExame().isInmetro();
                            continue;
                        }
                        if (s.equalsIgnoreCase("limiteDeDeteccaoExame")) {
                            linha[col] = exame.getLimiteDeDeteccao();
                            continue;
                        }
                        if (s.equalsIgnoreCase("precoExame")) {
                            linha[col] = ob.getValorTotal().setScale(2, arredondamentoPreco);
                            continue;
                        }
                        if (s.equalsIgnoreCase("senhaWebConvenio")) {
                            linha[col] = dadosConvenios.getSenhaWebConvenio();
                            continue;
                        }
                        if (s.equalsIgnoreCase("fantasiaConvenio")) {
                            linha[col] = dadosConvenios.getFantasia();
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoConvenio")) {
                            linha[col] = dadosConvenios.getCodigo();
                            continue;
                        }
                        if (s.equalsIgnoreCase("cnpjCpfConvenio")) {
                            linha[col] = dadosConvenios.getCnpj();
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoFilial")) {
                            linha[col] = filial.getCodigo();
                            continue;
                        }
                        if (s.equalsIgnoreCase("razaoSocialFilial")) {
                            linha[col] = filial.getRazaoSocial();
                            continue;
                        }
                        if (s.equalsIgnoreCase("descricaoFilial")) {
                            linha[col] = filial.getDescricao();
                            continue;
                        }
                        if (s.equalsIgnoreCase("foneFilial")) {
                            linha[col] = filial.getFone();
                            continue;
                        }
                        if (s.equalsIgnoreCase("nomeCidade")) {
                            linha[col] = filial.getCidade() != null ? this.getDescricaoNomeCidadeFilial(filial) : "";
                            continue;
                        }
                        if (s.equalsIgnoreCase("estadoCidade")) {
                            linha[col] = filial.getCidade() != null ? this.getDescricaoUfCidadeFilial(filial) : "";
                            continue;
                        }
                        if (s.equalsIgnoreCase("cnpjFilial")) {
                            linha[col] = filial.getCnpj();
                            continue;
                        }
                        if (s.equalsIgnoreCase("enderecoFilial")) {
                            linha[col] = filial.getEndereco();
                            continue;
                        }
                        if (s.equalsIgnoreCase("complementoFilial")) {
                            linha[col] = filial.getComplemento();
                            continue;
                        }
                        if (s.equalsIgnoreCase("nomeBairro")) {
                            linha[col] = filial.getBairro() != null ? this.getDescricaoBairroFilial(filial) : "";
                            continue;
                        }
                        if (s.equalsIgnoreCase("faxFilial")) {
                            linha[col] = filial.getFax();
                            continue;
                        }
                        if (s.equalsIgnoreCase("cepFilial")) {
                            linha[col] = filial.getCep();
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoUsuario")) {
                            linha[col] = usuarioLogado != null ? usuarioLogado.getCodigo() : Variaveis.login;
                            continue;
                        }
                        if (s.equalsIgnoreCase("nomeUsuario")) {
                            linha[col] = usuarioBean != null ? usuarioBean.getNome() : Variaveis.nomeUsuario;
                            continue;
                        }
                        if (s.equalsIgnoreCase("assinaturaUsuario")) {
                            linha[col] = usuarioBean != null ? usuarioBean.getAssinatura() : Variaveis.nomeUsuario;
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoUsuarioLogado")) {
                            linha[col] = usuarioLogado != null ? usuarioLogado.getCodigo() : Variaveis.login;
                            continue;
                        }
                        if (s.equalsIgnoreCase("nomeUsuarioLogado")) {
                            linha[col] = usuarioLogado != null ? usuarioLogado.getNome() : Variaveis.nomeUsuario;
                            continue;
                        }
                        if (s.equalsIgnoreCase("assinaturaUsuarioLogado")) {
                            linha[col] = usuarioLogado != null ? usuarioLogado.getAssinatura() : Variaveis.nomeUsuario;
                            continue;
                        }
                        if (s.equalsIgnoreCase("dataHoraOrcamento")) {
                            linha[col] = Funcoes.formataData("dd/MM/yyyy HH:mm", this.orcamentoBean.getDataHora());
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoOrcamento")) {
                            linha[col] = this.orcamentoBean.getCodigo();
                            continue;
                        }
                        if (s.equalsIgnoreCase("cnpjEmpresa")) {
                            String cnpj = "";
                            if (!Funcoes.objectIsNull(this.orcamentoBean.getPaciente())) {
                                cnpj = this.orcamentoBean.getPaciente().getCNPJ();
                            }
                            linha[col] = cnpj;
                            continue;
                        }
                        if (s.equalsIgnoreCase("cpfPaciente")) {
                            String cpf = "";
                            if (!Funcoes.objectIsNull(this.orcamentoBean.getPaciente())) {
                                cpf = this.orcamentoBean.getPaciente().getCpf();
                            }
                            linha[col] = cpf;
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoPaciente")) {
                            linha[col] = this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getCodigo() : "";
                            continue;
                        }
                        if (s.equalsIgnoreCase("nomePaciente")) {
                            linha[col] = this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getNome() : "";
                            continue;
                        }
                        if (s.equalsIgnoreCase("solicitanteOrcamento")) {
                            linha[col] = this.orcamentoBean.getSolicitante();
                            continue;
                        }
                        if (s.equalsIgnoreCase("proprietarioOrcamento")) {
                            linha[col] = this.orcamentoBean.getProprietario();
                            continue;
                        }
                        if (s.equalsIgnoreCase("animalOrcamento")) {
                            linha[col] = this.orcamentoBean.getSolicitante();
                            continue;
                        }
                        if (s.equalsIgnoreCase("foneOrcamento")) {
                            linha[col] = this.orcamentoBean.getFone();
                            continue;
                        }
                        if (s.equalsIgnoreCase("contatoOrcamento")) {
                            linha[col] = this.orcamentoBean.getFoneContato();
                            continue;
                        }
                        if (s.equalsIgnoreCase("foneContatoOrcamento")) {
                            linha[col] = this.orcamentoBean.getFoneContato();
                            continue;
                        }
                        if (s.equalsIgnoreCase("emailOrcamento")) {
                            linha[col] = this.orcamentoBean.getEmail();
                            continue;
                        }
                        if (s.equalsIgnoreCase("validadeOrcamento")) {
                            linha[col] = this.orcamentoBean.getValidade();
                            continue;
                        }
                        if (s.equalsIgnoreCase("observacaoOrcamento")) {
                            linha[col] = this.orcamentoBean.getObservacao();
                            continue;
                        }
                        if (s.equalsIgnoreCase("codigoPrazoEntregaExame")) {
                            linha[col] = exame.getPrazoEntrega() != null ? exame.getPrazoEntrega().getCodigo() : "9090";
                            continue;
                        }
                        if (s.equalsIgnoreCase("descricaoPrazoEntregaExame")) {
                            linha[col] = exame.getPrazoEntrega() != null ? exame.getPrazoEntrega().getDescricao() : "9090";
                            continue;
                        }
                        if (s.equalsIgnoreCase("referenciaExame")) {
                            linha[col] = exame.getMetodologia().getReferencia();
                            continue;
                        }
                        if (s.equalsIgnoreCase("referenciasExames")) {
                            linha[col] = referencias.toString();
                            continue;
                        }
                        if (s.equalsIgnoreCase("ambExame")) {
                            linha[col] = this.getCodigoAMBConvenio(filial.getCodigo().toString(), String.valueOf(dadosConvenios.getCodigo()), exame.getExame().getCodigo(), exame.getMaterial().getCodigo().toString(), exame.getMetodologia().getCodigo());
                            continue;
                        }
                        if (s.equalsIgnoreCase("possuiExameCertificadoInmetro")) {
                            linha[col] = temExameCertificadoInmetro;
                            continue;
                        }
                        if (s.equalsIgnoreCase("valorDescontoExame")) {
                            linha[col] = ob.getValorDesconto().setScale(2, arredondamentoPreco);
                            continue;
                        }
                        if (s.equalsIgnoreCase("valorAcrescimoExame")) {
                            linha[col] = ob.getValorAcrescimo().setScale(2, arredondamentoPreco);
                            continue;
                        }
                        if (s.equalsIgnoreCase("terceirizado")) {
                            ExameTerceirizadoBean exameTerceirizadoBean = new ExameTerceirizadoBean();
                            exameTerceirizadoBean.setFilialCodigo(filial != null && filial.getCodigo() != null ? filial.getCodigo().toString() : "");
                            exameTerceirizadoBean.setExameCodigo(exame != null && exame.getExame() != null && exame.getExame().getCodigo() != null ? exame.getExame().getCodigo() : "");
                            exameTerceirizadoBean.setMaterialColetado(exame != null && exame.getMaterial() != null ? exame.getMaterial().getCodigo().toString() : "");
                            exameTerceirizadoBean.setMetodologia(exame != null && exame.getMetodologia() != null && exame.getMetodologia().getCodigo() != null ? exame.getMetodologia().getCodigo().toString() : "");
                            linha[col] = new OrcamentoService().consultaTerceirizazao(exameTerceirizadoBean);
                            continue;
                        }
                        if (s.equalsIgnoreCase("valorUnitarioExame")) {
                            linha[col] = ob.getValorTotal().divide(new BigDecimal(exameConvenio.getQuantidadeExame())).setScale(2, arredondamentoPreco);
                            continue;
                        }
                        if (s.equalsIgnoreCase("quantidadeExameOrcamento")) {
                            linha[col] = exameConvenio.getQuantidadeExame();
                            continue;
                        }
                        if (!s.equalsIgnoreCase("celularPaciente")) continue;
                        linha[col] = this.orcamentoBean.getFone();
                    }
                    int pos = -1;
                    pos = modeloImpressao.findColumn("valorDesconto");
                    if (desconto != null && desconto.getPercentual().doubleValue() > 0.0 && desconto.getValor().doubleValue() <= 0.0) {
                        valorTotal = this.verificaValorMinimoRequisicao(dadosConvenios, valorTotal.setScale(casasDecimais, arredondamentoPreco)).setScale(casasDecimais, arredondamentoPreco);
                        linha[pos] = this.calcularPercentual(desconto.getPercentual(), valorTotal, casasDecimais, arredondamentoPreco).setScale(2, arredondamentoPreco);
                        pos = modeloImpressao.findColumn("percentualDesconto");
                        linha[pos] = desconto.getPercentual();
                    } else {
                        linha[pos] = desconto.getValor().setScale(2, arredondamentoPreco);
                        pos = modeloImpressao.findColumn("percentualDesconto");
                        BigDecimal valor = this.calcularValorPorPercentual(desconto.getValor(), valorTotal);
                        linha[pos] = valor.doubleValue();
                    }
                    pos = modeloImpressao.findColumn("valorAcrescimo");
                    if (acrescimo != null && acrescimo.getPercentual().doubleValue() > 0.0 && acrescimo.getValor().doubleValue() <= 0.0) {
                        valorTotal = this.verificaValorMinimoRequisicao(dadosConvenios, valorTotal.setScale(casasDecimais, arredondamentoPreco)).setScale(casasDecimais, arredondamentoPreco);
                        linha[pos] = this.calcularPercentual(acrescimo.getPercentual(), valorTotal, casasDecimais, arredondamentoPreco).setScale(2, arredondamentoPreco);
                        pos = modeloImpressao.findColumn("percentualAcrescimo");
                        linha[pos] = acrescimo.getPercentual();
                    } else {
                        linha[pos] = acrescimo.getValor().setScale(2, arredondamentoPreco);
                        pos = modeloImpressao.findColumn("percentualAcrescimo");
                        BigDecimal valor = this.calcularValorPorPercentual(acrescimo.getValor(), valorTotal);
                        linha[pos] = valor.doubleValue();
                    }
                    if (valorTotal != null) {
                        desconto.setValor(this.calcularPercentual(desconto.getPercentual(), valorTotal, 2, arredondamentoPreco));
                    }
                    acrescimo.setValor(this.calcularPercentual(acrescimo.getPercentual(), valorTotal, 2, arredondamentoPreco));
                    if (valorTotal != null && valorTotalOrcamento.doubleValue() == 0.0) {
                        BigDecimal valorMinimo = new BigDecimal(dadosConvenios.getValorAdicionalMinimoRequisicao());
                        valorTotalOrcamento = valorTotal.doubleValue() < valorMinimo.doubleValue() ? valorMinimo : valorTotal;
                        if (acrescimo != null) {
                            valorTotalOrcamento = valorTotalOrcamento.add(acrescimo.getValor());
                        }
                        if (desconto != null) {
                            valorTotalOrcamento = valorTotalOrcamento.subtract(desconto.getValor());
                        }
                        if (valorTotalOrcamento.doubleValue() < valorMinimo.doubleValue()) {
                            valorTotalOrcamento = valorMinimo;
                        }
                    }
                    if (exameConvenio.getNaoPermitido().booleanValue()) continue;
                    int posicao = modeloImpressao.findColumn("valorTotalOrcamento");
                    linha[posicao] = valorTotalOrcamento.setScale(2, arredondamentoPreco);
                    String tmp = (exame.getExame().isInmetro() != false ? "a" : "z") + modeloImpressao.getRowCount();
                    linha[modeloImpressao.findColumn((String)"ordenarcolunainmetro")] = tmp;
                    modeloImpressao.addLine(linha);
                }
                if (layout == null || layout != null && Funcoes.textoVazio(layout.getOrcamento())) {
                    Funcoes.mensagem(this, "Modelo de or\u00e7amento n\u00e3o definido", 1);
                    return;
                }
                modeloImpressao.ordenarColunas(modeloImpressao.findColumn("ordenarcolunainmetro"));
                String string = layout.getOrcamento();
                Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                gerador.setPreVisualizar(true);
                gerador.executar(string, modeloImpressao);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private BigDecimal verificaValorMinimoRequisicao(DadosConvenios convenio, BigDecimal total) {
        if (convenio.getValorMinimoRequisicao() > 0.0 && total.compareTo(new BigDecimal(convenio.getValorMinimoRequisicao())) < 0) {
            return new BigDecimal(String.valueOf(convenio.getValorAdicionalMinimoRequisicao()));
        }
        return total;
    }

    private BigDecimal calcularPercentual(BigDecimal valor, BigDecimal valorTotal, int casas, RoundingMode round) {
        return valorTotal.multiply(valor).divide(new BigDecimal(100)).setScale(casas, round);
    }

    private BigDecimal calcularValorPorPercentual(BigDecimal valorPercentual, BigDecimal valorTotal) {
        BigDecimal p = valorPercentual.multiply(new BigDecimal(100));
        if (p.compareTo(BigDecimal.ZERO) > 0) {
            p = p.divide(valorTotal, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCodigoAMBConvenio(String filial, String codigoConvenio, String codigoExame, String codigoMaterial, Integer codigoMetodologia) {
        String retorno;
        Statement st;
        block6: {
            st = Conexao.getStatement();
            retorno = "";
            try {
                StringBuilder buf = new StringBuilder();
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" select COALESCE(NULLIF(a.dtm_codamb, ''), dtp.dtp_codamb) as dtp_codamb ");
                    buf.append("   from convenios b ");
                    buf.append("   left join detalhetabelaprecometodologia a on b.fil_codigo = a.fil_codigo and b.tpe_codigo = a.tpe_codigo and a.exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' and a.mco_codigo = ").append(codigoMaterial).append(" and a.met_codigo = ").append(codigoMetodologia);
                    buf.append("   left join detalhetabelapreco dtp on b.fil_codigo = dtp.fil_codigo and b.tpe_codigo = dtp.tpe_codigo and dtp.exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' and dtp.mco_codigo = ").append(codigoMaterial);
                    buf.append("  where b.fil_codigo = ").append(filial);
                    buf.append("    and b.con_codigo = ").append(codigoConvenio);
                } else {
                    buf.append(" select a.dtp_codamb ");
                    buf.append("   from convenios b ");
                    buf.append("   left join detalhetabelapreco a on b.fil_codigo = a.fil_codigo and b.tpe_codigo = a.tpe_codigo ");
                    buf.append("    and a.exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' ");
                    buf.append("    and a.mco_codigo = ").append(codigoMaterial);
                    buf.append("  where a.fil_codigo = ").append(filial);
                    buf.append("    and b.con_codigo = ").append(codigoConvenio);
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block6;
                retorno = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Orcamento (1728)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void imprimirProposta(boolean usarPadrao, ItemMenuImpressao item) {
        try {
            UsuarioBean usuarioLogado = null;
            usuarioLogado = (UsuarioBean)new UsuarioService().get(Variaveis.login);
            this.orcamentoBean = this.getOrcamentoSelecionado();
            if (this.getLinhaSelecionada() < 0) {
                this.selecioneOrcamento();
                this.focarTabela();
                return;
            }
            ArrayList<OrcamentoConvenioBean> oc = this.getOrcamentoSelecionado().getConvenios();
            this.colunasConvenios = new DadosConvenios[oc.size()];
            for (int i = 0; i < oc.size(); ++i) {
                OrcamentoConvenioBean b = oc.get(i);
                try {
                    this.colunasConvenios[i] = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, b.getConvenio().getCodigo());
                    continue;
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            }
            boolean ok = true;
            NovoEscolheConvenio ec = new NovoEscolheConvenio((JFrame)this.getTopLevelAncestor(), "Selecionando conv\u00eanio");
            ec.setConvenios(this.colunasConvenios);
            ec.setTipo(2);
            ec.setVisible(true);
            ok = ec.getOK();
            FilialBean filial = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
            LayoutBean layout = (LayoutBean)new LayoutService().get(Variaveis.filialPadrao, usarPadrao ? String.valueOf(ParametrosGerais.getLayCodigo()) : String.valueOf(item.getLayoutVO().getCodigo()));
            if (layout == null || Funcoes.textoVazio(layout.getProposta())) {
                Funcoes.mensagem(this, "Modelo de proposta n\u00e3o definido.", 1);
                return;
            }
            RetornoDesconto desconto = new RetornoDesconto(7);
            desconto.setPercentual(BigDecimal.valueOf(this.orcamentoBean.getPercentualDesconto()));
            desconto.setValor(BigDecimal.valueOf(this.orcamentoBean.getValorDesconto()));
            RetornoAcrescimo acrescimo = new RetornoAcrescimo();
            acrescimo.setPercentual(BigDecimal.valueOf(this.orcamentoBean.getPercentualAcrescimo()));
            acrescimo.setValor(BigDecimal.valueOf(this.orcamentoBean.getValorAcrescimo()));
            DadosConvenios d = null;
            if (ec.getCodigoConvenioSelecionado() == null) {
                return;
            }
            for (DadosConvenios dadosConvenios : this.colunasConvenios) {
                if (dadosConvenios.getCodigo() != ec.getCodigoConvenioSelecionado().intValue()) continue;
                d = dadosConvenios;
                break;
            }
            ModeloGridTable modeloImpressao = this.geraModeloProposta(d, desconto, acrescimo, filial, usuarioLogado, layout);
            if (this.modelo != null) {
                String xml = layout.getProposta();
                Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                gerador.setPreVisualizar(true);
                gerador.executar(xml, modeloImpressao);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do usu\u00e1rio logado.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
    }

    private ArrayList<DadosExames> getAgrupamentoExames(ExameMatColetaVO examePai, DadosConvenios convenio, Integer codigoMetodologia) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT a.exa_kodigo as exame ");
        buf.append("       ,a.mco_kodigo as material ");
        buf.append("   FROM exameagrupaexameconvenio a ");
        buf.append("   JOIN exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
        buf.append("  WHERE a.fil_codigo = ").append(examePai.getFilial().getCodigo());
        buf.append("    AND a.exa_codigo = '").append(examePai.getExame().getCodigo()).append("' ");
        buf.append("    AND a.mco_codigo = ").append(examePai.getMaterial().getCodigo());
        buf.append("    AND a.con_codigo = ").append(convenio.getCodigo());
        buf.append("    AND a.aec_tipo = '").append("R").append("' ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (!rs.next()) {
            buf.setLength(0);
            buf.append(" SELECT a.exa_kodigo as exame ");
            buf.append("       ,a.mco_kodigo as material ");
            buf.append("   FROM exameagrupaexameconvenio a ");
            buf.append("   LEFT JOIN agrupaexameconvenio c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.aec_tipo = c.aec_tipo ");
            buf.append("   LEFT JOIN exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
            buf.append("  WHERE a.fil_codigo = ").append(examePai.getFilial().getCodigo());
            buf.append("    AND a.exa_codigo = '").append(examePai.getExame().getCodigo()).append("' ");
            buf.append("    AND a.mco_codigo = ").append(examePai.getMaterial().getCodigo());
            buf.append("    AND a.aec_tipo = '").append("R").append("' ");
            buf.append("    AND c.aec_ignorarconvenio ");
            rs = Conexao.executeQuery(st, buf.toString());
        } else {
            rs.beforeFirst();
        }
        ArrayList<DadosExames> listaExames = new ArrayList<DadosExames>();
        while (rs.next()) {
            try {
                DadosMaterial material = ExameUtil.getDadosMaterial(examePai.getFilial().getCodigo().toString(), rs.getInt("material"));
                DadosExames exame = ExameUtil.getDadosExame(examePai.getFilial().getCodigo().toString(), rs.getString("exame"), material);
                exame.setCodMetodo(codigoMetodologia.toString());
                ExameUtil.calculaPrecoExame(examePai.getFilial().getCodigo().toString(), exame, material, convenio, true, false, true, null, null, Integer.parseInt(exame.getCodMetodo()));
                listaExames.add(exame);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados dos exames filhos.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
        }
        rs.close();
        Conexao.fecharStatement(st);
        return listaExames.size() == 0 ? null : listaExames;
    }

    private ModeloGridTable geraModeloProposta(DadosConvenios convenio, RetornoDesconto desconto, RetornoAcrescimo acrescimo, FilialBean filial, UsuarioBean usuarioLogado, LayoutBean layout) {
        try {
            Iterator<DadosExameNormalProposta> total;
            if (layout == null || layout != null && Funcoes.textoVazio(layout.getProposta())) {
                Funcoes.mensagem(this, "Modelo de proposta n\u00e3o definido.", 1);
                return null;
            }
            int casasDecimais = ParametrosGerais.getCasasPrecoExame();
            RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
            if (!Funcoes.objectIsNull(convenio) && convenio.getConvenioUtilizarCasasDecimais()) {
                casasDecimais = convenio.getConvenioCasasPrecoExame();
                arredondamentoPreco = convenio.getConvenioTipoArredondamentoPrecoRoundingMode();
            }
            DadosProposta proposta = new DadosProposta();
            BigDecimal valorTotalOrcamento = new BigDecimal(0);
            for (OrcamentoConvenioExameBean exameConvenio : this.getExameOrcamentoConvenioSelecionado(convenio)) {
                ExameMatColetaVO examePai = (ExameMatColetaVO)this.exameMatColetaService.getVO(Variaveis.filialPadrao, exameConvenio.getExame().getCodigo().toString(), exameConvenio.getMaterial().getCodigo().toString());
                MetodologiaVO metodologia = examePai.getMetodologia();
                ArrayList<DadosExames> agrupamento = this.getAgrupamentoExames(examePai, convenio, metodologia.getCodigo());
                ObjetoTotalExame ob = new ObjetoTotalExame(new BigDecimal(exameConvenio.getValor().toString()).setScale(casasDecimais, arredondamentoPreco));
                ob.setNaoPermitido(exameConvenio.getNaoPermitido());
                total = ob.getValorTotal();
                if (!ob.getNaoPermitido()) {
                    valorTotalOrcamento = valorTotalOrcamento.add((BigDecimal)((Object)total));
                }
                if (ob.getNaoPermitido()) continue;
                if (agrupamento == null) {
                    DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(examePai.getFilial().getCodigo().toString(), examePai.getMaterial().getCodigo());
                    DadosExames exame = ExameUtil.getDadosExame(examePai.getFilial().getCodigo().toString(), examePai.getExame().getCodigo(), dadosMaterial);
                    exame.setCodMetodo(metodologia.getCodigo().toString());
                    exame.setQuantidadeExame(exameConvenio.getQuantidadeExame());
                    exame.setValorUnitarioExame(new BigDecimal(exameConvenio.getValor() / (double)exameConvenio.getQuantidadeExame().intValue()));
                    exame.setValorTotal(ob.getValorCalculado());
                    proposta.adicionaExameNormal(examePai.getFilial().getCodigo().toString(), exame, dadosMaterial, convenio, desconto);
                    continue;
                }
                proposta.adicionaExameAgrupado(examePai, agrupamento, desconto, exameConvenio);
            }
            BigDecimal valorMinimo = new BigDecimal(convenio.getValorAdicionalMinimoRequisicao());
            if (valorTotalOrcamento.doubleValue() < valorMinimo.doubleValue()) {
                valorTotalOrcamento = valorMinimo;
            }
            if (desconto != null) {
                desconto.setValor(this.calcularPercentual(desconto.getPercentual(), valorTotalOrcamento, casasDecimais, arredondamentoPreco).setScale(2, arredondamentoPreco));
            }
            if (acrescimo != null) {
                acrescimo.setValor(this.calcularPercentual(acrescimo.getPercentual(), valorTotalOrcamento, casasDecimais, arredondamentoPreco).setScale(2, arredondamentoPreco));
            }
            if (valorTotalOrcamento != null) {
                if (acrescimo != null) {
                    valorTotalOrcamento = valorTotalOrcamento.add(acrescimo.getValor());
                }
                if (desconto != null) {
                    valorTotalOrcamento = valorTotalOrcamento.subtract(desconto.getValor());
                }
                if (valorTotalOrcamento.doubleValue() < valorMinimo.doubleValue()) {
                    valorTotalOrcamento = valorMinimo;
                }
            }
            ModeloGridTable modeloImpressao = new ModeloGridTable(ArraysUtil.concatenar(jalis.laboratorio.util.impressao.Impressao.CAMPOS_PROPOSTA, new String[]{"ordenarcolunainmetro"}));
            ArrayList<DadosExameAgrupadoProposta> agrupados = proposta.getExamesAgrupados();
            boolean temExameCertificadoInmetro = false;
            for (DadosExameAgrupadoProposta exm : agrupados) {
                DadosExameNormalProposta dadosExameNormalProposta;
                total = exm.listaExamesFilhos.iterator();
                while (total.hasNext() && !(temExameCertificadoInmetro = (dadosExameNormalProposta = (DadosExameNormalProposta)total.next()).getExame().isInmetro().booleanValue())) {
                }
                if (!temExameCertificadoInmetro) continue;
                break;
            }
            for (DadosExameAgrupadoProposta exameAgrupado : agrupados) {
                for (DadosExameNormalProposta dadosExameNormalProposta : exameAgrupado.listaExamesFilhos) {
                    Object[] linha = new Object[modeloImpressao.getColumnCount()];
                    for (String s : jalis.laboratorio.util.impressao.Impressao.CAMPOS_PROPOSTA) {
                        int col = modeloImpressao.findColumn(s);
                        if (col > -1) {
                            if (s.equalsIgnoreCase("codigoConvenio")) {
                                linha[col] = convenio.getCodigo();
                            } else if (s.equalsIgnoreCase("descricaoConvenio")) {
                                linha[col] = convenio.getRazaoSocial();
                            } else if (s.equalsIgnoreCase("contatoConvenio")) {
                                linha[col] = convenio.getContato();
                            } else if (s.equalsIgnoreCase("foneConvenio")) {
                                linha[col] = convenio.getTelefone();
                            } else if (s.equalsIgnoreCase("emailConvenio")) {
                                linha[col] = convenio.getEmail();
                            } else if (s.equalsIgnoreCase("cidadeConvenio")) {
                                linha[col] = convenio.getCidade();
                            } else if (s.equalsIgnoreCase("ufConvenio")) {
                                linha[col] = convenio.getUf();
                            } else if (s.equalsIgnoreCase("cnpjCpfConvenio")) {
                                linha[col] = convenio.getCnpj();
                            } else if (s.equalsIgnoreCase("dataOrcamento")) {
                                linha[col] = Funcoes.formataData("dd/MM/yyyy HH:mm", this.getOrcamentoSelecionado().getDataHora());
                            } else if (s.equalsIgnoreCase("codigoOrcamento")) {
                                linha[col] = this.getOrcamentoSelecionado().getCodigo().toString();
                            } else if (s.equalsIgnoreCase("codigoGrupoPrincipal")) {
                                linha[col] = exameAgrupado.posicao;
                            } else if (s.equalsIgnoreCase("descricaoGrupoPrincipal")) {
                                linha[col] = exameAgrupado.examePai.getExame().getDescricao();
                            } else if (s.equalsIgnoreCase("codigoGrupoExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getCodigoGrupo();
                            } else if (s.equalsIgnoreCase("descricaoGrupoExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getDescricaoGrupo();
                            } else if (s.equalsIgnoreCase("certificadoInmetroExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().isInmetro();
                            } else if (s.equalsIgnoreCase("codigoExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getCodigo();
                            } else if (s.equalsIgnoreCase("possuiExameCertificadoInmetro")) {
                                linha[col] = temExameCertificadoInmetro;
                            } else if (s.equalsIgnoreCase("descricaoExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getDescricao();
                            } else if (s.equalsIgnoreCase("codigoMetodologiaExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getCodMetodo();
                            } else if (s.equalsIgnoreCase("descricaoMetodologiaExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getDescMetodo();
                            } else if (s.equalsIgnoreCase("valorExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getValor().multiply(new BigDecimal(dadosExameNormalProposta.getExame().getQuantidadeExame())).setScale(2, arredondamentoPreco);
                            } else if (s.equalsIgnoreCase("valorBrutoGrupo")) {
                                linha[col] = exameAgrupado.getValorBrutoGrupo();
                            } else if (s.equalsIgnoreCase("valorLiquidoGrupo")) {
                                linha[col] = exameAgrupado.getValorLiquidoGrupo();
                            } else if (s.equalsIgnoreCase("somatorioValorLiquidoGrupos")) {
                                linha[col] = proposta.getValorLiquidoTodosGrupos();
                            } else if (s.equalsIgnoreCase("prazoEntregaGrupoPrincipal")) {
                                linha[col] = exameAgrupado.getPrazoEntrega();
                            } else if (s.equalsIgnoreCase("percentualDesconto")) {
                                linha[col] = desconto.getPercentual();
                            } else if (s.equalsIgnoreCase("fantasiaConvenio")) {
                                linha[col] = convenio.getFantasia();
                            } else if (s.equalsIgnoreCase("valorDesconto")) {
                                linha[col] = desconto.getValor().setScale(2, arredondamentoPreco);
                            } else if (s.equalsIgnoreCase("valorAcrescimo")) {
                                linha[col] = acrescimo.getValor().setScale(2, arredondamentoPreco);
                            } else if (s.equalsIgnoreCase("percentualAcrescimo")) {
                                linha[col] = acrescimo.getPercentual();
                            } else if (s.equalsIgnoreCase("codigoFilial")) {
                                linha[col] = filial.getCodigo();
                            } else if (s.equalsIgnoreCase("razaoSocialFilial")) {
                                linha[col] = filial.getRazaoSocial();
                            } else if (s.equalsIgnoreCase("descricaoFilial")) {
                                linha[col] = filial.getDescricao();
                            } else if (s.equalsIgnoreCase("foneFilial")) {
                                linha[col] = filial.getFone();
                            } else if (s.equalsIgnoreCase("nomeCidade")) {
                                linha[col] = this.getDescricaoNomeCidadeFilial(filial);
                            } else if (s.equalsIgnoreCase("estadoCidade")) {
                                linha[col] = this.getDescricaoUfCidadeFilial(filial);
                            } else if (s.equalsIgnoreCase("cnpjFilial")) {
                                linha[col] = filial.getCnpj();
                            } else if (s.equalsIgnoreCase("enderecoFilial")) {
                                linha[col] = filial.getEndereco();
                            } else if (s.equalsIgnoreCase("complementoFilial")) {
                                linha[col] = filial.getComplemento();
                            } else if (s.equalsIgnoreCase("nomeBairro")) {
                                linha[col] = this.getDescricaoBairroFilial(filial);
                            } else if (s.equalsIgnoreCase("assinaturaUsuario")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getAssinatura() : "";
                            } else if (s.equalsIgnoreCase("nomeUsuarioLogado")) {
                                linha[col] = usuarioLogado.getNome();
                            } else if (s.equalsIgnoreCase("assinaturaUsuarioLogado")) {
                                linha[col] = usuarioLogado.getAssinatura();
                            } else if (s.equalsIgnoreCase("dataHoraOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getDataHora() : "";
                            } else if (s.equalsIgnoreCase("codigoOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getCodigo() : "";
                            } else if (s.equalsIgnoreCase("cnpjEmpresa")) {
                                String cnpj = "";
                                if (!Funcoes.objectIsNull(this.orcamentoBean.getPaciente())) {
                                    cnpj = this.orcamentoBean.getPaciente().getCNPJ();
                                }
                                linha[col] = cnpj;
                            } else if (s.equalsIgnoreCase("cpfPaciente")) {
                                String cpf = "";
                                if (!Funcoes.objectIsNull(this.orcamentoBean.getPaciente())) {
                                    cpf = this.orcamentoBean.getPaciente().getCpf();
                                }
                                linha[col] = cpf;
                            } else if (s.equalsIgnoreCase("codigoPaciente")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getCodigo() : 0;
                            } else if (s.equalsIgnoreCase("nomePaciente")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getNome() : "";
                            } else if (s.equalsIgnoreCase("solicitanteOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getSolicitante() : "";
                            } else if (s.equalsIgnoreCase("proprietarioOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getProprietario() : "";
                            } else if (s.equalsIgnoreCase("animalOrcamento")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getNome() : "";
                            } else if (s.equalsIgnoreCase("foneOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getFone() : "";
                            } else if (s.equalsIgnoreCase("contatoOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getContato() : "";
                            } else if (s.equalsIgnoreCase("emailOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getEmail() : "";
                            } else if (s.equalsIgnoreCase("validadeOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getValidade() : "";
                            } else if (s.equalsIgnoreCase("observacaoOrcamento")) {
                                linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getObservacao() : "";
                            } else if (s.equalsIgnoreCase("faxFilial")) {
                                linha[col] = filial.getFax();
                            } else if (s.equalsIgnoreCase("cepFilial")) {
                                linha[col] = filial.getCep();
                            } else if (s.equalsIgnoreCase("codigoUsuarioLogado")) {
                                linha[col] = usuarioLogado.getCodigo();
                            } else if (s.equalsIgnoreCase("codigoUsuario")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getCodigo() : "";
                            } else if (s.equalsIgnoreCase("nomeUsuario")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getNome() : "";
                            } else if (s.equalsIgnoreCase("assinaturaUsuario")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getAssinatura() : "";
                            } else if (s.equalsIgnoreCase("foneContatoOrcamento")) {
                                linha[col] = this.orcamentoBean != null && this.orcamentoBean.getFoneContato() != null ? this.orcamentoBean.getFoneContato() : "";
                            } else if (s.equalsIgnoreCase("materialColetadoExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getMaterialColetadoExame();
                            } else if (s.equalsIgnoreCase("abreviaturaMaterialColetadoExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getAbreviaturaMaterialColetadoExame();
                            } else if (s.equalsIgnoreCase("terceirizado")) {
                                linha[col] = dadosExameNormalProposta.getExame().getTerceirizado();
                            } else if (s.equalsIgnoreCase("valorUnitarioExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getValor().setScale(2, arredondamentoPreco);
                            } else if (s.equalsIgnoreCase("valorTotalExame")) {
                                linha[col] = dadosExameNormalProposta.getExame().getValorTotal().setScale(2, arredondamentoPreco);
                            } else if (s.equalsIgnoreCase("quantidadeExameOrcamento")) {
                                linha[col] = dadosExameNormalProposta.getExame().getQuantidadeExame();
                            } else if (s.equalsIgnoreCase("valorTotalOrcamento")) {
                                linha[col] = valorTotalOrcamento.setScale(2, arredondamentoPreco);
                            } else if (s.equalsIgnoreCase("descricaoPrazoEntregaExame")) {
                                linha[col] = null != dadosExameNormalProposta.getPrazoDias() ? dadosExameNormalProposta.getPrazoDias() : "9090";
                            }
                        }
                        String tmp = (dadosExameNormalProposta.getExame().isInmetro() != false ? "a" : "z") + modeloImpressao.getRowCount();
                        linha[modeloImpressao.findColumn((String)"ordenarcolunainmetro")] = tmp;
                    }
                    modeloImpressao.addLine(linha);
                }
            }
            if (!temExameCertificadoInmetro) {
                DadosExameNormalProposta exame;
                Iterator<Comparable> iterator = proposta.listaExamesNaoAgrupados.iterator();
                while (iterator.hasNext() && !(temExameCertificadoInmetro = (exame = (DadosExameNormalProposta)iterator.next()).getExame().isInmetro().booleanValue())) {
                }
            }
            for (DadosExameNormalProposta exame : proposta.listaExamesNaoAgrupados) {
                Object[] linha = new Object[modeloImpressao.getColumnCount()];
                for (String s : jalis.laboratorio.util.impressao.Impressao.CAMPOS_PROPOSTA) {
                    int col = modeloImpressao.findColumn(s);
                    if (col <= -1) continue;
                    if (s.equalsIgnoreCase("codigoConvenio")) {
                        linha[col] = convenio.getCodigo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("descricaoConvenio")) {
                        linha[col] = convenio.getRazaoSocial();
                        continue;
                    }
                    if (s.equalsIgnoreCase("contatoConvenio")) {
                        linha[col] = convenio.getContato();
                        continue;
                    }
                    if (s.equalsIgnoreCase("foneConvenio")) {
                        linha[col] = convenio.getTelefone();
                        continue;
                    }
                    if (s.equalsIgnoreCase("emailConvenio")) {
                        linha[col] = convenio.getEmail();
                        continue;
                    }
                    if (s.equalsIgnoreCase("cidadeConvenio")) {
                        linha[col] = convenio.getCidade();
                        continue;
                    }
                    if (s.equalsIgnoreCase("ufConvenio")) {
                        linha[col] = convenio.getUf();
                        continue;
                    }
                    if (s.equalsIgnoreCase("cnpjCpfConvenio")) {
                        linha[col] = convenio.getCnpj();
                        continue;
                    }
                    if (s.equalsIgnoreCase("senhaWebConvenio")) {
                        linha[col] = convenio.getSenhaWebConvenio();
                        continue;
                    }
                    if (s.equalsIgnoreCase("dataOrcamento")) {
                        linha[col] = Funcoes.formataData("dd/MM/yyyy HH:mm", this.getOrcamentoSelecionado().getDataHora());
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoOrcamento")) {
                        linha[col] = this.getOrcamentoSelecionado().getCodigo().toString();
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoGrupoPrincipal")) {
                        linha[col] = proposta.contador;
                        continue;
                    }
                    if (s.equalsIgnoreCase("descricaoGrupoPrincipal")) {
                        linha[col] = "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoGrupoExame")) {
                        linha[col] = exame.getExame().getCodigoGrupo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("descricaoGrupoExame")) {
                        linha[col] = exame.getExame().getDescricaoGrupo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoExame")) {
                        linha[col] = exame.getExame().getCodigo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("possuiExameCertificadoInmetro")) {
                        linha[col] = temExameCertificadoInmetro;
                        continue;
                    }
                    if (s.equalsIgnoreCase("certificadoInmetroExame")) {
                        linha[col] = exame.getExame().isInmetro();
                        continue;
                    }
                    if (s.equalsIgnoreCase("descricaoExame")) {
                        linha[col] = exame.getExame().getDescricao();
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoMetodologiaExame")) {
                        linha[col] = exame.getExame().getCodMetodo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("descricaoMetodologiaExame")) {
                        linha[col] = exame.getExame().getDescMetodo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorExame")) {
                        linha[col] = exame.getExame().getValor().multiply(new BigDecimal(exame.getExame().getQuantidadeExame())).setScale(2, arredondamentoPreco);
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorTotalExame")) {
                        linha[col] = exame.getExame().getValorTotal().setScale(2, arredondamentoPreco);
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorBrutoGrupo")) {
                        linha[col] = proposta.getValorBrutoExamesNaoAgrupados();
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorLiquidoGrupo")) {
                        linha[col] = proposta.getValorLiquidoExamesNaoAgrupados();
                        continue;
                    }
                    if (s.equalsIgnoreCase("somatorioValorLiquidoGrupos")) {
                        linha[col] = proposta.getValorLiquidoTodosGrupos();
                        continue;
                    }
                    if (s.equalsIgnoreCase("somatorioValorBrutoGrupos")) {
                        linha[col] = proposta.getValorLiquidoTodosGrupos();
                        continue;
                    }
                    if (s.equalsIgnoreCase("prazoEntregaGrupoPrincipal")) {
                        linha[col] = proposta.getPrazoEntregaExamesNaoAgrupados();
                        continue;
                    }
                    if (s.equalsIgnoreCase("percentualDesconto")) {
                        linha[col] = desconto.getPercentual();
                        continue;
                    }
                    if (s.equalsIgnoreCase("fantasiaConvenio")) {
                        linha[col] = convenio.getFantasia();
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorDesconto")) {
                        linha[col] = desconto.getValor().setScale(2, arredondamentoPreco);
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorAcrescimo")) {
                        linha[col] = acrescimo.getValor().setScale(2, arredondamentoPreco);
                        continue;
                    }
                    if (s.equalsIgnoreCase("percentualAcrescimo")) {
                        linha[col] = acrescimo.getPercentual();
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoFilial")) {
                        linha[col] = filial.getCodigo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("razaoSocialFilial")) {
                        linha[col] = filial.getRazaoSocial();
                        continue;
                    }
                    if (s.equalsIgnoreCase("descricaoFilial")) {
                        linha[col] = filial.getDescricao();
                        continue;
                    }
                    if (s.equalsIgnoreCase("foneFilial")) {
                        linha[col] = filial.getFone();
                        continue;
                    }
                    if (s.equalsIgnoreCase("nomeCidade")) {
                        linha[col] = this.getDescricaoNomeCidadeFilial(filial);
                        continue;
                    }
                    if (s.equalsIgnoreCase("estadoCidade")) {
                        linha[col] = this.getDescricaoUfCidadeFilial(filial);
                        continue;
                    }
                    if (s.equalsIgnoreCase("cnpjFilial")) {
                        linha[col] = filial.getCnpj();
                        continue;
                    }
                    if (s.equalsIgnoreCase("enderecoFilial")) {
                        linha[col] = filial.getEndereco();
                        continue;
                    }
                    if (s.equalsIgnoreCase("complementoFilial")) {
                        linha[col] = filial.getComplemento();
                        continue;
                    }
                    if (s.equalsIgnoreCase("nomeBairro")) {
                        linha[col] = this.getDescricaoBairroFilial(filial);
                        continue;
                    }
                    if (s.equalsIgnoreCase("assinaturaUsuario")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getAssinatura() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoUsuarioLogado")) {
                        linha[col] = usuarioLogado.getCodigo();
                        continue;
                    }
                    if (s.equalsIgnoreCase("nomeUsuarioLogado")) {
                        linha[col] = usuarioLogado.getNome();
                        continue;
                    }
                    if (s.equalsIgnoreCase("assinaturaUsuarioLogado")) {
                        linha[col] = usuarioLogado.getAssinatura();
                        continue;
                    }
                    if (s.equalsIgnoreCase("dataHoraOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getDataHora() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getCodigo() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("cnpjEmpresa")) {
                        String cnpj = "";
                        if (!Funcoes.objectIsNull(this.orcamentoBean.getPaciente())) {
                            cnpj = this.orcamentoBean.getPaciente().getCNPJ();
                        }
                        linha[col] = cnpj;
                        continue;
                    }
                    if (s.equalsIgnoreCase("cpfPaciente")) {
                        String cpf = "";
                        if (!Funcoes.objectIsNull(this.orcamentoBean.getPaciente())) {
                            cpf = this.orcamentoBean.getPaciente().getCpf();
                        }
                        linha[col] = cpf;
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoPaciente")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getCodigo() : 0;
                        continue;
                    }
                    if (s.equalsIgnoreCase("nomePaciente")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getNome() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("solicitanteOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getSolicitante() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("proprietarioOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getProprietario() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("animalOrcamento")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getPaciente() != null ? this.orcamentoBean.getPaciente().getNome() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("foneOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getFone() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("contatoOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getContato() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("emailOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getEmail() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("validadeOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getValidade() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("observacaoOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getObservacao() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("faxFilial")) {
                        linha[col] = filial.getFax();
                        continue;
                    }
                    if (s.equalsIgnoreCase("cepFilial")) {
                        linha[col] = filial.getCep();
                        continue;
                    }
                    if (s.equalsIgnoreCase("codigoUsuario")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getCodigo() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("nomeUsuario")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getNome() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("assinaturaUsuario")) {
                        linha[col] = this.orcamentoBean != null && this.orcamentoBean.getUsuario() != null ? this.orcamentoBean.getUsuario().getAssinatura() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("foneContatoOrcamento")) {
                        linha[col] = this.orcamentoBean != null ? this.orcamentoBean.getFoneContato() : "";
                        continue;
                    }
                    if (s.equalsIgnoreCase("materialColetadoExame")) {
                        linha[col] = exame.getExame().getMaterialColetadoExame();
                        continue;
                    }
                    if (s.equalsIgnoreCase("abreviaturaMaterialColetadoExame")) {
                        linha[col] = exame.getExame().getAbreviaturaMaterialColetadoExame();
                        continue;
                    }
                    if (s.equalsIgnoreCase("terceirizado")) {
                        linha[col] = exame.getExame().getTerceirizado();
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorUnitarioExame")) {
                        linha[col] = exame.getExame().getValor().setScale(2, arredondamentoPreco);
                        continue;
                    }
                    if (s.equalsIgnoreCase("quantidadeExameOrcamento")) {
                        linha[col] = exame.getExame().getQuantidadeExame();
                        continue;
                    }
                    if (s.equalsIgnoreCase("limiteDeDeteccaoExame")) {
                        linha[col] = exame.getExame().getLimiteDeDeteccao();
                        continue;
                    }
                    if (s.equalsIgnoreCase("valorTotalOrcamento")) {
                        linha[col] = valorTotalOrcamento.setScale(2, arredondamentoPreco);
                        continue;
                    }
                    if (!s.equalsIgnoreCase("descricaoPrazoEntregaExame")) continue;
                    linha[col] = null != exame.getPrazoDias() ? exame.getPrazoDias() : "9090";
                }
                String string = (exame.getExame().isInmetro() != false ? "a" : "z") + modeloImpressao.getRowCount();
                linha[modeloImpressao.findColumn((String)"ordenarcolunainmetro")] = string;
                modeloImpressao.addLine(linha);
            }
            modeloImpressao.ordenarColunas(modeloImpressao.findColumn("ordenarcolunainmetro"));
            return modeloImpressao;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir proposta", e.getStackTrace());
            return new ModeloGridTable(jalis.laboratorio.util.impressao.Impressao.CAMPOS_PROPOSTA);
        }
    }

    private String getDescricaoBairroFilial(FilialBean filial) {
        if (filial.getBairro() == null) {
            return "";
        }
        return filial.getBairro().getDescricao();
    }

    private String getDescricaoUfCidadeFilial(FilialBean filial) {
        if (filial.getCidade() == null) {
            return "";
        }
        return filial.getCidade().getUf();
    }

    private String getDescricaoNomeCidadeFilial(FilialBean filial) {
        if (filial.getCidade() == null) {
            return "";
        }
        return filial.getCidade().getNome();
    }

    @Override
    protected void controlaCampos() {
        this.botaoNovo.setEnabled(true);
        this.botaoFechar.setEnabled(true);
        this.buttonDataFinal.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataFinalAprovacao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataInicial.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataInicialAprovacao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonVisualizaExame.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonConsultar.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonImprimir.setEnabled(this.habilitaDesabilitaCampo() && !this.gridVazia());
        this.buttonRequisicao.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldDataFinal.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldDataFinalAprovacao.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldDataInicial.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldDataInicialAprovacao.setEnabled(this.habilitaDesabilitaCampo());
        this.textFieldSolicitante.setEnabled(this.habilitaDesabilitaCampo());
        this.itemFiltroUsuario.setEnabled(this.habilitaDesabilitaCampo());
        this.itemFiltroCliente.setEnabled(this.habilitaDesabilitaCampo());
        this.exibiOrcamentoComRequisicao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonRequisicao.setVisible(Cliente.getInstancia() != null && Cliente.getInstancia().getSocketEstacao().getSituacaoBloqueio());
    }

    private boolean gridVazia() {
        return this.modelo.getRowCount() == 0;
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void limparCampos() {
        this.textFieldDataFinal.clear();
        this.textFieldDataFinalAprovacao.clear();
        this.textFieldDataInicial.clear();
        this.textFieldDataInicialAprovacao.clear();
        this.textFieldSolicitante.clear();
        this.itemFiltroUsuario.setSelected(false);
        this.itemFiltroCliente.setSelected(false);
        this.modelo.clear();
        this.renderer.limpar();
        this.exibiOrcamentoComRequisicao.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void novo() {
        super.novo();
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    class DadosExameAgrupadoProposta
    implements Comparable {
        ExameMatColetaVO examePai = null;
        ArrayList<DadosExameNormalProposta> listaExamesFilhos = null;
        Integer posicao = -1;
        int prazo = 0;

        public DadosExameAgrupadoProposta(ExameMatColetaVO examePai, ArrayList<DadosExameNormalProposta> listaExamesFilhos, int posicao) {
            this.examePai = examePai;
            this.listaExamesFilhos = listaExamesFilhos;
            this.posicao = posicao;
            for (int i = 0; i < listaExamesFilhos.size(); ++i) {
                this.prazo = listaExamesFilhos.get((int)i).prazo > this.prazo ? listaExamesFilhos.get((int)i).prazo : this.prazo;
            }
            this.ordenarDados();
        }

        public void ordenarDados() {
            Collections.sort(this.listaExamesFilhos);
        }

        public int compareTo(Object o) {
            if (!(o instanceof DadosExameAgrupadoProposta)) {
                return -1;
            }
            DadosExameAgrupadoProposta aux = (DadosExameAgrupadoProposta)o;
            return this.posicao.compareTo(aux.posicao);
        }

        public int getPrazoEntrega() {
            return this.prazo;
        }

        public BigDecimal getValorBrutoGrupo() {
            BigDecimal somatorio = BigDecimal.ZERO;
            for (DadosExameNormalProposta aux : this.listaExamesFilhos) {
                somatorio = somatorio.add(aux.getValorBrutoExame());
            }
            return somatorio.setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
        }

        public BigDecimal getValorLiquidoGrupo() {
            BigDecimal somatorio = BigDecimal.ZERO;
            for (DadosExameNormalProposta aux : this.listaExamesFilhos) {
                somatorio = somatorio.add(aux.getValorLiquidoExame());
            }
            return somatorio.setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
        }
    }

    private class VisualizaExameOrcamento
    extends AbstractDialogoOKCancelar {
        private static final int POSICAO_EXAME_CONVENIO = 7;
        private ModeloGridTable modelo;
        private JTable tabela;
        private JScrollPane scrollPaneTabela;

        public VisualizaExameOrcamento(Component pai, String titulo, OrcamentoBean orcamentoBeanSelecionado, DadosConvenios dadosConvenios, boolean alterarBotoes) {
            super((Frame)pai, titulo);
            this.modelo = new ModeloGridTable(new String[]{"#", "C\u00f3d. Exame", "Exame", "Material", "Unit\u00e1rio", "Qtde", "Total"});
            this.tabela = new JTable(this.modelo);
            this.scrollPaneTabela = new JScrollPane(this.tabela);
            if (alterarBotoes) {
                this.getBotaoOK().setVisible(false);
                this.getBotaoCancelar().setText("Fechar");
                this.getBotaoCancelar().setMnemonic('F');
            }
            HashSet<String> lista = new HashSet<String>();
            int numeroLinha = 1;
            for (OrcamentoConvenioBean orcamentoConvenioBean : orcamentoBeanSelecionado.getConvenios()) {
                for (OrcamentoConvenioExameBean orcamentoConvenioExameBean : orcamentoConvenioBean.getExames()) {
                    String descricao;
                    if (dadosConvenios.getCodigo() != orcamentoConvenioExameBean.getConvenio().getCodigo().intValue() || lista.contains(descricao = orcamentoConvenioExameBean.getExame().getDescricao() + orcamentoConvenioExameBean.getMaterial().getDescricao() + orcamentoConvenioExameBean.getConvenio().getFantasia() + Funcoes.formataDecimal(orcamentoConvenioExameBean.getValor()))) continue;
                    this.modelo.addLine(new Object[]{numeroLinha, orcamentoConvenioExameBean.getExame().getCodigo(), orcamentoConvenioExameBean.getExame().getDescricao(), orcamentoConvenioExameBean.getMaterial().getAbreviatura(), Funcoes.formataDecimal(orcamentoConvenioExameBean.getValor() / (double)orcamentoConvenioExameBean.getQuantidadeExame().intValue()), orcamentoConvenioExameBean.getQuantidadeExame(), Funcoes.formataDecimal(orcamentoConvenioExameBean.getValor()), orcamentoConvenioExameBean});
                    lista.add(descricao);
                    ++numeroLinha;
                }
            }
            this.getPanelCentral().setLayout(new BorderLayout());
            this.getPanelCentral().setBorder(ScreenUtil.criarBordaVazia());
            this.getPanelCentral().add((Component)this.scrollPaneTabela, "Center");
            this.modelo.setColumnSize(new int[]{35, 100, 0, 70, 70, 70, 70}, this.tabela);
            this.setSize(new Dimension(700, 400));
            this.setLocationRelativeTo(this.getParent());
            this.setResizable(false);
            this.setModal(true);
            this.setVisible(true);
        }

        public OrcamentoConvenioExameBean getOrcamentoConvenioExameBeanSelcionado() {
            if (this.tabela.getSelectedRow() >= 0) {
                return (OrcamentoConvenioExameBean)this.modelo.getValueAt(this.tabela.getSelectedRow(), 7);
            }
            return null;
        }
    }

    class DadosProposta {
        ArrayList<DadosExameNormalProposta> listaExamesNaoAgrupados = new ArrayList();
        ArrayList<DadosExameAgrupadoProposta> listaExamesAgrupados = new ArrayList();
        int contador = 0;

        DadosProposta() {
        }

        public void adicionaExameNormal(String filial, DadosExames exame, DadosMaterial material, DadosConvenios convenio, RetornoDesconto desconto) {
            try {
                ExameUtil.calculaPrecoExame(filial, exame, material, convenio, true, false, true, null, null, Integer.parseInt(exame.getCodMetodo()));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(OrcamentoAprovado.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel calcular valor do exame.\n" + e.getMessage(), e.getStackTrace());
            }
            DadosExameNormalProposta aux = new DadosExameNormalProposta(filial, exame, desconto);
            this.listaExamesNaoAgrupados.add(aux);
        }

        public void adicionaExameAgrupado(ExameMatColetaVO examePai, ArrayList<DadosExames> listaExamesFilhos, RetornoDesconto desconto, OrcamentoConvenioExameBean exameConvenio) {
            ArrayList<DadosExameNormalProposta> listaAux = new ArrayList<DadosExameNormalProposta>();
            String filial = examePai.getFilial().getCodigo().toString();
            for (int i = 0; i < listaExamesFilhos.size(); ++i) {
                listaExamesFilhos.get(i).setQuantidadeExame(exameConvenio.getQuantidadeExame());
                listaExamesFilhos.get(i).setValorUnitarioExame(listaExamesFilhos.get(i).getValorTotal().divide(new BigDecimal(exameConvenio.getQuantidadeExame())));
                listaAux.add(new DadosExameNormalProposta(filial, listaExamesFilhos.get(i), desconto));
            }
            this.listaExamesAgrupados.add(new DadosExameAgrupadoProposta(examePai, listaAux, this.contador++));
        }

        public void ordenarDados() {
            Collections.sort(this.listaExamesNaoAgrupados);
            Collections.sort(this.listaExamesAgrupados);
            for (int i = 0; i < this.listaExamesAgrupados.size(); ++i) {
                this.listaExamesAgrupados.get(i).ordenarDados();
            }
        }

        public ArrayList<DadosExameNormalProposta> getExamesNaoAgrupados() {
            return this.listaExamesNaoAgrupados;
        }

        public ArrayList<DadosExameAgrupadoProposta> getExamesAgrupados() {
            return this.listaExamesAgrupados;
        }

        public BigDecimal getValorBrutoExamesNaoAgrupados() {
            BigDecimal somatorio = BigDecimal.ZERO;
            for (DadosExameNormalProposta aux : this.listaExamesNaoAgrupados) {
                somatorio = somatorio.add(aux.getValorBrutoExame());
            }
            return somatorio.setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
        }

        public BigDecimal getValorLiquidoExamesNaoAgrupados() {
            BigDecimal somatorio = BigDecimal.ZERO;
            for (DadosExameNormalProposta aux : this.listaExamesNaoAgrupados) {
                somatorio = somatorio.add(aux.getValorLiquidoExame());
            }
            return somatorio.setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
        }

        public BigDecimal getValorLiquidoTodosGrupos() {
            BigDecimal somatorio = BigDecimal.ZERO;
            somatorio = this.getValorLiquidoExamesNaoAgrupados();
            for (DadosExameAgrupadoProposta aux : this.listaExamesAgrupados) {
                somatorio = somatorio.add(aux.getValorLiquidoGrupo());
            }
            return somatorio.setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
        }

        public BigDecimal getValorBrutoTodosGrupos() {
            BigDecimal somatorio = BigDecimal.ZERO;
            somatorio = this.getValorBrutoExamesNaoAgrupados();
            for (DadosExameAgrupadoProposta aux : this.listaExamesAgrupados) {
                somatorio = somatorio.add(aux.getValorBrutoGrupo());
            }
            return somatorio.setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
        }

        public int getPrazoEntregaExamesNaoAgrupados() {
            int prazo = 0;
            for (DadosExameNormalProposta aux : this.listaExamesNaoAgrupados) {
                prazo = aux.getPrazoEntrega() > prazo ? aux.getPrazoEntrega() : prazo;
            }
            return prazo;
        }
    }

    class DadosExameNormalProposta
    implements Comparable {
        DadosExames exame = null;
        BigDecimal valorLiquidoExame = null;
        BigDecimal valorBrutoExame = null;
        int prazo = 0;
        String prazoDias = "";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DadosExameNormalProposta(String filial, DadosExames exame, RetornoDesconto desconto) {
            this.exame = exame;
            this.valorBrutoExame = exame.getValor().setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
            this.valorLiquidoExame = exame.getValor().setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND);
            if (desconto != null) {
                if (desconto.getPercentual() != null && desconto.getPercentual().compareTo(BigDecimal.ZERO) > 0) {
                    this.valorLiquidoExame = this.valorLiquidoExame.multiply(new BigDecimal("100").subtract(desconto.getPercentual().setScale(OrcamentoAprovado.this.CASAS, OrcamentoAprovado.this.ROUND))).divide(new BigDecimal("100"));
                } else if (desconto.getValor() != null && desconto.getValor().compareTo(BigDecimal.ZERO) > 0) {
                    this.valorLiquidoExame = this.valorLiquidoExame.subtract(desconto.getValor());
                }
            }
            if (exame.getCodPrazo() != null) {
                Statement st;
                block9: {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" SELECT prz_dias as dias, prz_descricao ");
                    buf.append("   FROM prazoentrega ");
                    buf.append("  WHERE fil_codigo = ").append(filial);
                    buf.append("    AND prz_codigo = ").append(exame.getCodPrazo());
                    st = Conexao.getStatement();
                    try {
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (!rs.next()) break block9;
                        this.prazo = rs.getInt("dias");
                        this.prazoDias = rs.getString("prz_descricao");
                    }
                    catch (SQLException e) {
                        try {
                            ErrorLogger.mostraMensagem(OrcamentoAprovado.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar o prazo de entrega do exame.\n" + e.getMessage(), e.getStackTrace());
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
            }
        }

        public int compareTo(Object o) {
            if (!(o instanceof DadosExameNormalProposta)) {
                return -1;
            }
            DadosExameNormalProposta aux = (DadosExameNormalProposta)o;
            return this.exame.getDescricao().compareTo(aux.getExame().getDescricao());
        }

        public DadosExames getExame() {
            return this.exame;
        }

        public int getPrazoEntrega() {
            return this.prazo;
        }

        public BigDecimal getValorBrutoExame() {
            return this.valorBrutoExame;
        }

        public BigDecimal getValorLiquidoExame() {
            return this.valorLiquidoExame;
        }

        public String getPrazoDias() {
            return this.prazoDias;
        }
    }
}

