/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.ParametrosGerais;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.math.RoundingMode;

class ObjetoTotalExame {
    private BigDecimal valorTotal = new BigDecimal(0);
    private boolean naoPermitido = false;
    private BigDecimal valorDesconto = new BigDecimal(0);
    private BigDecimal valorAcrescimo = new BigDecimal(0);
    private int CASAS = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public ObjetoTotalExame(BigDecimal valorTotal) {
        this.setValorTotal(valorTotal);
    }

    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setNaoPermitido(boolean naoPermitido) {
        this.naoPermitido = naoPermitido;
    }

    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorAcrescimo(BigDecimal valorAcrescimo) {
        this.valorAcrescimo = valorAcrescimo;
    }

    public void setCasasPrecoExame(int CASAS) {
        this.CASAS = CASAS;
    }

    public void setArredondamentoPrecoExame(RoundingMode ROUND) {
        this.ROUND = ROUND;
    }

    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    public boolean getNaoPermitido() {
        return this.naoPermitido;
    }

    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    public BigDecimal getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    public RoundingMode getArredondamentoPrecoExame() {
        return this.ROUND;
    }

    public int getCasasDecimais() {
        return this.CASAS;
    }

    public String toString() {
        String mascara = "0." + Funcoes.preencheZero("0", this.CASAS);
        if (this.naoPermitido) {
            mascara = "";
            return "N\u00e3o permitido";
        }
        if (this.valorDesconto.compareTo(new BigDecimal(0)) > 0) {
            Double aux = this.valorTotal.subtract(this.valorDesconto.setScale(this.CASAS, this.ROUND)).doubleValue();
            return Funcoes.formataDecimal(mascara, aux < 0.0 ? 0.0 : aux);
        }
        if (this.valorAcrescimo.compareTo(new BigDecimal(0)) > 0 && this.valorTotal.compareTo(BigDecimal.ZERO) > 0) {
            Double aux = this.valorTotal.add(this.valorAcrescimo.setScale(this.CASAS, this.ROUND)).doubleValue();
            return Funcoes.formataDecimal(mascara, aux < 0.0 ? 0.0 : aux);
        }
        return Funcoes.formataDecimal(mascara, this.valorTotal.setScale(this.CASAS, this.ROUND).doubleValue());
    }

    public BigDecimal getValorCalculado() {
        if (this.naoPermitido) {
            return BigDecimal.ZERO;
        }
        if (this.valorDesconto.compareTo(new BigDecimal(0)) > 0) {
            BigDecimal aux = this.valorTotal.subtract(this.valorDesconto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
            return aux.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : aux;
        }
        if (this.valorAcrescimo.compareTo(new BigDecimal(0)) > 0 && this.valorTotal.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal aux = this.valorTotal.add(this.valorAcrescimo.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
            return aux.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : aux;
        }
        return this.valorTotal.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
    }
}

