/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.laboratorio.recepcao.EntregarResultadoLote;
import jalis.laboratorio.recepcao.ObjetoExame;
import java.util.ArrayList;

class ObjetoRequisicao {
    static final int REQUISICAO_OK = 0;
    static final int REQUISICAO_DEVEDORA = 1;
    static final int REQUISICAO_SEM_EXAMES = 2;
    int codigo;
    String nome;
    double total;
    double totalPago;
    boolean deveGuia;
    String nomeMedico;
    ArrayList<ObjetoExame> exames = new ArrayList();

    public ObjetoRequisicao(int codigo, String nome, String nomeMedico, double total, double totalPago, boolean deveGuia) {
        this.codigo = codigo;
        this.nome = nome;
        this.total = total;
        this.totalPago = totalPago;
        this.deveGuia = deveGuia;
        this.nomeMedico = nomeMedico;
    }

    public void setExames(ArrayList<ObjetoExame> exames) {
        this.exames = exames;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public boolean isDeveGuia() {
        return this.deveGuia;
    }

    public ArrayList<ObjetoExame> getExames() {
        return this.exames;
    }

    public String getNome() {
        return this.nome;
    }

    public double getTotal() {
        return this.total;
    }

    public double getTotalPago() {
        return this.totalPago;
    }

    public String getNomeMedico() {
        return this.nomeMedico;
    }

    public int getSituacao() {
        boolean devedor = false;
        boolean acessoDevedor = Acesso.getAcesso(EntregarResultadoLote.ACESSO_DEVEDOR);
        if (!acessoDevedor && (this.totalPago < this.total || this.deveGuia)) {
            devedor = true;
        }
        if (devedor) {
            return 1;
        }
        if (this.exames.size() == 0) {
            return 2;
        }
        return 0;
    }
}

