/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.dados.DadosConvenios;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class NovoEscolheConvenio
extends JDialog
implements DisposeListener {
    private FrmPadrao panel = new FrmPadrao();
    private JPanel panelBotao = new JPanel(new FlowLayout(2));
    private JButton buttonImprimirCriar = new JButton("Imprimir");
    private JButton botaoCancelar = new JButton("Cancelar");
    private JLabel label1 = new JLabel("Selecione o conv\u00eanio a ser impresso");
    private JTable table = new JTable();
    private JScrollPane scroll = new JScrollPane(this.table);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Conv\u00eanio"});
    private int posicaoSelecionado = -1;
    public static final int TIPO_REQUISICAO = 1;
    public static final int TIPO_IMPRIMIR = 2;
    public static final int TIPO_SELECIONAR = 3;
    public static final int TIPO_ENVIAR = 4;
    private boolean ok = false;

    public NovoEscolheConvenio(JFrame owner, String title) {
        super((Frame)owner, title);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.setModal(true);
        this.setSize(new Dimension(350, 306));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "Center");
        this.buttonImprimirCriar.setMnemonic('I');
        this.getContentPane().add((Component)this.panelBotao, "South");
        this.panelBotao.add(this.buttonImprimirCriar);
        this.panelBotao.add(this.botaoCancelar);
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.label1.setBounds(new Rectangle(5, 5, 333, 14));
        this.scroll.setBounds(new Rectangle(5, 21, 333, 215));
        this.table.setModel(this.modelo);
        this.modelo.setColumnSize(new int[]{70, 0}, this.table);
        this.panel.add(this.label1);
        this.panel.add(this.scroll);
        this.buttonImprimirCriar.setMnemonic('I');
        this.botaoCancelar.setMnemonic('C');
        ScreenUtil.requisitarFoco(this.table);
        this.buttonImprimirCriar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NovoEscolheConvenio.this.table.getSelectedRow() > -1) {
                    NovoEscolheConvenio.this.posicaoSelecionado = NovoEscolheConvenio.this.table.getSelectedRow();
                } else if (NovoEscolheConvenio.this.table.getRowCount() == 1) {
                    NovoEscolheConvenio.this.posicaoSelecionado = 0;
                }
                NovoEscolheConvenio.this.ok = true;
                NovoEscolheConvenio.this.setVisible(false);
            }
        });
        this.botaoCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NovoEscolheConvenio.this.ok = false;
                NovoEscolheConvenio.this.setVisible(false);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NovoEscolheConvenio.this.buttonImprimirCriar.doClick();
                }
            }
        });
    }

    public void setConvenios(DadosConvenios[] selecao) {
        this.modelo.clear();
        for (DadosConvenios d : selecao) {
            this.modelo.addLine(new String[]{String.valueOf(d.getCodigo()), d.getFantasia()});
        }
        if (this.modelo.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public int getPosicaoSelecionada() {
        return this.posicaoSelecionado;
    }

    public Integer getCodigoConvenioSelecionado() {
        if (this.posicaoSelecionado != -1) {
            return Integer.valueOf(this.modelo.getValueAt(this.posicaoSelecionado, 0).toString());
        }
        return null;
    }

    public boolean getOK() {
        return this.ok;
    }

    public void setTipo(int tipo) {
        if (tipo == 1) {
            this.buttonImprimirCriar.setText("Criar");
            this.label1.setText("Selecione o conv\u00eanio para a requisi\u00e7\u00e3o");
        } else if (tipo == 2) {
            this.buttonImprimirCriar.setText("Imprimir");
            this.label1.setText("Selecione o conv\u00eanio para imprimir");
        } else if (tipo == 4) {
            this.buttonImprimirCriar.setText("Enviar");
            this.label1.setText("Selecione o conv\u00eanio para enviar e-mail");
        } else {
            this.buttonImprimirCriar.setText("Selecionar");
            this.label1.setText("Selecione o conv\u00eanio");
        }
    }
}

