/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.recepcao.MotivosAlteracaoVO;
import jalis.service.recepcao.MotivosAlteracaoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MotivosAlteracao
extends AbstractDialogoOKCancelar {
    private JTable tableMotivos;
    private ModeloGridTable modeloMotivos;
    private static String titulo = "Requisi\u00e7\u00e3o ";
    private String codigoFilial;
    private String codigoRequisicao;
    private static String[] colunasModeloMotivos = new String[]{"Motivo", "Descri\u00e7\u00e3o", "Data", "Usu\u00e1rio"};
    private static int[] tamanhoColunasModeloMotivos = new int[]{0, 0, 120, 90};

    public static MotivosAlteracao novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new MotivosAlteracao((Dialog)owner, titulo);
        }
        return new MotivosAlteracao((Frame)owner, titulo);
    }

    public MotivosAlteracao(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public MotivosAlteracao(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(700, 350));
        this.setLocationRelativeTo(this.getParent());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setText("Fechar");
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new BorderLayout());
        this.modeloMotivos = new ModeloGridTable(colunasModeloMotivos);
        this.tableMotivos = ComponenteFactory.novoJTable(this.modeloMotivos);
        this.modeloMotivos.setColumnSize(tamanhoColunasModeloMotivos, this.tableMotivos);
        JScrollPane scrollMotivos = new JScrollPane(this.tableMotivos);
        panelCentral.add((Component)scrollMotivos, "Center");
    }

    private void carregaRegistros() {
        if (!Funcoes.textoVazio(this.codigoFilial) && !Funcoes.textoVazio(this.codigoRequisicao)) {
            this.modeloMotivos.clear();
            MotivosAlteracaoVO[] motivosAlteracaoVO = new MotivosAlteracaoVO[]{};
            try {
                motivosAlteracaoVO = new MotivosAlteracaoService().buscarMotivos(this.codigoFilial, this.codigoRequisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados dos motivos.\n" + e.getMessage(), e.getStackTrace());
            }
            for (MotivosAlteracaoVO maVO : motivosAlteracaoVO) {
                this.modeloMotivos.addLine(new Object[]{maVO.getMotivo(), maVO.getDescricaoMotivo(), Funcoes.formataData("dd/MM/yyyy HH:mm", maVO.getDataHoraAlteracao()), maVO.getCodigoUsuario()});
            }
        }
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
        this.carregaRegistros();
    }

    public String getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public void setCodigoRequisicao(String codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
        this.setTitle(titulo.concat(codigoRequisicao));
        this.carregaRegistros();
    }
}

