/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.laboratorio.recepcao.Horario;
import jalis.laboratorio.recepcao.LabelDataAgendaListener;
import jalis.util.Funcoes;
import jalis.util.ListenerMostraCalendario;
import jalis.util.MostraCalendario;
import jalis.util.SplashMensagem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class LabelDataAgenda
extends JPanel {
    private static final String MSG_CARREGANDO_AGENDAMENTOS = "Carregando agendamentos. Aguarde...";
    public static final int LABEL_DIREITA = 0;
    public static final int LABEL_ESQUERDA = 1;
    public static final int LABEL_AMBOS = 2;
    private LabelDataAgendaListener janela = null;
    private Date data = new Date();
    private int tipo = -1;
    private boolean permitirSelecao = false;
    private final ArrayList<LabelDataAgendaListener> listener = new ArrayList();
    private final JLabel labelDataAnterior = new JLabel("\u25c4");
    private final JLabel labelDataPosterior = new JLabel("\u25ba");
    private final JLabel labelData = new JLabel();

    public LabelDataAgenda(LabelDataAgendaListener janela, Date data, boolean permitirSelecao, int tipo) {
        this.janela = janela;
        this.permitirSelecao = permitirSelecao;
        this.tipo = tipo;
        this.data = data;
        this.setLayout(new GridBagLayout());
        if (tipo == 0) {
            this.labelData.setHorizontalAlignment(4);
        } else if (tipo == 1) {
            this.labelData.setHorizontalAlignment(2);
        } else {
            this.labelData.setHorizontalAlignment(0);
        }
        this.labelDataAnterior.setHorizontalAlignment(0);
        this.labelDataPosterior.setHorizontalAlignment(0);
        this.montaPainel();
        if (this.permitirSelecao) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.labelData.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JPopupMenu menu = new JPopupMenu();
                    MostraCalendario calendario = new MostraCalendario(null, Funcoes.formataData(LabelDataAgenda.this.getData()), menu);
                    menu.add(calendario);
                    calendario.addListener(new ListenerMostraCalendario(){

                        @Override
                        public void dataSelecionada(Date data) {
                            if (data != null) {
                                LabelDataAgenda.this.data = data;
                                LabelDataAgenda.this.montaPainel();
                                for (LabelDataAgendaListener l : LabelDataAgenda.this.listener) {
                                    l.calendarioSelecionado(LabelDataAgenda.this, data);
                                }
                            }
                        }
                    });
                    calendario.setDate(Funcoes.formataData(new Date()));
                    menu.show(LabelDataAgenda.this.labelData, 0, LabelDataAgenda.this.labelData.getHeight());
                }
            });
        }
        this.labelDataAnterior.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LabelDataAgenda.this.janela != null) {
                    SplashMensagem splashMensagem = SplashMensagem.getInstancia(LabelDataAgenda.this.getTopLevelAncestor());
                    splashMensagem.mostrar(LabelDataAgenda.MSG_CARREGANDO_AGENDAMENTOS);
                    try {
                        LabelDataAgenda.this.janela.retrocederData();
                        Horario.horarioSelecionado = null;
                    }
                    finally {
                        splashMensagem.apagar();
                    }
                }
            }
        });
        this.labelDataPosterior.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LabelDataAgenda.this.janela != null) {
                    SplashMensagem splashMensagem = SplashMensagem.getInstancia(LabelDataAgenda.this.getTopLevelAncestor());
                    splashMensagem.mostrar(LabelDataAgenda.MSG_CARREGANDO_AGENDAMENTOS);
                    try {
                        LabelDataAgenda.this.janela.avancarData();
                        Horario.horarioSelecionado = null;
                    }
                    finally {
                        splashMensagem.apagar();
                    }
                }
            }
        });
    }

    public void setData(Date data) {
        this.data = data;
        this.montaPainel();
    }

    public void addListener(LabelDataAgendaListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void montaPainel() {
        this.setName("LabelDataAgenda");
        this.labelData.setName("labelData");
        if (this.tipo == 0) {
            this.labelData.setText(Funcoes.getDiaSemanaPorExtenso(this.data) + " - " + Funcoes.formataData(this.data));
        } else {
            this.labelData.setText(Funcoes.formataData(this.data) + " - " + Funcoes.getDiaSemanaPorExtenso(this.data));
        }
        this.labelDataPosterior.setName("labelDataPosterior");
        this.labelDataAnterior.setName("labelDataAnterior");
        this.removeAll();
        this.revalidate();
        GridBagConstraints c = new GridBagConstraints();
        if (this.tipo == 0) {
            c.anchor = 17;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.add((Component)this.labelData, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelDataPosterior.setPreferredSize(new Dimension((int)(this.getBounds().getWidth() / 3.0), 15));
            this.labelDataPosterior.setMinimumSize(new Dimension((int)(this.getBounds().getWidth() / 3.0), 15));
            this.labelDataPosterior.setMaximumSize(new Dimension((int)(this.getBounds().getWidth() / 3.0), 15));
            this.add((Component)this.labelDataPosterior, c);
        }
        if (this.tipo == 1) {
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            this.labelDataAnterior.setPreferredSize(new Dimension((int)(this.getBounds().getWidth() / 3.0), 15));
            this.labelDataAnterior.setMinimumSize(new Dimension((int)(this.getBounds().getWidth() / 3.0), 15));
            this.labelDataAnterior.setMaximumSize(new Dimension((int)(this.getBounds().getWidth() / 3.0), 15));
            this.add((Component)this.labelDataAnterior, c);
            c.weightx = 1.0;
            c.weighty = 0.0;
            ++c.gridx;
            c.fill = 2;
            this.add((Component)this.labelData, c);
        }
        if (this.tipo == 2) {
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            this.add((Component)this.labelDataAnterior, c);
            c.weightx = 1.0;
            c.weighty = 0.0;
            ++c.gridx;
            c.fill = 2;
            this.add((Component)this.labelData, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            this.add((Component)this.labelDataPosterior, c);
        }
    }

    public Date getData() {
        return this.data;
    }
}

