/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.PanelAgendamento;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JanelaSelecionaExameAgendamento
extends AbstractDialogoOKCancelar
implements ActionListener {
    private final JButton btnSelecionaTodos = ComponenteFactory.novoJButton("Selecionar todos", 'S', this);
    private final JButton btnDesmarcaTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_EXAME = 2;
    private final int COLUNA_CODIGO_REQUISICAO = 3;
    private final int COLUNA_SITUACAO = 4;
    private final int COLUNA_EXAME_MARCADO = 5;
    private final int COLUNA_EXAME_SELECIONADO = 6;
    private CheckBoxRenderer render = new CheckBoxRenderer();
    private final String SITUACAO_CONFERIDO = "Conferido";
    private final String SITUACAO_LANCADO = "Lan\u00e7ado";
    private final String SITUACAO_ENTREGUE = "Entregue";
    private final String SITUACAO_IMPRESSO = "Impresso";
    private final JPanel panelCentral = new JPanel(new GridBagLayout());
    private PanelAgendamento agendaEdicao = null;
    private ArrayList<ExameRequisicaoVO> exameSelecionado = new ArrayList();
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame", "Requisi\u00e7\u00e3o", "Situa\u00e7\u00e3o", "#", ""}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 5) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            if (!this.celulaEhEditavel(columnIndex)) {
                return false;
            }
            return columnIndex != 5 || !JanelaSelecionaExameAgendamento.this.exameComResultado(row);
        }

        private boolean celulaEhEditavel(int column) {
            Integer[] colunasDesabilitadas;
            for (Integer coluna : colunasDesabilitadas = new Integer[]{0, 3, 2, 6, 1, 4}) {
                if (coluna != column) continue;
                return false;
            }
            return true;
        }
    };
    JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, 70, 70, 260, 75, 75, 85, 1);
    JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private HashMap<ExameMatColetaVO, Integer> listaExames = null;
    private boolean isOK = false;
    private RequisicaoService requisicaoService = new RequisicaoService();

    public static JanelaSelecionaExameAgendamento novaInstancia(Object pai, RequisicaoVO requisicao) {
        if (pai instanceof Frame) {
            return new JanelaSelecionaExameAgendamento((Frame)pai, "Selecionar Exames", requisicao);
        }
        if (pai instanceof Dialog) {
            return new JanelaSelecionaExameAgendamento((Dialog)pai, "Selecionar Exames", requisicao);
        }
        return null;
    }

    public JanelaSelecionaExameAgendamento(Frame pai, String titulo, RequisicaoVO requisicao) {
        super(pai, titulo);
        this.montaTela(requisicao);
    }

    public JanelaSelecionaExameAgendamento(Dialog pai, String titulo, RequisicaoVO requisicao) {
        super(pai, titulo);
        this.montaTela(requisicao);
    }

    private void montaTela(RequisicaoVO requisicao) {
        this.getPanelCentral().setLayout(new BorderLayout());
        this.setSize(new Dimension(595, 350));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.tableExames.setDefaultRenderer(Boolean.class, this.render);
        this.modeloExames.setColumnSize(new int[]{70, 70, 250, 70, 90, 36, 1}, this.tableExames);
        this.tableExames.repaint();
        this.panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 5;
        c.fill = 1;
        c.anchor = 17;
        ++c.gridy;
        this.scrollExames.setPreferredSize(new Dimension(150, 20));
        this.scrollExames.setMinimumSize(new Dimension(150, 20));
        this.panelCentral.add((Component)this.scrollExames, c);
        this.getPanelBotoesEsquerda().add(this.btnSelecionaTodos);
        this.getPanelBotoesEsquerda().add(this.btnDesmarcaTodos);
        this.getPanelCentral().add((Component)this.panelCentral, "Center");
        ScreenUtil.centralizar(this);
        this.adicionarExameRequisicaoAoModelo(requisicao);
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 0) {
                    Boolean isMarcado = (Boolean)JanelaSelecionaExameAgendamento.this.modeloExames.getValueAt(JanelaSelecionaExameAgendamento.this.tableExames.getSelectedRow(), 5);
                    if (isMarcado.booleanValue()) {
                        JanelaSelecionaExameAgendamento.this.modeloExames.setValueAt(false, JanelaSelecionaExameAgendamento.this.tableExames.getSelectedRow(), 5);
                    } else {
                        JanelaSelecionaExameAgendamento.this.modeloExames.setValueAt(true, JanelaSelecionaExameAgendamento.this.tableExames.getSelectedRow(), 5);
                    }
                    JanelaSelecionaExameAgendamento.this.modeloExames.fireTableCellUpdated(JanelaSelecionaExameAgendamento.this.tableExames.getSelectedRow(), 5);
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linhaSelecionada;
                if (e.getKeyCode() == 32 && !JanelaSelecionaExameAgendamento.this.exameComResultado(linhaSelecionada = JanelaSelecionaExameAgendamento.this.tableExames.getSelectedRow())) {
                    Boolean isMarcado = (Boolean)JanelaSelecionaExameAgendamento.this.modeloExames.getValueAt(linhaSelecionada, 5);
                    if (isMarcado.booleanValue()) {
                        JanelaSelecionaExameAgendamento.this.modeloExames.setValueAt(false, linhaSelecionada, 5);
                    } else {
                        JanelaSelecionaExameAgendamento.this.modeloExames.setValueAt(true, linhaSelecionada, 5);
                    }
                    JanelaSelecionaExameAgendamento.this.modeloExames.fireTableCellUpdated(linhaSelecionada, 5);
                }
            }
        });
    }

    private boolean exameComResultado(int row) {
        return this.modeloExames.getValueAt(row, 4).toString().equalsIgnoreCase("Entregue") || this.modeloExames.getValueAt(row, 4).toString().equalsIgnoreCase("Conferido") || this.modeloExames.getValueAt(row, 4).toString().equalsIgnoreCase("Lan\u00e7ado") || this.modeloExames.getValueAt(row, 4).toString().equalsIgnoreCase("Impresso");
    }

    private void adicionarExameRequisicaoAoModelo(RequisicaoVO requisicao) {
        if (requisicao != null) {
            RequisicaoBean requisicaoBean = this.buscarRequisicaoBean(requisicao);
            List<ExameRequisicaoVO> exames = requisicaoBean.getExames();
            this.adicionarExamesModelo(exames);
            List<ExameRequisicaoVO> examesMultiguia = requisicaoBean.getExamesMultiguia();
            this.adicionarExamesMultiguiaModelo(examesMultiguia);
        }
    }

    private void adicionarExamesMultiguiaModelo(List<ExameRequisicaoVO> examesMultiguia) {
        if (examesMultiguia != null) {
            for (ExameRequisicaoVO exameRequiMultGuia : examesMultiguia) {
                if (exameRequiMultGuia.getExcluido().booleanValue()) continue;
                this.addLinhaModeloExameReq(exameRequiMultGuia);
            }
        }
    }

    private void adicionarExamesModelo(List<ExameRequisicaoVO> exames) {
        for (ExameRequisicaoVO exameRequisicaoVO : exames) {
            if (exameRequisicaoVO.getExcluido().booleanValue()) continue;
            this.addLinhaModeloExameReq(exameRequisicaoVO);
        }
    }

    private RequisicaoBean buscarRequisicaoBean(RequisicaoVO requisicao) {
        RequisicaoBean requisicaoBean = null;
        try {
            Map<String, Object> chaves = this.criarChaveRequisicaoBean(requisicao);
            requisicaoBean = this.consultarRequisicaoBean(chaves);
        }
        catch (Exception e) {
            Funcoes.mensagem(this.getPanelCentral(), "N\u00e3o foi poss\u00edvel buscar requisi\u00e7\u00e3o", 1);
        }
        return requisicaoBean;
    }

    private RequisicaoBean consultarRequisicaoBean(Map<String, Object> chaves) throws ThreadDaoException {
        Conexao.setSessaoConexao(true);
        RequisicaoBean requisicaoBean = (RequisicaoBean)this.requisicaoService.getBean(chaves);
        Conexao.setSessaoConexao(false);
        return requisicaoBean;
    }

    private Map<String, Object> criarChaveRequisicaoBean(RequisicaoVO requisicao) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", requisicao.getFilial().getCodigo());
        chaves.put("req_codigo", requisicao.getCodigo());
        return chaves;
    }

    private void addLinhaModeloExameReq(ExameRequisicaoVO exameRequisicaoVO) {
        String codigoExame = exameRequisicaoVO.getExame().getCodigo();
        String codigoAbreveatura = exameRequisicaoVO.getMaterial().getAbreviatura();
        String descricaoExame = exameRequisicaoVO.getExame().getDescricao();
        String codigoRequisicao = exameRequisicaoVO.getRequisicao().toString();
        String situacao = Funcoes.obterSituacaoExameRequisicao()[Funcoes.obterSituacaoRegistroExameReq(exameRequisicaoVO.getSituacao())];
        this.modeloExames.addLine(new Object[]{codigoExame, codigoAbreveatura, descricaoExame, codigoRequisicao, situacao.trim(), false, exameRequisicaoVO});
    }

    public List<HashMap<String, Object>> getExameSelecionados() {
        ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            HashMap<String, Object> hash = this.modeloExames.getLine(i);
            if (!hash.get("Sel").equals(true)) continue;
            sel.add(hash);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.btnSelecionaTodos || o == this.btnDesmarcaTodos) {
            boolean marcar = o == this.btnSelecionaTodos;
            for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                if (this.modeloExames.getValueAt(i, 4).toString().equalsIgnoreCase("Entregue") || this.modeloExames.getValueAt(i, 4).toString().equalsIgnoreCase("Conferido") || this.modeloExames.getValueAt(i, 4).toString().equalsIgnoreCase("Lan\u00e7ado") || this.modeloExames.getValueAt(i, 4).toString().equalsIgnoreCase("Impresso")) continue;
                this.modeloExames.setValueAt(marcar, i, 5);
            }
            this.modeloExames.fireTableDataChanged();
        }
        if (o == this.getBotaoOK()) {
            for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                Boolean b;
                if (this.modeloExames.getValueAt(i, 5) == null || !(this.modeloExames.getValueAt(i, 5) instanceof Boolean) || !(b = new Boolean((Boolean)this.modeloExames.getValueAt(i, 5))).booleanValue()) continue;
                ExameRequisicaoVO ex = (ExameRequisicaoVO)this.modeloExames.getValueAt(i, 6);
                this.exameSelecionado.add(ex);
            }
            if (this.exameSelecionado.isEmpty()) {
                return;
            }
            this.ok = true;
            this.dispose();
        } else if (o == this.buttonCancelar && this.isUsuarioPodeCancelar()) {
            this.acaoCancelar();
            this.dispose();
        }
    }

    public ArrayList<ExameRequisicaoVO> getExameSelecionado() {
        return this.exameSelecionado;
    }

    public void setExameSelecionado(ArrayList<ExameRequisicaoVO> exameSelecionado) {
        this.exameSelecionado = exameSelecionado;
    }

    @Override
    protected JButton getBotaoCancelar() {
        return this.buttonCancelar;
    }

    class JCheckEditor
    extends DefaultCellEditor {
        JCheckBox check;
        int linha;

        public JCheckEditor() {
            super(new JCheckBox());
            this.check = null;
            this.linha = -1;
            this.check = (JCheckBox)this.editorComponent;
            this.check.setOpaque(true);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            if (isSelected) {
                this.check.setForeground(table.getSelectionForeground());
                this.check.setBackground(table.getSelectionBackground());
            } else {
                this.check.setForeground(table.getForeground());
                this.check.setBackground(table.getBackground());
            }
            this.linha = rowIndex;
            Boolean hasResultado = JanelaSelecionaExameAgendamento.this.exameComResultado(rowIndex);
            this.check.setEnabled(hasResultado == false);
            return this.check;
        }
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color cor = UIManager.getColor("Table.selectionBackground");
            this.setSelected(value != null && (Boolean)value != false);
            Boolean hasResultado = JanelaSelecionaExameAgendamento.this.exameComResultado(row);
            if (column == 5 && hasResultado.booleanValue()) {
                this.setEnabled(false);
                this.setBackground(table.getBackground());
            } else {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setEnabled(true);
                }
                this.setSelected(value != null && (Boolean)value != false);
            }
            return this;
        }
    }
}

