/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.AbrirRequisicao;
import jalis.laboratorio.recepcao.CriarRequisicao_;
import jalis.laboratorio.recepcao.ObjetoTotalExame;
import jalis.laboratorio.recepcao.util.PanelAlimentos;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.bean.recepcao.OrcamentoBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.vo.cadastro.auxiliares.PaisVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.material.EmbalagemRecebidaVO;
import jalis.model.vo.estoque.UnidadeMedidaVO;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.auxiliares.PaisService;
import jalis.service.cadastro.material.EmbalagemRecebidaService;
import jalis.service.estoque.UnidadeMedidaService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class JanelaRequisicoesOrcamento
extends AbstractDialogoOKCancelar {
    private final int COLUNA_REQUISICAO = 0;
    private final int COLUNA_CLIENTE = 1;
    private final int COLUNA_CONVENIO = 2;
    private final int COLUNA_TOTAL_REQUISICAO = 3;
    private final int COLUNA_SALDO = 4;
    private final int COLUNA_EXAMES = 5;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Req.", "Cliente", "Conv\u00eanio", "Total Req.", "Saldo dev.", "Exames"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonAbrir = new JButton("Novo");
    private JLabel labelTotal = new JLabel("Total:");
    private JLabel labelValorTotal = new JLabel();
    private JLabel labelSaldo = new JLabel("Saldo:");
    private JLabel labelValorSaldo = new JLabel();
    private DadosConvenios convenio = null;
    private int materialSelecionado = -1;
    private OrcamentoBean bean = null;
    private RequisicaoBean requisicaoBean = null;
    private EntidadeBean entidadeBean = null;
    private HashMap<ExameMatColetaVO, Integer> listaExames = null;
    private HashMap<ExameMatColetaVO, ObjetoTotalExame> listaValoresExame = null;
    private String codigoResponsavel = "";
    private int reqPai = -1;
    private PaisService paisService;
    private UnidadeMedidaService unidadeMedidaService;
    private EmbalagemRecebidaService embalagemRecebidaService;
    private String senhaGerada;

    public static JanelaRequisicoesOrcamento novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new JanelaRequisicoesOrcamento((Frame)pai, "Criando requisi\u00e7\u00f5es");
        }
        if (pai instanceof Dialog) {
            return new JanelaRequisicoesOrcamento((Dialog)pai, "Criando requisi\u00e7\u00f5es");
        }
        return null;
    }

    public JanelaRequisicoesOrcamento(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public JanelaRequisicoesOrcamento(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new BorderLayout());
        this.setSize(new Dimension(650, 330));
        this.setUsuarioPodeCancelar(false);
        this.modelo.setColumnSize(new int[]{60, 180, 130, 70, 70, 0}, this.table);
        this.table.setDefaultRenderer(Object.class, new RequisicaoRender());
        JPanel panelRequisicoes = new JPanel(new BorderLayout());
        panelRequisicoes.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        this.scroll.setPreferredSize(new Dimension(200, 180));
        JPanel panelTable = new JPanel(new BorderLayout());
        panelTable.add((Component)this.scroll, "Center");
        JPanel panelTotalizadores = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        panelTotalizadores.add((Component)new JLabel(), c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 2);
        panelTotalizadores.add((Component)this.labelTotal, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        panelTotalizadores.add((Component)this.labelValorTotal, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 2);
        panelTotalizadores.add((Component)this.labelSaldo, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        panelTotalizadores.add((Component)this.labelValorSaldo, c);
        panelTable.add((Component)panelTotalizadores, "South");
        panelRequisicoes.add((Component)panelTable, "Center");
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonAbrir);
        panelRequisicoes.add((Component)panelBotoes, "South");
        this.getPanelCentral().add((Component)panelRequisicoes, "Center");
        this.buttonCancelar.setVisible(false);
        this.buttonOK.setText("Concluir");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenUtil.requisitarFoco(JanelaRequisicoesOrcamento.this.table);
            }
        });
        this.buttonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaRequisicoesOrcamento.this.visualizarRequisicao();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JanelaRequisicoesOrcamento.this.visualizarRequisicao();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JanelaRequisicoesOrcamento.this.controlaBotaoNovo();
            }
        });
        ScreenUtil.centralizar(this);
        this.paisService = new PaisService();
        this.unidadeMedidaService = new UnidadeMedidaService();
        this.embalagemRecebidaService = new EmbalagemRecebidaService();
    }

    private void controlaBotaoNovo() {
        int linha = this.table.getSelectedRow();
        if (linha > -1) {
            String codigo = (String)this.modelo.getValueAt(linha, 0);
            if (!Funcoes.textoVazio(codigo)) {
                this.buttonAbrir.setText("Editar");
            } else {
                this.buttonAbrir.setText("Novo");
            }
        }
    }

    public String getSenhaGerada() {
        return this.senhaGerada;
    }

    public void setSenhaGerada(String senhaGerada) {
        this.senhaGerada = senhaGerada;
    }

    private void visualizarRequisicao() {
        boolean temRequisicao;
        int linha = this.table.getSelectedRow();
        if (linha == -1) {
            return;
        }
        boolean bl = temRequisicao = this.modelo.getValueAt(linha, 0) != null;
        if (temRequisicao) {
            String codigoRequisicao = this.modelo.getValueAt(linha, 0).toString();
            AbrirRequisicao novaRequisicao = new AbrirRequisicao((Frame)Laboratorio.getInstancia(), false, null, null);
            novaRequisicao.setRequisicao(Variaveis.filialPadrao, codigoRequisicao, null);
            novaRequisicao.setVisible(true);
            novaRequisicao.requisicao.utilizarSenha(this.senhaGerada);
            if (novaRequisicao.getRequisicao() != null) {
                if (novaRequisicao.getRequisicao().getValorTotalOrcamento() > 0.0) {
                    this.modelo.setValueAt(Funcoes.formataDecimal(novaRequisicao.getRequisicao().getValorTotalOrcamento()), linha, 3);
                }
                if (novaRequisicao.getRequisicao().getSaldoOrcamento() > -1.0) {
                    this.modelo.setValueAt(Funcoes.formataDecimal(novaRequisicao.getRequisicao().getSaldoOrcamento()), linha, 4);
                }
                ArrayList<ExameMatColetaVO> listaExames = novaRequisicao.getRequisicao().getListaExames();
                ArrayListExames listaAux = new ArrayListExames();
                if (listaExames != null) {
                    for (ExameMatColetaVO exame : listaExames) {
                        listaAux.add((ExameMatColetaVO)exame);
                    }
                    this.modelo.setValueAt(listaAux, linha, 5);
                }
                this.codigoResponsavel = novaRequisicao.requisicao.getResponsavelOrcamento();
                this.atualizaBean(codigoRequisicao);
            }
        } else if (linha > -1) {
            this.geraRequisicao(linha);
        }
        BigDecimal totalSaldo = BigDecimal.ZERO;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            totalSaldo = totalSaldo.add(new BigDecimal(Funcoes.limpaDecimal((String)this.modelo.getValueAt(i, 4))));
        }
        this.labelValorSaldo.setText(Funcoes.formataDecimal(totalSaldo.doubleValue()));
        if (totalSaldo.doubleValue() == 0.0) {
            this.labelValorSaldo.setForeground(null);
        } else {
            this.labelValorSaldo.setForeground(Color.RED);
        }
        if (linha + 1 < this.modelo.getRowCount()) {
            this.table.getSelectionModel().setSelectionInterval(linha + 1, linha + 1);
        }
    }

    private void atualizaBean(String codigoRequisicao) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("req_codigo", codigoRequisicao);
        try {
            this.requisicaoBean = (RequisicaoBean)new RequisicaoService().getBean(chaves);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        if (!Funcoes.textoVazio(this.codigoResponsavel)) {
            try {
                this.entidadeBean = (EntidadeBean)new EntidadeService().get(Variaveis.filialPadrao, this.codigoResponsavel);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do respons\u00e1vel.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    public DadosConvenios getConvenioSelecionado() {
        return this.convenio;
    }

    public void setConvenioSelecionado(DadosConvenios convenioSelecionado) {
        this.convenio = convenioSelecionado;
    }

    public int getMaterialSelecionado() {
        return this.materialSelecionado;
    }

    public void setMaterialSelecionado(int materialSelecionado) {
        this.materialSelecionado = materialSelecionado;
    }

    public OrcamentoBean getOrcamentoBean() {
        return this.bean;
    }

    public void setOrcamentoBean(OrcamentoBean bean) {
        this.bean = bean;
    }

    public HashMap<ExameMatColetaVO, Integer> getListaExames() {
        return this.listaExames;
    }

    public HashMap<ExameMatColetaVO, ObjetoTotalExame> getListaValoresExame() {
        return this.listaValoresExame;
    }

    public void setListaValoresExame(HashMap<ExameMatColetaVO, ObjetoTotalExame> listaValoresExame) {
        this.listaValoresExame = listaValoresExame;
    }

    public void setListaExames(HashMap<ExameMatColetaVO, Integer> listaExames) {
        this.listaExames = listaExames;
        this.preencheDadosModelo();
    }

    private void preencheDadosModelo() {
        for (ExameMatColetaVO exame : this.listaExames.keySet()) {
            Integer qtdeExame = this.listaExames.get(exame);
            BigDecimal valorTotal = BigDecimal.ZERO;
            ObjetoTotalExame objExame = this.listaValoresExame.get(exame);
            BigDecimal valorUnitario = objExame.getValorTotal();
            int casasDecimais = ParametrosGerais.getCasasPrecoExame();
            RoundingMode arredondamentoPreco = ParametrosGerais.getArredondamentoPrecoExame();
            if (!Funcoes.objectIsNull((Object)objExame.getArredondamentoPrecoExame())) {
                casasDecimais = objExame.getCasasDecimais();
                arredondamentoPreco = objExame.getArredondamentoPrecoExame();
            }
            if (qtdeExame > 1) {
                valorUnitario = objExame.getValorTotal().divide(new BigDecimal(qtdeExame)).setScale(casasDecimais, arredondamentoPreco);
            }
            valorTotal = valorTotal.add(valorUnitario).subtract(objExame.getValorDesconto()).add(objExame.getValorAcrescimo());
            valorTotal = valorTotal.setScale(casasDecimais, arredondamentoPreco);
            for (int i = 0; i < qtdeExame; ++i) {
                ArrayListExames listaAux;
                if (this.modelo.getRowCount() < i + 1) {
                    listaAux = new ArrayListExames();
                    listaAux.add(exame);
                    this.modelo.addLine(new Object[]{null, this.bean.getPaciente() != null ? this.bean.getPaciente().getNome() : this.bean.getSolicitante(), this.convenio.getFantasia(), Funcoes.formataDecimal(valorTotal.setScale(2, arredondamentoPreco).doubleValue()), Funcoes.formataDecimal(valorTotal.setScale(2, arredondamentoPreco).doubleValue()), listaAux});
                    continue;
                }
                listaAux = (ArrayListExames)this.modelo.getValueAt(i, 5);
                listaAux.add(exame);
                String valorAux = (String)this.modelo.getValueAt(i, 3);
                Double novoValor = new BigDecimal(Funcoes.limpaDecimal(valorAux)).add(valorTotal).setScale(2, arredondamentoPreco).doubleValue();
                this.modelo.setValueAt(Funcoes.formataDecimal(novoValor), i, 3);
                this.modelo.setValueAt(Funcoes.formataDecimal(novoValor), i, 4);
            }
        }
        BigDecimal totalRequisicoes = BigDecimal.ZERO;
        BigDecimal totalSaldo = BigDecimal.ZERO;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            totalRequisicoes = totalRequisicoes.add(new BigDecimal(Funcoes.limpaDecimal((String)this.modelo.getValueAt(i, 3))));
            totalSaldo = totalSaldo.add(new BigDecimal(Funcoes.limpaDecimal((String)this.modelo.getValueAt(i, 3))));
        }
        this.labelValorTotal.setText(Funcoes.formataDecimal(totalRequisicoes.doubleValue()));
        this.labelValorSaldo.setText(Funcoes.formataDecimal(totalSaldo.doubleValue()));
        if (totalSaldo.doubleValue() > 0.0) {
            this.labelValorSaldo.setForeground(Color.RED);
        }
        this.table.getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    protected boolean acaoOk() {
        int contadorNaoCriadas = 0;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (this.modelo.getValueAt(i, 0) != null) continue;
            ++contadorNaoCriadas;
        }
        if (contadorNaoCriadas == this.modelo.getRowCount()) {
            Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o foi criada.", 5);
            return true;
        }
        if (contadorNaoCriadas == 0) {
            if (this.modelo.getRowCount() > 1) {
                this.gerarMultiguias();
            }
            return true;
        }
        Funcoes.mensagem(this, "Algumas requisi\u00e7\u00f5es n\u00e3o foram criadas.\nCrie todas as requisi\u00e7\u00f5es antes de concluir.", 2);
        return false;
    }

    private void gerarMultiguias() {
        Object requisicaoPai = 0;
        ArrayList<Object> listaFilhas = new ArrayList<Object>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            Integer req = Integer.parseInt((String)this.modelo.getValueAt(i, 0));
            listaFilhas.add(req);
            if ((Integer)requisicaoPai == 0) {
                requisicaoPai = req;
            }
            if (req >= (Integer)requisicaoPai) continue;
            requisicaoPai = req;
        }
        Statement st = Conexao.getStatement();
        try {
            for (Integer n : listaFilhas) {
                if (n.equals(requisicaoPai)) continue;
                StringBuilder buf = new StringBuilder();
                buf.append("insert into requisicaorequisicao (fil_codigo, req_codigo, req_kodigo) values (");
                buf.append(Variaveis.filialPadrao);
                buf.append(",");
                buf.append(String.valueOf(requisicaoPai));
                buf.append(",");
                buf.append(n);
                buf.append(")");
                Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            }
            st.close();
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir multiguias.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void geraRequisicao(int linha) {
        CriarRequisicao_ criarRequisicao = new CriarRequisicao_(Laboratorio.getInstancia());
        criarRequisicao.requisicao.setConvenioOrcamento(String.valueOf(this.convenio.getCodigo()));
        criarRequisicao.requisicao.setFormaPagamento(this.bean.getFormaPagamento());
        criarRequisicao.requisicao.setCodigoOrcamento(this.bean.getCodigo());
        criarRequisicao.requisicao.setPacienteOrcamento(this.bean.getPaciente() != null ? this.bean.getPaciente().getCodigo().toString() : null);
        criarRequisicao.requisicao.setDescontoOrcamento(this.bean.getValorDesconto() != null ? this.bean.getValorDesconto().toString() : "0");
        criarRequisicao.requisicao.setAcrescimoOrcamento(this.bean.getValorAcrescimo() != null ? this.bean.getValorAcrescimo().toString() : "0");
        criarRequisicao.requisicao.setPercentualAcrescimoOrcamento(this.bean.getPercentualAcrescimo().toString());
        criarRequisicao.requisicao.setPercentualDescontoOrcamento(this.bean.getPercentualDesconto().toString());
        criarRequisicao.requisicao.setGerarGuiaOrcamento(false);
        criarRequisicao.requisicao.utilizarSenha(this.senhaGerada);
        this.preencherDadosBeanRequisicaoAlimentos();
        if (this.entidadeBean != null) {
            criarRequisicao.requisicao.setResponsavelOrcamento(this.entidadeBean);
        }
        if (this.requisicaoBean != null) {
            criarRequisicao.requisicao.setRequisicaoBeanOrcamento(this.requisicaoBean);
        }
        ArrayListExames lista = (ArrayListExames)this.modelo.getValueAt(linha, 5);
        BigDecimal desconto = BigDecimal.ZERO;
        BigDecimal acrescimo = BigDecimal.ZERO;
        for (int i = 0; i < lista.size(); ++i) {
            ExameMatColetaVO exame = (ExameMatColetaVO)lista.get(i);
            ObjetoTotalExame objExame = this.listaValoresExame.get(exame);
            if (this.convenio.getPercentualBalcao() == 0.0 || this.convenio.getPercentualBalcao() == 100.0) {
                desconto = objExame.getValorDesconto();
                acrescimo = objExame.getValorAcrescimo();
            }
            try {
                criarRequisicao.requisicao.adicionaExameOrcamento(exame.getExame().getCodigo(), exame.getExame().getDescricao(), ExameUtil.getDadosMaterial(Variaveis.filialPadrao, exame.getMaterial().getCodigo()), exame.getMetodologia(), desconto, acrescimo);
                continue;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar a requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        criarRequisicao.setVisible(true);
        if (criarRequisicao.requisicao.getCodigoRequisicaoOrcamento() > -1) {
            this.reqPai = criarRequisicao.requisicao.getCodigoRequisicaoOrcamento();
        }
        if (criarRequisicao.requisicao.getCodigoRequisicaoOrcamento() > -1) {
            String requisicaoNova = String.valueOf(criarRequisicao.requisicao.getCodigoRequisicaoOrcamento());
            this.codigoResponsavel = criarRequisicao.requisicao.getResponsavelOrcamento();
            this.atualizaBean(requisicaoNova);
            if (!Funcoes.textoVazio(requisicaoNova)) {
                Double valor = (double)criarRequisicao.requisicao.getValorTotalOrcamento();
                Double saldo = (double)criarRequisicao.requisicao.getSaldoOrcamento();
                this.modelo.setValueAt(requisicaoNova, linha, 0);
                this.modelo.setValueAt(Funcoes.formataDecimal(valor), linha, 3);
                this.modelo.setValueAt(Funcoes.formataDecimal(saldo), linha, 4);
                ArrayList<ExameMatColetaVO> listaExames = criarRequisicao.requisicao.getListaExames();
                ArrayListExames listaAux = new ArrayListExames();
                if (listaAux != null) {
                    for (ExameMatColetaVO exame : listaExames) {
                        listaAux.add((ExameMatColetaVO)exame);
                    }
                }
                this.modelo.setValueAt(listaAux, linha, 5);
                this.controlaBotaoNovo();
            }
        }
    }

    private PanelAlimentos preencherDadosBeanRequisicaoAlimentos() {
        PanelAlimentos panel = null;
        this.atualizaBean(String.valueOf(this.reqPai));
        if (this.reqPai > 0 && this.requisicaoBean != null) {
            try {
                panel = new PanelAlimentos();
                ResultSet dadosAlimentos = this.buscaDadosAlimentos(Integer.parseInt(Variaveis.filialPadrao), this.reqPai);
                if (dadosAlimentos.next()) {
                    this.preencher(this.requisicaoBean, dadosAlimentos);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
        return panel;
    }

    private void preencher(RequisicaoBean bean, ResultSet dadosAlimentos) throws Exception {
        String codigoFilial = Variaveis.filialPadrao;
        String codigoPais = dadosAlimentos.getString("pais");
        EmbalagemRecebidaVO embalagem = (EmbalagemRecebidaVO)this.embalagemRecebidaService.getVO(codigoFilial, codigoPais);
        if (embalagem != null) {
            bean.setEmbalagem(embalagem);
        }
        bean.setDescricaoProduto(dadosAlimentos.getString("descricaoProduto"));
        bean.setNumeroRegistroProduto(dadosAlimentos.getString("numeroRegistroProduto"));
        bean.setDataValidadeProduto(dadosAlimentos.getString("dataValidade"));
        bean.setLacreProduto(dadosAlimentos.getString("lacreProduto"));
        bean.setTemperaturaRecebimentoProduto(dadosAlimentos.getString("temperaturaRecebimento"));
        bean.setCondicoesAmbientaisProduto(dadosAlimentos.getString("condicoesAmbProduto"));
        bean.setPartidaProduto(dadosAlimentos.getString("partidaProduto"));
        bean.setNumeroSolicitacaoProduto(dadosAlimentos.getString("nrSolicitacaoProduto"));
        bean.setDocumentoReferenciaProduto(dadosAlimentos.getString("doctorReferenciaProduto"));
        bean.setNumeroLoteProduto(dadosAlimentos.getString("numeroLoteProduto"));
        bean.setDataFabricacao(dadosAlimentos.getString("dataFabricacao"));
        bean.setTemperaturaColetaProduto(dadosAlimentos.getString("temperaturaColetaProduto"));
        bean.setMarcaProduto(dadosAlimentos.getString("marcaProduto"));
        bean.setLacreProdutoContra(dadosAlimentos.getString("lacreProdutoContra"));
        bean.setCaracteristicasSanitariasProduto(dadosAlimentos.getString("sanitariasProduto"));
        bean.setProcedimentoColetaProduto(dadosAlimentos.getString("procedimentoColetaProduto"));
        bean.setLocalColetaProduto(dadosAlimentos.getString("localColetaProduto"));
        bean.setTipoRecebimentoProduto(dadosAlimentos.getString("tipoRecebimentoproduto"));
        bean.setLacreProdutoContraEmpresa(dadosAlimentos.getString("lacreProdutoContraEmpresa"));
        bean.setNumeroCertificado(dadosAlimentos.getString("numeroCertificado"));
        UnidadeMedidaVO unidadeMedida = this.buscaUnidadeMedidaVO(codigoFilial, dadosAlimentos.getString("unidadeMedida"));
        if (unidadeMedida != null) {
            bean.setUnidadeMedida(unidadeMedida);
        }
        if (codigoPais != null) {
            PaisVO pais = this.buscaPaisVO(codigoFilial, codigoPais);
            bean.setPais(pais);
        }
        bean.setTermoColetaAmostra(dadosAlimentos.getString("termoColetaAmostra"));
        bean.setFornecedor(dadosAlimentos.getString("fornecedorProduto"));
        bean.setCertificadoOrigem(dadosAlimentos.getDate("certificadoOrigem"));
        bean.setCategoria(dadosAlimentos.getInt("cplCodigo"));
        bean.setCodigoProduto(dadosAlimentos.getInt("palCodigo"));
    }

    private UnidadeMedidaVO buscaUnidadeMedidaVO(String filial, String codigo) {
        UnidadeMedidaVO unidadeMedida = null;
        try {
            unidadeMedida = (UnidadeMedidaVO)this.unidadeMedidaService.get(filial, codigo).toVO();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return unidadeMedida;
    }

    private PaisVO buscaPaisVO(String filial, String codigo) {
        PaisVO pais = null;
        try {
            pais = (PaisVO)this.paisService.getVO(filial, codigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return pais;
    }

    private ResultSet buscaDadosAlimentos(int filial, int requisicao) {
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \treq_descricaoproduto \t\t\t\t\t\tas descricaoProduto, \t\t\t  req_datafabricacao \t\t\t\t\t\tas dataFabricacao, ");
        sql.append("\t\t\t\treq_numeroregistroproduto\t\t\t\tas numeroRegistroProduto,\t  req_temperaturacoletaproduto\t\tas temperaturaColetaProduto,");
        sql.append("\t\t\t\treq_datavalidade\t\t \t\t\t\t\t\tas dataValidade,\t\t\t\t\t  req_marcaproduto \t\t\t\t\t\t\tas marcaProduto, ");
        sql.append("\t\t\t\treq_lacreproduto\t\t\t\t\t\t\t\tas lacreProduto, \t\t\t\t\t  req_lacreprodutocontra\t\t\t\tas lacreProdutoContra,");
        sql.append("\t\t\t\treq_temperaturarecebimento\t\t\tas temperaturaRecebimento,  req_sanitariasproduto\t\t\t\t\tas sanitariasProduto, ");
        sql.append("\t\t\t\treq_condicoesambproduto\t\t\t\t\tas condicoesAmbProduto,\t\t  req_procedimentocoletaproduto as procedimentoColetaProduto,");
        sql.append("\t\t\t\treq_partidaproduto\t\t\t\t\t\t\tas partidaProduto, \t\t\t\t  req_localcoletaproduto \t\t\t\tas localColetaProduto, ");
        sql.append("\t\t\t\treq_nrsolicitacaoproduto\t\t\t\tas nrSolicitacaoProduto, \t  req_fornecedorproduto\t\t\t\t\tas fornecedorProduto, ");
        sql.append(" \t\t\t\treq_doctoreferenciaproduto  \t\tas doctorReferenciaProduto, req_tiporecebimentoproduto\t\tas tipoRecebimentoproduto,");
        sql.append("\t\t\t\tcpl_codigo\t\t\t\t\t\t\t\t\t\t\tas cplCodigo,\t\t\t\t\t\t\t\tpal_codigo\t\t\t\t\t\t\t\t\t\tas palCodigo,");
        sql.append("\t\t\t\treq_numeroloteproduto\t\t\t\t\t\tas numeroLoteProduto, \t\t\treq_lacreprodutocontraempresa as lacreProdutoContraEmpresa, ");
        sql.append("\t\t\t\tpai_codigo\t\t\t\t\t\t\t\t\t\t\tas pais,\t\t\t\t\t\t\t\t\t\treq_tcaalimentos\t\t\t\t\t\t\tas termoColetaAmostra, ");
        sql.append("\t\t\t\treq_fornecedorproduto\t\t\t\t\t\tas fornecedorProduto,\t\t\t\treq_datacertificadoalimentos  as certificadoOrigem, ");
        sql.append("\t\t\t\treq_numerocertificadoalimentos\tas numeroCertificado,\t\t\t\tunm_codigo\t\t\t\t\t\t\t\t\t\tas unidadeMedida, ");
        sql.append("\t\t\t\temb_codigo\t\t\t\t\t\t\t\t\t\t\tas embalagemRecebida ");
        sql.append("FROM requisicao ");
        sql.append("WHERE fil_codigo = ").append(filial);
        sql.append("AND req_codigo = ").append(requisicao);
        try {
            Statement st = Conexao.getStatement();
            rs = Conexao.executeQuery(st, sql);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return rs;
    }

    class RequisicaoRender
    extends DefaultTableCellRenderer {
        RequisicaoRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String valorSaldo = (String)JanelaRequisicoesOrcamento.this.modelo.getValueAt(row, 4);
            Double valorAux = new BigDecimal(Funcoes.limpaDecimal(valorSaldo)).doubleValue();
            if (valorAux > 0.0) {
                if (column == 4) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(null);
                }
            } else {
                this.setForeground(null);
            }
            return this;
        }
    }

    class ArrayListExames<ExameMatColetaVO>
    extends ArrayList {
        ArrayListExames() {
        }

        @Override
        public String toString() {
            return Funcoes.intervaloComVirgulas(this);
        }
    }
}

