/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.ConstantesGerais;
import jalis.laboratorio.recepcao.Agendamento;
import jalis.laboratorio.recepcao.PanelAgendamento;
import jalis.laboratorio.recepcao.RepresentacaoAgendamento;
import jalis.model.bean.cadastro.FeriadoBean;
import jalis.servidor.Cliente;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Horario
extends JPanel
implements Comparable {
    private final Color COR_CREME = ScreenUtil.clarearCor(ConstantesGerais.COR_FUNDO_CREME, 50);
    private final Color COR_ALMOCO = Color.BLACK;
    private final Color COR_BLOQUEADO = new Color(139, 136, 120);
    private final Color COR_BLOQUEADO_SELECIONADO = new Color(100, 100, 75);
    private final Color COR_SELECIONADA = new Color(250, 220, 170);
    private final Color COR_DESATIVADA = Color.LIGHT_GRAY;
    private final Color COR_HORA = Color.BLACK;
    private final Color COR_HORA_BLOQUEADO = Color.WHITE;
    private final Color COR_MENSAGEM = Color.WHITE;
    private final int TAMANHO_POR_MINUTO = 2;
    public static Horario horarioSelecionado = null;
    public static boolean bloqueioHorario = false;
    private PanelAgendamento panelAgendamento = null;
    private ArrayList<RepresentacaoAgendamento> agendamentosHorario = new ArrayList();
    public Integer horaInicial = null;
    public Integer minutoInicial = null;
    public Integer horaFinal = null;
    public Integer minutoFinal = null;
    public Integer intervalo = null;
    public Integer quantidadeColetadores = null;
    public Integer contador = null;
    public boolean isDesativado = false;
    public boolean isBloqueado = false;
    public boolean isSelecionado = false;
    public boolean isAlmoco = false;
    public boolean isHorarioDiferenciado = false;
    public boolean isIncorreto = false;
    public FeriadoBean feriado = null;
    private JPanel panelCentral = null;
    private JLabel labelHoraContador = new JLabel();
    private JLabel labelMensagem = new JLabel();

    public Horario(PanelAgendamento panelAgendamento, FeriadoBean feriado) {
        this.panelAgendamento = panelAgendamento;
        this.horaInicial = 0;
        this.minutoInicial = 0;
        this.intervalo = 0;
        this.quantidadeColetadores = 0;
        this.contador = null;
        this.isBloqueado = false;
        this.isDesativado = true;
        this.isHorarioDiferenciado = false;
        this.feriado = feriado;
        this.inicializa();
        this.montaHorario();
    }

    public Horario(PanelAgendamento panelAgendamento, boolean isHorarioDiferenciado, boolean isIncorreto, int horaInicial, int minutoInicial, int intervalo, int qtdeColetadores, Integer contador, int horaFinal, int minutoFinal) {
        this.panelAgendamento = panelAgendamento;
        this.horaInicial = horaInicial;
        this.minutoInicial = minutoInicial;
        this.horaFinal = horaFinal;
        this.minutoFinal = minutoFinal;
        this.intervalo = intervalo;
        this.quantidadeColetadores = qtdeColetadores;
        this.contador = contador;
        this.isBloqueado = false;
        this.isDesativado = false;
        this.isHorarioDiferenciado = isHorarioDiferenciado;
        this.isIncorreto = isIncorreto;
        this.panelCentral = new JPanel(new GridLayout(1, qtdeColetadores, 5, 0));
        this.feriado = panelAgendamento.getFeriado();
        this.inicializa();
        this.setPreferredSize(new Dimension(100, 2 * (intervalo >= 20 ? intervalo : 20)));
        this.setMinimumSize(new Dimension(100, 2 * (intervalo >= 20 ? intervalo : 20)));
        this.montaHorario();
    }

    private void inicializa() {
        this.setName("Horario");
        if (this.isDesativado || this.isBloqueado || this.isAlmoco) {
            this.labelMensagem.setOpaque(false);
            this.labelMensagem.setHorizontalAlignment(0);
            this.labelMensagem.setFont(this.getFont().deriveFont(1).deriveFont(15.0f));
        } else {
            this.panelCentral.setOpaque(false);
        }
        this.labelHoraContador.setOpaque(false);
        this.labelHoraContador.setFont(this.getFont().deriveFont(0).deriveFont(11.0f));
        this.setOpaque(true);
        if (!(this.isDesativado || this.isAlmoco || this.isIncorreto)) {
            this.addListernerMouse();
        }
    }

    private void addListernerMouse() {
        if (this.getMouseListeners().length == 0) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Horario.this.equals(horarioSelecionado)) {
                        Horario.this.desselecionar();
                    } else {
                        Horario.this.selecionar();
                    }
                }
            });
        }
    }

    private void removeListenerMouse() {
        MouseListener[] listeners = this.getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeMouseListener(listeners[i]);
        }
    }

    public boolean getHorarioDiferenciado() {
        return this.isHorarioDiferenciado;
    }

    public boolean getHoraIncorreto() {
        return this.isIncorreto;
    }

    public void setBloqueado(boolean isBloqueado, boolean isAlmoco) {
        this.removeAll();
        this.isBloqueado = isBloqueado;
        this.isAlmoco = isAlmoco;
        if (this.isDesativado || isBloqueado || isAlmoco) {
            this.labelMensagem.setOpaque(false);
            this.labelMensagem.setHorizontalAlignment(0);
            this.labelMensagem.setFont(this.getFont().deriveFont(1).deriveFont(15.0f));
        }
        if (isAlmoco) {
            this.removeListenerMouse();
        } else {
            this.addListernerMouse();
        }
        this.montaHorario();
    }

    private void setCorFundo(Color cor) {
        this.setBackground(cor);
    }

    private void setCorHoraContador(Color cor) {
        this.labelHoraContador.setForeground(cor);
    }

    private void setCorMensagem(Color cor) {
        this.labelMensagem.setForeground(cor);
    }

    public PanelAgendamento getPanelAgendamento() {
        return this.panelAgendamento;
    }

    private void montaHorario() {
        this.setLayout(new BorderLayout());
        if (!this.isDesativado) {
            if (this.isAlmoco) {
                this.setCorFundo(this.COR_ALMOCO);
                this.setCorHoraContador(this.COR_HORA_BLOQUEADO);
                this.setCorMensagem(this.COR_MENSAGEM);
            } else if (this.isBloqueado && this.isSelecionado) {
                this.setCorFundo(this.COR_BLOQUEADO_SELECIONADO);
                this.setCorHoraContador(this.COR_HORA_BLOQUEADO);
                this.setCorMensagem(this.COR_MENSAGEM);
            } else if (this.isBloqueado) {
                this.setBorder(null);
                this.setCorFundo(this.COR_BLOQUEADO);
                this.setCorHoraContador(this.COR_HORA_BLOQUEADO);
                this.setCorMensagem(this.COR_MENSAGEM);
            } else if (this.isSelecionado) {
                this.setCorFundo(this.COR_SELECIONADA);
                this.setCorHoraContador(this.COR_HORA);
            } else {
                this.setBorder(null);
                this.setCorFundo(this.COR_CREME);
                this.setCorHoraContador(this.COR_HORA);
            }
            if (this.isBloqueado) {
                if (this.isAlmoco) {
                    this.labelMensagem.setText("Hor\u00e1rio de almo\u00e7o");
                } else {
                    this.labelMensagem.setText("Agendamento bloqueado");
                }
            }
            if (this.contador != null) {
                String titulo = "<html><font size = 3>" + Funcoes.preencheVazio(String.valueOf(this.contador), 3, 1);
                if (this.feriado != null) {
                    titulo = titulo + " - <font size = 2 color = red>Feriado: \"" + this.feriado.getMotivo() + "\"";
                }
                titulo = titulo + "</html>";
                this.labelHoraContador.setText(titulo);
            } else {
                String titulo = null;
                titulo = this.isAlmoco ? "<html><font size = 3>" + Funcoes.preencheZero(this.horaInicial, 2) + ":" + Funcoes.preencheZero(this.minutoInicial, 2) + " - " + Funcoes.preencheZero(this.horaFinal, 2) + ":" + Funcoes.preencheZero(this.minutoFinal, 2) : (this.isHorarioDiferenciado ? "<html><font size = 3>" + Funcoes.preencheZero(this.horaInicial, 2) + ":" + Funcoes.preencheZero(this.minutoInicial, 2) : "<html><font size = 3>" + Funcoes.preencheZero(this.horaInicial, 2) + ":" + Funcoes.preencheZero(this.minutoInicial, 2) + "<font size = 1> (" + this.intervalo + " min.)");
                if (this.feriado != null) {
                    titulo = titulo + " - <font size = 2 color = red>Feriado: \"" + this.feriado.getMotivo() + "\"";
                }
                titulo = titulo + "</html>";
                this.labelHoraContador.setText(titulo);
            }
            this.add((Component)this.labelHoraContador, "North");
            if (this.isBloqueado) {
                this.add((Component)this.labelMensagem, "Center");
            } else {
                this.add((Component)this.panelCentral, "Center");
            }
        } else {
            this.setCorFundo(this.COR_DESATIVADA);
            this.setCorMensagem(this.COR_MENSAGEM);
            if (this.feriado != null && this.feriado.getPermitirAgendamento() != null && !this.feriado.getPermitirAgendamento().booleanValue()) {
                this.labelMensagem.setText("<html><center>Feriado<br><br>" + this.feriado.getMotivo() + "</center></html>");
            } else {
                this.labelMensagem.setText("Agendamento n\u00e3o permitido");
            }
            this.add((Component)this.labelMensagem, "Center");
        }
    }

    public void addAgendamento(RepresentacaoAgendamento agendamento) {
        if (agendamento != null) {
            this.agendamentosHorario.add(agendamento);
            agendamento.setHorario(this);
            this.panelCentral.removeAll();
            Collections.sort(this.agendamentosHorario);
            for (int i = 0; i < this.agendamentosHorario.size(); ++i) {
                this.panelCentral.add(this.agendamentosHorario.get(i));
            }
            Component[] comps = this.panelCentral.getComponents();
            for (int i = comps.length; i < this.quantidadeColetadores; ++i) {
                this.panelCentral.add(new JLabel());
            }
        }
    }

    public ArrayList<RepresentacaoAgendamento> getAgendamentos() {
        return this.agendamentosHorario;
    }

    public int getQuantidadeAgendamentos() {
        int qtde = 0;
        for (int i = 0; i < this.agendamentosHorario.size(); ++i) {
            RepresentacaoAgendamento rep = this.agendamentosHorario.get(i);
            if (rep.getAgendamento() == null || rep.getAgendamento().getBloqueado() != null && rep.getAgendamento().getBloqueado().booleanValue()) continue;
            ++qtde;
        }
        return qtde;
    }

    public int compareTo(Object o) {
        if (o instanceof Horario) {
            Horario aux = (Horario)o;
            if (this.horaInicial > aux.horaInicial) {
                return 1;
            }
            if (this.horaInicial < aux.horaInicial) {
                return -1;
            }
            return this.minutoInicial.compareTo(aux.minutoInicial);
        }
        return 0;
    }

    private void setSelecionado(boolean isSelecionado) {
        this.isSelecionado = isSelecionado;
        this.montaHorario();
        if (isSelecionado) {
            Agendamento.getInstancia().desselecionarTodosAgendamentos();
            horarioSelecionado = this;
            if (bloqueioHorario) {
                Calendar calAux = null;
                calAux = Calendar.getInstance();
                calAux.setTime(horarioSelecionado.getPanelAgendamento().getData());
                calAux.set(11, Horario.horarioSelecionado.horaInicial);
                calAux.set(12, Horario.horarioSelecionado.minutoInicial);
                Date dataHoraSelecionada = calAux.getTime();
                Cliente.getInstancia().bloqueiaHorario(this.panelAgendamento.getSalaAtendimento().getCodigo(), dataHoraSelecionada);
            }
        } else {
            if (horarioSelecionado != null) {
                Calendar calAux = null;
                calAux = Calendar.getInstance();
                calAux.setTime(horarioSelecionado.getPanelAgendamento().getData());
                calAux.set(11, Horario.horarioSelecionado.horaInicial);
                calAux.set(12, Horario.horarioSelecionado.minutoInicial);
                Date dataHoraSelecionada = calAux.getTime();
                Cliente.getInstancia().liberaHorario(horarioSelecionado.getPanelAgendamento().getSalaAtendimento().getCodigo(), dataHoraSelecionada);
            }
            horarioSelecionado = null;
        }
    }

    public void selecionar() {
        if (horarioSelecionado != null) {
            horarioSelecionado.setSelecionado(false);
        }
        this.setSelecionado(true);
        Agendamento.getInstancia().controlaCampos();
    }

    public void desselecionar() {
        if (horarioSelecionado != null) {
            horarioSelecionado.setSelecionado(false);
        }
        Agendamento.getInstancia().controlaCampos();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Horario) {
            Horario aux = (Horario)o;
            return this.horaInicial.intValue() == aux.horaInicial.intValue() && this.minutoInicial.intValue() == aux.minutoInicial.intValue();
        }
        return false;
    }
}

