/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.RegistroContato;
import jalis.laboratorio.recepcao.RegistroHistoricoContato;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class HistoricoContatoPaciente
extends AbstractDialogoOKCancelar {
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonAnteriores = new JButton("Anteriores");
    private JPanel panelObservacao = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Observa\u00e7\u00e3o"));
    private JPanel panelHistorico = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder(""));
    private JPanel panelBotoes = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder(""));
    JScrollPane scrollPanel = new JScrollPane();
    private ModeloGridTable modelo;
    private JTable table;
    private JTextArea txtObservacao = new JTextArea("");
    private String codigoFilial;
    private String codigoRequisicao;
    private String codigoPaciente;
    private String nomePaciente;
    private Boolean possuiAcessoRegistrarContato;
    private Boolean possuiAcessoRemoverContato;
    private Boolean possuiAcessoHistoricosAnteriores;
    transient List<RegistroHistoricoContato> registroContatos = new ArrayList<RegistroHistoricoContato>();
    transient List<RegistroHistoricoContato> registroContatosAnteriores = new ArrayList<RegistroHistoricoContato>();

    public HistoricoContatoPaciente(Dialog pai) {
        super(pai, "Hist\u00f3rico de Contato com o Paciente");
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public HistoricoContatoPaciente(Frame pai) {
        super(pai, "Hist\u00f3rico de Contato com o Paciente");
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public String getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public void setCodigoRequisicao(String codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public String getCodigoPaciente() {
        return this.codigoPaciente;
    }

    public void setCodigoPaciente(String codigoPaciente) {
        this.codigoPaciente = codigoPaciente;
    }

    public Boolean getPossuiAcessoHistoricosAnteriores() {
        return this.possuiAcessoHistoricosAnteriores;
    }

    public void setPossuiAcessoHistoricosAnteriores(Boolean possuiAcessoHistoricosAnteriores) {
        this.possuiAcessoHistoricosAnteriores = possuiAcessoHistoricosAnteriores;
        this.buttonAnteriores.setEnabled(possuiAcessoHistoricosAnteriores);
    }

    public Boolean getPossuiAcessoRegistrarContato() {
        return this.possuiAcessoRegistrarContato;
    }

    public void setPossuiAcessoRegistrarContato(Boolean possuiAcessoRegistrarContato) {
        this.possuiAcessoRegistrarContato = possuiAcessoRegistrarContato;
        this.buttonOK.setEnabled(possuiAcessoRegistrarContato);
    }

    public Boolean getPossuiAcessoRemoverContato() {
        return this.possuiAcessoRemoverContato;
    }

    public void setPossuiAcessoRemoverContato(Boolean possuiAcessoRemoverContato) {
        this.possuiAcessoRemoverContato = possuiAcessoRemoverContato;
        this.buttonCancelar.setEnabled(possuiAcessoRemoverContato);
    }

    public String getNomePaciente() {
        return this.nomePaciente;
    }

    public void setNomePaciente(String nomePaciente) {
        this.nomePaciente = nomePaciente;
    }

    @Override
    protected boolean acaoOk() {
        return false;
    }

    public static HistoricoContatoPaciente novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new HistoricoContatoPaciente((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new HistoricoContatoPaciente((Frame)pai);
        }
        return null;
    }

    private void montaTela() {
        this.setSize(new Dimension(940, 355));
        this.buttonAnteriores.addActionListener(this);
        this.buttonOK.setText("Registrar contato");
        this.buttonCancelar.setText("Remover contato");
        this.buttonFechar.addActionListener(e -> this.dispose());
        this.buildPanelHistorico();
        this.getContentPane().add((Component)this.panelHistorico, "Center");
        this.panelObservacao.setPreferredSize(new Dimension(270, 600));
        this.scrollPanel = new JScrollPane(this.panelObservacao);
        this.scrollPanel.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)this.scrollPanel, "East");
        this.buildPanelBotoes();
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.table.getSelectionModel().addListSelectionListener(e -> {
            this.validaButtonRemover();
            if (this.table.getSelectedRow() > -1) {
                this.showContatoSelecionado(this.table.getSelectedRow());
                JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
                verticalScrollBar.setValue(verticalScrollBar.getMinimum());
            }
        });
        this.panelObservacao.add(this.txtObservacao);
        this.txtObservacao.setPreferredSize(new Dimension(250, 580));
        this.txtObservacao.setMinimumSize(new Dimension(250, 580));
        this.txtObservacao.setLineWrap(true);
        this.txtObservacao.setWrapStyleWord(true);
        this.txtObservacao.setEditable(false);
        ScreenUtil.setBorda(new Component[]{this.txtObservacao}, new TitledBorder(""));
    }

    private void buildPanelBotoes() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagConstraints a = new GridBagConstraints();
        a.insets = new Insets(0, 2, 0, 4);
        a.anchor = 17;
        this.panelBotoes.add((Component)this.buttonAnteriores, a);
        c.gridy = 0;
        c.gridx = 2;
        c.weightx = 3.0;
        c.insets = new Insets(0, 2, 0, 4);
        c.anchor = 13;
        this.panelBotoes.add((Component)this.buttonOK, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelBotoes.add((Component)this.buttonCancelar, c);
        ++c.gridx;
        this.panelBotoes.add((Component)this.buttonFechar, c);
        this.panelBotoes.setPreferredSize(new Dimension(900, 40));
    }

    private void showContatoSelecionado(int selectedRow) {
        this.txtObservacao.setText(this.registroContatos.get(selectedRow).getObservacao());
    }

    private void buildPanelHistorico() {
        this.panelHistorico = new JPanel(new BorderLayout());
        this.panelHistorico.setLayout(new BorderLayout());
        this.modelo = new ModeloGridTable(new String[]{"Data", "Hora", "Respons\u00e1vel", "Motivo", "Requisi\u00e7\u00e3o"});
        this.table = ComponenteFactory.novoJTable(this.modelo);
        this.modelo.setColumnSize(new int[]{85, 50, 100, 0, 85}, this.table);
        this.panelHistorico.add((Component)new JScrollPane(this.table), "Center");
        this.panelHistorico.setPreferredSize(new Dimension(450, 350));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonAnteriores) {
            this.buscaHistoricoAnterior();
            this.setPossuiAcessoRegistrarContato(false);
            this.setPossuiAcessoRemoverContato(false);
            this.setPossuiAcessoHistoricosAnteriores(false);
        } else if (o == this.buttonOK) {
            this.registrarContato();
        } else if (o == this.buttonCancelar && this.table.getSelectedRow() >= 0) {
            boolean resp;
            boolean bl = resp = Funcoes.mensagem(this, "Deseja remover o contato selecionado?", 4) == 0;
            if (resp) {
                this.removerContato();
            }
        }
    }

    private void registrarContato() {
        RegistroContato registroContato = RegistroContato.novaInstancia(this);
        registroContato.setCodigoFilial(this.getCodigoFilial());
        registroContato.setCodigoRequisicao(this.getCodigoRequisicao());
        registroContato.setCodigoPaciente(this.getCodigoPaciente());
        registroContato.setNomePaciente(this.getNomePaciente());
        registroContato.setVisible(true);
        if (Boolean.TRUE.equals(registroContato.getAcaoSalvar())) {
            this.modelo.clear();
            this.buscaHistorico();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removerContato() {
        StringBuilder bui = new StringBuilder();
        bui.append("delete from historicoregistrocontato ");
        bui.append("where fil_codigo = ").append(this.registroContatos.get(this.table.getSelectedRow()).getCodigoFilial());
        bui.append(" and hrc_codigo = ").append(this.registroContatos.get(this.table.getSelectedRow()).getCodigoContato());
        Statement st2 = Conexao.getStatement();
        try {
            Conexao.executeUpdate(this.getCodigoFilial(), st2, bui.toString());
            Conexao.arquivaSQL();
            this.modelo.clear();
            this.buscaHistorico();
            this.txtObservacao.setText("");
            this.validaButtonRemover();
            Funcoes.mensagem(this, "Registro de contato removido com sucesso!", 5);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaHistoricoAnterior() {
        StringBuilder bui = new StringBuilder();
        bui.append("select h.hrc_datacontato, h.hrc_horacontato, h.usr_codigo, m.mct_descricao, req_codigo, h.hrc_observacao as observacao, h.hrc_codigo as codigo, h.fil_codigo as filCodigo ");
        bui.append("from historicoregistrocontato h ");
        bui.append("inner join motivocontato m on h.mct_codigo = m.mct_codigo and h.fil_codigo = m.fil_codigo ");
        bui.append("where h.fil_codigo = ").append(this.getCodigoFilial());
        bui.append(" and h.pac_codigo = ").append(this.getCodigoPaciente());
        bui.append(" order by h.hrc_datacontato asc, h.hrc_horacontato asc");
        Statement st = Conexao.getStatement();
        HashSet<String> existingCodes = new HashSet<String>();
        for (RegistroHistoricoContato registro : this.registroContatos) {
            existingCodes.add(registro.getCodigoContato());
        }
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                String codigo = rs.getString("codigo");
                if (existingCodes.contains(codigo)) continue;
                this.modelo.addLine(new String[]{Funcoes.formataData("dd/MM/yyyy", rs.getDate("hrc_datacontato")), Funcoes.formataDataHora("HH:mm", rs.getString("hrc_horacontato")), rs.getString("usr_codigo"), rs.getString("mct_descricao"), rs.getString("req_codigo")});
                this.registroContatos.add(new RegistroHistoricoContato(rs.getString("filCodigo"), codigo, rs.getString("observacao")));
                existingCodes.add(codigo);
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buscaHistorico() {
        this.modelo.clear();
        this.registroContatos.clear();
        StringBuilder bui = new StringBuilder();
        bui.append("select h.hrc_datacontato, h.hrc_horacontato, h.usr_codigo, m.mct_descricao, req_codigo, h.hrc_observacao as observacao, h.hrc_codigo as codigo, h.fil_codigo as filCodigo ");
        bui.append("from historicoregistrocontato h ");
        bui.append("inner join motivocontato m on h.mct_codigo = m.mct_codigo and h.fil_codigo = m.fil_codigo ");
        bui.append("where h.fil_codigo = ").append(this.getCodigoFilial());
        if (!Funcoes.textoVazio(this.getCodigoRequisicao())) {
            bui.append(" and h.req_codigo = ").append(this.getCodigoRequisicao());
        }
        bui.append(" and h.pac_codigo = ").append(this.getCodigoPaciente());
        bui.append(" order by h.hrc_datacontato desc, h.hrc_horacontato desc");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            this.buttonAnteriores.setVisible(this.getPossuiAcessoHistoricosAnteriores());
            this.buttonAnteriores.setEnabled(this.getPossuiAcessoHistoricosAnteriores());
            while (rs.next()) {
                this.modelo.addLine(new String[]{Funcoes.formataData("dd/MM/yyyy", rs.getDate("hrc_datacontato")), Funcoes.formataDataHora("HH:mm", rs.getString("hrc_horacontato")), rs.getString("usr_codigo"), rs.getString("mct_descricao"), rs.getString("req_codigo")});
                this.registroContatos.add(new RegistroHistoricoContato(rs.getString("filCodigo"), rs.getString("codigo"), rs.getString("observacao")));
            }
            this.validaButtonRemover();
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void validaButtonRemover() {
        this.buttonCancelar.setEnabled(this.table.getRowCount() > 0 && this.table.getSelectedRow() >= 0 && this.possuiAcessoRemoverContato != false);
    }
}

