/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.recepcao.DialogoDataEntrega;
import jalis.laboratorio.recepcao.DialogoFiltroEntregarResultado;
import jalis.laboratorio.recepcao.ObjetoExame;
import jalis.laboratorio.recepcao.ObjetoRequisicao;
import jalis.laboratorio.relatorios.recepcao.RelatorioRequisicoes;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;

public class EntregarResultadoLote
extends FrmPadrao
implements ActionListener,
ListSelectionListener,
TableModelListener {
    JPanel panelCentral = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new BorderLayout());
    JPanel panelBotoesA = new JPanel(new FlowLayout(2));
    JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    JButton buttonEntregar = ComponenteFactory.novoJButton("Entregar", 'E', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this);
    TTextField textRequisicao = new TTextField(12, 1);
    JLabel labelRequisicao = ComponenteFactory.novoJLabel("Requisi\u00e7\u00e3o:", 'R', null, this.textRequisicao);
    JButton buttonBuscaRequisicao = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    ModeloResultSet modeloRequisicao = new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "M\u00e9dico", "med_nome");
    ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Ent"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }
    };
    JTable tableRequisicao = new JTable(this.modeloRequisicao);
    JTable tableExame = new JTable(this.modeloExame);
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_ENTREGAR = 3;
    protected static final long ACESSO_DEVEDOR = Long.parseLong("0201100101");
    private int status = 1;

    public EntregarResultadoLote() {
        this.montaTela();
        Funcoes.adicionarCtrlI(this.getTopLevelAncestor(), this.panelCentral, Variaveis.filialPadrao, this.tableRequisicao.getSelectedRow() > -1 ? this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow()).getString("req_codigo") : "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EntregarResultadoLote.this.novo();
            }
        });
    }

    public static long getModuloAcesso() {
        return 201100100L;
    }

    private void montaTela() {
        this.setName("EntregarResultadoLote");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentral, "Center");
        Funcoes.criaBarraDescricao(this, "Entrega de resultados em lote", "Entrega de resultados em lote", "recepcao/entrega_resultado_lote.jpg");
        this.buttonFiltrar.setName("buttonFiltrar");
        this.panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonFiltrar), "Center");
        this.panelBotoes.add((Component)this.panelBotoesA, "East");
        this.panelBotoesA.add(this.buttonNovo);
        this.buttonNovo.setName("buttonNovo");
        this.panelBotoesA.add(this.buttonEntregar);
        this.buttonEntregar.setName("buttonEntregar");
        this.panelBotoesA.add(this.buttonCancelar);
        this.buttonCancelar.setName("buttonCancelar");
        this.panelBotoesA.add(this.buttonFechar);
        this.buttonFechar.setName("buttonFechar");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        this.panelCentral.add((Component)this.labelRequisicao, c);
        c.gridx = 1;
        this.textRequisicao.setPreferredSize(new Dimension(130, 20));
        this.textRequisicao.setMinimumSize(new Dimension(130, 20));
        this.panelCentral.add((Component)this.textRequisicao, c);
        this.textRequisicao.setName("textRequisicao");
        c.gridx = 2;
        this.buttonBuscaRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelCentral.add((Component)this.buttonBuscaRequisicao, c);
        this.buttonBuscaRequisicao.setName("buttonBuscaRequisicao");
        c.fill = 2;
        c.gridx = 3;
        c.weightx = 1.0;
        this.panelCentral.add((Component)new JPanel(), c);
        c.gridy = 0;
        this.panelCentral.add((Component)new JPanel(), c);
        c.gridy = 3;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.gridx = 0;
        c.fill = 2;
        this.panelCentral.add((Component)this.panelBotoes, c);
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 2;
        JPanel panelTabelas = new JPanel(new BorderLayout());
        this.panelCentral.add((Component)panelTabelas, c);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder("Requisi\u00e7\u00f5es"));
        this.tableRequisicao.setName("tableRequisicao");
        p.add((Component)new JScrollPane(this.tableRequisicao), "Center");
        p.setPreferredSize(new Dimension(300, 20));
        panelTabelas.add((Component)p, "West");
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(new TitledBorder("Exames"));
        this.tableExame.setName("tableExame");
        p2.add((Component)new JScrollPane(this.tableExame), "Center");
        panelTabelas.add((Component)p2, "Center");
        this.modeloRequisicao.setTamanhoColunas(this.tableRequisicao, 70, 0, 100);
        this.modeloExame.setColumnSize(new int[]{70, 45, 0, 40}, this.tableExame);
        this.tableExame.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.modeloRequisicao.setOrdenarColunas(true);
        this.tableRequisicao.setName("tableRequisicao");
        this.tableRequisicao.getTableHeader().addMouseListener(this.modeloRequisicao);
        Funcoes.montaEnter((JComponent)this.panelCentral);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.textRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (EntregarResultadoLote.this.processarNumeroTubo(null, EntregarResultadoLote.this.textRequisicao)) {
                    // empty if block
                }
                EntregarResultadoLote.this.buscaRequisicao();
            }
        });
        this.tableRequisicao.getSelectionModel().addListSelectionListener(this);
        this.tableExame.getModel().addTableModelListener(this);
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && EntregarResultadoLote.this.tableRequisicao.getSelectedRow() > -1) {
                    EntregarResultadoLote.this.modeloExame.clear();
                    EntregarResultadoLote.this.modeloRequisicao.removerRegistro(EntregarResultadoLote.this.tableRequisicao.getSelectedRow());
                    EntregarResultadoLote.this.modeloRequisicao.fireTableDataChanged();
                }
            }
        });
    }

    private void novo() {
        this.modeloExame.clear();
        this.modeloRequisicao.limpar();
        this.status = 2;
        this.habilitarCampos();
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonEntregar) {
            this.entregar();
        } else if (e.getSource() == this.buttonBuscaRequisicao) {
            this.pesquisaRequisicao();
        } else if (e.getSource() == this.buttonFiltrar) {
            this.filtrar();
        }
    }

    private void filtrar() {
        DialogoFiltroEntregarResultado dialogo = DialogoFiltroEntregarResultado.novaInstancia(this.getTopLevelAncestor());
        dialogo.setLocationRelativeTo(this.getTopLevelAncestor());
        dialogo.setVisible(true);
        if (dialogo.getOk()) {
            List<Registro> registros = dialogo.getRequisicoesSelecionados();
            for (Registro r : registros) {
                ObjetoRequisicao o = this.getRequisicao(Variaveis.filialPadrao, r.getString("req_codigo"));
                if (!this.modeloRequisicao.contemValor("req_codigo", o.getCodigo())) {
                    Registro reg = new Registro();
                    reg.setValor("fil_codigo", Variaveis.filialPadrao);
                    reg.setValor("req_codigo", o.getCodigo());
                    reg.setValor("pac_nome", o.getNome());
                    reg.setValor("med_nome", o.getNomeMedico());
                    reg.setValor("exames", o.getExames());
                    this.modeloRequisicao.addRegistro(reg);
                }
                this.modeloRequisicao.fireTableDataChanged();
            }
            if (this.tableRequisicao.getRowCount() > 0) {
                this.tableRequisicao.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void pesquisaRequisicao() {
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), Variaveis.filialPadrao, false, false, Acesso.getAcesso(Long.parseLong("0200500179")));
        if (resultado != null) {
            this.textRequisicao.setText(resultado.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    private void buscaRequisicao() {
        if (Funcoes.textoVazio(this.textRequisicao.getText())) {
            return;
        }
        if (this.modeloRequisicao.contemValor("req_codigo", this.textRequisicao.getText())) {
            this.textRequisicao.clear();
            this.textRequisicao.grabFocus();
            return;
        }
        ObjetoRequisicao requisicao = this.getRequisicao(Variaveis.filialPadrao, this.textRequisicao.getText());
        if (requisicao == null) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada", 1);
        } else if (requisicao.getSituacao() == 1) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o n\u00e3o pode ser entregue pois possui pend\u00eancias financeiras", 1);
        } else if (requisicao.getSituacao() == 2) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o n\u00e3o possui exames para serem entregues", 2);
        } else {
            Registro reg = new Registro();
            reg.setValor("fil_codigo", Variaveis.filialPadrao);
            reg.setValor("req_codigo", requisicao.getCodigo());
            reg.setValor("pac_nome", requisicao.getNome());
            reg.setValor("med_nome", requisicao.getNomeMedico());
            reg.setValor("exames", requisicao.getExames());
            this.modeloRequisicao.addRegistro(reg);
            this.modeloRequisicao.fireTableDataChanged();
            this.tableRequisicao.setRowSelectionInterval(this.tableRequisicao.getRowCount() - 1, this.tableRequisicao.getRowCount() - 1);
        }
        this.textRequisicao.clear();
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjetoRequisicao getRequisicao(String filial, String requisicao) {
        Statement st;
        ObjetoRequisicao o;
        block5: {
            o = null;
            st = Conexao.getStatement();
            StringBuilder bui = new StringBuilder();
            bui.append(" select a.req_codigo ");
            bui.append("       ,b.pac_nome ");
            bui.append("       ,a.req_total ");
            bui.append("       ,a.req_totpago ");
            bui.append("       ,a.req_deveguia ");
            bui.append("       ,m.med_nome ");
            bui.append("   from requisicao a ");
            bui.append("   left join medico m on a.fil_codigo = m.fil_codigo and a.med_crm = m.med_crm and a.med_conselho = m.med_conselho and a.med_uf = m.med_uf ");
            bui.append("   join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            bui.append("  where a.fil_codigo = ").append(filial);
            bui.append("    and a.req_codigo = ").append(requisicao);
            bui.append("    and a.req_excluida = false ");
            try {
                ResultSet rs = Conexao.executeQuery(st, bui);
                if (!rs.next()) break block5;
                o = new ObjetoRequisicao(rs.getInt("req_codigo"), rs.getString("pac_nome"), rs.getString("med_nome"), rs.getDouble("req_total"), rs.getDouble("req_totpago"), rs.getBoolean("req_deveguia"));
                bui.delete(0, bui.length());
                bui.append(" select a.exa_codigo ");
                bui.append("       ,a.mco_codigo ");
                bui.append("       ,b.exa_descricao ");
                bui.append("       ,a.exr_dataentreguerst ");
                bui.append("       ,a.usr_codentrega ");
                bui.append("   from examerequisicao a ");
                bui.append("   join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                bui.append("   join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
                bui.append("  where a.fil_codigo = ").append(filial);
                bui.append("    and a.req_codigo = ").append(requisicao);
                bui.append("    and a.exr_situacao = '").append("I").append("'");
                bui.append("    and a.exr_excluido = false ");
                rs = Conexao.executeQuery(st, bui);
                ArrayList<ObjetoExame> exames = new ArrayList<ObjetoExame>();
                while (rs.next()) {
                    ObjetoExame e = new ObjetoExame(rs.getString("exa_codigo"), rs.getString("exa_descricao"), ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo")), rs.getString("usr_codentrega"), rs.getTimestamp("exr_dataentreguerst"), true);
                    exames.add(e);
                }
                o.setExames(exames);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EntregarResultadoLote (344)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return o;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            this.modeloExame.clear();
            ArrayList lista = (ArrayList)this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow()).getValor("exames");
            for (ObjetoExame o : lista) {
                this.modeloExame.addLine(new Object[]{o.getCodigo(), o.getMaterial(), o.getDescricao(), o.isEntregue()});
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int linha = e.getFirstRow();
        int coluna = e.getColumn();
        if (coluna != 3) {
            return;
        }
        boolean b = (Boolean)this.modeloExame.getValueAt(linha, 3);
        ((ObjetoExame)((ArrayList)this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow()).getValor("exames")).get(linha)).setEntregue(b);
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.modeloExame.clear();
            this.modeloRequisicao.limpar();
            this.status = 1;
            this.habilitarCampos();
            this.buttonNovo.grabFocus();
        }
    }

    private void habilitarCampos() {
        this.textRequisicao.setEnabled(this.status == 2);
        this.buttonBuscaRequisicao.setEnabled(this.status == 2);
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonEntregar.setEnabled(this.status == 2);
        this.buttonFiltrar.setEnabled(this.status == 2);
        this.buttonCancelar.setEnabled(this.status == 2);
    }

    @Override
    public void pressioneiF2() {
        if (this.textRequisicao.hasFocus()) {
            this.pesquisaRequisicao();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entregar() {
        Statement st3;
        Statement st2;
        Statement st;
        block21: {
            Date dataEntregue;
            String entreguePara;
            StringBuilder buf;
            block20: {
                DialogoDataEntrega d;
                block19: {
                    if (this.tableRequisicao.getRowCount() <= 0) {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 requisi\u00e7\u00f5es para serem entregues", 2);
                        ScreenUtil.requisitarFoco(this.tableRequisicao);
                        return;
                    }
                    this.buttonEntregar.setEnabled(false);
                    st = Conexao.getStatement();
                    st2 = Conexao.getStatement();
                    st3 = Conexao.getStatement();
                    buf = new StringBuilder();
                    d = DialogoDataEntrega.novaInstancia((Frame)this.getTopLevelAncestor());
                    if (d != null) break block19;
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel solicitar os dados de entrega, a entrega ser\u00e1 cancelada.", 1);
                    this.buttonEntregar.setEnabled(true);
                    ScreenUtil.requisitarFoco(this.tableRequisicao);
                    Conexao.fecharStatement(st, st2, st3);
                    return;
                }
                entreguePara = "Paciente";
                dataEntregue = new Date();
                d.setVisible(true);
                if (d.getOK()) {
                    entreguePara = d.getEntreguePara();
                    dataEntregue = d.getDataEntregue();
                    break block20;
                }
                Funcoes.mensagem(this, "A entrega foi cancelada, um respons\u00e1vel pelo recebimento deve ser informado", 1);
                this.buttonEntregar.setEnabled(true);
                ScreenUtil.requisitarFoco(this.tableRequisicao);
                Conexao.fecharStatement(st, st2, st3);
                return;
            }
            try {
                StringBuilder whereAdicional = new StringBuilder();
                for (int i = 0; i < this.tableRequisicao.getRowCount(); ++i) {
                    ArrayList exames = (ArrayList)this.modeloRequisicao.getRegistro(i).getValor("exames");
                    for (ObjetoExame o : exames) {
                        if (!o.isEntregue()) continue;
                        String codigoRequisicao = this.modeloRequisicao.getRegistro(i).getString("req_codigo");
                        String codigoExame = o.getCodigo();
                        String codigoMaterial = String.valueOf(o.getMaterial().getCodigo());
                        buf.delete(0, buf.length());
                        buf.append("update examerequisicao set exr_dataentreguerst = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", dataEntregue)).append("', usr_codentrega = '");
                        buf.append(Variaveis.login).append("', ");
                        buf.append("exr_situacao = '").append("E").append("', ");
                        buf.append("exr_entrpara = '");
                        if (entreguePara.length() > 40) {
                            entreguePara = entreguePara.substring(0, 40);
                        }
                        buf.append(StringUtil.textoDB(entreguePara));
                        buf.append("'");
                        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and req_codigo = ").append(codigoRequisicao);
                        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' ");
                        buf.append(" and mco_codigo = ").append(codigoMaterial);
                        if (!Funcoes.textoVazio(whereAdicional.toString())) {
                            whereAdicional.append(" or ");
                        }
                        whereAdicional.append(" (a.req_codigo = ").append(codigoRequisicao);
                        whereAdicional.append(" and b.exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' ");
                        whereAdicional.append(" and b.mco_codigo = ").append(codigoMaterial).append(") ");
                        DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, codigoRequisicao, codigoExame, codigoMaterial, "E", false);
                        Conexao.execute(Variaveis.filialPadrao, st, buf);
                    }
                }
                Conexao.arquivaSQL();
                if (Funcoes.mensagem(this, "Deseja imprimir o relat\u00f3rio de requisi\u00e7\u00f5es entregues?", 4) != 0) break block21;
                String ordemRelatorio = null;
                switch (this.modeloRequisicao.getColunaOrdenada()) {
                    case 1: {
                        ordemRelatorio = "Nome Paciente";
                        break;
                    }
                    case 2: {
                        ordemRelatorio = "M\u00e9dico";
                        break;
                    }
                    case 0: {
                        ordemRelatorio = "C\u00f3digo";
                    }
                }
                String sql = RelatorioRequisicoes.getSelect(new String[]{Variaveis.filialPadrao}, whereAdicional.toString(), 5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ordemRelatorio, "E", false, false, false, false, false, null);
                sql = this.modeloRequisicao.getSentidoOrdenacao() < 0 ? sql + " DESC" : sql + " ASC";
                final JDialog dialogo = new JDialog((JFrame)this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es entregues", true);
                JPanel p = new JPanel(new BorderLayout());
                dialogo.add((Component)p, "Center");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        dialogo.dispose();
                    }
                };
                boolean acessoFiltrarUsuario = Acesso.getAcesso(RelatorioRequisicoes.ACESSO_FILTRARUSUARIO);
                boolean acessoFiltrarEstacao = Acesso.getAcesso(RelatorioRequisicoes.ACESSO_FILTRARESTACAO);
                RelatorioRequisicoes.imprimirRelatorio(false, dialogo, p, sql, 5, new String[]{Variaveis.filialPadrao}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ordemRelatorio, "E", false, false, false, 0, false, null, runnable, null, false, false, false, null, false, false, null, false, false, null, true, st, st2, st3, Variaveis.tipoFilialPadrao, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame(), acessoFiltrarUsuario, acessoFiltrarEstacao, Variaveis.login, Variaveis.codigoEstacao, Variaveis.filialPadrao);
                dialogo.setSize(new Dimension(700, 500));
                dialogo.setVisible(true);
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EntregarResultadoLote (393)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2, st3);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2, st3);
            }
        }
        Conexao.fecharStatement(st, st2, st3);
        this.novo();
    }
}

