/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.informacao.InfoExame;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmPadrao;
import jalis.integracao.painelsenhas.ChamadaPaciente;
import jalis.integracao.painelsenhas.InformacaoSenha;
import jalis.integracao.painelsenhas.LabelSenhaSolicitada;
import jalis.integracao.painelsenhas.PainelSenhas;
import jalis.integracao.painelsenhas.SenhaRemovidaListener;
import jalis.integracao.painelsenhas.SolicitarFila;
import jalis.integracao.painelsenhas.dto.FilaTotemDTO;
import jalis.integracao.painelsenhas.dto.SenhaGeradaDTO;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.recepcao.MostrarObservacoes;
import jalis.laboratorio.recepcao.PendenciasPaciente;
import jalis.laboratorio.recepcao.RenderizarEntrega;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.CaixaListener;
import jalis.laboratorio.recepcao.exception.EntregaResultadoException;
import jalis.laboratorio.recepcao.util.DadosEntrega;
import jalis.laboratorio.recepcao.util.EstornoCaixaListener;
import jalis.laboratorio.recepcao.util.ListaEntregas;
import jalis.laboratorio.recepcao.util.MostraCaixa;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirTermoConsentimento;
import jalis.laboratorio.util.impressao.notificacao.NotificacaoService;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.recepcao.EntregaResultadoVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.auxiliares.TermoConsentimentoService;
import jalis.service.recepcao.EntregaResultadoService;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.service.recepcao.entrega.DadosEntregaService;
import jalis.util.ArraysUtil;
import jalis.util.Biometria;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TAvisoLabel;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.codec.binary.Base64;

public class EntregaResultado
extends FrmPadrao
implements ActionListener,
EstornoCaixaListener,
CaixaListener {
    private static final long ACESSO_PAINEL_ATENDIMENTO = Long.parseLong("0000600000");
    private String impressoraSelecionada;
    private JPanel panelCentro = new JPanel(null);
    private JTable tableExame = new JTable();
    private JScrollPane scrollExame = new JScrollPane(this.tableExame);
    private JPanel panelExame = new JPanel(new BorderLayout());
    private JPanel panelCampos = new JPanel(null);
    private JPanel panelMultiguia = new JPanel(new BorderLayout());
    private JTable tableMultiguia = new JTable();
    private JScrollPane scrollMultiguia = new JScrollPane(this.tableMultiguia);
    private JPanel panelLateral = new JPanel(new BorderLayout());
    private JPanel panelOpcao = new JPanel(null);
    private JPanel panelSul = new JPanel(null);
    private JPanel panelNotificacao = new JPanel(null);
    private JPanel panelEntrega = new JPanel(null);
    private JPanel panelCaixa = new JPanel(null);
    private JPanel panelEntregar = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesA = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesB = new JPanel(new FlowLayout(2));
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Previs\u00e3o", "Entrega", "Sit"});
    private ModeloGridTable modeloMultiguia = new ModeloGridTable(new String[]{"C\u00f3digo", "Data"});
    private JButton buttonObservacoes = ComponenteFactory.novoJButton("Observa\u00e7\u00f5es", 'b', this);
    private JButton buttonEntregarTodos = new JButton("Entregar todos");
    private final LabelSenhaSolicitada lblSenhaGerada = new LabelSenhaSolicitada();
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonNaoEntregue = new JButton("N\u00e3o entregue");
    private JButton buttonBuscaRequisicao = new JButton();
    private JButton buttonNotificacao = new JButton("Notifica\u00e7\u00e3o");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelVUsuario = new JLabel();
    private JLabel labelDataHora = new JLabel("Data/Hora:");
    private JLabel labelVDataHora = new JLabel();
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelPara = new JLabel("Para:");
    private TTextField txtPara = new TTextField(40);
    private TTextField txtCodRequisicao = new TTextField(12, 1);
    private TTextField textFilial = new TTextField(5, 1);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, this.textFilial);
    private JButton buttonFilial = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EntregaResultado.this.pesquisarFilial();
        }
    }, true);
    private TAvisoLabel labelVPaciente = new TAvisoLabel();
    private JLabel labelIdade = new JLabel("Idade:");
    private JLabel labelVIdade = new JLabel();
    private JLabel labelNasc = new JLabel("Data Nasc:");
    private JLabel labelVNasc = new JLabel();
    private JLabel labelSexo = new JLabel("Sexo:");
    private TAvisoLabel labelVSexo = new TAvisoLabel();
    private JLabel labelDestino = new JLabel("Destino:");
    private JLabel labelCodDestino = new JLabel();
    private JLabel labelDescDestino = new JLabel();
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelVConvenio = new JLabel();
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private JLabel labelVMedico = new JLabel();
    private JLabel lblDataPrevista = new JLabel("Data prevista");
    private TTextField txtDataPrevista = new TTextField(10, 4);
    private JLabel lblHoraPrevista = new JLabel("Hora prevista");
    private TTextField txtHoraPrevista = new TTextField(5, 6);
    private JCheckBox checkAvisar = new JCheckBox("Avisar paciente");
    private JButton buttonImprimir = new JButton("Imprimir \u25bc");
    private JButton buttonImprimirTodos = new JButton("Imprimir todos");
    private JLabel labelSaldo = new JLabel("Saldo: ");
    private JButton buttonCaixa = new JButton("Caixa");
    private JPopupMenu menuImprimir = new JPopupMenu();
    private JMenuItem itemImprimirComprovante = new JMenuItem("Comprovante");
    private JMenuItem itemImprimirRecibo = new JMenuItem("Recibo");
    private JMenuItem itemImprimirCapa = new JMenuItem("Capa");
    private JMenuItem itemImprimirAnexo = new JMenuItem("Anexo de faturamento");
    private JMenuItem itemImprimirCarteira = new JMenuItem("Carteira");
    private JMenuItem itemImprimirAtestadoPaciente = new JMenuItem("Atestado paciente");
    private JMenuItem itemImprimirAtestadoAcompanhante = new JMenuItem("Atestado acompanhante");
    private JMenuItem itemImprimirExames = new JMenuItem("Exame selecionado");
    private JMenuItem itemImprimirAnexoCobranca = new JMenuItem("Anexo de cobran\u00e7a");
    private JMenuItem itemImprimirEtiquetaLaudo = new JMenuItem("Etiqueta de laudo");
    private JMenu itemTermoConsentimento = new JMenu("Termo de consentimento");
    private JLabel labelFoto = new JLabel("");
    private JLabel labelCamera = new JLabel(ImagemUtils.carregaImagemJalis("cam.gif"));
    private ImageIcon fotoPaciente = null;
    private JPanel panelFotoPaciente = new JPanel(new BorderLayout());
    private JButton buttonReceberGuia = ComponenteFactory.novoJButton("Receber guia/pedido", 'g', this);
    private JPopupMenu menuSenha = new JPopupMenu();
    private final JMenuItem itemSolicitarAtendimento = new JMenuItem("Solicitar Atendimento");
    private final JMenuItem itemSolicitarFila = new JMenuItem("Solicitar Fila");
    private final JMenuItem itemRepetirUltimaSenha = new JMenuItem("Repetir \u00daltima Senha");
    private final JMenuItem itemChamarPacientePorNome = new JMenuItem("Chamar Paciente pelo Nome");
    private JButton buttonSenha = ComponenteFactory.novoJButton("Senha \u25bc", this);
    private JMenuItem itemUtilizarSenha = new JMenuItem();
    private int status = 1;
    private double saldo = 0.0;
    private boolean deveGuia = false;
    private boolean deviaGuia = false;
    private Caixa caixa = new Caixa(this);
    private Caixa[] registroCaixa;
    private DadosConvenios convenio;
    private DadosConvenios convenioRepasse = null;
    private boolean deviaGuiaRepasse = false;
    private JPopupMenu menuNotificacao = new JPopupMenu();
    private JMenuItem itemResponderNotificacao = new JMenuItem("Responder");
    private JMenuItem itemVisualizarNotificacao = new JMenuItem("Visualizar");
    private JMenuItem itemImprimirNotificacao = new JMenuItem("Imprimir");
    private final int COLUNA_EXAME_CODIGO = 0;
    private final int COLUNA_EXAME_MATERIAL = 1;
    private final int COLUNA_EXAME_DESCRICAO = 2;
    private final int COLUNA_EXAME_ENTREGAPREV = 3;
    private final int COLUNA_EXAME_ENTREGAREAL = 4;
    private final int COLUNA_EXAME_SITUACAO = 5;
    private final int COLUNA_EXAME_USRENTREGA = 6;
    private final int COLUNA_EXAME_ENTREGAPARA = 7;
    private final int COLUNA_EXAME_GRAVAR = 8;
    private final int COLUNA_EXAME_DADOS_EXAMES = 9;
    private final int COLUNA_EXAME_NOTIFICACAO = 10;
    private final int COLUNA_MULTIGUIA_CODIGO = 0;
    private final int COLUNA_MULTIGUIA_DATA = 1;
    private final int BUTTON_ENTREGAR = 1;
    private final int BUTTON_NAOENTREGAR = 2;
    private int statusbuttonNaoEntregue = 1;
    private int codigoPaciente = -1;
    private final int IMPRESSAO_CANCELADA = 0;
    private final int IMPRESSAO_OK = 1;
    private final int IMPRESSAO_REIMPRIMIR = 2;
    private final long ACESSO_ENTREGAR = Long.parseLong("0200900101");
    private final long ACESSO_ENTREGAR_TODOS = Long.parseLong("0200900102");
    private final long ACESSO_ALTERAR_DESCONTO = Long.parseLong("0200900103");
    private final long ACESSO_ALTERAR_ACRESCIMO = Long.parseLong("0200900104");
    private final long ACESSO_MOVIMENTAR_CAIXA = Long.parseLong("0200900105");
    private final long ACESSO_ALTERAR_DATA_CAIXA = Long.parseLong("0200900106");
    private final long ACESSO_ALTERAR_CONTA_CAIXA = Long.parseLong("0200900107");
    private final long ACESSO_ESTORNAR_PAGAMENTO = Long.parseLong("0200900108");
    private final long ACESSO_IMPRIMIR_DEVEDORA = Long.parseLong("0200900109");
    private final long ACESSO_ENTREGAR_DEVEDORA = Long.parseLong("0200900110");
    private final long ACESSO_MOVIMENTAR_SEM_PAGAMENTO = Long.parseLong("0200900111");
    private final long ACESSO_MARCAR_DEVE_GUIA = Long.parseLong("0200900112");
    private final long ACESSO_ESTORNO_REPASSE_CAIXA = Long.parseLong("0200900113");
    private final long ACESSO_ENTREGAR_RESULTADO_SEM_IMPRESSAO_DIGITAL_PACIENTE = Long.parseLong("0200900114");
    private final long ACESSO_SALVAR_SEM_PAGADOR = Long.parseLong("0200900115");
    private final long ACESSO_IMPRIMIR_ETIQUETA_LAUDO = Long.parseLong("0200900118");
    private final long ACESSO_TERMO_CONSENTIMENTO = Long.parseLong("0200900120");
    private MostrarObservacoes mostrarObservacoes = null;
    private boolean isExibirMultiguia = false;
    private String biometriaPaciente = null;
    private boolean biometriaInformada = false;
    private boolean haExamesParaEntregar = false;
    private boolean acessoImprimirDevedora = Acesso.getAcesso(this.ACESSO_IMPRIMIR_DEVEDORA);
    private boolean integrar = !ParametrosGerais.getTipoIntegracao().equals("N");
    private ConvenioService convenioService = new ConvenioService();
    private ListaEntregas entregasRealizadas = ListaEntregas.criar(Integer.valueOf(this.getCodigoFilial()));
    private ExameRequisicaoService exameRequisicaoService = new ExameRequisicaoService();
    private DadosEntregaService dadosEntregaService = DadosEntregaService.criar();
    private DadosEntrega dadosEntrega = null;
    private int contaEntregue;
    private List<String> entregues;
    private int contaImpresso;
    private List<String> impressos;
    private int contaIncompleto;

    public EntregaResultado() {
        try {
            this.jbInit();
            this.mostrarObservacoes = MostrarObservacoes.novaInstancia(Laboratorio.getInstancia());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
        }
    }

    public void jbInit() throws Exception {
        this.setName("EntregaResultado");
        this.txtCodRequisicao.setName("txtCodRequisicao");
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Entrega de resultados", "Entrega de resultados ao paciente", "recepcao/entrega_resultado.jpg", this.labelFoto);
        this.menuImprimir.setName("menuImprimir");
        this.menuImprimir.add(this.itemImprimirComprovante);
        this.itemImprimirComprovante.setName("itemImprimirComprovante");
        this.menuImprimir.add(this.itemImprimirRecibo);
        this.itemImprimirRecibo.setName("itemImprimirRecibo");
        this.menuImprimir.add(this.itemImprimirCapa);
        this.itemImprimirCapa.setName("itemImprimirCapa");
        this.menuImprimir.add(this.itemImprimirAnexo);
        this.itemImprimirAnexo.setName("itemImprimirAnexo");
        this.menuImprimir.add(this.itemImprimirCarteira);
        this.itemImprimirCarteira.setName("itemImprimirCarteira");
        this.menuImprimir.add(this.itemImprimirAtestadoPaciente);
        this.itemImprimirAtestadoPaciente.setName("itemImprimirAtestadoPaciente");
        this.menuImprimir.add(this.itemImprimirAtestadoAcompanhante);
        this.itemImprimirAtestadoAcompanhante.setName("itemImprimirAtestadoAcompanhante");
        this.menuImprimir.add(this.itemImprimirExames);
        this.itemImprimirExames.setName("itemImprimirExames");
        this.itemImprimirExames.setVisible(this.telaEstaEmUpdate() && this.naoEstaDevendoHaGuia() && (this.saldo == 0.0 || this.acessoImprimirDevedora));
        this.menuImprimir.add(this.itemImprimirAnexoCobranca);
        this.itemImprimirAnexoCobranca.setName("itemImprimirAnexoCobranca");
        this.menuImprimir.add(this.itemImprimirEtiquetaLaudo);
        this.itemImprimirEtiquetaLaudo.setName("itemImprimirEtiquetaLaudo");
        this.menuImprimir.add(this.itemTermoConsentimento);
        this.itemTermoConsentimento.setName("itemTermoConsentimento");
        List<String> termos = new TermoConsentimentoService().getDescricaoTermos();
        for (String termo : termos) {
            final JMenuItem itemTermo = new JMenuItem(termo);
            this.itemTermoConsentimento.add(itemTermo);
            itemTermo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Runnable impressaoTermoSelecionado = new ImprimirTermoConsentimento().enviarImpressaoRun(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText(), itemTermo.getText(), EntregaResultado.this.ACESSO_TERMO_CONSENTIMENTO, String.valueOf(EntregaResultado.this.codigoPaciente));
                    new Thread(impressaoTermoSelecionado).start();
                }
            });
        }
        this.menuNotificacao.add(this.itemResponderNotificacao);
        this.menuNotificacao.add(this.itemVisualizarNotificacao);
        this.menuNotificacao.add(this.itemImprimirNotificacao);
        this.menuSenha.setName("menuSenha");
        this.menuSenha.add(this.itemSolicitarAtendimento);
        this.itemSolicitarAtendimento.setName("itemSolicitarAtendimento");
        this.menuSenha.add(this.itemSolicitarFila);
        this.itemSolicitarFila.setName("itemSolicitarFila");
        this.menuSenha.add(this.itemRepetirUltimaSenha);
        this.itemRepetirUltimaSenha.setName("itemRepetirUltimaSenha");
        this.menuSenha.add(this.itemChamarPacientePorNome);
        this.itemChamarPacientePorNome.setName("itemChamarPacientePorNome");
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add((Component)this.panelBotoesA, "West");
        this.panelBotoes.add((Component)this.panelBotoesB, "East");
        this.panelMultiguia.add((Component)this.scrollMultiguia, "Center");
        this.panelExame.add((Component)this.scrollExame, "Center");
        this.panelBotoesA.add(this.buttonReceberGuia);
        this.buttonReceberGuia.setName("buttonReceberGuia");
        this.panelBotoesB.add(this.buttonObservacoes);
        this.buttonObservacoes.setName("buttonObservacoes");
        if (this.possuiAcesso()) {
            this.lblSenhaGerada.setVisible(false);
            this.lblSenhaGerada.setPreferredSize(new Dimension(142, 20));
            this.panelBotoesA.add(this.lblSenhaGerada);
            this.panelBotoesB.add(this.buttonSenha);
            this.buttonSenha.setName("buttonSenha");
        }
        this.panelBotoesB.add(this.buttonNovo);
        this.buttonNovo.setName("buttonNovo");
        this.panelBotoesB.add(this.buttonSalvar);
        this.buttonSalvar.setName("buttonSalvar");
        this.panelBotoesB.add(this.buttonCancelar);
        this.buttonCancelar.setName("buttonCancelar");
        this.panelBotoesB.add(this.buttonFechar);
        this.buttonFechar.setName("buttonFechar");
        this.panelCentro.add(this.panelExame);
        this.panelCentro.add(this.panelEntregar);
        this.panelCentro.add(this.panelLateral);
        this.panelCentro.add(this.buttonBuscaRequisicao);
        this.buttonBuscaRequisicao.setName("buttonBuscaRequisicao");
        this.panelCentro.add(this.panelMultiguia);
        this.panelCentro.add(this.panelCampos);
        this.panelEntregar.add(this.labelUsuario);
        this.panelEntregar.add(this.labelVUsuario);
        this.panelEntregar.add(this.labelDataHora);
        this.panelEntregar.add(this.labelVDataHora);
        this.panelEntregar.add(this.labelPara);
        this.panelEntregar.add(this.txtPara);
        this.txtPara.setName("txtPara");
        this.panelEntregar.add(this.buttonNaoEntregue);
        this.buttonNaoEntregue.setName("buttonNaoEntregue");
        if (this.integrar) {
            this.panelCentro.add(this.labelFilial);
            this.panelCentro.add(this.textFilial);
            this.textFilial.setName("textFilial");
            this.panelCentro.add(this.buttonFilial);
            this.buttonFilial.setName("buttonFilial");
        }
        this.panelCentro.add(this.labelRequisicao);
        this.panelCentro.add(this.txtCodRequisicao);
        this.txtCodRequisicao.setName("txtCodRequisicao");
        this.panelCentro.add(this.labelVPaciente);
        this.panelCentro.add(this.labelCamera);
        this.panelCampos.add(this.labelIdade);
        this.panelCampos.add(this.labelVIdade);
        this.panelCampos.add(this.labelSexo);
        this.panelCampos.add(this.labelVSexo);
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            this.panelCampos.add(this.labelNasc);
            this.panelCampos.add(this.labelVNasc);
        }
        this.panelCampos.add(this.labelDestino);
        this.panelCampos.add(this.labelCodDestino);
        this.panelCampos.add(this.labelDescDestino);
        this.panelCampos.add(this.labelConvenio);
        this.panelCampos.add(this.labelVConvenio);
        this.panelCampos.add(this.labelMedico);
        this.panelCampos.add(this.labelVMedico);
        this.panelSul.setLayout(new BorderLayout());
        this.buttonNotificacao.setName("buttonNotificacao");
        this.buttonNotificacao.setBounds(new Rectangle(80, 16, 80, 25));
        this.buttonNotificacao.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNotificacao.setEnabled(false);
        this.panelNotificacao.add(this.buttonNotificacao);
        this.panelSul.add((Component)this.panelNotificacao, "Center");
        this.panelSul.add((Component)this.panelCaixa, "South");
        this.panelLateral.add((Component)this.panelOpcao, "Center");
        this.panelLateral.add((Component)this.panelEntrega, "North");
        this.panelLateral.add((Component)this.panelSul, "South");
        this.panelEntrega.add(this.lblDataPrevista);
        this.panelEntrega.add(this.txtDataPrevista);
        this.txtDataPrevista.setName("txtDataPrevista");
        this.panelEntrega.add(this.lblHoraPrevista);
        this.panelEntrega.add(this.txtHoraPrevista);
        this.txtHoraPrevista.setName("txtHoraPrevista");
        this.panelEntrega.add(this.checkAvisar);
        this.checkAvisar.setName("checkAvisar");
        this.buttonImprimir.setName("buttonImprimir");
        this.panelOpcao.add(this.buttonImprimir);
        this.buttonImprimir.setBounds(new Rectangle(10, 20, 90, 25));
        this.buttonImprimir.setMargin(new Insets(2, 2, 2, 2));
        this.panelOpcao.add(this.buttonImprimirTodos);
        this.buttonImprimirTodos.setName("buttonImprimirTodos");
        this.buttonImprimirTodos.setBounds(102, 20, 120, 25);
        this.buttonImprimirTodos.setMargin(new Insets(2, 2, 2, 2));
        this.panelOpcao.add(this.buttonEntregarTodos);
        this.buttonEntregarTodos.setName("buttonEntregarTodos");
        this.buttonEntregarTodos.setBounds(new Rectangle(102, 50, 120, 25));
        this.panelCaixa.add(this.labelSaldo);
        this.panelCaixa.add(this.buttonCaixa);
        this.buttonCaixa.setName("buttonCaixa");
        this.labelSaldo.setBounds(new Rectangle(10, 20, 120, 15));
        this.labelSaldo.setForeground(Color.RED);
        this.labelSaldo.setOpaque(true);
        this.buttonCaixa.setBounds(new Rectangle(140, 16, 80, 25));
        this.buttonCaixa.setMargin(new Insets(2, 2, 2, 2));
        this.lblDataPrevista.setBounds(new Rectangle(10, 15, 100, 14));
        this.txtDataPrevista.setBounds(new Rectangle(10, 30, 100, 20));
        this.txtDataPrevista.setName("txtDataPrevista");
        this.lblHoraPrevista.setBounds(new Rectangle(10, 52, 100, 14));
        this.txtHoraPrevista.setBounds(new Rectangle(10, 67, 100, 20));
        this.txtHoraPrevista.setName("txtHoraPrevista");
        this.checkAvisar.setMnemonic('v');
        this.checkAvisar.setName("checkAvisar");
        this.checkAvisar.setBounds(new Rectangle(10, 89, 120, 14));
        ScreenUtil.setBorda(new Component[]{this.labelVUsuario, this.labelVDataHora, this.labelVPaciente, this.labelVIdade, this.labelVMedico, this.labelVConvenio, this.labelVSexo, this.labelCodDestino, this.labelDescDestino, this.labelVNasc}, BorderFactory.createTitledBorder(""));
        this.posicionaComponentes();
        this.textFilial.setText(Variaveis.filialPadrao);
        this.textFilial.setName("textFilial");
        this.buttonObservacoes.setVisible(false);
        this.buttonObservacoes.setName("buttonObservacoes");
        this.buttonReceberGuia.setVisible(false);
        this.buttonReceberGuia.setName("buttonReceberGuia");
        this.buttonEntregarTodos.setMnemonic('o');
        this.buttonEntregarTodos.setName("buttonEntregarTodos");
        this.buttonNovo.setMnemonic('N');
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.buttonFechar.setMnemonic('F');
        this.buttonNaoEntregue.setMnemonic('N');
        this.buttonImprimir.setMnemonic('I');
        this.buttonImprimirTodos.setMnemonic('T');
        this.buttonCaixa.setMnemonic('x');
        this.buttonCaixa.setName("buttonCaixa");
        this.buttonBuscaRequisicao.setFocusable(false);
        this.labelRequisicao.setDisplayedMnemonic('q');
        this.labelRequisicao.setLabelFor(this.txtCodRequisicao);
        this.labelPara.setDisplayedMnemonic('r');
        this.labelPara.setLabelFor(this.txtPara);
        this.panelExame.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelMultiguia.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelEntregar.setBorder(BorderFactory.createTitledBorder("Entrega"));
        this.panelCaixa.setBorder(BorderFactory.createTitledBorder("Caixa"));
        this.panelOpcao.setBorder(BorderFactory.createTitledBorder("Op\u00e7\u00f5es"));
        this.panelEntrega.setBorder(BorderFactory.createTitledBorder("Entrega geral"));
        this.panelNotificacao.setBorder(BorderFactory.createTitledBorder("Notifica\u00e7\u00e3o"));
        this.panelEntrega.setPreferredSize(new Dimension(100, 110));
        this.panelCaixa.setPreferredSize(new Dimension(100, 50));
        this.panelNotificacao.setPreferredSize(new Dimension(100, 50));
        this.tableExame.setName("tableExame");
        this.tableExame.setModel(this.modeloExame);
        this.tableExame.setToolTipText("<html>Ctrl + H - Informa\u00e7\u00f5es do exame<br>Ctrl + I - Informa\u00e7\u00f5es da requisi\u00e7\u00e3o</html>");
        this.tableExame.setDefaultRenderer(Object.class, new RenderizarEntrega());
        this.tableMultiguia.setName("tableMultiguia");
        this.tableMultiguia.setModel(this.modeloMultiguia);
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(EntregaResultado.this.txtCodRequisicao.getText())) {
                    GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)EntregaResultado.this.getRootPane().getGlassPane();
                    InfoRequisicao info = EntregaResultado.this.getTopLevelAncestor() instanceof Frame ? new InfoRequisicao((Frame)EntregaResultado.this.getTopLevelAncestor(), glassPaneMensagem) : new InfoRequisicao((Dialog)EntregaResultado.this.getTopLevelAncestor(), glassPaneMensagem);
                    info.setRequisicao(EntregaResultado.this.getCodigoFilial(), Long.parseLong(EntregaResultado.this.txtCodRequisicao.getText()));
                    info.setVisible(true);
                    EntregaResultado.this.getRootPane().setGlassPane(glassPaneMensagem);
                }
            }
        });
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        this.modeloExame.setColumnSize(new int[]{60, 35, 0, 80, 80, 30}, this.tableExame);
        this.modeloMultiguia.setColumnSize(new int[]{60, 0}, this.tableMultiguia);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.controlaCampos(false);
        this.txtDataPrevista.setEnabled(false);
        this.txtHoraPrevista.setEnabled(false);
        this.checkAvisar.setEnabled(false);
        this.txtPara.setEnabled(false);
        this.tableExame.setRowSelectionAllowed(true);
        this.tableExame.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int linhaSelecionada = EntregaResultado.this.getLinhaSelecionadaExame();
                if (linhaSelecionada > -1) {
                    EntregaResultado.this.atualizarPanelEntrega();
                    EntregaResultado.this.itemImprimirExames.setToolTipText(null);
                    if (EntregaResultado.this.permiteReimprimir(linhaSelecionada)) {
                        EntregaResultado.this.itemImprimirExames.setVisible(false);
                        EntregaResultado.this.itemImprimirExames.setToolTipText("Usu\u00e1rio n\u00e3o possui acesso para reimprimir");
                    } else {
                        EntregaResultado.this.itemImprimirExames.setVisible(true);
                    }
                }
                if (EntregaResultado.this.tableExame.getSelectedRows().length > 1) {
                    EntregaResultado.this.itemImprimirExames.setText("Exames selecionados");
                } else {
                    EntregaResultado.this.itemImprimirExames.setText("Exame selecionado");
                }
                int[] rows = EntregaResultado.this.tableExame.getSelectedRows();
                boolean podeImprimir = false;
                for (int i = 0; i < rows.length; ++i) {
                    if (EntregaResultado.this.modeloExame.getValueAt(rows[i], 5).toString().equalsIgnoreCase("E")) continue;
                    podeImprimir = true;
                    break;
                }
                if (podeImprimir) {
                    EntregaResultado.this.itemImprimirExames.setVisible(true);
                } else {
                    EntregaResultado.this.itemImprimirExames.setVisible(false);
                }
                if (linhaSelecionada >= 0 && EntregaResultado.this.modeloExame.getValueAt(linhaSelecionada, 5).toString().equalsIgnoreCase("I") && !EntregaResultado.this.getPermiteReimprimirExames()) {
                    EntregaResultado.this.itemImprimirExames.setVisible(false);
                    EntregaResultado.this.itemImprimirExames.setToolTipText("Usu\u00e1rio n\u00e3o possui acesso para reimprimir");
                } else {
                    EntregaResultado.this.itemImprimirExames.setVisible(true);
                }
            }
        });
        this.modeloExame.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                EntregaResultado.this.haExamesParaEntregar = false;
                for (int i = 0; i < EntregaResultado.this.tableExame.getRowCount(); ++i) {
                    if (!EntregaResultado.this.modeloExame.getValueAt(i, 5).toString().equalsIgnoreCase("I") || EntregaResultado.this.haExamesParaEntregar) continue;
                    EntregaResultado.this.haExamesParaEntregar = true;
                }
                EntregaResultado.this.controlaCampos(false);
            }
        });
        this.tableMultiguia.setRowSelectionAllowed(true);
        this.tableMultiguia.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (EntregaResultado.this.tableMultiguia.getSelectedRow() > -1) {
                    String codigo = (String)EntregaResultado.this.modeloMultiguia.getValueAt(EntregaResultado.this.tableMultiguia.getSelectedRow(), 0);
                    EntregaResultado.this.txtCodRequisicao.setText(codigo);
                    EntregaResultado.this.atualizarInfoRequisicao(codigo);
                }
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.limpaDadosAtendimento();
                EntregaResultado.this.setVisible(false);
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(EntregaResultado.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    EntregaResultado.this.panelMultiguia.setVisible(false);
                    EntregaResultado.this.cancelar();
                }
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.novo();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.salvar(true);
            }
        });
        this.buttonEntregarTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.entregarTodos();
            }
        });
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.menuImprimir.show(EntregaResultado.this.panelOpcao, EntregaResultado.this.buttonImprimir.getX(), EntregaResultado.this.buttonImprimir.getY() + EntregaResultado.this.buttonImprimir.getHeight());
            }
        });
        this.buttonImprimirTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.imprimirTodos();
            }
        });
        this.panelCentro.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EntregaResultado.this.posicionaComponentes();
            }
        });
        this.tableExame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EntregaResultado.this.mostraInfoExame();
            }
        });
        this.tableExame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EntregaResultado.this.mostraInfoExame();
            }
        });
        this.tableExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (EntregaResultado.this.linhaEstaSelecionada() && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                    EntregaResultado.this.mostraInfoExame();
                }
            }
        });
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(72, 2, true), "TELA_INFORMACAO_EXAME", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoExame info = new InfoExame((JFrame)EntregaResultado.this.getTopLevelAncestor());
                if (EntregaResultado.this.linhaEstaSelecionada()) {
                    DadosExames d = (DadosExames)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.getLinhaSelecionadaExame(), 9);
                    DadosMaterial m = (DadosMaterial)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.getLinhaSelecionadaExame(), 1);
                    if (m != null && EntregaResultado.this.convenio != null) {
                        info.setExame(d, m, EntregaResultado.this.convenio);
                    } else {
                        info.setExame(d);
                    }
                }
                info.setVisible(true);
            }
        });
        this.buttonNaoEntregue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.linhaEstaSelecionada()) {
                    if (EntregaResultado.this.statusbuttonNaoEntregue == 1) {
                        DadosExames aux;
                        EntregaResultado.this.labelVUsuario.setText(Variaveis.login);
                        EntregaResultado.this.labelVDataHora.setText(Funcoes.formataData(new Date()) + " " + Funcoes.formataHora(new Date(), false));
                        EntregaResultado.this.txtPara.setText("Paciente");
                        EntregaResultado.this.dadosEntrega = new DadosEntrega(EntregaResultado.this.getCodigoDaRequisicaoSelecionada(), EntregaResultado.this.getCodigoDoExameSelecionado(), EntregaResultado.this.getCodigoDoMaterialSelecionado(), EntregaResultado.this.getAbreviaturaDoMaterialSelecionado(), Variaveis.login, EntregaResultado.this.txtPara.getText().trim(), EntregaResultado.this.getDataEntrega());
                        if (!EntregaResultado.this.biometriaInformada && ParametrosLocais.existeParametro("biometriaCaptura") && !ParametrosLocais.getParametro("biometriaCaptura").equals("Sem biometria") && (aux = (DadosExames)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.getLinhaSelecionadaExame(), 9)).isObrigaBiometriaPaciente() && EntregaResultado.this.biometriaPaciente != null) {
                            int resp = Funcoes.mensagem(EntregaResultado.this, "\u00c9 necess\u00e1ria a identifica\u00e7\u00e3o biom\u00e9trica para entregar o resultado.\nDeseja fazer a leitura da digital do paciente?", 4, true);
                            if (resp == 0) {
                                if (!EntregaResultado.this.verificaImpressaoDigital()) {
                                    Funcoes.mensagem(EntregaResultado.this, "A impress\u00e3o digital informada n\u00e3o confere com a impress\u00e3o digital cadastrada para o paciente.", 2);
                                    return;
                                }
                                EntregaResultado.this.biometriaInformada = true;
                            } else if (Acesso.getAcesso(EntregaResultado.this.ACESSO_ENTREGAR_RESULTADO_SEM_IMPRESSAO_DIGITAL_PACIENTE)) {
                                resp = Funcoes.mensagem(EntregaResultado.this, "Deseja entregar o resultado sem informar a impress\u00e3o digital?", 4, false);
                                if (resp == 1) {
                                    return;
                                }
                            } else {
                                Funcoes.mensagem(EntregaResultado.this, "O resultado n\u00e3o pode ser entregue.", 2);
                                ScreenUtil.requisitarFoco(EntregaResultado.this.buttonNaoEntregue);
                                return;
                            }
                        }
                        if (EntregaResultado.this.biometriaInformada) {
                            EntregaResultado.this.txtPara.setText("Paciente - biometria");
                            this.realizarEntregaDoExameSelecionado();
                        }
                        if (!EntregaResultado.this.biometriaInformada) {
                            EntregaResultado.this.txtPara.setEnabled(true);
                            EntregaResultado.this.txtPara.grabFocus();
                        }
                    } else {
                        EntregaResultado.this.modeloExame.setValueAt(null, EntregaResultado.this.getLinhaSelecionadaExame(), 4);
                        EntregaResultado.this.definirPanelEntregaComoNaoEntregar();
                        EntregaResultado.this.labelVUsuario.setText("");
                        EntregaResultado.this.labelVDataHora.setText("");
                        EntregaResultado.this.txtPara.clear();
                        EntregaResultado.this.txtPara.setEnabled(false);
                    }
                    EntregaResultado.this.modeloExame.setValueAt(new Boolean(true), EntregaResultado.this.getLinhaSelecionadaExame(), 8);
                    EntregaResultado.this.definirBotaoComoNaoEntregue();
                }
                EntregaResultado.this.montaListener();
            }

            private void realizarEntregaDoExameSelecionado() {
                String exame = EntregaResultado.this.getCodigoDoExameSelecionado();
                Integer codigoMaterial = EntregaResultado.this.getCodigoDoMaterialSelecionado();
                String abreviaturaMaterial = EntregaResultado.this.getAbreviaturaDoMaterialSelecionado();
                Integer requisicao = EntregaResultado.this.getCodigoDaRequisicaoSelecionada();
                EntregaResultado.this.entregasRealizadas.adicionar(new DadosEntrega(requisicao, exame, codigoMaterial, abreviaturaMaterial, Variaveis.login, EntregaResultado.this.txtPara.getText(), new Date()));
            }
        });
        this.txtPara.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.txtPara.setEnabled(false);
                EntregaResultado.this.atualizarDadosEntrega();
                EntregaResultado.this.dadosEntrega = null;
                EntregaResultado.this.atualizarPanelEntrega();
                EntregaResultado.this.txtPara.grabFocus();
            }
        });
        this.txtPara.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EntregaResultado.this.txtPara.setEnabled(false);
                EntregaResultado.this.atualizarDadosEntrega();
                EntregaResultado.this.dadosEntrega = null;
                EntregaResultado.this.atualizarPanelEntrega();
            }
        });
        this.buttonCaixa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.caixa.controlaCampos();
                Caixa caixaRequisicao = new Caixa(null);
                boolean caixaAlterado = false;
                try {
                    MostraCaixa mostraCaixa;
                    if (!EntregaResultado.this.isExibirMultiguia || EntregaResultado.this.registroCaixa[EntregaResultado.this.tableMultiguia.getSelectedRow()] == null) {
                        mostraCaixa = new MostraCaixa((Frame)EntregaResultado.this.getTopLevelAncestor(), EntregaResultado.this.caixa);
                    } else {
                        caixaRequisicao = EntregaResultado.this.registroCaixa[EntregaResultado.this.tableMultiguia.getSelectedRow()];
                        mostraCaixa = new MostraCaixa((Frame)EntregaResultado.this.getTopLevelAncestor(), caixaRequisicao);
                        caixaAlterado = true;
                    }
                    mostraCaixa.setVisible(true);
                    if (mostraCaixa.isOK()) {
                        if (!caixaAlterado) {
                            caixaRequisicao = EntregaResultado.this.caixa;
                        }
                        if (EntregaResultado.this.isExibirMultiguia) {
                            ((EntregaResultado)EntregaResultado.this).registroCaixa[((EntregaResultado)EntregaResultado.this).tableMultiguia.getSelectedRow()] = caixaRequisicao;
                            EntregaResultado.this.saldo = EntregaResultado.this.registroCaixa[EntregaResultado.this.tableMultiguia.getSelectedRow()].getValorRestante();
                            if (EntregaResultado.this.registroCaixa[EntregaResultado.this.tableMultiguia.getSelectedRow()].getConvenioRepasseSelecionado() != null) {
                                EntregaResultado.this.saldo = 0.0;
                            }
                        } else {
                            EntregaResultado.this.saldo = caixaRequisicao.getValorRestante();
                            if (caixaRequisicao.getConvenioRepasseSelecionado() != null) {
                                EntregaResultado.this.saldo = 0.0;
                            }
                        }
                    } else if (EntregaResultado.this.caixa.getCaixaAlterado()) {
                        EntregaResultado.this.carregaCaixaRequisicao(EntregaResultado.this.txtCodRequisicao.getText());
                    }
                    EntregaResultado.this.labelSaldo.setText("Saldo: " + Funcoes.formataDecimal(EntregaResultado.this.saldo));
                    EntregaResultado.this.controlaCampos(false);
                }
                catch (Exception e2) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado (901)");
                    }
                }
            }
        });
        this.txtCodRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != EntregaResultado.this.textFilial && !e.isTemporary() && !Funcoes.textoVazio(EntregaResultado.this.txtCodRequisicao.getText())) {
                    if (EntregaResultado.this.processarNumeroTubo(EntregaResultado.this.textFilial, EntregaResultado.this.txtCodRequisicao)) {
                        // empty if block
                    }
                    EntregaResultado.this.mostraDadosRequisicao(EntregaResultado.this.txtCodRequisicao.getText(), Acesso.getAcesso(Long.parseLong("0200900116")));
                }
            }
        });
        this.buttonBuscaRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.buscaRequisicao();
            }
        });
        this.txtCodRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EntregaResultado.this.buscaRequisicao();
                }
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EntregaResultado.this.pesquisarFilial();
                }
            }
        });
        this.itemImprimirComprovante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.salvar(false)) {
                    new Thread("Imprimir Comprovante - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirComprovante(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                                Conexao.arquivaSQL();
                            }
                            catch (Exception ex) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException ec) {
                                    ec.printStackTrace();
                                }
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado (483)");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirRecibo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.salvar(false)) {
                    new Thread("Imprimir recibo - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirRecibo(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirCapa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.salvar(false)) {
                    new Thread("Imprimir Capa - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirCapa(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirAnexo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.salvar(false)) {
                    new Thread("Imprimir Anexo - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirAnexo(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirAnexoCobranca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.salvar(false)) {
                    new Thread("Imprimir Anexo de Cobran\u00e7a - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirAnexoCobranca(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace());
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirCarteira.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.codigoPaciente > -1) {
                    new Thread("Imprimir Carteira - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirCarteira(EntregaResultado.this.getCodigoFilial(), String.valueOf(EntregaResultado.this.codigoPaciente));
                                Conexao.arquivaSQL();
                            }
                            catch (SQLException ex) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirAtestadoPaciente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(EntregaResultado.this.txtCodRequisicao.getText())) {
                    new Thread("Imprimir Atestado - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirAtestadoPaciente(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirAtestadoAcompanhante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(EntregaResultado.this.txtCodRequisicao.getText())) {
                    new Thread("Imprimir Atestado - Jalis"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirAtestadoAcompanhante(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirEtiquetaLaudo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntregaResultado.this.salvar(false)) {
                    new Thread("Imprimir etiqueta de laudo"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirEtiquetaLaudo(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText());
                            }
                            catch (Exception e) {
                                ErrorLogger.mostraMensagem(EntregaResultado.this, e.getMessage(), e.getStackTrace());
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirExames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DadosExames aux;
                if (EntregaResultado.this.tableExame.getSelectedRows().length == 0) {
                    return;
                }
                if (!EntregaResultado.this.biometriaInformada && ParametrosLocais.existeParametro("biometriaCaptura") && !ParametrosLocais.getParametro("biometriaCaptura").equals("Sem biometria") && (aux = (DadosExames)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.getLinhaSelecionadaExame(), 9)).isObrigaBiometriaPaciente() && EntregaResultado.this.biometriaPaciente != null) {
                    int resp = Funcoes.mensagem(EntregaResultado.this, "\u00c9 necess\u00e1ria a identifica\u00e7\u00e3o biom\u00e9trica para imprimir o resultado.\nDeseja fazer a leitura da digital do paciente?", 4, true);
                    if (resp == 0) {
                        if (!EntregaResultado.this.verificaImpressaoDigital()) {
                            Funcoes.mensagem(EntregaResultado.this, "A impress\u00e3o digital informada n\u00e3o confere com a impress\u00e3o digital cadastrada para o paciente.", 2);
                            return;
                        }
                        EntregaResultado.this.biometriaInformada = true;
                    } else if (Acesso.getAcesso(EntregaResultado.this.ACESSO_ENTREGAR_RESULTADO_SEM_IMPRESSAO_DIGITAL_PACIENTE)) {
                        resp = Funcoes.mensagem(EntregaResultado.this, "Deseja imprimir o resultado sem informar a impress\u00e3o digital?", 4, false);
                        if (resp == 1) {
                            return;
                        }
                    } else {
                        Funcoes.mensagem(EntregaResultado.this, "O resultado n\u00e3o pode ser impresso.", 2);
                        ScreenUtil.requisitarFoco(EntregaResultado.this.buttonNaoEntregue);
                        return;
                    }
                }
                if (EntregaResultado.this.salvar(false)) {
                    String[] exames = new String[EntregaResultado.this.tableExame.getSelectedRows().length];
                    String[] materiais = new String[EntregaResultado.this.tableExame.getSelectedRows().length];
                    try {
                        int i = 0;
                        for (int linha : EntregaResultado.this.tableExame.getSelectedRows()) {
                            exames[i] = EntregaResultado.this.getCodigoExame(linha);
                            materiais[i] = String.valueOf(((DadosMaterial)EntregaResultado.this.modeloExame.getValueAt(linha, 1)).getCodigo());
                            ++i;
                        }
                        int situacao = EntregaResultado.this.situacaoExames(true, EntregaResultado.this.tableExame.getSelectedRows());
                        RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(EntregaResultado.this.impressoraSelecionada, EntregaResultado.this.getTopLevelAncestor(), EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText(), situacao == 2 && EntregaResultado.this.getPermiteReimprimirExames(), null, exames, materiais, false);
                        if (Funcoes.textoVazio(EntregaResultado.this.impressoraSelecionada)) {
                            EntregaResultado.this.impressoraSelecionada = retorno.getImpressoraSelecionada();
                        }
                        Conexao.arquivaSQL();
                        EntregaResultado.this.mostraDadosRequisicao(EntregaResultado.this.txtCodRequisicao.getText(), Acesso.getAcesso(Long.parseLong("0200900116")));
                    }
                    catch (Exception ex) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(EntregaResultado.this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
                    }
                }
                EntregaResultado.this.validaBotaoImprimirTodos(EntregaResultado.this.acessoImprimirDevedora);
            }
        });
        this.labelCamera.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                EntregaResultado.this.showFotoPaciente(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                EntregaResultado.this.showFotoPaciente(false);
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !(e.getSource() instanceof JButton)) {
                    RecepcaoUtil.buscaDadosFilial(EntregaResultado.this, EntregaResultado.this.textFilial, EntregaResultado.this.buttonFilial);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                EntregaResultado.this.textFilial.selectAll();
            }
        });
        this.buttonSenha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.menuSenha.remove(EntregaResultado.this.itemUtilizarSenha);
                if (!Funcoes.textoVazio(Variaveis.retornoAtendimentoPainelSenhas.getIdentificador())) {
                    EntregaResultado.this.itemUtilizarSenha.setText(EntregaResultado.this.getSenha());
                    EntregaResultado.this.menuSenha.add(EntregaResultado.this.itemUtilizarSenha);
                }
                EntregaResultado.this.menuSenha.show(EntregaResultado.this.buttonSenha.getParent(), EntregaResultado.this.buttonSenha.getX(), EntregaResultado.this.buttonSenha.getY() + EntregaResultado.this.buttonSenha.getHeight());
            }
        });
        this.itemSolicitarAtendimento.addActionListener(action -> this.painelSenhaSolicitarAtendimento());
        this.itemSolicitarFila.addActionListener(action -> this.painelSenhaSolicitarFila());
        this.itemRepetirUltimaSenha.addActionListener(action -> this.painelRepetirUltimaSenha());
        this.itemChamarPacientePorNome.addActionListener(action -> this.painelChamarPacientePorNome());
        this.itemUtilizarSenha.addActionListener(action -> this.utilizarSenha());
        this.montaListener();
    }

    private void painelSenhaSolicitarAtendimento() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            SenhaGeradaDTO senha = painelSenhas.solicitarAtendimento(false);
            if (senha == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 senhas na fila de atendimento.", 2);
                return;
            }
            InformacaoSenha infoSenha = InformacaoSenha.novaInstancia(Laboratorio.getInstancia(), senha);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
                if (infoSenha.getOK()) {
                    Variaveis.retornoAtendimentoPainelSenhas = senha;
                    this.utilizarSenha();
                }
            }
        }
    }

    private void painelSenhaSolicitarFila() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            List<FilaTotemDTO> filasTotem = painelSenhas.carregarFilasPorTotem();
            SolicitarFila infoSenha = SolicitarFila.novaInstancia(Laboratorio.getInstancia(), filasTotem);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
                if (infoSenha.getOK()) {
                    this.utilizarSenha();
                }
            }
        }
    }

    private void painelRepetirUltimaSenha() {
        PainelSenhas painelSenhas = new PainelSenhas();
        if (painelSenhas.contemConfiguracao()) {
            SenhaGeradaDTO senha = painelSenhas.solicitarAtendimento(true);
            if (senha == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 senhas na fila de atendimento.", 2);
                return;
            }
            InformacaoSenha infoSenha = InformacaoSenha.novaInstancia(Laboratorio.getInstancia(), senha);
            if (infoSenha != null) {
                infoSenha.setVisible(true);
            }
        }
    }

    private void painelChamarPacientePorNome() {
        ChamadaPaciente chamadaPaciente = ChamadaPaciente.novaInstancia(Laboratorio.getInstancia());
        if (!Funcoes.textoVazio(this.labelVPaciente.getText())) {
            chamadaPaciente.setPaciente(this.labelVPaciente.getText());
        }
        if (chamadaPaciente != null) {
            chamadaPaciente.setVisible(true);
        }
    }

    private void utilizarSenha() {
        if (!Funcoes.textoVazio(Variaveis.retornoAtendimentoPainelSenhas.getIdentificador())) {
            this.lblSenhaGerada.setPreferredSize(new Dimension(150, 20));
            this.lblSenhaGerada.setText("<html>Senha solicitada: <b>" + Variaveis.retornoAtendimentoPainelSenhas.getIdentificador() + "</b><html>");
            this.lblSenhaGerada.setVisible(true);
            this.panelBotoesB.repaint();
            this.limpaDadosAtendimento();
        }
    }

    private void removeSenha() {
        this.lblSenhaGerada.setVisible(false);
        Variaveis.retornoAtendimentoPainelSenhas = new SenhaGeradaDTO();
        this.panelBotoesB.repaint();
    }

    private String getSenha() {
        StringBuilder senha = new StringBuilder("Utilizar Senha: ");
        senha.append(Variaveis.retornoAtendimentoPainelSenhas.getIdentificador());
        return senha.toString();
    }

    private boolean possuiAcesso() {
        return Acesso.getAcesso(ACESSO_PAINEL_ATENDIMENTO);
    }

    private void atualizarDadosEntrega() {
        if (!this.dadosEntregaNulo(this.dadosEntrega)) {
            String entreguePara = this.txtPara.getText();
            this.entregasRealizadas.adicionar(new DadosEntrega(this.dadosEntrega.getCodigoRequisicao(), this.dadosEntrega.getCodigoExame(), this.dadosEntrega.getCodigoMaterial(), this.dadosEntrega.getAbreviaturaMaterial(), this.dadosEntrega.getUsuarioEntrega(), entreguePara, this.dadosEntrega.getDataHora()));
            for (int linha = 0; linha < this.tableExame.getRowCount(); ++linha) {
                if (!this.txtCodRequisicao.getText().trim().equals(this.dadosEntrega.getCodigoRequisicao().toString()) || !this.modeloExame.getValueAt(linha, 0).equals(this.dadosEntrega.getCodigoExame()) || !this.modeloExame.getValueAt(linha, 1).toString().equals(this.dadosEntrega.getAbreviaturaMaterial())) continue;
                this.modeloExame.setValueAt(this.dadosEntrega.getUsuarioEntrega(), linha, 6);
                this.modeloExame.setValueAt(this.dadosEntrega.getDataHora(), linha, 4);
                this.modeloExame.setValueAt(entreguePara, linha, 7);
                this.modeloExame.setValueAt(new Boolean(true), linha, 8);
            }
        }
    }

    private boolean dadosEntregaNulo(DadosEntrega d) {
        return d == null;
    }

    private Integer getCodigoDaRequisicao(int linha) throws EntregaResultadoException {
        Object value;
        if (linha > -1 && (value = this.modeloMultiguia.getValueAt(linha, 0)) != null) {
            return Integer.valueOf(value.toString());
        }
        throw EntregaResultadoException.linhaInvalidaException();
    }

    private Integer getCodigoDaRequisicaoSelecionada() {
        Object value;
        if (this.multiguiaFoiSelecionada() && (value = this.modeloMultiguia.getValueAt(this.tableMultiguia.getSelectedRow(), 0)) != null) {
            return Integer.valueOf(value.toString());
        }
        return Integer.parseInt(this.txtCodRequisicao.getText().trim());
    }

    private boolean multiguiaFoiSelecionada() {
        return this.tableMultiguia.getSelectedRow() != -1;
    }

    private void limpaPanelEntrega() {
        this.labelVUsuario.setText("");
        this.labelVDataHora.setText("");
        this.txtPara.setText("");
    }

    private boolean permiteReimprimir(int linhaSelecionada) {
        return this.modeloExame.getValueAt(linhaSelecionada, 5).toString().equalsIgnoreCase("I") && !this.getPermiteReimprimirExames();
    }

    private void atualizarPanelEntrega() {
        int linha = this.getLinhaSelecionadaExame();
        if (this.dadosEntregaNulo(this.dadosEntrega)) {
            if (this.linhaValida(linha)) {
                Integer requisicao = this.getCodigoDaRequisicaoSelecionada();
                String exame = this.getCodigoExame(linha);
                String material = this.getAbreviaturaMaterial(linha);
                DadosEntrega dados = this.entregasRealizadas.buscarEntrega(requisicao, exame, material);
                this.buttonNotificacao.setEnabled(!Funcoes.textoVazio((String)this.modeloExame.getValueAt(this.tableExame.getSelectedRow(), 10)));
                if (dados.dadosSaoValidos()) {
                    this.labelVUsuario.setText(dados.getUsuarioEntrega());
                    this.labelVDataHora.setText(dados.getDataHoraFormatada());
                    this.txtPara.setText(dados.getEntreguePara());
                } else {
                    this.limpaPanelEntrega();
                }
                boolean foiEntregue = dados.dadosSaoValidos();
                this.atualizarBotaoEntregue(foiEntregue);
            } else {
                this.limpaPanelEntrega();
            }
        }
    }

    private boolean linhaValida(int linha) {
        return linha > -1;
    }

    private boolean situacaoDoExameSelecionadoPossuiResultado() {
        return this.getSituacaoExame().equals("I");
    }

    private boolean situacaoDoExameSelecionadoEstaEntregue() {
        return this.getSituacaoExame().equals("E");
    }

    private String getAbreviaturaMaterial(int linha) {
        return this.modeloExame.getValueAt(linha, 1).toString();
    }

    private String getCodigoExame(int linha) {
        Object value = this.modeloExame.getValueAt(linha, 0);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private Integer getCodigoMaterial(int linha) {
        int value = ((DadosMaterial)this.modeloExame.getValueAt(linha, 1)).getCodigo();
        return value;
    }

    private String getDataEntregaExameFormatada(int linha) {
        return this.formatarData(this.getDataEntregaExame(linha));
    }

    private Date getDataEntregaExame(int linha) {
        return (Date)this.modeloExame.getValueAt(linha, 4);
    }

    private String getEntreguePara(int linha) {
        Object value = this.modeloExame.getValueAt(linha, 7);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private String getUsuarioEntrega(int linha) {
        Object value = this.modeloExame.getValueAt(linha, 6);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registro getDadosPagador() {
        Registro retorno = null;
        if (this.codigoPaciente > -1) {
            Statement st;
            block5: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select COALESCE(pac_nomepagador, pac_nome) as nomePaciente ");
                buf.append("       ,pac_cpfpagador as cpfPagador, pac_cpf as cpfPaciente ");
                buf.append("       ,pac_codigo as codPaciente ");
                buf.append("   from paciente pac ");
                buf.append(" where fil_codigo = ").append(this.getCodigoFilial());
                buf.append("   and pac_codigo = ").append(this.codigoPaciente);
                ResultSet rs = null;
                st = Conexao.getStatement();
                try {
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block5;
                    retorno = new Registro(rs);
                }
                catch (Exception e) {
                    Registro registro;
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EntregaResultado (992)");
                        registro = null;
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    return registro;
                }
            }
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    private boolean todosExamesImpressos() {
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (this.modeloExame.getValueAt(i, 5).toString().equalsIgnoreCase("I")) continue;
            return false;
        }
        return true;
    }

    private boolean algumImpresso() {
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!this.modeloExame.getValueAt(i, 5).toString().equalsIgnoreCase("I")) continue;
            return true;
        }
        return false;
    }

    private boolean impressaoParcial() {
        return !this.todosExamesImpressos() && this.algumImpresso();
    }

    private void pesquisarFilial() {
        Hashtable resultado = Pesquisas.filial(this.getTopLevelAncestor(), false);
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void showFotoPaciente(boolean mostrar) {
        this.panelCentro.remove(this.panelFotoPaciente);
        this.panelFotoPaciente.removeAll();
        if (this.fotoPaciente != null && mostrar) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EntregaResultado.this.panelCentro.add((Component)EntregaResultado.this.panelFotoPaciente, 0);
                    EntregaResultado.this.panelFotoPaciente.setBounds(EntregaResultado.this.labelCamera.getX() + 20 - 130, EntregaResultado.this.labelCamera.getY() + 20, 130, 150);
                    EntregaResultado.this.panelFotoPaciente.add((Component)new JLabel(EntregaResultado.this.fotoPaciente), "Center");
                }
            });
        }
        this.panelFotoPaciente.revalidate();
        this.panelFotoPaciente.repaint();
        this.panelCentro.revalidate();
        this.panelCentro.repaint();
    }

    private int situacaoExames() {
        int[] linhas = new int[this.modeloExame.getRowCount()];
        for (int i = 0; i < linhas.length; ++i) {
            linhas[i] = i;
        }
        return this.situacaoExames(false, linhas);
    }

    private int situacaoExames(boolean isButtonImprimir, int ... linhas) {
        int retorno = 1;
        String situacao = "C";
        if (!ParametrosGerais.getConferencia()) {
            situacao = "L";
        }
        this.contaIncompleto = 0;
        this.contaEntregue = 0;
        this.entregues = new ArrayList<String>();
        this.contaImpresso = 0;
        this.impressos = new ArrayList<String>();
        for (int i : linhas) {
            if (this.modeloExame.getValueAt(i, 5).toString().equals("E")) {
                ++this.contaEntregue;
                this.entregues.add((String)this.modeloExame.getValueAt(i, 0));
                continue;
            }
            if (this.modeloExame.getValueAt(i, 5).toString().equals("I")) {
                ++this.contaImpresso;
                this.impressos.add((String)this.modeloExame.getValueAt(i, 0));
                continue;
            }
            if (this.modeloExame.getValueAt(i, 5).toString().equals(situacao)) continue;
            ++this.contaIncompleto;
        }
        if (this.contaIncompleto == this.modeloExame.getRowCount()) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 exames a serem impressos", 2);
            retorno = 0;
        } else if (this.contaImpresso > 0 && isButtonImprimir) {
            if (this.getPermiteReimprimirExames()) {
                retorno = Funcoes.mensagem(this, "Existe exames j\u00e1 impressos na requisi\u00e7\u00e3o.\n " + RecepcaoUtil.getExameImpresso(this.getCodigoFilial(), this.txtCodRequisicao.getText()) + "\nDeseja imprimir novamente?", 4) == 0 ? 2 : 1;
            } else {
                boolean ok = Funcoes.mensagem(this, "Existem exames j\u00e1 impressos na requisi\u00e7\u00e3o.\n " + RecepcaoUtil.getExameImpresso(this.getCodigoFilial(), this.txtCodRequisicao.getText()) + "\nUsu\u00e1rio n\u00e3o possui acesso para reimpress\u00e3o.\nDeseja imprimir os demais exames?", 4) == 0;
                retorno = ok ? 2 : 0;
            }
        }
        return retorno;
    }

    private boolean buscaRequisicao() {
        boolean retorno;
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), this.getCodigoFilial(), false, Acesso.getAcesso(Long.parseLong("0200900116")), Acesso.getAcesso(Long.parseLong("0200500179")));
        boolean bl = retorno = resultado != null;
        if (retorno) {
            if (resultado.contains("fil_codigo")) {
                this.textFilial.setText(resultado.get("fil_codigo").toString());
            }
            this.txtCodRequisicao.setText(resultado.get("req_codigo").toString());
        }
        this.txtCodRequisicao.requestFocus();
        return retorno;
    }

    private void posicionaComponentes() {
        int linhaCampo;
        int xlblVlrPaciente;
        this.labelCamera.setVisible(this.fotoPaciente != null);
        int posLinha = 90;
        int altura = 95;
        int altura2 = 145;
        int diferenca = this.integrar ? 175 : 0;
        int n = xlblVlrPaciente = this.isExibirMultiguia ? 180 : 175;
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            posLinha = 110;
            altura = 115;
            altura2 = 125;
        }
        if (this.isExibirMultiguia) {
            this.panelMultiguia.setVisible(this.isExibirMultiguia);
            this.posicionarPanelEntregar(232, 115, 229, altura2);
            this.posicionarPanelLateral(232, 240, 230, 244);
            this.posicionarPanelExame(148, 115, 380, 120);
            this.posicionarPanelMultiguia(5, 35, 140, 35);
            this.posicionarPanelCampos(145, 25, 135, 415);
        } else {
            this.posicionarPanelCampos(0, 25, 5, 415);
            this.posicionarPanelEntregar(235, posLinha, 230, altura2);
            this.posicionarPanelLateral(235, 235, 230, 240);
            this.posicionarPanelExame(5, posLinha, 240, altura);
        }
        this.revalidate();
        int getX = this.isExibirMultiguia ? this.panelMultiguia.getX() : this.panelExame.getX();
        this.labelUsuario.setBounds(new Rectangle(5, 15, 69, 14));
        this.labelVUsuario.setBounds(new Rectangle(75, 13, 140, 20));
        this.labelDataHora.setBounds(new Rectangle(5, 38, 69, 14));
        this.labelVDataHora.setBounds(new Rectangle(75, 36, 140, 20));
        this.labelPara.setBounds(new Rectangle(5, 61, 69, 14));
        this.txtPara.setBounds(new Rectangle(75, 59, 140, 20));
        this.buttonNaoEntregue.setBounds(new Rectangle(75, 82, 140, 25));
        if (this.integrar) {
            this.labelFilial.setBounds(new Rectangle(getX, 5, 75, 14));
            this.textFilial.setBounds(new Rectangle(getX + 73, 5, 80, 20));
            this.buttonFilial.setBounds(new Rectangle(getX + 154, 5, 20, 20));
        } else {
            this.labelFilial.setVisible(false);
            this.textFilial.setVisible(false);
            this.buttonFilial.setVisible(false);
        }
        this.labelRequisicao.setBounds(new Rectangle(getX + diferenca, 7, 75, 14));
        this.txtCodRequisicao.setBounds(new Rectangle(getX + 73 + diferenca, 5, 80, 20));
        this.buttonBuscaRequisicao.setBounds(new Rectangle(getX + 154 + diferenca, 5, 20, 20));
        this.labelVPaciente.setBounds(new Rectangle(getX + 175 + diferenca, 5, this.panelCentro.getWidth() - (getX + 180) - (this.fotoPaciente != null ? 20 : 0) - diferenca, 20));
        if (this.fotoPaciente != null) {
            this.labelCamera.setBounds(new Rectangle(this.labelVPaciente.getX() + this.labelVPaciente.getWidth() + 1, this.labelVPaciente.getY(), 20, 20));
        }
        int linhaLabel = this.isExibirMultiguia ? 10 : 2;
        int n2 = linhaCampo = this.isExibirMultiguia ? 5 : 2;
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            this.labelIdade.setBounds(new Rectangle(getX, linhaLabel, 140, 14));
            this.labelVIdade.setBounds(new Rectangle(getX + 73, linhaCampo, 101, 20));
            this.labelSexo.setBounds(new Rectangle(getX + 213, linhaLabel, 140, 14));
            this.labelVSexo.setBounds(new Rectangle(getX + 248, linhaCampo, 101, 20));
            this.labelNasc.setBounds(new Rectangle(getX + 390, linhaLabel, 80, 14));
            this.labelVNasc.setBounds(new Rectangle(getX + 460, linhaCampo, 100, 20));
            linhaLabel += 22;
            linhaCampo += 21;
        }
        this.labelDestino.setBounds(new Rectangle(getX, linhaLabel, 60, 14));
        this.labelCodDestino.setBounds(new Rectangle(getX + 73, linhaCampo, 101, 20));
        this.labelDescDestino.setBounds(new Rectangle(getX + 175, linhaCampo, this.panelCentro.getWidth() - (this.panelCampos.getX() + 185), 20));
        this.labelConvenio.setBounds(new Rectangle(getX, linhaLabel += 22, 140, 14));
        this.labelVConvenio.setBounds(new Rectangle(getX + 73, linhaCampo += 21, this.panelCentro.getWidth() - (this.panelCampos.getX() + 83), 20));
        this.labelMedico.setBounds(new Rectangle(getX + 1, linhaLabel += 22, 140, 14));
        this.labelVMedico.setBounds(new Rectangle(getX + 73, linhaCampo += 21, this.panelCentro.getWidth() - (this.panelCampos.getX() + 83), 20));
    }

    private void posicionarPanelEntregar(int xEntregar, int yEntregar, int larguraEntregar, int alturaEntregar) {
        this.panelEntregar.setBounds(new Rectangle(this.panelCentro.getWidth() - xEntregar, yEntregar, larguraEntregar, alturaEntregar));
    }

    private void posicionarPanelLateral(int xPanel, int yPanel, int largura, int altura) {
        this.panelLateral.setBounds(new Rectangle(this.panelCentro.getWidth() - xPanel, yPanel, largura, this.panelCentro.getHeight() - altura));
    }

    private void posicionarPanelExame(int xPanel, int yPanel, int largura, int altura) {
        this.panelExame.setBounds(new Rectangle(xPanel, yPanel, this.panelCentro.getWidth() - largura, this.panelCentro.getHeight() - altura));
    }

    private void posicionarPanelMultiguia(int xPanel, int yPanel, int largura, int altura) {
        this.panelMultiguia.setBounds(new Rectangle(xPanel, yPanel, largura, this.panelCentro.getHeight() - altura));
    }

    private void posicionarPanelCampos(int xPanel, int yPanel, int largura, int altura) {
        this.panelCampos.setBounds(new Rectangle(xPanel, yPanel, this.panelCentro.getWidth() - largura, this.panelCentro.getHeight() - altura));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0200900100");
    }

    public void defineAcessos() {
        this.buttonFechar.setVisible(Acesso.getAcesso(EntregaResultado.getModuloAcesso()));
        this.buttonEntregarTodos.setVisible(Acesso.getAcesso(this.ACESSO_ENTREGAR_TODOS));
        this.buttonSalvar.setVisible(Acesso.getAcesso(this.ACESSO_ENTREGAR));
    }

    private void limpaCampos() {
        this.entregasRealizadas.limpar();
        this.tableExame.getSelectionModel().setSelectionInterval(-1, -1);
        this.modeloExame.clear();
        this.labelVUsuario.setText("");
        this.labelVDataHora.setText("");
        this.txtCodRequisicao.clear();
        this.labelVPaciente.setText("");
        this.labelVPaciente.setNomeSocial(null);
        this.labelVIdade.setText("");
        this.labelVIdade.setToolTipText(null);
        this.labelVSexo.setText("");
        this.labelVSexo.setGenero("");
        this.labelVNasc.setText("");
        this.labelVConvenio.setText("");
        this.labelVMedico.setText("");
        this.txtDataPrevista.clear();
        this.txtHoraPrevista.clear();
        this.labelCodDestino.setText("");
        this.labelDescDestino.setText("");
        this.labelFoto.setIcon(null);
        this.checkAvisar.setSelected(false);
        this.saldo = 0.0;
        this.labelSaldo.setText("Saldo:");
        this.status = 1;
        this.caixa.limpaValores();
        this.convenio = null;
        this.convenioRepasse = null;
        this.codigoPaciente = -1;
        this.fotoPaciente = null;
        this.buttonReceberGuia.setVisible(false);
        this.deviaGuia = false;
        this.deviaGuiaRepasse = false;
        this.biometriaPaciente = null;
        this.biometriaInformada = false;
        this.isExibirMultiguia = false;
        this.registroCaixa = null;
        this.posicionaComponentes();
        this.modeloMultiguia.clear();
        this.txtPara.setText("");
        this.controlaCampos(false);
    }

    private void controlaCampos(boolean habilitaRequisicao) {
        this.controlaCampos(habilitaRequisicao, true);
    }

    private void controlaCampos(boolean habilitaRequisicao, boolean mudarFoco) {
        boolean acessoEntregarDevedora = Acesso.getAcesso(this.ACESSO_ENTREGAR_DEVEDORA);
        boolean acessoReceberGuia = Acesso.getAcesso(this.ACESSO_MARCAR_DEVE_GUIA);
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonSalvar.setEnabled(this.telaEstaEmUpdate());
        this.buttonCancelar.setEnabled(this.telaEstaEmUpdate());
        this.buttonFechar.setEnabled(this.status == 1);
        int linhaSelecionada = this.getLinhaSelecionadaExame();
        this.atualizarBotaoEntregue(this.statusbuttonNaoEntregue == 1);
        this.buttonEntregarTodos.setEnabled(this.telaEstaEmUpdate() && this.naoEstaDevendoHaGuia() && this.haExamesParaEntregar);
        this.buttonObservacoes.setEnabled(this.telaEstaEmUpdate());
        this.buttonReceberGuia.setEnabled(this.telaEstaEmUpdate() && this.deveGuia && acessoReceberGuia);
        this.buttonNotificacao.setEnabled(this.telaEstaEmUpdate());
        if (this.linhaEstaSelecionada() && this.linhaSelecionadaPertenceAoModeloDoExame()) {
            this.atualizarPanelEntrega();
        }
        this.buttonImprimir.setEnabled(this.telaEstaEmUpdate());
        this.buttonCaixa.setEnabled(this.telaEstaEmUpdate());
        this.itemImprimirExames.setVisible(this.saldo == 0.0 && !this.deveGuia || this.acessoImprimirDevedora);
        this.validaBotaoImprimirTodos(this.acessoImprimirDevedora);
        this.txtCodRequisicao.setEnabled(habilitaRequisicao);
        this.buttonBuscaRequisicao.setEnabled(habilitaRequisicao);
        this.textFilial.setEnabled(habilitaRequisicao);
        this.buttonFilial.setEnabled(habilitaRequisicao);
        if (habilitaRequisicao && this.status == 1 && mudarFoco) {
            if (this.integrar) {
                ScreenUtil.requisitarFoco(this.textFilial);
            } else {
                ScreenUtil.requisitarFoco(this.txtCodRequisicao);
            }
        }
        this.itemImprimirEtiquetaLaudo.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_ETIQUETA_LAUDO));
        this.itemTermoConsentimento.setVisible(Acesso.getAcesso(this.ACESSO_TERMO_CONSENTIMENTO));
    }

    private boolean linhaSelecionadaPertenceAoModeloDoExame() {
        return this.modeloExame.getRowCount() - 1 >= this.getLinhaSelecionadaExame();
    }

    private String getAbreviaturaDoMaterialSelecionado() {
        return this.getAbreviaturaMaterial(this.getLinhaSelecionadaExame());
    }

    private String getCodigoDoExameSelecionado() {
        return this.getCodigoExame(this.getLinhaSelecionadaExame());
    }

    private Integer getCodigoDoMaterialSelecionado() {
        return this.getCodigoMaterial(this.getLinhaSelecionadaExame());
    }

    private void atualizarBotaoEntregue(boolean foiEntregue) {
        if (foiEntregue) {
            this.statusbuttonNaoEntregue = 2;
            this.buttonNaoEntregue.setText("N\u00e3o entregue");
        } else {
            this.statusbuttonNaoEntregue = 1;
            this.buttonNaoEntregue.setText("Entregar");
        }
        this.buttonNaoEntregue.setEnabled(this.telaEstaEmUpdate() && this.naoEstaDevendoHaGuia() && this.linhaEstaSelecionada() && this.situacaoDoExameSelecionadoPossuiResultado() && this.situacaoDoExameSelecionadoNaoEstaEntregue());
    }

    private boolean situacaoDoExameSelecionadoNaoEstaEntregue() {
        return !this.situacaoDoExameSelecionadoEstaEntregue();
    }

    private boolean telaEstaEmUpdate() {
        return this.status == 3;
    }

    private boolean naoEstaDevendoHaGuia() {
        boolean acessoEntregarDevedora = Acesso.getAcesso(this.ACESSO_ENTREGAR_DEVEDORA);
        return this.saldo == 0.0 && !this.deveGuia || acessoEntregarDevedora;
    }

    private void montaListener() {
        this.buttonNotificacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntregaResultado.this.menuNotificacao.show(EntregaResultado.this.panelNotificacao, EntregaResultado.this.buttonNotificacao.getX(), EntregaResultado.this.buttonNotificacao.getY() + EntregaResultado.this.buttonNotificacao.getHeight());
            }
        });
        this.itemImprimirNotificacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (EntregaResultado.this.tableExame.getSelectedRow() >= 0) {
                        NotificacaoService service = new NotificacaoService();
                        DadosExames exameAux = (DadosExames)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 9);
                        String notificacao = (String)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 10);
                        service.imprimir(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText(), exameAux.getCodigo(), exameAux.getCodigoMaterialColetado(), notificacao);
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(EntregaResultado.this, e1.getMessage(), e1.getStackTrace(), "ReceberMaterial (2640)");
                }
            }
        });
        this.itemVisualizarNotificacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (EntregaResultado.this.tableExame.getSelectedRow() >= 0) {
                        NotificacaoService service = new NotificacaoService();
                        DadosExames exameAux = (DadosExames)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 9);
                        String notificacao = (String)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 10);
                        service.visualizar(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText(), exameAux.getCodigo(), exameAux.getCodigoMaterialColetado(), true, notificacao, String.valueOf(EntregaResultado.this.convenio.getCodigoLayout()));
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(EntregaResultado.this, e1.getMessage(), e1.getStackTrace(), "ReceberMaterial (2655)");
                }
            }
        });
        this.itemResponderNotificacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (EntregaResultado.this.tableExame.getSelectedRow() >= 0) {
                        NotificacaoService service = new NotificacaoService();
                        DadosExames exameAux = (DadosExames)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 9);
                        DadosMaterial material = (DadosMaterial)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 1);
                        String notificacao = (String)EntregaResultado.this.modeloExame.getValueAt(EntregaResultado.this.tableExame.getSelectedRow(), 10);
                        service.visualizar(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText(), exameAux.getCodigo(), exameAux.getCodigoMaterialColetado(), false, notificacao, String.valueOf(EntregaResultado.this.convenio.getCodigoLayout()));
                        EntregaResultado.this.modeloExame.setValueAt(service.getNotificacaoPreenchida(), EntregaResultado.this.tableExame.getSelectedRow(), 10);
                        EntregaResultado.this.modeloExame.setValueAt(new Boolean(true), EntregaResultado.this.tableExame.getSelectedRow(), 8);
                        service.atualizarExameRequisicao(EntregaResultado.this.getCodigoFilial(), EntregaResultado.this.txtCodRequisicao.getText(), exameAux.getCodigo(), material.getCodigo(), service.getNotificacaoPreenchida());
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(EntregaResultado.this, e1.getMessage(), e1.getStackTrace(), "ReceberMaterial (2672)");
                }
            }
        });
        this.lblSenhaGerada.addSenhaRemovidaListener(new SenhaRemovidaListener(){

            @Override
            public void senhaRemovida() {
                EntregaResultado.this.removeSenha();
                Variaveis.retornoAtendimentoPainelSenhas = new SenhaGeradaDTO();
            }
        });
    }

    private void cancelar() {
        try {
            Conexao.anulaSQL();
            this.limpaCampos();
            this.removeSenha();
            this.status = 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void novo() {
        this.limpaCampos();
        this.status = 1;
        this.controlaCampos(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean salvar(boolean limpaCampos) {
        Statement st2;
        Statement st;
        boolean retorno;
        block11: {
            retorno = false;
            if (!this.isExibirMultiguia) {
                this.registroCaixa = new Caixa[]{this.caixa};
            }
            for (int i = 0; i < this.registroCaixa.length; ++i) {
                retorno = this.salvarDadosCaixa(limpaCampos, this.registroCaixa[i]);
                if (retorno) continue;
                return retorno;
            }
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            ArrayList comandosExportaWeb = new ArrayList();
            try {
                StringBuilder buf = new StringBuilder();
                if (this.deviaGuia) {
                    String[] comandoRequisicao;
                    buf.delete(0, buf.length());
                    buf.append("update requisicao set ");
                    buf.append("req_deveguia = false");
                    buf.append(", req_datarecebeuguia = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("'");
                    buf.append(", usr_codrecebeuguia = '").append(Variaveis.login).append("'");
                    buf.append(" where fil_codigo = ");
                    buf.append(this.getCodigoFilial());
                    buf.append(" and req_codigo = ");
                    buf.append(this.txtCodRequisicao.getText());
                    Conexao.executeUpdate(this.getCodigoFilial(), st, buf.toString());
                    if (Variaveis.exportarWebFilial && (comandoRequisicao = RecepcaoUtil.geraCabecalhoRequisicaoParaWeb(st, st2, this.getCodigoFilial(), this.txtCodRequisicao.getText(), Variaveis.codigoBaseWeb)) != null) {
                        DBUtil.insereExportaWeb(this.getCodigoFilial(), st, "requisicao", "I", false, comandoRequisicao);
                    }
                }
                Conexao.arquivaSQL();
                for (String[] comandoExameRequisicaoaUX : comandosExportaWeb) {
                    DBUtil.insereExportaWebGerarResultadoPDF(this.getCodigoFilial(), st, "requisicaoexame", "A", true, false, comandoExameRequisicaoaUX);
                }
                this.dadosEntregaService.salvarDadosEntregas(this.entregasRealizadas);
                Conexao.arquivaSQL();
                if (!limpaCampos) break block11;
                this.removeSenha();
                this.limpaCampos();
                this.caixa.limpaValores();
                this.controlaCampos(false);
                this.panelMultiguia.setVisible(false);
            }
            catch (Exception sqlex) {
                try {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "EntregaResultado (962)");
                    }
                    catch (Exception ex) {
                        Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        return retorno;
    }

    private boolean salvarDadosCaixa(boolean limpaCampos, Caixa caixa) {
        int podeSalvar = 0;
        podeSalvar = caixa.podeSalvarCaixa();
        if (podeSalvar != 0) {
            if (podeSalvar == 1) {
                Funcoes.mensagem(this, "O pagamento n\u00e3o pode ser gravado pois as informa\u00e7\u00f5es de caixa est\u00e3o incompletas", 1);
            } else if (podeSalvar == 2) {
                Funcoes.mensagem(this, "A data de lan\u00e7amento do pagamento n\u00e3o pode ser inferior a data de saldo inicial da conta", 1);
            } else if (podeSalvar == 3) {
                Funcoes.mensagem(this, "As informa\u00e7\u00f5es para o conv\u00eanio de repasse est\u00e3o incompletas", 1);
            }
            return false;
        }
        if (caixa.getValorDesconto() > caixa.getValorExames() + caixa.getValorMateriais() + caixa.getValorAcrescimo() + caixa.getTotalTaxa().doubleValue()) {
            Funcoes.mensagem(this, "Valor de desconto no caixa acima do valor permitido", 1);
            caixa.posicionaFoco(2);
            return false;
        }
        if (limpaCampos && caixa.getValorRestante() > 0.0 && Funcoes.mensagem(this, "A requisi\u00e7\u00e3o " + caixa.getCodigoRequisicao() + " est\u00e1 com saldo devedor, deseja manter esse saldo ?", 4) == 1) {
            return false;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ArrayList<String[]> comandosExportaWeb = new ArrayList<String[]>();
        try {
            StringBuilder buf = new StringBuilder("");
            boolean repasseSelecionado = caixa.getConvenioRepasseSelecionado() != null;
            String tipoCalculo = "P";
            if (repasseSelecionado) {
                tipoCalculo = ConvenioUtil.getTipoCalculoConvenioRepasse(st, this.getCodigoFilial(), String.valueOf(this.convenio.getCodigo()), String.valueOf(caixa.getConvenioRepasseSelecionado().getCodigo()));
            }
            for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                List<String[]> exportados = this.exportarParaWeb(i);
                comandosExportaWeb.addAll(exportados);
            }
            buf.delete(0, buf.length());
            buf.append("update requisicao set ");
            buf.append("req_notacaixa = '");
            buf.append(StringUtil.textoDB(caixa.getObs()));
            buf.append("', req_totpago = ");
            buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getValorRecebido())));
            buf.append(", req_total = ");
            buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getSubTotal().add(new BigDecimal(String.valueOf(caixa.getValorAcrescimo()))).subtract(new BigDecimal(String.valueOf(caixa.getValorDesconto()))).doubleValue())));
            buf.append(", req_desconto = ");
            buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getDesconto())));
            buf.append(", req_vlrdesconto = ");
            buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getValorDesconto())));
            buf.append(", req_acrescimo = ");
            buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getAcrescimo())));
            buf.append(", req_vlracrescimo = ");
            buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getValorAcrescimo())));
            buf.append(", con_codrepasse = ");
            buf.append(caixa.getConvenioRepasseSelecionado() == null ? "null" : Integer.valueOf(caixa.getConvenioRepasseSelecionado().getCodigo()));
            buf.append(", req_vlrexames = ");
            buf.append(repasseSelecionado ? Integer.valueOf(0) : Funcoes.limpaDecimal(String.valueOf(caixa.getValorExames())));
            buf.append(", req_vlrmateriais = ");
            buf.append(repasseSelecionado ? Integer.valueOf(0) : Funcoes.limpaDecimal(String.valueOf(caixa.getValorMateriais())));
            if (this.deviaGuiaRepasse && !caixa.isDeveGuiaRepasse()) {
                buf.append(",req_deveguiaRepasse = false, ");
                buf.append("req_datarecebeuguiarepasse = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date())).append("',");
                buf.append("usr_codguiarepasse = '").append(StringUtil.textoDB(Variaveis.login)).append("'");
            } else if (!this.deviaGuiaRepasse && caixa.isDeveGuiaRepasse()) {
                buf.append(",req_deveguiaRepasse = true, ");
                buf.append("req_datarecebeuguiarepasse = null,");
                buf.append("usr_codguiarepasse = null");
            }
            buf.append(", req_guiarepasse = '").append(StringUtil.textoDB(caixa.getGuiaRepasse())).append("', ");
            buf.append("req_guiaprincipalrepasse = '").append(StringUtil.textoDB(caixa.getGuiaPrincipalRepasse())).append("', ");
            buf.append("req_matricularepasse = '").append(StringUtil.textoDB(caixa.getMatriculaRepasse())).append("', ");
            buf.append("req_nomeplanorepasse = '").append(StringUtil.textoDB(caixa.getPlanoRepasse())).append("', ");
            buf.append("req_validadeguiarepasse = ").append(caixa.getValidadeGuiaRepasse() != null ? "'" + Funcoes.formataData("MM/dd/yyyy", caixa.getValidadeGuiaRepasse()) + "'" : "null").append(", ");
            buf.append("req_validadecarteirarepasse = ").append(caixa.getValidadeCarteiraRepasse() != null ? "'" + Funcoes.formataData("MM/dd/yyyy", caixa.getValidadeCarteiraRepasse()) + "'" : "null");
            buf.append(" where fil_codigo = ");
            buf.append(this.getCodigoFilial());
            buf.append(" and req_codigo = ");
            buf.append(caixa.getCodigoRequisicao());
            Conexao.executeUpdate(this.getCodigoFilial(), st, buf.toString());
            String[] comandoExameRequisicao = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(this.getCodigoFilial(), String.valueOf(caixa.getCodigoRequisicao()), st), "valorRequisicao", repasseSelecionado ? "0" : Funcoes.limpaDecimal(String.valueOf(caixa.getValorTotal())), "valorPagoRequisicao", repasseSelecionado ? "0" : Funcoes.limpaDecimal(String.valueOf(caixa.getValorRecebido()))};
            DBUtil.insereExportaWeb(this.getCodigoFilial(), st, "requisicao", "A", false, comandoExameRequisicao);
            caixa.gravarValores(this.getCodigoFilial(), caixa.getCodigoRequisicao(), false, true);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return true;
    }

    private void limpaDadosAtendimento() {
        if (Variaveis.retornoAtendimentoPainelSenhas.getIdentificador() != null && !Variaveis.retornoAtendimentoPainelSenhas.getIdentificador().isEmpty()) {
            Variaveis.retornoAtendimentoPainelSenhas = new SenhaGeradaDTO();
        }
    }

    private List<String[]> exportarParaWeb(int i) throws SQLException {
        ArrayList<String[]> comandosExportaWeb = new ArrayList<String[]>();
        Statement st = Conexao.getStatement();
        if (Variaveis.exportarWebFilial && this.modeloExame.getValueAt(i, 4) != null) {
            String[] comandoExameRequisicao = new String[14];
            comandoExameRequisicao[0] = "codigoBase";
            comandoExameRequisicao[1] = ExportaWeb.getCodigoBaseWeb(st, this.getCodigoFilial());
            comandoExameRequisicao[2] = "codigoRequisicao";
            comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(this.getCodigoFilial(), this.txtCodRequisicao.getText(), st);
            comandoExameRequisicao[4] = "codigoExameRequisicao";
            comandoExameRequisicao[5] = this.getCodigoExame(i);
            comandoExameRequisicao[6] = "materialExameRequisicao";
            comandoExameRequisicao[7] = String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
            comandoExameRequisicao[8] = "situacaoExameRequisicao";
            comandoExameRequisicao[9] = "E";
            comandoExameRequisicao[10] = "dataEnvioExameRequisicao";
            comandoExameRequisicao[11] = "current_timestamp";
            comandosExportaWeb.add(comandoExameRequisicao);
        }
        return comandosExportaWeb;
    }

    private void gravarRequisicao(int i) throws SQLException {
        if (((Boolean)this.modeloExame.getValueAt(i, 8)).booleanValue()) {
            Statement st = Conexao.getStatement();
            String sql = this.criarSqlUpdateRequisicao(i, st);
            Conexao.executeUpdate(this.getCodigoFilial(), st, sql);
            ExportaFiliais.gravaRequisicao(Integer.parseInt(this.getCodigoFilial()), Long.parseLong(this.txtCodRequisicao.getText()), this.getCodigoExame(i), ((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo(), "U", "U");
        }
    }

    private String criarSqlUpdateRequisicao(int i, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.updateEntreguePara(i));
        buf.append(this.camposRepasse(i));
        if (null != this.modeloExame.getValueAt(i, 10) && !Funcoes.textoVazio(this.modeloExame.getValueAt(i, 10).toString())) {
            buf.append(", exr_notificacao = '").append(this.modeloExame.getValueAt(i, 10)).append("'");
        } else {
            buf.append(", exr_notificacao = '' ");
        }
        buf.append(this.condicaoWhere(i));
        this.gravarLogSituacaoDoExame(st, i);
        String sql = buf.toString();
        return sql;
    }

    private void gravarLogSituacaoDoExame(Statement st, int i) throws SQLException {
        if (this.modeloExame.getValueAt(i, 4) != null) {
            DBUtil.gravaLogSituacaoExameRequisicao(st, this.getCodigoFilial(), this.txtCodRequisicao.getText(), this.getCodigoExame(i), String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo()), "E", false);
        }
    }

    private String condicaoWhere(int i) {
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ");
        buf.append(this.getCodigoFilial());
        buf.append(" and req_codigo = ");
        buf.append(this.txtCodRequisicao.getText());
        buf.append(" and upper(exa_codigo)=upper('");
        buf.append(this.getCodigoExame(i));
        buf.append("') and mco_codigo = ");
        buf.append(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
        return buf.toString();
    }

    private String camposRepasse(int i) throws SQLException {
        String tipoCalculo = "P";
        StringBuilder buf = new StringBuilder();
        boolean repasseSelecionado = this.caixa.getConvenioRepasseSelecionado() != null;
        DadosExames dadosExame = (DadosExames)this.modeloExame.getValueAt(i, 9);
        DadosMaterial dadosMaterial = (DadosMaterial)this.modeloExame.getValueAt(i, 1);
        if (!repasseSelecionado && this.convenioRepasse != null) {
            buf.append(", exr_valorchexamerepasse = null");
            buf.append(", exr_valorchrepasse = null");
            buf.append(", exr_valorcustorepasse = null");
            buf.append(", exr_valorucorepasse = null");
            buf.append(", exr_valorporterepasse = null");
            buf.append(", exr_porterepasse = null ");
        } else if (repasseSelecionado) {
            if (tipoCalculo.equals("P")) {
                buf.append(", exr_valorchexamerepasse = ").append(dadosExame.getValorExame() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorExame())) : "null");
                buf.append(", exr_valorchrepasse = ").append(dadosExame.getValorCH() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH())) : "null");
                buf.append(", exr_valorcustorepasse = ").append(dadosExame.getCusto() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getCusto())) : "null");
                buf.append(", exr_valorucorepasse = ").append(dadosExame.getUco() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getUco())) : "null");
                buf.append(", exr_valorporterepasse = ").append(dadosExame.getValorPorte() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorPorte())) : "null");
                if (dadosExame.getPorte() != null && !Funcoes.textoVazio(dadosExame.getPorte())) {
                    buf.append(", exr_porterepasse = '").append(StringUtil.textoDB(dadosExame.getPorte())).append("'");
                } else {
                    buf.append(", exr_porterepasse = null ");
                }
            } else {
                DadosExames exameTmp = ExameUtil.getDadosExame(this.getCodigoFilial(), dadosExame.getCodigo(), dadosMaterial);
                ExameUtil.calculaPrecoExame(this.getCodigoFilial(), dadosExame, dadosMaterial, this.caixa.getConvenioRepasseSelecionado(), false, false, false, Integer.parseInt(this.txtCodRequisicao.getText()), null, Integer.parseInt(dadosExame.getCodMetodo()));
                buf.append(", exr_valorchexamerepasse = ").append(exameTmp.getValorExame() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getValorExame())) : "null");
                buf.append(", exr_valorchrepasse = ").append(exameTmp.getValorCH() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getValorCH())) : "null");
                buf.append(", exr_valorcustorepasse = ").append(exameTmp.getCusto() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getCusto())) : "null");
                buf.append(", exr_valorucorepasse = ").append(exameTmp.getUco() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getUco())) : "null");
                buf.append(", exr_valorporterepasse = ").append(exameTmp.getValorPorte() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getValorPorte())) : "null");
                if (exameTmp.getPorte() != null && !Funcoes.textoVazio(exameTmp.getPorte())) {
                    buf.append(", exr_porterepasse = '").append(StringUtil.textoDB(exameTmp.getPorte())).append("'");
                } else {
                    buf.append(", exr_porterepasse = null ");
                }
            }
        }
        return buf.toString();
    }

    private String updateEntreguePara(int i) {
        StringBuilder buf = new StringBuilder();
        if (this.modeloExame.getValueAt(i, 4) != null) {
            buf.append("update examerequisicao set exr_dataentreguerst = '");
            buf.append(Funcoes.formataData("MM/dd/yyyy HH:mm", (Date)this.modeloExame.getValueAt(i, 4)));
            buf.append("', usr_codentrega = '");
            buf.append(StringUtil.textoDB((String)this.modeloExame.getValueAt(i, 6)));
            buf.append("', exr_situacao = '");
            buf.append("E");
            buf.append("', exr_entrpara = '");
            String entreguePara = this.modeloExame.getValueAt(i, 7).toString();
            if (entreguePara.length() > 40) {
                entreguePara = entreguePara.substring(0, 40);
            }
            buf.append(StringUtil.textoDB(StringUtil.trataCaracteresEspeciais(entreguePara)));
            buf.append("'");
        } else {
            buf.append("update examerequisicao set exr_dataentreguerst = null, usr_codentrega = null, exr_entrpara = ''");
        }
        return buf.toString();
    }

    private boolean temExameParaEntregar() {
        int impressos = 0;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!this.modeloExame.getValueAt(i, 5).toString().equalsIgnoreCase("I")) continue;
            ++impressos;
        }
        return impressos > 0;
    }

    private void imprimirTodos() {
        DadosExames aux;
        if (this.todosExamesImpressos() && !this.getPermiteReimprimirExames()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Todos os exames foram impressos.\nUsu\u00e1rio n\u00e3o possui acesso para reimpress\u00e3o.", 2);
            return;
        }
        if (!this.biometriaInformada && ParametrosLocais.existeParametro("biometriaCaptura") && !ParametrosLocais.getParametro("biometriaCaptura").equals("Sem biometria") && (aux = (DadosExames)this.modeloExame.getValueAt(this.getLinhaSelecionadaExame(), 9)).isObrigaBiometriaPaciente() && this.biometriaPaciente != null) {
            int resp = Funcoes.mensagem(this, "\u00c9 necess\u00e1ria a identifica\u00e7\u00e3o biom\u00e9trica para imprimir o resultado.\nDeseja fazer a leitura da digital do paciente?", 4, true);
            if (resp == 0) {
                if (!this.verificaImpressaoDigital()) {
                    Funcoes.mensagem(this, "A impress\u00e3o digital informada N\u00c3O confere com a impress\u00e3o digital cadastrada para o paciente.", 2);
                    return;
                }
                Funcoes.mensagem(this, "A impress\u00e3o digital coincide.", 5);
                this.biometriaInformada = true;
            } else if (Acesso.getAcesso(this.ACESSO_ENTREGAR_RESULTADO_SEM_IMPRESSAO_DIGITAL_PACIENTE)) {
                resp = Funcoes.mensagem(this, "Deseja imprimir o resultado sem informar a impress\u00e3o digital?", 4, false);
                if (resp == 1) {
                    return;
                }
            } else {
                Funcoes.mensagem(this, "O resultado n\u00e3o pode ser impresso.", 2);
                ScreenUtil.requisitarFoco(this.buttonNaoEntregue);
                return;
            }
        }
        if (this.salvar(false)) {
            this.realizarImpressaoTodos();
        }
        this.validaBotaoImprimirTodos(this.acessoImprimirDevedora);
    }

    private void realizarImpressaoTodos() {
        int situacao = this.situacaoExames();
        String reimprimirTodos = "Reimprimir Todos";
        String reimprimirEntregues = "Reimprimir Entregues";
        String reimprimirImpressos = "Reimprimir Impressos";
        String reimprimirN\u00e3o = "N\u00e3o";
        if (situacao != 0) {
            try {
                int resposta = 0;
                String[] exames = new String[this.modeloExame.getRowCount()];
                String[] materiais = new String[this.modeloExame.getRowCount()];
                String[] opcoes = new String[4];
                if (this.getPermiteReimprimirExames()) {
                    if (this.contaEntregue > 0 && this.contaImpresso > 0) {
                        situacao = 2;
                        StringBuilder buf = new StringBuilder();
                        buf.append("Existe exames j\u00e1 impressos na requisi\u00e7\u00e3o ").append(this.impressos.toString()).append("\n");
                        buf.append("Existe exames j\u00e1 entregues na requisi\u00e7\u00e3o ").append(this.entregues.toString()).append("\n");
                        if (this.getPermiteReimprimirExames()) {
                            buf.append("Deseja imprimir novamente? ").append("\n");
                            opcoes[0] = "Reimprimir Impressos";
                            opcoes[1] = "Reimprimir Entregues";
                            opcoes[2] = "Reimprimir Todos";
                            opcoes[3] = "N\u00e3o";
                        }
                        resposta = Funcoes.showPerguntaOpcoes(Laboratorio.getInstancia(), buf.toString(), opcoes);
                    } else if (this.contaEntregue > 0 && this.contaImpresso == 0) {
                        situacao = 2;
                        StringBuilder buf = new StringBuilder();
                        buf.append("Existe exames j\u00e1 entregues na requisi\u00e7\u00e3o ").append(this.entregues.toString()).append("\n");
                        if (this.getPermiteReimprimirExames()) {
                            buf.append("Deseja imprimir novamente? ").append("\n");
                            opcoes = new String[]{"Reimprimir Entregues", "N\u00e3o"};
                        }
                        resposta = Funcoes.showPerguntaOpcoes(Laboratorio.getInstancia(), buf.toString(), opcoes);
                    } else if (this.contaEntregue == 0 && this.contaImpresso > 0) {
                        situacao = 2;
                        StringBuilder buf = new StringBuilder();
                        buf.append("Existe exames j\u00e1 impressos na requisi\u00e7\u00e3o ").append(this.impressos.toString()).append("\n");
                        if (this.getPermiteReimprimirExames()) {
                            buf.append("Deseja imprimir novamente? ").append("\n");
                            opcoes = new String[]{"Reimprimir Impressos", "N\u00e3o"};
                        }
                        resposta = Funcoes.showPerguntaOpcoes(Laboratorio.getInstancia(), buf.toString(), opcoes);
                    }
                } else if (this.contaIncompleto > 0) {
                    boolean ok = Funcoes.mensagem(this, "Existem exames j\u00e1 impressos na requisi\u00e7\u00e3o.\n " + RecepcaoUtil.getExameImpresso(this.getCodigoFilial(), this.txtCodRequisicao.getText()) + "\nUsu\u00e1rio n\u00e3o possui acesso para reimpress\u00e3o.\nDeseja imprimir os demais exames?", 4) == 0;
                    situacao = 0;
                    if (ok) {
                        situacao = 1;
                    }
                }
                String sitExame = "C";
                if (!ParametrosGerais.getConferencia()) {
                    sitExame = "L";
                }
                for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                    if (this.modeloExame.getValueAt(i, 5).toString().equals(sitExame)) {
                        exames[i] = (String)this.modeloExame.getValueAt(i, 0);
                        materiais[i] = String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
                    }
                    if (opcoes[resposta] != null && opcoes[resposta].equals("Reimprimir Impressos")) {
                        if (!this.modeloExame.getValueAt(i, 5).toString().equals("I")) continue;
                        exames[i] = (String)this.modeloExame.getValueAt(i, 0);
                        materiais[i] = String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
                        continue;
                    }
                    if (opcoes[resposta] != null && opcoes[resposta].equals("Reimprimir Entregues")) {
                        if (!this.modeloExame.getValueAt(i, 5).equals("E")) continue;
                        exames[i] = (String)this.modeloExame.getValueAt(i, 0);
                        materiais[i] = String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
                        continue;
                    }
                    if (opcoes[resposta] != null && opcoes[resposta].equals("Reimprimir Todos") && !this.modeloExame.getValueAt(i, 5).toString().equals("C")) {
                        exames[i] = (String)this.modeloExame.getValueAt(i, 0);
                        materiais[i] = String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
                        continue;
                    }
                    if (opcoes[resposta] == null || !opcoes[resposta].equals("N\u00e3o") || !this.modeloExame.getValueAt(i, 5).toString().equals("C")) continue;
                    exames[i] = (String)this.modeloExame.getValueAt(i, 0);
                    materiais[i] = String.valueOf(((DadosMaterial)this.modeloExame.getValueAt(i, 1)).getCodigo());
                }
                RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(this.impressoraSelecionada, this.getTopLevelAncestor(), this.getCodigoFilial(), this.txtCodRequisicao.getText(), situacao == 2 && this.getPermiteReimprimirExames(), null, exames, materiais, false);
                if (Funcoes.textoVazio(this.impressoraSelecionada)) {
                    this.impressoraSelecionada = retorno.getImpressoraSelecionada();
                }
                Conexao.arquivaSQL();
                this.mostraDadosRequisicao(this.txtCodRequisicao.getText(), Acesso.getAcesso(Long.parseLong("0200900116")));
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
            }
        }
    }

    private void updateExameRequisicao(Statement st, String exame, String material, List<String> campos, List<String> valores) throws SQLException {
        if (st != null && campos.size() == valores.size() && campos.size() > 0) {
            StringBuilder bui = new StringBuilder("update examerequisicao set ");
            boolean gravarHistorico = false;
            String situacao = "";
            String motivoRecoleta = "";
            String justificativaRecoleta = "";
            for (int i = 0; i < campos.size(); ++i) {
                bui.append(i > 0 ? ", " : "");
                bui.append(campos.get(i));
                bui.append(" = ");
                bui.append(Funcoes.textoVazio(valores.get(i)) ? "null" : valores.get(i));
                if (campos.get(i).equalsIgnoreCase("exr_situacao")) {
                    gravarHistorico = true;
                    situacao = valores.get(i).replaceAll("'", "");
                }
                if (campos.get(i).equalsIgnoreCase("mrc_codigo")) {
                    motivoRecoleta = valores.get(i).replaceAll("'", "");
                }
                if (!campos.get(i).equalsIgnoreCase("exr_motivorecoleta")) continue;
                justificativaRecoleta = valores.get(i).replaceAll("'", "");
            }
            bui.append(" where fil_codigo = ");
            bui.append(this.getCodigoFilial());
            bui.append(" and req_codigo = ");
            bui.append(this.txtCodRequisicao.getText());
            bui.append(" and exa_codigo = '");
            bui.append(StringUtil.textoDB(exame));
            bui.append("' and mco_codigo = ");
            bui.append(material);
            if (gravarHistorico && situacao.equalsIgnoreCase("R")) {
                DBUtil.gravaLogSituacaoExameRequisicao(st, this.getCodigoFilial(), this.txtCodRequisicao.getText(), exame, material, situacao, false, motivoRecoleta, justificativaRecoleta);
            } else {
                DBUtil.gravaLogSituacaoExameRequisicao(st, this.getCodigoFilial(), this.txtCodRequisicao.getText(), exame, material, situacao, false);
            }
            Conexao.executeUpdate(this.getCodigoFilial(), st, bui.toString());
        }
    }

    private void entregarTodos() {
        if (!this.temExameParaEntregar()) {
            Funcoes.mensagem(this.getTopLevelAncestor(), "\u00c9 necess\u00e1rio imprimir os resultados antes de entregar", 2);
            return;
        }
        if (this.saldo > 0.0 && !Acesso.getAcesso(this.ACESSO_ENTREGAR_DEVEDORA)) {
            Funcoes.mensagem(this, "Entrega n\u00e3o autorizada", 2);
            this.buttonEntregarTodos.grabFocus();
            return;
        }
        if (!this.biometriaInformada && ParametrosLocais.existeParametro("biometriaCaptura") && !ParametrosLocais.getParametro("biometriaCaptura").equals("Sem biometria")) {
            for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                DadosExames aux = (DadosExames)this.modeloExame.getValueAt(i, 9);
                if (!aux.isObrigaBiometriaPaciente() || this.biometriaPaciente == null) continue;
                int resp = Funcoes.mensagem(this, "\u00c9 necess\u00e1ria a identifica\u00e7\u00e3o biom\u00e9trica para entregar o resultado.\nDeseja fazer a leitura da digital do paciente?", 4, true);
                if (resp == 0) {
                    if (this.verificaImpressaoDigital()) {
                        this.biometriaInformada = true;
                        break;
                    }
                    Funcoes.mensagem(this, "A impress\u00e3o digital informada n\u00e3o confere com a impress\u00e3o digital cadastrada para o paciente.", 2);
                    return;
                }
                if (Acesso.getAcesso(this.ACESSO_ENTREGAR_RESULTADO_SEM_IMPRESSAO_DIGITAL_PACIENTE)) {
                    resp = Funcoes.mensagem(this, "Deseja entregar o resultado sem informar a impress\u00e3o digital?", 4, false);
                    if (resp == 0) break;
                    return;
                }
                Funcoes.mensagem(this, "O resultado n\u00e3o pode ser entregado.", 2);
                ScreenUtil.requisitarFoco(this.buttonEntregarTodos);
                return;
            }
        }
        String entreguePara = this.biometriaInformada ? "Paciente - biometria" : "";
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (this.modeloExame.getValueAt(i, 4) != null || !this.modeloExame.getValueAt(i, 5).toString().equalsIgnoreCase("I")) continue;
            if (Funcoes.textoVazio(entreguePara)) {
                entreguePara = JOptionPane.showInputDialog(this, "Exames entregues para", "Paciente");
            }
            if (entreguePara == null) {
                return;
            }
            if (Funcoes.textoVazio(entreguePara)) {
                entreguePara = "Paciente";
            }
            this.modeloExame.setValueAt(Variaveis.login, i, 6);
            this.modeloExame.setValueAt(new Date(), i, 4);
            this.modeloExame.setValueAt(entreguePara, i, 7);
            this.modeloExame.setValueAt(new Boolean(true), i, 8);
            try {
                this.gravarRequisicao(i);
                continue;
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        this.salvar(!this.isExibirMultiguia);
        if (this.isExibirMultiguia) {
            this.mostraDadosRequisicao(this.txtCodRequisicao.getText(), Acesso.getAcesso(Long.parseLong("0200900116")));
        }
        for (int linha = 0; linha < this.modeloMultiguia.getRowCount(); ++linha) {
            try {
                Integer requisicao = this.getCodigoDaRequisicao(linha);
                this.carregarExamesEntregues(requisicao);
                continue;
            }
            catch (EntregaResultadoException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private boolean verificaImpressaoDigital() {
        if (Funcoes.textoVazio(this.biometriaPaciente)) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 uma impress\u00e3o digital cadastrada para o paciente.", 5);
            return false;
        }
        String name = ParametrosLocais.getParametro("biometriaCaptura");
        short id = Biometria.getDispositivo(name);
        if (id > -1) {
            Funcoes.mensagem(this, "Informe a digital do paciente.", 5);
            try {
                return Biometria.verificar(id, this.biometriaPaciente, true);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String getCodigoFilial() {
        if (!Funcoes.textoVazio(this.textFilial.getText())) {
            return this.textFilial.getText();
        }
        return Variaveis.filialPadrao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mostraDadosRequisicao(String codigo, boolean acessoLabApoio) {
        if (codigo == null || Funcoes.textoVazio(codigo)) {
            this.txtCodRequisicao.clear();
            this.txtCodRequisicao.grabFocus();
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        String sql = this.getSQLRequisicao(codigo, acessoLabApoio);
        try {
            ResultSet rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.convenio = ConvenioUtil.getDadosConvenios(this.getCodigoFilial(), rs.getInt("con_codigo"));
                this.mostraDadosCaixa(codigo, st2, st3, rs);
                this.mostraDadosPaciente(rs);
                if (!this.isExibirMultiguia) {
                    StringBuilder mensagemGuia = new StringBuilder();
                    mensagemGuia.append(RecepcaoUtil.mensagemMultiGuias(this.getCodigoFilial(), codigo));
                    if (!Funcoes.textoVazio(mensagemGuia.toString())) {
                        mensagemGuia.append("\nDeseja adicionar multiguias?");
                        if (Funcoes.mensagem(this, mensagemGuia.toString(), 4) == 0) {
                            this.isExibirMultiguia = true;
                            this.posicionaComponentes();
                            this.carregaValoresMultiguia(codigo);
                            int linha = this.getLinhaMultiguia(codigo);
                            this.tableMultiguia.addRowSelectionInterval(linha, linha);
                        } else {
                            this.carregarExamesEntregues(Integer.parseInt(codigo));
                        }
                    } else {
                        this.carregarExamesEntregues(Integer.parseInt(codigo));
                    }
                }
                String obs = rs.getString("req_obs");
                String codigoPaciente = rs.getString("pac_codigo");
                String mensagem = RecepcaoUtil.getMensagemPendenciaPaciente(st, this.getCodigoFilial(), codigoPaciente, codigo);
                if (!Funcoes.textoVazio(mensagem) || Funcoes.textoVazio(mensagem) && !Funcoes.textoVazio(obs) && ParametrosGerais.getPendenciaPaciente() != 0) {
                    PendenciasPaciente pendenciasPaciente;
                    String titulo = "Alerta";
                    String[] opcoes = new String[]{"OK"};
                    char[] atalho = new char[]{'O'};
                    if (!Funcoes.textoVazio(mensagem)) {
                        opcoes = ArraysUtil.concatenar(opcoes, new String[]{"Ver pend\u00eancias"});
                        atalho = String.valueOf(atalho).concat("V").toCharArray();
                        if (!Funcoes.textoVazio(obs)) {
                            mensagem = mensagem.concat(".\n");
                        }
                    }
                    mensagem = mensagem.concat(obs);
                    int resposta = Funcoes.showPerguntaOpcoes(Laboratorio.getInstancia(), titulo, mensagem, opcoes, atalho, 2);
                    if (this.mostrarJanelaPendencias(resposta) && !Funcoes.objectIsNull(pendenciasPaciente = PendenciasPaciente.novaInstancia(Laboratorio.getInstancia()))) {
                        pendenciasPaciente.carregaRequisicoes(this.textFilial.getText().trim(), codigoPaciente, codigo);
                        pendenciasPaciente.setVisible(true);
                    }
                }
                this.mostrarObservacoes.clear();
                this.mostrarObservacoes.setObservacao(obs);
                this.modeloExame.clear();
                this.carregarDadosExames(codigo);
            } else {
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada", 2);
                this.status = 1;
            }
            rs.close();
            this.buttonObservacoes.setVisible(this.mostrarObservacoes.temObs());
            this.validaBotaoImprimirTodos(this.acessoImprimirDevedora);
        }
        catch (Exception sqlex) {
            try {
                ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "EntregaResultado (1134)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2, st3);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2, st3);
        }
        Conexao.fecharStatement(st, st2, st3);
        Conexao.fecharStatement(st);
        this.labelVUsuario.setText("");
        this.labelVDataHora.setText("");
        this.controlaCampos(this.status == 1, false);
    }

    private boolean mostrarJanelaPendencias(int resposta) {
        return resposta == 1;
    }

    private int getLinhaMultiguia(String codigo) {
        for (int linha = 0; linha < this.modeloMultiguia.getRowCount(); ++linha) {
            if (!this.modeloMultiguia.getValueAt(linha, 0).equals(codigo)) continue;
            return linha;
        }
        return -1;
    }

    private void mostraDadosPaciente(ResultSet rs) throws SQLException {
        this.fotoPaciente = null;
        if (!DBUtil.campoNull(rs.getString("pac_foto")) && !Funcoes.textoVazio(rs.getString("pac_foto"))) {
            String imagem64 = rs.getString("pac_foto");
            try {
                this.fotoPaciente = new ImageIcon(new Base64().decode(imagem64));
                this.labelFoto.setIcon(new ImageIcon(this.fotoPaciente.getImage().getScaledInstance(90, 80, 4)));
                this.labelFoto.revalidate();
                this.labelFoto.repaint();
                this.labelFoto.getTopLevelAncestor().repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.posicionaComponentes();
        }
        this.biometriaPaciente = rs.getString("pac_digital");
        this.codigoPaciente = rs.getInt("pac_codigo");
        this.labelVPaciente.setText(rs.getString("pac_nome"));
        this.labelVPaciente.setNomeSocial(rs.getString("pac_nomesocial"));
        this.labelVSexo.setGenero(rs.getString("pac_genero"));
        this.labelVIdade.setText(rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes")));
        this.labelVIdade.setToolTipText(Funcoes.getIdadePorExtenso(rs.getDate("pac_datanasc"), rs.getDate("req_data")));
        java.sql.Date dataNasc = rs.getDate("pac_datanasc");
        if (dataNasc != null) {
            this.labelVNasc.setText(Funcoes.formataData(dataNasc));
        }
        this.labelVSexo.setText(Tipos.tipoSexo(rs.getString("pac_sexo")));
        this.labelVConvenio.setText(rs.getString("con_fantasia"));
        this.labelVMedico.setText(rs.getString("med_nome"));
        this.labelCodDestino.setText(rs.getString("des_codigo"));
        this.labelDescDestino.setText(rs.getString("des_descricao"));
        this.checkAvisar.setSelected(rs.getBoolean("req_avisarpaciente"));
        if (this.checkAvisar.isSelected()) {
            this.txtDataPrevista.clear();
            this.txtHoraPrevista.clear();
        } else if (!DBUtil.campoNull(rs.getString("req_dataentregaprev"))) {
            this.txtDataPrevista.setText(Funcoes.formataData(rs.getDate("req_dataentregaprev")));
            if (!DBUtil.campoNull(rs.getString("req_horaentregaprev"))) {
                this.txtHoraPrevista.setText(Funcoes.formataHora(rs.getTime("req_horaentregaprev"), false));
            }
        }
        if (rs.getBoolean("req_deveguia")) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o sem guia", 2);
        }
        if (rs.getBoolean("pac_imprimircarteira")) {
            Funcoes.mensagem(this, "O paciente tem carteira para ser impressa", 2);
        }
    }

    private void atualizarInfoRequisicao(String codigo) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        String sql = this.getSQLRequisicao(codigo, Acesso.getAcesso(Long.parseLong("0200900116")));
        try {
            ResultSet rs = Conexao.executeQuery(st, sql);
            if (rs.next()) {
                this.mostraDadosCaixa(codigo, st2, st3, rs);
                this.mostraDadosPaciente(rs);
            }
            this.carregarDadosExames(codigo);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "EntregaResultado");
        }
    }

    private void mostraDadosCaixa(String codigo, Statement st2, Statement st3, ResultSet rs) throws SQLException, Exception {
        int colunaRequisicao;
        int n = colunaRequisicao = this.modeloMultiguia.localizar(0, codigo) < 0 ? 0 : this.modeloMultiguia.localizar(0, codigo);
        if (this.registroCaixa == null || this.registroCaixa[colunaRequisicao] == null) {
            this.caixa = this.criarCaixa(codigo, st2, st3, rs);
            this.panelCaixa.setVisible(this.caixa.getValorRestante() > 0.0);
            if (this.panelCaixa.isVisible()) {
                this.saldo = this.caixa.getValorRestante();
                if (this.isExibirMultiguia) {
                    this.registroCaixa[colunaRequisicao] = this.caixa;
                }
            }
        } else {
            this.panelCaixa.setVisible(this.registroCaixa[colunaRequisicao].getValorRestante() > 0.0);
            this.saldo = this.panelCaixa.isVisible() ? this.registroCaixa[colunaRequisicao].getValorRestante() : 0.0;
        }
        this.labelSaldo.setText("Saldo: " + Funcoes.formataDecimal(this.saldo));
    }

    private Caixa criarCaixa(String codigo, Statement st2, Statement st3, ResultSet rs) throws SQLException, Exception {
        this.deveGuia = rs.getBoolean("req_deveguia");
        this.buttonReceberGuia.setVisible(this.deveGuia);
        Caixa caixa1 = new Caixa(null);
        caixa1.setDadosConvenio(this.convenio);
        caixa1.setPercentualDesconto(Funcoes.textoVazio(rs.getString("req_desconto")) ? 0.0 : rs.getDouble("req_desconto"));
        caixa1.setPercentualAcrescimo(Funcoes.textoVazio(rs.getString("req_acrescimo")) ? 0.0 : rs.getDouble("req_acrescimo"));
        caixa1.setValorAcrescimo(Funcoes.textoVazio(rs.getString("req_vlracrescimo")) ? 0.0 : rs.getDouble("req_vlracrescimo"));
        caixa1.setValorDesconto(Funcoes.textoVazio(rs.getString("req_vlrdesconto")) ? 0.0 : rs.getDouble("req_vlrdesconto"));
        caixa1.setValorExames(rs.getDouble("req_vlrexames"));
        caixa1.setValorMateriais(rs.getDouble("req_vlrmateriais"));
        caixa1.setTotalTaxa(new BigDecimal(rs.getDouble("valorTotalTaxa")));
        caixa1.setFilial(this.getCodigoFilial());
        caixa1.setObs(rs.getString("req_notacaixa"));
        caixa1.setDadosPagador(rs.getInt("pac_codigo"), rs.getString("nomePagador"), Funcoes.temNumero(rs.getString("cpfPagador")) ? rs.getString("cpfPagador") : rs.getString("pac_cpf"));
        caixa1.setDataRequisicao(rs.getDate("req_data"));
        caixa1.setHabilitaAcrescimoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_ACRESCIMO));
        caixa1.setHabilitaDescontoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_DESCONTO));
        caixa1.setPermitirEstornoPagamento(Acesso.getAcesso(this.ACESSO_ESTORNAR_PAGAMENTO));
        caixa1.setMovimentarCaixa(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_CAIXA));
        caixa1.setAlterarData(Acesso.getAcesso(this.ACESSO_ALTERAR_DATA_CAIXA));
        boolean exigir = ParametrosGerais.getExigirDadosPagadorDmed() ? !Acesso.getAcesso(this.ACESSO_SALVAR_SEM_PAGADOR) : false;
        caixa1.setSalvarSemPagador(!exigir);
        caixa1.setAlterarConta(Acesso.getAcesso(this.ACESSO_ALTERAR_CONTA_CAIXA));
        caixa1.setNaoMovimentarCaixaSemPagamento(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_SEM_PAGAMENTO));
        caixa1.setConveniosRepasse(ConvenioUtil.getConveniosRepasse(st2, st3, this.getCodigoFilial(), String.valueOf(this.convenio.getCodigo())));
        caixa1.setPermitirEstornarRepasseConvenio(Acesso.getAcesso(this.ACESSO_ESTORNO_REPASSE_CAIXA));
        if (!DBUtil.campoNull(rs.getString("con_codrepasse"))) {
            this.convenioRepasse = ConvenioUtil.getDadosConvenios(this.getCodigoFilial(), rs.getInt("con_codrepasse"));
            caixa1.setConvenioRepasseSelecionado(this.convenioRepasse);
        }
        this.deviaGuiaRepasse = rs.getBoolean("req_deveguiarepasse");
        caixa1.setGuiaPrincipalRepasse(rs.getString("req_guiaprincipalrepasse"));
        caixa1.setGuiaRepasse(rs.getString("req_guiarepasse"));
        caixa1.setMatriculaRepasse(rs.getString("req_matricularepasse"));
        caixa1.setDeveGuiaRepasse(rs.getBoolean("req_deveguiarepasse"));
        caixa1.setValidadeCarteiraRepasse(rs.getDate("req_validadecarteirarepasse"));
        caixa1.setValidadeGuiaRepasse(rs.getDate("req_validadeguiarepasse"));
        caixa1.setPlanoRepasse(rs.getString("req_nomeplanorepasse"));
        caixa1.setCodigoRequisicao(this.getCodigoFilial(), Integer.parseInt(codigo), true);
        caixa1.posicionaFoco(1);
        return caixa1;
    }

    private String getSQLRequisicao(String codigo, boolean acessoLabApoio) {
        StringBuilder buf = new StringBuilder("select d.pac_datanasc, d.fil_codigo as filialpaciente, d.pac_nome, d.pac_nomesocial, d.pac_cpf, d.pac_datanasc, a.req_idade, a.req_anomes, a.req_total, a.req_totpago, ");
        buf.append("d.pac_sexo, coalesce(d.pac_genero, 0) as pac_genero, b.con_fantasia, c.med_nome, a.req_notacaixa, a.req_desconto, a.req_vlrdesconto, d.pac_foto, a.req_obs, ");
        buf.append("a.req_avisarpaciente, a.req_dataentregaprev, a.req_horaentregaprev, a.pac_codigo, a.pac_codigo, a.req_deveguia, ");
        buf.append(" a.req_acrescimo, a.req_vlracrescimo, a.req_vlrexames, a.req_vlrmateriais, a.con_codigo, a.req_data, a.req_deveguia, ");
        buf.append("a.des_codigo, des.des_descricao, d.pac_imprimircarteira, d.pac_digital, ");
        buf.append("a.con_codrepasse, a.req_guiarepasse, a.req_matricularepasse, a.req_validadeguiarepasse,  ");
        buf.append("a.req_validadecarteirarepasse, a.req_guiaprincipalrepasse, coalesce(a.req_deveguiarepasse, false) as req_deveguiarepasse, a.req_nomeplanorepasse ");
        buf.append(" ,COALESCE(d.pac_nomepagador, d.pac_nome) as nomePagador, d.pac_cpfpagador as cpfPagador, COALESCE(a.req_totaltaxa, 0.0) as valorTotalTaxa ");
        buf.append(" from requisicao a ");
        buf.append("left join paciente d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo ");
        buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        if (this.convenioService.getPossuiCampoPermitirPesquisaApoio()) {
            buf.append("left join convenios con on d.fil_codigo = con.fil_codigo and d.con_codigo = con.con_codigo ");
        }
        buf.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ");
        buf.append("left join destino des on a.fil_codigo = des.fil_codigo and a.des_codigo = des.des_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(this.getCodigoFilial());
        buf.append(" and a.req_codigo = ");
        buf.append(codigo);
        buf.append(" and a.req_excluida = false ");
        if (acessoLabApoio && this.convenioService.getPossuiCampoPermitirPesquisaApoio()) {
            buf.append(" and (COALESCE(con.con_permitirpesquisaapoio, false) OR NOT COALESCE(b.con_apoiado, false)) ");
        } else if (acessoLabApoio) {
            buf.append(" and COALESCE(b.con_apoiado, false) = false ");
        }
        return buf.toString();
    }

    private void carregarDadosExames(String codigo) throws SQLException {
        this.modeloExame.clear();
        List<EntregaResultadoVO> dados = new EntregaResultadoService().getListaDadosExames(codigo, this.getCodigoFilial());
        if (dados != null) {
            for (int x = 0; x < dados.size(); ++x) {
                this.modeloExame.addLine(new Object[]{dados.get(x).getDadosExames().getCodigo(), dados.get(x).getDadosMaterial(), dados.get(x).getDadosExames().getDescricao(), dados.get(x).getExrdataentregaprev() == null ? null : Funcoes.timestampToDate(dados.get(x).getExrdataentregaprev().toString()), dados.get(x).getExrdataentreguerst() == null ? null : Funcoes.timestampToDate(dados.get(x).getExrdataentreguerst().toString()), DBUtil.campoNull(dados.get(x).getExrsituacao()) ? "" : dados.get(x).getExrsituacao(), DBUtil.campoNull(dados.get(x).getUsrcodentrega()) ? "" : dados.get(x).getUsrcodentrega(), DBUtil.campoNull(dados.get(x).getExrentrpara()) ? "" : dados.get(x).getExrentrpara(), new Boolean(false), dados.get(x).getDadosExames(), dados.get(x).getDadosExames().getNotificacaoCorpo()});
                if (!Funcoes.textoVazio(dados.get(x).getExrobs())) {
                    this.mostrarObservacoes.adicionarObservacaoExame(dados.get(x).getDadosExames().getDescricao(), dados.get(x).getExrobs());
                }
                Iterator<DadosEntrega> entregas = this.entregasRealizadas.getIterator();
                while (entregas.hasNext()) {
                    DadosEntrega entrega = entregas.next();
                    if (!this.atualizarModelo(codigo, entrega, dados, x)) continue;
                    this.modeloExame.setValueAt(entrega.getDataHora(), x, 4);
                }
            }
            this.status = 3;
        }
    }

    public boolean atualizarModelo(String codigo, DadosEntrega entrega, List<EntregaResultadoVO> dados, int x) {
        return codigo.equals(entrega.getCodigoRequisicao().toString()) && dados.get(x).getDadosExames().getCodigo().equals(entrega.getCodigoExame()) && dados.get(x).getDadosMaterial().toString().contentEquals(entrega.getAbreviaturaMaterial());
    }

    public void carregarExamesEntregues(Integer codigoRequisicao) {
        List<ExameRequisicaoVO> vos = this.buscarExameRequisicaoVO(codigoRequisicao);
        for (ExameRequisicaoVO vo : vos) {
            Date dataEntregue = vo.getDataEntrega();
            String codigoUsuario = vo.getUsuarioEntrega();
            String entreguePara = vo.getEntreguePara();
            Integer requisicao = codigoRequisicao;
            String codigoExame = vo.getExame().getCodigo();
            String abreviaturaMaterial = vo.getMaterial().getAbreviatura();
            Integer codigoMaterial = vo.getMaterial().getCodigo();
            DadosEntrega dados = new DadosEntrega(requisicao, codigoExame, codigoMaterial, abreviaturaMaterial, codigoUsuario, entreguePara, dataEntregue);
            this.entregasRealizadas.adicionar(dados);
        }
    }

    private List<ExameRequisicaoVO> buscarExameRequisicaoVO(Integer codigoRequisicao) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", this.getCodigoFilial());
        chaves.put("req_codigo", codigoRequisicao);
        List<ExameRequisicaoVO> vos = null;
        try {
            vos = this.exameRequisicaoService.getVOs(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return vos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaValoresMultiguia(String codigo) throws ParseException {
        ArrayList<Registro> dadosReq = this.getInfoRequisicoes(codigo);
        this.modeloMultiguia.clear();
        if (this.registroCaixa == null) {
            this.registroCaixa = new Caixa[dadosReq.size()];
        }
        for (Registro req : dadosReq) {
            Statement st3;
            Statement st2;
            Statement st;
            block6: {
                this.modeloMultiguia.addLine(new Object[]{req.getString("req_codigo"), Funcoes.formataData(req.getDate("req_data"))});
                this.carregarExamesEntregues(req.getInt("req_codigo"));
                st = Conexao.getStatement();
                st2 = Conexao.getStatement();
                st3 = Conexao.getStatement();
                String sql = this.getSQLRequisicao(req.getString("req_codigo"), Acesso.getAcesso(Long.parseLong("0200900116")));
                try {
                    Caixa caixa1;
                    ResultSet rs = Conexao.executeQuery(st, sql);
                    if (!rs.next()) break block6;
                    int colunaRequisicao = this.modeloMultiguia.localizar(0, req.getString("req_codigo"));
                    this.registroCaixa[colunaRequisicao] = caixa1 = this.criarCaixa(req.getString("req_codigo"), st2, st3, rs);
                }
                catch (Exception sqlex) {
                    try {
                        ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "EntregaResultado (3028)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st, st2, st3);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st, st2, st3);
                    continue;
                }
            }
            Conexao.fecharStatement(st, st2, st3);
        }
        this.modeloMultiguia.ordenarColunaSemTrocarSentido(0);
    }

    private ArrayList<Registro> getInfoRequisicoes(String codigo) {
        ArrayList<Registro> reg = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        String guias = codigo;
        try {
            Integer[] multiguia = RecepcaoUtil.verificaMultiGuias(this.getCodigoFilial(), codigo, true);
            Statement st = Conexao.getStatementTratandoShutdown();
            guias = StringUtil.implode(Arrays.asList(multiguia), ",");
            buf.append("select req_codigo, req_data from requisicao where fil_codigo = ").append(this.getCodigoFilial()).append(" and  req_codigo in ( ").append(guias).append(")");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                Registro r = new Registro(rs);
                reg.add(r);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return reg;
    }

    private void validaBotaoImprimirTodos(boolean acessoImprimirDevedora) {
        boolean retorno = true;
        this.buttonImprimirTodos.setToolTipText(null);
        if (!this.getPermiteReimprimirExames()) {
            boolean todosImpressos = true;
            for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                if (this.modeloExame.getValueAt(i, 5).toString().equalsIgnoreCase("I")) continue;
                todosImpressos = false;
                break;
            }
            if (todosImpressos) {
                this.buttonImprimirTodos.setToolTipText("Usu\u00e1rio n\u00e3o possui acesso de reimpress\u00e3o");
                retorno = false;
            }
        }
        this.buttonImprimirTodos.setEnabled(retorno && this.telaEstaEmUpdate() && this.naoEstaDevendoHaGuia() && (this.saldo == 0.0 || acessoImprimirDevedora));
    }

    private void mostraInfoExame() {
        int linhaSelecionada = this.getLinhaSelecionadaExame();
        if (!this.linhaEstaSelecionada()) {
            return;
        }
        this.atualizarPanelEntrega();
    }

    private String getSituacaoExame() {
        if (this.linhaEstaSelecionada() && this.modeloExamePossioRegistros()) {
            return this.modeloExame.getValueAt(this.getLinhaSelecionadaExame(), 5).toString();
        }
        return "";
    }

    private boolean modeloExamePossioRegistros() {
        return this.modeloExame.getRowCount() > 0;
    }

    private boolean dataEntregaSelecionadaEstaNula() {
        return this.getDataEntregaExame(this.getLinhaSelecionadaExame()) == null;
    }

    private void definirPanelEntregaComoNaoEntregar() {
        int linha = this.getLinhaSelecionadaExame();
        DadosEntrega dadosEntrega = this.getDadosEntrega(linha);
        this.entregasRealizadas.remover(dadosEntrega);
        this.labelVDataHora.setText(this.getDataEntregaExameFormatada(linha));
        this.definirBotaoComoNaoEntregue();
        this.buttonNaoEntregue.setEnabled(false);
    }

    private void definirBotaoComoNaoEntregue() {
        this.buttonNaoEntregue.setText("N\u00e3o entregue");
        this.buttonNaoEntregue.setMnemonic('e');
        this.statusbuttonNaoEntregue = 2;
    }

    private DadosEntrega getDadosEntrega(int linha) {
        String exame = this.getCodigoExame(linha);
        Integer codigoMaterial = this.getCodigoMaterial(linha);
        String abreviaturaMaterial = this.getAbreviaturaMaterial(linha);
        String usuario = this.labelVUsuario.getText();
        String entreguePara = this.txtPara.getText();
        Date data = this.getDataEntrega();
        Integer requisicao = this.getCodigoDaRequisicaoSelecionada();
        DadosEntrega dadosEntrega = new DadosEntrega(requisicao, exame, codigoMaterial, abreviaturaMaterial, usuario, entreguePara, data);
        return dadosEntrega;
    }

    private void carregaCaixaRequisicao(String codigo) throws Exception {
        try {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            Statement st3 = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, this.getSQLRequisicao(codigo, false));
            if (rs.next()) {
                int colunaRequisicao = this.modeloMultiguia.localizar(0, codigo);
                this.convenio = ConvenioUtil.getDadosConvenios(this.getCodigoFilial(), rs.getInt("con_codigo"));
                this.caixa = new Caixa(null);
                this.caixa.setDadosConvenio(this.convenio);
                this.caixa.setPercentualDesconto(Funcoes.textoVazio(rs.getString("req_desconto")) ? 0.0 : rs.getDouble("req_desconto"));
                this.caixa.setPercentualAcrescimo(Funcoes.textoVazio(rs.getString("req_acrescimo")) ? 0.0 : rs.getDouble("req_acrescimo"));
                this.caixa.setValorAcrescimo(Funcoes.textoVazio(rs.getString("req_vlracrescimo")) ? 0.0 : rs.getDouble("req_vlracrescimo"));
                this.caixa.setValorDesconto(Funcoes.textoVazio(rs.getString("req_vlrdesconto")) ? 0.0 : rs.getDouble("req_vlrdesconto"));
                this.caixa.setValorExames(rs.getDouble("req_vlrexames"));
                this.caixa.setValorMateriais(rs.getDouble("req_vlrmateriais"));
                this.caixa.setTotalTaxa(new BigDecimal(rs.getDouble("valorTotalTaxa")));
                this.caixa.setFilial(this.getCodigoFilial());
                this.caixa.setConveniosRepasse(ConvenioUtil.getConveniosRepasse(st2, st3, this.getCodigoFilial(), String.valueOf(this.convenio.getCodigo())));
                this.caixa.setPermitirEstornarRepasseConvenio(Acesso.getAcesso(this.ACESSO_ESTORNO_REPASSE_CAIXA));
                if (!DBUtil.campoNull(rs.getString("con_codrepasse"))) {
                    this.convenioRepasse = ConvenioUtil.getDadosConvenios(this.getCodigoFilial(), rs.getInt("con_codrepasse"));
                    this.caixa.setConvenioRepasseSelecionado(this.convenioRepasse);
                }
                this.deviaGuiaRepasse = rs.getBoolean("req_deveguiarepasse");
                this.caixa.setGuiaPrincipalRepasse(rs.getString("req_guiaprincipalrepasse"));
                this.caixa.setGuiaRepasse(rs.getString("req_guiarepasse"));
                this.caixa.setMatriculaRepasse(rs.getString("req_matricularepasse"));
                this.caixa.setDeveGuiaRepasse(rs.getBoolean("req_deveguiarepasse"));
                this.caixa.setValidadeCarteiraRepasse(rs.getDate("req_validadecarteirarepasse"));
                this.caixa.setValidadeGuiaRepasse(rs.getDate("req_validadeguiarepasse"));
                this.caixa.setPlanoRepasse(rs.getString("req_nomeplanorepasse"));
                this.caixa.setObs(rs.getString("req_notacaixa"));
                this.caixa.setDadosPagador(rs.getInt("pac_codigo"), rs.getString("nomePagador"), Funcoes.temNumero(rs.getString("cpfPagador")) ? rs.getString("cpfPagador") : rs.getString("pac_cpf"));
                this.caixa.setDataRequisicao(rs.getDate("req_data"));
                this.caixa.setHabilitaAcrescimoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_ACRESCIMO));
                this.caixa.setHabilitaDescontoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_DESCONTO));
                this.caixa.setPermitirEstornoPagamento(Acesso.getAcesso(this.ACESSO_ESTORNAR_PAGAMENTO));
                this.caixa.setMovimentarCaixa(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_CAIXA));
                this.caixa.setAlterarData(Acesso.getAcesso(this.ACESSO_ALTERAR_DATA_CAIXA));
                boolean exigir = ParametrosGerais.getExigirDadosPagadorDmed() ? !Acesso.getAcesso(this.ACESSO_SALVAR_SEM_PAGADOR) : false;
                this.caixa.setSalvarSemPagador(!exigir);
                this.caixa.setAlterarConta(Acesso.getAcesso(this.ACESSO_ALTERAR_CONTA_CAIXA));
                this.caixa.setNaoMovimentarCaixaSemPagamento(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_SEM_PAGAMENTO));
                this.caixa.setCodigoRequisicao(this.getCodigoFilial(), Integer.parseInt(codigo), true);
                this.caixa.posicionaFoco(1);
                this.panelCaixa.setVisible(this.caixa.getValorRestante() > 0.0);
                this.saldo = this.caixa.getValorRestante();
                if (this.isExibirMultiguia) {
                    this.registroCaixa[colunaRequisicao] = this.caixa;
                }
                Conexao.fecharStatement(st, st2, st3);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Date getDataEntrega() {
        SimpleDateFormat form = new SimpleDateFormat("dd/MM/yyyy kk:mm");
        Date data = null;
        if (!Funcoes.textoVazio(this.labelVDataHora.getText())) {
            try {
                data = form.parse(this.labelVDataHora.getText());
            }
            catch (ParseException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
        return data;
    }

    private String formatarData(Date data) {
        if (data == null) {
            return "";
        }
        return Funcoes.formataData(data) + " " + Funcoes.formataHora(data, false);
    }

    private boolean linhaEstaSelecionada() {
        return this.getLinhaSelecionadaExame() > -1;
    }

    private int getLinhaSelecionadaExame() {
        return this.tableExame.getSelectedRow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonObservacoes) {
            this.mostrarObservacoes.setLocationRelativeTo(this.getTopLevelAncestor());
            this.mostrarObservacoes();
        } else if (e.getSource() == this.buttonReceberGuia) {
            this.receberGuia();
        }
    }

    private void receberGuia() {
        this.deviaGuia = true;
        this.deveGuia = false;
        this.controlaCampos(false);
    }

    private void mostrarObservacoes() {
        if (this.mostrarObservacoes != null) {
            this.mostrarObservacoes.setVisible(true);
        }
    }

    @Override
    public void valorEstornado(double valor) {
    }

    @Override
    public void repasseEstornado(DadosConvenios convenio) {
        int i;
        BigDecimal totalExames = new BigDecimal(0);
        BigDecimal totalMateriais = new BigDecimal(0);
        for (i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!(this.modeloExame.getValueAt(i, 9) instanceof DadosExames)) continue;
            DadosExames e = (DadosExames)this.modeloExame.getValueAt(i, 9);
            totalExames = totalExames.add(e.getValorExame());
            totalMateriais = totalMateriais.add(e.getValorMaterial());
        }
        if (convenio != null && convenio.getCobraExame() && convenio.getValorMinimoRequisicao() > 0.0 && totalExames.compareTo(new BigDecimal(convenio.getValorMinimoRequisicao())) < 0) {
            this.caixa.setValorExames(convenio.getValorMinimoRequisicao());
        } else {
            this.caixa.setValorExames(totalExames.doubleValue());
        }
        this.caixa.setValorMateriais(totalMateriais.doubleValue());
        for (i = 0; i < this.modeloExame.getRowCount(); ++i) {
            this.modeloExame.setValueAt(new Boolean(true), i, 8);
        }
    }

    private boolean getPermiteReimprimirExames() {
        boolean possuiAcesso = Acesso.getAcesso(Long.parseLong("0200900117"));
        return !possuiAcesso;
    }
}

