/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DialogoDataEntrega
extends AbstractDialogoOKCancelar {
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelHora = new JLabel("Hora:");
    private JLabel labelEntregue = new JLabel("Entregue para:");
    private TTextField textData = new TTextField(19, 4);
    private TTextField textHora = new TTextField(5, 6);
    private TTextField textEntregue = new TTextField(40);
    private JButton buttonData = ComponenteFactory.novoJButton(this, true);

    public static DialogoDataEntrega novaInstancia(Frame pai) {
        if (pai != null && pai instanceof Frame) {
            return new DialogoDataEntrega(pai, "Data de entrega");
        }
        return null;
    }

    public DialogoDataEntrega(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    private void montaTela() {
        this.setSize(new Dimension(300, 130));
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        panelCentral.add((Component)this.labelData, c);
        ++c.gridy;
        panelCentral.add((Component)this.labelHora, c);
        ++c.gridy;
        panelCentral.add((Component)this.labelEntregue, c);
        this.textData.setPreferredSize(new Dimension(100, 20));
        this.textData.setMinimumSize(new Dimension(100, 20));
        this.textData.setMaximumSize(new Dimension(100, 20));
        this.textHora.setPreferredSize(new Dimension(60, 20));
        this.textHora.setMinimumSize(new Dimension(60, 20));
        this.textHora.setMaximumSize(new Dimension(60, 20));
        this.textEntregue.setPreferredSize(new Dimension(180, 20));
        this.textEntregue.setMinimumSize(new Dimension(180, 20));
        this.textEntregue.setMaximumSize(new Dimension(180, 20));
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.buttonData.setMaximumSize(new Dimension(20, 20));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints cp = new GridBagConstraints();
        cp.gridx = 0;
        cp.gridy = 0;
        cp.anchor = 17;
        cp.fill = 0;
        p.add((Component)this.textData, cp);
        ++cp.gridx;
        p.add((Component)this.buttonData, cp);
        c.gridx = 1;
        c.gridy = 0;
        panelCentral.add((Component)p, c);
        ++c.gridy;
        panelCentral.add((Component)this.textHora, c);
        ++c.gridy;
        panelCentral.add((Component)this.textEntregue, c);
        this.textData.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textHora.setText(Funcoes.formataHora(new Date(), false));
        this.textEntregue.setText("Paciente");
        ScreenUtil.requisitarFoco(this.textData);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.textData, this.buttonData, this.getPanelCentral(), true);
        } else {
            super.actionPerformed(e);
        }
    }

    public String getEntreguePara() {
        return this.textEntregue.getText();
    }

    public Date getDataEntregue() {
        return Funcoes.stringToDate("dd/MM/yyyy HH:mm", this.textData.getText() + " " + this.textHora.getText());
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textEntregue) || !Funcoes.verificaData(this.textData.getText()) || !Funcoes.verificaHora(this.textHora.getText())) {
            Funcoes.mensagem(this, "Valores incorretos para entrega", 1);
            return false;
        }
        return true;
    }
}

