/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.recepcao.DestinoAlterado;
import jalis.laboratorio.recepcao.DestinoProibidoWeb;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DestinosProibidos
extends JPanel
implements ActionListener {
    JLabel label = new JLabel("");
    JButton button = ComponenteFactory.novoJButton(Variaveis.tipoFilialPadrao.equals("A") ? "Modal. proibidas na web" : "Destinos proibidos para web", this);
    ArrayList<String> destinos = new ArrayList();
    ArrayList<DestinoAlterado> listener = new ArrayList();
    Component owner = null;

    public DestinosProibidos() {
        super(new GridBagLayout());
        this.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.label, c);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        this.add((Component)this.button, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DestinoProibidoWeb dp;
        if (e.getSource() == this.button && (dp = DestinoProibidoWeb.novaInstancia(this.getTopLevelAncestor())) != null) {
            dp.setDestinos(new ArrayList<String>(this.destinos));
            dp.setVisible(true);
            if (dp.getOK()) {
                this.destinos = dp.getDestinos();
                this.setDestinos(this.destinos.toArray(new String[this.destinos.size()]));
                this.fireDestinoAlterado();
            }
        }
    }

    private void fireDestinoAlterado() {
        for (DestinoAlterado d : this.listener) {
            d.destinoAlterado();
        }
    }

    public void addDestinoAlteradoListener(DestinoAlterado l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void setDestinos(String ... codigos) {
        StringBuilder buf = new StringBuilder();
        this.destinos.clear();
        for (String s : codigos) {
            this.destinos.add(s);
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(s);
        }
        this.label.setText(buf.toString());
    }

    public String[] getDestinos() {
        return this.destinos.size() == 0 ? null : this.destinos.toArray(new String[this.destinos.size()]);
    }

    public void limpar() {
        this.destinos.clear();
        this.label.setText("");
    }

    public void habilitarCampos(boolean b) {
        this.button.setEnabled(b);
    }
}

