/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class DestinoProibidoWeb
extends AbstractDialogoOKCancelar
implements ActionListener {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private TTextField textDestino = new TTextField(5);
    private JLabel labelDestino = ComponenteFactory.novoJLabel("", new Dimension(10, 20), new TitledBorder(""));
    private JButton buttonBuscaDestino = ComponenteFactory.novoJButton(this, true);
    private ModeloGridTable modeloDestino = new ModeloGridTable(new String[]{"C\u00f3digo", "Destino"});
    private JTable tableDestino = new JTable(this.modeloDestino);
    private JButton buttonOKDestino = ComponenteFactory.novoJButton("OK", this);

    public static DestinoProibidoWeb novaInstancia(Component owner) {
        if (owner instanceof Frame) {
            return new DestinoProibidoWeb((Frame)owner, Variaveis.tipoFilialPadrao.equals("A") ? "Modalidades" : "Destinos");
        }
        if (owner instanceof Dialog) {
            return new DestinoProibidoWeb((Dialog)owner, Variaveis.tipoFilialPadrao.equals("A") ? "Modalidades" : "Destinos");
        }
        return null;
    }

    public DestinoProibidoWeb(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public DestinoProibidoWeb(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    private void montaTela(Component owner) {
        this.textDestino.setUpperCase(true);
        this.setSize(new Dimension(350, 400));
        this.setLocationRelativeTo(owner);
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        this.modeloDestino.setColumnSize(new int[]{70, 0}, this.tableDestino);
        this.montaControles();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        p.add((Component)new JLabel("Destino"), c);
        c.gridy = 1;
        c.gridx = 0;
        this.textDestino.setPreferredSize(new Dimension(69, 20));
        this.textDestino.setMinimumSize(new Dimension(69, 20));
        p.add((Component)this.textDestino, c);
        c.gridx = 1;
        this.buttonBuscaDestino.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaDestino.setPreferredSize(new Dimension(20, 20));
        p.add((Component)this.buttonBuscaDestino, c);
        c.gridx = 3;
        this.buttonOKDestino.setMinimumSize(new Dimension(40, 20));
        this.buttonOKDestino.setPreferredSize(new Dimension(40, 20));
        p.add((Component)this.buttonOKDestino, c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelDestino.setMinimumSize(new Dimension(100, 20));
        p.add((Component)this.labelDestino, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 4;
        p.add((Component)new JScrollPane(this.tableDestino), c);
    }

    private void montaControles() {
        this.textDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(DestinoProibidoWeb.this.textDestino.getText())) {
                        DestinoProibidoWeb.this.labelDestino.setText(DBUtil.getDescricao("des_codigo", "des_descricao", DestinoProibidoWeb.this.textDestino.getText(), "destino"));
                    }
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(DestinoProibidoWeb.this, e1.getMessage(), e1.getStackTrace(), "DestinoProibidoWeb (4508)");
                }
            }
        });
        this.textDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DestinoProibidoWeb.this.buscaDestino();
                }
            }
        });
        this.tableDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && DestinoProibidoWeb.this.tableDestino.getSelectedRow() > -1 && Funcoes.mensagem(DestinoProibidoWeb.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    DestinoProibidoWeb.this.modeloDestino.removeLine(DestinoProibidoWeb.this.tableDestino.getSelectedRow());
                }
            }
        });
        this.textDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    DestinoProibidoWeb.this.buscaDestino();
                }
            }
        });
    }

    private void buscaDestino() {
        Hashtable resultado = Pesquisas.destino(this, true);
        if (resultado != null) {
            this.textDestino.setText(resultado.get("des_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textDestino);
    }

    private void incluirDestino() {
        int pos;
        if (!Funcoes.textoVazio(this.textDestino.getText()) && !this.labelDestino.getText().equals("N\u00e3o cadastrado") && (pos = this.modeloDestino.localizar(0, this.textDestino.getText())) == -1) {
            this.modeloDestino.addLine(new String[]{this.textDestino.getText(), this.labelDestino.getText()});
        }
        this.textDestino.clear();
        this.labelDestino.setText("");
        ScreenUtil.requisitarFoco(this.textDestino);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaDestino) {
            this.buscaDestino();
        } else if (e.getSource() == this.buttonOKDestino) {
            this.incluirDestino();
        } else {
            super.actionPerformed(e);
        }
    }

    public ArrayList<String> getDestinos() {
        ArrayList<String> o = new ArrayList<String>();
        for (int i = 0; i < this.modeloDestino.getRowCount(); ++i) {
            o.add(this.modeloDestino.getValueAt(i, 0).toString());
        }
        return o;
    }

    public void setDestinos(ArrayList<String> destinos) {
        this.modeloDestino.clear();
        Iterator<String> iterator = destinos.iterator();
        while (iterator.hasNext()) {
            String o;
            String desc = o = iterator.next();
            try {
                desc = DBUtil.getDescricao("des_codigo", "des_descricao", o, "destino");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DestinoProibidoWeb: 4632");
            }
            this.modeloDestino.addLine(new String[]{o, desc});
        }
    }
}

