/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.utils.ThreadDaoException;
import jalis.util.ConvenioUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ContrassenhaExames
extends FrmCadPadrao
implements ActionListener,
ListSelectionListener {
    private static final String TIPO_CONTRASSENHAEXAMES = "E";
    private JPanel panelInfo = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelPrecos = new JPanel(new BorderLayout());
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelSenha = new JPanel(new GridBagLayout());
    private JLabel labelSenha = new JLabel("Senha:");
    private TTextField textSenha = new TTextField(QTDE_CARACTERES, 1);
    private JButton buttonOk = new JButton("OK");
    private JScrollPane scrollExames;
    private JScrollPane scrollPrecos;
    private JScrollPane scrollRequisicoes;
    private JScrollPane scrollInfo;
    private static final int COLUNA_INFO_NOME_PACIENTE = 0;
    private static final int COLUNA_INFO_NOME_MEDICO = 1;
    private static final int COLUNA_INFO_CRM_CONSELHO = 2;
    private static final int COLUNA_INFO_CRM_MEDICO = 3;
    private static final int COLUNA_INFO_UF_MEDICO = 4;
    private static final int COLUNA_INFO_CONVENIO = 5;
    private static final int COLUNA_INFO_CH_CONVENIO = 6;
    private static final int COLUNA_EXAMES_EXAME = 0;
    private static final int COLUNA_EXAMES_MATERIAL = 1;
    private static final int COLUNA_EXAMES_OBJETO = 2;
    private static final int COLUNA_PRECOS_PERCENTUAL = 0;
    private static final int COLUNA_PRECOS_CUSTO = 1;
    private static final int COLUNA_PRECOS_UCO = 2;
    private static final int COLUNA_PRECOS_VALOR_PORTE = 3;
    private static final int COLUNA_PRECOS_VALOR_MATERIAL = 4;
    private static final int COLUNA_PRECOS_VALOR_EXAME = 5;
    private static final int COLUNA_PRECOS_VALOR_TOTAL = 6;
    private static final int COLUNA_REQUISICOES_CODIGO = 0;
    private static final int COLUNA_REQUISICOES_DATA = 1;
    private static final int COLUNA_REQUISICOES_CONVENIO = 2;
    private static final int COLUNA_REQUISICOES_QTDE_EXAMES = 3;
    private static final int COLUNA_REQUISICOES_VALOR_TOTAL = 4;
    private ModeloGridTable modelInfo = new ModeloGridTable(new String[]{"Paciente", "Nome M\u00e9dico", "Cons.", "CRM", "UF", "Conv\u00eanio", "Vl. CH"});
    private ModeloGridTable modelExames = new ModeloGridTable(new String[]{"Exame", "Material", "Objeto"}){

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            try {
                if (ContrassenhaExames.this.tableExames != null) {
                    ContrassenhaExames.this.tableExames.removeColumn(ContrassenhaExames.this.tableExames.getColumn(ContrassenhaExames.this.tableExames.getColumnName(2)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private ModeloGridTable modelPrecos = new ModeloGridTable(new String[]{"%", "Custo", "UCO", "Vl. Porte", "Vl. Mat.", "Vl. Exame", "Vl. Total"});
    private ModeloGridTable modelRequisicoes = new ModeloGridTable(new String[]{"C\u00f3digo", "Data", "Conv\u00eanio", "Qtd. Exa.", "Vl. Total"});
    private JTable tableInfo = new JTable(this.modelInfo);
    private JTable tableExames = new JTable(this.modelExames);
    private JTable tablePrecos = new JTable(this.modelPrecos);
    private JTable tableRequisicoes = new JTable(this.modelRequisicoes);
    private static final int MAXIMO_SENHA = 999999;
    public static final int QTDE_CARACTERES = String.valueOf(999999).length();
    private boolean senhaCarregada = false;

    public ContrassenhaExames() {
        this.montaTela();
    }

    public ContrassenhaExames(int tipoContrassenha) {
        this.montaTela();
    }

    private void montaTela() {
        Funcoes.criaBarraDescricao(this, "Contrassenha", "Gera\u00e7\u00e3o de contrassenha para exames", "recepcao/contrassenha.jpg");
        this.painelCentral.setLayout(new GridBagLayout());
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setText("Gerar");
        this.botaoSalvar.setMnemonic('G');
        this.panelInfo.setBorder(BorderFactory.createTitledBorder("Paciente, M\u00e9dico e Conv\u00eanio da Requisi\u00e7\u00e3o"));
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames da Requisi\u00e7\u00e3o"));
        this.panelPrecos.setBorder(BorderFactory.createTitledBorder("Pre\u00e7o do Exame Selecionado"));
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es Anteriores do Paciente"));
        this.tableExames.removeColumn(this.tableExames.getColumn(this.tableExames.getColumnName(2)));
        this.tableExames.setFocusable(true);
        this.modelInfo.setColumnSize(new int[]{0, 0, 50, 40, 30, 0, 50}, this.tableInfo);
        this.modelExames.setColumnSize(new int[]{0, 75, 0}, this.tableExames);
        this.modelPrecos.setColumnSize(new int[]{40, 60, 50, 0, 0, 0, 0}, this.tablePrecos);
        this.modelRequisicoes.setColumnSize(new int[]{60, 85, 0, 80, 80}, this.tableRequisicoes);
        this.tableExames.getSelectionModel().addListSelectionListener(this);
        this.tableExames.getTableHeader().addMouseListener(this.modelExames);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modelRequisicoes);
        this.scrollExames = new JScrollPane(this.tableExames);
        this.scrollPrecos = new JScrollPane(this.tablePrecos);
        this.scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
        this.scrollInfo = new JScrollPane(this.tableInfo);
        Dimension d = new Dimension(100, 20);
        this.textSenha.setPreferredSize(d);
        this.textSenha.setMinimumSize(d);
        d = new Dimension(200, 20);
        this.panelExames.setPreferredSize(d);
        this.panelExames.setMinimumSize(d);
        d = new Dimension(20, 60);
        this.scrollInfo.setPreferredSize(d);
        this.scrollInfo.setMinimumSize(d);
        d = new Dimension(20, 80);
        this.scrollPrecos.setPreferredSize(d);
        this.scrollPrecos.setMinimumSize(d);
        this.buttonOk.setMnemonic('O');
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        d = new Dimension(30, 20);
        this.buttonOk.setPreferredSize(d);
        this.buttonOk.setMaximumSize(d);
        this.labelSenha.setLabelFor(this.textSenha);
        this.labelSenha.setDisplayedMnemonic('S');
        this.buttonOk.addActionListener(this);
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelPrecos.add((Component)this.scrollPrecos, "Center");
        this.panelInfo.add((Component)this.scrollInfo, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelSenha.add((Component)this.labelSenha, c);
        ++c.gridx;
        this.panelSenha.add((Component)this.textSenha, c);
        ++c.gridx;
        this.panelSenha.add((Component)this.buttonOk, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelSenha.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelSenha, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelInfo, c);
        ++c.gridy;
        c.gridheight = 2;
        c.gridwidth = 1;
        c.fill = 3;
        c.weighty = 1.0;
        c.weightx = 0.0;
        this.painelCentral.add((Component)this.panelExames, c);
        ++c.gridx;
        c.gridy = 2;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelPrecos, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.painelCentral.add((Component)this.panelRequisicoes, c);
        this.controlaCampos();
        this.modelExames.ordenarColunaSemTrocarSentido(0);
        this.modelRequisicoes.setSentidoOrdenacao(-1);
        this.modelRequisicoes.ordenarColunaSemTrocarSentido(1);
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textSenha.isEnabled() && this.textSenha.isFocusable()) {
            ScreenUtil.requisitarFoco(this.textSenha);
        }
    }

    @Override
    public void salvar() {
        String contrassenha = null;
        try {
            contrassenha = ContrassenhaExames.gerarContraSenha(this.textSenha.getText());
            StringBuilder buf = new StringBuilder();
            buf.append(" update contrassenharequisicao ");
            buf.append("    set usr_codgerada = '").append(Variaveis.login).append("' ");
            buf.append("       ,cse_datahoragerada = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm", new Date())).append("' ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and cse_codigo = ").append(this.textSenha.getText());
            Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
            Conexao.arquivaSQL();
            buf.setLength(0);
            buf.append("<html><font size = 3>A contrassenha gerada \u00e9: </font><font size = 4 color='red'>").append(contrassenha).append("</font>.</html>");
            Funcoes.mensagem(this, buf.toString(), 5);
        }
        catch (SQLException sqle) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel salvar dados de gera\u00e7\u00e3o de contrassenha.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar contrassenha.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void limparCampos() {
        this.textSenha.clear();
        this.modelInfo.clear();
        this.modelExames.clear();
        this.modelPrecos.clear();
        this.modelRequisicoes.clear();
        this.senhaCarregada = false;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.botaoSalvar.setEnabled(habilitar && this.senhaCarregada);
        this.textSenha.setEnabled(habilitar && !this.senhaCarregada);
        this.buttonOk.setEnabled(habilitar && !this.senhaCarregada);
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            if (Funcoes.textoVazio(this.textSenha)) {
                Funcoes.mensagem(this, "Insira a senha informada na adi\u00e7\u00e3o do exame para a cria\u00e7\u00e3o da contrassenha.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return;
            }
            if (this.textSenha.getText().length() != QTDE_CARACTERES) {
                this.textSenha.setText(Funcoes.preencheZero(Integer.parseInt(this.textSenha.getText()), QTDE_CARACTERES));
            }
            this.carregaDadosRequisicao(this.textSenha.getText());
            if (this.modelExames.getRowCount() > 0) {
                this.tableExames.getSelectionModel().setSelectionInterval(0, 0);
                ScreenUtil.requisitarFoco(this.tableExames);
            }
        }
    }

    private void carregaDadosRequisicao(String senha) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select pac.pac_codigo ");
        buf.append("       ,pac.pac_nome ");
        buf.append("       ,con.con_codigo ");
        buf.append("       ,con.con_fantasia ");
        buf.append("       ,con.con_valorch ");
        buf.append("       ,med.med_conselho ");
        buf.append("       ,med.med_crm ");
        buf.append("       ,med.med_uf ");
        buf.append("       ,med.med_nome ");
        buf.append("       ,COALESCE(cse.cse_valorbalcao, 0) as cse_valorbalcao ");
        buf.append("   from contrassenharequisicao cse ");
        buf.append("   join paciente pac on cse.fil_codigo = pac.fil_codigo and cse.pac_codigo = pac.pac_codigo ");
        buf.append("   left join medico med on cse.fil_codigo = med.fil_codigo and cse.med_conselho = med.med_conselho and cse.med_crm = med.med_crm and cse.med_uf = med.med_uf ");
        buf.append("   join convenios con on cse.fil_codigo = con.fil_codigo and cse.con_codigo = con.con_codigo ");
        buf.append("  where cse.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and cse.cse_codigo = ").append(senha);
        buf.append("    and cse.cse_tipo = '").append(TIPO_CONTRASSENHAEXAMES).append("'");
        try {
            ResultSet rsContrassenha = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rsContrassenha.next()) {
                this.modelInfo.addLine(new Object[]{rsContrassenha.getString("pac_nome"), rsContrassenha.getString("med_nome"), rsContrassenha.getString("med_conselho"), rsContrassenha.getString("med_crm"), rsContrassenha.getString("med_uf"), rsContrassenha.getString("con_fantasia"), Funcoes.formataDecimal(rsContrassenha.getDouble("con_valorch"))});
                double percentualBalcao = rsContrassenha.getDouble("cse_valorbalcao");
                buf.setLength(0);
                buf.append(" select exa.exa_codigo ");
                buf.append("       ,exa.exa_descricao ");
                buf.append("       ,mco.mco_codigo ");
                buf.append("       ,mco.mco_descricao ");
                buf.append("  from contrassenharequisicaoexame csx ");
                buf.append("  join exames exa on csx.fil_codigo = exa.fil_codigo and csx.exa_codigo = exa.exa_codigo ");
                buf.append("  join materialcoleta mco on csx.fil_codigo = mco.fil_codigo and csx.mco_codigo = mco.mco_codigo ");
                buf.append("  where csx.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and csx.cse_codigo = ").append(senha);
                ResultSet rsExames = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                while (rsExames.next()) {
                    DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rsExames.getInt("mco_codigo"));
                    DadosExames exame = ExameUtil.getDadosExame(Variaveis.filialPadrao, rsExames.getString("exa_codigo"), material);
                    DadosConvenios convenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, rsContrassenha.getInt("con_codigo"));
                    ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, exame, material, convenio, true, false, false, null, percentualBalcao, Integer.parseInt(exame.getCodMetodo()));
                    this.modelExames.addLine(new Object[]{exame.getDescricao(), material.getDescricao(), exame});
                }
                buf.setLength(0);
                buf.append(" select req.req_codigo ");
                buf.append("       ,req.req_data ");
                buf.append("       ,COUNT(1) as qtdeExames ");
                buf.append("       ,req.req_total ");
                buf.append("       ,con.con_fantasia ");
                buf.append("   from requisicao req ");
                buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
                buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
                buf.append("  where req.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and req.pac_codigo = ").append(rsContrassenha.getString("pac_codigo"));
                buf.append("  group by req.req_codigo, req.req_data, req.req_total, con.con_fantasia ");
                ResultSet rsRequisicoes = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                while (rsRequisicoes.next()) {
                    this.modelRequisicoes.addLine(new Object[]{rsRequisicoes.getString("req_codigo"), Funcoes.formataData("dd/MM/yyyy", rsRequisicoes.getDate("req_data")), rsRequisicoes.getString("con_fantasia"), rsRequisicoes.getInt("qtdeExames"), Funcoes.formataDecimal(rsRequisicoes.getDouble("req_total"))});
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o foram encontrados os dados da senha inserida.", 2);
                this.textSenha.selectAll();
                ScreenUtil.requisitarFoco(this.textSenha);
                return;
            }
            this.senhaCarregada = true;
            this.modelExames.ordenarColunaSemTrocarSentido(this.modelExames.getColunaOrdenacao());
            this.modelRequisicoes.ordenarColunaSemTrocarSentido(this.modelRequisicoes.getColunaOrdenacao());
            this.controlaCampos();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar senha.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reservaProximaSenha(Statement st) throws ThreadDaoException {
        int retorno = -1;
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('contrassenharequisicao_").append(Variaveis.filialPadrao).append("_sequence') ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                retorno = rs.getInt("nextval");
            }
        }
        catch (SQLException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return retorno;
    }

    public static String gerarSenha() throws Exception {
        Statement st = Conexao.getStatement();
        String retorno = String.valueOf(Funcoes.preencheZero(ContrassenhaExames.reservaProximaSenha(st), QTDE_CARACTERES));
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static String gerarSenha(Statement st) throws Exception {
        return String.valueOf(Funcoes.preencheZero(ContrassenhaExames.reservaProximaSenha(st), QTDE_CARACTERES));
    }

    public static String gerarContraSenha(String senha) throws Exception {
        if (senha == null || senha.length() == 0 || senha.length() > QTDE_CARACTERES || Integer.parseInt(senha) > 999999 || QTDE_CARACTERES % 2 == 1) {
            throw new Exception("A senha informada \u00e9 inv\u00e1lida.");
        }
        char[] caracteres = senha.toCharArray();
        char[] result = new char[QTDE_CARACTERES];
        int metade = QTDE_CARACTERES / 2;
        for (int i = 0; i < QTDE_CARACTERES; ++i) {
            int val = 0;
            val = i < metade ? Integer.parseInt(String.valueOf(caracteres[i])) + Integer.parseInt(String.valueOf(caracteres[metade + i])) : Integer.parseInt(String.valueOf(caracteres[i])) + Integer.parseInt(String.valueOf(caracteres[QTDE_CARACTERES - i - 1]));
            val -= val >= 10 ? 10 : 0;
            val -= (val += Integer.parseInt(String.valueOf(caracteres[QTDE_CARACTERES - 1]))) >= 10 ? 10 : 0;
            result[i] = Character.forDigit(val -= (val += i + 1) >= 10 ? 10 : 0, 10);
        }
        return String.valueOf(result);
    }

    public static boolean validaContraSenha(String contrassenha, String senha) throws Exception {
        if (contrassenha == null || contrassenha.length() == 0 || contrassenha.length() > QTDE_CARACTERES || Integer.parseInt(contrassenha) > 999999 || QTDE_CARACTERES % 2 == 1) {
            throw new Exception("A contrassenha informada \u00e9 inv\u00e1lida.");
        }
        if (senha == null || senha.length() == 0 || senha.length() > QTDE_CARACTERES || Integer.parseInt(senha) > 999999 || QTDE_CARACTERES % 2 == 1) {
            throw new Exception("A senha informada \u00e9 inv\u00e1lida.");
        }
        char[] caracContra = contrassenha.toCharArray();
        char[] caracSenha = senha.toCharArray();
        char[] result = new char[QTDE_CARACTERES];
        int metade = QTDE_CARACTERES / 2;
        for (int i = 0; i < QTDE_CARACTERES; ++i) {
            int val = 0;
            val += (val = Integer.parseInt(String.valueOf(caracContra[i])) - (i + 1)) < 0 ? 10 : 0;
            val += (val -= Integer.parseInt(String.valueOf(caracSenha[QTDE_CARACTERES - 1]))) < 0 ? 10 : 0;
            val = i < metade ? (val -= Integer.parseInt(String.valueOf(caracSenha[metade + i]))) : (val -= Integer.parseInt(String.valueOf(caracSenha[QTDE_CARACTERES - i - 1])));
            result[i] = Character.forDigit(val += val < 0 ? 10 : 0, 10);
        }
        return String.valueOf(result).equalsIgnoreCase(senha);
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return "";
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0201200100");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.tableExames.getSelectionModel()) {
            int row = this.tableExames.getSelectedRow();
            this.modelPrecos.clear();
            if (row >= 0) {
                DadosExames exame = (DadosExames)this.modelExames.getValueAt(row, 2);
                this.modelPrecos.addLine(new Object[]{Funcoes.formataDecimal(exame.getPercentual().doubleValue()), Funcoes.formataDecimal(exame.getCusto().doubleValue()), Funcoes.formataDecimal(exame.getUco().doubleValue()), Funcoes.formataDecimal(exame.getValorPorte().doubleValue()), Funcoes.formataDecimal(exame.getValorMaterial().add(exame.getValorMaterialBalcao()).doubleValue()), Funcoes.formataDecimal(exame.getValorExame().doubleValue()), Funcoes.formataDecimal(exame.getValor().doubleValue())});
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

