/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.ConsultaStatusSolicitacao;
import jalis.laboratorio.util.faturamento.eletronico.ConsultarCodigoSolicitacaoAPI;
import jalis.laboratorio.util.faturamento.eletronico.SolicitarStatusAutorizacaoAPI;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ConsultarCodigoSolicitacao
extends AbstractDialogoOKCancelar
implements ActionListener {
    private static final String NAO_AUTORIZADO = "0";
    private final int COLUNA_EXAME_CODIGO = 0;
    private final int COLUNA_EXAME_DESCRICAO = 1;
    private final int COLUNA_EXAME_MATERIAL = 2;
    private final int COLUNA_QTDE_SOLICITADO = 3;
    private final int COLUNA_QTDE_AUTORIZADO = 4;
    private final int COLUNA_EXAME_MARCADO = 5;
    private final int COLUNA_EXAME_DESCRICAO_MATERIAL = 6;
    private final int COLUNA_CODIGO_GUIA = 0;
    private final int COLUNA_DATA_SOLICITACAO = 1;
    private final int COLUNA_VALIDADE_SENHA = 2;
    private final String APROVADA = "Aprovada";
    private final String NEGADA = "Negada";
    private final String EM_ESTUDO = "Em estudo";
    private final String CANCELADA = "Cancelada";
    private final String VENCIDA = "Vencidas";
    private final String EXECUTADA = "Executada";
    private ModeloGridTable modeloGuia = new ModeloGridTable(new String[]{"Cod. Guia", "Dt. Solic.", "Validade Senha"});
    private JTable tableGuias = ComponenteFactory.novoJTable((TableModel)this.modeloGuia, 150, 0, 80);
    private JScrollPane scrollGuia = new JScrollPane(this.tableGuias);
    private JTextArea textErros = new JTextArea(new TTextAreaDocument(5000));
    private JPanel panelGuias = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelErros = new JPanel(new BorderLayout());
    private JLabel labelStatus = new JLabel("Filtro Situa\u00e7\u00e3o: ");
    private JComboBox comboStatus = new JComboBox<String>(new String[]{"Aprovada", "Negada", "Em estudo", "Cancelada", "Vencidas", "Executada"});
    private JScrollPane scrollErro = new JScrollPane(this.textErros);
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private List<Registro> exames = new ArrayList<Registro>();
    private HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listAprovados = new HashMap();
    private HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listNegadas = new HashMap();
    private HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listEmEstudo = new HashMap();
    private HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listCancelada = new HashMap();
    private HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listVencidos = new HashMap();
    private HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listExecutadas = new HashMap();
    private String xmlConfig = "";
    private String codigoConvenio = "";
    private ModeloResultSet modeloExame = new ModeloResultSet(new String[]{"C\u00f3digo", "codigoexame", "Exame", "exa_descricao", "Material", "descricaomaterial", "Qtde. Solic.", "qtdeSolicitada", "Qtde. Auto.", "qtdeAutorizada", "#", "selecionado", "", "codigomaterial"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 5) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            return columnIndex == 5;
        }
    };
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExame, 50, 0, 50, 70, 70, 30, 1);
    private JScrollPane scrollExame = new JScrollPane(this.tableExames);

    public ConsultarCodigoSolicitacao(Dialog pai, String titulo) {
        super(pai, titulo);
    }

    public ConsultarCodigoSolicitacao(Frame pai, String titulo, List<ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listaRetorno, String xmlConfig, String codigoConvenio) {
        super(pai, titulo);
        this.xmlConfig = xmlConfig;
        this.codigoConvenio = codigoConvenio;
        this.carregaListasPorStatus(listaRetorno);
        this.montarTela(pai);
    }

    private void carregaListasPorStatus(List<ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> listaRetorno) {
        for (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao retorno : listaRetorno) {
            if (retorno.getSituacao() == null) continue;
            if (retorno.getSituacao().equalsIgnoreCase("Aprovada")) {
                if (this.verificaDataValidadeGuia(retorno.getValidade_senha())) {
                    this.listAprovados.put(retorno.getNumero_guia(), retorno);
                    continue;
                }
                this.listVencidos.put(retorno.getNumero_guia(), retorno);
                continue;
            }
            if (retorno.getSituacao().equalsIgnoreCase("Negada")) {
                this.listNegadas.put(retorno.getNumero_guia(), retorno);
                continue;
            }
            if (retorno.getSituacao().equalsIgnoreCase("Em estudo")) {
                this.listEmEstudo.put(retorno.getNumero_guia(), retorno);
                continue;
            }
            if (retorno.getSituacao().equalsIgnoreCase("Cancelada")) {
                this.listCancelada.put(retorno.getNumero_guia(), retorno);
                continue;
            }
            if (!retorno.getSituacao().equalsIgnoreCase("Executada")) continue;
            this.listExecutadas.put(retorno.getNumero_guia(), retorno);
        }
    }

    public boolean verificaDataValidadeGuia(String dataGuia) {
        Date dataAtual = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        String dtAtual = sdf.format(dataAtual);
        String dtValidadeSenha = this.formataData(dataGuia);
        return Funcoes.comparaData(dtValidadeSenha, dtAtual) > 0;
    }

    private String formataData(String dataGuia) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfAux = new SimpleDateFormat("yyyy-MM-dd");
        String dtValidadeSenha = "";
        try {
            if (!Funcoes.textoVazio(dataGuia) && !dataGuia.equalsIgnoreCase("null")) {
                dtValidadeSenha = sdf.format(sdfAux.parse(dataGuia));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dtValidadeSenha;
    }

    public void montarTela(Frame pai) {
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        Dimension dim = new Dimension(900, 600);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setLocationRelativeTo(pai);
        this.setResizable(false);
        this.panelGuias.setBorder(BorderFactory.createTitledBorder("Guias"));
        this.scrollGuia.setPreferredSize(new Dimension(300, 80));
        this.labelStatus.setPreferredSize(new Dimension(92, 20));
        this.comboStatus.setPreferredSize(new Dimension(95, 20));
        JPanel panelCombo = new JPanel();
        JPanel panelAux = new JPanel();
        panelCombo.setPreferredSize(new Dimension(200, 35));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 0;
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 0, 0, 0);
        panelCombo.add((Component)this.labelStatus, cons);
        ++cons.gridy;
        panelCombo.add((Component)this.comboStatus, cons);
        ++cons.gridy;
        panelAux.setPreferredSize(new Dimension(98, 35));
        panelCombo.add((Component)panelAux, cons);
        this.tableExames.setDefaultRenderer(Object.class, new RenderExames());
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.modeloExame.setTamanhoColunas(this.tableExames, 50, 100, 80, 70, 70, 30, 0, 0);
        this.panelExames.add((Component)this.scrollExame, "Center");
        this.textErros.setEditable(false);
        this.panelErros.setPreferredSize(new Dimension(100, 100));
        this.panelErros.setBorder(BorderFactory.createTitledBorder("Avisos"));
        this.panelErros.add((Component)this.scrollErro, "Center");
        this.panelExames.add((Component)this.panelErros, "South");
        this.panelGuias.add((Component)this.scrollGuia, "Center");
        this.panelGuias.add((Component)panelCombo, "South");
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.panelGuias, "West");
        this.getPanelCentral().add((Component)this.panelExames, "Center");
        this.carregaInformacoes(this.listAprovados);
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    Boolean isMarcado = (Boolean)ConsultarCodigoSolicitacao.this.modeloExame.getValueAt(ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                    if (isMarcado.booleanValue()) {
                        ConsultarCodigoSolicitacao.this.modeloExame.setValueAt(false, ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                    } else {
                        ConsultarCodigoSolicitacao.this.modeloExame.setValueAt(true, ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                    }
                    ConsultarCodigoSolicitacao.this.modeloExame.fireTableCellUpdated(ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                }
            }
        });
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Boolean isMarcado = (Boolean)ConsultarCodigoSolicitacao.this.modeloExame.getValueAt(ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                    if (isMarcado.booleanValue()) {
                        ConsultarCodigoSolicitacao.this.modeloExame.setValueAt(false, ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                    } else {
                        ConsultarCodigoSolicitacao.this.modeloExame.setValueAt(true, ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                    }
                    ConsultarCodigoSolicitacao.this.modeloExame.fireTableCellUpdated(ConsultarCodigoSolicitacao.this.tableExames.getSelectedRow(), 5);
                }
            }
        });
        this.tableGuias.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ConsultarCodigoSolicitacao.this.tableGuias.getSelectedRow() > -1) {
                    ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao dadosGuia = null;
                    ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                    ConsultarCodigoSolicitacao.this.textErros.setText("");
                    String key = (String)ConsultarCodigoSolicitacao.this.modeloGuia.getValueAt(ConsultarCodigoSolicitacao.this.tableGuias.getSelectedRow(), 0);
                    if (ConsultarCodigoSolicitacao.this.comboStatus.getSelectedItem().equals("Aprovada")) {
                        dadosGuia = (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao)ConsultarCodigoSolicitacao.this.listAprovados.get(key);
                        ConsultarCodigoSolicitacao.this.adicionarExamesSolicitacaoStatusAutorizacao(dadosGuia.getCodigo_solicitacao());
                    } else if (ConsultarCodigoSolicitacao.this.comboStatus.getSelectedItem().equals("Negada")) {
                        dadosGuia = (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao)ConsultarCodigoSolicitacao.this.listNegadas.get(key);
                        ConsultarCodigoSolicitacao.this.adicionarExamesSolicitacaoStatusAutorizacao(dadosGuia.getCodigo_solicitacao());
                    } else if (ConsultarCodigoSolicitacao.this.comboStatus.getSelectedItem().equals("Em estudo")) {
                        dadosGuia = (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao)ConsultarCodigoSolicitacao.this.listEmEstudo.get(key);
                        ConsultarCodigoSolicitacao.this.adicionarExamesSolicitacaoStatusAutorizacao(dadosGuia.getCodigo_solicitacao());
                    } else if (ConsultarCodigoSolicitacao.this.comboStatus.getSelectedItem().equals("Cancelada")) {
                        dadosGuia = (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao)ConsultarCodigoSolicitacao.this.listCancelada.get(key);
                        ConsultarCodigoSolicitacao.this.adicionarExamesSolicitacaoStatusAutorizacao(dadosGuia.getCodigo_solicitacao());
                    } else if (ConsultarCodigoSolicitacao.this.comboStatus.getSelectedItem().equals("Vencidas")) {
                        dadosGuia = (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao)ConsultarCodigoSolicitacao.this.listVencidos.get(key);
                        ConsultarCodigoSolicitacao.this.adicionarExamesSolicitacaoStatusAutorizacao(dadosGuia.getCodigo_solicitacao());
                    } else if (ConsultarCodigoSolicitacao.this.comboStatus.getSelectedItem().equals("Executada")) {
                        dadosGuia = (ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao)ConsultarCodigoSolicitacao.this.listExecutadas.get(key);
                        ConsultarCodigoSolicitacao.this.adicionarExamesSolicitacaoStatusAutorizacao(dadosGuia.getCodigo_solicitacao());
                    }
                }
            }
        });
        this.comboStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                switch (e.getItem().toString()) {
                    case "Aprovada": {
                        ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                        ConsultarCodigoSolicitacao.this.carregaInformacoes(ConsultarCodigoSolicitacao.this.listAprovados);
                        ConsultarCodigoSolicitacao.this.buttonOK.setEnabled(true);
                        break;
                    }
                    case "Negada": {
                        ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                        ConsultarCodigoSolicitacao.this.carregaInformacoes(ConsultarCodigoSolicitacao.this.listNegadas);
                        ConsultarCodigoSolicitacao.this.buttonOK.setEnabled(false);
                        break;
                    }
                    case "Em estudo": {
                        ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                        ConsultarCodigoSolicitacao.this.carregaInformacoes(ConsultarCodigoSolicitacao.this.listEmEstudo);
                        ConsultarCodigoSolicitacao.this.buttonOK.setEnabled(false);
                        break;
                    }
                    case "Cancelada": {
                        ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                        ConsultarCodigoSolicitacao.this.carregaInformacoes(ConsultarCodigoSolicitacao.this.listCancelada);
                        ConsultarCodigoSolicitacao.this.buttonOK.setEnabled(false);
                        break;
                    }
                    case "Vencidas": {
                        ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                        ConsultarCodigoSolicitacao.this.carregaInformacoes(ConsultarCodigoSolicitacao.this.listVencidos);
                        ConsultarCodigoSolicitacao.this.buttonOK.setEnabled(false);
                        break;
                    }
                    case "Executada": {
                        ConsultarCodigoSolicitacao.this.modeloExame.limpar();
                        ConsultarCodigoSolicitacao.this.carregaInformacoes(ConsultarCodigoSolicitacao.this.listExecutadas);
                        ConsultarCodigoSolicitacao.this.buttonOK.setEnabled(false);
                    }
                }
            }
        });
        this.tableGuias.getTableHeader().addMouseListener(this.modeloGuia);
        this.modeloGuia.ordenarColuna(0);
    }

    private void carregaInformacoes(HashMap<String, ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao> dados) {
        ConsultarCodigoSolicitacaoAPI.RetornoCodigoSolicitacao dadosGuia = null;
        if (dados != null) {
            this.modeloGuia.clear();
            for (String key : dados.keySet()) {
                dadosGuia = dados.get(key);
                this.modeloGuia.addLine(new String[]{key, this.formataData(dadosGuia.getData_solicitacao()), this.formataData(dadosGuia.getValidade_senha())});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.carregarExamesSelecionados();
            this.ok = true;
            this.dispose();
        }
        if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
    }

    private void carregarExamesSelecionados() {
        this.exames.clear();
        for (int i = 0; i < this.tableExames.getRowCount(); ++i) {
            Boolean marcado = (Boolean)this.tableExames.getValueAt(i, 5);
            String autorizado = this.tableExames.getValueAt(i, 4) != null ? this.tableExames.getValueAt(i, 4).toString() : "";
            String codigoExame = this.tableExames.getValueAt(i, 0) != null ? this.tableExames.getValueAt(i, 0).toString() : "";
            String descricaoExame = this.tableExames.getValueAt(i, 1) != null ? this.tableExames.getValueAt(i, 1).toString() : "";
            int material = (Integer)(this.tableExames.getValueAt(i, 6) != null ? this.tableExames.getValueAt(i, 6) : "");
            try {
                if (!marcado.booleanValue() || autorizado.equalsIgnoreCase(NAO_AUTORIZADO)) continue;
                Registro registro = new Registro();
                ExameVO exameVO = (ExameVO)new ExameService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and exa_codigo = '" + codigoExame + "' ;").toArray()[0];
                registro.setValor("objetoExame", exameVO);
                registro.setValor("exame", codigoExame);
                registro.setValor("descricaoExame", descricaoExame);
                registro.setValor("codigomaterial", material);
                this.exames.add(registro);
                continue;
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar a lista de exames selecionados.\n" + e1.getMessage(), e1.getStackTrace());
            }
        }
    }

    private void adicionarExamesSolicitacaoStatusAutorizacao(String codigoSolicitacao) {
        ConsultaStatusSolicitacao consulta = new ConsultaStatusSolicitacao(this.xmlConfig, this.codigoConvenio);
        List<SolicitarStatusAutorizacaoAPI.RetornoSolicitacao> listaRetorno = consulta.getListRetornoConsultaAPI(codigoSolicitacao);
        if (listaRetorno.isEmpty()) {
            this.textErros.setText("Nenhum procedimento retornado com o codigo da solicita\u00e7\u00e3o  " + codigoSolicitacao);
            return;
        }
        for (SolicitarStatusAutorizacaoAPI.RetornoSolicitacao retornoSolicitacao : listaRetorno) {
            ArrayList<Registro> exames = new ArrayList<Registro>();
            exames.clear();
            String codigoExame = retornoSolicitacao.getCodigo_servico();
            String descricaoExame = retornoSolicitacao.getDescricao_servico();
            String qtdeSolicitada = StringUtil.removeCaracteresNaoNumericos(retornoSolicitacao.getQuantidade_solicitada());
            String qtdeAutorizada = StringUtil.removeCaracteresNaoNumericos(retornoSolicitacao.getQuantidade_autorizada());
            codigoExame = codigoExame.replaceAll("\"", "");
            exames.addAll(consulta.getExamesSolicitacao(codigoExame, descricaoExame));
            for (Registro reg : exames) {
                codigoExame = reg.getString("codigoexame");
                descricaoExame = reg.getString("exa_descricao");
                String descricaoMaterial = reg.getString("descricaomaterial");
                int material = reg.getInt("codigomaterial");
                reg.setValor("selecionado", false);
                reg.setValor("qtdeSolicitada", qtdeSolicitada);
                reg.setValor("qtdeAutorizada", qtdeAutorizada);
                this.modeloExame.addRegistro(reg);
            }
            if (consulta.getErros() == null || consulta.getErros().isEmpty()) continue;
            String erro = "";
            for (String msg : consulta.getErros()) {
                erro = erro + msg;
            }
            this.textErros.setText(erro);
        }
    }

    public List<Registro> getExames() {
        return this.exames;
    }

    public void setExames(List<Registro> exames) {
        this.exames = exames;
    }

    class RenderExames
    extends DefaultTableCellRenderer {
        RenderExames() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ModeloResultSet model = (ModeloResultSet)table.getModel();
            Registro reg = model.getRegistros().get(row);
            Color corExame = Color.black;
            Color corBackground = Color.white;
            if (this.estaSelecionado(table, row)) {
                ((JComponent)c).setBorder(BorderFactory.createEmptyBorder());
                corBackground = table.getSelectionBackground();
                corExame = Color.white;
            }
            if (reg.getString("qtdeAutorizada").equals(ConsultarCodigoSolicitacao.NAO_AUTORIZADO)) {
                corExame = Color.BLACK;
                corBackground = Color.RED;
            }
            this.setBackground(corBackground);
            this.setForeground(corExame);
            return this;
        }

        private boolean estaSelecionado(JTable table, int row) {
            for (int i : table.getSelectedRows()) {
                if (i != row) continue;
                return true;
            }
            return false;
        }
    }
}

