/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.SolicitarStatusAutorizacaoAPI;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ConsultaStatusSolicitacao {
    public String xmlConfig = "";
    public String codigoConvenio = "";
    public ArrayList<String> erros = new ArrayList();

    public ConsultaStatusSolicitacao(String xmlConfig, String codigoConvenio) {
        this.xmlConfig = xmlConfig;
        this.codigoConvenio = codigoConvenio;
    }

    public List<SolicitarStatusAutorizacaoAPI.RetornoSolicitacao> getListRetornoConsultaAPI(String codigoSolicitacao) {
        List<SolicitarStatusAutorizacaoAPI.RetornoSolicitacao> listaRetorno = null;
        try {
            SolicitarStatusAutorizacaoAPI solicitarStatusAPI = new SolicitarStatusAutorizacaoAPI();
            String url = StringUtil.getValor(this.xmlConfig, "caminhoWebService");
            String token = StringUtil.getValor(this.xmlConfig, "token");
            if (Funcoes.textoVazio(token)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Token Inv\u00e1lido. Verifique as configura\u00e7\u00f5es de token do conv\u00eanio", 1);
                return null;
            }
            url = url + "api_token=" + token;
            url = url + "&codigo_solicitacao=" + codigoSolicitacao;
            solicitarStatusAPI.solicitarStatusAutorizacao(url);
            listaRetorno = solicitarStatusAPI.getListaRetorno();
        }
        catch (IOException e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel fazer a consulta no c\u00f3digo de solicita\u00e7\u00e3o.\n" + e.getMessage(), 2);
        }
        return listaRetorno;
    }

    public ArrayList<Registro> getExamesSolicitacao(String codigoExame, String descricaoExame) {
        ArrayList<Registro> registro = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT  a.exa_codigo AS codigoExame, ");
        buf.append("        a.exa_descricao, ");
        buf.append("        emc.mco_codigo   AS codigoMaterial, ");
        buf.append("        mc.mco_descricao, ");
        buf.append("        mc.mco_abreviatura AS descricaomaterial ");
        buf.append("FROM   exames a  ");
        buf.append("       INNER JOIN examematcoleta emc  ");
        buf.append("               ON a.fil_codigo = emc.fil_codigo ");
        buf.append("               AND emc.exa_codigo = a.exa_codigo  ");
        buf.append("               AND emc.emc_default ");
        buf.append("       INNER JOIN detalhetabelapreco dtp ");
        buf.append("               ON  a.fil_codigo = dtp.fil_codigo ");
        buf.append("               AND a.exa_codigo = dtp.exa_codigo ");
        buf.append("               AND dtp.mco_codigo = emc.mco_codigo ");
        buf.append("             JOIN materialcoleta mc ");
        buf.append("               ON a.fil_codigo = mc.fil_codigo ");
        buf.append("               AND emc.mco_codigo = mc.mco_codigo ");
        buf.append("             JOIN convenios con ");
        buf.append("               ON a.fil_codigo = con.fil_codigo ");
        buf.append("               AND con.tpe_codigo = dtp.tpe_codigo ");
        buf.append(" WHERE a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" AND con.con_codigo = ").append(this.codigoConvenio);
        buf.append(" AND replace(replace(dtp.dtp_codamb, '.', ''), '-', '') = ").append("'").append(codigoExame).append("'");
        buf.append(" order by codigoExame ");
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            boolean adicionou = false;
            while (rs.next()) {
                codigoExame = rs.getString("codigoExame");
                descricaoExame = rs.getString("exa_descricao");
                Registro reg = new Registro(rs);
                ExameVO exameVO = (ExameVO)new ExameService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and exa_codigo = '" + rs.getString("codigoExame") + "' ;").toArray()[0];
                reg.setValor("objetoExame", exameVO);
                reg.setValor("exame", codigoExame);
                reg.setValor("descricaoExame", descricaoExame);
                registro.add(reg);
                adicionou = true;
            }
            if (!adicionou) {
                this.erros.add("Exame: " + codigoExame + ": " + descricaoExame + " n\u00e3o foi encontrado. \nVerifique a tabela de pre\u00e7os do conv\u00eanio. \n");
            }
        }
        catch (Exception e) {
            this.erros.add(codigoExame + " - " + descricaoExame + "\n" + e.getMessage());
        }
        return registro;
    }

    public ArrayList<String> getErros() {
        return this.erros;
    }

    public void setErros(ArrayList<String> erros) {
        this.erros = erros;
    }
}

