/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import br.com.thread.pdfbox.pdmodel.PDDocument;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.DialogoImagem;
import jalis.laboratorio.resultados.DialogoVisualizarResultadoPdf;
import jalis.model.vo.recepcao.RequisicaoImagensVO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTable;
import org.apache.commons.codec.binary.Base64;

class ButtonEditor
extends DefaultCellEditor {
    private JButton button;
    int linha = -1;
    JDialog pai = null;
    JTable table;

    public ButtonEditor(JDialog pai, JTable table) {
        super(new JCheckBox());
        this.table = table;
        this.pai = pai;
        this.button = new JButton();
        this.button.setOpaque(true);
        Funcoes.imagemPesquisa(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.linha = row;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.linha > -1) {
            String extensao = this.buscarExtensao(this.linha, 0);
            if (extensao == null && !this.validaExtensaoPdf() || extensao != null && !extensao.equals("pdf")) {
                DialogoImagem dialogo = new DialogoImagem(this.pai);
                dialogo.setImagem(this.pegaImagem(this.linha));
                dialogo.setModal(true);
                dialogo.setVisible(true);
                ScreenUtil.requisitarFoco(this.table);
            } else {
                DialogoVisualizarResultadoPdf pdf = DialogoVisualizarResultadoPdf.novaInstancia(Laboratorio.getInstancia(), true);
                try {
                    pdf.setPDf(this.buscarExtensao(this.linha, 1));
                    pdf.setVisible(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    private Image pegaImagem(int linha) {
        Image retorno = null;
        RequisicaoImagensVO obj = null;
        if (linha > -1 && (obj = this.buscaObjeto(linha)) != null) {
            new Base64();
            retorno = new ImageIcon(Base64.decodeBase64((String)obj.getImagem())).getImage();
        }
        return retorno;
    }

    private String buscarExtensao(int linha, int parametro) {
        String extensao = null;
        RequisicaoImagensVO obj = null;
        if (linha > -1 && (obj = this.buscaObjeto(linha)) != null) {
            extensao = parametro == 0 ? obj.getExtensao() : obj.getImagem();
        }
        return extensao;
    }

    private RequisicaoImagensVO buscaObjeto(int linha) {
        RequisicaoImagensVO obj = null;
        if (linha > -1 && this.table.getColumnCount() == 6) {
            RequisicaoImagensVO requisicaoImagem;
            obj = requisicaoImagem = (RequisicaoImagensVO)this.table.getValueAt(linha, 5);
        }
        return obj;
    }

    private boolean validaExtensaoPdf() {
        byte[] pdf = new Base64().decode(this.buscarExtensao(this.linha, 1));
        try {
            PDDocument pDDocument = PDDocument.load((byte[])pdf);
        }
        catch (IOException e1) {
            return false;
        }
        return true;
    }
}

