/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Senha;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Statement;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class AutorizacaoExame
extends JDialog
implements DisposeListener {
    private JPanel panelTopo = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JLabel labelExame = new JLabel("Exame:");
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelAutorizacao = new JLabel("Autoriza\u00e7\u00e3o:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelValidade = new JLabel("Validade:");
    private JLabel labelCodExame = new JLabel();
    private JLabel labelCodMaterial = new JLabel();
    private JLabel labelDescExame = new JLabel();
    private TTextField txtAutorizacao = new TTextField(30);
    private TTextField txtData = new TTextField(10, 4);
    private TTextField txtValidade = new TTextField(10, 4);
    private JButton buttonOKAutorizacao = new JButton("OK");
    private JButton buttonOKTela = new JButton("OK");
    private JButton buttonData = new JButton();
    private JButton buttonValidade = new JButton();
    private JTable tableExame = new JTable();
    private JScrollPane scrollExame = new JScrollPane(this.tableExame);
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Descri\u00e7\u00e3o", "Autoriza\u00e7\u00e3o", "Data", "Validade"});
    private boolean isOK = false;
    private int linhaAlterada = -1;
    private boolean sairSemPreencher = false;
    private long acessoSairSemPreencher;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_AUTORIZACAO = 3;
    private final int COLUNA_DATA = 4;
    private final int COLUNA_VALIDADE = 5;
    private final int COLUNA_EXAME_AGRUPADO = 6;
    private String codigoAutorizacaoRetorno = "";
    private String codigoExameSelecionado;
    private String materialExameSelecionado;
    private boolean isConferenciaGuia = false;

    public String getCodigoAutorizacaoEscolhida() {
        return this.codigoAutorizacaoRetorno;
    }

    public AutorizacaoExame(Frame owner, boolean isConferenciaGuias) {
        super(owner, "C\u00f3digo de libera\u00e7\u00e3o de exames");
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.isConferenciaGuia = isConferenciaGuias;
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public AutorizacaoExame(Dialog owner, boolean isConferenciaGuias) {
        super(owner, "Autoriza\u00e7\u00e3o de exames");
        try {
            this.isConferenciaGuia = isConferenciaGuias;
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public AutorizacaoExame(Frame owner, boolean apenasSelecionar, boolean isConferenciaGuias) {
        super(owner, "Selecione o c\u00f3digo de libera\u00e7\u00e3o de exame");
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.jbInit2();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit2() throws Exception {
        this.setSize(750, 200);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.tableExame.setModel(this.modeloExame);
        this.modeloExame.setColumnSize(new int[]{60, 60, 0, 0, 80, 80, 0}, this.tableExame);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.buttonOKTela.setMnemonic('O');
        this.panelBotoes.add(this.buttonOKTela);
        this.panelCentro.add((Component)this.scrollExame, "Center");
        this.tableExame.grabFocus();
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AutorizacaoExame.this.modeloExame.getRowCount() > 0) {
                    AutorizacaoExame.this.tableExame.setRowSelectionInterval(0, 0);
                    AutorizacaoExame.this.tableExame.grabFocus();
                }
            }
        });
        this.buttonOKTela.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutorizacaoExame.this.tableExame.getSelectedRow() > -1) {
                    AutorizacaoExame.this.codigoAutorizacaoRetorno = (String)AutorizacaoExame.this.modeloExame.getValueAt(AutorizacaoExame.this.tableExame.getSelectedRow(), 3);
                    AutorizacaoExame.this.setVisible(false);
                } else {
                    Funcoes.mensagem(AutorizacaoExame.this, "Uma autoriza\u00e7\u00e3o deve ser selecionada.", 2);
                }
            }
        });
    }

    public void jbInit() throws Exception {
        this.setSize(750, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.buttonData.setFocusable(false);
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonData);
        this.buttonValidade.setFocusable(false);
        this.buttonValidade.setPreferredSize(new Dimension(20, 20));
        this.buttonValidade.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonValidade);
        this.tableExame.setModel(this.modeloExame);
        this.modeloExame.setColumnSize(new int[]{60, 60, 0, 0, 80, 80}, this.tableExame);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelTopo, "North");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentro.add((Component)this.scrollExame, "Center");
        this.labelCodExame.setPreferredSize(new Dimension(110, 20));
        this.labelCodExame.setMinimumSize(new Dimension(110, 20));
        this.labelCodMaterial.setPreferredSize(new Dimension(110, 20));
        this.labelCodMaterial.setMinimumSize(new Dimension(110, 20));
        this.txtData.setPreferredSize(new Dimension(90, 20));
        this.txtData.setMinimumSize(new Dimension(90, 20));
        this.txtValidade.setPreferredSize(new Dimension(90, 20));
        this.txtValidade.setMinimumSize(new Dimension(90, 20));
        this.txtAutorizacao.setPreferredSize(new Dimension(20, 20));
        this.txtAutorizacao.setMinimumSize(new Dimension(20, 20));
        this.labelDescExame.setPreferredSize(new Dimension(20, 20));
        this.labelDescExame.setMinimumSize(new Dimension(20, 20));
        this.buttonOKAutorizacao.setMnemonic('O');
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelTopo.add((Component)this.labelExame, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelTopo.add((Component)this.labelCodExame, c);
        c.gridwidth = 4;
        c.gridx += 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelTopo.add((Component)this.labelDescExame, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.panelTopo.add((Component)this.labelMaterial, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelTopo.add((Component)this.labelCodMaterial, c);
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 0);
        c.gridwidth = 1;
        this.panelTopo.add((Component)this.labelAutorizacao, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.insets = new Insets(1, 0, 1, 0);
        c.fill = 2;
        this.panelTopo.add((Component)this.txtAutorizacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.panelTopo.add((Component)this.labelData, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.txtData, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.buttonData, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.panelTopo.add((Component)this.labelValidade, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        this.panelTopo.add((Component)this.txtValidade, c);
        ++c.gridx;
        this.panelTopo.add((Component)this.buttonValidade, c);
        ++c.gridx;
        c.anchor = 13;
        this.panelTopo.add((Component)this.buttonOKAutorizacao, c);
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.tableExame.setToolTipText("Barra de espa\u00e7os / duplo clique para editar");
        this.tableExame.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    if (value instanceof Date) {
                        this.setValue(Funcoes.formataData("dd/MM/yyyy", (Date)value));
                    } else {
                        this.setValue(value.toString());
                    }
                }
                return this;
            }
        });
        this.tableExame.grabFocus();
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        ScreenUtil.setBorda(new Component[]{this.labelCodExame, this.labelCodMaterial, this.labelDescExame}, new TitledBorder(""));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AutorizacaoExame.this.modeloExame.getRowCount() > 0) {
                    if (Funcoes.textoVazio(AutorizacaoExame.this.codigoExameSelecionado)) {
                        AutorizacaoExame.this.tableExame.setRowSelectionInterval(0, 0);
                        AutorizacaoExame.this.tableExame.grabFocus();
                    } else {
                        int linha = -1;
                        for (int i = 0; i < AutorizacaoExame.this.modeloExame.getRowCount(); ++i) {
                            String codigo = AutorizacaoExame.this.modeloExame.getValueAt(i, 0).toString();
                            DadosMaterial material = (DadosMaterial)AutorizacaoExame.this.modeloExame.getValueAt(i, 1);
                            if (!codigo.equalsIgnoreCase(AutorizacaoExame.this.codigoExameSelecionado) || !Funcoes.isNumeric(AutorizacaoExame.this.materialExameSelecionado) || Integer.parseInt(AutorizacaoExame.this.materialExameSelecionado) != material.getCodigo()) continue;
                            linha = i;
                            AutorizacaoExame.this.tableExame.setRowSelectionInterval(linha, linha);
                            AutorizacaoExame.this.alteraLinha(linha);
                            break;
                        }
                        if (linha == -1) {
                            AutorizacaoExame.this.tableExame.setRowSelectionInterval(0, 0);
                            AutorizacaoExame.this.tableExame.grabFocus();
                        }
                    }
                }
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutorizacaoExame.this.limparCampos();
                AutorizacaoExame.this.isOK = false;
                AutorizacaoExame.this.setVisible(false);
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(AutorizacaoExame.this.todosPreenchidos() || AutorizacaoExame.this.sairSemPreencher || AutorizacaoExame.this.isConferenciaGuia)) {
                    Funcoes.mensagem(AutorizacaoExame.this, "Alguns exames est\u00e3o sem o c\u00f3digo de autoriza\u00e7\u00e3o, \n\u00e9 necess\u00e1rio informar para Salvar.\nSolicite a senha de libera\u00e7\u00e3o ao administrador.", 1);
                    Senha senha = new Senha();
                    senha.setLocationRelativeTo(AutorizacaoExame.this);
                    senha.setVisible(true);
                    int pressionado = senha.getRetorno();
                    Statement st = Conexao.getStatement();
                    while (pressionado == 1) {
                        try {
                            boolean acesso = Acesso.getAcesso(AutorizacaoExame.this.acessoSairSemPreencher);
                            if (acesso) break;
                            Funcoes.mensagem(AutorizacaoExame.this, "Senha incorreta ou n\u00e3o permitida.\nTente novamente.", 1);
                            senha.setVisible(true);
                            pressionado = senha.getRetorno();
                        }
                        catch (Exception ex) {
                            pressionado = 2;
                            ErrorLogger.mostraMensagem(AutorizacaoExame.this, ex.getMessage(), ex.getStackTrace(), "AutorizacaoExame (171)");
                        }
                    }
                    Conexao.fecharStatement(st);
                    if (pressionado == 2) {
                        AutorizacaoExame.this.tableExame.grabFocus();
                    } else {
                        AutorizacaoExame.this.isOK = true;
                        AutorizacaoExame.this.setVisible(false);
                    }
                } else {
                    AutorizacaoExame.this.isOK = true;
                    AutorizacaoExame.this.setVisible(false);
                }
            }
        });
        this.tableExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    AutorizacaoExame.this.alteraLinha(AutorizacaoExame.this.tableExame.getSelectedRow());
                }
            }
        });
        this.tableExame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AutorizacaoExame.this.alteraLinha(AutorizacaoExame.this.tableExame.getSelectedRow());
                }
            }
        });
        this.buttonOKAutorizacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutorizacaoExame.this.isLinhaAlterada()) {
                    AutorizacaoExame.this.modeloExame.setValueAt(AutorizacaoExame.this.txtAutorizacao.getText(), AutorizacaoExame.this.linhaAlterada, 3);
                    AutorizacaoExame.this.modeloExame.setValueAt(Funcoes.textoVazio(AutorizacaoExame.this.txtData) ? null : Funcoes.getData("dd/MM/yyyy", AutorizacaoExame.this.txtData.getText()), AutorizacaoExame.this.linhaAlterada, 4);
                    AutorizacaoExame.this.modeloExame.setValueAt(Funcoes.textoVazio(AutorizacaoExame.this.txtValidade) ? null : Funcoes.getData("dd/MM/yyyy", AutorizacaoExame.this.txtValidade.getText()), AutorizacaoExame.this.linhaAlterada, 5);
                    AutorizacaoExame.this.preencheDadosAgrupamento();
                }
                if (AutorizacaoExame.this.modeloExame.getRowCount() > 1 && AutorizacaoExame.this.isLinhaAlterada() && AutorizacaoExame.this.alterarTodosExames()) {
                    AutorizacaoExame.this.preencheDadosExames();
                }
                AutorizacaoExame.this.limpaDadosExames();
            }
        });
        this.buttonData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(AutorizacaoExame.this.txtData, AutorizacaoExame.this.buttonData, AutorizacaoExame.this.panelTopo, true);
            }
        });
        this.buttonValidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(AutorizacaoExame.this.txtValidade, AutorizacaoExame.this.buttonValidade, AutorizacaoExame.this.panelTopo, true);
            }
        });
        this.txtData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AutorizacaoExame.this.buttonData.doClick();
                }
            }
        });
        this.txtValidade.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AutorizacaoExame.this.buttonValidade.doClick();
                }
            }
        });
    }

    private void alteraLinha(int linha) {
        if (linha <= -1) {
            return;
        }
        this.linhaAlterada = linha;
        this.labelCodExame.setText(this.modeloExame.getValueAt(this.linhaAlterada, 0).toString());
        this.labelCodMaterial.setText(this.modeloExame.getValueAt(this.linhaAlterada, 1).toString());
        this.labelDescExame.setText(this.modeloExame.getValueAt(this.linhaAlterada, 2).toString());
        this.txtAutorizacao.setText(this.modeloExame.getValueAt(this.linhaAlterada, 3).toString());
        this.txtData.setText(this.modeloExame.getValueAt(this.linhaAlterada, 4) != null ? Funcoes.formataData("dd/MM/yyyy", (Date)this.modeloExame.getValueAt(this.linhaAlterada, 4)) : "");
        this.txtValidade.setText(this.modeloExame.getValueAt(this.linhaAlterada, 5) != null ? Funcoes.formataData("dd/MM/yyyy", (Date)this.modeloExame.getValueAt(this.linhaAlterada, 5)) : "");
        this.txtAutorizacao.grabFocus();
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void limpaDadosExames() {
        this.linhaAlterada = -1;
        this.labelCodExame.setText("");
        this.labelCodMaterial.setText("");
        this.labelDescExame.setText("");
        this.txtAutorizacao.clear();
        this.txtData.clear();
        this.txtValidade.clear();
        this.tableExame.grabFocus();
    }

    private boolean alterarTodosExames() {
        return Funcoes.mensagem(this, "Deseja aplicar o c\u00f3digo de autoriza\u00e7\u00e3o para os exames que ainda n\u00e3o foram autorizados?", 4) == 0;
    }

    private boolean isLinhaAlterada() {
        return this.linhaAlterada > -1;
    }

    private void preencheDadosExames() {
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (Funcoes.textoVazio(this.modeloExame.getValueAt(i, 3).toString())) {
                this.modeloExame.setValueAt(this.txtAutorizacao.getText(), i, 3);
            }
            if (this.modeloExame.getValueAt(i, 4) == null || Funcoes.textoVazio(this.modeloExame.getValueAt(i, 4).toString())) {
                this.modeloExame.setValueAt(Funcoes.textoVazio(this.txtData) ? null : Funcoes.getData("dd/MM/yyyy", this.txtData.getText()), i, 4);
            }
            if (this.modeloExame.getValueAt(i, 5) != null && !Funcoes.textoVazio(this.modeloExame.getValueAt(i, 5).toString())) continue;
            this.modeloExame.setValueAt(Funcoes.textoVazio(this.txtValidade) ? null : Funcoes.getData("dd/MM/yyyy", this.txtValidade.getText()), i, 5);
        }
    }

    private void preencheDadosAgrupamento() {
        String exameSelecionado = this.modeloExame.getValueAt(this.linhaAlterada, 6).toString();
        String materialSelecionado = this.modeloExame.getValueAt(this.linhaAlterada, 1).toString();
        if (this.contemExamePai(exameSelecionado)) {
            for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                String examePai = this.modeloExame.getValueAt(i, 6).toString();
                String matPai = this.modeloExame.getValueAt(i, 1).toString();
                if (!exameSelecionado.equalsIgnoreCase(examePai) || !materialSelecionado.equalsIgnoreCase(matPai)) continue;
                this.modeloExame.setValueAt(this.txtAutorizacao.getText(), i, 3);
                this.modeloExame.setValueAt(Funcoes.textoVazio(this.txtData) ? null : Funcoes.getData("dd/MM/yyyy", this.txtData.getText()), i, 4);
                this.modeloExame.setValueAt(Funcoes.textoVazio(this.txtValidade) ? null : Funcoes.getData("dd/MM/yyyy", this.txtValidade.getText()), i, 5);
            }
        }
    }

    private boolean contemExamePai(String codigoExamePai) {
        return !Funcoes.textoVazio(codigoExamePai);
    }

    public void adicionarExames(String codigo, DadosMaterial material, String descricao, String autorizacao, Date data, Date validade, String examePai) {
        this.modeloExame.addLine(new Object[]{codigo, material, descricao, autorizacao, data, validade, examePai});
    }

    public void limpaExames() {
        this.modeloExame.clear();
    }

    private void limparCampos() {
        this.labelCodExame.setText("");
        this.labelCodMaterial.setText("");
        this.labelDescExame.setText("");
        this.txtAutorizacao.clear();
        this.txtData.clear();
        this.txtValidade.clear();
        this.limpaExames();
    }

    public int getCountExames() {
        return this.modeloExame.getRowCount();
    }

    public String getCodigoExame(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return this.modeloExame.getValueAt(linha, 0).toString();
        }
        return "";
    }

    public DadosMaterial getCodigoMaterial(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return (DadosMaterial)this.modeloExame.getValueAt(linha, 1);
        }
        return null;
    }

    public String getAutorizacao(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return this.modeloExame.getValueAt(linha, 3).toString();
        }
        return "";
    }

    public Date getData(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return (Date)this.modeloExame.getValueAt(linha, 4);
        }
        return null;
    }

    public Date getValidade(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return (Date)this.modeloExame.getValueAt(linha, 5);
        }
        return null;
    }

    private boolean achaDuplicado(String codigo, DadosMaterial material) {
        boolean retorno = false;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!this.modeloExame.getValueAt(i, 0).toString().equals(codigo) || !this.modeloExame.getValueAt(i, 1).equals(material)) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    private boolean todosPreenchidos() {
        boolean retorno = true;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (this.modeloExame.getValueAt(i, 3) != null && !Funcoes.textoVazio(this.modeloExame.getValueAt(i, 3).toString())) continue;
            return false;
        }
        return retorno;
    }

    public void setAcessoSairSemPreencher(long acesso) {
        this.acessoSairSemPreencher = acesso;
        this.sairSemPreencher = Acesso.getAcesso(acesso);
    }

    public void setExameSelecionado(String codigoExameSelecionado, String materialExameSelecionado) {
        this.codigoExameSelecionado = codigoExameSelecionado;
        this.materialExameSelecionado = materialExameSelecionado;
    }
}

