/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.TaxaBean;
import jalis.model.bean.recepcao.OrcamentoTaxaBean;
import jalis.model.vo.cadastro.TaxaVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.OrcamentoTaxaVO;
import jalis.service.cadastro.ExameMaterialColetaTaxaService;
import jalis.service.cadastro.TaxaColetaService;
import jalis.service.cadastro.TaxaConvenioService;
import jalis.service.cadastro.TaxaDestinoService;
import jalis.service.cadastro.TaxaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class AdicionarTaxa
extends AbstractDialogoOKCancelar {
    private JPanel panelTaxas = new JPanel(new GridBagLayout());
    private JLabel jLabelCodTaxa = new JLabel("C\u00f3digo");
    private JLabel jLabelDescTaxa = new JLabel();
    private JLabel jLabelValorTaxa = new JLabel("Valor");
    private JLabel jLabelValorDescTaxa = new JLabel();
    private TTextField textFieldCodTaxa = new TTextField(9, 1);
    private JButton buttonPesqTaxa = ComponenteFactory.novoJButton(this, true);
    private JLabel jLabelVlrDescTaxa = new JLabel();
    private JButton buttonAddTaxa = ComponenteFactory.novoJButton("OK", 'O', this);
    private JTable tableTaxa = null;
    private JScrollPane scroll = null;
    private TaxaVO taxaVO = new TaxaVO();
    private TaxaBean taxaBean = new TaxaBean();
    private TaxaService serviceTaxa = new TaxaService();
    private ExameMaterialColetaTaxaService exameMaterialColetaTaxaService = new ExameMaterialColetaTaxaService();
    private TaxaDestinoService serviceTaxaDestino = new TaxaDestinoService();
    private TaxaColetaService serviceTaxaColeta = new TaxaColetaService();
    private TaxaConvenioService taxaConvenioService = new TaxaConvenioService();
    private final int COLUNA_CODIGO_TAXA = 0;
    private final int COLUNA_DESCRICAO_TAXA = 1;
    private final int COLUNA_VALOR_TAXA = 2;
    private final int COLUNA_TAXA_VO = 3;
    private ModeloGridTable modeloTaxa = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Valor"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class[] valores = new Class[]{Integer.class, String.class, String.class};
            return valores[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            boolean[] valores = new boolean[]{false, false, false};
            return valores[columnIndex];
        }
    };

    public AdicionarTaxa(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public AdicionarTaxa(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public static AdicionarTaxa novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new AdicionarTaxa((Dialog)pai, "Adicionar taxa");
        }
        if (pai instanceof Frame) {
            return new AdicionarTaxa((Frame)pai, "Adicionar taxa");
        }
        return null;
    }

    private void montaTela() {
        this.setSize(400, 300);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.panelTaxas, "Center");
        GridBagConstraints layoutTaxa = new GridBagConstraints();
        layoutTaxa.fill = 13;
        layoutTaxa.anchor = 17;
        layoutTaxa.gridx = 0;
        layoutTaxa.gridy = 0;
        layoutTaxa.weightx = 0.0;
        layoutTaxa.weighty = 0.0;
        layoutTaxa.insets = new Insets(1, 0, 0, 1);
        this.panelTaxas.add((Component)this.jLabelCodTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        ++layoutTaxa.gridx;
        this.panelTaxas.add((Component)this.jLabelDescTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.panelTaxas.add((Component)this.jLabelValorTaxa, layoutTaxa);
        layoutTaxa.gridx = 0;
        ++layoutTaxa.gridy;
        layoutTaxa.insets = new Insets(1, 0, 0, 0);
        this.textFieldCodTaxa.setPreferredSize(new Dimension(80, 20));
        this.textFieldCodTaxa.setMinimumSize(new Dimension(80, 20));
        this.panelTaxas.add((Component)this.textFieldCodTaxa, layoutTaxa);
        layoutTaxa.insets = new Insets(1, 0, 0, 1);
        ++layoutTaxa.gridx;
        this.buttonPesqTaxa.setPreferredSize(new Dimension(20, 20));
        this.buttonPesqTaxa.setMinimumSize(new Dimension(20, 20));
        this.panelTaxas.add((Component)this.buttonPesqTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.jLabelVlrDescTaxa.setPreferredSize(new Dimension(20, 20));
        this.jLabelVlrDescTaxa.setMinimumSize(new Dimension(20, 20));
        this.jLabelVlrDescTaxa.setBorder(new TitledBorder(""));
        layoutTaxa.weightx = 1.0;
        layoutTaxa.fill = 2;
        this.panelTaxas.add((Component)this.jLabelVlrDescTaxa, layoutTaxa);
        layoutTaxa.weightx = 0.0;
        layoutTaxa.fill = 13;
        ++layoutTaxa.gridx;
        this.jLabelValorDescTaxa.setPreferredSize(new Dimension(100, 20));
        this.jLabelValorDescTaxa.setMinimumSize(new Dimension(100, 20));
        this.jLabelValorDescTaxa.setBorder(new TitledBorder(""));
        this.panelTaxas.add((Component)this.jLabelValorDescTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.buttonAddTaxa.setPreferredSize(new Dimension(40, 20));
        this.buttonAddTaxa.setMinimumSize(new Dimension(40, 20));
        this.panelTaxas.add((Component)this.buttonAddTaxa, layoutTaxa);
        this.modeloTaxa = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Valor"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{Integer.class, String.class, String.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean[] valores = new boolean[]{false, false, false};
                return valores[columnIndex];
            }
        };
        this.tableTaxa = new JTable(this.modeloTaxa);
        this.modeloTaxa.setColumnSize(new int[]{72, 0, 100}, this.tableTaxa);
        this.scroll = new JScrollPane(this.tableTaxa);
        this.scroll.setPreferredSize(new Dimension(100, 100));
        this.scroll.setMinimumSize(new Dimension(100, 100));
        layoutTaxa.weightx = 1.0;
        layoutTaxa.weighty = 1.0;
        ++layoutTaxa.gridy;
        layoutTaxa.gridx = 0;
        layoutTaxa.gridwidth = 5;
        layoutTaxa.fill = 1;
        this.panelTaxas.add((Component)this.scroll, layoutTaxa);
        this.textFieldCodTaxa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AdicionarTaxa.this.buttonPesqTaxa.doClick();
                }
            }
        });
        this.tableTaxa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && Funcoes.mensagem(AdicionarTaxa.this, "Deseja remover a taxa?", 4) == 0) {
                    AdicionarTaxa.this.modeloTaxa.removeLine(row);
                }
            }
        });
        this.buttonPesqTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdicionarTaxa.this.pesquisarTaxa();
            }
        });
        this.buttonAddTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = -1;
                pos = AdicionarTaxa.this.isTaxaAdicionada(AdicionarTaxa.this.taxaVO);
                if (pos > -1) {
                    AdicionarTaxa.this.jLabelVlrDescTaxa.setText("");
                    AdicionarTaxa.this.textFieldCodTaxa.clear();
                    AdicionarTaxa.this.jLabelValorDescTaxa.setText("");
                    AdicionarTaxa.this.tableTaxa.setRowSelectionInterval(pos, pos);
                    AdicionarTaxa.this.tableTaxa.scrollRectToVisible(AdicionarTaxa.this.tableTaxa.getCellRect(pos, pos, true));
                    ScreenUtil.requisitarFoco(AdicionarTaxa.this.textFieldCodTaxa);
                    return;
                }
                AdicionarTaxa.this.adicionarTaxa(AdicionarTaxa.this.textFieldCodTaxa.getText(), AdicionarTaxa.this.jLabelVlrDescTaxa.getText(), AdicionarTaxa.this.jLabelValorDescTaxa.getText());
            }
        });
        this.textFieldCodTaxa.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AdicionarTaxa.this.jLabelVlrDescTaxa.setText("");
                    AdicionarTaxa.this.jLabelValorDescTaxa.setText("");
                    if (!Funcoes.textoVazio(AdicionarTaxa.this.textFieldCodTaxa.getText())) {
                        AdicionarTaxa.this.taxaVO = (TaxaVO)AdicionarTaxa.this.serviceTaxa.getVO(Variaveis.filialPadrao, AdicionarTaxa.this.textFieldCodTaxa.getText());
                        if (AdicionarTaxa.this.taxaVO != null) {
                            AdicionarTaxa.this.textFieldCodTaxa.setText(AdicionarTaxa.this.taxaVO.getCodigo().toString());
                            AdicionarTaxa.this.jLabelVlrDescTaxa.setText(AdicionarTaxa.this.taxaVO.getDescricao());
                            AdicionarTaxa.this.jLabelValorDescTaxa.setText(Funcoes.formataDecimal(AdicionarTaxa.this.taxaVO.getValor()));
                            ScreenUtil.requisitarFoco(AdicionarTaxa.this.buttonAddTaxa);
                        } else {
                            AdicionarTaxa.this.jLabelVlrDescTaxa.setText("N\u00e3o cadastrado");
                            AdicionarTaxa.this.textFieldCodTaxa.selectAll();
                            ScreenUtil.requisitarFoco(AdicionarTaxa.this.textFieldCodTaxa);
                        }
                    } else {
                        AdicionarTaxa.this.jLabelVlrDescTaxa.setText("");
                        AdicionarTaxa.this.textFieldCodTaxa.setText("");
                        AdicionarTaxa.this.jLabelValorDescTaxa.setText("");
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AdicionarTaxa.this, "N\u00e3o foi poss\u00edvel consultar taxa.", 1);
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
    }

    private void pesquisarTaxa() {
        TaxaVO taxaVO = (TaxaVO)this.serviceTaxa.pesquisaVO(this, new TaxaVO(), "Pesquisando taxas", true);
        if (taxaVO != null) {
            this.textFieldCodTaxa.setText(taxaVO.getCodigo().toString());
            this.jLabelVlrDescTaxa.setText(taxaVO.getDescricao());
            this.jLabelValorDescTaxa.setText(Funcoes.formataDecimal(taxaVO.getValor()));
            ScreenUtil.requisitarFoco(this.buttonAddTaxa);
        } else {
            this.textFieldCodTaxa.selectAll();
            this.jLabelVlrDescTaxa.setText("N\u00e3o cadastrado");
            ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
        }
    }

    private int isTaxaAdicionada(TaxaVO taxa) {
        for (int i = 0; i < this.modeloTaxa.getRowCount(); ++i) {
            OrcamentoTaxaVO tVO = (OrcamentoTaxaVO)this.modeloTaxa.getValueAt(i, 3);
            if (tVO == null || taxa == null || taxa.getCodigo() == null || !tVO.getTaxa().getCodigo().equals(taxa.getCodigo())) continue;
            return i;
        }
        return -1;
    }

    private void adicionarTaxa(String codigoTaxa, String descricaoTaxa, String valorTaxa) {
        if (!Funcoes.textoVazio(codigoTaxa) && !descricaoTaxa.equals("N\u00e3o cadastrado")) {
            FilialVO fVO = new FilialVO();
            fVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            TaxaVO vo = new TaxaVO();
            vo.setCodigo(Integer.parseInt(codigoTaxa));
            vo.setDescricao(descricaoTaxa);
            vo.setValor(Double.parseDouble(Funcoes.limpaDecimal(valorTaxa)));
            OrcamentoTaxaVO oVO = new OrcamentoTaxaVO();
            oVO.setFilial(fVO);
            oVO.setTaxa(vo);
            oVO.setValor(Double.parseDouble(Funcoes.limpaDecimal(valorTaxa)));
            oVO.setQuantidade(1.0);
            this.modeloTaxa.addLine(new Object[]{oVO.getTaxa().getCodigo(), oVO.getTaxa().getDescricao(), Funcoes.formataDecimal(oVO.getValor()), oVO});
        }
        this.jLabelVlrDescTaxa.setText("");
        this.jLabelValorDescTaxa.setText("");
        this.textFieldCodTaxa.clear();
        ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
    }

    public void setTaxas(ArrayList<OrcamentoTaxaBean> taxas) {
        this.modeloTaxa.clear();
        if (null != taxas && !taxas.isEmpty()) {
            for (OrcamentoTaxaBean b : taxas) {
                OrcamentoTaxaVO vo = new OrcamentoTaxaVO();
                vo.setFilial(b.getFilial());
                vo.setTaxa(b.getTaxa());
                vo.setValor(b.getValor());
                vo.setQuantidade(b.getQuantidade());
                if (b.getOrcamento() != null) {
                    vo.setOrcamento(b.getOrcamento());
                }
                this.modeloTaxa.addLine(new Object[]{vo.getTaxa().getCodigo(), vo.getTaxa().getDescricao(), Funcoes.formataDecimal(vo.getValor()), vo});
            }
        }
    }

    public ArrayList<OrcamentoTaxaBean> getTaxas() {
        ArrayList<OrcamentoTaxaBean> taxas = new ArrayList<OrcamentoTaxaBean>();
        for (int i = 0; i < this.modeloTaxa.getRowCount(); ++i) {
            OrcamentoTaxaVO vo = (OrcamentoTaxaVO)this.modeloTaxa.getValueAt(i, 3);
            OrcamentoTaxaBean taxaVO = new OrcamentoTaxaBean();
            taxaVO.setTaxa(vo.getTaxa());
            taxaVO.setFilial(vo.getFilial());
            taxaVO.setValor(vo.getValor());
            taxaVO.setQuantidade(vo.getQuantidade());
            taxas.add(taxaVO);
        }
        return taxas;
    }
}

