/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.model.bean.recepcao.RequisicaoLogBean;
import jalis.util.Funcoes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class AbrirRequisicao
extends JDialog
implements DisposeListener,
WindowListener {
    public Requisicao requisicao;
    public ArrayList<Requisicao> multiguias = null;
    private boolean isNovaRequisicao = false;
    private String situacaoAgendamento = "";
    private JTabbedPane tabbedPane = null;
    private GlassPaneMensagem glassPaneMensagem;

    public AbrirRequisicao(Frame owner, GlassPaneMensagem glassPaneMensagem, boolean isHistoricoRequisicao) {
        super(owner);
        this.addWindowListener(this);
        this.glassPaneMensagem = glassPaneMensagem;
        this.setGlassPane(glassPaneMensagem);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.requisicao = new Requisicao(Variaveis.tipoFilialPadrao, isHistoricoRequisicao);
        this.addWindowListener(this);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(1024, 600);
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.requisicao.setFecharAoSalvar(true);
        this.requisicao.defineAcessos();
    }

    public AbrirRequisicao(Frame owner, boolean isNovaRequisicao, String situacaoAgendamento, Date dataAgendamento) {
        super(owner);
        this.isNovaRequisicao = isNovaRequisicao;
        this.situacaoAgendamento = situacaoAgendamento;
        this.requisicao = new Requisicao(Variaveis.tipoFilialPadrao, true, dataAgendamento);
        this.addWindowListener(this);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(760, 600);
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.requisicao.setFecharAoSalvar(true);
        this.requisicao.defineAcessos();
        if (!Funcoes.textoVazio(situacaoAgendamento)) {
            this.requisicao.setRequisicaoAgendamento(true, situacaoAgendamento);
        }
    }

    public AbrirRequisicao(Frame owner, GlassPaneMensagem glassPaneMensagem, boolean isNovaRequisicao, String situacaoAgendamento, Date dataAgendamento) {
        super(owner);
        this.isNovaRequisicao = isNovaRequisicao;
        this.situacaoAgendamento = situacaoAgendamento;
        this.addWindowListener(this);
        this.glassPaneMensagem = glassPaneMensagem;
        this.setGlassPane(glassPaneMensagem);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.requisicao = new Requisicao(Variaveis.tipoFilialPadrao, true, dataAgendamento);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(876, 730);
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.requisicao.setFecharAoSalvar(true);
        this.requisicao.defineAcessos();
        if (!Funcoes.textoVazio(situacaoAgendamento)) {
            this.requisicao.setRequisicaoAgendamento(true, situacaoAgendamento);
        }
    }

    public void setXml(RequisicaoLogBean bean) {
        this.requisicao.carregarHistoricoRequisicao(bean);
        this.setTitle("Hist\u00f3rico de altera\u00e7\u00e3o - Requisi\u00e7\u00e3o: " + bean.getRequisicao() + "s" + bean.getNrSuplemento() + " - " + Funcoes.formataData("dd/MM/yyyy HH:mm", bean.getDataHora()));
        this.getContentPane().add((Component)this.requisicao, "Center");
    }

    public String getCodigoRequisicao() {
        if (this.requisicao != null) {
            return this.requisicao.getRetornoParaPesquisa();
        }
        return null;
    }

    public void setRequisicao(String filial, String codigoRequisicao, Integer[] codigosMultiguias) {
        if (this.requisicao != null) {
            if (filial != null && codigoRequisicao != null) {
                this.requisicao.buscaDadosRequisicao(filial, codigoRequisicao, true);
            }
            if (codigosMultiguias == null || codigosMultiguias.length == 0) {
                this.setTitle("Editando requisi\u00e7\u00e3o");
                this.getContentPane().add((Component)this.requisicao, "Center");
            } else {
                this.setTitle("Editando requisi\u00e7\u00f5es");
                this.tabbedPane = new JTabbedPane(2);
                this.tabbedPane.setTabLayoutPolicy(1);
                this.tabbedPane.putClientProperty("JTabbedPane.tabAlignment", 10);
                this.tabbedPane.putClientProperty("JTabbedPane.tabRotation", "left");
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)this.requisicao, "Center");
                this.tabbedPane.addTab(codigoRequisicao, panel);
            }
        }
        if (codigosMultiguias != null && codigosMultiguias.length > 0) {
            this.multiguias = new ArrayList();
            for (int i = 0; i < codigosMultiguias.length; ++i) {
                Requisicao aux = new Requisicao(Variaveis.tipoFilialPadrao);
                aux.defineAcessos();
                aux.setFecharAoSalvar(true);
                aux.setRequisicaoAgendamento(true, this.situacaoAgendamento);
                aux.buscaDadosRequisicao(filial, codigosMultiguias[i].toString(), true, false, false);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)aux, "Center");
                this.tabbedPane.addTab(codigosMultiguias[i].toString(), panel);
                this.multiguias.add(aux);
            }
            this.getContentPane().add((Component)this.tabbedPane, "Center");
        }
    }

    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    public void novaRequisicao() {
        if (this.requisicao != null) {
            this.setTitle("Criando requisi\u00e7\u00e3o");
            this.getContentPane().add((Component)this.requisicao, "Center");
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.requisicao != null && this.isNovaRequisicao) {
            this.requisicao.novo();
        }
    }

    @Override
    @Deprecated
    public void windowClosing(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowClosed(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowIconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowActivated(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeactivated(WindowEvent e) {
    }
}

