/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class UsuarioNotificado
extends AbstractDialogoOKCancelar {
    private static final boolean REGISTRO_NOVO = true;
    private static final int POSICAO_REGISTRO_NOVO = 3;
    private static final int POSICAO_SETOR_USUARIO = 4;
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelVlrUsuario = new JLabel("");
    private TTextField textCodUser = ComponenteFactory.novoTTextField(20, 3, this);
    private JButton buttonPesquisaUsuario = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddUsuario = ComponenteFactory.novoJButton("OK", this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Usu\u00e1rio", "Notifica\u00e7\u00e3o", "Leitura"});
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scrollPane = new JScrollPane(this.tabela);
    private UsuarioService usuarioService = new UsuarioService();
    private UsuarioVO notificado = null;
    private static JLabel notificados = null;
    private List<SetorNaoConformidadeUsuarioBean> setorNaoConformidadeUsuarioBeansTemp = new ArrayList<SetorNaoConformidadeUsuarioBean>();

    public static UsuarioNotificado novaInstancia(Object owner, JLabel notificadosDesc) {
        notificados = notificadosDesc;
        return new UsuarioNotificado((Frame)owner);
    }

    public UsuarioNotificado(Frame owner) {
        super(owner, "Usu\u00e1rios notificados");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(500, 300));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ScreenUtil.requisitarFoco(UsuarioNotificado.this.textCodUser);
                super.windowActivated(e);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenUtil.requisitarFoco(UsuarioNotificado.this.textCodUser);
            }
        });
        this.setModal(true);
        this.modelo.setColumnSize(new int[]{0, 150, 120}, this.tabela);
        this.buttonAddUsuario.setMnemonic('K');
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrUsuario}, new TitledBorder(""));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 1, 0, 0);
        p.add((Component)this.labelUsuario, constraints);
        ++constraints.gridx;
        this.textCodUser.setPreferredSize(new Dimension(80, 20));
        this.textCodUser.setMinimumSize(new Dimension(80, 20));
        p.add((Component)this.textCodUser, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.buttonPesquisaUsuario.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisaUsuario.setMinimumSize(new Dimension(20, 20));
        p.add((Component)this.buttonPesquisaUsuario, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 1, 0, 0);
        this.labelVlrUsuario.setPreferredSize(new Dimension(20, 20));
        this.labelVlrUsuario.setMinimumSize(new Dimension(20, 20));
        constraints.fill = 2;
        constraints.weightx = 1.0;
        p.add((Component)this.labelVlrUsuario, constraints);
        constraints.fill = 17;
        constraints.weightx = 0.0;
        this.buttonAddUsuario.setPreferredSize(new Dimension(40, 20));
        this.buttonAddUsuario.setMinimumSize(new Dimension(40, 20));
        ++constraints.gridx;
        p.add((Component)this.buttonAddUsuario, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.gridwidth = 5;
        constraints.fill = 1;
        this.scrollPane.setPreferredSize(new Dimension(50, 50));
        this.scrollPane.setMinimumSize(new Dimension(50, 50));
        p.add((Component)this.scrollPane, constraints);
        this.textCodUser.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(UsuarioNotificado.this.textCodUser.getText())) {
                        Set s = UsuarioNotificado.this.usuarioService.loadVO(" where upper(usr_codigo) = upper('" + UsuarioNotificado.this.textCodUser.getText() + "')");
                        if (s != null && s.size() == 1 && (UsuarioNotificado.this.notificado = (UsuarioVO)s.toArray()[0]) != null) {
                            UsuarioNotificado.this.textCodUser.setText(UsuarioNotificado.this.notificado.getCodigo().toString());
                            UsuarioNotificado.this.labelVlrUsuario.setText(UsuarioNotificado.this.notificado.getNome());
                        } else {
                            UsuarioNotificado.this.labelVlrUsuario.setText("N\u00e3o cadastrado");
                            UsuarioNotificado.this.textCodUser.selectAll();
                        }
                    } else {
                        UsuarioNotificado.this.labelVlrUsuario.setText("");
                        UsuarioNotificado.this.textCodUser.setText("");
                        UsuarioNotificado.this.textCodUser.selectAll();
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel consultar o usu\u00e1rio", 1);
                }
            }
        });
        this.textCodUser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    UsuarioNotificado.this.pesquisaUsuario();
                }
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && UsuarioNotificado.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(UsuarioNotificado.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    UsuarioNotificado.this.modelo.removeLine(UsuarioNotificado.this.tabela.getSelectedRow());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonCancelar)) {
            int qtd;
            for (int i = qtd = this.modelo.getRowCount() - 1; i >= 0; --i) {
                Boolean novo = (Boolean)this.modelo.getValueAt(i, 3);
                if (!novo.booleanValue()) continue;
                this.modelo.removeLine(i);
            }
            this.labelVlrUsuario.setText("");
            this.textCodUser.setText("");
            this.notificado = null;
            this.setSetorNaoConformidadeUsuarioBeansTemp(this.getSetoresUsuarioNcf());
            this.dispose();
        } else if (e.getSource().equals(this.buttonOK)) {
            StringBuilder usuarioNotificados = new StringBuilder();
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                usuarioNotificados.append((String)this.modelo.getValueAt(i, 0));
                usuarioNotificados.append(", ");
                this.modelo.setValueAt(false, i, 3);
            }
            this.labelVlrUsuario.setText("");
            this.textCodUser.setText("");
            this.notificado = null;
            if (usuarioNotificados.length() > 0) {
                notificados.setText(usuarioNotificados.substring(0, usuarioNotificados.length() - 2));
            }
            this.dispose();
        } else if (e.getSource().equals(this.buttonPesquisaUsuario)) {
            this.pesquisaUsuario();
        } else if (e.getSource().equals(this.buttonAddUsuario)) {
            boolean userEstaAdicionado = false;
            if (this.notificado == null) {
                ScreenUtil.requisitarFoco(this.textCodUser);
                return;
            }
            SetorNaoConformidadeUsuarioBean conformidadeUsuarioBean = new SetorNaoConformidadeUsuarioBean();
            conformidadeUsuarioBean.setUsuarioVO(this.notificado);
            conformidadeUsuarioBean.setDataNotificado(new Date());
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                String codUser = (String)this.modelo.getValueAt(i, 0);
                if (!codUser.equalsIgnoreCase(this.notificado.getCodigo())) continue;
                userEstaAdicionado = true;
                this.labelVlrUsuario.setText("");
                this.textCodUser.setText("");
                ScreenUtil.requisitarFoco(this.textCodUser);
                break;
            }
            if (!userEstaAdicionado) {
                this.addNotificado(conformidadeUsuarioBean);
            }
            this.setSetorNaoConformidadeUsuarioBeansTemp(this.getSetoresUsuarioNcf());
        }
    }

    private void addNotificado(SetorNaoConformidadeUsuarioBean notificadoUser) {
        if (notificadoUser != null) {
            String dataLeitura = null;
            if (notificadoUser.getDataLeitura() != null) {
                dataLeitura = Funcoes.formataData("dd/MM/yyyy HH:mm", notificadoUser.getDataLeitura());
            }
            this.modelo.addLine(new Object[]{notificadoUser.getUsuarioVO().getCodigo(), Funcoes.formataData(notificadoUser.getDataNotificado()), dataLeitura, true, notificadoUser});
            this.notificado = null;
            this.labelVlrUsuario.setText("");
            this.textCodUser.setText("");
            ScreenUtil.requisitarFoco(this.textCodUser);
        }
    }

    private void pesquisaUsuario() {
        this.notificado = (UsuarioVO)this.usuarioService.pesquisaVO(this, new UsuarioVO(), "Pesquisando usu\u00e1rios notificados", false);
        if (this.notificado != null) {
            this.labelVlrUsuario.setText(this.notificado.getNome());
            this.textCodUser.setText(this.notificado.getCodigo());
        } else {
            this.labelVlrUsuario.setText("");
            this.textCodUser.setText("");
        }
    }

    public List<SetorNaoConformidadeUsuarioBean> getSetoresUsuarioNcf() {
        ArrayList<SetorNaoConformidadeUsuarioBean> list = new ArrayList<SetorNaoConformidadeUsuarioBean>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            list.add((SetorNaoConformidadeUsuarioBean)this.modelo.getValueAt(i, 4));
        }
        return list;
    }

    public void addListaSetoresUsuario(List<SetorNaoConformidadeUsuarioBean> list) {
        if (list != null) {
            for (SetorNaoConformidadeUsuarioBean notificadoUser : list) {
                String dataLeitura = null;
                if (notificadoUser.getDataLeitura() != null) {
                    dataLeitura = Funcoes.formataData("dd/MM/yyyy HH:mm", notificadoUser.getDataLeitura());
                }
                this.modelo.addLine(new Object[]{notificadoUser.getUsuarioVO().getCodigo(), Funcoes.formataData(notificadoUser.getDataNotificado()), dataLeitura, false, notificadoUser});
            }
        }
    }

    public void limparModeloNotificados() {
        this.modelo.clear();
    }

    @Override
    public boolean acaoOk() {
        return true;
    }

    public List<SetorNaoConformidadeUsuarioBean> getSetorNaoConformidadeUsuarioBeansTemp() {
        return this.setorNaoConformidadeUsuarioBeansTemp;
    }

    public void setSetorNaoConformidadeUsuarioBeansTemp(List<SetorNaoConformidadeUsuarioBean> setorNaoConformidadeUsuarioBeansTemp) {
        this.setorNaoConformidadeUsuarioBeansTemp = setorNaoConformidadeUsuarioBeansTemp;
    }
}

