/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBeanNovo;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.qualidade.naoconformidade.AbrirNaoConformidade;
import jalis.laboratorio.qualidade.naoconformidade.DescricaoAnaliseAcao;
import jalis.laboratorio.qualidade.naoconformidade.DetalheCritica;
import jalis.laboratorio.qualidade.naoconformidade.InfoAbrirNaoConformidade;
import jalis.laboratorio.qualidade.naoconformidade.InfoAnalisarNaoConformidade;
import jalis.laboratorio.qualidade.naoconformidade.UsuarioNotificado;
import jalis.laboratorio.relatorios.qualidade.ImprimirNaoConformidade;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.AcoesNaoConformidadeBean;
import jalis.model.bean.cadastro.NaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.vo.cadastro.AcaoNaoConformidadeVO;
import jalis.model.vo.cadastro.AcoesNaoConformidadeVO;
import jalis.model.vo.cadastro.NaoConformidadeVO;
import jalis.model.vo.cadastro.OrigemNaoConformidadeVO;
import jalis.model.vo.cadastro.ProcedenciaNaoConformidadeVO;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.AcaoNaoConformidadeService;
import jalis.service.cadastro.AcoesNaoConformidadeService;
import jalis.service.cadastro.NaoConformidadeService;
import jalis.service.cadastro.OrigemNaoConformidadeService;
import jalis.service.cadastro.ProcedenciaNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeUsuarioService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;

public class InfoAnalisarAcao
extends FrmCadPadraoBeanNovo
implements ActionListener {
    private static final String COLUNA_RESP = "Resp.";
    private static final String COLUNA_NOTIFICADO = "Notificado";
    private static final String COLUNA_CRITICA = "Cr\u00edtica";
    private static final String COLUNA_DESCRICAO = "Descri\u00e7\u00e3o";
    private static final String COLUNA_DESCRICAO_ANALISE_ACAO = "Descri\u00e7\u00e3o An\u00e1lise";
    private static final String COLUNA_CODIGO = "C\u00f3digo";
    private static final int COLUNA_ACAO = 3;
    private static final Integer COLUNA_SETOR = 5;
    private static final Integer COLUNA_SETOR_NCF = 8;
    private static final Integer OBJETO_CRITICA = 4;
    private JLabel labelCodigoNcf = new JLabel("C\u00f3digo:");
    private JLabel labelCodigoVlrNcf = new JLabel();
    private JLabel labelDataNcf = new JLabel("Data:");
    private JLabel labelDataVlrNcf = new JLabel();
    private JLabel labelUserNcf = new JLabel("Usu\u00e1rio:");
    private JLabel labelUserVlrNcf = new JLabel();
    private JLabel labelDataAnaliseNcf = new JLabel("Data an\u00e1lise:");
    private JLabel labelUserAnaliseNcf = new JLabel("Usu\u00e1rio an\u00e1lise:");
    private JLabel labelUserAnaliseVlrNcf = new JLabel();
    private JLabel labelProcedencia = new JLabel("Proced\u00eancia:");
    private JLabel labelVlrDescProcedencia = new JLabel();
    private JLabel labelAdicional = new JLabel("Adicional:");
    private JLabel labelResponsavelSetor = new JLabel();
    private JLabel labelVlrDescSetor = new JLabel();
    private JLabel labelNotificado = new JLabel("Notificado:");
    private JLabel labelVlrNotificado = new JLabel();
    private JLabel labelOrigem = new JLabel("Origem:");
    private JLabel labelVlrOrigem = new JLabel();
    private JLabel labelVlrLeitura = new JLabel();
    private JLabel textoDataAnaliseNcf = new JLabel();
    private JLabel textCodOrigem = new JLabel();
    private JLabel textDescAdicional = new JLabel();
    private TTextField textoAcaoAnaliseNcf = new TTextField(10, 1);
    private TTextField textCodSetor = new TTextField(10, 1);
    private TTextField textoDescricaoAcao = new TTextField(100, 3);
    private TTextField textoAnaliseAcao = new TTextField(1000, 3);
    private TTextField textoCodAcao = new TTextField(10, 1);
    private JLabel textCodProcedencia = new JLabel();
    private JTextArea textoAnalise = new JTextArea();
    private JButton buttonPesqSetor = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddSetor = ComponenteFactory.novoJButton("OK", 'K', this);
    private JButton buttonDetalhes = ComponenteFactory.novoJButton("Detalhes", 'D', this);
    private JButton buttonPesqAcao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddAcao = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonSetor = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscarNotificado = ComponenteFactory.novoJButton("...", this);
    private JButton buttonVisualizarNcf = new JButton();
    private ModeloGridTable modeloSetor = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Resp.", "Notificado", "Cr\u00edtica"});
    private JTable tableSetor = new JTable(this.modeloSetor){

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == OBJETO_CRITICA) {
                return Set.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == OBJETO_CRITICA;
        }
    };
    private JScrollPane scrollPaneSetor = new JScrollPane(this.tableSetor);
    private ModeloGridTable modeloAcao = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Descri\u00e7\u00e3o An\u00e1lise"});
    private JTable tableAcao = new JTable(this.modeloAcao);
    private JScrollPane scrollPaneAcao = new JScrollPane(this.tableAcao);
    private JCheckBox checkBoxComprometimento = new JCheckBox("Comprometimento");
    private JPanel panelProcedencia = new JPanel(new GridBagLayout());
    private JPanel panelSetor = new JPanel(new GridBagLayout());
    private JPanel panelAcao = new JPanel(new GridBagLayout());
    private JPanel panelAnalise = new JPanel(new GridBagLayout());
    private JPanel jPanelLinha2 = new JPanel(new GridBagLayout());
    private SetorVO setorVO = new SetorVO();
    private AcaoNaoConformidadeVO acaoNaoConformidadeVO = new AcaoNaoConformidadeVO();
    private SetorService setorService = new SetorService();
    private AcaoNaoConformidadeService acaoNaoConformidadeService = new AcaoNaoConformidadeService();
    private NaoConformidadeService naoConformidadeService = new NaoConformidadeService();
    private NaoConformidadeBean naoConformidadeBean = new NaoConformidadeBean();
    private AcoesNaoConformidadeService acoesNaoConformidadeService = new AcoesNaoConformidadeService();
    private SetorNaoConformidadeService setorNaoConformidadeService = new SetorNaoConformidadeService();
    private ProcedenciaNaoConformidadeService serviceProcedencia = new ProcedenciaNaoConformidadeService();
    private UsuarioVO usuarioVOLogado = null;
    private ProcedenciaNaoConformidadeVO procedenciaVo = null;
    private OrigemNaoConformidadeVO origemNaoConformidadeVO = null;
    private OrigemNaoConformidadeService origemNaoConformidadeService = new OrigemNaoConformidadeService();
    private UsuarioNotificado jDialogNotificados = UsuarioNotificado.novaInstancia(this.getTopLevelAncestor(), this.labelVlrNotificado);
    private SetorNaoConformidadeUsuarioService setorNaoConformidadeUsuarioService = new SetorNaoConformidadeUsuarioService();
    private UsuarioMensagemService usuarioMensagemService = new UsuarioMensagemService();
    private boolean editandoSetor = false;
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel painelCrud = new JPanel(new FlowLayout());
    private JButton buttonImprimir = new JButton("Imprimir");
    private static final String ASSUNTO_NCF_NAO_URGENTE = "N\u00e3o conformidade aberta.";
    private static final String ASSUNTO_NCF_URGENTE = "URGENTE, n\u00e3o conformidade aberta.";

    public InfoAnalisarAcao() {
        try {
            this.jbInit(false);
            this.controlaCampos();
            this.setModuloInsere(Long.valueOf("1300200201"));
            this.setModuloEdita(Long.valueOf("1300200202"));
            this.setModuloApaga(Long.valueOf("1300200203"));
            this.usuarioVOLogado = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, Variaveis.login);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void jbInit(boolean bloquear) {
        this.setLabelFormulario("Analisar a\u00e7\u00e3o");
        this.setLabelDescricao("Analisar a\u00e7\u00e3o");
        this.painelCentral.setLayout(new GridBagLayout());
        this.setIcone(ImagemUtils.carregaImagemJalis("cad_medico.jpg"));
        ScreenUtil.setBorda(new JComponent[]{this.labelResponsavelSetor, this.labelVlrOrigem, this.labelVlrNotificado, this.labelVlrDescProcedencia, this.labelCodigoVlrNcf, this.labelDataVlrNcf, this.labelUserVlrNcf, this.labelUserAnaliseVlrNcf, this.labelVlrLeitura, this.textoDataAnaliseNcf, this.textCodOrigem, this.textCodProcedencia, this.textDescAdicional}, new TitledBorder(""));
        this.panelSetor.setBorder(new TitledBorder("Setores Envolvidos"));
        this.panelAcao.setBorder(new TitledBorder("A\u00e7\u00f5es"));
        this.panelAnalise.setBorder(new TitledBorder("An\u00e1lise Geral"));
        this.modeloSetor.setColumnSize(new int[]{50, 0, 150, 0, 50}, this.tableSetor);
        this.modeloAcao.setColumnSize(new int[]{80, 0, 0}, this.tableAcao);
        this.tableSetor.getTableHeader().addMouseListener(this.modeloSetor);
        ButtonEditor buttonEditor = new ButtonEditor();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        this.tableSetor.setDefaultRenderer(Set.class, buttonRenderer);
        this.tableSetor.setDefaultEditor(Set.class, buttonEditor);
        if (Acesso.getAcesso(AbrirNaoConformidade.acessoOcultarDetalhe())) {
            this.buttonVisualizarNcf.setVisible(false);
        } else {
            this.buttonVisualizarNcf.setVisible(true);
        }
        this.buttonVisualizarNcf.setText("+");
        this.buttonVisualizarNcf.setToolTipText("Visualizar detalhes da n\u00e3o conformidade");
        this.buttonVisualizarNcf.addActionListener(this);
        this.buttonVisualizarNcf.setMargin(new Insets(0, 0, 0, 0));
        this.textoAnalise.setWrapStyleWord(true);
        this.textoAnalise.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textoAnalise);
        ScreenUtil.posicionaTextoTopo(this.textoAnalise);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.criaLinhaTopo(gridBagConstraints);
        this.criaOrigem(gridBagConstraints);
        this.criaPainelProcedencia(gridBagConstraints);
        this.criaPainelAnalise(gridBagConstraints);
        this.criaPainelAcao(gridBagConstraints);
        this.criaPainelSetor(gridBagConstraints);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelOpcoes.add(this.buttonImprimir);
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)this.painelCrud, "East");
        this.painelCrud.add(this.botaoNovo);
        this.painelCrud.add(this.botaoEditar);
        this.painelCrud.add(this.botaoSalvar);
        this.painelCrud.add(this.botaoCancelar);
        this.painelCrud.add(this.botaoExcluir);
        this.painelCrud.add(this.botaoFechar);
        this.buttonImprimir.setMnemonic('R');
        this.buttonImprimir.setVisible(Acesso.getAcesso(ImprimirNaoConformidade.getModuloAcesso()));
    }

    private void criaOrigem(GridBagConstraints bagLayout) {
        if (!Acesso.getAcesso(AbrirNaoConformidade.getModuloAcessoOcultarOrigem())) {
            bagLayout.weightx = 0.0;
            bagLayout.gridx = 0;
            ++bagLayout.gridy;
            bagLayout.gridwidth = 1;
            bagLayout.anchor = 13;
            bagLayout.insets = new Insets(0, 0, 0, 0);
            this.labelOrigem.setPreferredSize(new Dimension(77, 20));
            this.labelOrigem.setMinimumSize(new Dimension(77, 20));
            this.painelCentral.add((Component)this.labelOrigem, bagLayout);
            JPanel panelOrigem = new JPanel(new GridBagLayout());
            GridBagConstraints origem = new GridBagConstraints();
            origem.fill = 13;
            origem.anchor = 13;
            origem.gridx = 0;
            origem.gridy = 0;
            this.textCodOrigem.setPreferredSize(new Dimension(99, 20));
            this.textCodOrigem.setMinimumSize(new Dimension(50, 20));
            panelOrigem.add((Component)this.textCodOrigem, origem);
            ++origem.gridx;
            origem.weightx = 1.0;
            origem.fill = 2;
            origem.insets = new Insets(0, 1, 0, 0);
            this.labelVlrOrigem.setPreferredSize(new Dimension(20, 20));
            this.labelVlrOrigem.setMinimumSize(new Dimension(20, 20));
            panelOrigem.add((Component)this.labelVlrOrigem, origem);
            ++origem.gridx;
            origem.weightx = 0.0;
            origem.fill = 17;
            origem.insets = new Insets(1, 20, 0, 0);
            this.checkBoxComprometimento.setPreferredSize(new Dimension(200, 21));
            panelOrigem.add((Component)this.checkBoxComprometimento, origem);
            ++bagLayout.gridx;
            bagLayout.fill = 2;
            bagLayout.weightx = 1.0;
            bagLayout.gridwidth = 5;
            bagLayout.insets = new Insets(0, 0, 0, 3);
            this.painelCentral.add((Component)panelOrigem, bagLayout);
        }
    }

    private void criaPainelProcedencia(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.painelCentral.add((Component)this.panelProcedencia, gridBagConstraints);
        GridBagConstraints gridBagPanelProc = new GridBagConstraints();
        gridBagPanelProc.insets = new Insets(0, 0, 0, 1);
        gridBagPanelProc.gridy = 0;
        gridBagPanelProc.gridx = 0;
        gridBagPanelProc.weightx = 0.0;
        gridBagPanelProc.weighty = 0.0;
        gridBagPanelProc.fill = 17;
        gridBagPanelProc.anchor = 17;
        this.panelProcedencia.add((Component)new JLabel("Proced\u00eancia:"), gridBagPanelProc);
        ++gridBagPanelProc.gridx;
        this.textCodProcedencia.setPreferredSize(new Dimension(99, 20));
        this.textCodProcedencia.setMinimumSize(new Dimension(99, 20));
        gridBagPanelProc.fill = 13;
        this.panelProcedencia.add((Component)this.textCodProcedencia, gridBagPanelProc);
        gridBagPanelProc.insets = new Insets(0, 0, 0, 1);
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.weightx = 1.0;
        gridBagPanelProc.fill = 2;
        this.labelVlrDescProcedencia.setMinimumSize(new Dimension(80, 20));
        this.labelVlrDescProcedencia.setPreferredSize(new Dimension(80, 20));
        this.panelProcedencia.add((Component)this.labelVlrDescProcedencia, gridBagPanelProc);
        gridBagPanelProc.insets = new Insets(0, 0, 0, 0);
        gridBagPanelProc.weightx = 0.0;
        gridBagPanelProc.fill = 13;
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.insets = new Insets(0, 20, 0, 1);
        this.panelProcedencia.add((Component)this.labelAdicional, gridBagPanelProc);
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.weightx = 1.0;
        gridBagPanelProc.insets = new Insets(0, 0, 0, 1);
        gridBagPanelProc.fill = 2;
        this.textDescAdicional.setPreferredSize(new Dimension(100, 20));
        this.textDescAdicional.setMinimumSize(new Dimension(100, 20));
        this.panelProcedencia.add((Component)this.textDescAdicional, gridBagPanelProc);
        if (Acesso.getAcesso(AbrirNaoConformidade.getModuloAcessoOcultarProcedencia())) {
            this.panelProcedencia.setVisible(false);
        }
    }

    private void criaPainelAnalise(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.textoAnalise);
        jScrollPane.setPreferredSize(new Dimension(40, 60));
        jScrollPane.setMinimumSize(new Dimension(40, 60));
        this.panelAnalise.add((Component)jScrollPane, gridBagConstraints);
        this.painelCentral.add((Component)this.panelAnalise, gridBagConstraints);
    }

    private void criaPainelSetor(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.painelCentral.add((Component)this.panelSetor, gridBagConstraints);
        GridBagConstraints gridBagPanelSetor = new GridBagConstraints();
        ++gridBagPanelSetor.gridy;
        gridBagPanelSetor.gridx = 0;
        gridBagPanelSetor.gridwidth = 6;
        gridBagPanelSetor.fill = 1;
        gridBagPanelSetor.weightx = 1.0;
        gridBagPanelSetor.weighty = 1.0;
        this.scrollPaneSetor.setPreferredSize(new Dimension(20, 65));
        this.scrollPaneSetor.setMinimumSize(new Dimension(20, 65));
        this.panelSetor.add((Component)this.scrollPaneSetor, gridBagPanelSetor);
    }

    private void criaPainelAcao(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.painelCentral.add((Component)this.panelAcao, gridBagConstraints);
        GridBagConstraints gridBagPanelAcoes = new GridBagConstraints();
        gridBagPanelAcoes.insets = new Insets(0, 0, 0, 1);
        gridBagPanelAcoes.gridy = 0;
        gridBagPanelAcoes.gridx = 0;
        gridBagPanelAcoes.gridwidth = 4;
        gridBagPanelAcoes.fill = 1;
        gridBagPanelAcoes.weightx = 1.0;
        gridBagPanelAcoes.weighty = 1.0;
        this.scrollPaneAcao.setPreferredSize(new Dimension(20, 60));
        this.scrollPaneAcao.setMinimumSize(new Dimension(20, 60));
        this.panelAcao.add((Component)this.scrollPaneAcao, gridBagPanelAcoes);
        JPanel jPanelDetalhar = new JPanel(new FlowLayout(2, 0, 0));
        gridBagPanelAcoes.fill = 2;
        ++gridBagPanelAcoes.gridy;
        gridBagPanelAcoes.weightx = 1.0;
        gridBagPanelAcoes.weighty = 0.0;
        gridBagPanelAcoes.anchor = 13;
        this.buttonDetalhes.setPreferredSize(new Dimension(100, 20));
        this.buttonDetalhes.setMinimumSize(new Dimension(100, 20));
        jPanelDetalhar.add(this.buttonDetalhes);
        this.panelAcao.add((Component)jPanelDetalhar, gridBagPanelAcoes);
    }

    private void criaLinhaTopo(GridBagConstraints gridBagConstraints) {
        this.painelCentral.add((Component)this.labelCodigoNcf, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.labelCodigoVlrNcf.setMinimumSize(new Dimension(100, 20));
        this.labelCodigoVlrNcf.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.painelCentral.add((Component)this.labelCodigoVlrNcf, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        ++gridBagConstraints.gridx;
        this.painelCentral.add((Component)this.labelDataAnaliseNcf, gridBagConstraints);
        GridBagConstraints gridBagLinha2 = new GridBagConstraints();
        gridBagLinha2.insets = new Insets(0, 0, 0, 1);
        gridBagLinha2.gridy = 0;
        gridBagLinha2.gridx = 0;
        gridBagLinha2.weightx = 0.0;
        gridBagLinha2.weighty = 0.0;
        gridBagLinha2.fill = 0;
        gridBagLinha2.anchor = 17;
        gridBagLinha2.gridwidth = 1;
        ++gridBagConstraints.gridx;
        this.textoDataAnaliseNcf.setPreferredSize(new Dimension(100, 20));
        this.textoDataAnaliseNcf.setMinimumSize(new Dimension(100, 20));
        this.jPanelLinha2.add((Component)this.textoDataAnaliseNcf, gridBagLinha2);
        gridBagLinha2.insets = new Insets(0, 20, 0, 1);
        ++gridBagLinha2.gridx;
        this.labelUserAnaliseNcf.setPreferredSize(new Dimension(100, 20));
        this.labelUserAnaliseNcf.setMinimumSize(new Dimension(100, 20));
        this.jPanelLinha2.add((Component)this.labelUserAnaliseNcf, gridBagLinha2);
        ++gridBagLinha2.gridx;
        this.labelUserAnaliseVlrNcf.setPreferredSize(new Dimension(120, 20));
        this.labelUserAnaliseVlrNcf.setMinimumSize(new Dimension(120, 20));
        gridBagLinha2.insets = new Insets(0, 1, 0, 0);
        this.jPanelLinha2.add((Component)this.labelUserAnaliseVlrNcf, gridBagLinha2);
        ++gridBagLinha2.gridx;
        this.buttonVisualizarNcf.setPreferredSize(new Dimension(20, 20));
        this.buttonVisualizarNcf.setMinimumSize(new Dimension(20, 20));
        this.jPanelLinha2.add((Component)this.buttonVisualizarNcf, gridBagLinha2);
        gridBagConstraints.gridwidth = 3;
        this.painelCentral.add((Component)this.jPanelLinha2, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDetalhes) {
            this.mostrarDetalheAcao();
        } else if (e.getSource() == this.buttonVisualizarNcf) {
            InfoAnalisarNaoConformidade analisarNaoConformidade = new InfoAnalisarNaoConformidade(this.naoConformidadeBean);
            analisarNaoConformidade.visualizar();
        }
    }

    public void visualizar() {
        final JDialog visDialog = new JDialog();
        visDialog.add(this);
        visDialog.setResizable(false);
        visDialog.setPreferredSize(new Dimension(770, 580));
        visDialog.setMinimumSize(new Dimension(770, 580));
        visDialog.setTitle("Visualizando detalhes da an\u00e1lise da n\u00e3o conformidade");
        visDialog.setModal(true);
        this.painelCrud.removeAll();
        this.painelOpcoes.removeAll();
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                visDialog.dispose();
            }
        });
        this.painelCrud.add(this.botaoFechar);
        visDialog.setLocationRelativeTo(Laboratorio.getInstancia());
        visDialog.setVisible(true);
        visDialog.pack();
    }

    public InfoAnalisarAcao(NaoConformidadeBean naoConformidadeBean) {
        try {
            this.montarTela(true);
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", naoConformidadeBean.getFilial().getCodigo());
            chaves.put("nac_codigo", naoConformidadeBean.getCodigo());
            this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBeanAnalise(chaves);
            this.preencherCampos(this.naoConformidadeBean);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montarTela(boolean bloquearListenerTabelas) {
        this.jbInit(bloquearListenerTabelas);
        this.controlaCampos();
        this.ocultaProcedencia();
        this.setModuloInsere(Long.valueOf("1300200101"));
        this.setModuloEdita(Long.valueOf("1300200102"));
        this.setModuloApaga(Long.valueOf("1300200103"));
    }

    private void ocultaProcedencia() {
        if (Acesso.getAcesso(AbrirNaoConformidade.getModuloAcessoOcultarProcedencia())) {
            this.labelProcedencia.setVisible(false);
            this.labelVlrDescProcedencia.setVisible(false);
            this.textCodProcedencia.setVisible(false);
            this.labelAdicional.setVisible(false);
            this.textDescAdicional.setVisible(false);
        } else {
            this.labelProcedencia.setVisible(true);
            this.labelVlrDescProcedencia.setVisible(true);
            this.textCodProcedencia.setVisible(true);
            this.labelAdicional.setVisible(true);
            this.textDescAdicional.setVisible(true);
        }
    }

    private void exibirDetalheNcf() {
        InfoAbrirNaoConformidade abrirNaoConformidade = new InfoAbrirNaoConformidade(this.naoConformidadeBean);
        abrirNaoConformidade.visualizar();
    }

    private void pesquisaOrigem() {
        OrigemNaoConformidadeVO setVo = (OrigemNaoConformidadeVO)this.origemNaoConformidadeService.pesquisaVO(Laboratorio.getInstancia(), new OrigemNaoConformidadeVO(), "Pesquisando origem", true);
        if (setVo != null) {
            this.origemNaoConformidadeVO = setVo;
            this.textCodOrigem.setText(setVo.getCodigo().toString());
            this.labelVlrOrigem.setText(setVo.getDescricao());
        } else {
            this.labelVlrOrigem.setText("N\u00e3o cadastrado");
        }
    }

    private void mostrarDetalheAcao() {
        if (this.modeloAcao.getRowCount() > 0) {
            if (this.tableAcao.getSelectedRow() < 0) {
                Funcoes.mensagem(this, "Selecione uma a\u00e7\u00e3o.", 2);
                return;
            }
            int linhaSelecionada = this.tableAcao.getSelectedRow();
            AcoesNaoConformidadeBean acoesNcfSelecionada = (AcoesNaoConformidadeBean)this.modeloAcao.getValueAt(linhaSelecionada, 3);
            if (acoesNcfSelecionada != null) {
                DescricaoAnaliseAcao descricaoAnaliseAcao = new DescricaoAnaliseAcao().novaInstancia(this.getTopLevelAncestor(), acoesNcfSelecionada, true);
                descricaoAnaliseAcao.setVisible(Boolean.TRUE);
            }
        }
    }

    private void addSetor() {
        SetorNaoConformidadeVO setorNaoConformidadeVoTemp = new SetorNaoConformidadeVO();
        if (this.editandoSetor) {
            this.clonarDadoSetor(setorNaoConformidadeVoTemp);
            int linha = this.tableSetor.getSelectedRow();
            if (linha > -1) {
                this.modeloSetor.removeLine(this.tableSetor.getSelectedRow());
            }
        }
        this.setorVO.setResponsavel(this.labelResponsavelSetor.getText());
        this.addLinhaTabelaSetor(this.setorVO, setorNaoConformidadeVoTemp);
        this.textCodSetor.setText("");
        this.labelResponsavelSetor.setText("");
        this.labelVlrDescSetor.setText("");
        this.labelVlrLeitura.setText("");
        this.labelVlrNotificado.setText("");
        this.editandoSetor = false;
        this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
    }

    private void clonarDadoSetor(SetorNaoConformidadeVO setorNaoConformidadeVoTemp) {
        SetorNaoConformidadeVO setorNaoConformidadeVoClona = (SetorNaoConformidadeVO)((SetorNaoConformidadeVO)this.modeloSetor.getValueAt(this.tableSetor.getSelectedRow(), COLUNA_SETOR_NCF)).clonar();
        setorNaoConformidadeVoTemp.setCodigo(setorNaoConformidadeVoClona.getCodigo());
        setorNaoConformidadeVoTemp.setFilial(setorNaoConformidadeVoClona.getFilial());
        setorNaoConformidadeVoTemp.setNaoConformidade(setorNaoConformidadeVoClona.getNaoConformidade());
        setorNaoConformidadeVoTemp.setCodResponsavelSetor(setorNaoConformidadeVoClona.getCodResponsavelSetor());
        setorNaoConformidadeVoTemp.setDataAnaliseUsuario(setorNaoConformidadeVoClona.getDataAnaliseUsuario());
        setorNaoConformidadeVoTemp.setCritica(setorNaoConformidadeVoClona.getCritica());
    }

    private void addLinhaTabelaSetor(SetorVO setorVO, SetorNaoConformidadeVO setorNaoConformidadeVoTemp) {
        SetorNaoConformidadeVO setorNaoConformidadeVo = new SetorNaoConformidadeVO();
        setorNaoConformidadeVo.setFilial(this.naoConformidadeBean.getFilial());
        setorNaoConformidadeVo.setCodigo(setorNaoConformidadeVoTemp.getCodigo());
        setorNaoConformidadeVo.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
        setorNaoConformidadeVo.setSetor(setorVO);
        setorNaoConformidadeVo.setDataAnaliseUsuario(setorNaoConformidadeVoTemp.getDataAnaliseUsuario());
        setorNaoConformidadeVo.setCritica(setorNaoConformidadeVoTemp.getCritica());
        setorNaoConformidadeVo.setNaoConformidadeUsuarioBeans(this.jDialogNotificados.getSetoresUsuarioNcf());
        setorNaoConformidadeVo.setCodResponsavelSetor(setorVO.getUsuario().getCodigo());
        this.modeloSetor.addLine(new Object[]{setorVO.getCodigo(), setorVO.getDescricao(), setorVO.getUsuario().getCodigo(), this.labelVlrNotificado.getText(), setorNaoConformidadeVo, setorVO, this.jDialogNotificados.getSetoresUsuarioNcf(), setorNaoConformidadeVo, setorNaoConformidadeVoTemp});
    }

    private void addLinhaTabelaSetor(SetorNaoConformidadeVO setorVO) {
        this.modeloSetor.addLine(new Object[]{setorVO.getSetor().getCodigo(), setorVO.getSetor().getDescricao(), setorVO.getSetor().getUsuario().getCodigo(), this.montaUsuariosNotificados(setorVO.getNaoConformidadeUsuarioBeansTemp()), setorVO, setorVO.getSetor(), setorVO.getNaoConformidadeUsuarioBeansTemp(), setorVO, setorVO});
    }

    private String montaUsuariosNotificados(List<SetorNaoConformidadeUsuarioBean> naoConformidadeUsuarioBeansTemp) {
        StringBuilder retorno = new StringBuilder();
        if (naoConformidadeUsuarioBeansTemp != null) {
            for (SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean : naoConformidadeUsuarioBeansTemp) {
                retorno.append(setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo());
                retorno.append(", ");
            }
            if (retorno.length() > 0) {
                return retorno.toString().substring(0, retorno.length() - 2);
            }
        }
        return "";
    }

    private void addAcaoAoModelo(AcoesNaoConformidadeBean acoesNaoConformidadeBean) {
        this.modeloAcao.addLine(new Object[]{acoesNaoConformidadeBean.getAcaoNaoConformidade().getCodigo(), acoesNaoConformidadeBean.getAcaoNaoConformidade().getDescricao(), acoesNaoConformidadeBean.getDescricaoAcao(), acoesNaoConformidadeBean.clonar()});
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void controlaCampos() {
        this.checkBoxComprometimento.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonBuscarNotificado.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddAcao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonPesqAcao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonPesqSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.textoAcaoAnaliseNcf.setEditable(false);
        this.textoAnalise.setEditable(false);
    }

    private void linhaAdicionalVisivel(boolean visivel) {
        this.labelAdicional.setVisible(visivel);
        this.textDescAdicional.setVisible(visivel);
    }

    @Override
    protected void limparCampos() {
        this.textCodOrigem.setText("");
        this.textoAcaoAnaliseNcf.clear();
        this.textoAnalise.setText("");
        this.textoCodAcao.clear();
        this.textCodSetor.clear();
        this.labelResponsavelSetor.setText("");
        this.labelVlrOrigem.setText("");
        this.labelCodigoVlrNcf.setText("");
        this.labelUserAnaliseVlrNcf.setText("");
        this.labelUserVlrNcf.setText("");
        this.textDescAdicional.setText("");
        this.labelVlrDescProcedencia.setText("");
        this.labelVlrLeitura.setText("");
        this.modeloAcao.clear();
        this.modeloSetor.clear();
        this.checkBoxComprometimento.setSelected(false);
        this.setorVO = new SetorVO();
        this.naoConformidadeBean = new NaoConformidadeBean();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return this.naoConformidadeBean;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean != null && bean instanceof NaoConformidadeBean && bean != null) {
            this.naoConformidadeBean = (NaoConformidadeBean)bean.clonar();
            this.labelCodigoVlrNcf.setText(this.naoConformidadeBean.getCodigo().toString());
            this.labelUserVlrNcf.setText(this.naoConformidadeBean.getUsuario() + " em " + Funcoes.formataData(this.naoConformidadeBean.getNcfData()));
            this.labelUserAnaliseVlrNcf.setText(this.naoConformidadeBean.getUsuarioAnalise().getCodigo());
            this.textoDataAnaliseNcf.setText(Funcoes.formataData(this.naoConformidadeBean.getNcfDataAnalise()));
            this.textoAnalise.setText(this.naoConformidadeBean.getAnalise());
            this.textCodProcedencia.setText(this.procedencia());
            this.labelVlrDescProcedencia.setText(this.descricaoProcedencia());
            this.textDescAdicional.setText(this.naoConformidadeBean.getAdicional());
            this.procedenciaVo = this.naoConformidadeBean.getProcedenciaNaoConformidade();
            this.textCodOrigem.setText(this.getCodOrigem(this.naoConformidadeBean));
            this.labelVlrOrigem.setText(this.getDescOrigem(this.naoConformidadeBean));
            this.checkBoxComprometimento.setSelected(this.naoConformidadeBean.isComprometimento());
            for (SetorNaoConformidadeVO setorVO : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if (setorVO == null) continue;
                this.addLinhaTabelaSetor(setorVO);
            }
            for (AcoesNaoConformidadeVO acoesNcf : this.naoConformidadeBean.getAcoesNaoConformidadeVOs()) {
                this.addAcaoAoModelo((AcoesNaoConformidadeBean)acoesNcf.toBean());
            }
        }
    }

    private String getCodOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getDescOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getDescricao();
        }
        return "";
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return true;
    }

    private boolean validarSetoresInformados() {
        HashSet<Integer> setoresNcf = new HashSet<Integer>();
        HashSet<Integer> setoresANcf = new HashSet<Integer>();
        for (SetorNaoConformidadeBean bean : this.setorNaoConformidadeListaAnalise()) {
            setoresANcf.add(bean.getSetor().getCodigo());
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", this.naoConformidadeBean.getFilial().getCodigo());
        chaves.put("nac_codigo", this.naoConformidadeBean.getCodigo());
        NaoConformidadeBean naoConformidadeBean = null;
        try {
            naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel validar os setores informados.", 1);
        }
        for (SetorNaoConformidadeVO bean : naoConformidadeBean.getSetorNaoConformidadeVOs()) {
            setoresNcf.add(bean.getSetor().getCodigo());
        }
        return setoresANcf.containsAll(setoresNcf);
    }

    private List<SetorNaoConformidadeBean> setorNaoConformidadeListaAnalise() {
        ArrayList<SetorNaoConformidadeBean> setores = new ArrayList<SetorNaoConformidadeBean>();
        for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
            setores.add((SetorNaoConformidadeBean)((SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, 7)).toBean());
        }
        return setores;
    }

    private List<AcoesNaoConformidadeBean> acoesNaoConformidadeListaAnalise() {
        ArrayList<AcoesNaoConformidadeBean> acoes = new ArrayList<AcoesNaoConformidadeBean>();
        for (int i = 0; i < this.modeloAcao.getRowCount(); ++i) {
            acoes.add((AcoesNaoConformidadeBean)this.modeloAcao.getValueAt(i, 3));
        }
        return acoes;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1300200200");
    }

    private void preencherCamposNcf() {
        if (this.naoConformidadeBean != null) {
            this.labelCodigoVlrNcf.setText(this.naoConformidadeBean.getCodigo().toString());
            this.labelUserVlrNcf.setText(this.naoConformidadeBean.getUsuario() + " em " + Funcoes.formataData(this.naoConformidadeBean.getNcfData()));
            this.labelUserAnaliseVlrNcf.setText(Variaveis.login);
            this.textCodProcedencia.setText(this.procedencia());
            this.labelVlrDescProcedencia.setText(this.descricaoProcedencia());
            this.textDescAdicional.setText(this.naoConformidadeBean.getAdicional());
            this.procedenciaVo = this.naoConformidadeBean.getProcedenciaNaoConformidade();
            this.textCodOrigem.setText(this.descricaoOrigem());
            this.labelVlrOrigem.setText(this.valorOrigem());
            for (SetorNaoConformidadeVO setorNcf : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                this.addLinhaTabelaSetor(setorNcf);
            }
        }
    }

    private String valorOrigem() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getOrigemNaoConformidade() == null || this.naoConformidadeBean.getOrigemNaoConformidade().getDescricao() == null) {
            return "";
        }
        return this.naoConformidadeBean.getOrigemNaoConformidade().getDescricao();
    }

    private String descricaoOrigem() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getOrigemNaoConformidade() == null) {
            return "";
        }
        return this.naoConformidadeBean.getOrigemNaoConformidade().toString();
    }

    private String descricaoProcedencia() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getProcedenciaNaoConformidade() == null) {
            return "";
        }
        return this.naoConformidadeBean.getProcedenciaNaoConformidade().getDescricao();
    }

    private String procedencia() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getProcedenciaNaoConformidade() == null || this.naoConformidadeBean.getProcedenciaNaoConformidade().getCodigo() == null) {
            return "";
        }
        return this.naoConformidadeBean.getProcedenciaNaoConformidade().getCodigo().toString();
    }

    class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            isSelected = false;
            Funcoes.imagemPesquisa(this);
            return this;
        }
    }

    class ButtonEditor
    extends DefaultCellEditor {
        private JButton button;
        int linha;

        public ButtonEditor() {
            super(new JCheckBox());
            this.linha = -1;
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.setPreferredSize(new Dimension(40, 40));
            this.button.setMinimumSize(new Dimension(40, 40));
            Funcoes.imagemPesquisa(this.button);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.linha = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            SetorNaoConformidadeVO resultado;
            if (this.linha > -1 && (resultado = (SetorNaoConformidadeVO)InfoAnalisarAcao.this.modeloSetor.getValueAt(this.linha, 4)) != null) {
                Container container = InfoAnalisarAcao.this.getTopLevelAncestor();
                DetalheCritica detalheCritica = null;
                detalheCritica = container instanceof Dialog ? new DetalheCritica((Dialog)InfoAnalisarAcao.this.getTopLevelAncestor(), "Detalhe cr\u00edtica", resultado) : new DetalheCritica((Frame)InfoAnalisarAcao.this.getTopLevelAncestor(), "Detalhe cr\u00edtica", resultado);
                if (detalheCritica != null) {
                    detalheCritica.setVisible(true);
                }
                return resultado;
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.linha = -1;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}

