/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.NaoConformidadeBean;
import jalis.model.bean.cadastro.RequisicaoNaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.OrigemNaoConformidadeVO;
import jalis.model.vo.cadastro.ProcedenciaNaoConformidadeVO;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.NaoConformidadeService;
import jalis.service.cadastro.OrigemNaoConformidadeService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class InfoAbrirNaoConformidade
extends FrmCadPadraoBean
implements ActionListener {
    private static final String OCULTA_PROCEDENCIA = "0105000104";
    private static final String OCULTA_ORIGEM = "0105000105";
    private static final String OCULTA_DETALHE = "0105000106";
    private static final Integer COLUNA_LOTE = 3;
    private static final Integer COLUNA_SETOR = 4;
    private static final Integer COLUNA_NOTIFICADO = 3;
    private static final Integer COLUNA_REQUISICAO = 2;
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelProcedencia = new JLabel("Proced\u00eancia:");
    private JLabel labelAdicional = new JLabel("Adicional:");
    private JLabel labelOrigem = new JLabel("Origem:");
    private JLabel labelTipo = new JLabel("Tipo:");
    private JLabel labelVlrOrigem = new JLabel();
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelVlrTipo = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrDescProcedencia = new JLabel();
    private JLabel labelVlrDescSetor = new JLabel();
    private JLabel labelVlrDataNcf = new JLabel();
    private JLabel textData = new JLabel();
    private JLabel textCodProcedencia = new JLabel();
    private JLabel textDescAdicional = new JLabel();
    private JLabel textCodOrigem = new JLabel();
    private JLabel textCodTipo = new JLabel();
    private JTextArea textAreaDescricao = new JTextArea();
    private JCheckBox checkboxUrgente = new JCheckBox("Urgente");
    ModeloGridTable modeloRequisicao = new ModeloGridTable(new String[]{"C\u00f3digo", "Nome"});
    JTable tableRequisicao = new JTable(this.modeloRequisicao);
    JScrollPane scrollPaneRequisicao = new JScrollPane(this.tableRequisicao);
    ModeloGridTable modeloSetores = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Resp."});
    JTable tableSetor = new JTable(this.modeloSetores);
    JScrollPane scrollPaneSetor = new JScrollPane(this.tableSetor);
    private JPanel panelNcf = new JPanel(new GridBagLayout());
    private JPanel panelSetor = new JPanel(new GridBagLayout());
    private JPanel panelLote = new JPanel(new GridBagLayout());
    private JPanel panelLoteSetor = new JPanel(new GridBagLayout());
    private ProcedenciaNaoConformidadeVO procedenciaVo = null;
    private ConvenioVO convenioVO = null;
    private EntidadeVO entidadeVO = null;
    private MaterialVO materialVO = null;
    private MaterialLoteVO materialLoteVo = null;
    private SetorVO setorVO = null;
    private OrigemNaoConformidadeVO origemNaoConformidadeVO = null;
    private NotaFiscalVO notaFiscalVO = null;
    private UsuarioVO usuarioVO = null;
    private NaoConformidadeBean naoConformidadeBean = null;
    private RequisicaoNaoConformidadeBean requisicaoNaoConformidadeBean = null;
    private NaoConformidadeService naoConformidadeService = new NaoConformidadeService();
    private OrigemNaoConformidadeService origemNaoConformidadeService = new OrigemNaoConformidadeService();
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel painelCrud = new JPanel(new FlowLayout());
    private boolean editandoSetor = false;

    public InfoAbrirNaoConformidade() {
        try {
            this.montarTela(false);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public InfoAbrirNaoConformidade(NaoConformidadeBean naoConformidadeBean) {
        try {
            this.montarTela(true);
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", naoConformidadeBean.getFilial().getCodigo());
            chaves.put("nac_codigo", naoConformidadeBean.getCodigo());
            this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
            this.preencherCampos(naoConformidadeBean);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montarTela(boolean bloquearListenerTabelas) {
        this.jbInit(bloquearListenerTabelas);
        this.controlaCampos();
        this.ocultaProcedencia();
        this.setModuloInsere(Long.valueOf("1300200101"));
        this.setModuloEdita(Long.valueOf("1300200102"));
        this.setModuloApaga(Long.valueOf("1300200103"));
    }

    private void jbInit(boolean bloquear) {
        this.modeloSetores.setColumnSize(new int[]{80, 0, 0}, this.tableSetor);
        this.modeloRequisicao.setColumnSize(new int[]{80, 0}, this.tableRequisicao);
        ScreenUtil.setBorda(new JComponent[]{this.textData, this.labelVlrOrigem, this.labelVlrCodigo, this.labelVlrUsuario, this.labelVlrDescProcedencia, this.labelVlrDescSetor, this.labelVlrDataNcf, this.textCodProcedencia, this.textDescAdicional, this.textCodOrigem, this.labelVlrTipo, this.textCodTipo}, new TitledBorder(""));
        this.setIcone(ImagemUtils.carregaImagemJalis("qualidade/qualidade_abrir_nc.jpg"));
        this.setLabelFormulario("Abrir n\u00e3o conformidade");
        this.setLabelDescricao("Abrir n\u00e3o conformidade");
        this.tableRequisicao.getTableHeader().addMouseListener(this.modeloRequisicao);
        this.tableSetor.getTableHeader().addMouseListener(this.modeloSetores);
        this.panelNcf.setBorder(new TitledBorder("N\u00e3o conformidade"));
        this.panelLote.setBorder(new TitledBorder("Lote"));
        this.panelSetor.setBorder(new TitledBorder("Setores envolvidos"));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints bagLayout = new GridBagConstraints();
        this.criaLinhaCodigo(bagLayout);
        this.criaLinhaProcedencia(bagLayout);
        this.criaLinhaAdicional(bagLayout);
        this.criaOrigem(bagLayout);
        this.criaTipo(bagLayout);
        this.criaPainelNcf(bagLayout);
        bagLayout = new GridBagConstraints();
        this.criaLinhaRequisicao(bagLayout);
        this.criaPainelSetor(bagLayout);
        this.criaLinhaSetor();
        this.criaDescricaoNcf(bagLayout);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)this.painelCrud, "East");
        this.painelCrud.add(this.botaoFechar);
        this.textAreaDescricao.setWrapStyleWord(true);
        this.textAreaDescricao.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textAreaDescricao);
        ScreenUtil.posicionaTextoTopo(this.textAreaDescricao);
        this.labelData.setDisplayedMnemonic('D');
        this.labelData.setLabelFor(this.textData);
        this.labelProcedencia.setDisplayedMnemonic('P');
        this.labelProcedencia.setLabelFor(this.textCodProcedencia);
        this.ocultaCampos();
    }

    private void criaOrigem(GridBagConstraints bagLayout) {
        if (!Acesso.getAcesso(this.getModuloAcessoOcultarOrigem())) {
            bagLayout.weightx = 0.0;
            bagLayout.gridx = 0;
            ++bagLayout.gridy;
            bagLayout.gridwidth = 1;
            bagLayout.anchor = 17;
            bagLayout.insets = new Insets(0, 0, 0, 0);
            this.painelCentral.add((Component)this.labelOrigem, bagLayout);
            ++bagLayout.gridx;
            bagLayout.insets = new Insets(0, 0, 0, 1);
            this.textCodOrigem.setPreferredSize(new Dimension(97, 20));
            this.textCodOrigem.setMinimumSize(new Dimension(97, 20));
            this.painelCentral.add((Component)this.textCodOrigem, bagLayout);
            bagLayout.insets = new Insets(0, 0, 0, 1);
            JPanel panelOrigem = new JPanel(new GridBagLayout());
            GridBagConstraints origem = new GridBagConstraints();
            origem.fill = 2;
            origem.gridx = 0;
            origem.gridy = 0;
            origem.weightx = 1.0;
            origem.insets = new Insets(0, 0, 0, 1);
            this.labelVlrOrigem.setPreferredSize(new Dimension(20, 20));
            this.labelVlrOrigem.setMinimumSize(new Dimension(20, 20));
            panelOrigem.add((Component)this.labelVlrOrigem, origem);
            ++origem.gridx;
            origem.fill = 17;
            origem.weightx = 0.0;
            origem.insets = new Insets(0, 1, 0, 1);
            ++bagLayout.gridx;
            bagLayout.insets = new Insets(0, 0, 0, 1);
            bagLayout.fill = 2;
            bagLayout.weightx = 1.0;
            bagLayout.gridwidth = 6;
            this.painelCentral.add((Component)panelOrigem, bagLayout);
        }
    }

    private void criaTipo(GridBagConstraints bagLayout) {
        bagLayout.weightx = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 1;
        bagLayout.anchor = 17;
        bagLayout.insets = new Insets(0, 0, 0, 0);
        this.painelCentral.add((Component)this.labelTipo, bagLayout);
        ++bagLayout.gridx;
        bagLayout.insets = new Insets(0, 0, 0, 1);
        this.textCodTipo.setPreferredSize(new Dimension(97, 20));
        this.textCodTipo.setMinimumSize(new Dimension(97, 20));
        this.painelCentral.add((Component)this.textCodTipo, bagLayout);
        bagLayout.insets = new Insets(0, 0, 0, 1);
        JPanel panelTipo = new JPanel(new GridBagLayout());
        GridBagConstraints tipo = new GridBagConstraints();
        tipo.fill = 2;
        tipo.gridx = 0;
        tipo.gridy = 0;
        tipo.weightx = 1.0;
        tipo.insets = new Insets(0, 0, 0, 1);
        this.labelVlrTipo.setPreferredSize(new Dimension(20, 20));
        this.labelVlrTipo.setMinimumSize(new Dimension(20, 20));
        panelTipo.add((Component)this.labelVlrTipo, tipo);
        ++tipo.gridx;
        tipo.fill = 17;
        tipo.weightx = 0.0;
        tipo.insets = new Insets(0, 1, 0, 1);
        ++bagLayout.gridx;
        bagLayout.insets = new Insets(0, 0, 0, 1);
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.gridwidth = 6;
        this.painelCentral.add((Component)panelTipo, bagLayout);
    }

    private void ocultaCampos() {
        this.labelVlrDataNcf.setVisible(false);
        this.panelLote.setVisible(false);
    }

    private void addLinhaTabelaRequisicao(RequisicaoVO requisicaoVO) {
        this.modeloRequisicao.addLine(new Object[]{requisicaoVO.getCodigo(), requisicaoVO.getPaciente().getNome(), requisicaoVO});
    }

    private void addLinhaTabelaSetor(SetorNaoConformidadeVO setorVO) {
        this.modeloSetores.addLine(new Object[]{setorVO.getSetor().getCodigo(), setorVO.getSetor().getDescricao(), setorVO.getCodResponsavelSetor(), this.montaUsuariosNotificados(setorVO.getNaoConformidadeUsuarioBeansTemp()), setorVO.getSetor(), setorVO.getNaoConformidadeUsuarioBeansTemp()});
    }

    private String montaUsuariosNotificados(List<SetorNaoConformidadeUsuarioBean> naoConformidadeUsuarioBeansTemp) {
        StringBuilder retorno = new StringBuilder();
        if (naoConformidadeUsuarioBeansTemp != null) {
            for (SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean : naoConformidadeUsuarioBeansTemp) {
                retorno.append(setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo());
                retorno.append(", ");
            }
            if (retorno.length() > 0) {
                return retorno.toString().substring(0, retorno.length() - 2);
            }
        }
        return "";
    }

    private void criaDescricaoNcf(GridBagConstraints bagLayout) {
        ++bagLayout.gridy;
        bagLayout.weighty = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 13;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 2;
        JScrollPane jScrollPane = new JScrollPane(this.textAreaDescricao);
        jScrollPane.setPreferredSize(new Dimension(40, 100));
        jScrollPane.setMinimumSize(new Dimension(40, 100));
        this.panelNcf.add((Component)jScrollPane, bagLayout);
    }

    private void criaLinhaSetor() {
        GridBagConstraints bagLayout = new GridBagConstraints();
        bagLayout.insets = new Insets(1, 0, 0, 1);
        bagLayout.gridy = 0;
        bagLayout.gridx = 0;
        bagLayout.gridwidth = 4;
        bagLayout.fill = 1;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        this.scrollPaneSetor.setPreferredSize(new Dimension(20, 20));
        this.scrollPaneSetor.setMinimumSize(new Dimension(20, 20));
        this.panelSetor.add((Component)this.scrollPaneSetor, bagLayout);
    }

    private void criaPainelSetor(GridBagConstraints bagLayout) {
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        bagLayout.fill = 1;
        bagLayout.gridwidth = 13;
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.anchor = 17;
        bagConstraints.fill = 1;
        bagConstraints.weightx = 1.0;
        bagConstraints.weighty = 1.0;
        bagLayout.gridwidth = 13;
        this.panelLoteSetor.add((Component)this.panelSetor, bagConstraints);
        this.panelNcf.add((Component)this.panelLoteSetor, bagLayout);
    }

    private void criaPainelNcf(GridBagConstraints bagLayout) {
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.fill = 1;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        if (!Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            bagLayout.gridwidth = 9;
        }
        bagLayout.gridwidth = 12;
        this.painelCentral.add((Component)this.panelNcf, bagLayout);
    }

    private void criaLinhaCodigo(GridBagConstraints bagLayout) {
        bagLayout.fill = 0;
        bagLayout.insets = new Insets(1, 0, 0, 1);
        bagLayout.gridx = 0;
        bagLayout.gridy = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.anchor = 17;
        this.painelCentral.add((Component)this.labelCodigo, bagLayout);
        ++bagLayout.gridx;
        this.labelVlrCodigo.setPreferredSize(new Dimension(99, 20));
        this.labelVlrCodigo.setMinimumSize(new Dimension(99, 20));
        bagLayout.gridwidth = 2;
        this.painelCentral.add((Component)this.labelVlrCodigo, bagLayout);
        bagLayout.gridwidth = 1;
        bagLayout.gridx += 2;
        bagLayout.insets = !Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia()) ? new Insets(1, 0, 0, 1) : new Insets(1, 20, 0, 1);
        bagLayout.insets = new Insets(1, 20, 0, 1);
        this.painelCentral.add((Component)this.labelData, bagLayout);
        ++bagLayout.gridx;
        this.textData.setPreferredSize(new Dimension(90, 20));
        this.textData.setMinimumSize(new Dimension(90, 20));
        bagLayout.insets = new Insets(1, 0, 0, 1);
        this.painelCentral.add((Component)this.textData, bagLayout);
        ++bagLayout.gridx;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 2;
        this.painelCentral.add((Component)new JLabel(), bagLayout);
        bagLayout.weightx = 0.0;
        bagLayout.fill = 0;
        ++bagLayout.gridx;
        bagLayout.insets = new Insets(1, 20, 0, 1);
        this.painelCentral.add((Component)this.labelUsuario, bagLayout);
        bagLayout.insets = new Insets(1, 0, 0, 1);
        ++bagLayout.gridx;
        this.labelVlrUsuario.setPreferredSize(new Dimension(100, 20));
        this.labelVlrUsuario.setMinimumSize(new Dimension(100, 20));
        bagLayout.insets = new Insets(1, 1, 0, 3);
        this.painelCentral.add((Component)this.labelVlrUsuario, bagLayout);
        bagLayout.insets = new Insets(1, 0, 0, 1);
    }

    private void criaLinhaProcedencia(GridBagConstraints bagLayout) {
        if (!Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            bagLayout.fill = 0;
            bagLayout.gridx = 0;
            ++bagLayout.gridy;
            bagLayout.weightx = 0.0;
            bagLayout.insets = new Insets(0, 0, 0, 1);
            this.painelCentral.add((Component)this.labelProcedencia, bagLayout);
            ++bagLayout.gridx;
            this.textCodProcedencia.setPreferredSize(new Dimension(99, 20));
            this.textCodProcedencia.setMinimumSize(new Dimension(99, 20));
            this.painelCentral.add((Component)this.textCodProcedencia, bagLayout);
            bagLayout.insets = new Insets(0, 0, 0, 3);
            ++bagLayout.gridx;
            bagLayout.weightx = 1.0;
            bagLayout.fill = 2;
            bagLayout.weighty = 0.0;
            bagLayout.gridwidth = 5;
            this.labelVlrDescProcedencia.setMinimumSize(new Dimension(80, 20));
            this.labelVlrDescProcedencia.setPreferredSize(new Dimension(80, 20));
            this.painelCentral.add((Component)this.labelVlrDescProcedencia, bagLayout);
        }
        bagLayout.fill = 13;
        bagLayout.anchor = 13;
        bagLayout.gridx += 3;
        bagLayout.weightx = 0.0;
        this.checkboxUrgente.setPreferredSize(new Dimension(100, 22));
        this.checkboxUrgente.setMinimumSize(new Dimension(100, 22));
        this.painelCentral.add((Component)this.checkboxUrgente, bagLayout);
    }

    private void criaLinhaAdicional(GridBagConstraints bagLayout) {
        bagLayout.weightx = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 1;
        bagLayout.anchor = 17;
        bagLayout.insets = new Insets(0, 0, 0, 1);
        this.painelCentral.add((Component)this.labelAdicional, bagLayout);
        ++bagLayout.gridx;
        bagLayout.gridwidth = 8;
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.insets = new Insets(0, 0, 1, 2);
        this.textDescAdicional.setMinimumSize(new Dimension(50, 20));
        this.textDescAdicional.setPreferredSize(new Dimension(50, 20));
        this.painelCentral.add((Component)this.textDescAdicional, bagLayout);
    }

    private void criaLinhaRequisicao(GridBagConstraints bagLayout) {
        bagLayout.gridx = 0;
        bagLayout.gridy = 0;
        bagLayout.weighty = 1.0;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 1;
        this.scrollPaneRequisicao.setPreferredSize(new Dimension(20, 20));
        this.scrollPaneRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.scrollPaneRequisicao, bagLayout);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1300200100");
    }

    public void visualizar() {
        final JDialog visDialog = new JDialog();
        visDialog.add(this);
        visDialog.setResizable(false);
        visDialog.setPreferredSize(new Dimension(770, 580));
        visDialog.setMinimumSize(new Dimension(770, 580));
        visDialog.setTitle("Visualizando detalhes da n\u00e3o conformidade");
        visDialog.setModal(true);
        this.painelCrud.removeAll();
        this.painelOpcoes.removeAll();
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                visDialog.dispose();
            }
        });
        this.painelCrud.add(this.botaoFechar);
        visDialog.setLocationRelativeTo(Laboratorio.getInstancia());
        visDialog.setVisible(true);
        visDialog.pack();
    }

    private void limparCampos(boolean b) {
        this.textAreaDescricao.setText("");
        this.textCodProcedencia.setText("");
        this.textCodOrigem.setText("");
        this.textData.setText("");
        this.labelVlrDataNcf.setText("");
        this.textDescAdicional.setText("");
        this.labelVlrCodigo.setText("");
        this.labelVlrDescProcedencia.setText("");
        this.labelVlrDescSetor.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrOrigem.setText("");
        this.textCodTipo.setText("");
        this.labelVlrTipo.setText("");
        this.modeloSetores.clear();
        this.modeloRequisicao.clear();
        this.checkboxUrgente.setSelected(false);
        this.naoConformidadeBean = null;
    }

    @Override
    protected void controlaCampos() {
        this.textAreaDescricao.setEditable(this.habilitaDesabilitaCampo());
        this.checkboxUrgente.setEnabled(this.habilitaDesabilitaCampo());
        this.linhaAdicionalVisivel(false);
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void limparCampos() {
        this.zerarObjetos();
        this.limparCampos(true);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    private void zerarObjetos() {
        this.procedenciaVo = null;
        this.setorVO = null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return this.naoConformidadeBean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean != null) {
            NaoConformidadeBean naoConformidadeBean = (NaoConformidadeBean)bean;
            this.procedenciaVo = naoConformidadeBean.getProcedenciaNaoConformidade();
            this.materialVO = naoConformidadeBean.getMaterial();
            this.notaFiscalVO = naoConformidadeBean.getNotaFiscal();
            this.entidadeVO = naoConformidadeBean.getFornecedor();
            this.origemNaoConformidadeVO = naoConformidadeBean.getOrigemNaoConformidade();
            this.labelVlrCodigo.setText(naoConformidadeBean.getCodigo().toString());
            this.textData.setText(Funcoes.formataData(naoConformidadeBean.getNcfData()));
            this.labelVlrUsuario.setText(this.getCodUser(naoConformidadeBean));
            this.textCodProcedencia.setText(this.getCodProcedencia(naoConformidadeBean));
            this.labelVlrDescProcedencia.setText(this.getDescricaoProcedencia(naoConformidadeBean));
            this.textDescAdicional.setText(naoConformidadeBean.getAdicional());
            this.checkboxUrgente.setSelected(naoConformidadeBean.getUrgente());
            if (naoConformidadeBean.getProcedenciaNaoConformidade() != null) {
                this.linhaAdicionalVisivel(naoConformidadeBean.getProcedenciaNaoConformidade().getSolicitarDescricao());
            } else {
                this.linhaAdicionalVisivel(false);
            }
            for (RequisicaoVO reqVo : naoConformidadeBean.getRequisicaoVos()) {
                if (reqVo == null) continue;
                this.addLinhaTabelaRequisicao(reqVo);
            }
            this.textCodOrigem.setText(this.getCodOrigem(naoConformidadeBean));
            this.labelVlrOrigem.setText(this.getDescOrigem(naoConformidadeBean));
            this.textCodTipo.setText(naoConformidadeBean.getTipoNaoConformidade() != null ? naoConformidadeBean.getTipoNaoConformidade().getCodigo().toString() : "");
            this.labelVlrTipo.setText(naoConformidadeBean.getTipoNaoConformidade() != null ? naoConformidadeBean.getTipoNaoConformidade().getDescricao() : "");
            for (SetorNaoConformidadeVO setorVO : naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if (setorVO == null) continue;
                this.addLinhaTabelaSetor(setorVO);
            }
            this.textAreaDescricao.setText(naoConformidadeBean.getDescricao());
        }
    }

    private String getCodProcedencia(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getProcedenciaNaoConformidade() != null) {
            return naoConformidadeBean.getProcedenciaNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getCodUser(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getUsuario() != null) {
            return naoConformidadeBean.getUsuario().getCodigo();
        }
        return "";
    }

    private String getCodOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getDescOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getDescricao();
        }
        return "";
    }

    private String getDescricaoProcedencia(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getProcedenciaNaoConformidade() != null) {
            return naoConformidadeBean.getProcedenciaNaoConformidade().getDescricao();
        }
        return "";
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void linhaAdicionalVisivel(boolean visivel) {
        if (visivel) {
            if (Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
                this.labelAdicional.setVisible(false);
                this.textDescAdicional.setVisible(false);
                return;
            }
        }
        this.labelAdicional.setVisible(visivel);
        this.textDescAdicional.setVisible(visivel);
    }

    public static long getModuloAcessoOcultarProcedencia() {
        return Long.valueOf(OCULTA_PROCEDENCIA);
    }

    public static long getModuloAcessoOcultarOrigem() {
        return Long.valueOf(OCULTA_ORIGEM);
    }

    public static long acessoOcultarDetalhe() {
        return Long.valueOf(OCULTA_DETALHE);
    }

    private void ocultaProcedencia() {
        if (Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            this.labelProcedencia.setVisible(false);
            this.labelVlrDescProcedencia.setVisible(false);
            this.textCodProcedencia.setVisible(false);
            this.labelAdicional.setVisible(false);
            this.textDescAdicional.setVisible(false);
        } else {
            this.labelProcedencia.setVisible(true);
            this.labelVlrDescProcedencia.setVisible(true);
            this.textCodProcedencia.setVisible(true);
            this.labelAdicional.setVisible(true);
            this.textDescAdicional.setVisible(true);
        }
    }
}

