/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.cadastro.SetorNaoConformidadeBean;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.service.cadastro.SetorNaoConformidadeService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class DetalheCritica
extends AbstractDialogoOKCancelar {
    private SetorNaoConformidadeVO setorNaoConformidadeVO = null;
    private SetorNaoConformidadeService setorNaoConformidadeService = new SetorNaoConformidadeService();
    private JTextArea textAreaDescricao = new JTextArea();
    private JScrollPane jScrollPaneDescricao = new JScrollPane(this.textAreaDescricao);
    private JLabel labelDataAnalise = new JLabel();
    private JLabel labelVlerSetor = new JLabel();

    public DetalheCritica(Dialog pai, String titulo, SetorNaoConformidadeVO resultado) {
        super(pai, titulo);
        this.setorNaoConformidadeVO = resultado;
        this.montarTela();
        this.setLocationRelativeTo(pai);
    }

    private void montarTela() {
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        this.setResizable(false);
        this.setModal(true);
        this.setSize(new Dimension(500, 400));
        GridBagConstraints layoutPrincipal = new GridBagConstraints();
        layoutPrincipal.fill = 17;
        layoutPrincipal.insets = new Insets(1, 1, 0, 1);
        layoutPrincipal.gridx = 0;
        layoutPrincipal.gridy = 0;
        layoutPrincipal.weightx = 0.0;
        layoutPrincipal.weighty = 0.0;
        layoutPrincipal.anchor = 17;
        this.textAreaDescricao.setWrapStyleWord(true);
        this.textAreaDescricao.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textAreaDescricao);
        ScreenUtil.posicionaTextoTopo(this.textAreaDescricao);
        this.textAreaDescricao.setEditable(false);
        this.getPanelCentral().add((Component)new JLabel("An\u00e1lise:"), layoutPrincipal);
        this.labelDataAnalise.setBorder(new TitledBorder(""));
        this.labelDataAnalise.setPreferredSize(new Dimension(100, 20));
        this.labelDataAnalise.setMinimumSize(new Dimension(100, 20));
        ++layoutPrincipal.gridx;
        this.getPanelCentral().add((Component)this.labelDataAnalise, layoutPrincipal);
        layoutPrincipal.insets = new Insets(1, 20, 0, 1);
        ++layoutPrincipal.gridx;
        this.getPanelCentral().add((Component)new JLabel("Setor:"), layoutPrincipal);
        layoutPrincipal.insets = new Insets(1, 1, 0, 1);
        this.labelVlerSetor.setBorder(new TitledBorder(""));
        this.labelVlerSetor.setPreferredSize(new Dimension(400, 20));
        this.labelVlerSetor.setMinimumSize(new Dimension(400, 20));
        ++layoutPrincipal.gridx;
        this.getPanelCentral().add((Component)this.labelVlerSetor, layoutPrincipal);
        layoutPrincipal.gridx = 0;
        ++layoutPrincipal.gridy;
        layoutPrincipal.fill = 1;
        layoutPrincipal.gridwidth = 4;
        layoutPrincipal.weightx = 1.0;
        layoutPrincipal.weighty = 1.0;
        this.getPanelCentral().add((Component)this.jScrollPaneDescricao, layoutPrincipal);
        this.getBotaoCancelar().setVisible(false);
        this.setUsuarioPodeCancelar(false);
        if (this.setorNaoConformidadeVO != null && this.setorNaoConformidadeVO.getFilial() != null && this.setorNaoConformidadeVO.getNaoConformidade() != null) {
            try {
                if (this.setorNaoConformidadeVO.getCodigo() == null) {
                    return;
                }
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", this.setorNaoConformidadeVO.getFilial().getCodigo());
                chaves.put("nac_codigo", this.setorNaoConformidadeVO.getNaoConformidade().getCodigo());
                chaves.put("sna_codigo", this.setorNaoConformidadeVO.getCodigo());
                SetorNaoConformidadeBean setorNaoConformidadeBean = (SetorNaoConformidadeBean)this.setorNaoConformidadeService.getBean(chaves);
                if (setorNaoConformidadeBean != null) {
                    this.labelDataAnalise.setText(Funcoes.formataData(setorNaoConformidadeBean.getDataAnaliseUsuario()));
                    this.textAreaDescricao.setText(setorNaoConformidadeBean.getCritica());
                    this.labelVlerSetor.setText(setorNaoConformidadeBean.getSetor().getDescricao());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar setor n\u00e3o conformidade.", e.getStackTrace());
            }
        }
    }

    public DetalheCritica(Frame pai, String titulo, SetorNaoConformidadeVO resultado) {
        super(pai, titulo);
        this.setorNaoConformidadeVO = resultado;
        this.montarTela();
        this.setLocationRelativeTo(pai);
    }
}

