/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.qualidade.naoconformidade.InfoAbrirNaoConformidade;
import jalis.mensagens.NovaMensagem;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.NaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.vo.cadastro.NaoConformidadeVO;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.cadastro.AcoesNaoConformidadeService;
import jalis.service.cadastro.AnalisarNaoConformidadeService;
import jalis.service.cadastro.NaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeUsuarioService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class AnalisarNaoConformidade
extends FrmCadPadraoBean
implements ActionListener,
ListSelectionListener,
FocusListener {
    private static final int POSICAO_SETOR_NCF = 3;
    private static final int POSICAO_SETOR_USUARIO_NCF = 4;
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelCodEnvolvido = new JLabel("Usu\u00e1rio:");
    private JLabel labelTipo = new JLabel("Tipo:");
    private JLabel labelVlrData = new JLabel();
    private TTextField textCodEnvolvido = new TTextField(20, 3);
    private JLabel labelVlrUsr = new JLabel();
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelVlrEnvolvido = new JLabel();
    private JLabel labelVlrTipo = new JLabel();
    private JTextArea textAreaDescricao = new JTextArea();
    private JTextArea textAreaCritica = new JTextArea();
    private JButton buttonAddEnvolvido = ComponenteFactory.novoJButton("OK", 'K', this);
    private JButton buttonConfirmaCritica = ComponenteFactory.novoJButton("Salvar cr\u00edtica", 'M', this);
    private JButton buttonData = ComponenteFactory.novoJButton(this, true);
    private JButton buttonPesquisaEnvolvido = ComponenteFactory.novoJButton(this, true);
    private JButton buttonVisualizarNcf = new JButton();
    private ModeloGridTable modeloSetor = new ModeloGridTable(new String[]{"C\u00f3digo", "Decri\u00e7\u00e3o", "An\u00e1lise"});
    private JTable tableSetor = ComponenteFactory.novoJTable((TableModel)this.modeloSetor, (ListSelectionListener)this, 80, 0, 125);
    private JScrollPane scrollPaneSetor = new JScrollPane(this.tableSetor);
    private ModeloGridTable modeloEnvolvido = new ModeloGridTable(new String[]{"C\u00f3digo", "Nome", "Notificado", "Leitura"});
    private JTable tableEnvolvido = new JTable(this.modeloEnvolvido);
    private JScrollPane scrollPaneEnvovido = new JScrollPane(this.tableEnvolvido);
    private NaoConformidadeService naoConformidadeService = new NaoConformidadeService();
    private AnalisarNaoConformidadeService analisarNaoConformidadeService = new AnalisarNaoConformidadeService();
    private NaoConformidadeBean naoConformidadeBean = new NaoConformidadeBean();
    private UsuarioService usuarioService = new UsuarioService();
    private SetorNaoConformidadeUsuarioService setorNaoConformidadeUsuarioService = new SetorNaoConformidadeUsuarioService();
    private UsuarioMensagemService usuarioMensagemService = new UsuarioMensagemService();
    private SetorNaoConformidadeService setorNaoConformidadeService = new SetorNaoConformidadeService();
    private NaoConformidadeVO naoConformidadeVO;
    private UsuarioVO notificado;
    private AcoesNaoConformidadeService acoesNaoConformidadeService = new AcoesNaoConformidadeService();
    private String codigoUsuarioSelecionado;
    private static final String ASSUNTO_NCF_NAO_URGENTE = "N\u00e3o conformidade aberta.";
    private static final String ASSUNTO_NCF_URGENTE = "URGENTE, n\u00e3o conformidade aberta.";

    public String getCodigoUsuarioSelecionado() {
        return this.codigoUsuarioSelecionado;
    }

    public AnalisarNaoConformidade() {
        try {
            this.montarTela();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montarTela() {
        this.jbInit();
        this.setModuloInsere(Long.valueOf("1300200101"));
        this.setModuloEdita(Long.valueOf("1300200102"));
        this.setModuloApaga(Long.valueOf("1300200103"));
    }

    @Override
    public void excluir() {
        this.naoConformidadeBean = (NaoConformidadeBean)this.pesquisar();
        if (this.naoConformidadeBean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnalisarNaoConformidade.this.preencherCampos(AnalisarNaoConformidade.this.naoConformidadeBean);
                    if (Funcoes.mensagem(AnalisarNaoConformidade.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            AnalisarNaoConformidade.this.naoConformidadeBean.setSituacao("A");
                            AnalisarNaoConformidade.this.naoConformidadeBean.setAnalise(null);
                            AnalisarNaoConformidade.this.naoConformidadeBean.setNcfDataAnalise(null);
                            AnalisarNaoConformidade.this.naoConformidadeBean.setNcfDataHoraAnalise(null);
                            AnalisarNaoConformidade.this.naoConformidadeBean.setUsuarioAnalise(null);
                            AnalisarNaoConformidade.this.naoConformidadeService.update(AnalisarNaoConformidade.this.naoConformidadeBean, Variaveis.filialPadrao);
                            for (SetorNaoConformidadeVO vo : AnalisarNaoConformidade.this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                                if (vo.getNaoConformidadeUsuarioBeansTemp() == null) continue;
                                for (SetorNaoConformidadeUsuarioBean setorUser : vo.getNaoConformidadeUsuarioBeansTemp()) {
                                    for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                                        AnalisarNaoConformidade.this.usuarioMensagemService.delete(mensagemBean, mensagemBean.getCodigo(), Variaveis.filialPadrao, AnalisarNaoConformidade.this.getCopiaFiliais());
                                    }
                                }
                            }
                            Conexao.arquivaSQL();
                            for (SetorNaoConformidadeVO vo : AnalisarNaoConformidade.this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                                if (vo.getNaoConformidadeUsuarioBeansTemp() != null) {
                                    for (SetorNaoConformidadeUsuarioBean setorUser : vo.getNaoConformidadeUsuarioBeansTemp()) {
                                        if (setorUser.getUsuarioVO().getCodigo().equalsIgnoreCase(vo.getCodResponsavelSetor())) continue;
                                        AnalisarNaoConformidade.this.setorNaoConformidadeUsuarioService.deletePorUser(setorUser, setorUser.getUsuarioVO().getCodigo());
                                    }
                                }
                                vo.setCritica("");
                                vo.setDataAnaliseUsuario(null);
                                AnalisarNaoConformidade.this.setorNaoConformidadeService.update(vo, vo.getCodigo(), Variaveis.filialPadrao, AnalisarNaoConformidade.this.getCopiaFiliais());
                            }
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir an\u00e1lise.\n" + e.getMessage(), 2);
                        }
                    }
                    AnalisarNaoConformidade.this.limparCampos();
                    AnalisarNaoConformidade.this.naoConformidadeBean = null;
                }
            });
        }
    }

    private void jbInit() {
        this.painelCentral.setLayout(new GridBagLayout());
        this.setIcone(ImagemUtils.carregaImagemJalis("qualidade/qualidade_analisar_nc.jpg"));
        this.setLabelFormulario("Analisar n\u00e3o conformidade");
        this.setLabelDescricao("Analisar n\u00e3o conformidade");
        this.buttonVisualizarNcf.setText("+");
        this.buttonVisualizarNcf.setToolTipText("Visualizar detalhes da n\u00e3o conformidade");
        this.buttonVisualizarNcf.addActionListener(this);
        this.modeloEnvolvido.setColumnSize(new int[]{80, 0, 125, 125}, this.tableEnvolvido);
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrUsr, this.labelVlrCodigo, this.labelVlrEnvolvido, this.labelVlrData, this.labelVlrTipo}, new TitledBorder(""));
        this.textAreaDescricao.setWrapStyleWord(true);
        this.textAreaDescricao.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textAreaDescricao);
        ScreenUtil.posicionaTextoTopo(this.textAreaDescricao);
        this.textAreaDescricao.setEditable(false);
        JScrollPane jScrollPaneDescricao = new JScrollPane(this.textAreaDescricao);
        this.textAreaCritica.setWrapStyleWord(true);
        this.textAreaCritica.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textAreaCritica);
        ScreenUtil.posicionaTextoTopo(this.textAreaCritica);
        JScrollPane jScrollPaneCritica = new JScrollPane(this.textAreaCritica);
        GridBagConstraints layoutPrincipal = new GridBagConstraints();
        layoutPrincipal.fill = 2;
        layoutPrincipal.insets = new Insets(1, 2, 0, 1);
        layoutPrincipal.gridx = 0;
        layoutPrincipal.gridy = 0;
        layoutPrincipal.weightx = 0.0;
        layoutPrincipal.weighty = 0.0;
        layoutPrincipal.anchor = 17;
        GridBagConstraints layout = new GridBagConstraints();
        layout.fill = 2;
        layout.insets = new Insets(1, 0, 0, 1);
        layout.gridx = 0;
        layout.gridy = 0;
        layout.weightx = 0.0;
        layout.weighty = 0.0;
        layout.anchor = 17;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.labelCodigo, layout);
        layout.insets = new Insets(1, 1, 0, 1);
        ++layout.gridx;
        this.labelVlrCodigo.setPreferredSize(new Dimension(100, 20));
        this.labelVlrCodigo.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.labelVlrCodigo, layout);
        layout.insets = new Insets(1, 20, 0, 1);
        ++layout.gridx;
        panel.add((Component)this.labelData, layout);
        layout.insets = new Insets(1, 1, 0, 0);
        ++layout.gridx;
        this.labelVlrData.setMinimumSize(new Dimension(100, 20));
        this.labelVlrData.setPreferredSize(new Dimension(100, 20));
        panel.add((Component)this.labelVlrData, layout);
        layout.insets = new Insets(1, 0, 0, 1);
        ++layout.gridx;
        this.buttonData.setVisible(false);
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        panel.add((Component)this.buttonData, layout);
        layout.insets = new Insets(1, 20, 0, 1);
        ++layout.gridx;
        panel.add((Component)this.labelUsuario, layout);
        layout.insets = new Insets(1, 1, 0, 1);
        ++layout.gridx;
        this.labelVlrUsr.setMinimumSize(new Dimension(120, 20));
        this.labelVlrUsr.setPreferredSize(new Dimension(120, 20));
        panel.add((Component)this.labelVlrUsr, layout);
        layout.insets = new Insets(1, 20, 0, 1);
        ++layout.gridx;
        panel.add((Component)this.labelTipo, layout);
        layout.insets = new Insets(1, 1, 0, 1);
        ++layout.gridx;
        this.labelVlrTipo.setMinimumSize(new Dimension(150, 20));
        this.labelVlrTipo.setPreferredSize(new Dimension(150, 20));
        panel.add((Component)this.labelVlrTipo, layout);
        if (!Acesso.getAcesso(this.getModuloAcessoOcultaDetalhe())) {
            ++layout.gridx;
            this.buttonVisualizarNcf.setPreferredSize(new Dimension(20, 20));
            this.buttonVisualizarNcf.setMinimumSize(new Dimension(20, 20));
            this.buttonVisualizarNcf.setMargin(new Insets(0, 0, 0, 0));
            panel.add((Component)this.buttonVisualizarNcf, layout);
        }
        this.painelCentral.add((Component)panel, layoutPrincipal);
        layoutPrincipal.insets = new Insets(1, 0, 0, 1);
        layoutPrincipal.fill = 2;
        ++layoutPrincipal.gridx;
        layoutPrincipal.weightx = 1.0;
        this.painelCentral.add((Component)new JLabel(), layoutPrincipal);
        layoutPrincipal.fill = 2;
        layoutPrincipal.insets = new Insets(1, 0, 0, 1);
        layoutPrincipal.gridx = 0;
        ++layoutPrincipal.gridy;
        layoutPrincipal.weightx = 0.0;
        layoutPrincipal.weighty = 0.0;
        layoutPrincipal.anchor = 17;
        JPanel panelNcf = new JPanel(new BorderLayout());
        panelNcf.setBorder(new TitledBorder("Descri\u00e7\u00e3o n\u00e3o conformidade"));
        panelNcf.add(jScrollPaneDescricao);
        ++layoutPrincipal.gridy;
        layoutPrincipal.fill = 1;
        layoutPrincipal.gridx = 0;
        layoutPrincipal.weightx = 1.0;
        layoutPrincipal.weighty = 1.0;
        layoutPrincipal.gridwidth = 2;
        this.painelCentral.add((Component)panelNcf, layoutPrincipal);
        JPanel panelSetoresEnvolvidos = new JPanel(new GridBagLayout());
        panelSetoresEnvolvidos.setBorder(new TitledBorder("Setores envolvidos"));
        GridBagConstraints layoutSetEnvolvido = new GridBagConstraints();
        layoutSetEnvolvido.insets = new Insets(1, 0, 0, 1);
        layoutSetEnvolvido.gridx = 0;
        layoutSetEnvolvido.gridy = 0;
        layoutSetEnvolvido.anchor = 17;
        layoutSetEnvolvido.weightx = 1.0;
        layoutSetEnvolvido.weighty = 1.0;
        layoutSetEnvolvido.fill = 1;
        this.scrollPaneSetor.setPreferredSize(new Dimension(100, 100));
        panelSetoresEnvolvidos.add((Component)this.scrollPaneSetor, layoutSetEnvolvido);
        ++layoutPrincipal.gridy;
        layoutPrincipal.fill = 1;
        layoutPrincipal.gridx = 0;
        layoutPrincipal.weighty = 1.0;
        layoutPrincipal.weightx = 1.0;
        layoutPrincipal.gridwidth = 2;
        this.painelCentral.add((Component)panelSetoresEnvolvidos, layoutPrincipal);
        JPanel envolvidos = new JPanel(new GridBagLayout());
        envolvidos.setBorder(new TitledBorder("Usu\u00e1rios envolvidos"));
        GridBagConstraints layoutEnvolvidos = new GridBagConstraints();
        layoutEnvolvidos.gridy = 0;
        layoutEnvolvidos.fill = 2;
        layoutEnvolvidos.gridx = 0;
        layoutEnvolvidos.weighty = 0.0;
        layoutEnvolvidos.weightx = 0.0;
        layoutEnvolvidos.insets = layout.insets = new Insets(1, 1, 0, 1);
        this.labelCodEnvolvido.setDisplayedMnemonic('o');
        this.labelCodEnvolvido.setLabelFor(this.textCodEnvolvido);
        envolvidos.add((Component)this.labelCodEnvolvido, layoutEnvolvidos);
        layoutEnvolvidos.insets = layout.insets = new Insets(1, 0, 0, 0);
        ++layoutEnvolvidos.gridx;
        this.textCodEnvolvido.setMinimumSize(new Dimension(100, 20));
        this.textCodEnvolvido.setPreferredSize(new Dimension(100, 20));
        envolvidos.add((Component)this.textCodEnvolvido, layoutEnvolvidos);
        layoutEnvolvidos.insets = layout.insets = new Insets(1, 0, 0, 0);
        ++layoutEnvolvidos.gridx;
        this.buttonPesquisaEnvolvido.setMinimumSize(new Dimension(20, 20));
        this.buttonPesquisaEnvolvido.setPreferredSize(new Dimension(20, 20));
        envolvidos.add((Component)this.buttonPesquisaEnvolvido, layoutEnvolvidos);
        layoutEnvolvidos.fill = 2;
        layoutEnvolvidos.weightx = 1.0;
        layoutEnvolvidos.insets = layout.insets = new Insets(1, 1, 0, 0);
        this.labelVlrEnvolvido.setPreferredSize(new Dimension(100, 20));
        this.labelVlrEnvolvido.setMinimumSize(new Dimension(100, 20));
        ++layoutEnvolvidos.gridx;
        envolvidos.add((Component)this.labelVlrEnvolvido, layoutEnvolvidos);
        layoutEnvolvidos.insets = layout.insets = new Insets(1, 1, 0, 1);
        layoutEnvolvidos.weightx = 0.0;
        layoutEnvolvidos.insets = layout.insets = new Insets(1, 1, 0, 0);
        ++layoutEnvolvidos.gridx;
        this.buttonAddEnvolvido.setMinimumSize(new Dimension(40, 20));
        this.buttonAddEnvolvido.setPreferredSize(new Dimension(40, 20));
        envolvidos.add((Component)this.buttonAddEnvolvido, layoutEnvolvidos);
        ++layoutEnvolvidos.gridy;
        layoutEnvolvidos.gridx = 0;
        layoutEnvolvidos.gridwidth = 5;
        layoutEnvolvidos.weightx = 1.0;
        layoutEnvolvidos.weighty = 1.0;
        layoutEnvolvidos.fill = 1;
        envolvidos.add((Component)this.scrollPaneEnvovido, layoutEnvolvidos);
        ++layoutPrincipal.gridy;
        layoutPrincipal.fill = 1;
        layoutPrincipal.gridx = 0;
        layoutPrincipal.weighty = 1.0;
        layoutPrincipal.weightx = 1.0;
        layoutPrincipal.gridwidth = 2;
        this.painelCentral.add((Component)envolvidos, layoutPrincipal);
        JPanel critica = new JPanel(new GridBagLayout());
        critica.setBorder(new TitledBorder("Cr\u00edtica"));
        GridBagConstraints layoutcritica = new GridBagConstraints();
        layoutcritica.gridy = 0;
        layoutcritica.gridx = 0;
        layoutcritica.insets = layout.insets = new Insets(1, 1, 0, 1);
        layoutcritica.weighty = 1.0;
        layoutcritica.weightx = 1.0;
        layoutcritica.fill = 1;
        critica.add((Component)jScrollPaneCritica, layoutcritica);
        ++layoutPrincipal.gridy;
        layoutPrincipal.fill = 1;
        layoutPrincipal.gridx = 0;
        layoutPrincipal.weightx = 1.0;
        layoutPrincipal.weighty = 1.0;
        layoutPrincipal.gridwidth = 2;
        this.painelCentral.add((Component)critica, layoutPrincipal);
        ++layoutPrincipal.gridy;
        layoutPrincipal.fill = 2;
        layoutPrincipal.weightx = 1.0;
        layoutPrincipal.weighty = 0.0;
        layoutPrincipal.gridwidth = 2;
        layoutPrincipal.insets = new Insets(0, 0, 0, 0);
        JPanel salvarCritica = new JPanel(new FlowLayout(2));
        this.buttonConfirmaCritica.setPreferredSize(new Dimension(100, 25));
        salvarCritica.add(this.buttonConfirmaCritica);
        this.painelCentral.add((Component)salvarCritica, layoutPrincipal);
        this.labelVlrData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarNaoConformidade.this.buttonData.doClick();
                }
            }
        });
        this.textCodEnvolvido.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarNaoConformidade.this.pesquisaEnvolvido();
                }
            }
        });
        this.textAreaCritica.addFocusListener(this);
        this.tableEnvolvido.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(AnalisarNaoConformidade.this.painelCentral, "Deseja remover o notificado da composi\u00e7\u00e3o?", 4)) == 0) {
                    AnalisarNaoConformidade.this.modeloEnvolvido.removeLine(row);
                    AnalisarNaoConformidade.this.getSetorSelecionado().getNaoConformidadeUsuarioBeans().clear();
                    for (int i = 0; i < AnalisarNaoConformidade.this.modeloEnvolvido.getRowCount(); ++i) {
                        SetorNaoConformidadeUsuarioBean bean = (SetorNaoConformidadeUsuarioBean)AnalisarNaoConformidade.this.modeloEnvolvido.getValueAt(i, 4);
                        AnalisarNaoConformidade.this.getSetorSelecionado().getNaoConformidadeUsuarioBeans().add(bean);
                    }
                }
            }
        });
        this.textCodEnvolvido.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(AnalisarNaoConformidade.this.textCodEnvolvido.getText())) {
                        AnalisarNaoConformidade.this.notificado = (UsuarioVO)AnalisarNaoConformidade.this.usuarioService.getVO(Variaveis.filialPadrao, AnalisarNaoConformidade.this.textCodEnvolvido.getText());
                        if (AnalisarNaoConformidade.this.notificado != null) {
                            AnalisarNaoConformidade.this.textCodEnvolvido.setText(AnalisarNaoConformidade.this.notificado.getCodigo());
                            AnalisarNaoConformidade.this.labelVlrEnvolvido.setText(AnalisarNaoConformidade.this.notificado.getNome());
                        } else {
                            AnalisarNaoConformidade.this.labelVlrEnvolvido.setText("N\u00e3o cadastrado");
                            AnalisarNaoConformidade.this.textCodEnvolvido.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AnalisarNaoConformidade.this.painelCentral, "N\u00e3o foi poss\u00edvel consultar proced\u00eancia.", 1);
                }
            }
        });
        this.controlaCampos();
    }

    private void pesquisaEnvolvido() {
        this.notificado = (UsuarioVO)this.usuarioService.pesquisaVO(Laboratorio.getInstancia(), new UsuarioVO(), "Pesquisando usu\u00e1rios notificados", false);
        if (this.notificado != null) {
            this.codigoUsuarioSelecionado = this.notificado.getCodigo();
            this.labelVlrEnvolvido.setText(this.notificado.getNome());
            this.textCodEnvolvido.setText(this.notificado.getCodigo());
        } else {
            this.labelVlrEnvolvido.setText("");
            this.textCodEnvolvido.setText("");
            this.notificado = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.buttonData) {
            if (e.getSource() == this.buttonPesquisaEnvolvido) {
                this.pesquisaEnvolvido();
            } else if (e.getSource() == this.buttonAddEnvolvido) {
                this.addEnvolvido();
            } else if (e.getSource() == this.buttonConfirmaCritica) {
                if (Funcoes.textoVazio(this.textAreaCritica.getText())) {
                    Funcoes.mensagem(this, "Cr\u00edtica n\u00e3o informada.", 2);
                    ScreenUtil.requisitarFoco(this.textAreaCritica);
                    return;
                }
                if (!Funcoes.textoVazio(this.textAreaCritica.getText()) && this.textAreaCritica.getText().length() > 3000) {
                    Funcoes.mensagem(this, "A cr\u00edtica excede o limite de 3000 caracteres.", 2);
                    ScreenUtil.requisitarFoco(this.textAreaCritica);
                    return;
                }
                SetorNaoConformidadeVO setor = this.getSetorSelecionado();
                if (setor != null) {
                    setor.setCritica(this.textAreaCritica.getText());
                    setor.setDataAnaliseUsuario(Calendar.getInstance().getTime());
                    this.modeloSetor.setValueAt(setor.getSetor().getCodigo(), this.tableSetor.getSelectedRow(), 0);
                    this.modeloSetor.setValueAt(setor.getSetor().getDescricao(), this.tableSetor.getSelectedRow(), 1);
                    this.modeloSetor.setValueAt(Funcoes.formataData("dd/MM/yyyy", setor.getDataAnaliseUsuario()), this.tableSetor.getSelectedRow(), 2);
                    this.modeloSetor.setValueAt(setor, this.tableSetor.getSelectedRow(), 3);
                    Funcoes.mensagem(this, "Cr\u00edtica adicionada com sucesso para o setor " + this.getSetorSelecionado().getSetor().getDescricao() + ".", 2);
                }
            } else if (e.getSource() == this.buttonVisualizarNcf) {
                this.exibirDetalheNcf();
            }
        }
    }

    public static long getModuloAcessoOcultaDetalhe() {
        return 1300200404L;
    }

    private void exibirDetalheNcf() {
        InfoAbrirNaoConformidade abrirNaoConformidade = new InfoAbrirNaoConformidade(this.naoConformidadeBean);
        abrirNaoConformidade.visualizar();
    }

    private void addEnvolvido() {
        if (this.tableSetor.getSelectedRow() < 0) {
            Funcoes.mensagem(this, "Setor deve ser selecionado.", 2);
            return;
        }
        if (this.notificado != null) {
            if (this.modeloEnvolvido.localizar(0, this.notificado.getCodigo()) == -1) {
                SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean = new SetorNaoConformidadeUsuarioBean();
                setorNaoConformidadeUsuarioBean.setDataLeitura(null);
                setorNaoConformidadeUsuarioBean.setDataNotificado(Calendar.getInstance().getTime());
                setorNaoConformidadeUsuarioBean.setFilial(this.notificado.getFilial());
                setorNaoConformidadeUsuarioBean.setNaoConformidade(this.naoConformidadeVO);
                setorNaoConformidadeUsuarioBean.setSetorNaoConformidadeVO(this.getSetorSelecionado());
                setorNaoConformidadeUsuarioBean.setUsuarioVO(this.notificado);
                this.modeloEnvolvido.addLine(new Object[]{setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo(), setorNaoConformidadeUsuarioBean.getUsuarioVO().getNome(), null, null, setorNaoConformidadeUsuarioBean});
                if (this.getSetorSelecionado() != null) {
                    this.getSetorSelecionado().getNaoConformidadeUsuarioBeans().add(setorNaoConformidadeUsuarioBean);
                }
                this.notificado = null;
                this.textCodEnvolvido.clear();
                this.labelVlrEnvolvido.setText("");
                ScreenUtil.requisitarFoco(this.textCodEnvolvido);
            } else {
                this.textCodEnvolvido.clear();
                this.labelVlrEnvolvido.setText("");
                ScreenUtil.requisitarFoco(this.textCodEnvolvido);
            }
        }
    }

    @Override
    protected void controlaCampos() {
        this.textAreaCritica.setEnabled(this.habilitaDesabilitaCampo());
        this.textAreaDescricao.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodEnvolvido.setEnabled(this.habilitaDesabilitaCampo());
        this.labelVlrData.setEnabled(this.habilitaDesabilitaCampo());
        this.labelVlrCodigo.setEnabled(this.habilitaDesabilitaCampo());
        this.labelVlrEnvolvido.setEnabled(this.habilitaDesabilitaCampo());
        this.labelVlrUsr.setEnabled(this.habilitaDesabilitaCampo());
        this.labelVlrTipo.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddEnvolvido.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonConfirmaCritica.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonData.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonPesquisaEnvolvido.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonVisualizarNcf.setEnabled(this.habilitaDesabilitaCampo());
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void limparCampos() {
        this.modeloEnvolvido.clear();
        this.modeloSetor.clear();
        this.textAreaCritica.setText("");
        this.textAreaDescricao.setText("");
        this.textCodEnvolvido.clear();
        this.labelVlrData.setText("");
        this.labelVlrCodigo.setText("");
        this.labelVlrEnvolvido.setText("");
        this.labelVlrUsr.setText(Variaveis.login);
        this.labelVlrTipo.setText("");
        this.labelVlrData.setText(Funcoes.formataData(Calendar.getInstance().getTime()));
    }

    @Override
    public void novo() {
        super.novo();
        this.naoConformidadeBean = (NaoConformidadeBean)this.pesquisarNcf();
        if (this.naoConformidadeBean != null) {
            this.labelVlrCodigo.setText(this.naoConformidadeBean.getCodigo().toString());
            this.textAreaDescricao.setText(this.naoConformidadeBean.getDescricao());
            this.labelVlrTipo.setText(this.naoConformidadeBean.getTipoNaoConformidade() != null ? this.naoConformidadeBean.getTipoNaoConformidade().getDescricao() : "");
            for (SetorNaoConformidadeVO setorNaoConformidadeVO : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if (!setorNaoConformidadeVO.getCodResponsavelSetor().equalsIgnoreCase(Variaveis.login) && !this.usuarioLogadoEstaEnvolvido(setorNaoConformidadeVO)) continue;
                this.modeloSetor.addLine(new Object[]{setorNaoConformidadeVO.getSetor().getCodigo(), setorNaoConformidadeVO.getSetor().getDescricao(), Funcoes.formataData("dd/MM/yyyy", setorNaoConformidadeVO.getDataAnaliseUsuario()), setorNaoConformidadeVO});
            }
            if (this.modeloSetor.getRowCount() > 0) {
                this.tableSetor.getSelectionModel().setSelectionInterval(0, 0);
                this.textAreaCritica.setEditable(true);
                this.textCodEnvolvido.setEnabled(true);
                this.buttonPesquisaEnvolvido.setEnabled(true);
                this.buttonAddEnvolvido.setEnabled(true);
                if (this.getSetorSelecionado() != null) {
                    this.textAreaCritica.setText(this.getSetorSelecionado().getCritica());
                }
            } else {
                this.textAreaCritica.setEditable(false);
                this.textCodEnvolvido.setEnabled(false);
                this.buttonPesquisaEnvolvido.setEnabled(false);
                this.buttonAddEnvolvido.setEnabled(false);
            }
        } else {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private AbstractThreadBean pesquisarNcf() {
        try {
            this.naoConformidadeVO = (NaoConformidadeVO)this.analisarNaoConformidadeService.pesquisaVOAnaliseNcf(this.getTopLevelAncestor(), new NaoConformidadeVO(), "Pesquisando n\u00e3o conformidades", false, "A");
            if (this.naoConformidadeVO != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", this.naoConformidadeVO.getFilial().getCodigo());
                chaves.put("nac_codigo", this.naoConformidadeVO.getCodigo());
                this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
                if (this.naoConformidadeBean.getSetorNaoConformidadeVOs().isEmpty() && this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp() != null) {
                    for (SetorNaoConformidadeVO setorNaoConformidadeVO : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                        if (setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp() == null) continue;
                        for (SetorNaoConformidadeUsuarioBean b : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp()) {
                            setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans().add(b);
                        }
                    }
                }
                return this.naoConformidadeBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            this.naoConformidadeVO = (NaoConformidadeVO)this.analisarNaoConformidadeService.pesquisaVOAnaliseNcf(this.getTopLevelAncestor(), new NaoConformidadeVO(), "Pesquisando n\u00e3o conformidades", false, "L");
            if (this.naoConformidadeVO != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", this.naoConformidadeVO.getFilial().getCodigo());
                chaves.put("nac_codigo", this.naoConformidadeVO.getCodigo());
                chaves.put("nac_situacao", "L");
                this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
                if (this.naoConformidadeBean.getSetorNaoConformidadeVOs().isEmpty()) {
                    for (SetorNaoConformidadeVO setorNaoConformidadeVO : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                        if (setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp() == null) continue;
                        for (SetorNaoConformidadeUsuarioBean b : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp()) {
                            setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans().add(b);
                        }
                    }
                }
                return this.naoConformidadeBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        this.naoConformidadeBean = (NaoConformidadeBean)bean;
        if (this.naoConformidadeBean != null) {
            this.textAreaDescricao.setText(this.naoConformidadeBean.getDescricao());
        }
        if (this.naoConformidadeBean != null) {
            this.labelVlrCodigo.setText(this.naoConformidadeBean.getCodigo().toString());
            this.textAreaDescricao.setText(this.naoConformidadeBean.getDescricao());
            this.labelVlrTipo.setText(this.naoConformidadeBean.getTipoNaoConformidade() != null ? this.naoConformidadeBean.getTipoNaoConformidade().getDescricao() : "");
            for (SetorNaoConformidadeVO setorNaoConformidadeVO : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if (!setorNaoConformidadeVO.getCodResponsavelSetor().equalsIgnoreCase(Variaveis.login) && !this.usuarioLogadoEstaEnvolvido(setorNaoConformidadeVO)) continue;
                this.modeloSetor.addLine(new Object[]{setorNaoConformidadeVO.getSetor().getCodigo(), setorNaoConformidadeVO.getSetor().getDescricao(), Funcoes.formataData("dd/MM/yyyy", setorNaoConformidadeVO.getDataAnaliseUsuario()), setorNaoConformidadeVO});
            }
            if (this.modeloSetor.getRowCount() > 0) {
                this.tableSetor.getSelectionModel().setSelectionInterval(0, 0);
                this.textAreaCritica.setEditable(true);
                this.textCodEnvolvido.setEnabled(true);
                this.buttonPesquisaEnvolvido.setEnabled(true);
                this.buttonAddEnvolvido.setEnabled(true);
                if (this.getSetorSelecionado() != null) {
                    this.textAreaCritica.setText(this.getSetorSelecionado().getCritica());
                }
            } else {
                this.textAreaCritica.setEditable(false);
                this.textCodEnvolvido.setEnabled(false);
                this.buttonPesquisaEnvolvido.setEnabled(false);
                this.buttonAddEnvolvido.setEnabled(false);
            }
        } else {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    private boolean usuarioLogadoEstaEnvolvido(SetorNaoConformidadeVO setorNaoConformidadeVO) {
        String logado = Variaveis.login;
        for (SetorNaoConformidadeUsuarioBean bean : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans()) {
            if (!bean.getUsuarioVO().getCodigo().equals(logado)) continue;
            return true;
        }
        if (setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp() != null) {
            for (SetorNaoConformidadeUsuarioBean bean : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp()) {
                if (!bean.getUsuarioVO().getCodigo().equals(logado)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SetorNaoConformidadeVO setorNaoConformidadeVO;
        this.modeloEnvolvido.clear();
        if (this.tableSetor.getSelectedRow() > -1 && (setorNaoConformidadeVO = this.getSetorSelecionado()) != null) {
            if (setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans() != null && !setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans().isEmpty()) {
                for (SetorNaoConformidadeUsuarioBean conformidadeUsuarioBean : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans()) {
                    this.modeloEnvolvido.addLine(new Object[]{conformidadeUsuarioBean.getUsuarioVO().getCodigo(), conformidadeUsuarioBean.getUsuarioVO().getDescricao(), Funcoes.formataData("dd/MM/yyyy HH:mm", conformidadeUsuarioBean.getDataNotificado()), Funcoes.formataData("dd/MM/yyyy HH:mm", conformidadeUsuarioBean.getDataLeitura()), conformidadeUsuarioBean});
                }
            }
            this.textAreaCritica.setText(setorNaoConformidadeVO.getCritica());
        }
    }

    private SetorNaoConformidadeVO getSetorSelecionado() {
        if (this.tableSetor.getSelectedRow() >= 0) {
            return (SetorNaoConformidadeVO)this.modeloSetor.getValueAt(this.tableSetor.getSelectedRow(), 3);
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource().equals(this.textAreaCritica) && !Funcoes.textoVazio(this.textAreaCritica.getText()) && this.textAreaCritica.getText().length() > 3000) {
            Funcoes.mensagem(this, "A cr\u00edtica excede o limite de 3000 caracteres.", 2);
            ScreenUtil.requisitarFoco(this.textAreaCritica);
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource().equals(this.textAreaCritica) && !Funcoes.textoVazio(this.textAreaCritica.getText()) && this.textAreaCritica.getText().length() > 3000) {
            Funcoes.mensagem(this, "A cr\u00edtica excede o limite de 3000 caracteres.", 2);
            ScreenUtil.requisitarFoco(this.textAreaCritica);
            return;
        }
    }

    @Override
    public void salvar() {
        try {
            boolean criticaEncontrada = false;
            if (!Funcoes.textoVazio(this.textAreaCritica.getText())) {
                for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
                    SetorNaoConformidadeVO voTable = (SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, 3);
                    if (Funcoes.textoVazio(voTable.getCritica()) || !voTable.getCritica().equalsIgnoreCase(this.textAreaCritica.getText())) continue;
                    criticaEncontrada = true;
                }
                if (!criticaEncontrada) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "A cr\u00edtica deve ser salva.", 2);
                    ScreenUtil.requisitarFoco(this.buttonConfirmaCritica);
                    return;
                }
            }
            String assuntoMsg = ASSUNTO_NCF_NAO_URGENTE;
            if (this.naoConformidadeBean.getUrgente().booleanValue()) {
                assuntoMsg = ASSUNTO_NCF_URGENTE;
            }
            StringBuilder setorSemCritica = new StringBuilder();
            for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
                SetorNaoConformidadeVO voTable = (SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, 3);
                if (!Funcoes.textoVazio(voTable.getCritica())) continue;
                setorSemCritica.append(voTable.getSetor().getCodigo()).append(" - ");
                setorSemCritica.append(voTable.getSetor().getDescricao()).append("\n");
            }
            Set<String> usuariosNotificar = this.getUsuarioNotificar();
            for (SetorNaoConformidadeVO setorVo : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if ((setorVo == null || !setorVo.getCodResponsavelSetor().equalsIgnoreCase(Variaveis.login)) && !this.usuarioLogadoEstaEnvolvido(setorVo) || setorVo.getNaoConformidadeUsuarioBeans() == null || setorVo.getNaoConformidadeUsuarioBeansTemp() == null) continue;
                for (SetorNaoConformidadeUsuarioBean setorUser : setorVo.getNaoConformidadeUsuarioBeansTemp()) {
                    for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                        this.usuarioMensagemService.delete(mensagemBean, mensagemBean.getCodigo(), Variaveis.filialPadrao, this.getCopiaFiliais());
                    }
                }
            }
            for (SetorNaoConformidadeVO vo : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if ((vo == null || !vo.getCodResponsavelSetor().equalsIgnoreCase(Variaveis.login)) && !this.usuarioLogadoEstaEnvolvido(vo) || vo.getNaoConformidadeUsuarioBeansTemp() == null) continue;
                for (SetorNaoConformidadeUsuarioBean beanSetorUser : vo.getNaoConformidadeUsuarioBeansTemp()) {
                    this.setorNaoConformidadeUsuarioService.delete(beanSetorUser, Variaveis.filialPadrao);
                }
            }
            for (SetorNaoConformidadeVO setorVo : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if ((setorVo == null || !setorVo.getCodResponsavelSetor().equalsIgnoreCase(Variaveis.login)) && !this.usuarioLogadoEstaEnvolvido(setorVo)) continue;
                for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
                    SetorNaoConformidadeVO voTable = (SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, 3);
                    if (!voTable.getSetor().getCodigo().equals(setorVo.getSetor().getCodigo())) continue;
                    setorVo.setCritica(voTable.getCritica());
                    setorVo.setDataAnaliseUsuario(voTable.getDataAnaliseUsuario());
                    break;
                }
                this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(setorVo, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                if (setorVo.getNaoConformidadeUsuarioBeans() == null || setorVo.getNaoConformidadeUsuarioBeans().isEmpty()) continue;
                for (SetorNaoConformidadeUsuarioBean setorUser : setorVo.getNaoConformidadeUsuarioBeans()) {
                    setorUser.setSetorNaoConformidadeVO(setorVo);
                    setorUser.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
                    setorUser.setFilial(this.naoConformidadeBean.getFilial());
                    this.setorNaoConformidadeUsuarioService.insert(setorUser, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                        mensagemBean.setSetorNaoConformidadeVO(setorVo);
                        this.usuarioMensagemService.insert(mensagemBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    }
                    if (!usuariosNotificar.contains(setorUser.getUsuarioVO().getCodigo())) continue;
                    Statement st = Conexao.getStatement();
                    NovaMensagem.enviarMensagemNcf(Conexao.getStatement(), Variaveis.login, setorUser.getUsuarioVO().getCodigo(), assuntoMsg, "N\u00e3o conformidade com o c\u00f3digo " + this.naoConformidadeBean.getCodigo() + " adicionada sobre sua responsabilidade.", false, this.naoConformidadeBean.getFilial().getCodigo(), this.naoConformidadeBean.getCodigo(), setorUser.getSetorNaoConformidadeVO().getCodigo(), setorUser.getUsuarioVO().getCodigo());
                    st.close();
                }
            }
            this.naoConformidadeBean.setSituacao("L");
            this.naoConformidadeService.update(this.naoConformidadeBean, Variaveis.filialPadrao);
            Conexao.arquivaSQL();
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private Set<String> getUsuarioNotificar() {
        HashSet<String> usuariosNotificar = new HashSet<String>();
        for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
            SetorNaoConformidadeVO setorNcfBean = (SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, 3);
            if (setorNcfBean.getNaoConformidadeUsuarioBeans() != null && !setorNcfBean.getNaoConformidadeUsuarioBeans().isEmpty()) {
                for (SetorNaoConformidadeUsuarioBean setorUser : setorNcfBean.getNaoConformidadeUsuarioBeans()) {
                    if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(this.naoConformidadeBean.getCodigo(), setorUser.getUsuarioVO().getCodigo())) continue;
                    usuariosNotificar.add(setorUser.getUsuarioVO().getCodigo());
                }
            } else if (setorNcfBean.getNaoConformidadeUsuarioBeansTemp() != null && !setorNcfBean.getNaoConformidadeUsuarioBeansTemp().isEmpty()) {
                for (SetorNaoConformidadeUsuarioBean setorUser : setorNcfBean.getNaoConformidadeUsuarioBeansTemp()) {
                    if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(this.naoConformidadeBean.getCodigo(), setorUser.getUsuarioVO().getCodigo())) continue;
                    usuariosNotificar.add(setorUser.getUsuarioVO().getCodigo());
                }
            }
            if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(this.naoConformidadeBean.getCodigo(), setorNcfBean.getCodResponsavelSetor())) continue;
            usuariosNotificar.add(setorNcfBean.getCodResponsavelSetor());
        }
        return usuariosNotificar;
    }

    public static long getModuloAcesso() {
        return 1300200400L;
    }
}

