/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.qualidade.naoconformidade.AbrirNaoConformidade;
import jalis.laboratorio.qualidade.naoconformidade.DescricaoAnaliseAcao;
import jalis.laboratorio.qualidade.naoconformidade.DetalheCritica;
import jalis.laboratorio.qualidade.naoconformidade.InfoAnalisarNaoConformidade;
import jalis.laboratorio.qualidade.naoconformidade.UsuarioNotificado;
import jalis.laboratorio.relatorios.qualidade.ImprimirNaoConformidade;
import jalis.mensagens.NovaMensagem;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.AcoesNaoConformidadeBean;
import jalis.model.bean.cadastro.NaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.bean.cadastro.TipoNaoConformidadeBean;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.AcaoNaoConformidadeVO;
import jalis.model.vo.cadastro.AcoesNaoConformidadeVO;
import jalis.model.vo.cadastro.NaoConformidadeVO;
import jalis.model.vo.cadastro.OrigemNaoConformidadeVO;
import jalis.model.vo.cadastro.ProcedenciaNaoConformidadeVO;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.model.vo.cadastro.TipoNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.AcaoNaoConformidadeService;
import jalis.service.cadastro.AcoesNaoConformidadeService;
import jalis.service.cadastro.NaoConformidadeService;
import jalis.service.cadastro.OrigemNaoConformidadeService;
import jalis.service.cadastro.ProcedenciaNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeUsuarioService;
import jalis.service.cadastro.TipoNaoConformidadeService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;

public class AnalisarAcao
extends FrmCadPadraoBean
implements ActionListener {
    private static final long OCULTA_PROCEDENCIA = 105000107L;
    private static final long OCULTA_ORIGEM = 105000108L;
    private static final String COLUNA_RESP = "Resp.";
    private static final String COLUNA_NOTIFICADO = "Notificado";
    private static final String COLUNA_CRITICA = "Cr\u00edtica";
    private static final String COLUNA_DESCRICAO = "Descri\u00e7\u00e3o";
    private static final String COLUNA_DESCRICAO_ANALISE_ACAO = "Descri\u00e7\u00e3o An\u00e1lise";
    private static final String COLUNA_CODIGO = "C\u00f3digo";
    private static final int COLUNA_ACAO = 3;
    private static final Integer COLUNA_SETOR = 5;
    private static final Integer COLUNA_SETOR_NCF = 8;
    private static final Integer OBJETO_CRITICA = 4;
    private JLabel labelLeitura = new JLabel("Leitura:");
    private JLabel labelCodigoNcf = new JLabel("C\u00f3digo:");
    private JLabel labelCodigoVlrNcf = new JLabel();
    private JLabel labelDataNcf = new JLabel("Data:");
    private JLabel labelDataVlrNcf = new JLabel();
    private JLabel labelUserNcf = new JLabel("Usu\u00e1rio:");
    private JLabel labelUserVlrNcf = new JLabel();
    private JLabel labelDataAnaliseNcf = new JLabel("Data an\u00e1lise:");
    private JLabel labelUserAnaliseNcf = new JLabel("Usu\u00e1rio an\u00e1lise:");
    private JLabel labelUserAnaliseVlrNcf = new JLabel();
    private JLabel labelRespAnalise = new JLabel("Respons\u00e1vel:");
    private JLabel labelRespAnaliseVlr = new JLabel();
    private JLabel labelSetorAnaliseVlr = new JLabel();
    private JLabel labelDescSetor = new JLabel();
    private JLabel labelDescAcao = new JLabel();
    private JLabel labelProcedencia = new JLabel("Proced\u00eancia:");
    private JLabel labelVlrDescProcedencia = new JLabel();
    private JLabel labelAdicional = new JLabel("Adicional:");
    private JLabel labelResponsavelSetor = new JLabel();
    private JLabel labelVlrDescSetor = new JLabel();
    private JLabel labelNotificado = new JLabel("Notificado:");
    private JLabel labelVlrNotificado = new JLabel();
    private JLabel labelOrigem = new JLabel("Origem:");
    private JLabel labelVlrOrigem = new JLabel();
    private JLabel labelVlrLeitura = new JLabel();
    private JLabel labelVlrTipo = new JLabel();
    private TTextField textCodOrigem = new TTextField(12, 1);
    private TTextField textCodTipo = new TTextField(12, 1);
    private TTextField textoDataAnaliseNcf = new TTextField(10, 4);
    private TTextField textoAcaoAnaliseNcf = new TTextField(10, 1);
    private TTextField textCodSetor = new TTextField(10, 1);
    private TTextField textoDescricaoAcao = new TTextField(100, 3);
    private TTextField textoAnaliseAcao = new TTextField(1000, 3);
    private TTextField textoCodAcao = new TTextField(10, 1);
    private TTextField textCodProcedencia = new TTextField(9, 1);
    private TTextField textDescAdicional = new TTextField(100);
    private JTextArea textoAnalise = new JTextArea();
    private JButton buttonTipo = ComponenteFactory.novoJButton(this, true);
    private JButton buttonOrigem = ComponenteFactory.novoJButton(this, true);
    private JButton buttonProcedencia = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataAnalise = ComponenteFactory.novoJButton(this, true);
    private JButton buttonPesqSetor = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddSetor = ComponenteFactory.novoJButton("OK", 'K', this);
    private JButton buttonDetalhes = ComponenteFactory.novoJButton("Detalhes", 'D', this);
    private JButton buttonPesqAcao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddAcao = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonVisualizarNcf = new JButton();
    private JButton buttonSetor = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscarNotificado = ComponenteFactory.novoJButton("...", this);
    private ModeloGridTable modeloSetor = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Resp.", "Notificado", "Cr\u00edtica"});
    private JTable tableSetor = new JTable(this.modeloSetor){

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == OBJETO_CRITICA) {
                return Set.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == OBJETO_CRITICA;
        }
    };
    private JScrollPane scrollPaneSetor = new JScrollPane(this.tableSetor);
    private ModeloGridTable modeloAcao = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Descri\u00e7\u00e3o An\u00e1lise"});
    private JTable tableAcao = new JTable(this.modeloAcao);
    private JScrollPane scrollPaneAcao = new JScrollPane(this.tableAcao);
    private JCheckBox checkBoxComprometimento = new JCheckBox("Comprometimento");
    private JPanel panelProcedencia = new JPanel(new GridBagLayout());
    private JPanel panelSetor = new JPanel(new GridBagLayout());
    private JPanel panelAcao = new JPanel(new GridBagLayout());
    private JPanel panelAnalise = new JPanel(new GridBagLayout());
    private JPanel jPanelLinha2 = new JPanel(new GridBagLayout());
    private SetorVO setorVO = new SetorVO();
    private AcaoNaoConformidadeVO acaoNaoConformidadeVO = new AcaoNaoConformidadeVO();
    private SetorService setorService = new SetorService();
    private AcaoNaoConformidadeService acaoNaoConformidadeService = new AcaoNaoConformidadeService();
    private NaoConformidadeService naoConformidadeService = new NaoConformidadeService();
    private NaoConformidadeBean naoConformidadeBean = new NaoConformidadeBean();
    private AcoesNaoConformidadeService acoesNaoConformidadeService = new AcoesNaoConformidadeService();
    private SetorNaoConformidadeService setorNaoConformidadeService = new SetorNaoConformidadeService();
    private ProcedenciaNaoConformidadeService serviceProcedencia = new ProcedenciaNaoConformidadeService();
    private UsuarioVO usuarioVOLogado = null;
    private ProcedenciaNaoConformidadeVO procedenciaVo = null;
    private OrigemNaoConformidadeVO origemNaoConformidadeVO = null;
    private OrigemNaoConformidadeService origemNaoConformidadeService = new OrigemNaoConformidadeService();
    private TipoNaoConformidadeVO tipoNaoConformidadeVO = null;
    private TipoNaoConformidadeService tipoService = new TipoNaoConformidadeService();
    private UsuarioNotificado jDialogNotificados = UsuarioNotificado.novaInstancia(this.getTopLevelAncestor(), this.labelVlrNotificado);
    private SetorNaoConformidadeUsuarioService setorNaoConformidadeUsuarioService = new SetorNaoConformidadeUsuarioService();
    private UsuarioMensagemService usuarioMensagemService = new UsuarioMensagemService();
    private boolean editandoSetor = false;
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel painelCrud = new JPanel(new FlowLayout());
    private JButton buttonImprimir = new JButton("Imprimir");
    private static final String ASSUNTO_NCF_NAO_URGENTE = "N\u00e3o conformidade aberta.";
    private static final String ASSUNTO_NCF_URGENTE = "URGENTE, n\u00e3o conformidade aberta.";
    private JLabel labelTipo = new JLabel("Tipo:");

    public AnalisarAcao() {
        try {
            this.jbInit(false);
            this.controlaCampos();
            this.setModuloInsere(Long.valueOf("1300200201"));
            this.setModuloEdita(Long.valueOf("1300200202"));
            this.setModuloApaga(Long.valueOf("1300200203"));
            this.usuarioVOLogado = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, Variaveis.login);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void jbInit(boolean bloquear) {
        this.setLabelFormulario("Analisar a\u00e7\u00e3o");
        this.setLabelDescricao("Analisar a\u00e7\u00e3o");
        this.painelCentral.setLayout(new GridBagLayout());
        this.setIcone(ImagemUtils.carregaImagemJalis("qualidade/qualidade_analisar_acao.jpg"));
        ScreenUtil.setBorda(new JComponent[]{this.labelResponsavelSetor, this.labelVlrOrigem, this.labelVlrNotificado, this.labelVlrDescProcedencia, this.labelCodigoVlrNcf, this.labelDescAcao, this.labelDataVlrNcf, this.labelUserVlrNcf, this.labelUserAnaliseVlrNcf, this.labelDescSetor, this.labelVlrLeitura, this.labelVlrTipo}, new TitledBorder(""));
        Funcoes.imagemPesquisa(this.buttonDataAnalise);
        this.panelSetor.setBorder(new TitledBorder("Setores Envolvidos"));
        this.panelAcao.setBorder(new TitledBorder("A\u00e7\u00f5es"));
        this.panelAnalise.setBorder(new TitledBorder("An\u00e1lise Geral"));
        this.modeloSetor.setColumnSize(new int[]{50, 0, 150, 0, 50}, this.tableSetor);
        this.modeloAcao.setColumnSize(new int[]{80, 0, 0}, this.tableAcao);
        this.buttonVisualizarNcf.setText("+");
        this.buttonVisualizarNcf.setToolTipText("Visualizar detalhes da n\u00e3o conformidade");
        this.buttonVisualizarNcf.addActionListener(this);
        this.tableSetor.getTableHeader().addMouseListener(this.modeloSetor);
        ButtonEditor buttonEditor = new ButtonEditor();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        this.tableSetor.setDefaultRenderer(Set.class, buttonRenderer);
        this.tableSetor.setDefaultEditor(Set.class, buttonEditor);
        this.textoAnalise.setWrapStyleWord(true);
        this.textoAnalise.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textoAnalise);
        ScreenUtil.posicionaTextoTopo(this.textoAnalise);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 0, 0, 1);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.criaLinhaTopo(gridBagConstraints);
        this.criaTipo(gridBagConstraints);
        this.criaOrigem(gridBagConstraints);
        this.criaPainelProcedencia(gridBagConstraints);
        this.criaPainelAnalise(gridBagConstraints);
        this.criaPainelAcao(gridBagConstraints);
        this.criaPainelSetor(gridBagConstraints);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelOpcoes.add(this.buttonImprimir);
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)this.painelCrud, "East");
        this.painelCrud.add(this.botaoNovo);
        this.painelCrud.add(this.botaoEditar);
        this.painelCrud.add(this.botaoSalvar);
        this.painelCrud.add(this.botaoCancelar);
        this.painelCrud.add(this.botaoExcluir);
        this.painelCrud.add(this.botaoFechar);
        this.buttonImprimir.setMnemonic('R');
        this.buttonImprimir.setVisible(Acesso.getAcesso(ImprimirNaoConformidade.getModuloAcesso()));
        this.addListener(bloquear);
    }

    private void criaTipo(GridBagConstraints bagLayout) {
        bagLayout.weightx = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 1;
        bagLayout.anchor = 13;
        bagLayout.insets = new Insets(0, 0, 0, 0);
        this.labelTipo.setPreferredSize(new Dimension(77, 20));
        this.labelTipo.setMinimumSize(new Dimension(77, 20));
        this.painelCentral.add((Component)this.labelTipo, bagLayout);
        JPanel panelTipo = new JPanel(new GridBagLayout());
        GridBagConstraints tipo = new GridBagConstraints();
        tipo.fill = 13;
        tipo.insets = new Insets(0, 0, 0, 0);
        tipo.anchor = 13;
        tipo.gridx = 0;
        tipo.gridy = 0;
        this.textCodTipo.setPreferredSize(new Dimension(99, 20));
        this.textCodTipo.setMinimumSize(new Dimension(50, 20));
        panelTipo.add((Component)this.textCodTipo, tipo);
        ++tipo.gridx;
        tipo.insets = new Insets(0, 0, 0, 0);
        this.buttonTipo.setPreferredSize(new Dimension(20, 20));
        this.buttonTipo.setMinimumSize(new Dimension(20, 20));
        panelTipo.add((Component)this.buttonTipo, tipo);
        tipo.insets = new Insets(0, 1, 0, 0);
        ++tipo.gridx;
        tipo.weightx = 1.0;
        tipo.fill = 2;
        this.labelVlrTipo.setPreferredSize(new Dimension(20, 20));
        this.labelVlrTipo.setMinimumSize(new Dimension(20, 20));
        panelTipo.add((Component)this.labelVlrTipo, tipo);
        ++bagLayout.gridx;
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.gridwidth = 5;
        bagLayout.insets = new Insets(0, 0, 0, 3);
        this.painelCentral.add((Component)panelTipo, bagLayout);
    }

    private void criaOrigem(GridBagConstraints bagLayout) {
        if (!Acesso.getAcesso(AnalisarAcao.getModuloAcessoOcultarOrigem())) {
            bagLayout.weightx = 0.0;
            bagLayout.gridx = 0;
            ++bagLayout.gridy;
            bagLayout.gridwidth = 1;
            bagLayout.anchor = 13;
            bagLayout.insets = new Insets(0, 0, 0, 0);
            this.labelOrigem.setPreferredSize(new Dimension(77, 20));
            this.labelOrigem.setMinimumSize(new Dimension(77, 20));
            this.painelCentral.add((Component)this.labelOrigem, bagLayout);
            JPanel panelOrigem = new JPanel(new GridBagLayout());
            GridBagConstraints origem = new GridBagConstraints();
            origem.fill = 13;
            origem.insets = new Insets(0, 0, 0, 0);
            origem.anchor = 13;
            origem.gridx = 0;
            origem.gridy = 0;
            this.textCodOrigem.setPreferredSize(new Dimension(99, 20));
            this.textCodOrigem.setMinimumSize(new Dimension(50, 20));
            panelOrigem.add((Component)this.textCodOrigem, origem);
            ++origem.gridx;
            origem.insets = new Insets(0, 0, 0, 0);
            this.buttonOrigem.setPreferredSize(new Dimension(20, 20));
            this.buttonOrigem.setMinimumSize(new Dimension(20, 20));
            panelOrigem.add((Component)this.buttonOrigem, origem);
            origem.insets = new Insets(0, 1, 0, 0);
            ++origem.gridx;
            origem.weightx = 1.0;
            origem.fill = 2;
            this.labelVlrOrigem.setPreferredSize(new Dimension(20, 20));
            this.labelVlrOrigem.setMinimumSize(new Dimension(20, 20));
            panelOrigem.add((Component)this.labelVlrOrigem, origem);
            ++origem.gridx;
            origem.weightx = 0.0;
            origem.fill = 17;
            origem.insets = new Insets(1, 20, 0, 0);
            this.checkBoxComprometimento.setPreferredSize(new Dimension(200, 21));
            panelOrigem.add((Component)this.checkBoxComprometimento, origem);
            ++bagLayout.gridx;
            bagLayout.fill = 2;
            bagLayout.weightx = 1.0;
            bagLayout.gridwidth = 5;
            bagLayout.insets = new Insets(0, 0, 0, 3);
            this.painelCentral.add((Component)panelOrigem, bagLayout);
        }
    }

    private void criaPainelProcedencia(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.painelCentral.add((Component)this.panelProcedencia, gridBagConstraints);
        GridBagConstraints gridBagPanelProc = new GridBagConstraints();
        gridBagPanelProc.insets = new Insets(0, 0, 0, 1);
        gridBagPanelProc.gridy = 0;
        gridBagPanelProc.gridx = 0;
        gridBagPanelProc.weightx = 0.0;
        gridBagPanelProc.weighty = 0.0;
        gridBagPanelProc.fill = 17;
        gridBagPanelProc.anchor = 17;
        this.panelProcedencia.add((Component)new JLabel("Proced\u00eancia:"), gridBagPanelProc);
        gridBagPanelProc.insets = new Insets(0, 0, 0, 0);
        ++gridBagPanelProc.gridx;
        this.textCodProcedencia.setPreferredSize(new Dimension(99, 20));
        this.textCodProcedencia.setMinimumSize(new Dimension(99, 20));
        gridBagPanelProc.fill = 13;
        this.panelProcedencia.add((Component)this.textCodProcedencia, gridBagPanelProc);
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.insets = new Insets(0, 0, 0, 1);
        this.buttonProcedencia.setMinimumSize(new Dimension(20, 20));
        this.buttonProcedencia.setPreferredSize(new Dimension(20, 20));
        this.panelProcedencia.add((Component)this.buttonProcedencia, gridBagPanelProc);
        gridBagPanelProc.insets = new Insets(0, 0, 0, 4);
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.weightx = 1.0;
        gridBagPanelProc.fill = 2;
        this.labelVlrDescProcedencia.setMinimumSize(new Dimension(80, 19));
        this.labelVlrDescProcedencia.setPreferredSize(new Dimension(80, 19));
        this.panelProcedencia.add((Component)this.labelVlrDescProcedencia, gridBagPanelProc);
        gridBagPanelProc.insets = new Insets(0, 0, 0, 0);
        gridBagPanelProc.weightx = 0.0;
        gridBagPanelProc.fill = 13;
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.insets = new Insets(0, 20, 0, 4);
        this.panelProcedencia.add((Component)this.labelAdicional, gridBagPanelProc);
        ++gridBagPanelProc.gridx;
        gridBagPanelProc.weightx = 1.0;
        gridBagPanelProc.insets = new Insets(0, 0, 0, 1);
        gridBagPanelProc.fill = 2;
        this.textDescAdicional.setPreferredSize(new Dimension(100, 20));
        this.textDescAdicional.setMinimumSize(new Dimension(100, 20));
        this.panelProcedencia.add((Component)this.textDescAdicional, gridBagPanelProc);
        if (Acesso.getAcesso(AnalisarAcao.getModuloAcessoOcultarProcedencia())) {
            this.panelProcedencia.setVisible(false);
        }
    }

    private void criaPainelAnalise(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.textoAnalise);
        jScrollPane.setPreferredSize(new Dimension(40, 60));
        jScrollPane.setMinimumSize(new Dimension(40, 60));
        this.panelAnalise.add((Component)jScrollPane, gridBagConstraints);
        this.painelCentral.add((Component)this.panelAnalise, gridBagConstraints);
    }

    private void criaPainelSetor(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.painelCentral.add((Component)this.panelSetor, gridBagConstraints);
        GridBagConstraints gridBagPanelSetor = new GridBagConstraints();
        gridBagPanelSetor.insets = new Insets(1, 0, 0, 1);
        gridBagPanelSetor.gridy = 0;
        gridBagPanelSetor.gridx = 0;
        gridBagPanelSetor.weightx = 0.0;
        gridBagPanelSetor.weighty = 0.0;
        gridBagPanelSetor.fill = 0;
        gridBagPanelSetor.anchor = 17;
        gridBagPanelSetor.gridwidth = 1;
        this.panelSetor.add((Component)new JLabel("Setor:"), gridBagPanelSetor);
        ++gridBagPanelSetor.gridx;
        this.textCodSetor.setPreferredSize(new Dimension(80, 20));
        this.textCodSetor.setMinimumSize(new Dimension(80, 20));
        gridBagPanelSetor.insets = new Insets(1, 0, 0, 0);
        this.panelSetor.add((Component)this.textCodSetor, gridBagPanelSetor);
        ++gridBagPanelSetor.gridx;
        this.buttonPesqSetor.setPreferredSize(new Dimension(20, 20));
        this.buttonPesqSetor.setMinimumSize(new Dimension(20, 20));
        this.buttonPesqSetor.setFocusable(false);
        gridBagPanelSetor.insets = new Insets(1, 0, 0, 1);
        this.panelSetor.add((Component)this.buttonPesqSetor, gridBagPanelSetor);
        ++gridBagPanelSetor.gridx;
        gridBagPanelSetor.weightx = 1.0;
        gridBagPanelSetor.fill = 2;
        this.labelDescSetor.setPreferredSize(new Dimension(20, 20));
        this.labelDescSetor.setMinimumSize(new Dimension(20, 20));
        this.panelSetor.add((Component)this.labelDescSetor, gridBagPanelSetor);
        ++gridBagPanelSetor.gridx;
        gridBagPanelSetor.weightx = 0.0;
        gridBagPanelSetor.fill = 17;
        gridBagPanelSetor.insets = new Insets(1, 20, 0, 1);
        this.panelSetor.add((Component)this.labelLeitura, gridBagPanelSetor);
        gridBagPanelSetor.insets = new Insets(1, 0, 0, 1);
        ++gridBagPanelSetor.gridx;
        gridBagPanelSetor.weightx = 0.0;
        gridBagPanelSetor.insets = new Insets(1, 1, 0, 1);
        gridBagPanelSetor.fill = 17;
        this.labelVlrLeitura.setPreferredSize(new Dimension(135, 20));
        this.labelVlrLeitura.setMinimumSize(new Dimension(135, 20));
        this.panelSetor.add((Component)this.labelVlrLeitura, gridBagPanelSetor);
        JPanel jPanelResp = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagPanelResp = new GridBagConstraints();
        gridBagPanelResp.insets = new Insets(1, 0, 0, 1);
        gridBagPanelResp.gridy = 0;
        gridBagPanelResp.gridx = 0;
        gridBagPanelResp.weightx = 0.0;
        gridBagPanelResp.weighty = 0.0;
        gridBagPanelResp.fill = 0;
        gridBagPanelResp.anchor = 17;
        gridBagPanelResp.gridwidth = 1;
        jPanelResp.add((Component)new JLabel("Resp.:"), gridBagPanelResp);
        ++gridBagPanelResp.gridx;
        gridBagPanelResp.fill = 2;
        gridBagPanelResp.weightx = 1.0;
        this.labelResponsavelSetor.setPreferredSize(new Dimension(50, 20));
        this.labelResponsavelSetor.setMinimumSize(new Dimension(50, 20));
        jPanelResp.add((Component)this.labelResponsavelSetor, gridBagPanelResp);
        gridBagPanelResp.fill = 13;
        gridBagPanelResp.weightx = 0.0;
        gridBagPanelResp.insets = new Insets(0, 20, 0, 0);
        ++gridBagPanelResp.gridx;
        jPanelResp.add((Component)this.labelNotificado, gridBagPanelResp);
        gridBagPanelResp.insets = new Insets(0, 1, 0, 0);
        gridBagPanelResp.fill = 2;
        gridBagPanelResp.weightx = 1.0;
        ++gridBagPanelResp.gridx;
        this.labelVlrNotificado.setPreferredSize(new Dimension(100, 20));
        this.labelVlrNotificado.setMinimumSize(new Dimension(100, 20));
        jPanelResp.add((Component)this.labelVlrNotificado, gridBagPanelResp);
        gridBagPanelResp.fill = 13;
        gridBagPanelResp.weightx = 0.0;
        ++gridBagPanelResp.gridx;
        this.buttonBuscarNotificado.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscarNotificado.setMinimumSize(new Dimension(20, 20));
        jPanelResp.add((Component)this.buttonBuscarNotificado, gridBagPanelResp);
        ++gridBagPanelResp.gridx;
        this.buttonAddSetor.setPreferredSize(new Dimension(40, 20));
        this.buttonAddSetor.setMinimumSize(new Dimension(40, 20));
        jPanelResp.add((Component)this.buttonAddSetor, gridBagPanelResp);
        ++gridBagPanelSetor.gridy;
        gridBagPanelSetor.gridx = 0;
        gridBagPanelSetor.fill = 2;
        gridBagPanelSetor.gridwidth = 6;
        this.panelSetor.add((Component)jPanelResp, gridBagPanelSetor);
        ++gridBagPanelSetor.gridy;
        gridBagPanelSetor.gridx = 0;
        gridBagPanelSetor.gridwidth = 6;
        gridBagPanelSetor.fill = 1;
        gridBagPanelSetor.weightx = 1.0;
        gridBagPanelSetor.weighty = 1.0;
        this.scrollPaneSetor.setPreferredSize(new Dimension(20, 65));
        this.scrollPaneSetor.setMinimumSize(new Dimension(20, 65));
        this.panelSetor.add((Component)this.scrollPaneSetor, gridBagPanelSetor);
    }

    private void criaPainelAcao(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.painelCentral.add((Component)this.panelAcao, gridBagConstraints);
        GridBagConstraints gridBagPanelAcoes = new GridBagConstraints();
        gridBagPanelAcoes.insets = new Insets(1, 0, 0, 1);
        gridBagPanelAcoes.gridy = 0;
        gridBagPanelAcoes.gridx = 0;
        gridBagPanelAcoes.weightx = 0.0;
        gridBagPanelAcoes.weighty = 0.0;
        gridBagPanelAcoes.fill = 0;
        gridBagPanelAcoes.anchor = 17;
        gridBagPanelAcoes.gridwidth = 1;
        gridBagPanelAcoes.gridheight = 1;
        this.panelAcao.add((Component)new JLabel("A\u00e7\u00e3o"), gridBagPanelAcoes);
        gridBagPanelAcoes.insets = new Insets(1, 0, 0, 0);
        ++gridBagPanelAcoes.gridy;
        this.textoCodAcao.setPreferredSize(new Dimension(80, 20));
        this.textoCodAcao.setMinimumSize(new Dimension(80, 20));
        this.panelAcao.add((Component)this.textoCodAcao, gridBagPanelAcoes);
        gridBagPanelAcoes.insets = new Insets(1, 0, 0, 1);
        ++gridBagPanelAcoes.gridx;
        this.buttonPesqAcao.setPreferredSize(new Dimension(20, 20));
        this.buttonPesqAcao.setMinimumSize(new Dimension(20, 20));
        this.buttonPesqAcao.setFocusable(false);
        this.panelAcao.add((Component)this.buttonPesqAcao, gridBagPanelAcoes);
        ++gridBagPanelAcoes.gridx;
        gridBagPanelAcoes.weightx = 1.0;
        gridBagPanelAcoes.fill = 2;
        this.labelDescAcao.setPreferredSize(new Dimension(100, 20));
        this.labelDescAcao.setMinimumSize(new Dimension(100, 20));
        this.panelAcao.add((Component)this.labelDescAcao, gridBagPanelAcoes);
        gridBagPanelAcoes.weightx = 0.0;
        gridBagPanelAcoes.fill = 0;
        ++gridBagPanelAcoes.gridx;
        this.buttonAddAcao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddAcao.setMinimumSize(new Dimension(40, 20));
        this.panelAcao.add((Component)this.buttonAddAcao, gridBagPanelAcoes);
        ++gridBagPanelAcoes.gridy;
        gridBagPanelAcoes.gridx = 0;
        gridBagPanelAcoes.gridwidth = 4;
        gridBagPanelAcoes.fill = 1;
        gridBagPanelAcoes.weightx = 1.0;
        gridBagPanelAcoes.weighty = 1.0;
        this.scrollPaneAcao.setPreferredSize(new Dimension(20, 60));
        this.scrollPaneAcao.setMinimumSize(new Dimension(20, 60));
        this.panelAcao.add((Component)this.scrollPaneAcao, gridBagPanelAcoes);
        JPanel jPanelDetalhar = new JPanel(new FlowLayout(2, 0, 0));
        gridBagPanelAcoes.fill = 2;
        ++gridBagPanelAcoes.gridy;
        gridBagPanelAcoes.weightx = 1.0;
        gridBagPanelAcoes.weighty = 0.0;
        gridBagPanelAcoes.anchor = 13;
        this.buttonDetalhes.setPreferredSize(new Dimension(100, 20));
        this.buttonDetalhes.setMinimumSize(new Dimension(100, 20));
        jPanelDetalhar.add(this.buttonDetalhes);
        this.panelAcao.add((Component)jPanelDetalhar, gridBagPanelAcoes);
    }

    private void criaLinhaTopo(GridBagConstraints gridBagConstraints) {
        this.painelCentral.add((Component)this.labelCodigoNcf, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.labelCodigoVlrNcf.setMinimumSize(new Dimension(100, 20));
        this.labelCodigoVlrNcf.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.painelCentral.add((Component)this.labelCodigoVlrNcf, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        ++gridBagConstraints.gridx;
        this.painelCentral.add((Component)this.labelDataAnaliseNcf, gridBagConstraints);
        GridBagConstraints gridBagLinha2 = new GridBagConstraints();
        gridBagLinha2.insets = new Insets(0, 0, 0, 0);
        gridBagLinha2.gridy = 0;
        gridBagLinha2.gridx = 0;
        gridBagLinha2.weightx = 0.0;
        gridBagLinha2.weighty = 0.0;
        gridBagLinha2.fill = 0;
        gridBagLinha2.anchor = 17;
        gridBagLinha2.gridwidth = 1;
        ++gridBagConstraints.gridx;
        this.textoDataAnaliseNcf.setPreferredSize(new Dimension(100, 20));
        this.textoDataAnaliseNcf.setMinimumSize(new Dimension(100, 20));
        this.jPanelLinha2.add((Component)this.textoDataAnaliseNcf, gridBagLinha2);
        gridBagLinha2.insets = new Insets(0, 0, 0, 1);
        ++gridBagLinha2.gridx;
        this.buttonDataAnalise.setPreferredSize(new Dimension(20, 20));
        this.buttonDataAnalise.setMinimumSize(new Dimension(20, 20));
        this.buttonDataAnalise.setFocusable(false);
        gridBagLinha2.insets = new Insets(0, 0, 0, 20);
        this.jPanelLinha2.add((Component)this.buttonDataAnalise, gridBagLinha2);
        gridBagLinha2.insets = new Insets(0, 0, 0, 1);
        ++gridBagLinha2.gridx;
        this.labelUserAnaliseNcf.setPreferredSize(new Dimension(100, 20));
        this.labelUserAnaliseNcf.setMinimumSize(new Dimension(100, 20));
        this.jPanelLinha2.add((Component)this.labelUserAnaliseNcf, gridBagLinha2);
        ++gridBagLinha2.gridx;
        if (!Acesso.getAcesso(AbrirNaoConformidade.acessoOcultarDetalhe())) {
            this.labelUserAnaliseVlrNcf.setPreferredSize(new Dimension(120, 20));
            this.labelUserAnaliseVlrNcf.setMinimumSize(new Dimension(120, 20));
        } else {
            this.labelUserAnaliseVlrNcf.setPreferredSize(new Dimension(141, 20));
            this.labelUserAnaliseVlrNcf.setMinimumSize(new Dimension(141, 20));
        }
        gridBagLinha2.insets = new Insets(0, 0, 0, 0);
        this.jPanelLinha2.add((Component)this.labelUserAnaliseVlrNcf, gridBagLinha2);
        ++gridBagLinha2.gridx;
        gridBagLinha2.insets = new Insets(0, 1, 0, 1);
        this.labelTipo.setPreferredSize(new Dimension(50, 20));
        this.labelTipo.setMinimumSize(new Dimension(50, 20));
        this.jPanelLinha2.add((Component)this.labelTipo, gridBagLinha2);
        if (!Acesso.getAcesso(AbrirNaoConformidade.acessoOcultarDetalhe())) {
            ++gridBagLinha2.gridx;
            gridBagLinha2.insets = new Insets(0, 1, 0, 0);
            this.buttonVisualizarNcf.setPreferredSize(new Dimension(20, 20));
            this.buttonVisualizarNcf.setMinimumSize(new Dimension(20, 20));
            this.buttonVisualizarNcf.setMargin(new Insets(0, 0, 0, 0));
            this.jPanelLinha2.add((Component)this.buttonVisualizarNcf, gridBagLinha2);
        }
        this.painelCentral.add((Component)this.jPanelLinha2, gridBagConstraints);
    }

    private TipoNaoConformidadeVO[] pegaTipos() {
        TipoNaoConformidadeVO[] set = new TipoNaoConformidadeVO[]{};
        try {
            Set set2 = this.tipoService.load(" where fil_codigo = " + Variaveis.filialPadrao);
            set = new TipoNaoConformidadeVO[set2.size() + 1];
            set[0] = new TipoNaoConformidadeVO();
            int i = 1;
            Iterator it = set2.iterator();
            while (it.hasNext()) {
                TipoNaoConformidadeVO f;
                set[i] = f = (TipoNaoConformidadeVO)((TipoNaoConformidadeBean)it.next()).toVO();
                ++i;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AnalisarAcao (739)");
        }
        return set;
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            try {
                this.getBeanPreenchido();
                this.naoConformidadeService.update(this.naoConformidadeBean, Variaveis.filialPadrao);
                this.gravarAnaliseAcao();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar a an\u00e1lise da n\u00e3o conformidade.", 1);
            }
        }
    }

    private void gravarAnaliseAcao() throws Exception, SQLException {
        String assuntoMsg = ASSUNTO_NCF_NAO_URGENTE;
        if (this.naoConformidadeBean.getUrgente().booleanValue()) {
            assuntoMsg = ASSUNTO_NCF_URGENTE;
        }
        Set<String> usuariosNotificar = this.getUsuarioNotificar();
        for (AcoesNaoConformidadeVO acoesNcfVo : this.naoConformidadeBean.getAcoesNaoConformidadeVOs()) {
            this.acoesNaoConformidadeService.delete(acoesNcfVo.toBean(), Variaveis.filialPadrao);
        }
        for (AcoesNaoConformidadeBean acoesNcfBean : this.acoesNaoConformidadeListaAnalise()) {
            this.acoesNaoConformidadeService.insert(acoesNcfBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
        }
        for (SetorNaoConformidadeVO setorVo : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
            if (setorVo == null || !setorVo.getTipo().equalsIgnoreCase("N") || setorVo == null || setorVo.getNaoConformidadeUsuarioBeans() == null || setorVo.getNaoConformidadeUsuarioBeansTemp() == null) continue;
            for (SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean : setorVo.getNaoConformidadeUsuarioBeansTemp()) {
                for (UsuarioMensagemBean usuarioMensagemBean : setorNaoConformidadeUsuarioBean.getUsuarioMensagemBeans()) {
                    this.usuarioMensagemService.delete(usuarioMensagemBean, usuarioMensagemBean.getCodigo(), Variaveis.filialPadrao, this.getCopiaFiliais());
                }
            }
        }
        for (SetorNaoConformidadeVO vo : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
            if (vo == null || !vo.getTipo().equalsIgnoreCase("N") || vo == null) continue;
            if (vo.getNaoConformidadeUsuarioBeansTemp() != null) {
                for (SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean : vo.getNaoConformidadeUsuarioBeansTemp()) {
                    this.setorNaoConformidadeUsuarioService.delete(setorNaoConformidadeUsuarioBean, Variaveis.filialPadrao);
                }
            }
            this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(vo, 2, Variaveis.filialPadrao, this.getCopiaFiliais());
        }
        for (SetorNaoConformidadeVO setorVo : this.naoConformidadeBean.getSetorNaoConformidadeVOs()) {
            SetorNaoConformidadeBean setorNaoConformidadeBean = new SetorNaoConformidadeBean();
            if (setorVo == null) continue;
            setorNaoConformidadeBean.setFilial(this.naoConformidadeBean.getFilial());
            setorNaoConformidadeBean.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
            setorNaoConformidadeBean.setCodResponsavelSetor(setorVo.getCodResponsavelSetor());
            setorNaoConformidadeBean.setSetor(setorVo.getSetor());
            setorNaoConformidadeBean.setTipo("N");
            setorNaoConformidadeBean.setDataAnaliseUsuario(setorVo.getDataAnaliseUsuario());
            setorNaoConformidadeBean.setCritica(setorVo.getCritica());
            this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(setorNaoConformidadeBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
            if (setorVo.getNaoConformidadeUsuarioBeans() != null && !setorVo.getNaoConformidadeUsuarioBeans().isEmpty()) {
                for (SetorNaoConformidadeUsuarioBean setorUser : setorVo.getNaoConformidadeUsuarioBeans()) {
                    setorUser.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setorNaoConformidadeBean.toVO());
                    setorUser.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
                    setorUser.setFilial(this.naoConformidadeBean.getFilial());
                    this.setorNaoConformidadeUsuarioService.insert(setorUser, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                        mensagemBean.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setorNaoConformidadeBean.toVO());
                        this.usuarioMensagemService.insert(mensagemBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    }
                    if (!usuariosNotificar.contains(setorUser.getUsuarioVO().getCodigo())) continue;
                    Statement statement = Conexao.getStatement();
                    NovaMensagem.enviarMensagemNcf(Conexao.getStatement(), Variaveis.login, setorUser.getUsuarioVO().getCodigo(), assuntoMsg, "N\u00e3o conformidade com o c\u00f3digo " + this.naoConformidadeBean.getCodigo() + " adicionada sobre sua responsabilidade.", false, this.naoConformidadeBean.getFilial().getCodigo(), this.naoConformidadeBean.getCodigo(), setorUser.getSetorNaoConformidadeVO().getCodigo(), setorUser.getUsuarioVO().getCodigo());
                    statement.close();
                }
                continue;
            }
            SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean = new SetorNaoConformidadeUsuarioBean();
            UsuarioVO u = new UsuarioVO();
            u.setCodigo(setorVo.getCodResponsavelSetor());
            setorNaoConformidadeUsuarioBean.setUsuarioVO(u);
            setorNaoConformidadeUsuarioBean.setDataNotificado(new Date());
            setorNaoConformidadeUsuarioBean.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setorNaoConformidadeBean.toVO());
            setorNaoConformidadeUsuarioBean.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
            setorNaoConformidadeUsuarioBean.setFilial(this.naoConformidadeBean.getFilial());
            this.setorNaoConformidadeUsuarioService.insert(setorNaoConformidadeUsuarioBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
            Statement statement = Conexao.getStatement();
            Conexao.arquivaSQL();
            NovaMensagem.enviarMensagemNcf(Conexao.getStatement(), Variaveis.login, setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo(), assuntoMsg, "N\u00e3o conformidade com o c\u00f3digo " + this.naoConformidadeBean.getCodigo() + " adicionada sobre sua responsabilidade.", false, this.naoConformidadeBean.getFilial().getCodigo(), this.naoConformidadeBean.getCodigo(), setorNaoConformidadeUsuarioBean.getSetorNaoConformidadeVO().getCodigo(), setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo());
            statement.close();
        }
    }

    private Set<String> getUsuarioNotificar() {
        HashSet<String> usuariosNotificar = new HashSet<String>();
        for (SetorNaoConformidadeBean setorNcfBean : this.setorNaoConformidadeListaAnalise()) {
            if (setorNcfBean.getNaoConformidadeUsuarioBeans() != null && !setorNcfBean.getNaoConformidadeUsuarioBeans().isEmpty()) {
                for (SetorNaoConformidadeUsuarioBean setorUser : setorNcfBean.getNaoConformidadeUsuarioBeans()) {
                    if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(this.naoConformidadeBean.getCodigo(), setorUser.getUsuarioVO().getCodigo())) continue;
                    usuariosNotificar.add(setorUser.getUsuarioVO().getCodigo());
                }
            } else if (setorNcfBean.getNaoConformidadeUsuarioBeansTemp() != null && !setorNcfBean.getNaoConformidadeUsuarioBeansTemp().isEmpty()) {
                for (SetorNaoConformidadeUsuarioBean setorUser : setorNcfBean.getNaoConformidadeUsuarioBeansTemp()) {
                    if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(this.naoConformidadeBean.getCodigo(), setorUser.getUsuarioVO().getCodigo())) continue;
                    usuariosNotificar.add(setorUser.getUsuarioVO().getCodigo());
                }
            }
            if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(this.naoConformidadeBean.getCodigo(), setorNcfBean.getCodResponsavelSetor())) continue;
            usuariosNotificar.add(setorNcfBean.getCodResponsavelSetor());
        }
        return usuariosNotificar;
    }

    private void gravarUsuarioNotificar(List<SetorNaoConformidadeUsuarioBean> setorNcfBean, SetorNaoConformidadeBean setor, String assuntoMsg) throws Exception, SQLException {
        for (SetorNaoConformidadeUsuarioBean setorUser : setorNcfBean) {
            if (this.setorNaoConformidadeUsuarioService.existe(setorUser, setor)) continue;
            setorUser.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setor.toVO());
            setorUser.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
            setorUser.setFilial(this.naoConformidadeBean.getFilial());
            this.setorNaoConformidadeUsuarioService.insert(setorUser, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
            NovaMensagem.enviarMensagemNcf(Conexao.getStatement(), Variaveis.login, setorUser.getUsuarioVO().getCodigo(), assuntoMsg, "N\u00e3o conformidade com o c\u00f3digo " + setorUser.getNaoConformidade().getCodigo() + " adicionada sobre sua responsabilidade.", false, setorUser.getNaoConformidade().getFilial().getCodigo(), setorUser.getNaoConformidade().getCodigo(), setorUser.getSetorNaoConformidadeVO().getCodigo(), setorUser.getUsuarioVO().getCodigo());
        }
    }

    @Override
    public void excluir() {
        this.naoConformidadeBean = (NaoConformidadeBean)this.pesquisar();
        if (this.naoConformidadeBean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnalisarAcao.this.preencherCampos(AnalisarAcao.this.naoConformidadeBean);
                    if (Funcoes.mensagem(AnalisarAcao.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            AnalisarAcao.this.naoConformidadeBean.setSituacao("L");
                            AnalisarAcao.this.naoConformidadeBean.setAnalise(null);
                            AnalisarAcao.this.naoConformidadeBean.setNcfDataAnalise(null);
                            AnalisarAcao.this.naoConformidadeBean.setNcfDataHoraAnalise(null);
                            AnalisarAcao.this.naoConformidadeBean.setUsuarioAnalise(null);
                            AnalisarAcao.this.naoConformidadeService.update(AnalisarAcao.this.naoConformidadeBean, Variaveis.filialPadrao);
                            for (AcoesNaoConformidadeVO acoesVo : AnalisarAcao.this.naoConformidadeBean.getAcoesNaoConformidadeVOs()) {
                                AnalisarAcao.this.acoesNaoConformidadeService.delete(acoesVo.toBean(), Variaveis.filialPadrao);
                            }
                            for (SetorNaoConformidadeVO vo : AnalisarAcao.this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                                if (vo != null && vo.getNaoConformidadeUsuarioBeansTemp() != null) {
                                    for (SetorNaoConformidadeUsuarioBean setorUser : vo.getNaoConformidadeUsuarioBeansTemp()) {
                                        for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                                            AnalisarAcao.this.usuarioMensagemService.delete(mensagemBean, mensagemBean.getCodigo(), Variaveis.filialPadrao, AnalisarAcao.this.getCopiaFiliais());
                                        }
                                        AnalisarAcao.this.setorNaoConformidadeService.delete(setorUser, Variaveis.filialPadrao);
                                    }
                                }
                                if (vo == null) continue;
                                AnalisarAcao.this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(vo, 2, Variaveis.filialPadrao, AnalisarAcao.this.getCopiaFiliais());
                            }
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir an\u00e1lise.\n" + e.getMessage(), 2);
                        }
                    }
                    AnalisarAcao.this.limparCampos();
                    AnalisarAcao.this.naoConformidadeBean = null;
                }
            });
        }
    }

    private void editarSetor() {
        this.editandoSetor = true;
        int linhaSelecionada = this.tableSetor.getSelectedRow();
        this.setorVO = (SetorVO)this.modeloSetor.getValueAt(linhaSelecionada, COLUNA_SETOR);
        this.textCodSetor.setText(this.setorVO.getCodigo().toString());
        this.labelDescSetor.setText(this.setorVO.getDescricao());
        this.labelVlrLeitura.setText(this.getDataLeituraResponsavel(this.modeloSetor.getValueAt(linhaSelecionada, COLUNA_SETOR_NCF)));
        this.labelResponsavelSetor.setText(this.setorVO.getUsuario().getCodigo());
        this.labelVlrNotificado.setText(this.montaUsuariosNotificados((List)this.modeloSetor.getValueAt(linhaSelecionada, COLUNA_SETOR + 1)));
        this.jDialogNotificados.limparModeloNotificados();
        this.jDialogNotificados.addListaSetoresUsuario((List)this.modeloSetor.getValueAt(linhaSelecionada, COLUNA_SETOR + 1));
        this.textCodSetor.setEnabled(true);
        this.buttonPesqSetor.setEnabled(true);
    }

    private String montaUsuariosNotificados(List<SetorNaoConformidadeUsuarioBean> naoConformidadeUsuarioBeansTemp) {
        StringBuilder retorno = new StringBuilder();
        if (naoConformidadeUsuarioBeansTemp != null) {
            for (SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean : naoConformidadeUsuarioBeansTemp) {
                retorno.append(setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo());
                retorno.append(", ");
            }
            if (retorno.length() > 0) {
                return retorno.toString().substring(0, retorno.length() - 2);
            }
        }
        return "";
    }

    private void imprimirRelatorio() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getCodigo() == null && Funcoes.textoVazio(this.labelCodigoVlrNcf.getText())) {
            this.pesquisar();
        }
        if (!Funcoes.textoVazio(this.labelCodigoVlrNcf.getText())) {
            new ImprimirNaoConformidade(Integer.valueOf(this.labelCodigoVlrNcf.getText()));
        } else if (this.naoConformidadeBean != null) {
            new ImprimirNaoConformidade((int)this.naoConformidadeBean.getCodigo());
        }
        this.naoConformidadeBean = null;
        this.limparCampos();
        this.setStatus(1);
        this.controlaCampos();
    }

    private void addListener(boolean bloquear) {
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalisarAcao.this.getStatus() == 2) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Salve a an\u00e1lise para impress\u00e3o.", 2);
                    return;
                }
                AnalisarAcao.this.imprimirRelatorio();
            }
        });
        if (!bloquear) {
            this.tableSetor.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AnalisarAcao.this.editarSetor();
                        AnalisarAcao.this.textCodSetor.setEnabled(true);
                        AnalisarAcao.this.buttonPesqSetor.setEnabled(true);
                    } else {
                        AnalisarAcao.this.editarSetor();
                        AnalisarAcao.this.textCodSetor.setEnabled(false);
                        AnalisarAcao.this.buttonPesqSetor.setEnabled(false);
                    }
                }
            });
            this.tableSetor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        AnalisarAcao.this.editarSetor();
                    }
                }
            });
            this.tableSetor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int resp;
                    int row;
                    if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Deseja remover o setor da composi\u00e7\u00e3o ?", 4)) == 0) {
                        AnalisarAcao.this.modeloSetor.removeLine(row);
                    }
                }
            });
            this.tableAcao.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int resp;
                    int row;
                    if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Deseja remover a a\u00e7\u00e3o da composi\u00e7\u00e3o ?", 4)) == 0) {
                        AnalisarAcao.this.modeloAcao.removeLine(row);
                    }
                }
            });
        }
        this.textCodSetor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AnalisarAcao.this.labelResponsavelSetor.setText("");
                    AnalisarAcao.this.labelVlrDescSetor.setText("");
                    AnalisarAcao.this.labelVlrLeitura.setText("");
                    if (!Funcoes.textoVazio(AnalisarAcao.this.textCodSetor.getText())) {
                        AnalisarAcao.this.setorVO = (SetorVO)AnalisarAcao.this.setorService.getVO(Variaveis.filialPadrao, AnalisarAcao.this.textCodSetor.getText());
                        if (AnalisarAcao.this.setorVO != null) {
                            AnalisarAcao.this.textCodSetor.setText(AnalisarAcao.this.setorVO.getCodigo().toString());
                            AnalisarAcao.this.labelVlrDescSetor.setText(AnalisarAcao.this.setorVO.getDescricao());
                            AnalisarAcao.this.labelResponsavelSetor.setText(AnalisarAcao.this.setorVO.getUsuario().getCodigo());
                            AnalisarAcao.this.labelVlrNotificado.setText("");
                            AnalisarAcao.this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
                        } else {
                            AnalisarAcao.this.labelVlrDescSetor.setText("N\u00e3o cadastrado");
                            AnalisarAcao.this.labelResponsavelSetor.setText("");
                            AnalisarAcao.this.labelVlrNotificado.setText("");
                            AnalisarAcao.this.textCodSetor.selectAll();
                            AnalisarAcao.this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Setor n\u00e3o identificado", 1);
                }
            }
        });
        this.textCodTipo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (Funcoes.textoVazio(AnalisarAcao.this.textCodTipo)) {
                        AnalisarAcao.this.labelVlrTipo.setText("");
                        AnalisarAcao.this.labelVlrTipo.repaint();
                        AnalisarAcao.this.tipoNaoConformidadeVO = null;
                    }
                    if (AnalisarAcao.this.tipoNaoConformidadeVO != null && !Funcoes.textoVazio(AnalisarAcao.this.textCodTipo) && AnalisarAcao.this.tipoNaoConformidadeVO.getCodigo().toString().equals(AnalisarAcao.this.textCodTipo.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AnalisarAcao.this.textCodTipo.getText())) {
                        AnalisarAcao.this.tipoNaoConformidadeVO = (TipoNaoConformidadeVO)AnalisarAcao.this.tipoService.loadVOCast(" where tcf_codigo = " + AnalisarAcao.this.textCodTipo.getText() + " and fil_codigo = " + Variaveis.filialPadrao);
                        if (AnalisarAcao.this.tipoNaoConformidadeVO != null) {
                            AnalisarAcao.this.textCodTipo.setText(AnalisarAcao.this.tipoNaoConformidadeVO.getCodigo().toString());
                            AnalisarAcao.this.labelVlrTipo.setText(AnalisarAcao.this.tipoNaoConformidadeVO.getDescricao());
                        } else {
                            AnalisarAcao.this.labelVlrTipo.setText("N\u00e3o cadastrado");
                            AnalisarAcao.this.textCodTipo.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Tipo n\u00e3o identificado", 1);
                }
            }
        });
        this.textCodOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (Funcoes.textoVazio(AnalisarAcao.this.textCodOrigem)) {
                        AnalisarAcao.this.labelVlrOrigem.setText("");
                        AnalisarAcao.this.labelVlrOrigem.repaint();
                        AnalisarAcao.this.origemNaoConformidadeVO = null;
                    }
                    if (AnalisarAcao.this.origemNaoConformidadeVO != null && !Funcoes.textoVazio(AnalisarAcao.this.textCodOrigem) && AnalisarAcao.this.origemNaoConformidadeVO.getCodigo().toString().equals(AnalisarAcao.this.textCodOrigem.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AnalisarAcao.this.textCodOrigem.getText())) {
                        AnalisarAcao.this.origemNaoConformidadeVO = (OrigemNaoConformidadeVO)AnalisarAcao.this.origemNaoConformidadeService.loadVOCast(" where onc_codigo = " + AnalisarAcao.this.textCodOrigem.getText() + " and fil_codigo = " + Variaveis.filialPadrao);
                        if (AnalisarAcao.this.origemNaoConformidadeVO != null) {
                            AnalisarAcao.this.textCodOrigem.setText(AnalisarAcao.this.origemNaoConformidadeVO.getCodigo().toString());
                            AnalisarAcao.this.labelVlrOrigem.setText(AnalisarAcao.this.origemNaoConformidadeVO.getDescricao());
                        } else {
                            AnalisarAcao.this.labelVlrOrigem.setText("N\u00e3o cadastrado");
                            AnalisarAcao.this.textCodOrigem.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Origem n\u00e3o identificada", 1);
                }
            }
        });
        this.textCodOrigem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarAcao.this.buttonOrigem.doClick();
                }
            }
        });
        this.textCodTipo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarAcao.this.buttonTipo.doClick();
                }
            }
        });
        this.textCodProcedencia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarAcao.this.pesquisaProcedencia();
                }
            }
        });
        this.textCodProcedencia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (AnalisarAcao.this.procedenciaVo != null && !Funcoes.textoVazio(AnalisarAcao.this.textCodProcedencia.getText()) && AnalisarAcao.this.procedenciaVo.getCodigo().toString().equals(AnalisarAcao.this.textCodProcedencia.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AnalisarAcao.this.textCodProcedencia.getText())) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", Variaveis.filialPadrao);
                        chaves.put("pnc_codigo", AnalisarAcao.this.textCodProcedencia.getText());
                        AnalisarAcao.this.procedenciaVo = (ProcedenciaNaoConformidadeVO)AnalisarAcao.this.serviceProcedencia.getVO(chaves);
                        if (AnalisarAcao.this.procedenciaVo != null) {
                            if (AnalisarAcao.this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
                                AnalisarAcao.this.linhaAdicionalVisivel(true);
                            } else {
                                AnalisarAcao.this.linhaAdicionalVisivel(false);
                            }
                            AnalisarAcao.this.textCodProcedencia.setText(AnalisarAcao.this.procedenciaVo.getCodigo().toString());
                            AnalisarAcao.this.labelVlrDescProcedencia.setText(AnalisarAcao.this.procedenciaVo.getDescricao());
                        } else {
                            AnalisarAcao.this.labelVlrDescProcedencia.setText("N\u00e3o cadastrado");
                            AnalisarAcao.this.textCodProcedencia.selectAll();
                        }
                    }
                }
                catch (ThreadDaoException e1) {
                    Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Proced\u00eancia n\u00e3o identificada", 1);
                }
            }
        });
        this.textoDataAnaliseNcf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarAcao.this.buttonDataAnalise.doClick();
                }
            }
        });
        this.textCodSetor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarAcao.this.pesquisaSetor();
                }
            }
        });
        this.textoCodAcao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AnalisarAcao.this.pesquisaAcao();
                }
            }
        });
        this.textCodSetor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AnalisarAcao.this.labelDescSetor.setText("");
                    if (!Funcoes.textoVazio(AnalisarAcao.this.textCodSetor.getText())) {
                        AnalisarAcao.this.setorVO = (SetorVO)AnalisarAcao.this.setorService.getVO(Variaveis.filialPadrao, AnalisarAcao.this.textCodSetor.getText());
                        if (AnalisarAcao.this.setorVO != null) {
                            AnalisarAcao.this.textCodSetor.setText(AnalisarAcao.this.setorVO.getCodigo().toString());
                            AnalisarAcao.this.labelDescSetor.setText(AnalisarAcao.this.setorVO.getDescricao());
                            AnalisarAcao.this.setorVO.setResponsavel(AnalisarAcao.this.labelDescSetor.getText());
                        } else {
                            AnalisarAcao.this.labelDescSetor.setText("N\u00e3o cadastrado");
                            AnalisarAcao.this.textCodSetor.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Setor n\u00e3o identificado", 1);
                }
            }
        });
        this.textoCodAcao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AnalisarAcao.this.labelDescAcao.setText("");
                    if (!Funcoes.textoVazio(AnalisarAcao.this.textoCodAcao.getText())) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", Variaveis.filialPadrao);
                        chaves.put("anc_codigo", AnalisarAcao.this.textoCodAcao.getText());
                        AnalisarAcao.this.acaoNaoConformidadeVO = (AcaoNaoConformidadeVO)AnalisarAcao.this.acaoNaoConformidadeService.getVO(chaves);
                        if (AnalisarAcao.this.acaoNaoConformidadeVO != null) {
                            AnalisarAcao.this.textoCodAcao.setText(AnalisarAcao.this.acaoNaoConformidadeVO.getCodigo().toString());
                            AnalisarAcao.this.labelDescAcao.setText(AnalisarAcao.this.acaoNaoConformidadeVO.getDescricao());
                        } else {
                            AnalisarAcao.this.labelDescAcao.setText("N\u00e3o cadastrado");
                            AnalisarAcao.this.textoCodAcao.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AnalisarAcao.this.painelCentral, "A\u00e7\u00e3o n\u00e3o identificada", 1);
                }
            }
        });
        this.buttonAddSetor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalisarAcao.this.setorlInformado() && AnalisarAcao.this.setorInformado()) {
                    if (AnalisarAcao.this.modeloSetor.getRowCount() == 0) {
                        AnalisarAcao.this.addSetor();
                    } else {
                        if (!AnalisarAcao.this.editandoSetor) {
                            for (int i = 0; i < AnalisarAcao.this.modeloSetor.getRowCount(); ++i) {
                                Integer codigo = (Integer)AnalisarAcao.this.modeloSetor.getValueAt(i, AnalisarAcao.this.modeloSetor.findColumn(AnalisarAcao.COLUNA_CODIGO));
                                if (codigo == null || !AnalisarAcao.this.setorJaInformado(codigo)) continue;
                                Funcoes.mensagem(AnalisarAcao.this.painelCentral, "Setor j\u00e1 inserido", 2);
                                return;
                            }
                        }
                        AnalisarAcao.this.addSetor();
                    }
                }
            }
        });
        this.buttonAddAcao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalisarAcao.this.acaoInformada()) {
                    if (AnalisarAcao.this.modeloAcao.getRowCount() == 0) {
                        AnalisarAcao.this.addAcao();
                    } else {
                        for (int i = 0; i < AnalisarAcao.this.modeloAcao.getRowCount(); ++i) {
                            Integer codigo = (Integer)AnalisarAcao.this.modeloAcao.getValueAt(i, AnalisarAcao.this.modeloAcao.findColumn(AnalisarAcao.COLUNA_CODIGO));
                            if (codigo == null || !AnalisarAcao.this.acaoJaInformada(codigo)) continue;
                            Funcoes.mensagem(AnalisarAcao.this.painelCentral, "A\u00e7\u00e3o j\u00e1 inserida.", 2);
                            return;
                        }
                        AnalisarAcao.this.addAcao();
                    }
                }
            }
        });
    }

    private boolean setorJaInformado(Integer codigo) {
        if (this.setorVO.getCodigo().equals(codigo)) {
            this.setFoco(this.textCodSetor);
            return true;
        }
        return false;
    }

    private boolean acaoJaInformada(Integer codigo) {
        if (this.acaoNaoConformidadeVO.getCodigo().equals(codigo)) {
            this.setFoco(this.textoCodAcao);
            return true;
        }
        return false;
    }

    private boolean setorInformado() {
        if (this.validaSetor()) {
            Funcoes.mensagem(this, "Informe o setor.", 2);
            this.setFoco(this.textCodSetor);
            return false;
        }
        return true;
    }

    private boolean validaSetor() {
        return Funcoes.textoVazio(this.textCodSetor.getText()) || this.labelVlrDescSetor.getText().equalsIgnoreCase("N\u00e3o cadastrado");
    }

    private boolean setorlInformado() {
        if (Funcoes.textoVazio(this.textCodSetor.getText()) || this.labelDescSetor.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe o setor.", 2);
            this.setFoco(this.textCodSetor);
            return false;
        }
        return true;
    }

    private boolean acaoInformada() {
        if (Funcoes.textoVazio(this.textoCodAcao.getText()) || this.labelDescAcao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe a a\u00e7\u00e3o.", 2);
            this.setFoco(this.textoCodAcao);
            return false;
        }
        return true;
    }

    private void setFoco(Component comp) {
        ScreenUtil.requisitarFoco(comp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataAnalise) {
            Funcoes.mostraData(this.textoDataAnaliseNcf, this.buttonDataAnalise, this.jPanelLinha2, true);
        } else if (e.getSource() == this.buttonPesqSetor) {
            this.pesquisaSetor();
        } else if (e.getSource() == this.buttonPesqAcao) {
            this.pesquisaAcao();
        } else if (e.getSource() == this.buttonDetalhes) {
            this.mostrarDetalheAcao();
        } else if (e.getSource() == this.buttonVisualizarNcf) {
            this.exibirDetalheNcf();
        } else if (e.getSource() == this.buttonProcedencia) {
            this.pesquisaProcedencia();
        } else if (e.getSource() == this.buttonOrigem) {
            this.pesquisaOrigem();
        } else if (e.getSource() == this.buttonTipo) {
            this.pesquisaTipo();
        } else if (e.getSource() == this.buttonBuscarNotificado) {
            this.buttonBuscarNotificado.transferFocus();
            if (this.setorVO == null || Funcoes.textoVazio(this.textCodSetor)) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Informe o setor.", 2);
                ScreenUtil.requisitarFoco(this.textCodSetor);
                return;
            }
            this.jDialogNotificados.limparModeloNotificados();
            if (this.editandoSetor) {
                int linhaSelecionada = this.tableSetor.getSelectedRow();
                if (linhaSelecionada > 0) {
                    this.setorVO = (SetorVO)this.modeloSetor.getValueAt(linhaSelecionada, COLUNA_SETOR);
                }
                if (this.setorVO != null && !this.setorVO.getCodigo().toString().trim().equals(this.textCodSetor.getText().trim())) {
                    this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp();
                } else {
                    this.jDialogNotificados.addListaSetoresUsuario((List)this.modeloSetor.getValueAt(linhaSelecionada, COLUNA_SETOR + 1));
                }
            } else {
                this.jDialogNotificados.addListaSetoresUsuario(this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp());
            }
            this.jDialogNotificados.setVisible(true);
        }
    }

    public void visualizar() {
        final JDialog visDialog = new JDialog();
        visDialog.add(this);
        visDialog.setResizable(false);
        visDialog.setPreferredSize(new Dimension(770, 580));
        visDialog.setMinimumSize(new Dimension(770, 580));
        visDialog.setTitle("Visualizando detalhes da an\u00e1lise da n\u00e3o conformidade");
        visDialog.setModal(true);
        this.painelCrud.removeAll();
        this.painelOpcoes.removeAll();
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                visDialog.dispose();
            }
        });
        this.painelCrud.add(this.botaoFechar);
        ScreenUtil.centralizar(visDialog);
        visDialog.setVisible(true);
        visDialog.pack();
    }

    public AnalisarAcao(NaoConformidadeBean naoConformidadeBean) {
        try {
            this.montarTela(true);
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", naoConformidadeBean.getFilial().getCodigo());
            chaves.put("nac_codigo", naoConformidadeBean.getCodigo());
            this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBeanAnalise(chaves);
            this.preencherCampos(this.naoConformidadeBean);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montarTela(boolean bloquearListenerTabelas) {
        this.jbInit(bloquearListenerTabelas);
        this.controlaCampos();
        this.ocultaProcedencia();
        this.setModuloInsere(Long.valueOf("1300200101"));
        this.setModuloEdita(Long.valueOf("1300200102"));
        this.setModuloApaga(Long.valueOf("1300200103"));
    }

    private void ocultaProcedencia() {
        if (Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            this.labelProcedencia.setVisible(false);
            this.labelVlrDescProcedencia.setVisible(false);
            this.textCodProcedencia.setVisible(false);
            this.buttonProcedencia.setVisible(false);
            this.labelAdicional.setVisible(false);
            this.textDescAdicional.setVisible(false);
        } else {
            this.labelProcedencia.setVisible(true);
            this.labelVlrDescProcedencia.setVisible(true);
            this.textCodProcedencia.setVisible(true);
            this.buttonProcedencia.setVisible(true);
            this.labelAdicional.setVisible(true);
            this.textDescAdicional.setVisible(true);
        }
    }

    private void exibirDetalheNcf() {
        InfoAnalisarNaoConformidade abrirNaoConformidade = new InfoAnalisarNaoConformidade(this.naoConformidadeBean);
        abrirNaoConformidade.visualizar();
    }

    private void pesquisaOrigem() {
        OrigemNaoConformidadeVO setVo = (OrigemNaoConformidadeVO)this.origemNaoConformidadeService.pesquisaVO(Laboratorio.getInstancia(), new OrigemNaoConformidadeVO(), "Pesquisando origem", true);
        if (setVo != null) {
            this.origemNaoConformidadeVO = setVo;
            this.textCodOrigem.setText(setVo.getCodigo().toString());
            this.labelVlrOrigem.setText(setVo.getDescricao());
        } else {
            this.labelVlrOrigem.setText("N\u00e3o cadastrado");
            this.textCodOrigem.selectAll();
        }
    }

    private void pesquisaTipo() {
        TipoNaoConformidadeVO setVo = (TipoNaoConformidadeVO)this.tipoService.pesquisaVO(Laboratorio.getInstancia(), new TipoNaoConformidadeVO(), "Pesquisando tipo", true);
        if (setVo != null) {
            this.tipoNaoConformidadeVO = setVo;
            this.textCodTipo.setText(setVo.getCodigo().toString());
            this.labelVlrTipo.setText(setVo.getDescricao());
        } else {
            this.labelVlrTipo.setText("N\u00e3o cadastrado");
            this.textCodTipo.selectAll();
        }
    }

    private void mostrarDetalheAcao() {
        if (this.modeloAcao.getRowCount() > 0) {
            if (this.tableAcao.getSelectedRow() < 0) {
                Funcoes.mensagem(this, "Selecione uma a\u00e7\u00e3o.", 2);
                return;
            }
            int linhaSelecionada = this.tableAcao.getSelectedRow();
            AcoesNaoConformidadeBean acoesNcfSelecionada = (AcoesNaoConformidadeBean)this.modeloAcao.getValueAt(linhaSelecionada, 3);
            if (acoesNcfSelecionada != null) {
                DescricaoAnaliseAcao descricaoAnaliseAcao = new DescricaoAnaliseAcao().novaInstancia(this.getTopLevelAncestor(), acoesNcfSelecionada, false);
                descricaoAnaliseAcao.setVisible(Boolean.TRUE);
                this.modeloAcao.removeLine(linhaSelecionada);
                this.addAcaoAoModelo(acoesNcfSelecionada);
            }
        }
    }

    private void addSetor() {
        SetorNaoConformidadeVO setorNaoConformidadeVoTemp = new SetorNaoConformidadeVO();
        if (this.editandoSetor) {
            this.clonarDadoSetor(setorNaoConformidadeVoTemp);
            int linha = this.tableSetor.getSelectedRow();
            if (linha > -1) {
                this.modeloSetor.removeLine(this.tableSetor.getSelectedRow());
            }
        }
        this.setorVO.setResponsavel(this.labelResponsavelSetor.getText());
        this.addLinhaTabelaSetor(this.setorVO, setorNaoConformidadeVoTemp);
        this.textCodSetor.setText("");
        this.labelResponsavelSetor.setText("");
        this.labelVlrDescSetor.setText("");
        this.labelVlrLeitura.setText("");
        this.labelVlrNotificado.setText("");
        this.setFoco(this.textCodSetor);
        this.editandoSetor = false;
        this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
        this.textCodSetor.setEnabled(true);
        this.buttonPesqSetor.setEnabled(true);
    }

    private void clonarDadoSetor(SetorNaoConformidadeVO setorNaoConformidadeVoTemp) {
        SetorNaoConformidadeVO setorNaoConformidadeVoClona = (SetorNaoConformidadeVO)((SetorNaoConformidadeVO)this.modeloSetor.getValueAt(this.tableSetor.getSelectedRow(), COLUNA_SETOR_NCF)).clonar();
        setorNaoConformidadeVoTemp.setCodigo(setorNaoConformidadeVoClona.getCodigo());
        setorNaoConformidadeVoTemp.setFilial(setorNaoConformidadeVoClona.getFilial());
        setorNaoConformidadeVoTemp.setNaoConformidade(setorNaoConformidadeVoClona.getNaoConformidade());
        setorNaoConformidadeVoTemp.setCodResponsavelSetor(setorNaoConformidadeVoClona.getCodResponsavelSetor());
        setorNaoConformidadeVoTemp.setDataAnaliseUsuario(setorNaoConformidadeVoClona.getDataAnaliseUsuario());
        setorNaoConformidadeVoTemp.setCritica(setorNaoConformidadeVoClona.getCritica());
    }

    private void addLinhaTabelaSetor(SetorVO setorVO, SetorNaoConformidadeVO setorNaoConformidadeVoTemp) {
        SetorNaoConformidadeVO setorNaoConformidadeVo = new SetorNaoConformidadeVO();
        setorNaoConformidadeVo.setFilial(this.naoConformidadeBean.getFilial());
        setorNaoConformidadeVo.setCodigo(setorNaoConformidadeVoTemp.getCodigo());
        setorNaoConformidadeVo.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
        setorNaoConformidadeVo.setSetor(setorVO);
        setorNaoConformidadeVo.setDataAnaliseUsuario(setorNaoConformidadeVoTemp.getDataAnaliseUsuario());
        setorNaoConformidadeVo.setCritica(setorNaoConformidadeVoTemp.getCritica());
        setorNaoConformidadeVo.setNaoConformidadeUsuarioBeans(this.jDialogNotificados.getSetoresUsuarioNcf());
        setorNaoConformidadeVo.setCodResponsavelSetor(setorVO.getUsuario().getCodigo());
        this.modeloSetor.addLine(new Object[]{setorVO.getCodigo(), setorVO.getDescricao(), setorVO.getUsuario().getCodigo(), this.labelVlrNotificado.getText(), setorNaoConformidadeVo, setorVO, this.jDialogNotificados.getSetoresUsuarioNcf(), setorNaoConformidadeVo, setorNaoConformidadeVoTemp});
    }

    private String getDataLeituraResponsavel(Object object) {
        try {
            SetorNaoConformidadeVO setorNsc;
            if (!Funcoes.textoVazio(this.labelCodigoVlrNcf.getText()) && object instanceof SetorNaoConformidadeVO && (setorNsc = (SetorNaoConformidadeVO)object) != null && setorNsc.getFilial() != null && setorNsc.getNaoConformidade() != null) {
                StringBuilder sql = new StringBuilder();
                sql.append(" select snu_dataleitura from setoresnaoconformidadeusuario where  fil_codigo = ");
                sql.append(setorNsc.getFilial().getCodigo());
                sql.append(" and nac_codigo = ").append(setorNsc.getNaoConformidade().getCodigo());
                sql.append(" and sna_codigo = ").append(setorNsc.getCodigo());
                sql.append(" and usr_codigo = '").append(setorNsc.getCodResponsavelSetor()).append("' limit 1");
                ResultSet resultSet = Conexao.executeQuery(this.getStatement(), sql.toString());
                if (resultSet.next()) {
                    return Funcoes.formataData("dd/MM/yyyy HH:mm", resultSet.getTimestamp("snu_dataleitura"));
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a data de leitura do respons\u00e1vel", e.getStackTrace());
        }
        return "";
    }

    private void addLinhaTabelaSetor(SetorNaoConformidadeVO setorVO) {
        this.modeloSetor.addLine(new Object[]{setorVO.getSetor().getCodigo(), setorVO.getSetor().getDescricao(), setorVO.getSetor().getUsuario().getCodigo(), this.montaUsuariosNotificados(setorVO.getNaoConformidadeUsuarioBeansTemp()), setorVO, setorVO.getSetor(), setorVO.getNaoConformidadeUsuarioBeansTemp(), setorVO, setorVO});
    }

    private void addAcao() {
        if (this.acaoNaoConformidadeVO != null && this.acaoNaoConformidadeVO.getCodigo() != null) {
            AcoesNaoConformidadeBean acoesNaoConformidadeBean = new AcoesNaoConformidadeBean();
            try {
                acoesNaoConformidadeBean.setFilial(this.naoConformidadeBean.getFilial());
                acoesNaoConformidadeBean.setNaoConformidade((NaoConformidadeVO)this.naoConformidadeBean.toVO());
                acoesNaoConformidadeBean.setDataHora(Funcoes.getDataHoraServidor());
                acoesNaoConformidadeBean.setAcaoNaoConformidade(this.acaoNaoConformidadeVO);
                acoesNaoConformidadeBean.setUsuario(this.usuarioVOLogado);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel adicionar o usu\u00e1rio ao registro de a\u00e7\u00e3o.", 1);
                return;
            }
            if (this.acaoNaoConformidadeVO.getSolicitarDescricao().booleanValue()) {
                DescricaoAnaliseAcao descricaoAnaliseAcao = new DescricaoAnaliseAcao().novaInstancia(this.getTopLevelAncestor(), acoesNaoConformidadeBean, false);
                descricaoAnaliseAcao.setVisible(Boolean.TRUE);
            }
            this.addAcaoAoModelo(acoesNaoConformidadeBean);
            this.textoCodAcao.clear();
            this.labelDescAcao.setText("");
            this.setFoco(this.textoCodAcao);
        }
    }

    private void addAcaoAoModelo(AcoesNaoConformidadeBean acoesNaoConformidadeBean) {
        this.modeloAcao.addLine(new Object[]{acoesNaoConformidadeBean.getAcaoNaoConformidade().getCodigo(), acoesNaoConformidadeBean.getAcaoNaoConformidade().getDescricao(), acoesNaoConformidadeBean.getDescricaoAcao(), acoesNaoConformidadeBean.clonar()});
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void controlaCampos() {
        this.checkBoxComprometimento.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonBuscarNotificado.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonOrigem.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonTipo.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddAcao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataAnalise.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDetalhes.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonPesqAcao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonPesqSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonProcedencia.setEnabled(this.habilitaDesabilitaCampo());
        this.textoAcaoAnaliseNcf.setEnabled(this.habilitaDesabilitaCampo());
        this.textoAnalise.setEnabled(this.habilitaDesabilitaCampo());
        this.textoCodAcao.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.textoDataAnaliseNcf.setEnabled(this.habilitaDesabilitaCampo());
        this.textDescAdicional.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodProcedencia.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodOrigem.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonVisualizarNcf.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodTipo.setEnabled(this.habilitaDesabilitaCampo());
    }

    private void linhaAdicionalVisivel(boolean visivel) {
        this.labelAdicional.setVisible(visivel);
        this.textDescAdicional.setVisible(visivel);
        this.setFoco(this.textDescAdicional);
    }

    private void pesquisaProcedencia() {
        ProcedenciaNaoConformidadeVO vo = (ProcedenciaNaoConformidadeVO)this.serviceProcedencia.pesquisaVO(Laboratorio.getInstancia(), new ProcedenciaNaoConformidadeVO(), "Pesquisando proced\u00eancias de n\u00e3o conformidade", true);
        if (vo != null) {
            this.procedenciaVo = vo;
            this.textCodProcedencia.setText(vo.getCodigo().toString());
            this.labelVlrDescProcedencia.setText(vo.getDescricao());
            if (this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
                this.linhaAdicionalVisivel(true);
            } else {
                this.linhaAdicionalVisivel(false);
            }
        } else {
            this.procedenciaVo = null;
            this.labelVlrDescProcedencia.setText("N\u00e3o cadastrado");
            this.textCodProcedencia.selectAll();
        }
        if (this.procedenciaVo != null && !this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
            this.setFoco(this.textCodProcedencia);
        }
    }

    @Override
    protected void limparCampos() {
        this.textCodTipo.setText("");
        this.textCodOrigem.setText("");
        this.textoAcaoAnaliseNcf.clear();
        this.textoAnalise.setText("");
        this.textoCodAcao.clear();
        this.textCodSetor.clear();
        this.textoDataAnaliseNcf.clear();
        this.textCodProcedencia.clear();
        this.labelResponsavelSetor.setText("");
        this.labelVlrTipo.setText("");
        this.labelVlrOrigem.setText("");
        this.labelCodigoVlrNcf.setText("");
        this.labelUserAnaliseVlrNcf.setText("");
        this.labelDescAcao.setText("");
        this.labelDescSetor.setText("");
        this.labelUserVlrNcf.setText("");
        this.textDescAdicional.setText("");
        this.labelVlrDescProcedencia.setText("");
        this.labelVlrLeitura.setText("");
        this.modeloAcao.clear();
        this.modeloSetor.clear();
        this.checkBoxComprometimento.setSelected(false);
        this.setorVO = new SetorVO();
        this.naoConformidadeBean = new NaoConformidadeBean();
    }

    @Override
    public void novo() {
        super.novo();
        this.pesquisarNaoConformidade();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            NaoConformidadeVO vo = (NaoConformidadeVO)this.naoConformidadeService.pesquisaVONcf(this.getTopLevelAncestor(), new NaoConformidadeVO(), "Pesquisando an\u00e1lise de n\u00e3o conformidades", false, "N");
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("nac_codigo", vo.getCodigo());
                chaves.put("nac_situacao", "N");
                this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBeanAnalise(chaves);
                this.setFoco(this.textoDataAnaliseNcf);
            } else {
                this.naoConformidadeBean = null;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return this.naoConformidadeBean;
    }

    private List<SetorNaoConformidadeVO> setorNcfVos() {
        ArrayList<SetorNaoConformidadeVO> setorVos = new ArrayList<SetorNaoConformidadeVO>();
        for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
            SetorNaoConformidadeVO setorNaoConformidadeVO = (SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, COLUNA_SETOR - 1);
            SetorNaoConformidadeVO bean = new SetorNaoConformidadeVO();
            SetorVO setor = (SetorVO)this.modeloSetor.getValueAt(i, COLUNA_SETOR);
            bean.setSetor(setor);
            bean.setDataAnaliseUsuario(setorNaoConformidadeVO.getDataAnaliseUsuario());
            bean.setCritica(setorNaoConformidadeVO.getCritica());
            bean.setNaoConformidadeUsuarioBeans((List)this.modeloSetor.getValueAt(i, COLUNA_SETOR + 1));
            bean.setCodResponsavelSetor(setor.getUsuario().getCodigo());
            bean.setTipo("N");
            setorVos.add(bean);
        }
        return setorVos;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        if (this.naoConformidadeBean != null) {
            this.naoConformidadeBean.setSituacao("N");
            this.naoConformidadeBean.setAnalise(this.textoAnalise.getText());
            this.naoConformidadeBean.setNcfDataAnalise(Funcoes.getData("dd/MM/yyyy", this.textoDataAnaliseNcf.getText()));
            this.naoConformidadeBean.setNcfDataHoraAnalise(Calendar.getInstance().getTime());
            this.naoConformidadeBean.setProcedenciaNaoConformidade(this.procedenciaVo);
            this.naoConformidadeBean.setAdicional(this.textDescAdicional.getText());
            this.naoConformidadeBean.setOrigemNaoConformidade(this.origemNaoConformidadeVO);
            this.naoConformidadeBean.setSetorNaoConformidadeVOs(this.setorNcfVos());
            this.naoConformidadeBean.setComprometimento(this.checkBoxComprometimento.isSelected());
            this.naoConformidadeBean.setTipoNaoConformidade(this.tipoNaoConformidadeVO);
            try {
                this.naoConformidadeBean.setUsuarioAnalise((UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, Variaveis.login));
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel adicionar o usu\u00e1rio para a n\u00e3o conformidade", 1);
                return null;
            }
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean != null && bean instanceof NaoConformidadeBean && bean != null) {
            this.naoConformidadeBean = (NaoConformidadeBean)bean.clonar();
            this.labelCodigoVlrNcf.setText(this.naoConformidadeBean.getCodigo().toString());
            this.labelUserVlrNcf.setText(this.naoConformidadeBean.getUsuario() + " em " + Funcoes.formataData(this.naoConformidadeBean.getNcfData()));
            this.labelUserAnaliseVlrNcf.setText(this.naoConformidadeBean.getUsuarioAnalise().getCodigo());
            this.textoDataAnaliseNcf.setText(Funcoes.formataData(this.naoConformidadeBean.getNcfDataAnalise()));
            this.textoAnalise.setText(this.naoConformidadeBean.getAnalise());
            this.textCodProcedencia.setText(this.procedencia());
            this.labelVlrDescProcedencia.setText(this.descricaoProcedencia());
            this.textDescAdicional.setText(this.naoConformidadeBean.getAdicional());
            this.procedenciaVo = this.naoConformidadeBean.getProcedenciaNaoConformidade();
            this.textCodOrigem.setText(this.getCodOrigem(this.naoConformidadeBean));
            this.labelVlrOrigem.setText(this.getDescOrigem(this.naoConformidadeBean));
            if (this.naoConformidadeBean.getTipoNaoConformidade() != null) {
                this.textCodTipo.setText(this.naoConformidadeBean.getTipoNaoConformidade().getCodigo().toString());
                this.labelVlrTipo.setText(this.naoConformidadeBean.getTipoNaoConformidade().getDescricao());
                try {
                    this.tipoNaoConformidadeVO = (TipoNaoConformidadeVO)this.tipoService.loadVOCast(" where tcf_codigo = " + this.textCodTipo.getText() + " and fil_codigo = " + Variaveis.filialPadrao);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
            } else {
                this.textCodTipo.setText("");
                this.labelVlrTipo.setText("");
                this.tipoNaoConformidadeVO = null;
            }
            if (this.naoConformidadeBean.isComprometimento() != null) {
                this.checkBoxComprometimento.setSelected(this.naoConformidadeBean.isComprometimento());
            }
            this.origemNaoConformidadeVO = this.naoConformidadeBean.getOrigemNaoConformidade();
            for (SetorNaoConformidadeVO setorVO : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if (setorVO == null) continue;
                this.addLinhaTabelaSetor(setorVO);
            }
            for (AcoesNaoConformidadeVO acoesNcf : this.naoConformidadeBean.getAcoesNaoConformidadeVOs()) {
                this.addAcaoAoModelo((AcoesNaoConformidadeBean)acoesNcf.toBean());
            }
        }
    }

    private String getCodOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getDescOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getDescricao();
        }
        return "";
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.verificaData(this.textoDataAnaliseNcf.getText())) {
            Funcoes.mensagem(this, "O campo data an\u00e1lise deve ser informado.", 2);
            this.setFoco(this.textoDataAnaliseNcf);
            return false;
        }
        if (!this.validarSetoresInformados()) {
            Funcoes.mensagem(this, "Existem setores da n\u00e3o conformidade que n\u00e3o est\u00e3o presentes na an\u00e1lise.", 2);
            this.setFoco(this.textCodSetor);
            return false;
        }
        if (this.acoesNaoConformidadeListaAnalise().size() == 0) {
            Funcoes.mensagem(this, "Informe as a\u00e7\u00f5es tomadas.", 2);
            this.setFoco(this.textoCodAcao);
            return false;
        }
        if (this.setorNaoConformidadeListaAnalise().size() == 0) {
            Funcoes.mensagem(this, "Informe os setores da n\u00e3o conformidade.", 2);
            this.setFoco(this.textCodSetor);
            return false;
        }
        if (Funcoes.textoVazio(this.textoAnalise.getText())) {
            Funcoes.mensagem(this, "Informe a an\u00e1lise da n\u00e3o conformidade.", 2);
            this.setFoco(this.textoAnalise);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodProcedencia.getText())) {
            if (!Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
                Funcoes.mensagem(this, "Informe a proced\u00eancia da n\u00e3o conformidade.", 2);
                this.setFoco(this.textCodProcedencia);
                return false;
            }
        }
        return true;
    }

    private boolean validarSetoresInformados() {
        HashSet<Integer> setoresNcf = new HashSet<Integer>();
        HashSet<Integer> setoresANcf = new HashSet<Integer>();
        for (SetorNaoConformidadeBean bean : this.setorNaoConformidadeListaAnalise()) {
            setoresANcf.add(bean.getSetor().getCodigo());
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", this.naoConformidadeBean.getFilial().getCodigo());
        chaves.put("nac_codigo", this.naoConformidadeBean.getCodigo());
        NaoConformidadeBean naoConformidadeBean = null;
        try {
            naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel validar os setores informados", 1);
        }
        if (naoConformidadeBean != null) {
            for (SetorNaoConformidadeVO bean : naoConformidadeBean.getSetorNaoConformidadeVOs()) {
                setoresNcf.add(bean.getSetor().getCodigo());
            }
        }
        return setoresANcf.containsAll(setoresNcf);
    }

    private List<SetorNaoConformidadeBean> setorNaoConformidadeListaAnalise() {
        ArrayList<SetorNaoConformidadeBean> setores = new ArrayList<SetorNaoConformidadeBean>();
        for (int i = 0; i < this.modeloSetor.getRowCount(); ++i) {
            setores.add((SetorNaoConformidadeBean)((SetorNaoConformidadeVO)this.modeloSetor.getValueAt(i, 7)).toBean());
        }
        return setores;
    }

    private List<AcoesNaoConformidadeBean> acoesNaoConformidadeListaAnalise() {
        ArrayList<AcoesNaoConformidadeBean> acoes = new ArrayList<AcoesNaoConformidadeBean>();
        for (int i = 0; i < this.modeloAcao.getRowCount(); ++i) {
            acoes.add((AcoesNaoConformidadeBean)this.modeloAcao.getValueAt(i, 3));
        }
        return acoes;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1300200200");
    }

    private void pesquisaSetor() {
        SetorVO setVo = (SetorVO)this.setorService.pesquisaVO(Laboratorio.getInstancia(), new SetorVO(), "Pesquisando setores", true);
        if (setVo != null) {
            this.setorVO = setVo;
            this.textCodSetor.setText(setVo.getCodigo().toString());
            this.labelDescSetor.setText(setVo.getDescricao());
        } else {
            this.labelDescSetor.setText("N\u00e3o cadastrado");
            this.textCodSetor.selectAll();
        }
        this.setFoco(this.textCodSetor);
    }

    private void pesquisaAcao() {
        AcaoNaoConformidadeVO acaoNaoConformidadeVO = (AcaoNaoConformidadeVO)this.acaoNaoConformidadeService.pesquisaVO(Laboratorio.getInstancia(), new AcaoNaoConformidadeVO(), "Pesquisando a\u00e7\u00f5es", true);
        if (acaoNaoConformidadeVO != null) {
            this.acaoNaoConformidadeVO = acaoNaoConformidadeVO;
            this.textoCodAcao.setText(acaoNaoConformidadeVO.getCodigo().toString());
            this.labelDescAcao.setText(acaoNaoConformidadeVO.getDescricao());
        } else {
            this.labelDescAcao.setText("N\u00e3o cadastrado");
            this.textoCodAcao.selectAll();
        }
        this.setFoco(this.textoCodAcao);
    }

    private void pesquisarNaoConformidade() {
        try {
            NaoConformidadeVO vo = (NaoConformidadeVO)this.naoConformidadeService.pesquisaVONcf(Laboratorio.getInstancia(), new NaoConformidadeVO(), "Pesquisando n\u00e3o conformidades", true, "L");
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("nac_codigo", vo.getCodigo());
                this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
                this.tipoNaoConformidadeVO = this.naoConformidadeBean.getTipoNaoConformidade();
                this.preencherCamposNcf();
                this.textoDataAnaliseNcf.setText(Funcoes.formataData(Calendar.getInstance().getTime()));
                this.setFoco(this.textoDataAnaliseNcf);
            } else {
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                this.naoConformidadeBean = null;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void preencherCamposNcf() {
        if (this.naoConformidadeBean != null) {
            this.labelCodigoVlrNcf.setText(this.naoConformidadeBean.getCodigo().toString());
            this.labelUserVlrNcf.setText(this.naoConformidadeBean.getUsuario() + " em " + Funcoes.formataData(this.naoConformidadeBean.getNcfData()));
            this.labelUserAnaliseVlrNcf.setText(Variaveis.login);
            this.textCodProcedencia.setText(this.procedencia());
            this.labelVlrDescProcedencia.setText(this.descricaoProcedencia());
            this.textDescAdicional.setText(this.naoConformidadeBean.getAdicional());
            this.procedenciaVo = this.naoConformidadeBean.getProcedenciaNaoConformidade();
            this.textCodOrigem.setText(this.descricaoOrigem());
            this.labelVlrOrigem.setText(this.valorOrigem());
            this.textCodTipo.setText(this.descricaoTipo());
            this.labelVlrTipo.setText(this.valorTipo());
            this.origemNaoConformidadeVO = this.naoConformidadeBean.getOrigemNaoConformidade();
            for (SetorNaoConformidadeVO setorNcf : this.naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                this.addLinhaTabelaSetor(setorNcf);
            }
        }
    }

    private String valorTipo() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getTipoNaoConformidade() == null || this.naoConformidadeBean.getTipoNaoConformidade().getDescricao() == null) {
            return "";
        }
        return this.naoConformidadeBean.getTipoNaoConformidade().getDescricao();
    }

    private String descricaoTipo() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getTipoNaoConformidade() == null) {
            return "";
        }
        return this.naoConformidadeBean.getTipoNaoConformidade().getCodigo().toString();
    }

    private String valorOrigem() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getOrigemNaoConformidade() == null || this.naoConformidadeBean.getOrigemNaoConformidade().getDescricao() == null) {
            return "";
        }
        return this.naoConformidadeBean.getOrigemNaoConformidade().getDescricao();
    }

    private String descricaoOrigem() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getOrigemNaoConformidade() == null) {
            return "";
        }
        return this.naoConformidadeBean.getOrigemNaoConformidade().getCodigo().toString();
    }

    private String descricaoProcedencia() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getProcedenciaNaoConformidade() == null) {
            return "";
        }
        return this.naoConformidadeBean.getProcedenciaNaoConformidade().getDescricao();
    }

    private String procedencia() {
        if (this.naoConformidadeBean == null || this.naoConformidadeBean.getProcedenciaNaoConformidade() == null || this.naoConformidadeBean.getProcedenciaNaoConformidade().getCodigo() == null) {
            return "";
        }
        return this.naoConformidadeBean.getProcedenciaNaoConformidade().getCodigo().toString();
    }

    public static long getModuloAcessoOcultarProcedencia() {
        return 105000107L;
    }

    public static long getModuloAcessoOcultarOrigem() {
        return 105000108L;
    }

    class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            isSelected = false;
            Funcoes.imagemPesquisa(this);
            return this;
        }
    }

    class ButtonEditor
    extends DefaultCellEditor {
        private JButton button;
        int linha;

        public ButtonEditor() {
            super(new JCheckBox());
            this.linha = -1;
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.setPreferredSize(new Dimension(40, 40));
            this.button.setMinimumSize(new Dimension(40, 40));
            Funcoes.imagemPesquisa(this.button);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.linha = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            SetorNaoConformidadeVO resultado;
            if (this.linha > -1 && (resultado = (SetorNaoConformidadeVO)AnalisarAcao.this.modeloSetor.getValueAt(this.linha, 4)) != null) {
                Container container = AnalisarAcao.this.getTopLevelAncestor();
                DetalheCritica detalheCritica = null;
                detalheCritica = container instanceof Dialog ? new DetalheCritica((Dialog)AnalisarAcao.this.getTopLevelAncestor(), "Detalhe cr\u00edtica", resultado) : new DetalheCritica((Frame)AnalisarAcao.this.getTopLevelAncestor(), "Detalhe cr\u00edtica", resultado);
                if (detalheCritica != null) {
                    detalheCritica.setVisible(true);
                }
                return resultado;
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.linha = -1;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}

