/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.qualidade.naoconformidade;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.qualidade.naoconformidade.UsuarioNotificado;
import jalis.laboratorio.relatorios.qualidade.ImprimirNaoConformidade;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.NaoConformidadeBean;
import jalis.model.bean.cadastro.RequisicaoNaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.NaoConformidadeVO;
import jalis.model.vo.cadastro.OrigemNaoConformidadeVO;
import jalis.model.vo.cadastro.ProcedenciaNaoConformidadeVO;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.model.vo.cadastro.TipoNaoConformidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.NaoConformidadeService;
import jalis.service.cadastro.OrigemNaoConformidadeService;
import jalis.service.cadastro.ProcedenciaNaoConformidadeService;
import jalis.service.cadastro.TipoNaoConformidadeService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AbrirNaoConformidade
extends FrmCadPadraoBean
implements ActionListener {
    private static final String OCULTA_PROCEDENCIA = "0105000104";
    private static final String OCULTA_ORIGEM = "0105000105";
    private static final String OCULTA_DETALHE = "0105000106";
    private static final Integer COLUNA_LOTE = 3;
    private static final Integer COLUNA_SETOR = 4;
    private static final Integer COLUNA_NOTIFICADO = 3;
    private static final Integer COLUNA_REQUISICAO = 2;
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelProcedencia = new JLabel("Proced\u00eancia:");
    private JLabel labelAdicional = new JLabel("Adicional:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelTelefone = new JLabel("Telefone:");
    private JLabel labelDataNcf = new JLabel("Data:");
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelFornecedor = new JLabel("Fornecedor:");
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelNotaFiscal = new JLabel("Notal Fiscal:");
    private JLabel labelCodLote = new JLabel("C\u00f3digo:");
    private JLabel labelCodSetor = new JLabel("Setor:");
    private JLabel labelDescricaoSetor = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelDescricaoNcf = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelNotificado = new JLabel("Notificado:");
    private JLabel labelOrigem = new JLabel("Origem:");
    private JLabel labelTipo = new JLabel("Tipo:");
    private JLabel labelVlrTipo = new JLabel();
    private JLabel labelVlrOrigem = new JLabel();
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrDescProcedencia = new JLabel();
    private JLabel labelVlrDescRequisicao = new JLabel();
    private JLabel labelVlrDescConvenio = new JLabel();
    private JLabel labelVlrDescFornecedor = new JLabel();
    private JLabel labelVlrDescMaterial = new JLabel();
    private JLabel labelVlrDescLote = new JLabel();
    private JLabel labelVlrDescSetor = new JLabel();
    private JLabel labelVlrDataNcf = new JLabel();
    private JLabel labelVlrCodConvenio = new JLabel();
    private JLabel labelResponsavelSetor = new JLabel();
    private JLabel labelVlrNotificado = new JLabel();
    private TTextField textData = new TTextField(10, 4);
    private TTextField textCodProcedencia = new TTextField(9, 1);
    private TTextField textDescAdicional = new TTextField(100);
    private TTextField textCodRequisicao = new TTextField(50, 1);
    private JLabel labelDescTelefone = new JLabel();
    private TTextField textCodFornecedor = new TTextField(12, 1);
    private TTextField textCodMaterial = new TTextField(12, 1);
    private TTextField textCodNotaFiscal = new TTextField(12, 1);
    private TTextField textCodLote = new TTextField(12, 1);
    private TTextField textCodSetor = new TTextField(12, 1);
    private TTextField textCodOrigem = new TTextField(12, 1);
    private TTextField textCodTipo = new TTextField(12, 1);
    private JTextArea textAreaDescricao = new JTextArea();
    private JButton buttonAddSetor = ComponenteFactory.novoJButton("OK", 'K', this);
    private JButton buttonAddLote = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonOrigem = ComponenteFactory.novoJButton(this, true);
    private JButton buttonTipo = ComponenteFactory.novoJButton(this, true);
    private JButton buttonLote = ComponenteFactory.novoJButton(this, true);
    private JButton buttonSetor = ComponenteFactory.novoJButton(this, true);
    private JButton buttonMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonFornecedor = ComponenteFactory.novoJButton(this, true);
    private JButton buttonConvenio = ComponenteFactory.novoJButton(this, true);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonProcedencia = ComponenteFactory.novoJButton(this, true);
    private JButton buttonData = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataNcf = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonBuscarNotificado = ComponenteFactory.novoJButton("...", this);
    private JButton buttonImprimir = new JButton("Imprimir");
    private JCheckBox checkboxUrgente = new JCheckBox("Urgente");
    ModeloGridTable modeloLote = new ModeloGridTable(new String[]{"C\u00f3digo", "Lote", "Data lote"});
    JTable tableLote = new JTable(this.modeloLote);
    JScrollPane scrollPaneLote = new JScrollPane(this.tableLote);
    ModeloGridTable modeloRequisicao = new ModeloGridTable(new String[]{"C\u00f3digo", "Nome"});
    JTable tableRequisicao = new JTable(this.modeloRequisicao);
    JScrollPane scrollPaneRequisicao = new JScrollPane(this.tableRequisicao);
    ModeloGridTable modeloSetores = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Resp."});
    JTable tableSetor = new JTable(this.modeloSetores);
    JScrollPane scrollPaneSetor = new JScrollPane(this.tableSetor);
    private JPanel panelNcf = new JPanel(new GridBagLayout());
    private JPanel panelSetor = new JPanel(new GridBagLayout());
    private JPanel panelLote = new JPanel(new GridBagLayout());
    private JPanel panelLoteSetor = new JPanel(new GridBagLayout());
    private ProcedenciaNaoConformidadeVO procedenciaVo = null;
    private RequisicaoVO requisicaoVO = null;
    private ConvenioVO convenioVO = null;
    private EntidadeVO entidadeVO = null;
    private MaterialVO materialVO = null;
    private MaterialLoteVO materialLoteVo = null;
    private SetorVO setorVO = null;
    private OrigemNaoConformidadeVO origemNaoConformidadeVO = null;
    private TipoNaoConformidadeVO tipoNaoConformidadeVO = null;
    private NotaFiscalVO notaFiscalVO = null;
    private UsuarioVO usuarioVO = null;
    private NotaFiscalService notaFiscalService = new NotaFiscalService();
    private SetorService setorService = new SetorService();
    private MaterialLoteService materialLoteService = new MaterialLoteService();
    private MaterialService materialService = new MaterialService();
    private EntidadeService entidadeService = new EntidadeService();
    private ConvenioService convenioService = new ConvenioService();
    private RequisicaoService requisicaoService = new RequisicaoService();
    private ProcedenciaNaoConformidadeService service = new ProcedenciaNaoConformidadeService();
    private NaoConformidadeBean naoConformidadeBean = null;
    private RequisicaoNaoConformidadeBean requisicaoNaoConformidadeBean = null;
    private NaoConformidadeService naoConformidadeService = new NaoConformidadeService();
    private OrigemNaoConformidadeService origemNaoConformidadeService = new OrigemNaoConformidadeService();
    private TipoNaoConformidadeService tipoNaoConformidadeService = new TipoNaoConformidadeService();
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel painelCrud = new JPanel(new FlowLayout());
    private UsuarioNotificado jDialogNotificados = UsuarioNotificado.novaInstancia(this.getTopLevelAncestor(), this.labelVlrNotificado);
    private boolean editandoSetor = false;

    public AbrirNaoConformidade() {
        try {
            this.montarTela(false);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public AbrirNaoConformidade(NaoConformidadeBean naoConformidadeBean) {
        try {
            this.montarTela(true);
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", naoConformidadeBean.getFilial().getCodigo());
            chaves.put("nac_codigo", naoConformidadeBean.getCodigo());
            this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
            this.preencherCampos(naoConformidadeBean);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Abrir n\u00e3o Conformidade (149)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montarTela(boolean bloquearListenerTabelas) {
        this.jbInit(bloquearListenerTabelas);
        this.controlaCampos();
        this.ocultaProcedencia();
        this.linhaAdicionalVisivel(false);
        this.setModuloInsere(Long.valueOf("1300200101"));
        this.setModuloEdita(Long.valueOf("1300200102"));
        this.setModuloApaga(Long.valueOf("1300200103"));
    }

    private void jbInit(boolean bloquear) {
        this.modeloLote.setColumnSize(new int[]{80, 0, 100}, this.tableLote);
        this.modeloSetores.setColumnSize(new int[]{80, 0, 0}, this.tableSetor);
        this.modeloRequisicao.setColumnSize(new int[]{80, 0}, this.tableRequisicao);
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrOrigem, this.labelVlrCodigo, this.labelVlrUsuario, this.labelVlrDescLote, this.labelVlrDescProcedencia, this.labelVlrDescRequisicao, this.labelVlrDescConvenio, this.labelVlrDescFornecedor, this.labelVlrDescMaterial, this.labelVlrDescSetor, this.labelVlrCodConvenio, this.labelVlrDataNcf, this.labelDescTelefone, this.labelResponsavelSetor, this.labelVlrNotificado, this.labelVlrTipo}, new TitledBorder(""));
        this.setLabelFormulario("Abrir n\u00e3o conformidade");
        this.setLabelDescricao("Abrir n\u00e3o conformidade");
        this.tableRequisicao.getTableHeader().addMouseListener(this.modeloRequisicao);
        this.tableSetor.getTableHeader().addMouseListener(this.modeloSetores);
        this.setIcone(ImagemUtils.carregaImagemJalis("qualidade/qualidade_abrir_nc.jpg"));
        Funcoes.imagemPesquisa(this.buttonData);
        this.panelNcf.setBorder(new TitledBorder("N\u00e3o conformidade"));
        this.panelLote.setBorder(new TitledBorder("Lote"));
        this.panelSetor.setBorder(new TitledBorder("Setores envolvidos"));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints bagLayout = new GridBagConstraints();
        this.criaLinhaCodigo(bagLayout);
        this.criaLinhaProcedencia(bagLayout);
        this.criaLinhaAdicional(bagLayout);
        this.criaOrigem(bagLayout);
        this.criaTipo(bagLayout);
        this.criaPainelNcf(bagLayout);
        bagLayout = new GridBagConstraints();
        this.criaLinhaRequisicao(bagLayout);
        this.criaLinhaTelefone(bagLayout);
        this.criaLinhaFornecedor(bagLayout);
        this.criaLinhaMaterial(bagLayout);
        this.criaPainelLote(bagLayout);
        this.criaLinhaLote();
        this.criaPainelSetor(bagLayout);
        this.criaLinhaSetor();
        this.criaDescricaoNcf(bagLayout);
        this.addListener(bloquear);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelOpcoes.add(this.buttonImprimir);
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)this.painelCrud, "East");
        this.painelCrud.add(this.botaoNovo);
        this.painelCrud.add(this.botaoEditar);
        this.painelCrud.add(this.botaoSalvar);
        this.painelCrud.add(this.botaoCancelar);
        this.painelCrud.add(this.botaoExcluir);
        this.painelCrud.add(this.botaoFechar);
        this.textAreaDescricao.setWrapStyleWord(true);
        this.textAreaDescricao.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textAreaDescricao);
        ScreenUtil.posicionaTextoTopo(this.textAreaDescricao);
        this.buttonImprimir.setMnemonic('R');
        this.buttonImprimir.setVisible(Acesso.getAcesso(ImprimirNaoConformidade.getModuloAcesso()));
        this.labelData.setDisplayedMnemonic('D');
        this.labelData.setLabelFor(this.textData);
        this.labelProcedencia.setDisplayedMnemonic('P');
        this.labelProcedencia.setLabelFor(this.textCodProcedencia);
        this.labelOrigem.setDisplayedMnemonic('I');
        this.labelOrigem.setLabelFor(this.textCodOrigem);
        this.labelTipo.setDisplayedMnemonic('O');
        this.labelTipo.setLabelFor(this.textCodTipo);
        this.labelRequisicao.setDisplayedMnemonic('Q');
        this.labelRequisicao.setLabelFor(this.textCodRequisicao);
        this.labelCodSetor.setDisplayedMnemonic('T');
        this.labelCodSetor.setLabelFor(this.textCodSetor);
        this.labelDescricaoNcf.setDisplayedMnemonic('E');
        this.labelDescricaoNcf.setLabelFor(this.textAreaDescricao);
        this.ocultaCampos();
    }

    private void criaOrigem(GridBagConstraints bagLayout) {
        if (!Acesso.getAcesso(this.getModuloAcessoOcultarOrigem())) {
            bagLayout.weightx = 0.0;
            bagLayout.gridx = 0;
            ++bagLayout.gridy;
            bagLayout.gridwidth = 1;
            bagLayout.anchor = 17;
            bagLayout.insets = new Insets(0, 0, 0, 0);
            this.painelCentral.add((Component)this.labelOrigem, bagLayout);
            ++bagLayout.gridx;
            bagLayout.insets = new Insets(0, 0, 0, 1);
            this.textCodOrigem.setPreferredSize(new Dimension(97, 20));
            this.textCodOrigem.setMinimumSize(new Dimension(97, 20));
            this.painelCentral.add((Component)this.textCodOrigem, bagLayout);
            bagLayout.insets = new Insets(0, 0, 0, 1);
            ++bagLayout.gridx;
            this.buttonOrigem.setPreferredSize(new Dimension(19, 20));
            this.buttonOrigem.setMinimumSize(new Dimension(19, 20));
            this.painelCentral.add((Component)this.buttonOrigem, bagLayout);
            bagLayout.insets = new Insets(0, 0, 0, 0);
            JPanel panelOrigem = new JPanel(new GridBagLayout());
            GridBagConstraints origem = new GridBagConstraints();
            origem.fill = 2;
            origem.gridx = 0;
            origem.gridy = 0;
            origem.weightx = 1.0;
            origem.insets = new Insets(0, 0, 0, 1);
            this.labelVlrOrigem.setPreferredSize(new Dimension(20, 20));
            this.labelVlrOrigem.setMinimumSize(new Dimension(20, 20));
            panelOrigem.add((Component)this.labelVlrOrigem, origem);
            ++origem.gridx;
            origem.fill = 17;
            origem.weightx = 0.0;
            origem.insets = new Insets(0, 1, 0, 1);
            ++bagLayout.gridx;
            bagLayout.insets = new Insets(0, 0, 0, 1);
            bagLayout.fill = 2;
            bagLayout.weightx = 1.0;
            bagLayout.gridwidth = 6;
            this.painelCentral.add((Component)panelOrigem, bagLayout);
        }
    }

    private void criaTipo(GridBagConstraints bagLayout) {
        bagLayout.weightx = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 1;
        bagLayout.anchor = 17;
        bagLayout.insets = new Insets(0, 0, 0, 0);
        this.painelCentral.add((Component)this.labelTipo, bagLayout);
        ++bagLayout.gridx;
        bagLayout.insets = new Insets(0, 0, 0, 1);
        this.textCodTipo.setPreferredSize(new Dimension(97, 20));
        this.textCodTipo.setMinimumSize(new Dimension(97, 20));
        this.painelCentral.add((Component)this.textCodTipo, bagLayout);
        bagLayout.insets = new Insets(0, 0, 0, 1);
        ++bagLayout.gridx;
        this.buttonTipo.setPreferredSize(new Dimension(19, 20));
        this.buttonTipo.setMinimumSize(new Dimension(19, 20));
        this.painelCentral.add((Component)this.buttonTipo, bagLayout);
        bagLayout.insets = new Insets(0, 0, 0, 0);
        JPanel panelTipo = new JPanel(new GridBagLayout());
        GridBagConstraints tipo = new GridBagConstraints();
        tipo.fill = 2;
        tipo.gridx = 0;
        tipo.gridy = 0;
        tipo.weightx = 1.0;
        tipo.insets = new Insets(0, 0, 0, 1);
        this.labelVlrTipo.setPreferredSize(new Dimension(20, 20));
        this.labelVlrTipo.setMinimumSize(new Dimension(20, 20));
        panelTipo.add((Component)this.labelVlrTipo, tipo);
        ++tipo.gridx;
        tipo.fill = 17;
        tipo.weightx = 0.0;
        tipo.insets = new Insets(0, 1, 0, 1);
        ++bagLayout.gridx;
        bagLayout.insets = new Insets(0, 0, 0, 1);
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.gridwidth = 6;
        this.painelCentral.add((Component)panelTipo, bagLayout);
    }

    private void ocultaCampos() {
        this.labelTelefone.setVisible(false);
        this.labelDescTelefone.setVisible(false);
        this.labelDataNcf.setVisible(false);
        this.labelVlrDataNcf.setVisible(false);
        this.labelConvenio.setVisible(false);
        this.labelVlrDescConvenio.setVisible(false);
        this.labelFornecedor.setVisible(false);
        this.labelVlrDescFornecedor.setVisible(false);
        this.textCodFornecedor.setVisible(false);
        this.buttonFornecedor.setVisible(false);
        this.labelMaterial.setVisible(false);
        this.textCodMaterial.setVisible(false);
        this.buttonMaterial.setVisible(false);
        this.labelVlrDescMaterial.setVisible(false);
        this.labelNotaFiscal.setVisible(false);
        this.textCodNotaFiscal.setVisible(false);
        this.panelLote.setVisible(false);
    }

    private void addListener(boolean bloquear) {
        this.labelVlrDataNcf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.buttonDataNcf.doClick();
                }
            }
        });
        this.textCodOrigem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.buttonOrigem.doClick();
                }
            }
        });
        this.textCodTipo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.buttonTipo.doClick();
                }
            }
        });
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.buttonData.doClick();
                }
            }
        });
        this.textCodFornecedor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.pesquisaFornecedor();
                }
            }
        });
        this.textCodMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.pesquisaMaterial();
                }
            }
        });
        this.textCodLote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.pesquisaLote();
                }
            }
        });
        this.textCodSetor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.pesquisaSetor();
                }
            }
        });
        this.textCodRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.pesquisaRequisicao();
                }
            }
        });
        this.textCodProcedencia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AbrirNaoConformidade.this.pesquisaProcedencia();
                }
            }
        });
        this.textCodMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (Funcoes.textoVazio(AbrirNaoConformidade.this.textCodMaterial)) {
                        AbrirNaoConformidade.this.labelVlrDescMaterial.setText("");
                        AbrirNaoConformidade.this.labelVlrDescMaterial.repaint();
                        AbrirNaoConformidade.this.materialVO = null;
                    }
                    if (AbrirNaoConformidade.this.materialVO != null && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodMaterial) && AbrirNaoConformidade.this.materialVO.getCodigo().toString().equals(AbrirNaoConformidade.this.textCodMaterial.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AbrirNaoConformidade.this.textCodMaterial.getText())) {
                        AbrirNaoConformidade.this.materialVO = (MaterialVO)AbrirNaoConformidade.this.materialService.getAtivoVO(Variaveis.filialPadrao, AbrirNaoConformidade.this.textCodMaterial.getText());
                        if (AbrirNaoConformidade.this.materialVO != null) {
                            AbrirNaoConformidade.this.textCodMaterial.setText(AbrirNaoConformidade.this.materialVO.getCodigo().toString());
                            AbrirNaoConformidade.this.labelVlrDescMaterial.setText(AbrirNaoConformidade.this.materialVO.getDescricao());
                        } else {
                            AbrirNaoConformidade.this.labelVlrDescMaterial.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodMaterial.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Material n\u00e3o identificado", 1);
                }
            }
        });
        this.textCodOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (Funcoes.textoVazio(AbrirNaoConformidade.this.textCodOrigem)) {
                        AbrirNaoConformidade.this.labelVlrOrigem.setText("");
                        AbrirNaoConformidade.this.labelVlrOrigem.repaint();
                        AbrirNaoConformidade.this.origemNaoConformidadeVO = null;
                    }
                    if (AbrirNaoConformidade.this.origemNaoConformidadeVO != null && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodOrigem) && AbrirNaoConformidade.this.origemNaoConformidadeVO.getCodigo().toString().equals(AbrirNaoConformidade.this.textCodOrigem.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AbrirNaoConformidade.this.textCodOrigem.getText())) {
                        AbrirNaoConformidade.this.origemNaoConformidadeVO = (OrigemNaoConformidadeVO)AbrirNaoConformidade.this.origemNaoConformidadeService.loadVOCast(" where onc_codigo = " + AbrirNaoConformidade.this.textCodOrigem.getText() + " and fil_codigo = " + Variaveis.filialPadrao);
                        if (AbrirNaoConformidade.this.origemNaoConformidadeVO != null) {
                            AbrirNaoConformidade.this.textCodOrigem.setText(AbrirNaoConformidade.this.origemNaoConformidadeVO.getCodigo().toString());
                            AbrirNaoConformidade.this.labelVlrOrigem.setText(AbrirNaoConformidade.this.origemNaoConformidadeVO.getDescricao());
                        } else {
                            AbrirNaoConformidade.this.labelVlrOrigem.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodOrigem.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Origem n\u00e3o identificada", 1);
                }
            }
        });
        this.textCodTipo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (Funcoes.textoVazio(AbrirNaoConformidade.this.textCodTipo)) {
                        AbrirNaoConformidade.this.labelVlrTipo.setText("");
                        AbrirNaoConformidade.this.labelVlrTipo.repaint();
                        AbrirNaoConformidade.this.tipoNaoConformidadeVO = null;
                    }
                    if (AbrirNaoConformidade.this.tipoNaoConformidadeVO != null && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodTipo) && AbrirNaoConformidade.this.tipoNaoConformidadeVO.getCodigo().toString().equals(AbrirNaoConformidade.this.labelVlrTipo.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AbrirNaoConformidade.this.textCodTipo.getText())) {
                        AbrirNaoConformidade.this.tipoNaoConformidadeVO = (TipoNaoConformidadeVO)AbrirNaoConformidade.this.tipoNaoConformidadeService.loadVOCast(" where tcf_codigo = " + AbrirNaoConformidade.this.textCodTipo.getText() + " and fil_codigo = " + Variaveis.filialPadrao);
                        if (AbrirNaoConformidade.this.tipoNaoConformidadeVO != null) {
                            AbrirNaoConformidade.this.textCodTipo.setText(AbrirNaoConformidade.this.tipoNaoConformidadeVO.getCodigo().toString());
                            AbrirNaoConformidade.this.labelVlrTipo.setText(AbrirNaoConformidade.this.tipoNaoConformidadeVO.getDescricao());
                        } else {
                            AbrirNaoConformidade.this.labelVlrTipo.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodTipo.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Tipo n\u00e3o identificado", 1);
                }
            }
        });
        this.textCodProcedencia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (AbrirNaoConformidade.this.procedenciaVo != null && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodProcedencia.getText()) && AbrirNaoConformidade.this.procedenciaVo.getCodigo().toString().equals(AbrirNaoConformidade.this.textCodProcedencia.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AbrirNaoConformidade.this.textCodProcedencia.getText())) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", Variaveis.filialPadrao);
                        chaves.put("pnc_codigo", AbrirNaoConformidade.this.textCodProcedencia.getText());
                        AbrirNaoConformidade.this.procedenciaVo = (ProcedenciaNaoConformidadeVO)AbrirNaoConformidade.this.service.getVO(chaves);
                        if (AbrirNaoConformidade.this.procedenciaVo != null) {
                            if (AbrirNaoConformidade.this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
                                AbrirNaoConformidade.this.linhaAdicionalVisivel(true);
                            } else {
                                AbrirNaoConformidade.this.linhaAdicionalVisivel(false);
                            }
                            AbrirNaoConformidade.this.textCodProcedencia.setText(AbrirNaoConformidade.this.procedenciaVo.getCodigo().toString());
                            AbrirNaoConformidade.this.labelVlrDescProcedencia.setText(AbrirNaoConformidade.this.procedenciaVo.getDescricao());
                        } else {
                            AbrirNaoConformidade.this.labelVlrDescProcedencia.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodProcedencia.selectAll();
                        }
                    }
                }
                catch (ThreadDaoException e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Proced\u00eancia n\u00e3o identificada", 1);
                }
            }
        });
        this.textCodRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (AbrirNaoConformidade.this.requisicaoVO != null && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodRequisicao) && AbrirNaoConformidade.this.requisicaoVO.getCodigo().toString().equals(AbrirNaoConformidade.this.textCodRequisicao.getText())) {
                        return;
                    }
                    if (AbrirNaoConformidade.this.processarNumeroTubo(null, AbrirNaoConformidade.this.textCodRequisicao) && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodRequisicao.getText())) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", Variaveis.filialPadrao);
                        chaves.put("req_codigo", AbrirNaoConformidade.this.textCodRequisicao.getText());
                        AbrirNaoConformidade.this.requisicaoVO = (RequisicaoVO)AbrirNaoConformidade.this.requisicaoService.getVO(chaves);
                        if (AbrirNaoConformidade.this.requisicaoVO != null && !AbrirNaoConformidade.this.requisicaoVO.getExcluida().booleanValue()) {
                            AbrirNaoConformidade.this.mostrarDadoRequisicao(AbrirNaoConformidade.this.requisicaoVO);
                        } else {
                            AbrirNaoConformidade.this.labelVlrDescRequisicao.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodRequisicao.selectAll();
                        }
                    }
                }
                catch (ThreadDaoException e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "N\u00e3o foi poss\u00edvel consultar requisi\u00e7\u00e3o", 1);
                }
            }
        });
        this.textCodFornecedor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (AbrirNaoConformidade.this.entidadeVO != null && !Funcoes.textoVazio(AbrirNaoConformidade.this.textCodFornecedor) && AbrirNaoConformidade.this.entidadeVO.getCodigo().toString().equals(AbrirNaoConformidade.this.textCodFornecedor.getText())) {
                        return;
                    }
                    if (!Funcoes.textoVazio(AbrirNaoConformidade.this.textCodFornecedor.getText())) {
                        AbrirNaoConformidade.this.entidadeVO = (EntidadeVO)AbrirNaoConformidade.this.entidadeService.getVO(Variaveis.filialPadrao, AbrirNaoConformidade.this.textCodFornecedor.getText());
                        if (AbrirNaoConformidade.this.entidadeVO != null) {
                            AbrirNaoConformidade.this.textCodFornecedor.setText(AbrirNaoConformidade.this.getCodigoFornecedor().toString());
                            AbrirNaoConformidade.this.labelVlrDescFornecedor.setText(AbrirNaoConformidade.this.entidadeVO.getFantasia());
                        } else {
                            AbrirNaoConformidade.this.labelVlrDescFornecedor.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodFornecedor.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Fornecedor n\u00e3o identificado", 1);
                }
            }
        });
        this.textCodSetor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AbrirNaoConformidade.this.labelResponsavelSetor.setText("");
                    AbrirNaoConformidade.this.labelVlrDescSetor.setText("");
                    if (!Funcoes.textoVazio(AbrirNaoConformidade.this.textCodSetor.getText())) {
                        AbrirNaoConformidade.this.setorVO = (SetorVO)AbrirNaoConformidade.this.setorService.getVO(Variaveis.filialPadrao, AbrirNaoConformidade.this.textCodSetor.getText());
                        if (AbrirNaoConformidade.this.setorVO != null) {
                            AbrirNaoConformidade.this.textCodSetor.setText(AbrirNaoConformidade.this.setorVO.getCodigo().toString());
                            AbrirNaoConformidade.this.labelVlrDescSetor.setText(AbrirNaoConformidade.this.setorVO.getDescricao());
                            AbrirNaoConformidade.this.labelResponsavelSetor.setText(AbrirNaoConformidade.this.setorVO.getUsuario().getCodigo());
                            AbrirNaoConformidade.this.labelVlrNotificado.setText("");
                            AbrirNaoConformidade.this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
                        } else {
                            AbrirNaoConformidade.this.labelVlrDescSetor.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.labelResponsavelSetor.setText("");
                            AbrirNaoConformidade.this.labelVlrNotificado.setText("");
                            AbrirNaoConformidade.this.textCodSetor.selectAll();
                            AbrirNaoConformidade.this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Setor n\u00e3o identificado", 1);
                }
            }
        });
        this.textCodLote.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    AbrirNaoConformidade.this.labelVlrDescLote.setText("");
                    if (AbrirNaoConformidade.this.materialInformado() && !AbrirNaoConformidade.this.validaLote()) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", Variaveis.filialPadrao);
                        chaves.put("mll_codigo", AbrirNaoConformidade.this.textCodLote.getText());
                        chaves.put("mat_codigo", AbrirNaoConformidade.this.textCodMaterial.getText());
                        AbrirNaoConformidade.this.materialLoteVo = (MaterialLoteVO)AbrirNaoConformidade.this.materialLoteService.getVO(chaves);
                        if (AbrirNaoConformidade.this.materialLoteVo != null) {
                            AbrirNaoConformidade.this.textCodLote.setText(AbrirNaoConformidade.this.materialLoteVo.getCodigo().toString());
                            AbrirNaoConformidade.this.labelVlrDescLote.setText(AbrirNaoConformidade.this.materialLoteVo.getLote());
                        } else {
                            AbrirNaoConformidade.this.labelVlrDescLote.setText("N\u00e3o cadastrado");
                            AbrirNaoConformidade.this.textCodLote.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "N\u00e3o foi poss\u00edvel consultar lote.", 1);
                }
            }
        });
        this.buttonAddLote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbrirNaoConformidade.this.materialInformado() && AbrirNaoConformidade.this.loteInformado()) {
                    if (AbrirNaoConformidade.this.modeloLote.getRowCount() == 0) {
                        AbrirNaoConformidade.this.addLoteTable();
                    } else {
                        for (int i = 0; i < AbrirNaoConformidade.this.modeloLote.getRowCount(); ++i) {
                            Integer codigo = (Integer)AbrirNaoConformidade.this.modeloLote.getValueAt(i, AbrirNaoConformidade.this.modeloLote.findColumn("C\u00f3digo"));
                            if (codigo == null || !AbrirNaoConformidade.this.loteJaInformado(codigo)) continue;
                            Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Lote j\u00e1 inserido", 2);
                            return;
                        }
                        AbrirNaoConformidade.this.addLoteTable();
                    }
                }
            }
        });
        this.buttonAddSetor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbrirNaoConformidade.this.setorlInformado() && AbrirNaoConformidade.this.setorInformado()) {
                    if (AbrirNaoConformidade.this.modeloSetores.getRowCount() == 0) {
                        AbrirNaoConformidade.this.addSetorTable();
                    } else {
                        if (!AbrirNaoConformidade.this.editandoSetor) {
                            for (int i = 0; i < AbrirNaoConformidade.this.modeloSetores.getRowCount(); ++i) {
                                Integer codigo = (Integer)AbrirNaoConformidade.this.modeloSetores.getValueAt(i, AbrirNaoConformidade.this.modeloSetores.findColumn("C\u00f3digo"));
                                if (codigo == null || !AbrirNaoConformidade.this.setorJaInformado(codigo)) continue;
                                Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Setor j\u00e1 inserido", 2);
                                return;
                            }
                        }
                        AbrirNaoConformidade.this.addSetorTable();
                    }
                }
            }
        });
        this.buttonAddRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbrirNaoConformidade.this.requisicaoInformada() && AbrirNaoConformidade.this.validarRequisicao()) {
                    if (AbrirNaoConformidade.this.modeloRequisicao.getRowCount() == 0) {
                        AbrirNaoConformidade.this.addRequisicaoTable();
                    } else {
                        for (int i = 0; i < AbrirNaoConformidade.this.modeloRequisicao.getRowCount(); ++i) {
                            Integer codigo = (Integer)AbrirNaoConformidade.this.modeloRequisicao.getValueAt(i, AbrirNaoConformidade.this.modeloRequisicao.findColumn("C\u00f3digo"));
                            if (codigo == null || !AbrirNaoConformidade.this.requisicaoJaInformada(codigo)) continue;
                            Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Requisi\u00e7\u00e3o j\u00e1 inserida.", 2);
                            return;
                        }
                        AbrirNaoConformidade.this.addRequisicaoTable();
                    }
                }
            }
        });
        if (!bloquear) {
            this.tableSetor.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AbrirNaoConformidade.this.editarSetor();
                    }
                }
            });
            this.tableSetor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        AbrirNaoConformidade.this.editarSetor();
                    }
                }
            });
            this.tableLote.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int resp;
                    int row;
                    if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Deseja remover o lote da composi\u00e7\u00e3o?", 4)) == 0) {
                        AbrirNaoConformidade.this.modeloLote.removeLine(row);
                    }
                }
            });
            this.tableSetor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int resp;
                    int row;
                    if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Deseja remover o setor da composi\u00e7\u00e3o?", 4)) == 0) {
                        AbrirNaoConformidade.this.modeloSetores.removeLine(row);
                    }
                }
            });
            this.tableRequisicao.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int resp;
                    int row;
                    if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(AbrirNaoConformidade.this.painelCentral, "Deseja remover a requisi\u00e7\u00e3o da composi\u00e7\u00e3o?", 4)) == 0) {
                        AbrirNaoConformidade.this.modeloRequisicao.removeLine(row);
                    }
                }
            });
        }
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbrirNaoConformidade.this.imprimirRelatorio();
            }
        });
    }

    private void imprimirRelatorio() {
        if (this.naoConformidadeBean == null && Funcoes.textoVazio(this.labelVlrCodigo.getText())) {
            this.pesquisar();
        }
        if (!Funcoes.textoVazio(this.labelVlrCodigo.getText())) {
            new ImprimirNaoConformidade(Integer.valueOf(this.labelVlrCodigo.getText()));
        } else if (this.naoConformidadeBean != null) {
            new ImprimirNaoConformidade((int)this.naoConformidadeBean.getCodigo());
        }
        this.naoConformidadeBean = null;
        this.limparCampos();
        this.setStatus(1);
        this.controlaCampos();
    }

    private void editarSetor() {
        this.editandoSetor = true;
        int linhaSelecionada = this.tableSetor.getSelectedRow();
        if (linhaSelecionada < 0) {
            return;
        }
        this.setorVO = (SetorVO)this.modeloSetores.getValueAt(linhaSelecionada, COLUNA_SETOR);
        this.textCodSetor.setText(this.setorVO.getCodigo().toString());
        this.labelVlrDescSetor.setText(this.setorVO.getDescricao());
        this.labelResponsavelSetor.setText(this.setorVO.getUsuario().getCodigo());
        this.labelVlrNotificado.setText(this.montaUsuariosNotificados((List)this.modeloSetores.getValueAt(linhaSelecionada, COLUNA_SETOR + 1)));
        this.jDialogNotificados.limparModeloNotificados();
        this.jDialogNotificados.addListaSetoresUsuario((List)this.modeloSetores.getValueAt(linhaSelecionada, COLUNA_SETOR + 1));
    }

    private void addLoteTable() {
        this.addLinhaTabelaLote(this.materialLoteVo);
        this.textCodLote.setText("");
        this.labelVlrDescLote.setText("");
        this.setFoco(this.textCodLote);
    }

    private void addLinhaTabelaLote(MaterialLoteVO materialLoteVo) {
        this.modeloLote.addLine(new Object[]{materialLoteVo.getCodigo(), materialLoteVo.getLote(), Funcoes.formataData(materialLoteVo.getDataLote()), materialLoteVo});
    }

    private List<MaterialLoteVO> materialLoteVos() {
        ArrayList<MaterialLoteVO> materialLoteVos = new ArrayList<MaterialLoteVO>();
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            materialLoteVos.add((MaterialLoteVO)this.modeloLote.getValueAt(i, COLUNA_LOTE));
        }
        return materialLoteVos;
    }

    private List<SetorNaoConformidadeVO> setorNcfVos() {
        ArrayList<SetorNaoConformidadeVO> setorVos = new ArrayList<SetorNaoConformidadeVO>();
        for (int i = 0; i < this.modeloSetores.getRowCount(); ++i) {
            SetorNaoConformidadeVO bean = new SetorNaoConformidadeVO();
            SetorVO setor = (SetorVO)this.modeloSetores.getValueAt(i, COLUNA_SETOR);
            bean.setSetor(setor);
            bean.setNaoConformidadeUsuarioBeans((List)this.modeloSetores.getValueAt(i, COLUNA_SETOR + 1));
            bean.setCodResponsavelSetor(setor.getUsuario().getCodigo());
            setorVos.add(bean);
        }
        return setorVos;
    }

    private void addSetorTable() {
        if (this.editandoSetor) {
            Integer setorEditando = (Integer)this.modeloSetores.getValueAt(this.tableSetor.getSelectedRow(), 0);
            if (!setorEditando.equals(this.setorVO.getCodigo())) {
                for (int i = 0; i < this.modeloSetores.getRowCount(); ++i) {
                    Integer codSetor = (Integer)this.modeloSetores.getValueAt(i, 0);
                    if (codSetor == null || !this.setorVO.getCodigo().equals(codSetor)) continue;
                    Funcoes.mensagem(this, "Setor j\u00e1 foi informado.", 2);
                    this.setFoco(this.textCodSetor);
                    return;
                }
            }
            if (this.tableSetor.getSelectedRow() != -1) {
                this.modeloSetores.removeLine(this.tableSetor.getSelectedRow());
            }
        }
        this.setorVO.setResponsavel(this.labelResponsavelSetor.getText());
        this.addLinhaTabelaSetor(this.setorVO);
        this.textCodSetor.setText("");
        this.labelResponsavelSetor.setText("");
        this.labelVlrDescSetor.setText("");
        this.labelVlrNotificado.setText("");
        this.setFoco(this.textCodSetor);
        this.editandoSetor = false;
        this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
    }

    private void addRequisicaoTable() {
        if (Funcoes.textoVazio(this.textCodRequisicao.getText())) {
            Funcoes.mensagem(this, "Informe a requisi\u00e7\u00e3o.", 2);
            this.setFoco(this.textCodRequisicao);
            return;
        }
        this.addLinhaTabelaRequisicao(this.requisicaoVO);
        this.textCodRequisicao.setText("");
        this.labelVlrDescRequisicao.setText("");
        this.setFoco(this.textCodRequisicao);
    }

    private void addLinhaTabelaSetor(SetorVO setorVO) {
        ArrayList<SetorNaoConformidadeUsuarioBean> list = new ArrayList<SetorNaoConformidadeUsuarioBean>();
        SetorNaoConformidadeUsuarioBean conformidadeUsuarioBean = new SetorNaoConformidadeUsuarioBean();
        conformidadeUsuarioBean.setUsuarioVO(setorVO.getUsuario());
        conformidadeUsuarioBean.setDataNotificado(new Date());
        list.add(conformidadeUsuarioBean);
        this.modeloSetores.addLine(new Object[]{setorVO.getCodigo(), setorVO.getDescricao(), setorVO.getResponsavel(), this.labelVlrNotificado.getText(), setorVO, list});
    }

    private void addLinhaTabelaRequisicao(RequisicaoVO requisicaoVO) {
        this.modeloRequisicao.addLine(new Object[]{requisicaoVO.getCodigo(), requisicaoVO.getPaciente().getNome(), requisicaoVO});
    }

    private void addLinhaTabelaSetor(SetorNaoConformidadeVO setorVO) {
        this.modeloSetores.addLine(new Object[]{setorVO.getSetor().getCodigo(), setorVO.getSetor().getDescricao(), setorVO.getCodResponsavelSetor(), this.montaUsuariosNotificados(setorVO.getNaoConformidadeUsuarioBeansTemp()), setorVO.getSetor(), setorVO.getNaoConformidadeUsuarioBeansTemp()});
    }

    private String montaUsuariosNotificados(List<SetorNaoConformidadeUsuarioBean> naoConformidadeUsuarioBeansTemp) {
        StringBuilder retorno = new StringBuilder();
        if (naoConformidadeUsuarioBeansTemp != null) {
            for (SetorNaoConformidadeUsuarioBean setorNaoConformidadeUsuarioBean : naoConformidadeUsuarioBeansTemp) {
                retorno.append(setorNaoConformidadeUsuarioBean.getUsuarioVO().getCodigo());
                retorno.append(", ");
            }
            if (retorno.length() > 0) {
                return retorno.toString().substring(0, retorno.length() - 2);
            }
        }
        return "";
    }

    private boolean loteJaInformado(Integer codigo) {
        if (this.materialLoteVo.getCodigo().equals(codigo)) {
            this.setFoco(this.textCodLote);
            return true;
        }
        return false;
    }

    private boolean setorJaInformado(Integer codigo) {
        if (this.setorVO.getCodigo().equals(codigo)) {
            this.setFoco(this.textCodSetor);
            return true;
        }
        return false;
    }

    private boolean requisicaoJaInformada(Integer codigo) {
        if (this.requisicaoVO.getCodigo().equals(codigo)) {
            this.setFoco(this.textCodRequisicao);
            return true;
        }
        return false;
    }

    private void criaDescricaoNcf(GridBagConstraints bagLayout) {
        ++bagLayout.gridy;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.fill = 17;
        bagLayout.anchor = 17;
        this.panelNcf.add((Component)this.labelDescricaoNcf, bagLayout);
        bagLayout.weighty = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 13;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 2;
        JScrollPane jScrollPane = new JScrollPane(this.textAreaDescricao);
        jScrollPane.setPreferredSize(new Dimension(40, 100));
        jScrollPane.setMinimumSize(new Dimension(40, 100));
        this.panelNcf.add((Component)jScrollPane, bagLayout);
    }

    private void criaPainelLote(GridBagConstraints bagLayout) {
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        bagLayout.fill = 1;
        bagLayout.gridwidth = 12;
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.anchor = 17;
        bagConstraints.fill = 1;
        bagConstraints.weightx = 1.0;
        bagConstraints.weighty = 1.0;
        this.panelLoteSetor.add((Component)this.panelLote, bagConstraints);
    }

    private void criaLinhaSetor() {
        GridBagConstraints bagLayout = new GridBagConstraints();
        bagLayout.insets = new Insets(1, 0, 0, 1);
        bagLayout.gridy = 0;
        bagLayout.gridx = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.anchor = 17;
        bagLayout.fill = 0;
        bagLayout.gridwidth = 1;
        this.panelSetor.add((Component)this.labelCodSetor, bagLayout);
        ++bagLayout.gridx;
        this.textCodSetor.setPreferredSize(new Dimension(80, 20));
        this.textCodSetor.setMinimumSize(new Dimension(80, 20));
        this.panelSetor.add((Component)this.textCodSetor, bagLayout);
        ++bagLayout.gridx;
        this.buttonSetor.setPreferredSize(new Dimension(20, 20));
        this.buttonSetor.setMinimumSize(new Dimension(20, 20));
        this.panelSetor.add((Component)this.buttonSetor, bagLayout);
        ++bagLayout.gridx;
        bagLayout.fill = 2;
        bagLayout.gridwidth = 1;
        this.labelVlrDescSetor.setPreferredSize(new Dimension(80, 20));
        this.labelVlrDescSetor.setMinimumSize(new Dimension(80, 20));
        this.panelSetor.add((Component)this.labelVlrDescSetor, bagLayout);
        bagLayout.insets = new Insets(1, 0, 0, 1);
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.anchor = 17;
        bagLayout.fill = 0;
        bagLayout.gridwidth = 1;
        this.panelSetor.add((Component)new JLabel("Resp.:"), bagLayout);
        ++bagLayout.gridx;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.anchor = 17;
        bagConstraints.fill = 2;
        bagConstraints.gridheight = 1;
        bagConstraints.gridwidth = 1;
        bagConstraints.gridx = 0;
        bagConstraints.gridy = 0;
        bagConstraints.insets = new Insets(0, 0, 0, 1);
        bagConstraints.weightx = 1.0;
        bagConstraints.weighty = 0.0;
        this.labelResponsavelSetor.setPreferredSize(new Dimension(100, 20));
        this.labelResponsavelSetor.setMinimumSize(new Dimension(100, 20));
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.gridwidth = 3;
        panel.add((Component)this.labelResponsavelSetor, bagConstraints);
        this.panelSetor.add((Component)panel, bagLayout);
        ++bagConstraints.gridx;
        bagConstraints.fill = 0;
        bagConstraints.gridheight = 1;
        bagConstraints.gridwidth = 1;
        bagConstraints.weightx = 0.0;
        bagConstraints.weighty = 0.0;
        bagConstraints.insets = new Insets(0, 20, 0, 1);
        this.labelNotificado.setVisible(false);
        panel.add((Component)this.labelNotificado, bagConstraints);
        this.panelSetor.add((Component)panel, bagLayout);
        bagConstraints.insets = new Insets(0, 0, 0, 1);
        GridBagConstraints layoutNotificado = new GridBagConstraints();
        layoutNotificado.gridx = 0;
        layoutNotificado.gridy = 0;
        JPanel jPanelNotificado = new JPanel(new GridBagLayout());
        jPanelNotificado.setVisible(false);
        this.buttonBuscarNotificado.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscarNotificado.setMinimumSize(new Dimension(20, 20));
        this.labelVlrNotificado.setMinimumSize(new Dimension(100, 20));
        this.labelVlrNotificado.setPreferredSize(new Dimension(100, 20));
        layoutNotificado.fill = 2;
        layoutNotificado.weightx = 1.0;
        jPanelNotificado.add((Component)this.labelVlrNotificado, layoutNotificado);
        ++layoutNotificado.gridx;
        layoutNotificado.fill = 17;
        layoutNotificado.weightx = 0.0;
        jPanelNotificado.add((Component)this.buttonBuscarNotificado, layoutNotificado);
        bagConstraints.fill = 2;
        bagConstraints.weightx = 1.0;
        bagConstraints.gridwidth = 1;
        panel.add((Component)jPanelNotificado, bagConstraints);
        this.panelSetor.add((Component)panel, bagLayout);
        ++bagConstraints.gridx;
        bagConstraints.weightx = 0.0;
        bagConstraints.fill = 0;
        bagLayout.fill = 0;
        bagLayout.gridx += 3;
        bagLayout.weightx = 0.0;
        this.buttonAddSetor.setMinimumSize(new Dimension(40, 20));
        this.buttonAddSetor.setPreferredSize(new Dimension(40, 20));
        panel.add((Component)this.buttonAddSetor, bagConstraints);
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.gridwidth = 4;
        bagLayout.fill = 1;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        this.scrollPaneSetor.setPreferredSize(new Dimension(20, 20));
        this.scrollPaneSetor.setMinimumSize(new Dimension(20, 20));
        this.panelSetor.add((Component)this.scrollPaneSetor, bagLayout);
    }

    private void criaPainelSetor(GridBagConstraints bagLayout) {
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        bagLayout.fill = 1;
        bagLayout.gridwidth = 13;
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.anchor = 17;
        bagConstraints.fill = 1;
        bagConstraints.weightx = 1.0;
        bagConstraints.weighty = 1.0;
        bagLayout.gridwidth = 13;
        this.panelLoteSetor.add((Component)this.panelSetor, bagConstraints);
        this.panelNcf.add((Component)this.panelLoteSetor, bagLayout);
    }

    private void criaPainelNcf(GridBagConstraints bagLayout) {
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.fill = 1;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        if (!Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            bagLayout.gridwidth = 9;
        }
        bagLayout.gridwidth = 12;
        this.painelCentral.add((Component)this.panelNcf, bagLayout);
    }

    private void criaLinhaLote() {
        GridBagConstraints bagLayout = new GridBagConstraints();
        bagLayout.insets = new Insets(0, 0, 0, 1);
        bagLayout.gridy = 0;
        bagLayout.gridx = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.anchor = 17;
        bagLayout.fill = 0;
        bagLayout.gridwidth = 1;
        bagLayout.gridx += 2;
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        this.textCodLote.setPreferredSize(new Dimension(80, 20));
        this.textCodLote.setMinimumSize(new Dimension(80, 20));
        this.panelLote.add((Component)this.textCodLote, bagLayout);
        ++bagLayout.gridx;
        this.buttonLote.setPreferredSize(new Dimension(20, 20));
        this.buttonLote.setMinimumSize(new Dimension(20, 20));
        this.panelLote.add((Component)this.buttonLote, bagLayout);
        ++bagLayout.gridx;
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        this.labelVlrDescLote.setPreferredSize(new Dimension(80, 20));
        this.labelVlrDescLote.setMinimumSize(new Dimension(80, 20));
        this.panelLote.add((Component)this.labelVlrDescLote, bagLayout);
        ++bagLayout.gridx;
        bagLayout.weightx = 0.0;
        bagLayout.fill = 0;
        this.buttonAddLote.setMinimumSize(new Dimension(40, 20));
        this.buttonAddLote.setPreferredSize(new Dimension(40, 20));
        this.panelLote.add((Component)this.buttonAddLote, bagLayout);
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.gridwidth = 4;
        bagLayout.fill = 1;
        bagLayout.weightx = 1.0;
        bagLayout.weighty = 1.0;
        this.scrollPaneLote.setPreferredSize(new Dimension(20, 20));
        this.scrollPaneLote.setMinimumSize(new Dimension(20, 20));
        this.panelLote.add((Component)this.scrollPaneLote, bagLayout);
    }

    private void criaLinhaCodigo(GridBagConstraints bagLayout) {
        bagLayout.fill = 0;
        bagLayout.insets = new Insets(1, 0, 0, 1);
        bagLayout.gridx = 0;
        bagLayout.gridy = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.anchor = 17;
        this.painelCentral.add((Component)this.labelCodigo, bagLayout);
        ++bagLayout.gridx;
        this.labelVlrCodigo.setPreferredSize(new Dimension(99, 20));
        this.labelVlrCodigo.setMinimumSize(new Dimension(99, 20));
        bagLayout.gridwidth = 2;
        this.painelCentral.add((Component)this.labelVlrCodigo, bagLayout);
        bagLayout.gridwidth = 1;
        bagLayout.gridx += 2;
        bagLayout.insets = !Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia()) ? new Insets(1, 0, 0, 1) : new Insets(1, 20, 0, 1);
        this.painelCentral.add((Component)this.labelData, bagLayout);
        ++bagLayout.gridx;
        this.textData.setPreferredSize(new Dimension(90, 20));
        this.textData.setMinimumSize(new Dimension(90, 20));
        bagLayout.insets = new Insets(1, 0, 0, 1);
        this.painelCentral.add((Component)this.textData, bagLayout);
        ++bagLayout.gridx;
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonData, bagLayout);
        ++bagLayout.gridx;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 2;
        this.painelCentral.add((Component)new JLabel(), bagLayout);
        bagLayout.weightx = 0.0;
        bagLayout.fill = 0;
        ++bagLayout.gridx;
        bagLayout.insets = new Insets(1, 20, 0, 1);
        this.painelCentral.add((Component)this.labelUsuario, bagLayout);
        bagLayout.insets = new Insets(1, 0, 0, 1);
        ++bagLayout.gridx;
        this.labelVlrUsuario.setPreferredSize(new Dimension(100, 20));
        this.labelVlrUsuario.setMinimumSize(new Dimension(100, 20));
        bagLayout.insets = new Insets(1, 1, 0, 3);
        this.painelCentral.add((Component)this.labelVlrUsuario, bagLayout);
        bagLayout.insets = new Insets(1, 0, 0, 1);
    }

    private void criaLinhaProcedencia(GridBagConstraints bagLayout) {
        if (!Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            bagLayout.fill = 0;
            bagLayout.gridx = 0;
            ++bagLayout.gridy;
            bagLayout.weightx = 0.0;
            bagLayout.insets = new Insets(0, 0, 0, 1);
            this.painelCentral.add((Component)this.labelProcedencia, bagLayout);
            ++bagLayout.gridx;
            this.textCodProcedencia.setPreferredSize(new Dimension(99, 20));
            this.textCodProcedencia.setMinimumSize(new Dimension(99, 20));
            this.painelCentral.add((Component)this.textCodProcedencia, bagLayout);
            ++bagLayout.gridx;
            this.buttonProcedencia.setMinimumSize(new Dimension(20, 20));
            this.buttonProcedencia.setPreferredSize(new Dimension(20, 20));
            this.painelCentral.add((Component)this.buttonProcedencia, bagLayout);
            bagLayout.insets = new Insets(0, 0, 0, 3);
            ++bagLayout.gridx;
            bagLayout.weightx = 1.0;
            bagLayout.fill = 2;
            bagLayout.weighty = 0.0;
            bagLayout.gridwidth = 5;
            this.labelVlrDescProcedencia.setMinimumSize(new Dimension(80, 20));
            this.labelVlrDescProcedencia.setPreferredSize(new Dimension(80, 20));
            this.painelCentral.add((Component)this.labelVlrDescProcedencia, bagLayout);
        }
        bagLayout.fill = 13;
        bagLayout.anchor = 13;
        bagLayout.gridx += 3;
        bagLayout.weightx = 0.0;
        this.checkboxUrgente.setPreferredSize(new Dimension(100, 22));
        this.checkboxUrgente.setMinimumSize(new Dimension(100, 22));
        this.painelCentral.add((Component)this.checkboxUrgente, bagLayout);
    }

    private void criaLinhaAdicional(GridBagConstraints bagLayout) {
        bagLayout.weightx = 0.0;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.gridwidth = 1;
        bagLayout.anchor = 17;
        bagLayout.insets = new Insets(0, 0, 0, 1);
        this.painelCentral.add((Component)this.labelAdicional, bagLayout);
        ++bagLayout.gridx;
        bagLayout.gridwidth = 8;
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.insets = new Insets(0, 0, 1, 2);
        this.textDescAdicional.setMinimumSize(new Dimension(50, 20));
        this.textDescAdicional.setPreferredSize(new Dimension(50, 20));
        this.painelCentral.add((Component)this.textDescAdicional, bagLayout);
    }

    private void criaLinhaRequisicao(GridBagConstraints bagLayout) {
        bagLayout.insets = new Insets(1, 0, 0, 2);
        bagLayout.gridy = 0;
        bagLayout.gridx = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.fill = 0;
        bagLayout.anchor = 17;
        bagLayout.gridwidth = 1;
        this.panelNcf.add((Component)this.labelRequisicao, bagLayout);
        bagLayout.insets = new Insets(1, 0, 0, 1);
        ++bagLayout.gridx;
        this.textCodRequisicao.setMinimumSize(new Dimension(99, 20));
        this.textCodRequisicao.setPreferredSize(new Dimension(99, 20));
        this.panelNcf.add((Component)this.textCodRequisicao, bagLayout);
        ++bagLayout.gridx;
        this.buttonRequisicao.setMinimumSize(new Dimension(20, 20));
        this.buttonRequisicao.setPreferredSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.buttonRequisicao, bagLayout);
        ++bagLayout.gridx;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 2;
        bagLayout.weighty = 0.0;
        bagLayout.gridwidth = 1;
        this.labelVlrDescRequisicao.setPreferredSize(new Dimension(20, 20));
        this.labelVlrDescRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.labelVlrDescRequisicao, bagLayout);
        ++bagLayout.gridx;
        bagLayout.weightx = 0.0;
        bagLayout.gridwidth = 0;
        bagLayout.fill = 13;
        bagLayout.anchor = 13;
        bagLayout.insets = new Insets(1, 0, 0, 0);
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        this.panelNcf.add((Component)this.buttonAddRequisicao, bagLayout);
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.weighty = 1.0;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 1;
        this.scrollPaneRequisicao.setPreferredSize(new Dimension(20, 20));
        this.scrollPaneRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.scrollPaneRequisicao, bagLayout);
    }

    private void criaLinhaTelefone(GridBagConstraints bagLayout) {
        bagLayout.insets = new Insets(0, 0, 0, 1);
        bagLayout.fill = 0;
        bagLayout.gridwidth = 1;
        bagLayout.gridx = 0;
        ++bagLayout.gridy;
        bagLayout.weightx = 0.0;
        this.panelNcf.add((Component)this.labelTelefone, bagLayout);
        ++bagLayout.gridx;
        bagLayout.gridwidth = 2;
        this.labelDescTelefone.setPreferredSize(new Dimension(120, 20));
        this.labelDescTelefone.setMinimumSize(new Dimension(120, 20));
        this.panelNcf.add((Component)this.labelDescTelefone, bagLayout);
        bagLayout.gridx += 2;
        bagLayout.gridwidth = 1;
        bagLayout.insets = new Insets(0, 20, 0, 1);
        this.panelNcf.add((Component)this.labelDataNcf, bagLayout);
        bagLayout.insets = new Insets(0, 0, 0, 1);
        ++bagLayout.gridx;
        this.labelVlrDataNcf.setMinimumSize(new Dimension(100, 20));
        this.labelVlrDataNcf.setPreferredSize(new Dimension(100, 20));
        this.panelNcf.add((Component)this.labelVlrDataNcf, bagLayout);
        bagLayout.gridx += 2;
        bagLayout.insets = new Insets(0, 20, 0, 1);
        this.panelNcf.add((Component)this.labelConvenio, bagLayout);
        bagLayout.insets = new Insets(0, 0, 0, 0);
        bagLayout.gridx += 2;
        bagLayout.fill = 2;
        bagLayout.weightx = 1.0;
        bagLayout.gridwidth = 4;
        bagLayout.insets = new Insets(0, 1, 0, 1);
        this.labelVlrDescConvenio.setPreferredSize(new Dimension(20, 20));
        this.labelVlrDescConvenio.setMinimumSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.labelVlrDescConvenio, bagLayout);
    }

    private void criaLinhaFornecedor(GridBagConstraints bagLayout) {
        bagLayout.insets = new Insets(0, 0, 0, 1);
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.fill = 0;
        bagLayout.gridwidth = 1;
        this.panelNcf.add((Component)this.labelFornecedor, bagLayout);
        ++bagLayout.gridx;
        this.textCodFornecedor.setMinimumSize(new Dimension(99, 20));
        this.textCodFornecedor.setPreferredSize(new Dimension(99, 20));
        this.panelNcf.add((Component)this.textCodFornecedor, bagLayout);
        ++bagLayout.gridx;
        this.buttonFornecedor.setMinimumSize(new Dimension(20, 20));
        this.buttonFornecedor.setPreferredSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.buttonFornecedor, bagLayout);
        ++bagLayout.gridx;
        bagLayout.weightx = 1.0;
        bagLayout.fill = 2;
        bagLayout.weighty = 0.0;
        bagLayout.gridwidth = 9;
        this.labelVlrDescFornecedor.setPreferredSize(new Dimension(20, 20));
        this.labelVlrDescFornecedor.setMinimumSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.labelVlrDescFornecedor, bagLayout);
    }

    private void criaLinhaMaterial(GridBagConstraints bagLayout) {
        bagLayout.insets = new Insets(0, 0, 0, 1);
        ++bagLayout.gridy;
        bagLayout.gridx = 0;
        bagLayout.weightx = 0.0;
        bagLayout.weighty = 0.0;
        bagLayout.fill = 0;
        bagLayout.gridwidth = 1;
        this.panelNcf.add((Component)this.labelMaterial, bagLayout);
        ++bagLayout.gridx;
        this.textCodMaterial.setMinimumSize(new Dimension(99, 20));
        this.textCodMaterial.setPreferredSize(new Dimension(99, 20));
        this.panelNcf.add((Component)this.textCodMaterial, bagLayout);
        ++bagLayout.gridx;
        this.buttonMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonMaterial.setPreferredSize(new Dimension(20, 20));
        this.panelNcf.add((Component)this.buttonMaterial, bagLayout);
        ++bagLayout.gridx;
        bagLayout.fill = 2;
        bagLayout.weightx = 350.0;
        bagLayout.gridwidth = 7;
        this.labelVlrDescMaterial.setPreferredSize(new Dimension(20, 20));
        this.labelVlrDescMaterial.setMinimumSize(new Dimension(50, 20));
        this.panelNcf.add((Component)this.labelVlrDescMaterial, bagLayout);
        bagLayout.gridx += 7;
        bagLayout.weightx = 0.0;
        bagLayout.fill = 2;
        bagLayout.gridwidth = 1;
        bagLayout.insets = new Insets(0, 20, 0, 1);
        this.panelNcf.add((Component)this.labelNotaFiscal, bagLayout);
        bagLayout.insets = new Insets(0, 0, 0, 0);
        ++bagLayout.gridx;
        bagLayout.gridwidth = 1;
        bagLayout.fill = 17;
        this.textCodNotaFiscal.setPreferredSize(new Dimension(100, 20));
        this.textCodNotaFiscal.setMinimumSize(new Dimension(100, 20));
        this.panelNcf.add((Component)this.textCodNotaFiscal, bagLayout);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1300200100");
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.setFoco(this.textData);
        this.textData.setText(Funcoes.formataData(Calendar.getInstance().getTime()));
        this.labelVlrUsuario.setText(Variaveis.login);
    }

    @Override
    public void excluir() {
        this.naoConformidadeBean = (NaoConformidadeBean)this.pesquisar();
        if (this.naoConformidadeBean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbrirNaoConformidade.this.preencherCampos(AbrirNaoConformidade.this.naoConformidadeBean);
                    if (Funcoes.mensagem(AbrirNaoConformidade.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            AbrirNaoConformidade.this.naoConformidadeService.gravaAutoCopiaSemCommit(AbrirNaoConformidade.this.naoConformidadeBean, 2, Variaveis.filialPadrao, AbrirNaoConformidade.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir.\n" + e.getMessage(), 2);
                        }
                    }
                    AbrirNaoConformidade.this.limparCampos();
                    AbrirNaoConformidade.this.naoConformidadeBean = null;
                }
            });
        }
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            try {
                this.naoConformidadeBean = (NaoConformidadeBean)this.getBeanPreenchido();
                if (!this.naoConformidadeBean.getLoteVos().isEmpty() && this.naoConformidadeBean.getMaterial() == null) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Material n\u00e3o pode ser removido pois existem lotes adicionados.", 2);
                    return;
                }
                for (MaterialLoteVO materialLoteVO : this.naoConformidadeBean.getLoteVos()) {
                    if (this.naoConformidadeBean.getMaterial() == null || materialLoteVO.getMaterial().getCodigo().equals(this.naoConformidadeBean.getMaterial().getCodigo())) continue;
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Existem lotes que n\u00e3o pertencem ao material adicionado.", 2);
                    return;
                }
                if (this.naoConformidadeBean != null) {
                    if (this.getStatus() == 2) {
                        this.naoConformidadeBean.setSituacao("A");
                        this.naoConformidadeService.gravaAutoCopiaSemCommit(this.naoConformidadeBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    } else if (this.getStatus() == 3) {
                        this.naoConformidadeService.gravaAutoCopiaSemCommit(this.naoConformidadeBean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                    }
                    Conexao.arquivaSQL();
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a n\u00e3o conformidade.", 2);
            }
        }
    }

    @Override
    public void editar() {
        super.editar();
        this.setFoco(this.textData);
    }

    public void visualizar() {
        final JDialog visDialog = new JDialog();
        visDialog.add(this);
        visDialog.setResizable(false);
        visDialog.setPreferredSize(new Dimension(770, 580));
        visDialog.setMinimumSize(new Dimension(770, 580));
        visDialog.setTitle("Visualizando detalhes da n\u00e3o conformidade");
        visDialog.setModal(true);
        this.painelCrud.removeAll();
        this.painelOpcoes.removeAll();
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                visDialog.dispose();
            }
        });
        this.painelCrud.add(this.botaoFechar);
        ScreenUtil.centralizar(visDialog);
        visDialog.setVisible(true);
        visDialog.pack();
    }

    private void limparCampos(boolean b) {
        this.textAreaDescricao.setText("");
        this.labelVlrCodConvenio.setText("");
        this.textCodFornecedor.setText("");
        this.textCodLote.setText("");
        this.textCodMaterial.setText("");
        this.textCodNotaFiscal.setText("");
        this.textCodProcedencia.setText("");
        this.textCodRequisicao.setText("");
        this.textCodSetor.setText("");
        this.textCodOrigem.setText("");
        this.textCodTipo.setText("");
        this.labelResponsavelSetor.setText("");
        this.textData.setText("");
        this.labelVlrDataNcf.setText("");
        this.textDescAdicional.setText("");
        this.labelDescTelefone.setText("");
        this.labelVlrCodigo.setText("");
        this.labelVlrDescConvenio.setText("");
        this.labelVlrDescFornecedor.setText("");
        this.labelVlrDescLote.setText("");
        this.labelVlrDescMaterial.setText("");
        this.labelVlrDescProcedencia.setText("");
        this.labelVlrDescRequisicao.setText("");
        this.labelVlrDescSetor.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrOrigem.setText("");
        this.labelVlrTipo.setText("");
        this.modeloLote.clear();
        this.modeloSetores.clear();
        this.modeloRequisicao.clear();
        this.checkboxUrgente.setSelected(false);
        this.labelVlrNotificado.setText("");
        this.naoConformidadeBean = null;
    }

    @Override
    protected void controlaCampos() {
        this.textData.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodProcedencia.setEnabled(this.habilitaDesabilitaCampo());
        this.textDescAdicional.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodRequisicao.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodFornecedor.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodMaterial.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodNotaFiscal.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodLote.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodOrigem.setEnabled(this.habilitaDesabilitaCampo());
        this.labelResponsavelSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.textAreaDescricao.setEnabled(this.habilitaDesabilitaCampo());
        this.textCodTipo.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddLote.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonConvenio.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonData.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonDataNcf.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonFornecedor.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonLote.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonMaterial.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonProcedencia.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonRequisicao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonSetor.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAddRequisicao.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonOrigem.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonTipo.setEnabled(this.habilitaDesabilitaCampo());
        this.scrollPaneLote.setEnabled(this.habilitaDesabilitaCampo());
        this.checkboxUrgente.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonBuscarNotificado.setEnabled(this.habilitaDesabilitaCampo());
        this.linhaAdicionalVisivel(false);
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void limparCampos() {
        this.zerarObjetos();
        this.limparCampos(true);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            NaoConformidadeVO vo = (NaoConformidadeVO)this.naoConformidadeService.pesquisaVONcf(this.getTopLevelAncestor(), new NaoConformidadeVO(), "Pesquisando n\u00e3o conformidades", false, "A");
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("nac_codigo", vo.getCodigo());
                chaves.put("nac_situacao", "A");
                this.naoConformidadeBean = (NaoConformidadeBean)this.naoConformidadeService.getBean(chaves);
                this.zerarObjetos();
                this.buttonImprimir.setVisible(Acesso.getAcesso(ImprimirNaoConformidade.getModuloAcesso()) && this.naoConformidadeBean.getCodigo() > 0);
                return this.naoConformidadeBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    private void zerarObjetos() {
        this.procedenciaVo = null;
        this.requisicaoVO = null;
        this.convenioVO = null;
        this.entidadeVO = null;
        this.materialVO = null;
        this.materialLoteVo = null;
        this.setorVO = null;
        this.notaFiscalVO = null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        if (this.naoConformidadeBean == null) {
            this.naoConformidadeBean = new NaoConformidadeBean();
        }
        FilialVO filialVO = new FilialVO();
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setCodigo(this.labelVlrUsuario.getText());
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        this.naoConformidadeBean.setUrgente(this.checkboxUrgente.isSelected());
        this.naoConformidadeBean.setFilial(filialVO);
        this.naoConformidadeBean.setProcedenciaNaoConformidade(this.procedenciaVo);
        this.naoConformidadeBean.setNcfDataHora(new Date());
        this.naoConformidadeBean.setUsuario(usuarioVO);
        this.naoConformidadeBean.setNcfData(Funcoes.getData("dd/MM/yyyy", this.textData.getText()));
        this.naoConformidadeBean.setMaterial(this.materialVO);
        this.naoConformidadeBean.setMaterialLote(this.materialLoteVo);
        this.naoConformidadeBean.setDescricao(this.textAreaDescricao.getText());
        this.naoConformidadeBean.setNotaFiscal(this.notaFiscalVO);
        this.naoConformidadeBean.setFornecedor(this.entidadeVO);
        this.naoConformidadeBean.setAdicional(this.textDescAdicional.getText());
        this.naoConformidadeBean.setSetorNaoConformidadeVOs(this.setorNcfVos());
        this.naoConformidadeBean.setLoteVos(this.materialLoteVos());
        this.naoConformidadeBean.setRequisicaoVos(this.requisicoes());
        this.naoConformidadeBean.setOrigemNaoConformidade(this.origemNaoConformidadeVO);
        this.naoConformidadeBean.setTipoNaoConformidade(this.tipoNaoConformidadeVO);
        return this.naoConformidadeBean;
    }

    private Integer getCodigoFornecedor() {
        if (!Funcoes.textoVazio(this.textCodFornecedor)) {
            return Integer.parseInt(this.textCodFornecedor.getText());
        }
        return null;
    }

    private Integer getCodNota() {
        if (!Funcoes.textoVazio(this.textCodNotaFiscal)) {
            return Integer.parseInt(this.textCodNotaFiscal.getText());
        }
        return null;
    }

    private List<RequisicaoVO> requisicoes() {
        ArrayList<RequisicaoVO> requisicaoVOs = new ArrayList<RequisicaoVO>();
        for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
            this.requisicaoVO = (RequisicaoVO)this.modeloRequisicao.getValueAt(i, COLUNA_REQUISICAO);
            requisicaoVOs.add(this.requisicaoVO);
        }
        return requisicaoVOs;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (this.beanValido(bean)) {
            NaoConformidadeBean naoConformidadeBean = (NaoConformidadeBean)bean;
            this.procedenciaVo = naoConformidadeBean.getProcedenciaNaoConformidade();
            this.materialVO = naoConformidadeBean.getMaterial();
            this.notaFiscalVO = naoConformidadeBean.getNotaFiscal();
            this.entidadeVO = naoConformidadeBean.getFornecedor();
            this.origemNaoConformidadeVO = naoConformidadeBean.getOrigemNaoConformidade();
            this.tipoNaoConformidadeVO = naoConformidadeBean.getTipoNaoConformidade();
            if (!naoConformidadeBean.getRequisicaoVos().isEmpty()) {
                this.requisicaoVO = naoConformidadeBean.getRequisicaoVos().get(0);
            }
            this.labelVlrCodigo.setText(naoConformidadeBean.getCodigo().toString());
            this.textData.setText(Funcoes.formataData(naoConformidadeBean.getNcfData()));
            this.labelVlrUsuario.setText(this.getCodUser(naoConformidadeBean));
            this.textCodProcedencia.setText(this.getCodProcedencia(naoConformidadeBean));
            this.labelVlrDescProcedencia.setText(this.getDescricaoProcedencia(naoConformidadeBean));
            this.textDescAdicional.setText(naoConformidadeBean.getAdicional());
            this.checkboxUrgente.setSelected(naoConformidadeBean.getUrgente());
            if (naoConformidadeBean.getProcedenciaNaoConformidade() != null) {
                this.linhaAdicionalVisivel(naoConformidadeBean.getProcedenciaNaoConformidade().getSolicitarDescricao());
            } else {
                this.linhaAdicionalVisivel(false);
            }
            for (RequisicaoVO reqVo : naoConformidadeBean.getRequisicaoVos()) {
                if (reqVo == null) continue;
                this.addLinhaTabelaRequisicao(reqVo);
            }
            this.textCodFornecedor.setText(this.getCodFornecedor(naoConformidadeBean));
            this.labelVlrDescFornecedor.setText(this.getFantasia(naoConformidadeBean));
            this.textCodMaterial.setText(this.getCodMaterial(naoConformidadeBean));
            this.labelVlrDescMaterial.setText(this.getDescMaterial(naoConformidadeBean));
            this.textCodNotaFiscal.setText(this.getCodNotaFiscal(naoConformidadeBean));
            this.textCodOrigem.setText(this.getCodOrigem(naoConformidadeBean));
            this.labelVlrOrigem.setText(this.getDescOrigem(naoConformidadeBean));
            this.textCodTipo.setText(this.getCodTipo(naoConformidadeBean));
            this.labelVlrTipo.setText(this.getDescTipo(naoConformidadeBean));
            for (MaterialLoteVO mlVo : naoConformidadeBean.getLoteVos()) {
                if (mlVo == null) continue;
                this.addLinhaTabelaLote(mlVo);
            }
            for (SetorNaoConformidadeVO setorVO : naoConformidadeBean.getSetorNaoConformidadeVOsTemp()) {
                if (setorVO == null) continue;
                this.addLinhaTabelaSetor(setorVO);
            }
            this.textAreaDescricao.setText(naoConformidadeBean.getDescricao());
        }
    }

    private String getCodNotaFiscal(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getNotaFiscal() != null) {
            return naoConformidadeBean.getNotaFiscal().getCodigo().toString();
        }
        if (naoConformidadeBean.getNotaFiscal() != null) {
            return String.valueOf(naoConformidadeBean.getNotaFiscal().getCodigo());
        }
        return "";
    }

    private String getCodOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getDescOrigem(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getOrigemNaoConformidade() != null) {
            return naoConformidadeBean.getOrigemNaoConformidade().getDescricao();
        }
        return "";
    }

    private String getCodTipo(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getTipoNaoConformidade() != null) {
            return naoConformidadeBean.getTipoNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getDescTipo(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getTipoNaoConformidade() != null) {
            return naoConformidadeBean.getTipoNaoConformidade().getDescricao();
        }
        return "";
    }

    private String getDescMaterial(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean != null && naoConformidadeBean.getMaterial() != null) {
            return naoConformidadeBean.getMaterial().getDescricao();
        }
        return "";
    }

    private String getCodMaterial(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getMaterial() != null) {
            return naoConformidadeBean.getMaterial().getCodigo().toString();
        }
        return "";
    }

    private String getFantasia(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getFornecedor() != null) {
            return naoConformidadeBean.getFornecedor().getFantasia();
        }
        return "";
    }

    private String getCodFornecedor(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getFornecedor() != null) {
            return naoConformidadeBean.getFornecedor().getCodigo().toString();
        }
        return "";
    }

    private String getDescricaoProcedencia(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getProcedenciaNaoConformidade() != null) {
            return naoConformidadeBean.getProcedenciaNaoConformidade().getDescricao();
        }
        return "";
    }

    private String getCodProcedencia(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getProcedenciaNaoConformidade() != null) {
            return naoConformidadeBean.getProcedenciaNaoConformidade().getCodigo().toString();
        }
        return "";
    }

    private String getCodUser(NaoConformidadeBean naoConformidadeBean) {
        if (naoConformidadeBean.getUsuario() != null) {
            return naoConformidadeBean.getUsuario().getCodigo();
        }
        return "";
    }

    private boolean beanValido(AbstractThreadBean bean) {
        return bean != null && bean instanceof NaoConformidadeBean;
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.verificaData(this.textData.getText())) {
            Funcoes.mensagem(this, "O campo data deve ser informado.", 2);
            this.setFoco(this.textData);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodProcedencia)) {
            if (!Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
                Funcoes.mensagem(this, "O campo proced\u00eancia deve ser informado.", 2);
                this.setFoco(this.textCodProcedencia);
                return false;
            }
        }
        if (Funcoes.textoVazio(this.textDescAdicional) && this.procedenciaVo != null && this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
            Funcoes.mensagem(this, "o campo adicional deve ser informado.", 2);
            this.setFoco(this.textDescAdicional);
            return false;
        }
        if (Funcoes.textoVazio(this.textAreaDescricao.getText())) {
            Funcoes.mensagem(this, "O campo descri\u00e7\u00e3o deve ser informado.", 2);
            this.setFoco(this.textAreaDescricao);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.textData, this.buttonData, this.painelCentral, true);
        } else if (e.getSource() == this.buttonProcedencia) {
            this.pesquisaProcedencia();
        } else if (e.getSource() == this.buttonRequisicao) {
            this.pesquisaRequisicao();
        } else if (e.getSource() == this.buttonFornecedor) {
            this.pesquisaFornecedor();
        } else if (e.getSource() == this.buttonMaterial) {
            this.pesquisaMaterial();
        } else if (e.getSource() == this.buttonLote) {
            this.pesquisaLote();
        } else if (e.getSource() == this.buttonSetor) {
            this.pesquisaSetor();
        } else if (e.getSource() == this.buttonOrigem) {
            this.pesquisaOrigem();
        } else if (e.getSource() == this.buttonTipo) {
            this.pesquisaTipo();
        } else if (e.getSource() == this.buttonBuscarNotificado) {
            this.buttonBuscarNotificado.transferFocus();
            if (this.setorVO == null || Funcoes.textoVazio(this.textCodSetor)) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Informe o setor.", 2);
                ScreenUtil.requisitarFoco(this.textCodSetor);
                return;
            }
            this.jDialogNotificados.limparModeloNotificados();
            if (this.editandoSetor) {
                int linhaSelecionada = this.tableSetor.getSelectedRow();
                if (linhaSelecionada > 0) {
                    this.setorVO = (SetorVO)this.modeloSetores.getValueAt(linhaSelecionada, COLUNA_SETOR);
                }
                if (this.setorVO != null && !this.setorVO.getCodigo().toString().trim().equals(this.textCodSetor.getText().trim())) {
                    this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp();
                } else {
                    this.jDialogNotificados.addListaSetoresUsuario((List)this.modeloSetores.getValueAt(linhaSelecionada, COLUNA_SETOR + 1));
                }
            } else {
                this.jDialogNotificados.addListaSetoresUsuario(this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp());
            }
            this.jDialogNotificados.setVisible(true);
        }
    }

    private void pesquisaOrigem() {
        OrigemNaoConformidadeVO setVo = (OrigemNaoConformidadeVO)this.origemNaoConformidadeService.pesquisaVO(Laboratorio.getInstancia(), new OrigemNaoConformidadeVO(), "Pesquisando origem", true);
        if (setVo != null) {
            this.origemNaoConformidadeVO = setVo;
            this.textCodOrigem.setText(setVo.getCodigo().toString());
            this.labelVlrOrigem.setText(setVo.getDescricao());
        } else {
            this.labelVlrOrigem.setText("N\u00e3o cadastrado");
            this.textCodOrigem.selectAll();
        }
    }

    private void pesquisaTipo() {
        TipoNaoConformidadeVO setVo = (TipoNaoConformidadeVO)this.tipoNaoConformidadeService.pesquisaVO(Laboratorio.getInstancia(), new TipoNaoConformidadeVO(), "Pesquisando tipo", true);
        if (setVo != null) {
            this.tipoNaoConformidadeVO = setVo;
            this.textCodTipo.setText(setVo.getCodigo().toString());
            this.labelVlrTipo.setText(setVo.getDescricao());
        } else {
            this.labelVlrTipo.setText("N\u00e3o cadastrado");
            this.textCodTipo.selectAll();
        }
    }

    private void pesquisaMaterial() {
        MaterialVO matVO = (MaterialVO)this.materialService.pesquisaAtivosVO(Laboratorio.getInstancia(), new MaterialVO(), "Pesquisando Materiais", true);
        if (matVO != null) {
            this.materialVO = matVO;
            this.textCodMaterial.setText(matVO.getCodigo().toString());
            this.labelVlrDescMaterial.setText(matVO.getDescricao());
        } else {
            this.materialVO = null;
            this.labelVlrDescMaterial.setText("N\u00e3o cadastrado");
            this.textCodMaterial.selectAll();
        }
        this.setFoco(this.textCodMaterial);
    }

    private void pesquisaFornecedor() {
        EntidadeVO entVO = (EntidadeVO)this.entidadeService.pesquisaVO(Laboratorio.getInstancia(), new EntidadeVO(), "Pesquisando Fornecedores", true);
        if (entVO != null) {
            this.entidadeVO = entVO;
            this.textCodFornecedor.setText(entVO.getCodigo().toString());
            this.labelVlrDescFornecedor.setText(entVO.getFantasia());
        } else {
            this.entidadeVO = null;
            this.labelVlrDescFornecedor.setText("N\u00e3o cadastrado");
            this.textCodFornecedor.selectAll();
        }
        this.setFoco(this.textCodFornecedor);
    }

    private void pesquisaRequisicao() {
        RequisicaoVO reqVO = (RequisicaoVO)this.requisicaoService.pesquisaVO(Laboratorio.getInstancia(), new RequisicaoVO(), "Pesquisando Requisi\u00e7\u00f5es", true);
        if (reqVO != null) {
            this.requisicaoVO = reqVO;
            this.mostrarDadoRequisicao(reqVO);
        } else {
            this.requisicaoVO = null;
            this.labelVlrDescRequisicao.setText("N\u00e3o cadastrado");
            this.textCodRequisicao.selectAll();
        }
        this.setFoco(this.textCodRequisicao);
    }

    private void mostrarDadoRequisicao(RequisicaoVO reqVO) {
        this.textCodRequisicao.setText(reqVO.getCodigo().toString());
        this.labelVlrDescRequisicao.setText(reqVO.getPaciente().getNome());
        this.labelVlrDataNcf.setText(Funcoes.formataData("dd/MM/yyyy", reqVO.getData()));
        this.labelVlrCodConvenio.setText(reqVO.getConvenio().getCodigo().toString());
        this.labelVlrDescConvenio.setText(reqVO.getConvenio().getFantasia());
    }

    private void pesquisaProcedencia() {
        ProcedenciaNaoConformidadeVO vo = (ProcedenciaNaoConformidadeVO)this.service.pesquisaVO(Laboratorio.getInstancia(), new ProcedenciaNaoConformidadeVO(), "Pesquisando proced\u00eancias de n\u00e3o conformidade", true);
        if (vo != null) {
            this.procedenciaVo = vo;
            this.textCodProcedencia.setText(vo.getCodigo().toString());
            this.labelVlrDescProcedencia.setText(vo.getDescricao());
            if (this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
                this.linhaAdicionalVisivel(true);
            } else {
                this.linhaAdicionalVisivel(false);
            }
        } else {
            this.procedenciaVo = null;
            this.labelVlrDescProcedencia.setText("N\u00e3o cadastrado");
            this.textCodProcedencia.selectAll();
        }
        if (this.procedenciaVo != null && !this.procedenciaVo.getSolicitarDescricao().booleanValue()) {
            this.setFoco(this.textCodProcedencia);
        }
    }

    private void linhaAdicionalVisivel(boolean visivel) {
        if (visivel) {
            if (Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
                this.labelAdicional.setVisible(false);
                this.textDescAdicional.setVisible(false);
                return;
            }
        }
        this.labelAdicional.setVisible(visivel);
        this.textDescAdicional.setVisible(visivel);
        this.setFoco(this.textDescAdicional);
    }

    private void pesquisaSetor() {
        SetorVO setVo = (SetorVO)this.setorService.pesquisaVO(Laboratorio.getInstancia(), new SetorVO(), "Pesquisando setores", true);
        if (setVo != null) {
            this.setorVO = setVo;
            this.textCodSetor.setText(setVo.getCodigo().toString());
            this.labelVlrDescSetor.setText(setVo.getDescricao());
            this.labelResponsavelSetor.setText(setVo.getUsuario().getCodigo());
        } else {
            this.labelVlrDescSetor.setText("N\u00e3o cadastrado");
            this.labelResponsavelSetor.setText("");
            this.textCodSetor.selectAll();
        }
        this.setFoco(this.buttonAddSetor);
        this.labelVlrNotificado.setText("");
        this.editandoSetor = false;
        this.jDialogNotificados.getSetorNaoConformidadeUsuarioBeansTemp().clear();
    }

    private void pesquisaLote() {
        if (!this.materialInformado()) {
            return;
        }
        MaterialLoteVO loteVo = (MaterialLoteVO)this.materialLoteService.pesquisaVO(Laboratorio.getInstancia(), new MaterialLoteVO(), "Pesquisando lotes", this.textCodMaterial.getText(), true);
        if (loteVo != null) {
            this.materialLoteVo = loteVo;
            this.textCodLote.setText(loteVo.getCodigo().toString());
            this.labelVlrDescLote.setText(loteVo.getLote());
        } else {
            this.labelVlrDescLote.setText("N\u00e3o cadastrado");
            this.textCodLote.selectAll();
        }
        this.setFoco(this.textCodLote);
    }

    private boolean materialInformado() {
        if (Funcoes.textoVazio(this.textCodMaterial.getText()) || this.labelVlrDescMaterial.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe o material.", 2);
            this.setFoco(this.textCodMaterial);
            return false;
        }
        return true;
    }

    private boolean setorlInformado() {
        if (Funcoes.textoVazio(this.textCodSetor.getText()) || this.labelVlrDescSetor.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe o setor.", 2);
            this.setFoco(this.textCodSetor);
            return false;
        }
        return true;
    }

    private boolean requisicaoInformada() {
        if (Funcoes.textoVazio(this.textCodRequisicao.getText()) || this.labelVlrDescRequisicao.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe a requisi\u00e7\u00e3o.", 2);
            this.setFoco(this.textCodRequisicao);
            return false;
        }
        return true;
    }

    private boolean loteInformado() {
        if (this.validaLote()) {
            Funcoes.mensagem(this, "Informe o lote.", 2);
            this.setFoco(this.textCodLote);
            return false;
        }
        return true;
    }

    private boolean setorInformado() {
        if (this.validaSetor()) {
            Funcoes.mensagem(this, "Informe o setor.", 2);
            this.setFoco(this.textCodSetor);
            return false;
        }
        return true;
    }

    private boolean validarRequisicao() {
        if (this.validaRequisicao()) {
            Funcoes.mensagem(this, "Informe a requisi\u00e7\u00e3o.", 2);
            this.setFoco(this.textCodRequisicao);
            return false;
        }
        return true;
    }

    private boolean validaLote() {
        return Funcoes.textoVazio(this.textCodLote.getText()) || this.labelVlrDescLote.getText().equalsIgnoreCase("N\u00e3o cadastrado");
    }

    private boolean validaSetor() {
        return Funcoes.textoVazio(this.textCodSetor.getText()) || this.labelVlrDescSetor.getText().equalsIgnoreCase("N\u00e3o cadastrado");
    }

    private boolean validaRequisicao() {
        return Funcoes.textoVazio(this.textCodRequisicao.getText()) || this.labelVlrDescRequisicao.getText().equalsIgnoreCase("N\u00e3o cadastrado");
    }

    private void setFoco(Component comp) {
        ScreenUtil.requisitarFoco(comp);
    }

    public static long getModuloAcessoOcultarProcedencia() {
        return Long.valueOf(OCULTA_PROCEDENCIA);
    }

    public static long getModuloAcessoOcultarOrigem() {
        return Long.valueOf(OCULTA_ORIGEM);
    }

    public static long acessoOcultarDetalhe() {
        return Long.valueOf(OCULTA_DETALHE);
    }

    private void ocultaProcedencia() {
        if (Acesso.getAcesso(this.getModuloAcessoOcultarProcedencia())) {
            this.labelProcedencia.setVisible(false);
            this.labelVlrDescProcedencia.setVisible(false);
            this.textCodProcedencia.setVisible(false);
            this.buttonProcedencia.setVisible(false);
            this.labelAdicional.setVisible(false);
            this.textDescAdicional.setVisible(false);
        } else {
            this.labelProcedencia.setVisible(true);
            this.labelVlrDescProcedencia.setVisible(true);
            this.textCodProcedencia.setVisible(true);
            this.buttonProcedencia.setVisible(true);
            this.labelAdicional.setVisible(true);
            this.textDescAdicional.setVisible(true);
        }
    }
}

