/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.util;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.util.EnvioRackListener;
import jalis.laboratorio.interfaceamento.util.SolicitarRack;
import jalis.laboratorio.interfaceamento.util.ThreadEnvio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RequisicaoRack
extends JDialog
implements ActionListener,
EnvioRackListener {
    private AbstractInterfaceamento equip;
    private JPanel panelRoot = new JPanel(new GridBagLayout());
    private ArrayList exames;
    private int indexRequisicao;
    private int indexNomePaciente;
    private int indexExame;
    private int indexRack;
    private int indexTubo;
    private boolean reenvio;
    private PanelAbaAbstrata aba;
    private TTextField textFilial = ComponenteFactory.novoTTextField(ParametrosGerais.getDigitosTuboFilial(), 1);
    private TTextField textRequisicao = ComponenteFactory.novoTTextField(ParametrosGerais.getDigitosTuboRequisicao(), 1);
    private TTextField textNomePaciente = ComponenteFactory.novoTTextField(50, 3);
    private TTextField textRack = ComponenteFactory.novoTTextField(6, 3);
    private JComboBox comboExames = ComponenteFactory.novoJComboBox(this);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("Ok", 'o', this);
    private ModeloGridTable tableModel = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Exame", "Rack", "Tubo"});
    private JTable tableRequisicao = new JTable(this.tableModel);
    private JScrollPane scrollTable = new JScrollPane(this.tableRequisicao);
    private JPanel panelButton = new JPanel(new FlowLayout(2));
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private ArrayList requisicoes = new ArrayList();

    public RequisicaoRack(JFrame parent, AbstractInterfaceamento equip, ArrayList exames, int indexRequisicao, int indexNomePaciente, int indexExame, int indexRack, int indexTubo, boolean reenvio, PanelAbaAbstrata aba) {
        super(parent);
        this.equip = equip;
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexRack = indexRack;
        this.indexTubo = indexTubo;
        this.reenvio = reenvio;
        this.aba = aba;
        this.setDefaultCloseOperation(0);
        this.configTela();
    }

    private void configTela() {
        this.setPreferredSize(new Dimension(550, 350));
        this.setTitle("Rack");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.tableModel.setColumnSize(new int[]{100, 0, 80, 50, 1}, this.tableRequisicao);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Filial"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Requisi\u00e7\u00e3o"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Paciente"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Exame(s)"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Rack"), c);
        this.textFilial.setPreferredSize(new Dimension(50, 20));
        this.textFilial.setMinimumSize(new Dimension(50, 20));
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        this.panelRoot.add((Component)this.textFilial, c);
        this.textRequisicao.setPreferredSize(new Dimension(100, 20));
        this.textRequisicao.setMinimumSize(new Dimension(100, 20));
        ++c.gridx;
        c.gridy = 1;
        c.fill = 0;
        this.panelRoot.add((Component)this.textRequisicao, c);
        this.textNomePaciente.setPreferredSize(new Dimension(90, 20));
        this.textNomePaciente.setMinimumSize(new Dimension(90, 20));
        this.textNomePaciente.setEditable(false);
        this.textNomePaciente.setFocusable(false);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelRoot.add((Component)this.textNomePaciente, c);
        this.comboExames.setPreferredSize(new Dimension(100, 20));
        this.comboExames.setMinimumSize(new Dimension(100, 20));
        ++c.gridx;
        c.gridy = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelRoot.add((Component)this.comboExames, c);
        this.textRack.setPreferredSize(new Dimension(65, 20));
        this.textRack.setMinimumSize(new Dimension(65, 20));
        ++c.gridx;
        c.gridy = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelRoot.add((Component)this.textRack, c);
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelRoot.add((Component)this.buttonAddRequisicao, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridwidth = 6;
        this.panelRoot.add((Component)this.scrollTable, c);
        this.panelButton.add(this.buttonEnviar);
        this.panelButton.add(this.buttonCancelar);
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.textRequisicao.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                RequisicaoRack.this.loadExamesRequisicao();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (RequisicaoRack.this.tableRequisicao.getSelectedRowCount() > 0 && e.getKeyCode() == 127) {
                    RequisicaoRack.this.requisicoes.remove(RequisicaoRack.this.tableRequisicao.getSelectedRow());
                    RequisicaoRack.this.populateTable();
                }
            }
        });
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void alteraRack(int linha) {
        String rack = (String)this.tableRequisicao.getValueAt(linha, 3);
        SolicitarRack tela = new SolicitarRack();
        tela.setRack(rack);
        tela.setVisible(true);
        rack = tela.getRack();
        if (!Funcoes.textoVazio(rack)) {
            this.tableRequisicao.setValueAt(rack, linha, 3);
        }
    }

    private boolean validaRequisicao(boolean adicionaLista) {
        int i;
        String requisicao = this.textRequisicao.getText();
        String filial = this.textFilial.getText();
        boolean achou = false;
        if (Funcoes.textoVazio(filial)) {
            Funcoes.mensagem(this, "Filial n\u00e3o preenchida!", 5);
            return false;
        }
        if (Funcoes.textoVazio(requisicao)) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o preenchida!", 5);
            return false;
        }
        if (this.requisicoes.size() > 0) {
            for (i = 0; i < this.requisicoes.size(); ++i) {
                Object[] req = (Object[])this.requisicoes.get(i);
                String rack = req[3].toString();
                String exame = req[2].toString();
                if (this.textRack.getText().equalsIgnoreCase(rack)) {
                    Funcoes.mensagem(this, "Rack j\u00e1 adicionada!", 5);
                    return false;
                }
                String rq = StringUtil.preencheString(this.textFilial.getText(), ParametrosGerais.getDigitosTuboFilial(), '0', 1);
                rq = rq + StringUtil.preencheString(this.textRequisicao.getText(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                String examesCombo = this.comboExames.getSelectedItem().toString();
                if (!req[this.indexRequisicao].toString().equalsIgnoreCase(rq) || examesCombo.indexOf(exame) < 0) continue;
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o j\u00e1 adicionada!", 5);
                return false;
            }
        }
        filial = StringUtil.preencheString(filial, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
        requisicao = filial + StringUtil.preencheString(requisicao, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
        for (i = 0; i < this.exames.size(); ++i) {
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            if (!req.equalsIgnoreCase(requisicao) || !this.comboExames.getSelectedItem().equals(linha[this.indexExame])) continue;
            if (adicionaLista) {
                String[] exas;
                String exaReq = linha[this.indexExame].toString();
                for (String s : exas = exaReq.split(" ")) {
                    Object[] line = new Object[]{req, linha[this.indexNomePaciente].toString(), s, this.textRack.getText(), linha[this.indexTubo].toString()};
                    this.requisicoes.add(line);
                }
            }
            achou = true;
        }
        if (!achou) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o encontrada!", 5);
        }
        return achou;
    }

    private void loadExamesRequisicao() {
        String filial = this.textFilial.getText();
        String requisicao = this.textRequisicao.getText();
        filial = StringUtil.preencheString(filial, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
        requisicao = filial + StringUtil.preencheString(requisicao, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
        this.comboExames.removeAllItems();
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            if (!req.equalsIgnoreCase(requisicao)) continue;
            this.comboExames.addItem(linha[this.indexExame]);
            this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
        }
        this.comboExames.setEnabled(this.comboExames.getItemCount() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.requisicoes.clear();
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAddRequisicao) {
            this.addRequisicao();
        } else if (e.getSource() == this.buttonEnviar && (this.reenvio || this.validarLote())) {
            this.enviar();
        }
    }

    private void addRequisicao() {
        if (this.validaRequisicao(false)) {
            this.validaRequisicao(true);
            if (Funcoes.textoVazio(this.textRack.getText())) {
                Funcoes.mensagem(this, "Rack n\u00e3o preenchida!", 5);
                return;
            }
            int rack = Integer.parseInt(this.textRack.getText()) + 1;
            this.populateTable();
            this.textFilial.setText("");
            this.textRequisicao.setText("");
            this.textNomePaciente.setText("");
            this.comboExames.removeAllItems();
            this.textRack.setText(Integer.toString(rack));
            this.textFilial.grabFocus();
        }
    }

    private void populateTable() {
        while (this.tableRequisicao.getRowCount() > 0) {
            this.tableModel.removeLine(0);
        }
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            Object[] o = (Object[])this.requisicoes.get(i);
            this.tableModel.addLine(o);
        }
        this.tableRequisicao.setModel(this.tableModel);
    }

    private void editaRequisicao() {
        int row = this.tableRequisicao.getSelectedRow();
        Object[] req = (Object[])this.requisicoes.get(row);
        this.textRequisicao.setText(req[this.indexRequisicao].toString());
        this.textNomePaciente.setText(req[this.indexNomePaciente].toString());
        this.textRack.setText(req[this.indexRack].toString());
        this.textRack.grabFocus();
    }

    public ArrayList getRequisicoes() {
        return this.requisicoes;
    }

    private boolean validarLote() {
        ((AbaDefaultPendentes)this.equip.examesPendentes).reloadExames();
        ArrayList pendentes = ((AbaDefaultPendentes)this.equip.examesPendentes).getExames();
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            int rack;
            Object[] req = (Object[])this.requisicoes.get(i);
            int requisicao = Integer.parseInt(req[this.indexRequisicao].toString());
            int row = this.validaExisteExame(requisicao);
            if (row < 0 || req[3] == null || !this.validaExisteExamePendente(rack = Integer.parseInt(req[3].toString()), pendentes)) continue;
            Funcoes.mensagem(this, "A rack " + rack + " j\u00e1 esta cadastrada\npara exame que espera retorno!", 5);
            return false;
        }
        return true;
    }

    private int validaExisteExame(int requisicao) {
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] exame = (Object[])this.exames.get(i);
            int requisicaoExame = Integer.parseInt(exame[this.indexRequisicao].toString());
            if (requisicao != requisicaoExame) continue;
            return i;
        }
        return -1;
    }

    private boolean validaExisteExamePendente(int contador, ArrayList pendentes) {
        for (int i = 0; i < pendentes.size(); ++i) {
            int contadorExame;
            Object[] pendente = (Object[])pendentes.get(i);
            if (pendente[this.indexRack] == null || contador != (contadorExame = Integer.parseInt(pendente[this.indexRack].toString()))) continue;
            return true;
        }
        return false;
    }

    private void enviar() {
        ThreadEnvio envio = new ThreadEnvio(this.requisicoes, this.indexRequisicao, this.indexRack, this.indexTubo, this.aba);
        this.buttonEnviar.setEnabled(false);
        this.buttonCancelar.setEnabled(false);
        envio.addEnvioRackListener(this);
        envio.start();
    }

    @Override
    public void envioFinalizado() {
        this.setVisible(false);
    }
}

