/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.util;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;

public class DadosEtiqueta {
    private final String filial;
    private final String recipiente;
    private final String requisicao;
    private final String exame;

    public DadosEtiqueta(String etiqueta) {
        this.exame = "";
        if (this.guiasSaoValidas(this.buscarMuiltiguias(etiqueta))) {
            this.filial = this.exrtairFilial(etiqueta);
            this.recipiente = this.extrairRecipiente(etiqueta);
            this.requisicao = this.extratirRequisicao(etiqueta);
        } else {
            DescritorCodigoEtiqueta descritor = this.createDescritor(etiqueta);
            if (descritor != null) {
                this.filial = descritor.getFilialDoPreenchida();
                this.requisicao = descritor.getRequisicaoPreenchida();
                this.recipiente = descritor.getTuboPreenchido();
            } else {
                this.filial = "";
                this.requisicao = "";
                this.recipiente = "";
            }
        }
    }

    public DadosEtiqueta(String filial, String requisicao) {
        this.filial = filial;
        this.requisicao = requisicao;
        this.recipiente = "";
        this.exame = "";
    }

    public DadosEtiqueta(String filialRequisicao, String exame, String recipiente) {
        this.filial = this.exrtairFilial(filialRequisicao);
        this.requisicao = this.extratirRequisicao(filialRequisicao);
        this.recipiente = recipiente;
        this.exame = exame;
    }

    private DescritorCodigoEtiqueta createDescritor(String tubo) {
        return DescritorCodigoEtiqueta.getDescritor(tubo);
    }

    private String extratirRequisicao(String tubo) {
        int fim = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        if (fim <= tubo.length()) {
            return tubo.substring(ParametrosGerais.getDigitosTuboFilial(), fim);
        }
        return tubo.substring(ParametrosGerais.getDigitosTuboFilial(), tubo.length());
    }

    private String extrairRecipiente(String tubo) {
        return tubo.substring(this.getLenghtDoTubo(tubo) - ParametrosGerais.getDigitosTuboTubo());
    }

    private int getLenghtDoTubo(String tubo) {
        return tubo.length();
    }

    private String exrtairFilial(String etiqueta) {
        return etiqueta.substring(0, ParametrosGerais.getDigitosTuboFilial());
    }

    private boolean guiasSaoValidas(Integer[] guias) {
        return null != guias && guias.length >= 1;
    }

    public String getRequisicao() {
        return this.requisicao;
    }

    public int getLenghtRequisicao() {
        return this.requisicao.length();
    }

    public String getFilial() {
        return this.filial;
    }

    public String getRecipiente() {
        return this.recipiente;
    }

    public String getFilialRequisicao() {
        return this.filial + this.requisicao;
    }

    private Integer[] buscarMuiltiguias(String tubo) {
        Integer[] guias = null;
        if (this.deveAgruparInterface()) {
            try {
                if (this.tamanhoDoTuboEhValido(tubo)) {
                    String filialMult = tubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String requisicaoMult = tubo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    guias = RecepcaoUtil.verificaMultiGuias(filialMult, requisicaoMult);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return guias;
    }

    private boolean tamanhoDoTuboEhValido(String tubo) {
        return tubo.length() == this.getLenghtDoTuboNaConfiguracao();
    }

    private int getLenghtDoTuboNaConfiguracao() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    }

    private boolean deveAgruparInterface() {
        return ParametrosGerais.getAgruparInterface() == 0;
    }

    public String getExame() {
        return this.exame;
    }

    public String getTubo() {
        return this.filial + this.requisicao + this.recipiente;
    }
}

