/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.Rack;
import jalis.model.bean.recepcao.ExameRequisicaoDadosBrutosBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.util.CodString;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloTabela;
import jalis.util.tabela.Registro;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BDUtil {
    public static synchronized boolean existeRequisicao(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" limit 1 ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = rs != null && rs.next();
        ps.close();
        return retorno;
    }

    public static synchronized boolean existeRequisicaoInterface(String fil_codigo, String int_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" limit 1 ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = rs != null && rs.next();
        ps.close();
        return retorno;
    }

    public static synchronized String getExameMatColetaAbreviatura(String fil_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select a.mco_abreviatura from materialcoleta a left join examematcoleta b ");
        query.append("on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and b.mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("mco_abreviatura") : null;
        ps.close();
        return retorno;
    }

    public static synchronized String getExameMatColetaDescricao(String fil_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        return BDUtil.getExameMatColetaDescricaoPerformance(fil_codigo, exa_codigo, mco_codigo);
    }

    public static String getExameMatColetaDescricaoPerformance(String fil_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select a.mco_descricao from materialcoleta a left join examematcoleta b ");
        query.append("on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and b.mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("mco_descricao") : null;
        ps.close();
        return retorno;
    }

    public static synchronized boolean existeExame(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" limit 1 ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet ts = ps.executeQuery();
        boolean retorno = ts != null && ts.next();
        ps.close();
        return retorno;
    }

    public static synchronized boolean existeDesmembramento(String fil_codigo, String int_codigo, String req_codigo, String rec_kodigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        return BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_kodigo, exa_kodigo, mco_kodigo, false);
    }

    public static synchronized boolean existeDesmembramento(String fil_codigo, String int_codigo, String req_codigo, String rec_kodigo, String exa_kodigo, String mco_kodigo, boolean curva) throws SQLException {
        String campoExame = "exa_kodigo = ";
        String campoMaterial = "mco_kodigo = ";
        if (curva) {
            campoExame = "exa_codigo = ";
            campoMaterial = "mco_codigo = ";
        }
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo from interfaceexamerequisicaodesm where ");
        query.append("fil_codigo = ").append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and rec_kodigo = ").append(rec_kodigo);
        query.append(" and ").append(campoExame).append(DBUtil.bdText(exa_kodigo));
        query.append(" and ").append(campoMaterial).append(mco_kodigo);
        query.append(" limit 1 ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet ts = ps.executeQuery();
        boolean retorno = ts != null && ts.next();
        ps.close();
        return retorno;
    }

    public static synchronized String getExmDescricao(String fil_codigo, String exa_codigo) throws SQLException {
        return BDUtil.getExmDescricaoPerformance(fil_codigo, exa_codigo);
    }

    public static String getExmDescricaoPerformance(String fil_codigo, String exa_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_descricao from exames where fil_codigo = ");
        query.append(fil_codigo);
        query.append("and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        String retorno = rs != null && rs.next() ? rs.getString("exa_descricao") : null;
        st.close();
        return retorno;
    }

    public static synchronized String getNomeInterfaceamento(String fil_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select int_descricao from interface where fil_codigo = ");
        query.append(fil_codigo);
        query.append("and int_codigo = ");
        query.append(int_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        String retorno = rs != null && rs.next() ? rs.getString("int_descricao") : "";
        st.close();
        return retorno;
    }

    public static synchronized String getExmAssinatura(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select usr_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("usr_codigo") : "";
        ps.close();
        return retorno;
    }

    public static int getExmSituacao(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        int retorno = -1;
        if (!Funcoes.textoVazio(mco_codigo)) {
            StringBuilder query = new StringBuilder();
            query.append(" select ier_situacao ");
            query.append("   from interfaceexamerequisicao ");
            query.append("  where fil_codigo = ? ");
            query.append("    and int_codigo = ? ");
            query.append("    and req_codigo = ? ");
            query.append("    and exa_codigo = ? ");
            query.append("    and mco_codigo = ? ");
            query.append("    and rec_codigo = ? ");
            PreparedStatement prst = Conexao.getPreparedStatement(query.toString());
            prst.setInt(1, Integer.parseInt(fil_codigo));
            prst.setInt(2, Integer.parseInt(int_codigo));
            prst.setInt(3, Integer.parseInt(req_codigo));
            prst.setString(4, exa_codigo);
            prst.setInt(5, Integer.parseInt(mco_codigo));
            prst.setInt(6, Integer.parseInt(rec_codigo));
            ResultSet rs = Conexao.executeQueryPerformance(prst);
            retorno = rs != null && rs.next() ? rs.getInt("ier_situacao") : -1;
            prst.close();
        }
        return retorno;
    }

    public static synchronized int getExmSituacaoFilho(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_kodigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_kodigo = ");
        query.append(mco_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int retorno = rs != null && rs.next() ? rs.getInt("erd_situacao") : -1;
        ps.close();
        return retorno;
    }

    public static synchronized int getExmSituacaoFilho(String fil_codigo, String int_codigo, Integer[] requisicoes, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder req_codigos = new StringBuilder();
        for (Integer requisicao : requisicoes) {
            req_codigos.append(requisicao).append(",");
        }
        String requisicoes2 = req_codigos.substring(0, req_codigos.length() - 1);
        StringBuilder query = new StringBuilder();
        query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo in ( ");
        query.append(requisicoes2);
        query.append(") and exa_kodigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_kodigo = ");
        query.append(mco_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int retorno = rs != null && rs.next() ? rs.getInt("erd_situacao") : -1;
        ps.close();
        return retorno;
    }

    public static synchronized Date getExmColeta(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exr_datamaterial from examerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        Timestamp retorno = rs != null && rs.next() ? rs.getTimestamp("exr_datamaterial") : null;
        ps.close();
        Conexao.fecharStatement(ps);
        return retorno;
    }

    public static synchronized ExameMaterial[] getDesmExamesPai(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and rec_kodigo = ").append(rec_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
        query.append(" and mco_kodigo = ").append(mco_kodigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return pais;
    }

    public static synchronized ExameMaterial[] getExameDesmembradosTubo(String fil_codigo, String req_codigo, String rec_kodigo, String int_codigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ").append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_kodigo);
        query.append(" and mco_kodigo = ");
        query.append(mco_kodigo);
        query.append(" order by exa_kodigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_kodigo"), rs.getInt("mco_kodigo"));
        }
        ps.close();
        return pais;
    }

    public static synchronized BDExame[] getDesmExamesFilhos(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo, erd_situacao, rec_kodigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" order by exa_kodigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        BDExame[] filhos = new BDExame[i];
        while (rs != null && rs.next()) {
            filhos[--i] = new BDExame(req_codigo, rs.getString("exa_kodigo"), rs.getString("mco_kodigo"), rec_codigo, rs.getString("rec_kodigo"), rs.getInt("erd_situacao"));
        }
        ps.close();
        return filhos;
    }

    public static List<BDExame> getDesmExamesFilhos(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo, erd_situacao from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo <> ");
        query.append(mco_codigo);
        query.append(" and mco_kodigo = ");
        query.append(mco_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_codigo);
        query.append(" order by exa_kodigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<BDExame> filhos = new ArrayList<BDExame>();
        while (rs != null && rs.next()) {
            filhos.add(new BDExame(req_codigo, rs.getString("exa_kodigo"), rs.getString("mco_kodigo"), rec_codigo, rs.getInt("erd_situacao")));
        }
        ps.close();
        return filhos;
    }

    public static List<BDExame> getDesmExamesFilhosX(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo, erd_situacao, rec_codigo, rec_kodigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and exa_codigo = '");
        query.append(exa_codigo);
        query.append("'");
        query.append(" order by exa_kodigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<BDExame> filhos = new ArrayList<BDExame>();
        while (rs != null && rs.next()) {
            filhos.add(new BDExame(req_codigo, rs.getString("exa_kodigo"), rs.getString("mco_kodigo"), rs.getString("rec_codigo"), rs.getString("rec_kodigo"), rs.getInt("erd_situacao")));
        }
        ps.close();
        return filhos;
    }

    public static synchronized BDExame[] getDesmExamesFilhos(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String rec_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo, erd_situacao from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_kodigo);
        query.append(" order by exa_kodigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        BDExame[] filhos = new BDExame[i];
        while (rs != null && rs.next()) {
            filhos[--i] = new BDExame(req_codigo, rs.getString("exa_kodigo"), rs.getString("mco_kodigo"), rec_codigo, rs.getInt("erd_situacao"));
        }
        ps.close();
        return filhos;
    }

    public static ExameMaterial[] getExamesFilhos(String fil_codigo, String int_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        ArrayList<ExameMaterial> lista = new ArrayList<ExameMaterial>();
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo from examematintdesmembrar where fil_codigo = ? ");
        query.append(" and int_codigo = ?");
        query.append(" and exa_codigo = ?");
        query.append(" and mco_codigo = ?");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(fil_codigo));
        ps.setInt(2, Integer.parseInt(int_codigo));
        ps.setString(3, exa_codigo);
        ps.setInt(4, Integer.parseInt(mco_codigo));
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            lista.add(new ExameMaterial(rs.getString("exa_kodigo"), rs.getInt("mco_kodigo")));
        }
        ExameMaterial[] retorno = new ExameMaterial[lista.size()];
        for (int i = 0; i < lista.size(); ++i) {
            retorno[i] = (ExameMaterial)lista.get(i);
        }
        ps.close();
        return retorno;
    }

    public static List<String> getRecipientesExame(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo) throws SQLException {
        ArrayList<String> lista = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("select rec_kodigo from examerequisicaorecipiente where fil_codigo = ? ");
        query.append(" and req_codigo in ( ").append(reqCodigo).append(") ");
        query.append(" and exa_codigo = ?");
        query.append(" and mco_codigo = ?");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(filCodigo));
        ps.setString(2, exaCodigo);
        ps.setInt(3, Integer.parseInt(mcoCodigo));
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            lista.add(rs.getString("rec_kodigo"));
        }
        ps.close();
        return lista;
    }

    public static List<String> getRecipientesExameDesm(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String intCodigo) throws SQLException {
        ArrayList<String> lista = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("select rec_kodigo from interfaceexamerequisicaodesm where fil_codigo = ? ");
        query.append(" and req_codigo in ( ").append(reqCodigo).append(") ");
        query.append(" and exa_kodigo = ?");
        query.append(" and mco_codigo = ?");
        query.append(" and int_codigo = ?");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(filCodigo));
        ps.setString(2, exaCodigo);
        ps.setInt(3, Integer.parseInt(mcoCodigo));
        ps.setInt(4, Integer.parseInt(intCodigo));
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            lista.add(rs.getString("rec_kodigo"));
        }
        ps.close();
        return lista;
    }

    public static synchronized int getDesmSituacao(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        return BDUtil.getDesmSituacaoPerfomance(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, exa_kodigo, mco_kodigo);
    }

    public static int getDesmSituacaoPerfomance(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and exa_codigo = ").append(DBUtil.bdText(exa_codigo));
        query.append(" and (rec_codigo = ").append(rec_codigo).append(" or rec_kodigo = ").append(rec_codigo).append(") ");
        query.append(" and mco_codigo = ").append(mco_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
        query.append(" and mco_kodigo = ").append(mco_kodigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int retorno = rs != null && rs.next() ? rs.getInt("erd_situacao") : -1;
        ps.close();
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getNomePaciente(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append(" select a.pac_nome ");
        query.append("   from requisicao b ");
        query.append("   left join paciente a on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        query.append("  where b.fil_codigo = ").append(fil_codigo);
        query.append("    and b.req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        String retorno = null;
        try {
            if (rs.next()) {
                retorno = rs.getString("pac_nome");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static synchronized Map<String, String> getDadosPacienteMaps(String fil_codigo, String req_codigo) throws SQLException {
        return BDUtil.getDadosPacienteMapsPerformance(fil_codigo, req_codigo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getDadosPacienteMapsPerformance(String fil_codigo, String req_codigo) throws SQLException {
        HashMap<String, String> maps = new HashMap<String, String>();
        StringBuilder query = new StringBuilder();
        query.append(" select a.pac_nome, a.pac_datanasc, a.pac_sexo, a.pac_codigo, med.med_nome ");
        query.append("   from requisicao b ");
        query.append("   left join paciente a on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        query.append("   left join medico med on  med.fil_codigo = b.fil_codigo and med.med_conselho = b.med_conselho and med.med_crm = b.med_crm and med.med_uf = b.med_uf ");
        query.append("  where b.fil_codigo = ").append(fil_codigo);
        query.append("    and b.req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQueryPerformance(st, query.toString());
        try {
            if (rs.next()) {
                maps.put("pac_nome", rs.getString("pac_nome"));
                maps.put("pac_datanasc", Funcoes.formataData("dd/MM/yyyy", rs.getDate("pac_datanasc")));
                maps.put("pac_sexo", rs.getString("pac_sexo"));
                maps.put("pac_codigo", rs.getString("pac_codigo"));
                maps.put("med_nome", rs.getString("med_nome"));
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return maps;
    }

    public static synchronized String getNomeConvenio(String fil_codigo, String req_codigo) throws SQLException {
        return BDUtil.getNomeConvenioPerfomance(fil_codigo, req_codigo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNomeConvenioPerfomance(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append(" select a.con_fantasia ");
        query.append("   from requisicao b ");
        query.append("   left join convenios a on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        query.append("  where b.fil_codigo = ").append(fil_codigo);
        query.append("    and b.req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        String retorno = null;
        try {
            if (rs.next()) {
                retorno = rs.getString("con_fantasia");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static synchronized String[] getIdadeNacimentoPaciente(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select b.req_idade, coalesce(b.req_anomes, 'A') as req_anomes, a.pac_datanasc from requisicao b left join paciente a ");
        query.append("on a.fil_codigo=b.fil_codigo and a.pac_codigo=b.pac_codigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.req_codigo = ");
        query.append(req_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs == null || !rs.next()) {
            return null;
        }
        String[] retorno = new String[]{rs.getString("req_idade"), rs.getString("req_anomes"), Funcoes.formataData(rs.getDate("pac_datanasc"))};
        ps.close();
        return retorno;
    }

    public static synchronized Date getDataNacimentoPaciente(String fil_codigo, String req_codigo) {
        try {
            StringBuilder query = new StringBuilder();
            query.append("select a.pac_datanasc from requisicao b left join paciente a ");
            query.append("on a.fil_codigo=b.fil_codigo and a.pac_codigo=b.pac_codigo where b.fil_codigo = ");
            query.append(fil_codigo);
            query.append(" and b.req_codigo = ");
            query.append(req_codigo);
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs == null || !rs.next()) {
                return null;
            }
            return rs.getDate("pac_datanasc");
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public static Date getDataNacimentoPacienteSemSynchronized(String fil_codigo, String req_codigo) {
        try {
            StringBuilder query = new StringBuilder();
            query.append("select a.pac_datanasc from requisicao b left join paciente a ");
            query.append("on a.fil_codigo=b.fil_codigo and a.pac_codigo=b.pac_codigo where b.fil_codigo = ");
            query.append(fil_codigo);
            query.append(" and b.req_codigo = ");
            query.append(req_codigo);
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs == null || !rs.next()) {
                return null;
            }
            return rs.getDate("pac_datanasc");
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public static synchronized String getCodigoPaciente(String fil_codigo, String req_codigo) throws SQLException {
        return BDUtil.getCodigoPacientePerfomance(fil_codigo, req_codigo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCodigoPacientePerfomance(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select pac_codigo from requisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        Statement st = Conexao.getStatement();
        String retorno = null;
        try {
            ResultSet rs = st.executeQuery(query.toString());
            retorno = rs != null && rs.next() ? rs.getString("pac_codigo") : null;
            st.close();
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static synchronized CodString[] getHistoricos(String fil_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select his_codigo, his_descricao from historicos where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" order by his_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        CodString[] hists = new CodString[i];
        while (rs != null && rs.next()) {
            hists[--i] = new CodString(rs.getInt("his_codigo"), rs.getString("his_descricao"));
        }
        ps.close();
        return hists;
    }

    public static synchronized ArrayList<Object[]> getExmHistoricos(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws Exception {
        Exame exm = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        ArrayList<Object[]> hists = new ArrayList<Object[]>();
        Map<String, Object> dados = exm.getDados();
        Set<String> keyset = dados.keySet();
        int i = 0;
        for (String key : keyset) {
            if (!key.matches("observacao_[012][0-9]")) continue;
            String valor = (String)dados.get(key);
            Object[] linha = new Object[]{StringUtil.preencheString(String.valueOf(++i), 2, '0', 1), valor};
            hists.add(linha);
        }
        return hists;
    }

    public static synchronized ModeloTabela getExmHistoricos(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, ModeloTabela modelo) throws SQLException {
        modelo.setData(new ArrayList());
        StringBuilder query = new StringBuilder();
        query.append("select ieh_campo, ieh_descricao from interfaceexmreqhistorico where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" order by ieh_campo");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                String ieh_campo = String.valueOf(rs.getInt("ieh_campo"));
                String ieh_descricao = rs.getString("ieh_descricao");
                modelo.addRow(new Object[]{ieh_campo, ieh_descricao});
            }
            ps.close();
            return modelo;
        }
        ps.close();
        return null;
    }

    public static synchronized String getExmCodigoMaterial(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select mco_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? String.valueOf(rs.getInt("mco_codigo")) : null;
        ps.close();
        return retorno;
    }

    public static synchronized String getExmCodigoMaterialDesm(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String exame) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select mco_codigo from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exame));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? String.valueOf(rs.getInt("mco_codigo")) : null;
        ps.close();
        return retorno;
    }

    public static synchronized Map<Integer, String> getExmResultadosAnteriores(String fil_codigo, String pac_codigo, String requisicao, String exa_codigo, String mco_codigo, String codMetodo) throws SQLException {
        return ExameUtil.getResultadosAnteriores(fil_codigo, requisicao, pac_codigo, exa_codigo, mco_codigo, codMetodo);
    }

    public static synchronized Registro getDadosRequisicao(String fil_codigo, String req_codigo) throws Exception {
        return BDUtil.getDadosRequisicaoPerfomance(fil_codigo, req_codigo);
    }

    public static synchronized Registro getDadosRequisicaoPerfomance(String fil_codigo, String req_codigo) throws Exception {
        if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo)) {
            throw new Exception("Requisi\u00e7\u00e3o n\u00e3o localizada. Filial: " + (fil_codigo == null ? "null" : fil_codigo) + ", Requisi\u00e7\u00e3o: " + (req_codigo == null ? "null" : req_codigo) + ".");
        }
        StringBuilder query = new StringBuilder();
        query.append("select a.des_codigo ");
        query.append("      ,a.con_codigo ");
        query.append("      ,a.req_idade ");
        query.append("      ,a.req_anomes ");
        query.append("      ,a.req_obs ");
        query.append("      ,a.req_dclinicos ");
        query.append("      ,a.med_conselho ");
        query.append("      ,a.med_uf ");
        query.append("      ,a.med_crm ");
        query.append("      ,b.med_nome ");
        query.append("  from requisicao a ");
        query.append("  left join medico b on a.fil_codigo = b.fil_codigo and a.med_conselho = b.med_conselho and a.med_crm = b.med_crm and a.med_uf = b.med_uf ");
        query.append(" where a.fil_codigo = ? ");
        query.append("   and a.req_codigo = ? ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(fil_codigo));
        ps.setInt(2, Integer.parseInt(req_codigo));
        ResultSet rs = Conexao.executeQueryPerformance(ps);
        Registro reg = null;
        if (rs.next()) {
            reg = new Registro(rs);
        }
        ps.close();
        Conexao.fecharStatement(ps);
        return reg;
    }

    public static synchronized Registro getDadosExameRequisicaoJalis(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exr_situacao, pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado, exr_resposta, coalesce(exr_coletaincorreta, false) as exr_coletaincorreta, exr_motivocoletaincorreta from examerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        Registro reg = null;
        if (rs.next()) {
            reg = new Registro(rs);
        }
        ps.close();
        Conexao.fecharStatement(ps);
        return reg;
    }

    public static Registro getDadosExameRequisicaoJalisSemResultado(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exr_situacao,  exr_resposta, coalesce(exr_coletaincorreta, false) as exr_coletaincorreta, exr_motivocoletaincorreta from examerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        Registro reg = null;
        if (rs.next()) {
            reg = new Registro(rs);
        }
        ps.close();
        Conexao.fecharStatement(ps);
        return reg;
    }

    public static Registro getDadosExameRequisicaoJalisResultado(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado from examerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        Registro reg = null;
        if (rs.next()) {
            reg = new Registro(rs);
        }
        ps.close();
        Conexao.fecharStatement(ps);
        return reg;
    }

    public static synchronized int getExameMetodo(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        return BDUtil.getExameMetodoPerformance(fil_codigo, exa_codigo, mco_codigo, int_codigo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getExameMetodoPerformance(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        PreparedStatement ps;
        block4: {
            ResultSet rs;
            StringBuilder query;
            block3: {
                int n;
                query = new StringBuilder();
                query.append("select met_codigo from examematinterface where fil_codigo = ");
                query.append(fil_codigo);
                query.append(" and exa_codigo = ");
                query.append(DBUtil.bdText(exa_codigo));
                query.append(" and mco_codigo = ");
                query.append(mco_codigo);
                query.append(" and int_codigo = ");
                query.append(int_codigo);
                ps = Conexao.getPreparedStatement(query.toString());
                rs = ps.executeQuery();
                try {
                    if (!rs.next() || rs.getInt("met_codigo") <= 0) break block3;
                    int i = rs.getInt("met_codigo");
                    ps.close();
                    n = i;
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(ps);
                    throw throwable;
                }
                Conexao.fecharStatement(ps);
                return n;
            }
            query.setLength(0);
            query.append("select met_codigo from examematcoleta where fil_codigo = ");
            query.append(fil_codigo);
            query.append(" and exa_codigo = ");
            query.append(DBUtil.bdText(exa_codigo));
            query.append(" and mco_codigo = ");
            query.append(mco_codigo);
            ps.close();
            ps = null;
            ps = Conexao.getPreparedStatement(query.toString());
            rs = ps.executeQuery();
            if (!rs.next() || rs.getInt("met_codigo") <= 0) break block4;
            int i = rs.getInt("met_codigo");
            ps.close();
            int n = i;
            Conexao.fecharStatement(ps);
            return n;
        }
        Conexao.fecharStatement(ps);
        return -1;
    }

    public static synchronized String getMatAbreviatura(String fil_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select mco_abreviatura from materialcoleta where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        String retorno = rs != null && rs.next() ? rs.getString("mco_abreviatura") : null;
        st.close();
        return retorno;
    }

    public static synchronized CodString[] getFiliais() throws SQLException {
        StringBuilder query = new StringBuilder("select fil_codigo, fil_descricao ");
        query.append("from filiais_postocoleta order by fil_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        CodString[] filiais = new CodString[i];
        while (rs != null && rs.next()) {
            filiais[--i] = new CodString(rs.getInt("fil_codigo"), rs.getString("fil_descricao"));
        }
        ps.close();
        return filiais;
    }

    public static synchronized Map<String, String> getInterfacesProtocolosDisponiveis() throws SQLException {
        PreparedStatement ps = Conexao.getPreparedStatement("select apa_nome, apa_classe from aparelhosinterface order by apa_nome");
        ResultSet rs = ps.executeQuery();
        LinkedHashMap<String, String> faces = new LinkedHashMap<String, String>();
        while (rs != null && rs.next()) {
            faces.put(rs.getString("apa_nome"), rs.getString("apa_classe"));
        }
        ps.close();
        return faces;
    }

    public static synchronized String getInterfaceProtocoloNome(String apa_classe) throws SQLException {
        StringBuilder query = new StringBuilder("select apa_nome from aparelhosinterface where apa_classe = ");
        query.append(DBUtil.bdText(apa_classe));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("apa_nome") : null;
        ps.close();
        return retorno;
    }

    public static synchronized String getInterfaceProtocoloClasse(String apa_nome) throws SQLException {
        StringBuilder query = new StringBuilder("select apa_classe from aparelhosinterface where apa_nome = ");
        query.append(DBUtil.bdText(apa_nome));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("apa_classe") : null;
        ps.close();
        return retorno;
    }

    public static synchronized CodString[] getInterfaces(String fil_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select int_codigo, int_descricao from interface where fil_codigo = ").append(fil_codigo);
        query.append(" and (int_inativo is null or not int_inativo) order by int_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        CodString[] faces = new CodString[i];
        while (rs != null && rs.next()) {
            faces[--i] = new CodString(rs.getInt("int_codigo"), rs.getString("int_descricao"));
        }
        ps.close();
        return faces;
    }

    public static synchronized void setExmXmlValores(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String ier_xmlvalores) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_xmlvalores = ");
        query.append(DBUtil.bdText(ier_xmlvalores));
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmXmlValoresESituacao(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String ier_xmlvalores, int situacao) throws SQLException {
        BDUtil.setExmXmlValoresESituacaoPerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, ier_xmlvalores, situacao);
    }

    public static void setExmXmlValoresESituacaoPerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String ier_xmlvalores, int situacao) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_xmlvalores = ");
        query.append(DBUtil.bdText(ier_xmlvalores));
        query.append(", ier_situacao  = ");
        query.append(situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executePerformance(fil_codigo, st, query.toString(), false);
    }

    public static synchronized void setExmSituacao(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao) throws SQLException {
        BDUtil.setExmSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, nova_situacao, null);
    }

    public static synchronized void setExmSituacao(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao, String nova_rack) throws SQLException {
        BDUtil.setExmSituacaoPerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, nova_situacao, nova_rack);
    }

    public static void setExmSituacaoPerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao, String nova_rack) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        if (nova_rack != null) {
            query.append(", ier_rackpos = '").append(nova_rack).append("' ");
        }
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static void setValorAlterado(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int valorAlterado) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_resultadoalterado  = ");
        query.append(valorAlterado);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmSituacao(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, int nova_situacao, String int_codigo, String rec_codigo) throws SQLException {
        BDUtil.setExmSituacao(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, nova_situacao, null, int_codigo, rec_codigo);
    }

    public static synchronized void setExmSituacao(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, int nova_situacao, String nova_rack, String int_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        if (nova_rack != null) {
            query.append(", ier_rackpos = '").append(nova_rack).append("' ");
        }
        query.append(" where fil_codigo = ").append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and exa_codigo = ").append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ").append(mco_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and rec_codigo = ").append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmSituacao(Statement st, int nova_situacao, int situacao, String int_codigo, String fil_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        query.append(" where int_codigo = ").append(int_codigo);
        query.append(" and ier_situacao= ").append(situacao);
        query.append(" and fil_codigo = ").append(fil_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmSituacaoTodosFilhos(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao) throws SQLException {
        BDUtil.setExmSituacaoTodosFilhosPerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, nova_situacao);
    }

    public static void setExmSituacaoTodosFilhosPerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmSituacaoFilho(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String exa_codigoFilho, String mco_codigoFilho, String rec_codigo, int nova_situacao) throws SQLException {
        ArrayList<String> multiGuias;
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and exa_kodigo = ");
        query.append(DBUtil.bdText(exa_codigoFilho));
        query.append(" and mco_kodigo = ");
        query.append(mco_codigoFilho);
        int qtde = Conexao.executeUpdate(fil_codigo, st, query.toString());
        if (qtde == 0 && (multiGuias = BDUtil.getReqMultiGuias(fil_codigo, req_codigo)) != null && !multiGuias.isEmpty()) {
            for (String req : multiGuias) {
                query.setLength(0);
                query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
                query.append(nova_situacao);
                query.append(" where fil_codigo = ");
                query.append(fil_codigo);
                query.append(" and int_codigo = ");
                query.append(int_codigo);
                query.append(" and req_codigo = ");
                query.append(req);
                query.append(" and exa_codigo = ");
                query.append(DBUtil.bdText(exa_codigo));
                query.append(" and mco_codigo = ");
                query.append(mco_codigo);
                query.append(" and rec_codigo = ");
                query.append(rec_codigo);
                query.append(" and exa_kodigo = ");
                query.append(DBUtil.bdText(exa_codigoFilho));
                query.append(" and mco_kodigo = ");
                query.append(mco_codigoFilho);
                qtde = Conexao.executeUpdate(fil_codigo, st, query.toString());
            }
        }
    }

    public static synchronized void setExmSituacaoTubo(Statement st, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, int nova_situacao) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        query.delete(0, query.length());
        query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmSituacaoRackTubo(Statement st, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, int nova_situacao, String ier_rackpos) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        query.append(", ier_rackpos = ");
        query.append(DBUtil.bdText(ier_rackpos));
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        query.delete(0, query.length());
        query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void setDesmSituacao(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exa_kodigo, String mco_kodigo, int nova_situacao) throws SQLException {
        BDUtil.setDesmSituacaoPerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, exa_kodigo, mco_kodigo, nova_situacao);
    }

    public static void setDesmSituacaoPerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String exa_kodigo, String mco_kodigo, int nova_situacao) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
        query.append(nova_situacao);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and exa_kodigo = ");
        query.append(DBUtil.bdText(exa_kodigo));
        query.append(" and mco_kodigo = ");
        query.append(mco_kodigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static synchronized void setExmSituacaoEAssinatura(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao, String usr_codigo) throws SQLException {
        BDUtil.setExmSituacaoEAssinaturaPerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, nova_situacao, usr_codigo);
    }

    public static void setExmSituacaoEAssinaturaPerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int nova_situacao, String usr_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(nova_situacao);
        query.append(", usr_codigo = ");
        if (Funcoes.textoVazio(usr_codigo)) {
            query.append(DBUtil.bdText(Variaveis.login));
        } else {
            query.append(DBUtil.bdText(usr_codigo));
        }
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static synchronized void setReagenteLoteESerial(Statement st, String fil_codigo, String exa_codigo, String mco_codigo, String req_codigo, String exr_lotereag, String exr_serialreag) throws SQLException {
        exr_lotereag = DBUtil.bdText(exr_lotereag);
        exr_serialreag = DBUtil.bdText(exr_serialreag);
        StringBuilder query = new StringBuilder();
        query.append("update examerequisicao set exr_lotereag = ");
        query.append(exr_lotereag);
        query.append(", exr_serialreag = ");
        query.append(exr_serialreag);
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void deletarExamesPorRecipienteSituacao(Statement st, String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, int situacao) throws SQLException {
        class Req {
            protected String requisicao;
            protected String exame;
            protected String material;

            public Req(String requisicao, String exame, String material) {
                this.requisicao = requisicao;
                this.exame = exame;
                this.material = material;
            }
        }
        ArrayList<Req> requisicoesParaDesmarcar = new ArrayList<Req>();
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, req_codigo, mco_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and ier_situacao = ");
        query.append(situacao);
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        while (rs.next()) {
            requisicoesParaDesmarcar.add(new Req(req_codigo, rs.getString("exa_codigo"), rs.getString("mco_codigo")));
        }
        query.setLength(0);
        query.append("delete from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and ier_situacao = ");
        query.append(situacao);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        query.setLength(0);
        query.append("delete from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        for (Req r : requisicoesParaDesmarcar) {
            query.setLength(0);
            query.setLength(0);
            query.append("update examerequisicao set exr_interfaciado = false ");
            query.append(" where fil_codigo = ").append(fil_codigo);
            query.append(" and req_codigo = ").append(req_codigo);
            query.append(" and mco_codigo = ").append(r.material);
            query.append(" and exa_codigo = '").append(r.exame).append("'");
            Conexao.executeUpdate(fil_codigo, st, query.toString());
        }
    }

    public static synchronized void deletarExame(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("delete from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        query.setLength(0);
        query.append("delete from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        query.setLength(0);
        query.append("update examerequisicao set exr_interfaciado = false ");
        query.append(" where fil_codigo = ").append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and mco_codigo = ").append(mco_codigo);
        query.append(" and exa_codigo = '").append(exa_codigo).append("'");
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized void limparBaseLocal(Statement st, String fil_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("delete from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        Conexao.executeUpdate(fil_codigo, st, query.toString());
    }

    public static synchronized int getContagemExames(String fil_codigo, String req_codigo) throws SQLException {
        int count = 0;
        StringBuilder query = new StringBuilder();
        query.append("select count(req_codigo) as contagem from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs == null || !rs.next()) {
            ps.close();
            throw new SQLException("Erro ao contar exames da requisi\u00e7\u00e3o no banco de dados.");
        }
        ps.close();
        return count += rs.getInt("contagem");
    }

    public static synchronized String getExmCodigoAlternativo(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select emi_alternativo from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        String retorno = rs != null && rs.next() ? rs.getString("emi_alternativo") : null;
        st.close();
        return retorno;
    }

    public static synchronized Registro getCodigoExame(String fil_codigo, String alternativo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select ex.exa_codigo, ex.mco_codigo, ier.rec_codigo from examematinterface ex ");
        query.append("left join interfaceexamerequisicao ier on (ex.fil_codigo = ier.fil_codigo and ex.mco_codigo = ier.mco_codigo and ex.exa_codigo = ier.exa_codigo)");
        query.append(" where ex.fil_codigo =");
        query.append(fil_codigo);
        query.append(" and ex.emi_alternativo = ");
        query.append(DBUtil.bdText(alternativo));
        query.append(" and ier.req_codigo =").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        boolean i = false;
        if (rs.next()) {
            Registro retorno = new Registro(rs);
            st.close();
            return retorno;
        }
        return null;
    }

    public static synchronized Registro getCodExameAlternativoDesm(String fil_codigo, String alternativo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append(" select ier.exa_codigo, ier.mco_codigo, ier.int_codigo from examematinterface r ");
        query.append(" left join examematintdesmembrar ier ");
        query.append(" on (r.exa_codigo = ier.exa_kodigo and r.fil_codigo = ier.fil_codigo and r.mco_codigo = ier.mco_codigo) ");
        query.append(" where r.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and r.emi_alternativo = ");
        query.append(DBUtil.bdText(alternativo));
        query.append(" and ier.int_codigo = ").append(int_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        boolean i = false;
        if (rs.next()) {
            Registro retorno = new Registro(rs);
            st.close();
            return retorno;
        }
        return null;
    }

    public static synchronized String getExmEquipamentoMaterial(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select emi_material from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        String retorno = rs != null && rs.next() ? rs.getString("emi_material") : null;
        st.close();
        return retorno;
    }

    public static synchronized ExameMaterial[] getExamesLIS(String fil_codigo, String int_codigo, String emi_alternativo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and emi_alternativo = ");
        query.append(DBUtil.bdText(emi_alternativo));
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] exames = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            exames[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return exames;
    }

    public static synchronized ExameMaterial[] getExamesReqLIS(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select ier.exa_codigo, ier.mco_codigo from interfaceexamerequisicao ier  ");
        query.append("left join interfaceexamerequisicaodesm ierd on (ier.fil_codigo = ierd.fil_codigo and ier.req_codigo = ierd.req_codigo and ier.rec_codigo = ierd.rec_codigo and ier.exa_codigo = ierd.exa_codigo and ier.mco_codigo = ierd.mco_codigo)");
        query.append("where ier.fil_codigo =");
        query.append(fil_codigo);
        query.append(" and ier.int_codigo = ");
        query.append(int_codigo);
        query.append(" and ier.req_codigo = ");
        query.append(DBUtil.bdText(req_codigo));
        query.append(" and (ier.rec_codigo = ");
        query.append(DBUtil.bdText(rec_codigo));
        query.append("or ierd.rec_kodigo = ").append(DBUtil.bdText(rec_codigo)).append(")");
        query.append(" order by ier.exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] exames = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            exames[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return exames;
    }

    public static ExameMaterial getExamesLIS(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String emi_alternativo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select b.exa_codigo ");
        query.append("      ,b.mco_codigo ");
        query.append("  from interfaceexamerequisicao a ");
        query.append("  left join examematinterface b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo and a.int_codigo = b.int_codigo ");
        query.append(" where a.fil_codigo = ? ");
        query.append("   and a.req_codigo = ? ");
        query.append("   and a.rec_codigo = ? ");
        query.append("   and a.int_codigo = ? ");
        query.append("   and b.emi_alternativo = ? ");
        query.append("   and a.ier_situacao in(?, ?, ?, ?, ?) ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(fil_codigo));
        ps.setInt(2, Integer.parseInt(req_codigo));
        ps.setInt(3, Integer.parseInt(rec_codigo));
        ps.setInt(4, Integer.parseInt(int_codigo));
        ps.setString(5, StringUtil.textoDB(emi_alternativo));
        ps.setInt(6, 0);
        ps.setInt(7, 1);
        ps.setInt(8, 3);
        ps.setInt(9, 4);
        ps.setInt(10, 5);
        ResultSet rs = Conexao.executeQuery(ps);
        ExameMaterial exame = null;
        if (rs.next()) {
            exame = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return exame;
    }

    @Deprecated
    public static ExameMaterial getExamesLISDesm(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String emi_alternativo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select b.exa_codigo, b.mco_codigo from  interfaceexamerequisicaodesm a");
        query.append(" left join examematinterface b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo and a.mco_kodigo = b.mco_codigo and a.int_codigo = b.int_codigo ");
        query.append(" where a.fil_codigo = ").append(fil_codigo);
        query.append(" and a.req_codigo = ");
        query.append(req_codigo);
        query.append(" and a.rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and a.int_codigo = ");
        query.append(int_codigo);
        query.append(" and b.emi_alternativo = ");
        query.append(DBUtil.bdText(emi_alternativo));
        query.append(" and a.erd_situacao in( ").append(0);
        query.append(", ").append(1);
        query.append(", ").append(3);
        query.append(", ").append(4);
        query.append(", ").append(5).append(") ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial exame = null;
        if (i == 1 && rs.next()) {
            exame = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return exame;
    }

    public static synchronized ExameMaterial[] getExamesLIS(String fil_codigo, String int_codigo, String emi_alternativo, String emi_material) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and emi_alternativo = ");
        query.append(DBUtil.bdText(emi_alternativo));
        query.append(" and emi_material = ");
        query.append(DBUtil.bdText(emi_material));
        query.append(" order by exa_codigo desc");
        Statement ps = Conexao.getStatement();
        ResultSet rs = ps.executeQuery(query.toString());
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] exames = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            exames[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return exames;
    }

    public static ArrayList<String> getReqMultiGuias(String filCodigo, String reqCodigo) throws SQLException {
        Statement st = Conexao.getStatement();
        ArrayList<String> retorno = BDUtil.getReqMultiGuias(filCodigo, reqCodigo, st);
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static ArrayList<String> getReqMultiGuias(String filCodigo, String reqCodigo, Statement st) throws SQLException {
        ArrayList<String> requisicoes = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo from requisicaorequisicao where fil_codigo = ");
        query.append(filCodigo);
        query.append(" and req_kodigo = ");
        query.append(reqCodigo);
        ResultSet rs = st.executeQuery(query.toString());
        if (rs != null && rs.next()) {
            reqCodigo = rs.getString("req_codigo");
        }
        requisicoes.add(reqCodigo);
        query.delete(0, query.length());
        query.append("select req_kodigo from requisicaorequisicao where fil_codigo = ");
        query.append(filCodigo);
        query.append(" and req_codigo = ");
        query.append(reqCodigo);
        rs = st.executeQuery(query.toString());
        while (rs != null && rs.next()) {
            requisicoes.add(rs.getString("req_kodigo"));
        }
        return requisicoes;
    }

    public static ArrayList<String> getReqMultiGuiasWithZeros(String fil_codigo, String req_codigo) throws SQLException {
        ArrayList<String> requisicoes = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo from requisicaorequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_kodigo = ");
        query.append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(query.toString());
        if (rs != null && rs.next()) {
            req_codigo = rs.getString("req_codigo");
        }
        st.close();
        requisicoes.add(req_codigo);
        query.delete(0, query.length());
        query.append("select req_kodigo from requisicaorequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        st = Conexao.getStatement();
        rs = st.executeQuery(query.toString());
        while (rs != null && rs.next()) {
            requisicoes.add(Funcoes.preencheZero(rs.getString("req_kodigo"), ParametrosGerais.getDigitosTuboRequisicao()));
        }
        st.close();
        return requisicoes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getReqMultiGuiaMae(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select pegaCodigoMultiguiaMae(").append(fil_codigo).append(", ").append(req_codigo).append(") as multiguia");
        Statement st = Conexao.getStatement();
        String retorno = null;
        try {
            ResultSet rs = Conexao.executeQuery(st, query.toString());
            if (rs.next()) {
                retorno = rs.getString("multiguia");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static synchronized ExameMaterial getReqExameLIS(Statement st, String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select a.exa_codigo, a.mco_codigo from interfaceexamerequisicao b left join ");
        query.append("examematinterface a on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo");
        query.append(" and a.mco_codigo = b.mco_codigo and a.int_codigo = b.int_codigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.int_codigo = ");
        query.append(int_codigo);
        query.append(" and b.req_codigo = ");
        query.append(req_codigo);
        query.append(" and b.rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and a.emi_alternativo = ");
        query.append(DBUtil.bdText(emi_alternativo));
        query.append(" order by a.exa_codigo desc");
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        return rs != null && rs.next() ? new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo")) : null;
    }

    public static synchronized ExameMaterial getReqExameFilhoLIS(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        if (!Funcoes.isNumeric(fil_codigo) || !Funcoes.isNumeric(req_codigo) || !Funcoes.isNumeric(int_codigo) || rec_codigo.trim().length() > 0 && !Funcoes.isNumeric(rec_codigo)) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        query.append("select a.exa_codigo, a.mco_codigo from interfaceexamerequisicaodesm b left join ");
        query.append("examematinterface a on a.fil_codigo = b.fil_codigo and ");
        query.append("a.int_codigo = b.int_codigo and a.exa_codigo = b.exa_kodigo and ");
        query.append("a.mco_codigo = b.mco_kodigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.int_codigo = ");
        query.append(int_codigo);
        query.append(" and b.req_codigo = ");
        query.append(req_codigo);
        if (rec_codigo.trim().length() > 0) {
            query.append(" and b.rec_kodigo = ");
        }
        query.append(rec_codigo);
        query.append(" and a.emi_alternativo = ");
        query.append(DBUtil.bdText(emi_alternativo));
        query.append(" order by a.exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ExameMaterial exa = rs != null && rs.next() ? new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo")) : null;
        ps.close();
        return exa;
    }

    public static synchronized ExameMaterial getReqExamePaiLIS(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        if (!Funcoes.isNumeric(fil_codigo) || !Funcoes.isNumeric(req_codigo) || !Funcoes.isNumeric(int_codigo) || rec_codigo.trim().length() > 0 && !Funcoes.isNumeric(rec_codigo)) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        query.append("select b.exa_codigo, b.mco_codigo from interfaceexamerequisicaodesm b left join ");
        query.append("examematinterface a on a.fil_codigo = b.fil_codigo and ");
        query.append("a.int_codigo = b.int_codigo and a.exa_codigo = b.exa_kodigo and ");
        query.append("a.mco_codigo = b.mco_kodigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.int_codigo = ");
        query.append(int_codigo);
        query.append(" and b.req_codigo = ");
        query.append(req_codigo);
        if (rec_codigo.trim().length() > 0) {
            query.append(" and b.rec_kodigo = ");
        }
        query.append(rec_codigo);
        query.append(" order by a.exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ExameMaterial exa = rs != null && rs.next() ? new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo")) : null;
        ps.close();
        return exa;
    }

    public static String getInterfaceExameAlternativo(String fil_codigo, String req_codigo, String rec_codigo, String emi_alternativo) throws SQLException {
        return BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, emi_alternativo, false);
    }

    public static String getInterfaceExameAlternativo(String fil_codigo, String req_codigo, String rec_codigo, String emi_alternativo, boolean primeiroEncontrado) throws SQLException {
        String int_codigo = null;
        StringBuilder query = new StringBuilder();
        query.append("select b.int_codigo, b.ier_situacao from interfaceexamerequisicao b left join ");
        query.append("examematinterface a on a.fil_codigo = b.fil_codigo and ");
        query.append("a.int_codigo = b.int_codigo and a.exa_codigo = b.exa_codigo and ");
        query.append("a.mco_codigo = b.mco_codigo where b.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and b.req_codigo = ");
        query.append(req_codigo);
        query.append(" and b.rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and a.emi_alternativo = ");
        query.append(DBUtil.bdText(emi_alternativo));
        query.append(" and b.ier_situacao in( ").append(0);
        query.append(", ").append(1);
        query.append(", ").append(3);
        query.append(", ").append(4);
        query.append(", ").append(5).append(") ");
        query.append(" order by b.ier_situacao desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int_codigo = rs.getString("int_codigo");
            if (!primeiroEncontrado && rs.next()) {
                int_codigo = null;
            }
        }
        ps.close();
        return int_codigo;
    }

    public static synchronized BDExame[] getReqExames(String fil_codigo, String int_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo, rec_codigo, ier_situacao from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        BDExame[] exames = new BDExame[i];
        while (rs != null && rs.next()) {
            String exa_codigo = rs.getString("exa_codigo");
            String mco_codigo = rs.getString("mco_codigo");
            String rec_codigo = rs.getString("rec_codigo");
            Integer ier_situacao = rs.getInt("ier_situacao");
            exames[--i] = new BDExame(req_codigo, exa_codigo, mco_codigo, rec_codigo, ier_situacao);
        }
        ps.close();
        return exames;
    }

    public static synchronized BDExame[] getReqExames(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        return BDUtil.getReqExamesPerformance(fil_codigo, int_codigo, req_codigo, rec_codigo);
    }

    public static BDExame[] getReqExamesPerformance(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo, ier_situacao from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        BDExame[] exames = new BDExame[i];
        while (rs != null && rs.next()) {
            exames[--i] = new BDExame(req_codigo, rs.getString("exa_codigo"), rs.getString("mco_codigo"), rec_codigo, rs.getInt("ier_situacao"));
        }
        ps.close();
        return exames;
    }

    public static List<BDExame> getReqExamesMultGuia(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        return BDUtil.getReqExamesMultGuiaPerformance(fil_codigo, int_codigo, req_codigo, rec_codigo);
    }

    public static List<BDExame> getReqExamesMultGuiaPerformance(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo) throws SQLException {
        ArrayList<BDExame> exames = new ArrayList<BDExame>();
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            Collections.addAll(exames, BDUtil.getReqExamesPerformance(fil_codigo, int_codigo, req_codigo, rec_codigo));
            ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            for (String req : requisicoes) {
                BDExame[] examesTemp;
                for (BDExame bdExame : examesTemp = BDUtil.getReqExamesPerformance(fil_codigo, int_codigo, req, rec_codigo)) {
                    if (exames.contains(bdExame)) continue;
                    exames.add(bdExame);
                }
            }
        } else {
            Collections.addAll(exames, BDUtil.getReqExamesPerformance(fil_codigo, int_codigo, req_codigo, rec_codigo));
        }
        return exames;
    }

    public static synchronized String getHisDescricao(String fil_codigo, String his_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select his_descricao from historicos where his_codigo = ");
        query.append(his_codigo);
        query.append(" and fil_codigo = ");
        query.append(fil_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("his_descricao") : null;
        ps.close();
        return retorno;
    }

    public static synchronized String getUsuarioNome(String usr_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select usr_nome from usuario where usr_codigo = ");
        query.append(DBUtil.bdText(usr_codigo));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("usr_nome") : null;
        ps.close();
        return retorno;
    }

    public static synchronized String getReqSituacao(String fil_codigo, String req_codigo, String exa_codigo, int mco_codigo) throws SQLException {
        return BDUtil.getReqSituacaoPerformance(fil_codigo, req_codigo, exa_codigo, mco_codigo);
    }

    public static String getReqSituacaoPerformance(String fil_codigo, String req_codigo, String exa_codigo, int mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exr_situacao from examerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("exr_situacao") : null;
        ps.close();
        Conexao.fecharStatement(ps);
        return retorno;
    }

    public static synchronized void insertRack(Statement st, String fil_codigo, String int_codigo, String ira_codigo, String ira_valor) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("insert into interfacerack (fil_codigo, int_codigo, ira_codigo, ira_valor) values (");
        query.append(fil_codigo);
        query.append(", ");
        query.append(int_codigo);
        query.append(", ");
        query.append(DBUtil.bdText(ira_codigo));
        query.append(", ");
        query.append(DBUtil.bdText(ira_valor));
        query.append(")");
        Conexao.execute(fil_codigo, st, query.toString());
    }

    public static synchronized void deleteRack(Statement st, String fil_codigo, String int_codigo, String ira_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("delete from interfacerack where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and ira_codigo = ");
        query.append(DBUtil.bdText(ira_codigo));
        Conexao.executeUpdate(fil_codigo, st, query.toString());
        Conexao.arquivaSQL();
    }

    public static synchronized boolean isReqUrgente(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select req_urgente from requisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = false;
        if (rs != null && rs.next()) {
            retorno = rs.getBoolean("req_urgente");
        }
        ps.close();
        return retorno;
    }

    public static synchronized boolean isRackChaveValida(String fil_codigo, String int_codigo, String ira_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select ira_codigo from interfacerack where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and ira_codigo = ");
        query.append(DBUtil.bdText(ira_codigo));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = rs != null && rs.next();
        ps.close();
        return retorno;
    }

    public static synchronized boolean isRackValorValido(String fil_codigo, String int_codigo, String ira_codigo, String ira_valor) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select ira_valor from interfacerack where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and ira_codigo = ");
        query.append(DBUtil.bdText(ira_codigo));
        query.append(" and ira_valor = ");
        query.append(DBUtil.bdText(ira_valor));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = rs != null && rs.next();
        ps.close();
        return retorno;
    }

    public static synchronized ArrayList<Rack> getRackList(String fil_codigo, String int_codigo) throws SQLException {
        ArrayList<Rack> racks = new ArrayList<Rack>();
        StringBuilder query = new StringBuilder();
        query.append("select ira_codigo, ira_valor from interfacerack where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" order by ira_codigo, ira_valor");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            Rack rack = new Rack(rs.getString("ira_codigo"), rs.getString("ira_valor"));
            racks.add(rack);
        }
        ps.close();
        return racks;
    }

    public static synchronized ArrayList<String> getRackValores(String fil_codigo, String int_codigo, String ira_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select ira_valor from interfacerack where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and ira_codigo = ");
        query.append(DBUtil.bdText(ira_codigo));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> valores = new ArrayList<String>();
        while (rs != null && rs.next()) {
            valores.add(rs.getString("ira_valor"));
        }
        ps.close();
        return valores;
    }

    public static synchronized String getRackValor(String fil_codigo, String int_codigo, String ira_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select ira_valor from interfacerack where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and ira_codigo = ");
        query.append(DBUtil.bdText(ira_codigo));
        query.append(" order by ira_codigo");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("ira_valor") : null;
        ps.close();
        return retorno;
    }

    public static synchronized boolean isExameCurva(String fil_codigo, String int_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select emi_curva from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = false;
        if (rs != null && rs.next()) {
            retorno = rs.getBoolean("emi_curva");
        }
        ps.close();
        return retorno;
    }

    public static synchronized boolean isExameDesmembrado(String fil_codigo, String int_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        return BDUtil.isExameDesmembradoPerformance(fil_codigo, int_codigo, exa_codigo, mco_codigo);
    }

    public static boolean isExameDesmembradoPerformance(String fil_codigo, String int_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo from examematintdesmembrar where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" limit 1 ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = false;
        retorno = rs != null && rs.next();
        ps.close();
        return retorno;
    }

    public static synchronized boolean verificaExameVariosParametros(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        Object situacao = null;
        Map<Object, Object> dados = new HashMap();
        Statement st = Conexao.getStatement();
        StringBuilder query = new StringBuilder();
        query.append("select ier_xmlvalores from ");
        query.append("interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = '");
        query.append(exa_codigo);
        query.append("' and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        if (rs != null && rs.next()) {
            dados = StringUtil.getMapDeXML(rs.getString("ier_xmlvalores"));
        }
        int contador = 0;
        for (String key : dados.keySet()) {
            if (!key.contains("resultado_quantitativo") && !key.contains("repeticao_qualitativo") && !key.contains("@") && !key.contains("#")) continue;
            ++contador;
        }
        rs.close();
        st.close();
        return contador > 1;
    }

    public static synchronized boolean isGrupoInteiroPendente(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            if (rs.getInt("erd_situacao") >= 1) continue;
            ps.close();
            return false;
        }
        if (!ParametrosGerais.isAgruparGuiasInterface()) {
            return true;
        }
        if (rs != null) {
            ArrayList<String> multiGuias = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            if (multiGuias != null && !multiGuias.isEmpty()) {
                for (String req : multiGuias) {
                    query.setLength(0);
                    query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
                    query.append(fil_codigo);
                    query.append(" and int_codigo = ");
                    query.append(int_codigo);
                    query.append(" and req_codigo = ");
                    query.append(req);
                    query.append(" and exa_codigo = ");
                    query.append(DBUtil.bdText(exa_codigo));
                    query.append(" and mco_codigo = ");
                    query.append(mco_codigo);
                    query.append(" and rec_codigo = ");
                    query.append(rec_codigo);
                    ps = Conexao.getPreparedStatement(query.toString());
                    rs = ps.executeQuery();
                    while (rs != null && rs.next()) {
                        if (rs.getInt("erd_situacao") >= 1) continue;
                        ps.close();
                        return false;
                    }
                }
            }
            ps.close();
            return true;
        }
        ps.close();
        return false;
    }

    public static synchronized boolean isGrupoInteiroPronto(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            if (rs.getInt("erd_situacao") == 2) continue;
            ps.close();
            return false;
        }
        if (rs != null) {
            ps.close();
            return true;
        }
        ps.close();
        return false;
    }

    public static synchronized boolean isGrupoInteiroRepetido(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select erd_situacao from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            if (rs.getInt("erd_situacao") == 4 || rs.getInt("erd_situacao") == 2) continue;
            ps.close();
            return false;
        }
        if (rs != null) {
            ps.close();
            return true;
        }
        ps.close();
        return false;
    }

    public static synchronized ArrayList<String> getRequisicaoTuboRack(String fil_codigo, String int_codigo, String ier_situacao, String ier_rackpos) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo, rec_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and ier_situacao = ");
        query.append(ier_situacao);
        query.append(" and ier_rackpos = ");
        query.append(DBUtil.bdText(ier_rackpos));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> values = null;
        if (rs != null && rs.next()) {
            values = new ArrayList<String>();
            values.add(rs.getString("req_codigo"));
            values.add(rs.getString("rec_codigo"));
        }
        ps.close();
        return values;
    }

    public static synchronized ArrayList<String> getRequisicaoTuboRackExame(String fil_codigo, String int_codigo, String ier_situacao, String ier_rackpos, String exa_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select req_codigo, rec_codigo from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and ier_situacao = ").append(ier_situacao);
        query.append(" and ier_rackpos = ").append(DBUtil.bdText(ier_rackpos));
        query.append(" and exa_codigo = ").append(DBUtil.bdText(exa_codigo));
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> values = null;
        if (rs != null && rs.next()) {
            values = new ArrayList<String>();
            values.add(rs.getString("req_codigo"));
            values.add(rs.getString("rec_codigo"));
        }
        ps.close();
        return values;
    }

    public static synchronized String getInterfaceExameTuboRequisicao(String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select int_codigo from interfaceexamerequisicao where fil_codigo = ");
        sql.append(fil_codigo);
        sql.append(" and req_codigo = ").append(req_codigo);
        sql.append(" and rec_codigo = ").append(rec_codigo);
        sql.append(" and exa_codigo = ").append(DBUtil.bdText(exa_codigo));
        PreparedStatement ps = Conexao.getPreparedStatement(sql.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = null;
        if (rs != null && rs.next()) {
            retorno = Integer.toString(rs.getInt("int_codigo"));
        }
        ps.close();
        return retorno;
    }

    public static synchronized ArrayList<String> getInterfaceTuboExameRequisicaoRack(String fil_codigo, String req_codigo, String ier_rackpos) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select int_codigo, rec_codigo from interfaceexamerequisicao where fil_codigo = ");
        sql.append(fil_codigo);
        sql.append(" and req_codigo = ").append(req_codigo);
        sql.append(" and ier_rackpos = ").append(DBUtil.bdText(ier_rackpos));
        PreparedStatement ps = Conexao.getPreparedStatement(sql.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> values = null;
        if (rs != null && rs.next()) {
            values = new ArrayList<String>();
            values.add(rs.getString("int_codigo"));
            values.add(rs.getString("rec_codigo"));
        }
        ps.close();
        return values;
    }

    public static synchronized String montaSQLEquipamentoFilial() {
        StringBuilder sql = new StringBuilder("(");
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial e : c.getEquipamentos()) {
                if (sql.length() > 1) {
                    sql.append(" or ");
                }
                sql.append("(a.fil_codigo = ").append(e.getFilial()).append(" and a.int_codigo = ").append(e.getEquipamento()).append(")");
            }
        }
        sql.append(")");
        return sql.toString();
    }

    public static ArrayList<String> getIntDesmExamesPai(String fil_codigo, String req_codigo, String rec_codigo, String exa_kodigo) throws SQLException {
        ArrayList<String> exames = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append(" select a.exa_codigo ");
        query.append("   from interfaceexamerequisicaodesm a ");
        query.append("   left join examematinterface b on a.fil_codigo = b.fil_codigo and a.int_codigo = b.int_codigo and a.exa_kodigo = b.exa_codigo and a.mco_kodigo = b.mco_codigo ");
        query.append("  where a.fil_codigo = ? ");
        query.append("    and a.req_codigo = ? ");
        query.append("    and a.rec_codigo = ? ");
        query.append("    and b.emi_alternativo = ? ");
        PreparedStatement prst = Conexao.getPreparedStatement(query.toString());
        prst.setInt(1, Integer.parseInt(fil_codigo));
        prst.setInt(2, Integer.parseInt(req_codigo));
        prst.setInt(3, Integer.parseInt(rec_codigo));
        prst.setString(4, StringUtil.textoDB(exa_kodigo));
        ResultSet rs = Conexao.executeQuery(prst);
        while (rs.next()) {
            exames.add(rs.getString("exa_codigo"));
        }
        prst.close();
        return exames;
    }

    public static boolean verificaDiaDeRotina(String filial, String codigoExame, String codigoMaterial, int diaAtual) throws SQLException {
        boolean retorno = true;
        StringBuilder buf = new StringBuilder("select b.prz_prazo from examematcoleta a ");
        buf.append("left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
        buf.append("where a.fil_codigo = ").append(filial);
        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' ");
        buf.append(" and mco_codigo = ").append(codigoMaterial);
        PreparedStatement ps = Conexao.getPreparedStatement(buf.toString());
        ResultSet rs = ps.executeQuery();
        if (rs.next() && diaAtual >= 0 && diaAtual < 7) {
            String prazo = rs.getString("prz_prazo");
            retorno = prazo.length() == 7 && prazo.substring(diaAtual - 1, diaAtual).equals("R");
        }
        ps.close();
        return retorno;
    }

    public static String buscaMedicoRequisicao(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.med_crm, a.med_uf, b.med_nome from requisicao a ");
        sql.append(" left join medico b on a.fil_codigo = b.fil_codigo and a.med_conselho = b.med_conselho and a.med_crm = b.med_crm and a.med_uf = b.med_uf ");
        sql.append(" where a.fil_codigo = ").append(fil_codigo);
        sql.append(" and a.req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            sql.setLength(0);
            sql.append(StringUtil.removerAcentos(rs.getString("med_nome")));
            return sql.toString();
        }
        return "";
    }

    public static String getCodigoExames(String fil_codigo, String req_codigo, Statement st) throws SQLException {
        StringBuffer buf = new StringBuffer("");
        buf.append("select a.exa_codigo from examerequisicao a ");
        buf.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(fil_codigo);
        buf.append(" and a.req_codigo = ");
        buf.append(req_codigo);
        buf.append(" and a.exr_excluido = false ");
        buf.append(" order by g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        StringBuffer exm = new StringBuffer("");
        while (rs.next()) {
            if (!Funcoes.textoVazio(exm.toString())) {
                exm.append(" ");
            }
            exm.append(rs.getString("exa_codigo"));
        }
        return exm.toString();
    }

    public static synchronized int getCasasDecimaisResultado(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append(" select emi_arredondarvalor ");
        query.append("   from examematinterface ");
        query.append("  where fil_codigo = ? ");
        query.append("    and exa_codigo = ? ");
        query.append("    and mco_codigo = ? ");
        query.append("    and int_codigo = ? ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ps.setInt(1, Integer.parseInt(fil_codigo));
        ps.setString(2, exa_codigo);
        ps.setInt(3, Integer.parseInt(mco_codigo));
        ps.setInt(4, Integer.parseInt(int_codigo));
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getInt("emi_arredondarvalor");
        }
        return 0;
    }

    public static String getCodigoIntegracaoHospitalRequisicao(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select req_integracaohospital from requisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs.next() && !DBUtil.campoNull(rs.getString("req_integracaohospital"))) {
            return rs.getString("req_integracaohospital");
        }
        return null;
    }

    public static synchronized ArrayList<String> getInterfacesExame(String fil_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        return BDUtil.getInterfacesExamePerformance(fil_codigo, exa_codigo, mco_codigo);
    }

    public static ArrayList<String> getInterfacesExamePerformance(String fil_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select int_codigo from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> interfaces = new ArrayList<String>();
        while (rs.next()) {
            interfaces.add(rs.getString("int_codigo"));
        }
        return interfaces;
    }

    public static synchronized void deletarExameInterface(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        BDUtil.deletarExameInterfacePerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
    }

    public static void deletarExameInterfacePerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("delete from interfaceexamerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
        query.setLength(0);
        query.append("delete from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and rec_codigo = ");
        query.append(rec_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static void cancelaExameInterface(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int sitExportado) throws SQLException {
        BDUtil.cancelaExameInterfacePerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, sitExportado);
    }

    public static void cancelaExameInterfacePerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, int sitExportado) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update interfaceexamerequisicao set ier_situacao = ");
        query.append(sitExportado);
        query.append(" where fil_codigo = ").append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and rec_codigo <> ");
        query.append(rec_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
        query.setLength(0);
        query.append("update interfaceexamerequisicaodesm set erd_situacao = ");
        query.append(sitExportado);
        query.append(" where fil_codigo = ").append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and rec_codigo <> ");
        query.append(rec_codigo);
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static synchronized String getExameDesmembradoTubo(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            query.append("select ie.rec_kodigo ");
            query.append(" from interfaceexamerequisicaodesm ie ");
            query.append(" left join requisicaorequisicao r on r.fil_codigo  = ie.fil_codigo and r.req_kodigo  = ie.req_codigo  ");
            query.append(" left join requisicaorequisicao r2 on r2.fil_codigo  = ie.fil_codigo and r2.req_codigo  = ie.req_codigo  ");
            query.append(" where ie.fil_codigo = ");
            query.append(fil_codigo);
            query.append(" and (ie.req_codigo = ").append(req_codigo).append(" or r2.req_codigo = ").append(req_codigo).append(") ");
            query.append(" and ie.rec_codigo = ").append(rec_codigo);
            query.append(" and ie.exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
            query.append(" and ie.mco_kodigo = ").append(mco_kodigo);
            if (!Funcoes.textoVazio(int_codigo)) {
                query.append(" and ie.int_codigo = ").append(int_codigo);
            }
            query.append("and (not exists (SELECT r1.req_codigo FROM requisicaorequisicao r1 WHERE r.req_codigo = ").append(req_codigo).append(") and ie.req_codigo = ").append(req_codigo).append(") or ");
            query.append(" (r.req_codigo = ").append(req_codigo).append(" or r2.req_codigo = ").append(req_codigo).append(") ");
        } else {
            query.append("select rec_kodigo from interfaceexamerequisicaodesm where fil_codigo = ");
            query.append(fil_codigo);
            query.append(" and req_codigo = ").append(req_codigo);
            query.append(" and rec_codigo = ").append(rec_codigo);
            query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
            query.append(" and mco_kodigo = ").append(mco_kodigo);
            if (!Funcoes.textoVazio(int_codigo)) {
                query.append(" and int_codigo = ").append(int_codigo);
            }
        }
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("rec_kodigo") : null;
        return retorno;
    }

    public static synchronized String getExameDesmembradoTuboPai(String fil_codigo, String req_codigo, String rec_kodigo, String int_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select rec_codigo from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and rec_kodigo = ").append(rec_kodigo);
        query.append(" and exa_codigo = ").append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ").append(mco_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        String retorno = rs != null && rs.next() ? rs.getString("rec_codigo") : null;
        return retorno;
    }

    public static Integer getTuboPai(String fil_codigo, String req_codigo, String rec_kodigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select rec_codigo from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and rec_kodigo = ").append(rec_kodigo);
        query.append(" and rec_kodigo <> rec_codigo ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        Integer retorno = rs != null && rs.next() ? Integer.valueOf(rs.getInt("rec_codigo")) : null;
        return retorno;
    }

    public static Integer getTuboFilho(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String exa_kodigo, String mco_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select rec_kodigo from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and mco_codigo = ").append(mco_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
        query.append(" and rec_codigo = ").append(rec_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        Integer retorno = rs != null && rs.next() ? Integer.valueOf(rs.getInt("rec_kodigo")) : null;
        return retorno;
    }

    public static synchronized ArrayList<String> getExameDesmembradoTubos(String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select rec_kodigo from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and rec_codigo = ").append(rec_codigo);
        query.append(" and exa_codigo = ").append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_codigo = ").append(mco_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs != null) {
            ArrayList<String> tubos = new ArrayList<String>();
            while (rs.next()) {
                tubos.add(rs.getString("rec_kodigo"));
            }
            return tubos;
        }
        return null;
    }

    public static synchronized boolean getExamePermiteValidarAutomatico(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select emi_validarresultado from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = '").append(StringUtil.textoDB(exa_codigo)).append("' ");
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = rs != null && rs.next() && rs.getBoolean("emi_validarresultado");
        ps.close();
        return retorno;
    }

    public static synchronized ArrayList<String> getExameDesmembradoTubosPorExame(String fil_codigo, String req_codigo, String rec_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select rec_kodigo from interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and rec_codigo = ").append(rec_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_codigo));
        query.append(" and mco_kodigo = ").append(mco_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        if (rs != null) {
            ArrayList<String> tubos = new ArrayList<String>();
            while (rs.next()) {
                tubos.add(rs.getString("rec_kodigo"));
            }
            return tubos;
        }
        return null;
    }

    public static synchronized boolean getExamePermiteGerarInterface(String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select coalesce(emi_bloqueado, false) as emi_bloqueado from examematinterface where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and exa_codigo = '").append(StringUtil.textoDB(exa_codigo)).append("' ");
        query.append(" and mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        boolean retorno = rs != null && rs.next() && rs.getBoolean("emi_bloqueado");
        ps.close();
        return retorno;
    }

    public static int getIdUltimoExameLancado() {
        int retorno = 0;
        try {
            PreparedStatement ps = Conexao.getPreparedStatement("select max(ers_codigo) as ers_codigo from examerequisicaosituacoes");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                retorno = rs.getInt("ers_codigo");
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public static List<Registro> getListaExamesLancado(int ers_codigo) {
        ArrayList<Registro> registros = new ArrayList<Registro>();
        int retorno = ers_codigo;
        StringBuilder query = new StringBuilder();
        query.append("select ers_codigo, fil_codigo, req_codigo, exa_codigo, mco_codigo from examerequisicaosituacoes where ers_codigo > ? and ers_situacao in(?, ?) order by ers_codigo");
        try {
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            ps.setInt(1, ers_codigo);
            ps.setString(2, "L");
            ps.setString(3, "C");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                registros.add(new Registro(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return registros;
    }

    public static String getCodigoApoioRecipiente(int fil_codigo, int req_codigo, String exa_codigo, int mco_codigo, int rec_kodigo) {
        StringBuilder query = new StringBuilder();
        query.append("select COALESCE(ere_codigoapoiado, exr_codigoapoiado) as exr_codigoapoiado from examerequisicao a ");
        query.append(" left join examerequisicaorecipiente err on a.fil_codigo = err.fil_codigo ");
        query.append("\t\t\t\t\t\t\t\t and a.req_codigo = err.req_codigo ");
        query.append("\t\t\t\t\t\t\t\t and a.exa_codigo = err.exa_codigo ");
        query.append("\t\t\t\t\t\t\t\t and a.mco_codigo = err.mco_codigo ");
        query.append(" where a.fil_codigo = ?  and a.req_codigo = ? and a.exa_codigo = ? and a.mco_codigo = ? and err.rec_kodigo = ? ");
        String codigoApoiado = "";
        try {
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            ps.setInt(1, fil_codigo);
            ps.setInt(2, req_codigo);
            ps.setString(3, exa_codigo);
            ps.setInt(4, mco_codigo);
            ps.setInt(5, rec_kodigo);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                codigoApoiado = rs.getString("exr_codigoapoiado");
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return codigoApoiado;
    }

    public static String getCodigoApoiado(int fil_codigo, int req_codigo, String exa_codigo, int mco_codigo) {
        StringBuilder query = new StringBuilder();
        query.append("select exr_codigoapoiado from examerequisicao where fil_codigo = ?  and req_codigo = ? and exa_codigo = ? and mco_codigo = ?");
        String codigoApoiado = "";
        try {
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            ps.setInt(1, fil_codigo);
            ps.setInt(2, req_codigo);
            ps.setString(3, exa_codigo);
            ps.setInt(4, mco_codigo);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                codigoApoiado = rs.getString("exr_codigoapoiado");
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return codigoApoiado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getCodigoJalis(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String exa_codigo, String mco_codigo) {
        Statement st;
        String[] codigoJalis;
        block8: {
            String sql2;
            String sql1;
            String codigoApoiado;
            block7: {
                codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
                codigoJalis = new String[3];
                StringBuilder buf = new StringBuilder();
                buf.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo from examerequisicao a ");
                buf.append(" join interfaceexamerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and b.int_codigo = ").append(int_codigo);
                buf.append(" where a.exr_codigoapoiado = '").append(codigoApoiado).append("'");
                sql1 = buf.toString();
                buf.setLength(0);
                buf.append("select a.fil_codigo, a.req_codigo, a.rec_kodigo from examerequisicaorecipiente a ");
                buf.append(" join interfaceexamerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and b.int_codigo = ").append(int_codigo);
                sql2 = buf.toString();
                st = Conexao.getStatement();
                if (DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado")) break block7;
                String[] stringArray = null;
                Conexao.fecharStatement(st);
                return stringArray;
            }
            try {
                ResultSet rs2;
                ResultSet rs = st.executeQuery(sql1);
                if (rs.next()) {
                    StringBuilder buf2 = new StringBuilder(sql2.toString());
                    buf2.append(" where a.fil_codigo = ").append(rs.getString("fil_codigo"));
                    buf2.append(" and a.req_codigo = ").append(rs.getString("req_codigo"));
                    buf2.append(" and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("'");
                    buf2.append(" and a.mco_codigo = ").append(rs.getString("mco_codigo"));
                    rs2 = st.executeQuery(buf2.toString());
                } else {
                    StringBuilder buf2 = new StringBuilder(sql2.toString());
                    buf2.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                    buf2.append(" and a.ere_codigoapoiado = '").append(codigoApoiado).append("'");
                    rs2 = st.executeQuery(buf2.toString());
                }
                if (rs2 == null || !rs2.next()) break block8;
                codigoJalis[0] = Funcoes.preencheZero(rs2.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                codigoJalis[1] = Funcoes.preencheZero(rs2.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                codigoJalis[2] = Funcoes.preencheZero(rs2.getString("rec_kodigo"), ParametrosGerais.getDigitosTuboTubo());
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter dados dos exames.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return codigoJalis;
    }

    public static synchronized ArrayList<Registro> getResultadoExameRequisicaoJalis(String fil_codigo, String req_codigo, String exa_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado from examerequisicao where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = ");
        query.append(DBUtil.bdText(exa_codigo));
        query.append(" and exr_situacao in ('").append("I").append("', '").append("C").append("', '").append("E").append("')");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<Registro> registros = null;
        if (rs.next()) {
            registros = new ArrayList<Registro>();
            do {
                registros.add(new Registro(rs));
            } while (rs.next());
        }
        ps.close();
        return registros;
    }

    public static ExameMaterial[] getExameMaterialRecipiente(String fil_codigo, String req_codigo, String rec_kodigo, String int_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_kodigo, mco_kodigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ").append(fil_codigo);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and rec_kodigo = ");
        query.append(rec_kodigo);
        query.append(" order by exa_kodigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_kodigo"), rs.getInt("mco_kodigo"));
        }
        ps.close();
        return pais;
    }

    public static ExameRequisicaoDadosBrutosBean[] getDadosBrutosRequisicao(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo) throws SQLException {
        ArrayList<ExameRequisicaoDadosBrutosBean> retorno = new ArrayList<ExameRequisicaoDadosBrutosBean>();
        StringBuilder buf = new StringBuilder("select e.eda_datahora, e.usr_codigo, e.eda_dadosbrutos ");
        buf.append("from examerequisicaodadosbrutos e ");
        buf.append(" left join examerequisicao a on e.fil_codigo = a.fil_codigo and e.req_codigo = a.req_codigo and e.exa_codigo = a.exa_codigo and e.mco_codigo = a.mco_codigo ");
        buf.append("where ");
        buf.append("  e.fil_codigo = ").append(fil_codigo);
        buf.append(" and e.req_codigo = ").append(req_codigo);
        buf.append(" and e.exa_codigo = ").append(StringUtil.textoDBEscape(exa_codigo));
        buf.append(" and e.mco_codigo = ").append(mco_codigo);
        buf.append(" and a.exr_excluido = false ");
        PreparedStatement ps = Conexao.getPreparedStatement(buf.toString());
        ResultSet rs = ps.executeQuery();
        while (rs != null && rs.next()) {
            ExameRequisicaoDadosBrutosBean b = new ExameRequisicaoDadosBrutosBean();
            UsuarioVO u = new UsuarioVO();
            u.setCodigo(rs.getString("usr_codigo"));
            b.setDataHora(rs.getTimestamp("eda_datahora"));
            b.setUsuario(u);
            b.setDadosBrutos(rs.getString("eda_dadosbrutos"));
            retorno.add(b);
        }
        ps.close();
        Conexao.fecharStatement(ps);
        return retorno.size() == 0 ? null : retorno.toArray(new ExameRequisicaoDadosBrutosBean[retorno.size()]);
    }

    public static boolean getTodosFilhosConferidos(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exame, String mco_codigo, String rec_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder("select e.erd_situacao ");
        buf.append("from interfaceexamerequisicaodesm e ");
        buf.append("where ");
        buf.append("  e.fil_codigo = ").append(fil_codigo);
        buf.append(" and e.req_codigo = ").append(req_codigo);
        buf.append(" and e.exa_codigo = ").append(StringUtil.textoDBEscape(exame));
        buf.append(" and e.mco_codigo = ").append(mco_codigo);
        buf.append(" and e.int_codigo = ").append(int_codigo);
        PreparedStatement ps = Conexao.getPreparedStatement(buf.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (rs.getInt("erd_situacao") >= 1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNomeDestino(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder consulta = new StringBuilder();
        consulta.append("select d.des_descricao ");
        consulta.append("from requisicao r ");
        consulta.append("left join destino d on r.des_codigo = d.des_codigo and r.fil_codigo = d.fil_codigo ");
        consulta.append("where r.fil_codigo = ").append(fil_codigo);
        consulta.append("and r.req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, consulta.toString());
        String retorno = null;
        try {
            if (rs.next()) {
                retorno = rs.getString("des_descricao");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }
}

