/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.status;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.TravaFechamento;
import jalis.laboratorio.interfaceamento.comunicacao.arquivo.ArquivoException;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoException;
import jalis.laboratorio.interfaceamento.comunicacao.log.LogInterfaceamentoService;
import jalis.laboratorio.interfaceamento.status.StatusExportacao;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.JalisPropertiesService;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class StatusFecharInterfaceamento
extends JPanel {
    JButton botao_fechar = new JButton(ImagemUtils.carregaImagemJalis("fechar_interfac.gif"));
    private boolean mostrarMensagem = true;
    private StatusExportacao statusExportacao = null;
    private List<TravaFechamento> travasFechamento;
    private LogInterfaceamentoService service = new LogInterfaceamentoService();

    public StatusFecharInterfaceamento() {
        this.travasFechamento = new ArrayList<TravaFechamento>();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "StatusFecharInterfaceamento");
        }
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(28, 28));
        this.setMinimumSize(new Dimension(28, 28));
        this.setSize(new Dimension(28, 28));
        this.setLayout(new BorderLayout());
        this.add((Component)this.botao_fechar, "Center");
        this.botao_fechar.setFocusable(false);
        this.botao_fechar.setMnemonic('X');
        this.botao_fechar.setToolTipText("Retorna ao Jalis");
        this.botao_fechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resposta;
                if (StatusFecharInterfaceamento.this.statusExportacao != null && StatusFecharInterfaceamento.this.statusExportacao.isExecutando()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Existem exames sendo exportados! \u00c9 preciso aguardar o t\u00e9rmino antes de fechar o interfaceamento!", 5);
                    return;
                }
                String message = "Deseja ocultar ou fechar o interfaceamento?\nOcultar - Oculta tela do interfaceamento, e os dados CONTINUAR\u00c3O a serem transmitidos.\nFechar  - Fecha a tela do interfaceamento, e TODOS OS DADOS QUE SER\u00c3O TRANSMITIDOS SER\u00c3O PERDIDOS!";
                int n = resposta = StatusFecharInterfaceamento.this.mostrarMensagem ? Funcoes.showPerguntaOpcoes(Laboratorio.getInstancia(), message, new String[]{"Ocultar", "Fechar", "Cancelar"}, new char[]{'O', 'F', 'C'}) : 1;
                if (resposta == 1 && !StatusFecharInterfaceamento.this.travasFechamento.isEmpty()) {
                    StringBuilder mensagem = new StringBuilder();
                    mensagem.append("O interfaceamento n\u00e3o pode ser fechado no momento pelo(s) seguinte(s) motivo(s):");
                    mensagem.append("\n");
                    for (TravaFechamento trava : StatusFecharInterfaceamento.this.travasFechamento) {
                        mensagem.append("\n").append("- ").append(trava.getDescricao());
                    }
                    Funcoes.showAlertaOK(Laboratorio.getInstancia(), mensagem.toString());
                    return;
                }
                if (resposta < 2) {
                    if (resposta == 1 && Variaveis.equip.getStatusAutoEnvio() != null) {
                        if (!Variaveis.equip.getStatusAutoEnvio().isRunning()) {
                            if (ParametrosLocais.getParametro("envioAutomaticoExameInterfaceamento") == null) {
                                if (Funcoes.mensagem(Variaveis.equip, "Envio autom\u00e1tico foi desativado!\nDeseja iniciar desabilitado?", 4) == 0) {
                                    ParametrosLocais.setParametro("envioAutomaticoExameInterfaceamento", "0");
                                } else {
                                    ParametrosLocais.setParametro("envioAutomaticoExameInterfaceamento", "1");
                                }
                            } else {
                                ParametrosLocais.setParametro("envioAutomaticoExameInterfaceamento", "0");
                            }
                        } else {
                            ParametrosLocais.setParametro("envioAutomaticoExameInterfaceamento", "1");
                        }
                        ParametrosLocais.salvaParametros();
                    }
                    if (Variaveis.equip != null) {
                        Variaveis.equip.setVisible(false);
                    }
                    if (resposta == 0) {
                        Variaveis.equip.escreverLog("Ocultou", new Date());
                        Laboratorio.setIconeInterfaceamento(AbstractInterfaceamento.imagemInterfaceamentoAberto);
                    } else if (resposta == 1) {
                        this.salvarArquivo();
                        Laboratorio.setIconeInterfaceamento(null);
                        Variaveis.equip.encerrar();
                        Variaveis.equip = null;
                    }
                }
            }

            private void salvarArquivo() {
                try {
                    StatusFecharInterfaceamento.this.service.salvarArquivo(Integer.valueOf(Variaveis.filialPadrao), this.getCodigoInterface());
                }
                catch (LogInterfaceamentoException | NumberFormatException e) {
                    ErrorLogger.mostraMensagem(StatusFecharInterfaceamento.this, e.getMessage(), e.getStackTrace());
                }
            }

            private Integer[] getCodigoInterface() {
                try {
                    return JalisPropertiesService.getCodigoInterfaceamento();
                }
                catch (ArquivoException e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                    return null;
                }
            }
        });
    }

    public void doClick(boolean mostrarMensagem) {
        this.mostrarMensagem = mostrarMensagem;
        this.botao_fechar.doClick();
    }

    public void addTravaFechamento(TravaFechamento trava) {
        this.travasFechamento.add(trava);
    }

    public void removeTravaFechamento(TravaFechamento trava) {
        this.travasFechamento.remove(trava);
    }

    public void setStatusExportacao(StatusExportacao statusExportacao) {
        this.statusExportacao = statusExportacao;
    }

    public boolean isExportando() {
        return this.statusExportacao.isExecutando();
    }
}

