/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.status;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacao;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacaoWebIntegracao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.util.Funcoes;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusExportacao
extends JPanel
implements ActionListener {
    protected JLabel labelContador = new JLabel(" ");
    protected JButton buttonCancelar = new BotaoNavegavel("Cancelar");
    protected AbstractInterfaceamento equipamento;
    protected ArrayList<String> colunasVisiveis;
    protected ArrayList<String> colunasOcultas;
    protected ThreadExportacao threadExportacao;
    protected boolean executando = false;

    public StatusExportacao(AbstractInterfaceamento equipamento, ArrayList<String> colunasVisiveis, ArrayList<String> colunasOcultas) {
        this.equipamento = equipamento;
        this.colunasVisiveis = colunasVisiveis;
        this.colunasOcultas = colunasOcultas;
        this.setBorder(ComponenteFactory.novoTitledEtchedBorder("Exporta\u00e7\u00e3o"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelContador, "West");
        this.buttonCancelar.setMargin(new Insets(2, 2, 2, 2));
        this.add((Component)this.buttonCancelar, "East");
        this.buttonCancelar.setEnabled(false);
        this.buttonCancelar.addActionListener(this);
        this.threadExportacao = new ThreadExportacao(this.labelContador, 100, Conexao.getStatement());
    }

    public void addExames(ArrayList<Object[]> exames) {
        ConcurrentLinkedQueue<Object[]> list = new ConcurrentLinkedQueue<Object[]>();
        list.addAll(exames);
        this.threadExportacao.addExames(list);
    }

    public void restart() {
        if (this.threadExportacao != null && !this.threadExportacao.isInterrupted() && this.threadExportacao.isAlive()) {
            return;
        }
        this.buttonCancelar.setEnabled(true);
        if (this.threadExportacao != null && !this.threadExportacao.isAlive()) {
            ConcurrentLinkedQueue exames = this.threadExportacao.exames;
            if (this.threadExportacao != null) {
                try {
                    this.threadExportacao.cancelar();
                    this.threadExportacao.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.threadExportacao = new ThreadExportacao(this.labelContador, 100, Conexao.getStatement());
            this.threadExportacao.addExames(exames);
        }
        if (this.threadExportacao != null) {
            this.threadExportacao.start();
        }
    }

    public int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        }
    }

    private void cancelar() {
        this.threadExportacao.cancelar();
        ThreadInterfaceExportacao.stopThread();
        ThreadInterfaceExportacaoWebIntegracao.stopThread();
        Conexao.setSessaoConexao(false);
        this.limpar();
        if (this.equipamento.getAbaProntos() instanceof AbaDefaultProntos) {
            ((AbaDefaultProntos)this.equipamento.getAbaProntos()).carregaExames();
        }
    }

    public boolean isVerificaExameExportando(String codigoReq, String codigoInt, String codigoExa, String codigoMco, String codigoRec) {
        return this.threadExportacao.isVerificaExameExportando(codigoReq, codigoInt, codigoExa, codigoMco, codigoRec);
    }

    protected void limpar() {
        this.buttonCancelar.setEnabled(false);
        this.labelContador.setText(" ");
    }

    public boolean isExecutando() {
        return this.executando;
    }

    protected class ThreadExportacao
    extends Thread {
        private JLabel labelContador;
        private int time;
        private ConcurrentLinkedQueue<Object[]> exames;
        private Set<Object[]> examesControle;
        private Set<Object[]> examesNaoExportados;
        private int col_req;
        private int col_int;
        private int col_exa;
        private int col_mco;
        private int col_rec;
        private int col_pac;
        private int col_sex;
        private int colMetodo;
        private int codigo_paciente;
        private int usr_codigo;
        private String usuario;
        private int totalExames;
        private boolean cancelar;
        private Statement st;

        public ThreadExportacao(JLabel labelContador, int time, Statement st) {
            super("Thread Exportacao Interface");
            this.exames = new ConcurrentLinkedQueue();
            this.examesControle = new HashSet<Object[]>();
            this.examesNaoExportados = new HashSet<Object[]>();
            this.totalExames = 0;
            this.cancelar = false;
            this.st = null;
            this.labelContador = labelContador;
            this.setPriority(1);
            this.time = time;
            this.st = st;
        }

        public void addExames(ConcurrentLinkedQueue<Object[]> exames) {
            this.exames.addAll(exames);
            this.examesControle.addAll(exames);
            this.totalExames += exames.size();
        }

        public void addExame(Object[] exame) {
            this.exames.add(exame);
            ++this.totalExames;
        }

        public void cancelar() {
            this.cancelar = true;
            this.totalExames = 0;
            this.examesControle.clear();
            Conexao.setSessaoConexao(false);
            ThreadInterfaceExportacao.stopThread();
            ThreadInterfaceExportacaoWebIntegracao.stopThread();
        }

        public boolean isVerificaExameExportando(String codigoReq, String codigoInt, String codigoExa, String codigoMco, String codigoRec) {
            if (this.examesControle != null) {
                boolean isAgruparGuiasInterface = ParametrosGerais.isAgruparGuiasInterface();
                for (Object[] obj : this.examesControle) {
                    String reqCodigo = (String)obj[this.col_req];
                    String intCodigo = (String)obj[this.col_int];
                    String exaCodigo = (String)obj[this.col_exa];
                    String mcoCodigo = (String)obj[this.col_mco];
                    String recCodigo = (String)obj[this.col_rec];
                    if (isAgruparGuiasInterface) {
                        reqCodigo = (String)obj[StatusExportacao.this.getColIndice("C\u00f3digo Temp.")];
                    }
                    if (!codigoReq.equals(reqCodigo) || !codigoInt.equals(intCodigo) || !codigoExa.equals(exaCodigo) || !codigoMco.equals(mcoCodigo) || !codigoRec.equals(recCodigo)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Conexao.setSessaoConexao(true);
            StatusExportacao.this.executando = true;
            String temp = "";
            try {
                this.col_req = StatusExportacao.this.getColIndice("C\u00f3digo");
                this.col_int = StatusExportacao.this.getColIndice("Interface");
                this.col_exa = StatusExportacao.this.getColIndice("Exame");
                this.col_mco = StatusExportacao.this.getColIndice("C\u00f3d. Mat.");
                this.col_rec = StatusExportacao.this.getColIndice("Tubo");
                this.col_pac = StatusExportacao.this.getColIndice("Paciente");
                this.col_sex = StatusExportacao.this.getColIndice("S");
                this.colMetodo = StatusExportacao.this.getColIndice("Cod. M\u00e9todo");
                this.codigo_paciente = StatusExportacao.this.getColIndice("Cod. Paciente");
                this.usr_codigo = StatusExportacao.this.getColIndice("Usu\u00e1rio");
                boolean isAgruparGuiasInterface = ParametrosGerais.isAgruparGuiasInterface();
                int digitosTuboFilial = ParametrosGerais.getDigitosTuboFilial();
                AbaDefaultProntos abaProntos2 = (AbaDefaultProntos)StatusExportacao.this.equipamento.getAbaProntos();
                Timer timer = new Timer("Timer atualiza\u00e7\u00e3o exportados interface", true);
                timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        if (!ThreadExportacao.this.cancelar) {
                            ThreadExportacao.this.labelContador.setText(String.format("Exportando %s de %s ", Integer.toString(ThreadInterfaceExportacao.getQtdeSendoExportada()), Integer.toString(ThreadExportacao.this.totalExames)));
                        }
                    }
                }, this.time, (long)this.time);
                Iterator<Object[]> i = this.exames.iterator();
                while (i.hasNext() && !this.cancelar) {
                    Object[] exame = i.next();
                    String requisicao = (String)exame[this.col_req];
                    this.usuario = !Funcoes.textoVazio((String)exame[this.usr_codigo]) ? (String)exame[this.usr_codigo] : Variaveis.login;
                    if (isAgruparGuiasInterface) {
                        requisicao = (String)exame[StatusExportacao.this.getColIndice("C\u00f3digo Temp.")];
                    }
                    String filial = requisicao.substring(0, digitosTuboFilial);
                    requisicao = requisicao.substring(digitosTuboFilial);
                    temp = "Filial: " + filial + ", requisicao: " + requisicao + ", exame: " + exame[this.col_exa].toString();
                    abaProntos2.exportaExame(true, requisicao, (String)exame[this.col_pac], (String)exame[this.col_sex], (String)exame[this.col_exa], (String)exame[this.col_mco], (String)exame[this.col_rec], (String)exame[this.col_int], true, filial, this.usuario, this.st, (String)exame[this.colMetodo], true, exame, (String)exame[this.codigo_paciente]);
                    ThreadExportacao.sleep(100L);
                    this.examesNaoExportados.addAll(ThreadInterfaceExportacao.getExamesNaoExportados());
                    if (null != i) {
                        i.remove();
                    }
                    exame = null;
                }
                ArrayList<Object[]> objects = new ArrayList<Object[]>();
                while (!ThreadInterfaceExportacao.exportandoLogs() || !this.examesNaoExportados.isEmpty()) {
                    if (!ThreadInterfaceExportacao.exportandoLogs() || !ThreadInterfaceExportacaoWebIntegracao.exportandoLogs()) {
                        this.labelContador.setText(String.format("Exportando %s de %s ", Integer.toString(ThreadInterfaceExportacao.getQtdeSendoExportada()), Integer.toString(this.totalExames)));
                    }
                    if (!(StatusExportacao.this.equipamento.getAbaProntos() instanceof AbaDefaultProntos) || this.examesNaoExportados.isEmpty()) continue;
                    Iterator<Object[]> it = this.examesNaoExportados.iterator();
                    while (it.hasNext()) {
                        objects.add(it.next());
                        it.remove();
                    }
                }
                Conexao.arquivaSQL();
                ((AbaDefaultProntos)StatusExportacao.this.equipamento.getAbaProntos()).voltaExamesNaoExportados(objects);
                if (!this.examesNaoExportados.isEmpty()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Nem todos os resultados foram exportados.\nVerifique a aba exce\u00e7\u00f5es.", 2);
                }
                this.exames = new ConcurrentLinkedQueue();
                this.examesControle.clear();
                StatusExportacao.this.limpar();
                timer.cancel();
            }
            catch (InterruptedException ex) {
                this.exames.clear();
                this.examesControle.clear();
                try {
                    Conexao.anulaSQL();
                    this.cancelar();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage() + (temp.trim().length() > 0 ? "\n" + temp : ""), ex.getStackTrace(), "StatusExportacao: 143 " + (temp.trim().length() > 0 ? "\n" + temp : ""));
                Funcoes.showErro(null, "A exporta\u00e7\u00e3o de exames ser\u00e1 encerrada.");
            }
            catch (Exception ex) {
                this.exames.clear();
                this.examesControle.clear();
                try {
                    Conexao.anulaSQL();
                    this.cancelar();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage() + (temp.trim().length() > 0 ? "\n" + temp : ""), ex.getStackTrace(), "StatusExportacao: 153 " + (temp.trim().length() > 0 ? "\n" + temp : ""));
                Funcoes.showErro(null, "A exporta\u00e7\u00e3o de exames ser\u00e1 encerrada.");
            }
            finally {
                StatusExportacao.this.executando = false;
                Conexao.setSessaoConexao(false);
            }
        }
    }
}

