/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.status;

import jalis.comum.Acesso;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class StatusAutoImportador
extends JPanel {
    static final long ALTERAR_AUTO_IMPORTADOR = 1001005001L;
    static final String TEMPO_INTERVALO = "auto_import_time";
    static final int TEMPO_DEFAULT = 30;
    protected final String MENSAGEM_LIGADO = "<html>Tempo restante para a pr\u00f3xima importa\u00e7\u00e3o<br>Clique para desabilitar auto-importador</html>";
    protected final String MENSAGEM_DESLIGADO = "<html>Clique para re-iniciar auto-importador</html>";
    protected JProgressBar progressBar;
    protected int tempo;
    protected AbstractInterfaceamento equipamento;
    protected ThreadImport timer;
    protected JPopupMenu popup_menu = new JPopupMenu("Auto-Importador");
    protected JMenuItem menu_start = new JMenuItem("Iniciar");
    protected JMenuItem menu_restart = new JMenuItem("Re-iniciar");
    protected JMenuItem menu_stop = new JMenuItem("Parar");
    protected JMenuItem menu_config = new JMenuItem("Configurar tempo");

    public StatusAutoImportador(AbstractInterfaceamento equipamento) {
        super(new BorderLayout());
        try {
            this.equipamento = equipamento;
            this.jbInit();
            this.loadValorTempo();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "StatusAutoImportador");
        }
    }

    public void jbInit() {
        this.popup_menu.add(this.menu_start);
        this.popup_menu.add(this.menu_restart);
        this.popup_menu.add(this.menu_stop);
        this.popup_menu.add(this.menu_config);
        this.progressBar = new JProgressBar(0, this.tempo);
        this.progressBar.setMinimumSize(new Dimension(80, 15));
        this.progressBar.setStringPainted(true);
        this.progressBar.setFont(new Font("Sans", 0, 10));
        this.progressBar.setString(this.tempo + " seg.");
        this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progressBar.setToolTipText("<html>Tempo restante para a pr\u00f3xima importa\u00e7\u00e3o<br>Clique para desabilitar auto-importador</html>");
        this.add((Component)this.progressBar, "Center");
        this.progressBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && Acesso.getAcesso(1001005001L)) {
                    if (StatusAutoImportador.this.isRunning()) {
                        StatusAutoImportador.this.stop();
                    } else {
                        StatusAutoImportador.this.restart();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && e.isPopupTrigger() && Acesso.getAcesso(1001005001L)) {
                    StatusAutoImportador.this.popup_menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && e.isPopupTrigger() && Acesso.getAcesso(1001005001L)) {
                    StatusAutoImportador.this.popup_menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusAutoImportador.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusAutoImportador.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.menu_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoImportador.this.start();
            }
        });
        this.menu_restart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoImportador.this.restart();
            }
        });
        this.menu_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoImportador.this.stop();
            }
        });
        this.menu_config.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoImportador.this.config();
            }
        });
    }

    private void loadValorTempo() {
        String configurado = ParametrosLocais.getParametro(TEMPO_INTERVALO);
        try {
            this.tempo = Integer.parseInt(configurado);
        }
        catch (Exception ex) {
            this.tempo = 30;
            this.saveValorTempo();
            ParametrosLocais.salvaParametros();
        }
        this.restart();
    }

    public void saveValorTempo() {
        String novo_tempo = String.valueOf(this.tempo);
        ParametrosLocais.setParametro(TEMPO_INTERVALO, novo_tempo);
        ParametrosLocais.salvaParametros();
    }

    public boolean isRunning() {
        return this.timer != null && !this.timer.isInterrupted() && this.timer.isAlive();
    }

    public void start() {
        this.progressBar.setToolTipText("<html>Tempo restante para a pr\u00f3xima importa\u00e7\u00e3o<br>Clique para desabilitar auto-importador</html>");
        if (this.isRunning()) {
            return;
        }
        this.progressBar.setString(new StringBuilder(this.tempo).append(" seg.").toString());
        this.progressBar.setEnabled(true);
        this.menu_start.setEnabled(false);
        this.menu_restart.setEnabled(true);
        this.menu_stop.setEnabled(true);
        this.progressBar.setMaximum(this.tempo);
        this.progressBar.setMinimum(0);
        this.timer = new ThreadImport(this.tempo, BDUtil.getIdUltimoExameLancado());
        this.timer.start();
    }

    public void restart() {
        if (this.isRunning()) {
            this.timer.interrupt();
        }
        this.start();
    }

    public void stop() {
        if (this.isRunning()) {
            this.timer.interrupt();
        }
        this.progressBar.setValue(0);
        this.progressBar.setString("Desabilitado");
        this.progressBar.setEnabled(false);
        this.progressBar.setToolTipText("<html>Clique para re-iniciar auto-importador</html>");
        this.menu_start.setEnabled(true);
        this.menu_restart.setEnabled(false);
        this.menu_stop.setEnabled(false);
    }

    public void config() {
        String digitado;
        ConfigAutoImportacao dlg = new ConfigAutoImportacao(this.tempo);
        DialogUtil.centerAndShow(dlg, true, false);
        if (dlg.getFechouOK() && !(digitado = dlg.getValorDigitado()).equals(String.valueOf(this.tempo))) {
            this.tempo = Integer.parseInt(digitado);
            this.saveValorTempo();
            this.restart();
        }
    }

    private class ConfigAutoImportacao
    extends JDialog {
        String atual;
        JPanel panel;
        JLabel label;
        JTextField field;
        JPanel buttons;
        JButton button_ok;
        JButton button_cancel;
        boolean fechou_ok;

        protected ConfigAutoImportacao(int tempo) {
            super((Frame)((JFrame)StatusAutoImportador.this.getTopLevelAncestor()), "Configura\u00e7\u00e3o de Intervalo");
            this.panel = (JPanel)this.getContentPane();
            this.label = new JLabel("Novo tempo [5 - 999] seg.");
            this.field = new TTextField(3, 1);
            this.buttons = new JPanel(new FlowLayout(2));
            this.button_ok = new BotaoNavegavel("OK", 'O');
            this.button_cancel = new BotaoNavegavel("Cancelar", 'C');
            this.fechou_ok = false;
            try {
                this.atual = String.valueOf(tempo);
                this.jbInit();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConfigAutoImportacao");
            }
        }

        public void jbInit() {
            this.setPreferredSize(new Dimension(230, 85));
            this.setSize(new Dimension(230, 85));
            this.setResizable(false);
            this.field.setHorizontalAlignment(0);
            this.panel.setLayout(new GridBagLayout());
            this.buttons.add(this.button_ok);
            this.buttons.add(this.button_cancel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.insets = new Insets(9, 9, 5, 5);
            this.panel.add((Component)this.label, c);
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 0;
            c.insets = new Insets(9, 0, 5, 9);
            this.panel.add((Component)this.field, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = new Insets(0, 0, 5, 0);
            this.panel.add((Component)this.buttons, c);
            this.field.setPreferredSize(new Dimension(30, 17));
            this.field.setMinimumSize(new Dimension(30, 17));
            this.button_ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int valor = Integer.parseInt(ConfigAutoImportacao.this.field.getText());
                    if (valor >= 5 && valor <= 999) {
                        ConfigAutoImportacao.this.fechou_ok = true;
                        ConfigAutoImportacao.this.dispose();
                    } else {
                        Funcoes.showAlertaOK(null, "Valor deve estar entre 5 e 999 segundos.");
                        ConfigAutoImportacao.this.field.grabFocus();
                    }
                }
            });
            this.button_cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigAutoImportacao.this.dispose();
                }
            });
        }

        public boolean getFechouOK() {
            return this.fechou_ok;
        }

        public String getValorDigitado() {
            return this.field.getText();
        }
    }

    protected class ThreadImport
    extends Thread {
        private int time;
        private int sequence = 0;

        public ThreadImport(int time, int sequence) {
            this.setPriority(1);
            this.time = time;
            this.sequence = sequence;
        }

        @Override
        public void run() {
            try {
                block3: while (true) {
                    if (StatusAutoImportador.this.equipamento != null && StatusAutoImportador.this.equipamento.isAutoImportador()) {
                        StatusAutoImportador.this.equipamento.refresh(0);
                        StatusAutoImportador.this.equipamento.refresh(1);
                        if (StatusAutoImportador.this.equipamento.configuracao.getAtualizarAbaProntosAutomaticamente()) {
                            StatusAutoImportador.this.equipamento.refresh(2);
                        }
                    } else if (StatusAutoImportador.this.equipamento != null && StatusAutoImportador.this.equipamento.getAutoEnvio() != null && (StatusAutoImportador.this.equipamento.getAutoEnvio().isRunning() || StatusAutoImportador.this.equipamento.getAutoEnvio().isRunning() && StatusAutoImportador.this.equipamento.getAbaNaoEnviados().getRowCount() == 0)) {
                        StatusAutoImportador.this.equipamento.refresh(0);
                    }
                    if (StatusAutoImportador.this.equipamento.getSelectedTab() instanceof AbaDefaultProntos) {
                        this.sequence = ((AbaDefaultProntos)StatusAutoImportador.this.equipamento.getSelectedTab()).verificaLancados(this.sequence);
                    }
                    int i = this.time;
                    while (true) {
                        if (i < 0) continue block3;
                        StatusAutoImportador.this.progressBar.setString(i == 0 ? "" : i + " seg.");
                        StatusAutoImportador.this.progressBar.setValue(StatusAutoImportador.this.tempo - i);
                        ThreadImport.sleep(1000L);
                        --i;
                    }
                    break;
                }
            }
            catch (InterruptedException i) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O importador autom\u00e1tico de exames ser\u00e1 encerrado.", ex.getStackTrace(), "StatusAutoImportador");
            }
        }
    }
}

