/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.status;

import jalis.comum.Acesso;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ListenerAcaoTransfereFoco;
import jalis.util.componentes.ListenerComponenteSetasNavegacao;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class StatusAutoEnvio
extends JPanel {
    static final long ALTERAR_AUTO_ENVIO = 1001004001L;
    static final String TEMPO_INTERVALO = "auto_tx_time";
    static final int TEMPO_DEFAULT = 1000;
    protected final String MENSAGEM_LIGADO = "<html>Clique para desabilitar auto-envio para o equipamento</html>";
    protected final String MENSAGEM_DESLIGADO = "<html>Clique para re-iniciar auto-envio para o equipamento</html>";
    protected final ImageIcon ICON_ON = ImagemUtils.carregaImagemJalis("auto_envio_on.png");
    protected final ImageIcon ICON_OFF = ImagemUtils.carregaImagemJalis("auto_envio_off.png");
    protected JLabel label;
    protected int tempo;
    protected AbstractInterfaceamento equipamento;
    protected ThreadEnvio timer;
    protected JPopupMenu popup_menu = new JPopupMenu("Auto-Envio");
    protected JMenuItem menu_start = new JMenuItem("Iniciar");
    protected JMenuItem menu_stop = new JMenuItem("Parar");
    protected JMenuItem menu_config = new JMenuItem("Configurar tempo");

    public StatusAutoEnvio(AbstractInterfaceamento equip) {
        super(new BorderLayout());
        try {
            this.equipamento = equip;
            this.jbInit();
            this.loadValorTempo();
            this.stop();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "StatusAutoEnvio");
        }
    }

    public void jbInit() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel();
        this.add((Component)this.label, "Center");
        this.setMinimumSize(new Dimension(20, 15));
        this.setSize(new Dimension(20, 15));
        this.setPreferredSize(new Dimension(20, 15));
        this.popup_menu.add(this.menu_start);
        this.popup_menu.add(this.menu_stop);
        this.popup_menu.add(this.menu_config);
        this.label.setHorizontalAlignment(0);
        this.label.setFont(new Font("Sans", 0, 9));
        this.label.setIcon(this.ICON_ON);
        this.label.setBorder(BorderFactory.createLoweredBevelBorder());
        this.label.setToolTipText("<html>Clique para desabilitar auto-envio para o equipamento</html>");
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && Acesso.getAcesso(1001004001L)) {
                    if (StatusAutoEnvio.this.isRunning()) {
                        StatusAutoEnvio.this.stop();
                    } else {
                        StatusAutoEnvio.this.restart();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && e.isPopupTrigger() && Acesso.getAcesso(1001004001L)) {
                    StatusAutoEnvio.this.popup_menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && e.isPopupTrigger() && Acesso.getAcesso(1001004001L)) {
                    StatusAutoEnvio.this.popup_menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusAutoEnvio.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusAutoEnvio.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.menu_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoEnvio.this.start();
            }
        });
        this.menu_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoEnvio.this.stop();
            }
        });
        this.menu_config.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusAutoEnvio.this.config();
            }
        });
    }

    private void loadValorTempo() {
        String configurado = ParametrosLocais.getParametro(TEMPO_INTERVALO);
        try {
            this.tempo = Integer.parseInt(configurado);
        }
        catch (Exception ex) {
            this.tempo = 1000;
            this.saveValorTempo();
            ParametrosLocais.salvaParametros();
        }
        if (this.isRunning()) {
            this.restart();
        }
    }

    public void saveValorTempo() {
        String novo_tempo = String.valueOf(this.tempo);
        ParametrosLocais.setParametro(TEMPO_INTERVALO, novo_tempo);
        ParametrosLocais.salvaParametros();
    }

    public boolean isRunning() {
        return this.timer != null && !this.timer.isInterrupted() && this.timer.isAlive();
    }

    public void start() {
        this.label.setToolTipText("<html>Clique para desabilitar auto-envio para o equipamento</html>");
        if (this.isRunning()) {
            return;
        }
        this.label.setIcon(this.ICON_ON);
        this.menu_stop.setEnabled(true);
        this.timer = new ThreadEnvio(this.tempo);
        this.timer.start();
    }

    public void restart() {
        if (this.isRunning()) {
            this.timer.interrupt();
        }
        this.start();
    }

    public void stop() {
        if (this.isRunning()) {
            this.timer.interrupt();
        }
        this.label.setIcon(this.ICON_OFF);
        this.label.setToolTipText("<html>Clique para re-iniciar auto-envio para o equipamento</html>");
        this.equipamento.getAutoImport().start();
        this.menu_start.setEnabled(true);
        this.menu_stop.setEnabled(false);
    }

    public void config() {
        String digitado;
        ConfigAutoEnvio dlg = new ConfigAutoEnvio(this.tempo);
        DialogUtil.centerAndShow(dlg, true, false);
        if (dlg.getFechouOK() && !(digitado = dlg.getValorDigitado()).equals(String.valueOf(this.tempo))) {
            this.tempo = Integer.parseInt(digitado);
            this.saveValorTempo();
            this.restart();
        }
    }

    private class ConfigAutoEnvio
    extends JDialog {
        String atual;
        JPanel panel;
        JLabel label;
        JTextField field;
        JPanel buttons;
        JButton button_ok;
        JButton button_cancel;
        boolean fechou_ok;

        protected ConfigAutoEnvio(int tempo) {
            super((Frame)((JFrame)StatusAutoEnvio.this.getTopLevelAncestor()), "Configura\u00e7\u00e3o de Intervalo");
            this.panel = (JPanel)this.getContentPane();
            this.label = new JLabel("Novo tempo [100 - 9999] milissegundos");
            this.field = new TTextField(4, 1);
            this.buttons = new JPanel(new FlowLayout(2));
            this.button_ok = new BotaoNavegavel("OK", 'O');
            this.button_cancel = new BotaoNavegavel("Cancelar", 'C');
            this.fechou_ok = false;
            try {
                this.atual = String.valueOf(tempo);
                this.jbInit();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConfigAutoEnvio");
            }
        }

        public void jbInit() {
            this.setPreferredSize(new Dimension(330, 90));
            this.setSize(new Dimension(330, 90));
            this.setResizable(false);
            this.field.setHorizontalAlignment(0);
            this.field.addActionListener(new ListenerAcaoTransfereFoco());
            this.field.addKeyListener(new ListenerComponenteSetasNavegacao());
            this.panel.setLayout(new GridBagLayout());
            this.buttons.add(this.button_ok);
            this.buttons.add(this.button_cancel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.insets = new Insets(9, 9, 5, 5);
            this.panel.add((Component)this.label, c);
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 0;
            c.insets = new Insets(9, 0, 5, 9);
            this.panel.add((Component)this.field, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(0, 0, 5, 0);
            this.panel.add((Component)this.buttons, c);
            this.field.setPreferredSize(new Dimension(45, 17));
            this.field.setMinimumSize(new Dimension(45, 17));
            this.field.setText(this.atual);
            this.button_ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int valor = Integer.parseInt(ConfigAutoEnvio.this.field.getText());
                    if (valor >= 100 && valor <= 9999) {
                        ConfigAutoEnvio.this.fechou_ok = true;
                        ConfigAutoEnvio.this.dispose();
                    } else {
                        Funcoes.showAlertaOK(null, "Valor deve estar entre 100 e 9999 milissegundos.");
                        ConfigAutoEnvio.this.field.grabFocus();
                    }
                }
            });
            this.button_cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigAutoEnvio.this.dispose();
                }
            });
        }

        public boolean getFechouOK() {
            return this.fechou_ok;
        }

        public String getValorDigitado() {
            return this.field.getText();
        }
    }

    protected class ThreadEnvio
    extends Thread {
        private int time;

        public ThreadEnvio(int time) {
            this.setPriority(1);
            this.time = time;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    StatusAutoEnvio.this.equipamento.enviarProximoExameAutoEnvio();
                    ThreadEnvio.sleep(this.time);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "StatusAutoEnvio");
                Funcoes.showErro(null, "O auto-envio de exames ser\u00e1 encerrado.");
            }
        }
    }
}

