/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados.repeticao;

import jalis.comum.Conexao;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MembroExamesComposto
extends JPanel {
    JLabel repet = new JLabel();
    JLabel quali = new JLabel();
    JLabel media = new JLabel();
    CampoDigitacao campoFinal = new CampoDigitacao();
    JLabel quanti = new JLabel();
    JLabel desc = new JLabel();
    ExameMaterial exame;
    String parametro;
    public static final Color COR_VERMELHA = new Color(200, 0, 0);
    public static final Color COR_ACTIVE = SystemColor.activeCaption;
    private static final int MARGEM = 15;
    private static final int ALTURA = 25;

    public MembroExamesComposto(ExameMaterial exame, String quantAnterior, String qualitativo, String quantRepeticao, String parametro) {
        this.montaMembro(exame, quantAnterior, qualitativo, quantRepeticao, parametro);
    }

    private void montaMembro(ExameMaterial exame, String quantAnterior, String qualitativo, String quantRepeticao, String parametro) {
        this.parametro = parametro;
        String quantMedia = "";
        if (!Funcoes.textoVazio(quantAnterior) && !Funcoes.textoVazio(quantRepeticao) && Funcoes.isNumeric(quantAnterior) && Funcoes.isNumeric(quantRepeticao)) {
            if (quantAnterior.toString().indexOf(".") > 0 && quantAnterior.toString().indexOf(",") > 0 && quantAnterior.toString().indexOf(".") < quantAnterior.toString().indexOf(",")) {
                quantAnterior = quantAnterior.replaceAll("\\.", "").trim();
            }
            if (quantRepeticao.toString().indexOf(".") > 0 && quantRepeticao.toString().indexOf(",") > 0 && quantRepeticao.toString().indexOf(".") < quantRepeticao.toString().indexOf(",")) {
                quantRepeticao = quantRepeticao.replaceAll("\\.", "").trim();
            }
            BigDecimal b = new BigDecimal(quantAnterior.replaceAll(",", ".").trim());
            b = b.add(new BigDecimal(quantRepeticao.replaceAll(",", ".").trim()));
            b = b.divide(new BigDecimal(2));
            quantMedia = Funcoes.formataDecimal("0.000", b.setScale(3, RoundingMode.HALF_UP).doubleValue());
        }
        this.exame = exame;
        this.media.setText(quantMedia);
        this.getCampoFinal().setHorizontalAlignment(0);
        this.getCampoFinal().setValor(quantRepeticao);
        this.repet.setText(quantRepeticao);
        this.repet.setHorizontalAlignment(0);
        this.media.setHorizontalAlignment(0);
        this.quanti.setText(quantAnterior);
        this.quanti.setForeground(COR_VERMELHA);
        this.quanti.setHorizontalAlignment(0);
        this.repet.setBorder(BorderFactory.createLineBorder(COR_ACTIVE));
        this.quali.setText(qualitativo);
        this.quali.setHorizontalAlignment(0);
        this.setPreferredSize(new Dimension(500, 25));
        this.setSize(new Dimension(500, 25));
        this.setLayout(null);
        this.add((Component)this.quanti, null);
        this.add((Component)this.repet, null);
        this.add((Component)this.media, null);
        this.add((Component)this.getCampoFinal(), null);
        this.add((Component)this.desc, null);
        this.quanti.setBounds(2, 4, 80, 21);
        this.repet.setBounds(87, 4, 80, 21);
        this.media.setBounds(172, 4, 80, 21);
        this.getCampoFinal().setBounds(257, 4, 80, 21);
        this.desc.setBounds(360, 4, 250, 21);
        Statement st = Conexao.getStatement();
        this.desc.setText(exame.getCampoExame());
        Conexao.fecharStatement(st);
    }

    public String getExame() {
        return this.exame.getNomeExame();
    }

    public String getMaterial() {
        return String.valueOf(this.exame.getCodigoMaterial());
    }

    public String getQuanti() {
        return this.repet.getText();
    }

    public String getRepet() {
        return this.quanti.getText();
    }

    public String getQuali() {
        return this.quali.getText();
    }

    public String getParametro() {
        return this.parametro;
    }

    public CampoDigitacao getCampoFinal() {
        return this.campoFinal;
    }
}

