/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados.repeticao;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.resultados.repeticao.AbstractEditarRepeticao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JFrame;

public class EditarRepeticaoGrupo
extends AbstractEditarRepeticao {
    public EditarRepeticaoGrupo(JFrame parent, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo) {
        super(parent, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, usr_codigo);
    }

    @Override
    public void instanciaExameELista(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws Exception {
        BDExame[] temp;
        Statement st = Conexao.getStatement();
        this.lista = new ArrayList();
        this.exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        for (BDExame exm : temp = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) {
            if (exm.getSituacao() != 4) continue;
            String exa_kodigo = exm.getExame();
            String mco_kodigo = exm.getMaterial();
            ExameMaterial exa = new ExameMaterial(exa_kodigo, new Integer(mco_kodigo));
            String quanti = (String)this.exame.getValor(Exame.montaCampoExameFilho(exa_kodigo, mco_kodigo, "resultado_quantitativo"));
            String quali = (String)this.exame.getValor(Exame.montaCampoExameFilho(exa_kodigo, mco_kodigo, "resultado_qualitativo"));
            String repet = (String)this.exame.getValor(Exame.montaCampoExameFilho(exa_kodigo, mco_kodigo, "repeticao_quantitativo"));
            this.lista.add(new AbstractEditarRepeticao.MembroExame(exa, quanti, quali, repet));
        }
    }

    @Override
    public void salvaDados(Statement st) throws SQLException {
        this.atualizaGrupo();
        this.exame.salvaDados(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
    }

    private void atualizaGrupo() {
        for (AbstractEditarRepeticao.MembroExame item : this.lista) {
            String valor = StringUtil.limpaString(item.getQuanti(), new String[]{" ", ".", ","});
            if (!Funcoes.textoVazio(valor)) {
                this.exame.setValor(Exame.montaCampoExameFilho(item.getExame(), item.getMaterial(), "resultado_quantitativo"), item.getQuanti());
            } else {
                this.exame.setValor(Exame.montaCampoExameFilho(item.getExame(), item.getMaterial(), "resultado_quantitativo"), item.getRepet());
            }
            this.exame.setValor(Exame.montaCampoExameFilho(item.getExame(), item.getMaterial(), "resultado_qualitativo"), item.getQuali());
            this.exame.setValor(Exame.montaCampoExameFilho(item.getExame(), item.getMaterial(), "repeticao_quantitativo"), item.getRepet());
        }
    }
}

