/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados.repeticao;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.CamposCoagulacao;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.resultados.repeticao.AbstractEditarRepeticaoComposta;
import jalis.laboratorio.interfaceamento.resultados.repeticao.MembroExamesComposto;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;

public class EditarRepeticaoComposta
extends AbstractEditarRepeticaoComposta {
    BDExame[] examesFilhos = null;

    public EditarRepeticaoComposta(JFrame parent, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo) {
        super(parent, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, usr_codigo);
    }

    @Override
    public void instanciaExameELista(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws Exception {
        Statement st = Conexao.getStatement();
        this.exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        BDExame[] temp = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        Map<String, Object> valores = this.exame.getDados();
        ArrayList<String> listaOrdenada = new ArrayList<String>();
        for (String k : valores.keySet()) {
            listaOrdenada.add(k);
        }
        Collections.sort(listaOrdenada);
        if (temp.length > 0) {
            this.examesFilhos = temp;
            for (BDExame exm : temp) {
                if (exm.getSituacao() != 4) continue;
                this.setDesmembrado(true);
                String exa_kodigo = exm.getExame();
                String mco_kodigo = exm.getMaterial();
                String keyAux = null;
                for (String key : listaOrdenada) {
                    if (key.contains("repeticao") || key.contains("flag") || !key.contains(exa_kodigo)) continue;
                    if (keyAux == null) {
                        keyAux = exa_kodigo + "_" + mco_kodigo;
                        this.lista.put(keyAux, new LinkedList());
                    }
                    ExameMaterial exa = new ExameMaterial(exa_kodigo, new Integer(mco_kodigo));
                    String parametroRepeticao = key.replace("@", "_repeticao@");
                    String repet = (String)this.exame.getValor(parametroRepeticao);
                    exa.setCampoExame(CamposCoagulacao.getValue(key.substring(0, key.indexOf("@"))));
                    if (!this.lista.containsKey(keyAux)) continue;
                    ((LinkedList)this.lista.get(keyAux)).add(new MembroExamesComposto(exa, valores.get(key).toString(), null, repet, key));
                }
            }
        } else {
            ExameMaterial exa = null;
            String keyAux = null;
            LinkedList<MembroExamesComposto> listaCampos = new LinkedList<MembroExamesComposto>();
            for (String key : listaOrdenada) {
                if (key.contains("repeticao") || key.contains("flag")) continue;
                if (keyAux == null) {
                    keyAux = key;
                }
                String repet = (String)this.exame.getValor(key + "_" + "repeticao");
                exa = new ExameMaterial(exa_codigo, new Integer(mco_codigo));
                exa.setCampoExame(CamposCoagulacao.getValue(key));
                listaCampos.add(new MembroExamesComposto(exa, valores.get(key).toString(), null, repet, key));
            }
            this.lista.put(keyAux, listaCampos);
        }
    }

    @Override
    public void salvaDados(Statement st) throws Exception {
        this.atualizaValores();
        this.exame.salvaDados(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
    }

    private void atualizaValores() {
        for (String key : this.lista.keySet()) {
            LinkedList itens = (LinkedList)this.lista.get(key);
            for (MembroExamesComposto item : itens) {
                String valor = StringUtil.limpaString(item.getQuanti(), new String[]{" ", ".", ","});
                if (Funcoes.textoVazio(valor)) continue;
                this.exame.setValor(item.parametro, item.campoFinal.getText());
            }
        }
    }
}

