/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados.repeticao;

import jalis.comum.Conexao;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.resultados.repeticao.MembroExamesComposto;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class AbstractEditarRepeticaoComposta
extends JDialog
implements DisposeListener {
    private static final int MARGEM = 15;
    private static final int ALTURA = 25;
    public static final Color COR_VERMELHA = new Color(200, 0, 0);
    public static final Color COR_ACTIVE = SystemColor.activeCaption;
    JPanel jPanelMain = new JPanel(new BorderLayout());
    JPanel jPanelFoot = new JPanel(new FlowLayout(2));
    JButton jButtonOK = new BotaoNavegavel("OK", 'O');
    JButton jButtonCancel = new BotaoNavegavel("Cancelar", 'C');
    protected String fil_codigo;
    protected String int_codigo;
    protected String req_codigo;
    protected String exa_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String user_code;
    protected Exame exame;
    boolean isDesmembrado = false;
    protected HashMap<String, LinkedList<MembroExamesComposto>> lista = new HashMap();
    private boolean fechou_ok = false;

    public AbstractEditarRepeticaoComposta(JFrame parent, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo) {
        super(parent);
        this.inicializaTela(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, usr_codigo);
    }

    private void inicializaTela(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo) {
        try {
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.exa_codigo = exa_codigo;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.user_code = usr_codigo;
            this.instanciaExameELista(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            this.exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            this.jbInit();
            this.montaTela();
            Laboratorio.getInstancia().addDisposeListener(this);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    public abstract void instanciaExameELista(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    public abstract void salvaDados(Statement var1) throws Exception;

    private void jbInit() throws Exception {
        for (String key : this.lista.keySet()) {
            List listaAux = this.lista.get(key);
            int tamanho = this.lista.size() * (listaAux.size() * 25 + 190);
            this.setSize(new Dimension(724, tamanho > 500 ? 500 : tamanho));
            this.setPreferredSize(new Dimension(724, tamanho > 500 ? 500 : tamanho));
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.setResizable(false);
        this.setTitle("Resultado [" + this.exa_codigo + "] " + this.pac_nome);
        this.jPanelMain.add((Component)this.jPanelFoot, "South");
        this.jPanelFoot.setPreferredSize(new Dimension(120, 35));
        this.jPanelFoot.add(this.jButtonOK);
        this.jPanelFoot.add(this.jButtonCancel);
        this.jButtonOK.setMinimumSize(new Dimension(68, 20));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractEditarRepeticaoComposta.this.jButtonOK_actionPerformed(e);
            }
        });
        this.jButtonCancel.setMinimumSize(new Dimension(68, 20));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractEditarRepeticaoComposta.this.dispose();
            }
        });
    }

    protected void montaTela() {
        this.pack();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Alterando [Exame Pai: " + this.exa_codigo + "] "));
        ScrollPane scroll = new ScrollPane();
        scroll.add(panel);
        this.jPanelMain.add((Component)scroll, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (!this.isDesmembrado) {
            c.weighty = 1.0;
        }
        c.insets = new Insets(2, 2, 2, 2);
        for (String key : this.lista.keySet()) {
            List listaAux = this.lista.get(key);
            JPanel panelCampos = new JPanel(new GridBagLayout());
            panelCampos.setBorder(new TitledBorder(this.isDesmembrado ? key : this.exa_codigo));
            JLabel jLabelQuantitativo = new JLabel("Res. Anterior");
            JLabel jLabelRepeticao = new JLabel("Res. Repetido");
            JLabel jLabelMedia = new JLabel("M\u00e9dia");
            JLabel jLabelAtual = new JLabel("Result./Final");
            JLabel jLabelQualitativo = new JLabel("Parametros");
            GridBagConstraints c2 = new GridBagConstraints();
            c2.gridx = 0;
            c2.gridy = 0;
            c2.anchor = 18;
            c2.fill = 2;
            c2.gridheight = 1;
            c2.gridwidth = 1;
            c2.weightx = 0.0;
            c2.weighty = 0.0;
            c2.insets = new Insets(2, 2, 2, 2);
            jLabelQuantitativo.setPreferredSize(new Dimension(85, 20));
            panelCampos.add((Component)jLabelQuantitativo, c2);
            ++c2.gridx;
            jLabelRepeticao.setPreferredSize(new Dimension(88, 20));
            panelCampos.add((Component)jLabelRepeticao, c2);
            ++c2.gridx;
            jLabelMedia.setPreferredSize(new Dimension(70, 20));
            panelCampos.add((Component)jLabelMedia, c2);
            ++c2.gridx;
            jLabelAtual.setPreferredSize(new Dimension(98, 20));
            panelCampos.add((Component)jLabelAtual, c2);
            ++c2.gridx;
            jLabelQualitativo.setPreferredSize(new Dimension(85, 20));
            jLabelQualitativo.setPreferredSize(new Dimension(300, 20));
            panelCampos.add((Component)jLabelQualitativo, c2);
            c2.gridwidth = 5;
            c2.gridx = 0;
            c2.weightx = 1.0;
            for (MembroExamesComposto item : listaAux) {
                ++c2.gridy;
                item.setPreferredSize(new Dimension(300, 30));
                panelCampos.add((Component)item, c2);
            }
            panel.add((Component)panelCampos, c);
            ++c.gridy;
        }
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.salvaDados(Conexao.getStatement());
            this.atualizaExame();
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getDefaultCursor());
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            Funcoes.showErro(this, "Erro ao armazenar valores no banco de dados.\n" + ex.getMessage());
            return;
        }
        this.fechou_ok = true;
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    protected void atualizaExame() {
        try {
            Statement st = Conexao.getStatement();
            BDUtil.setExmSituacaoEAssinatura(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, 2, null);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            Funcoes.showErro(this, "Erro ao validar exame. " + e.getMessage());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public boolean fechouOK() {
        return this.fechou_ok;
    }

    public void setDesmembrado(boolean isDesmembrado) {
        this.isDesmembrado = isDesmembrado;
    }
}

