/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados.repeticao;

import jalis.comum.Conexao;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DocumentoMascara;
import jalis.util.Funcoes;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractEditarRepeticao
extends JDialog
implements DisposeListener {
    private static final int MARGEM = 15;
    private static final int ALTURA = 25;
    public static final Color COR_VERMELHA = new Color(200, 0, 0);
    public static final Color COR_ACTIVE = SystemColor.activeCaption;
    JPanel jPanelMain = new JPanel(new BorderLayout());
    JPanel jPanelFoot = new JPanel(new FlowLayout(2));
    JPanel jPanelResultado = new JPanel(null);
    JLabel jLabelRepeticao = new JLabel("Repet/Final");
    JLabel jLabelQuantitativo = new JLabel("Qt. Anterior");
    JLabel jLabelMedia = new JLabel("M\u00e9dia");
    JLabel jLabelQualitativo = new JLabel("Qualitativo");
    JButton jButtonOK = new BotaoNavegavel("OK", 'O');
    JButton jButtonCancel = new BotaoNavegavel("Cancelar", 'C');
    String fil_codigo;
    String int_codigo;
    String req_codigo;
    String exa_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String user_code;
    Exame exame;
    private boolean isRepeticaoComposta = false;
    ArrayList<MembroExame> lista = new ArrayList();
    private boolean fechou_ok = false;

    public AbstractEditarRepeticao(JFrame parent, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo) {
        this.inicializaTela(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, usr_codigo, false);
    }

    public AbstractEditarRepeticao(JFrame parent, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo, boolean isRepeticaoComposta) {
        super(parent);
        this.inicializaTela(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, usr_codigo, isRepeticaoComposta);
    }

    private void inicializaTela(String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String usr_codigo, boolean isRepeticaoComposta) {
        try {
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.exa_codigo = exa_codigo;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.isRepeticaoComposta = isRepeticaoComposta;
            this.user_code = usr_codigo;
            this.instanciaExameELista(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            this.exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
            this.jbInit();
            this.montaTela();
            Laboratorio.getInstancia().addDisposeListener(this);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    public abstract void instanciaExameELista(String var1, String var2, String var3, String var4, String var5, String var6) throws Exception;

    public abstract void salvaDados(Statement var1) throws Exception;

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.setSize(new Dimension(590, 180));
        this.setPreferredSize(new Dimension(590, 180));
        this.setResizable(false);
        this.setTitle("Resultado [" + this.exa_codigo + "] " + this.pac_nome);
        this.jPanelMain.add((Component)this.jPanelResultado, "North");
        this.jPanelMain.add((Component)this.jPanelFoot, "South");
        this.jPanelResultado.setBorder(ComponenteFactory.novoTitledEtchedBorder("Alterar Resultado - " + this.exa_codigo));
        this.jPanelResultado.setPreferredSize(new Dimension(10, 100));
        this.jPanelResultado.add((Component)this.jLabelRepeticao, null);
        this.jPanelResultado.add((Component)this.jLabelQuantitativo, null);
        this.jPanelResultado.add((Component)this.jLabelMedia, null);
        if (this.isRepeticaoComposta) {
            this.jLabelQualitativo.setText("Parametros");
        }
        this.jPanelResultado.add((Component)this.jLabelQualitativo, null);
        this.jPanelFoot.setPreferredSize(new Dimension(120, 35));
        this.jPanelFoot.add(this.jButtonOK);
        this.jPanelFoot.add(this.jButtonCancel);
        this.jLabelRepeticao.setBounds(new Rectangle(9, 28, 80, 15));
        this.jLabelQuantitativo.setBounds(new Rectangle(96, 28, 80, 15));
        this.jLabelMedia.setBounds(new Rectangle(181, 28, 80, 15));
        this.jLabelQualitativo.setBounds(new Rectangle(267, 28, 80, 15));
        this.jButtonOK.setMinimumSize(new Dimension(68, 20));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractEditarRepeticao.this.jButtonOK_actionPerformed(e);
            }
        });
        this.jButtonCancel.setMinimumSize(new Dimension(68, 20));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractEditarRepeticao.this.dispose();
            }
        });
    }

    protected void montaTela() {
        this.jPanelResultado.setPreferredSize(new Dimension(10, 55 + 25 * this.lista.size()));
        Dimension d = this.getPreferredSize();
        d = new Dimension(d.width, d.height + 25 * (this.lista.size() - 1));
        this.setSize(d);
        this.setPreferredSize(d);
        int i = 0;
        for (MembroExame item : this.lista) {
            this.jPanelResultado.add((Component)item, null);
            item.setBounds(9, 15 + 25 * ++i, 520, 25);
        }
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.salvaDados(Conexao.getStatement());
            this.atualizaExame();
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getDefaultCursor());
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            Funcoes.showErro(this, "Erro ao armazenar valores no banco de dados.\n" + ex.getMessage());
            return;
        }
        this.fechou_ok = true;
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    protected void atualizaExame() {
        try {
            Statement st = Conexao.getStatement();
            BDUtil.setExmSituacaoEAssinatura(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, 2, null);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            Funcoes.showErro(this, "Erro ao validar exame. " + e.getMessage());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public boolean fechouOK() {
        return this.fechou_ok;
    }

    class MembroExame
    extends JPanel {
        CampoDigitacao repet = new CampoDigitacao();
        CampoDigitacao quali = new CampoDigitacao();
        CampoDigitacao media = new CampoDigitacao();
        JLabel quanti = new JLabel();
        JLabel desc = new JLabel();
        ExameMaterial exame;

        public MembroExame(ExameMaterial exame, String quantAnterior, String qualitativo, String quantRepeticao, boolean isRepeticaoComposta) {
            this.montaMembro(exame, quantAnterior, qualitativo, quantRepeticao, isRepeticaoComposta);
        }

        public MembroExame(ExameMaterial exame, String quantAnterior, String qualitativo, String quantRepeticao) {
            this.montaMembro(exame, quantAnterior, qualitativo, quantRepeticao, false);
        }

        private void montaMembro(ExameMaterial exame, String quantAnterior, String qualitativo, String quantRepeticao, boolean isRepeticaoComposta) {
            String quantMedia = "";
            if (!Funcoes.textoVazio(quantAnterior) && !Funcoes.textoVazio(quantRepeticao) && Funcoes.isNumeric(quantAnterior) && Funcoes.isNumeric(quantRepeticao)) {
                if (quantAnterior.toString().indexOf(".") > 0 && quantAnterior.toString().indexOf(",") > 0 && quantAnterior.toString().indexOf(".") < quantAnterior.toString().indexOf(",")) {
                    quantAnterior = quantAnterior.replaceAll("\\.", "").trim();
                }
                if (quantRepeticao.toString().indexOf(".") > 0 && quantRepeticao.toString().indexOf(",") > 0 && quantRepeticao.toString().indexOf(".") < quantRepeticao.toString().indexOf(",")) {
                    quantRepeticao = quantRepeticao.replaceAll("\\.", "").trim();
                }
                BigDecimal b = new BigDecimal(quantAnterior.replaceAll(",", ".").trim());
                b = b.add(new BigDecimal(quantRepeticao.replaceAll(",", ".").trim()));
                b = b.divide(new BigDecimal(2));
                quantMedia = Funcoes.formataDecimal("0.000", b.setScale(3, RoundingMode.HALF_UP).doubleValue());
            }
            this.exame = exame;
            if (!isRepeticaoComposta) {
                this.repet.setDocument(new DocumentoMascara(this.repet, "######,###"));
            }
            this.repet.setHorizontalAlignment(0);
            this.repet.setValor(quantRepeticao);
            this.media.setDocument(new DocumentoMascara(this.repet, "######,###"));
            this.media.setHorizontalAlignment(0);
            this.media.setValor(quantMedia);
            this.media.setBorder(BorderFactory.createLineBorder(COR_ACTIVE));
            this.quanti.setText(quantAnterior);
            this.quanti.setForeground(COR_VERMELHA);
            this.quanti.setHorizontalAlignment(0);
            this.repet.setBorder(BorderFactory.createLineBorder(COR_ACTIVE));
            this.quali.setText(qualitativo);
            this.quali.setHorizontalAlignment(0);
            this.setPreferredSize(new Dimension(500, 25));
            this.setSize(new Dimension(500, 25));
            this.setLayout(null);
            this.add((Component)this.repet, null);
            this.add((Component)this.quanti, null);
            if (!isRepeticaoComposta) {
                this.add((Component)this.quali, null);
            }
            this.add((Component)this.media, null);
            this.add((Component)this.desc, null);
            this.repet.setBounds(2, 4, 80, 21);
            this.quanti.setBounds(87, 4, 80, 21);
            this.media.setBounds(172, 4, 80, 21);
            if (!isRepeticaoComposta) {
                this.quali.setBounds(267, 4, 120, 21);
                this.desc.setBounds(400, 4, 200, 21);
            } else {
                this.desc.setBounds(267, 4, 250, 21);
            }
            this.repet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MembroExame.this.repet.transferFocus();
                }
            });
            this.quali.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MembroExame.this.quali.transferFocus();
                }
            });
            this.media.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MembroExame.this.media.transferFocus();
                }
            });
            try {
                Statement st = Conexao.getStatement();
                if (isRepeticaoComposta && exame != null && !Funcoes.textoVazio(exame.getCampoExame())) {
                    this.desc.setText(exame.getCampoExame());
                } else {
                    this.desc.setText(BDUtil.getExmDescricao(AbstractEditarRepeticao.this.fil_codigo, exame.getString()));
                }
                Conexao.fecharStatement(st);
            }
            catch (SQLException ex) {
                this.desc.setText(exame.getString());
            }
        }

        public String getExame() {
            return this.exame.getNomeExame();
        }

        public String getMaterial() {
            return String.valueOf(this.exame.getCodigoMaterial());
        }

        public String getQuanti() {
            return this.repet.getText();
        }

        public String getRepet() {
            return this.quanti.getText();
        }

        public String getQuali() {
            return this.quali.getText();
        }

        public String getCampoExame() {
            return this.exame.getCampoExame();
        }
    }
}

