/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.ghosp.IntegracaoHospitalGHosp;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.sistemas.sinconecta.SinconectaLogUtil;
import jalis.integracaohospitais.sistemas.warelineBD.WarelineBDService;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.salux.service.SaluxService;
import jalis.integracaohospitais.util.sinconecta.service.SinconectaService;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.ipmsaude.IPMSaudeService;
import jalis.integracaooperadoras.sistemas.ipmsaude.IntegracaoOperadoraIPMSaude;
import jalis.integracaooperadoras.sistemas.mksaude.IntegracaoOperadoraMKSaude;
import jalis.integracaooperadoras.sistemas.sdh.IntegracaoOperadoraSDH;
import jalis.integracaooperadoras.sistemas.simus.IntegracaoOperadoraSimus;
import jalis.integracaooperadoras.sistemas.sline.model.SLineService;
import jalis.integracaooperadoras.sistemas.sline.model.SLineVO;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.IntegracaoOperadoraGuaxupe;
import jalis.integracaooperadoras.sistemas.unimed.pr.IntegracaoOperadoraPR;
import jalis.integracaooperadoras.sistemas.unimed.sinos.IntegracaoOperadoraUnimedValeSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.upy.IntegracaoOperadoraUpy;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.acoes.AbstractAcoes;
import jalis.laboratorio.configurador.acoes.FabricaAcoes;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Exportacao {
    public static final long CONSIDERAR_LIBERADO_COMO_CONFERENCIA = 1001003007L;

    public static void exportarExames(AbstractInterfaceamento equip, Resultado res) throws Exception {
        String fil_codigo = Variaveis.filialPadrao;
        String usr_codigo = Variaveis.login;
        boolean conferido = Acesso.getAcesso(1001003007L);
        Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(null, fil_codigo);
        Statement s = Conexao.getStatement();
        ResultSet rs = Exportacao.getTodosValidados(s, equip != null && !equip.configuracao.getNaoProcessarRespostasExames());
        while (rs != null && rs.next()) {
            String req_codigo = rs.getString("req_codigo");
            String exa_codigo = rs.getString("exa_codigo");
            int mco_codigo = rs.getInt("mco_codigo");
            String rec_codigo = rs.getString("rec_codigo");
            String con_codigo = rs.getString("con_codigo");
            String des_codigo = rs.getString("des_codigo");
            int req_idade = rs.getInt("req_idade");
            String req_anomes = rs.getString("req_anomes");
            String int_codigo = rs.getString("int_codigo");
            String metCodigo = rs.getString("met_codigo");
            String codigoApoiado = rs.getString("req_codigoapoiado");
            String exameIntegracaoHospital = rs.getString("exr_integracaohospital");
            Map<String, Object> resposta = null;
            if (!(equip == null || equip.configuracao.getNaoProcessarRespostasExames() || DBUtil.campoNull(rs.getString("exr_resposta")) || Funcoes.textoVazio(rs.getString("exr_resposta")))) {
                resposta = Resultado.getCamposResultado(rs.getString("exr_resposta"));
            }
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            Exportacao.recuperaDadosSalvaResultados(equip, s, fil_codigo, int_codigo, usr_codigo, conferido, req_codigo, exa_codigo, mco_codigo, rec_codigo, con_codigo, des_codigo, req_idade, req_anomes, codigoApoiado, historicos, resposta, res, metCodigo, null, exameIntegracaoHospital);
        }
    }

    public static String exportarExame(AbstractInterfaceamento equip, Statement st, String fil_codigo, String req_codigo, String int_codigo, String exa_codigo, String mco_codigo, String rec_codigo, Resultado res, String resultadoAtual) throws Exception {
        return Exportacao.exportarExame(equip, st, fil_codigo, req_codigo, int_codigo, exa_codigo, mco_codigo, rec_codigo, Variaveis.login, res, resultadoAtual);
    }

    public static String exportarExame(AbstractInterfaceamento equip, Statement st, String fil_codigo, String req_codigo, String int_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String usr_codigo, Resultado res, String resultadoAtual) throws Exception {
        ResultSet rs;
        String retorno = "";
        boolean conferido = Acesso.getAcesso(1001003007L);
        Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(exa_codigo, fil_codigo);
        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
            historicos = ExameUtil.getHistoricos(null, fil_codigo);
        }
        if ((rs = Exportacao.getUnicoValidado(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, equip == null || equip != null && !equip.configuracao.getNaoProcessarRespostasExames())) != null && rs.next()) {
            String con_codigo = rs.getString("con_codigo");
            String des_codigo = rs.getString("des_codigo");
            int req_idade = rs.getInt("req_idade");
            String req_anomes = rs.getString("req_anomes");
            String metCodigo = rs.getString("met_codigo");
            String codigoApoiado = rs.getString("req_codigoapoiado");
            String exameIntegracaoHospital = rs.getString("exr_integracaohospital");
            Map<String, Object> resposta = null;
            if (!(equip != null && (equip == null || equip.configuracao.getNaoProcessarRespostasExames()) || DBUtil.campoNull(rs.getString("exr_resposta")) || Funcoes.textoVazio(rs.getString("exr_resposta")) || rs.getString("exr_resposta").trim().length() <= 0)) {
                resposta = Resultado.getCamposResultado(rs.getString("exr_resposta"));
            }
            retorno = Exportacao.recuperaDadosSalvaResultados(equip, st, fil_codigo, int_codigo, usr_codigo, conferido, req_codigo, exa_codigo, Integer.parseInt(mco_codigo), rec_codigo, con_codigo, des_codigo, req_idade, req_anomes, codigoApoiado, historicos, resposta, res, metCodigo, resultadoAtual, exameIntegracaoHospital);
        }
        return retorno;
    }

    public static String recuperaDadosSalvaResultados(AbstractInterfaceamento equip, Statement st, final String fil_codigo, String int_codigo, String usr_codigo, boolean conferido, final String req_codigo, final String exa_codigo, final int mco_codigo, String rec_codigo, final String con_codigo, String des_codigo, int req_idade, String req_anomes, String codigoApoiado, Map<String, Map<String, String>> historicos, Map<String, Object> externos, Resultado res, String metCodigo, String resultadoCompletoAtual, String exameIntegracaoHospital) throws SQLException, Exception {
        String retorno = "";
        String situacao = BDUtil.getReqSituacao(fil_codigo, req_codigo, exa_codigo, mco_codigo);
        if (Funcoes.textoVazio(situacao) || situacao.equals("P")) {
            boolean validacaoResultadoCritico;
            Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), rec_codigo);
            exame.putDados(ExameUtil.getDadosExameRequisicao(req_codigo, exa_codigo, String.valueOf(mco_codigo), fil_codigo, false, false));
            String lay_codigo = ExameUtil.getCodigoLayout(fil_codigo, con_codigo, des_codigo);
            int met_codigo = BDUtil.getExameMetodo(fil_codigo, exa_codigo, Integer.toString(mco_codigo), int_codigo);
            if (met_codigo < 0) {
                return "N\u00e3o foi poss\u00edvel encontrar o m\u00e9todo do Exame";
            }
            String elm_formato = ExameUtil.pegaLayoutIdade(fil_codigo, req_idade, req_anomes, lay_codigo, exa_codigo, mco_codigo, met_codigo, "elm_formato");
            final String pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            Map<Integer, String> resAnteriores = BDUtil.getExmResultadosAnteriores(fil_codigo, pac_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), metCodigo);
            Date data = (Date)exame.getValor("datacoletaexame");
            Date hora = (Date)exame.getValor("datacoletaexame");
            String resultadoAtual = res.getResultadoAnterior(data, hora);
            String resultadoAux = Funcoes.textoVazio(resultadoCompletoAtual) ? res.getResultado() : resultadoCompletoAtual;
            resultadoAux = Funcoes.textoVazio(resultadoAux) ? elm_formato : resultadoAux;
            res = new Resultado(null, resultadoAux, exame.getDados(), externos, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnteriores, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual);
            res.atualizarComponentes();
            if (!res.verificarCondicao()) {
                retorno = "Requisi\u00e7\u00e3o: " + req_codigo + ", Exame: " + exa_codigo;
                retorno = retorno + " - N\u00e3o pode ser exportado por n\u00e3o satisfazer as condi\u00e7\u00f5es do exame.";
                if (equip != null) {
                    equip.adicionarExcecao(retorno);
                    equip.novaMensagem(retorno, 1, 5000);
                }
                return retorno;
            }
            DadosExames exa = ExameUtil.getDadosExameSimples(fil_codigo, exa_codigo, new DadosMaterial(mco_codigo, "", false, false));
            boolean res_completo = true;
            if (exa.getSalvarParcial()) {
                res_completo = res.resultadoCompleto(true);
            }
            String resultado = res_completo ? resultadoAux : res.getResultadoParcial();
            boolean situacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
            boolean bl = validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
            if (res_completo) {
                Exportacao.salvarResultado(st, fil_codigo, pac_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), usr_codigo, resultado, res.getResultadoAnterior(data, hora), data, hora, conferido, metCodigo, situacaoCompulsoria, validacaoResultadoCritico);
                ExameUtil.atualizaDadosConferenciaAutomatica(fil_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), int_codigo);
            } else {
                Exportacao.salvarParcial(st, fil_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), usr_codigo, resultado, situacaoCompulsoria, validacaoResultadoCritico);
            }
            BDUtil.setExmSituacaoEAssinatura(st, fil_codigo, int_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), rec_codigo, 8, usr_codigo);
            BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), rec_codigo, 8);
            if (equip != null && equip.configuracao != null && equip.configuracao.getRemoverOutrosRecipientesDaInterfaceNaExportacao()) {
                BDUtil.cancelaExameInterface(st, fil_codigo, int_codigo, req_codigo, exa_codigo, String.valueOf(mco_codigo), rec_codigo, 10);
            }
            situacao = BDUtil.getReqSituacao(fil_codigo, req_codigo, exa_codigo, mco_codigo);
            final String rec_codigoThread = rec_codigo;
            final String fil_codigoThread = fil_codigo;
            final String int_codigoThread = int_codigo;
            final String req_codigoThread = req_codigo;
            final String exa_codigoThread = exa_codigo;
            final int mco_codigoThread = mco_codigo;
            final String situacaoThread = situacao;
            final String resultadoThread = resultado;
            final String lay_codigoThread = lay_codigo;
            final String req_anomesThread = req_anomes;
            final int req_idadeThread = req_idade;
            final int met_codigoThread = met_codigo;
            final Map<String, Map<String, String>> historicosThread = historicos;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Statement st = Conexao.getStatement();
                    try {
                        if (!situacaoThread.equals("P")) {
                            ArrayList<String> interfaces = BDUtil.getInterfacesExame(fil_codigoThread, exa_codigoThread, String.valueOf(mco_codigoThread));
                            for (String i : interfaces) {
                                if (i.equalsIgnoreCase(int_codigoThread)) continue;
                                BDUtil.deletarExameInterface(st, fil_codigoThread, i, req_codigoThread, exa_codigoThread, String.valueOf(mco_codigoThread), rec_codigoThread);
                            }
                        }
                        Exportacao.exportarWeb(situacaoThread, resultadoThread, fil_codigoThread, req_codigoThread, exa_codigoThread, String.valueOf(mco_codigoThread), lay_codigoThread, req_anomesThread, String.valueOf(req_idadeThread), String.valueOf(met_codigoThread), historicosThread);
                        Util.gravaAlteracaoExameRequisicao(st, fil_codigoThread, req_codigoThread, exa_codigoThread, String.valueOf(mco_codigoThread));
                        ExportaFiliais.gravaRequisicao(Integer.parseInt(fil_codigoThread), Integer.parseInt(req_codigoThread), exa_codigoThread, mco_codigoThread, "U", "U");
                        if (!SMSUtil.isBloquearSMSExamePronto(fil_codigoThread, req_codigoThread, st)) {
                            SMSUtil.criaLogSmsComDadosRequisicao(fil_codigoThread, req_codigoThread, ExportaSMS.TipoSMS.RESULTADO, st, Conexao.getStatement());
                        }
                        if (!EmailUtil.isBloquearEmailExamePronto(fil_codigoThread, req_codigoThread, st)) {
                            EmailUtil.criaLogEmail(fil_codigoThread, req_codigoThread, null, EmailUtil.TipoEmail.RESULTADO, true, st);
                        }
                        if (!PushUtil.isBloquearPushExamePronto(fil_codigoThread, req_codigoThread, st)) {
                            PushUtil.criaLogPushComDadosRequisicao(fil_codigoThread, req_codigoThread, TipoPush.RESULTADO, st, Conexao.getStatement());
                        }
                        if (!WhatsAppUtil.isBloquearWhatsappExamePronto(fil_codigoThread, req_codigoThread, st)) {
                            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(fil_codigoThread, req_codigoThread, TipoWhatsapp.RESULTADO, st, Conexao.getStatement());
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }).start();
            final String fil_codigoThread2 = fil_codigo;
            final String req_codigoThread2 = req_codigo;
            final String exa_codigoThread2 = exa_codigo;
            final int mco_codigoThread2 = mco_codigo;
            String met_codigoThread2 = metCodigo;
            final String con_codigoThread = con_codigo;
            String resultadoThread2 = resultadoAux;
            String codigoApoiadoThread = codigoApoiado;
            final String pac_codigoThread = pac_codigo;
            String des_codigoThread = des_codigo;
            int req_idadeThread2 = req_idade;
            String req_anomesThread2 = req_anomes;
            String lay_codigoThread2 = lay_codigo;
            final String situacaoThread2 = situacao;
            final String exameIntegracaoHospitalThread = exameIntegracaoHospital;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Statement st;
                    block29: {
                        st = Conexao.getStatement();
                        try {
                            Registro dadosReq;
                            IPMSaudeService ipmSaudeService;
                            String integracaoHospital = BDUtil.getCodigoIntegracaoHospitalRequisicao(fil_codigoThread2, req_codigoThread2);
                            if (ParametrosGerais.getProtocoloIntegracaoHospital() != null) {
                                String codRequisicao;
                                Object service;
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH) {
                                    IntegracaoHospitalSigh integracaoSig;
                                    boolean cobranca;
                                    if (ParametrosGerais.getEventoGeradorIntegracaoHospital().equalsIgnoreCase("R") && IntegracaoHospitalSigh.validaExportacaoRequisicaoSituacaoI(fil_codigoThread2, req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2)) && !(cobranca = (integracaoSig = (IntegracaoHospitalSigh)FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), ParametrosLocais.getParametro("xmlHospital"))).getCobrancaContaPaciente(fil_codigoThread2, con_codigoThread))) {
                                        IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), fil_codigoThread2, "I", "filial", fil_codigoThread2, "codReq", req_codigoThread2, "codExa", exa_codigoThread2, "codMat", String.valueOf(mco_codigoThread2));
                                    }
                                    if (integracaoHospital != null) {
                                        IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), fil_codigoThread2, "O", "filial", fil_codigoThread2, "codReq", req_codigoThread2, "codExa", exa_codigoThread2, "codMat", String.valueOf(mco_codigoThread2));
                                    }
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV && !Funcoes.textoVazio(integracaoHospital)) {
                                    AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), Variaveis.filialPadrao, "R", "filial", fil_codigoThread2, "codReq", req_codigoThread2, "codExa", exa_codigoThread2, "codMat", String.valueOf(mco_codigoThread2));
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.TASY && !Funcoes.textoVazio(integracaoHospital)) {
                                    AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), Variaveis.filialPadrao, "R", "filial", fil_codigoThread2, "codReq", req_codigoThread2, "codExa", exa_codigoThread2, "codMat", String.valueOf(mco_codigoThread2));
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.TASY_WEBSERVICE && !Funcoes.textoVazio(integracaoHospital) && !Funcoes.textoVazio(StringUtil.getValor(exameIntegracaoHospitalThread, "NR_PRESCRICAO")) && situacaoThread2.equals("C")) {
                                    String[] comando = new String[]{"NR_PRESCRICAO", StringUtil.getValor(exameIntegracaoHospitalThread, "NR_PRESCRICAO"), "NR_SEQUENCIA", "NR_SEQUENCIA", StringUtil.getValor(exameIntegracaoHospitalThread, "NR_SEQUENCIA")};
                                    AbstractIntegracaoHospital.insereIntegracaoHospitalComExameRequisicao(ParametrosGerais.getProtocoloIntegracaoHospital(), fil_codigoThread2, req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2), "E", comando);
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.G_HOSP && !Funcoes.textoVazio(integracaoHospital)) {
                                    IntegracaoHospitalGHosp.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), Variaveis.filialPadrao, req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2), "R", new String[]{"filial", fil_codigoThread2, "codReq", req_codigoThread2, "codExa", exa_codigoThread2, "codMat", String.valueOf(mco_codigoThread2)});
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SALUX && !Funcoes.textoVazio(integracaoHospital)) {
                                    Integer sequencialExame;
                                    service = new SaluxService();
                                    String idSolicitacao = ((SaluxService)service).getIdSolicitacaoSalux(fil_codigoThread2, req_codigoThread2);
                                    if (((SaluxService)service).convenioIntegradoSalux(fil_codigoThread2, con_codigoThread) && !Funcoes.textoVazio(idSolicitacao) && situacaoThread2.equals("C") && (sequencialExame = ((SaluxService)service).getSequencialExame(fil_codigoThread2, req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2))) > 0) {
                                        String tipoOperacao = ((SaluxService)service).resultadoRetificado(fil_codigoThread2, req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2)) ? "A" : "L";
                                        ((SaluxService)service).insereIntegracaoHospitalResultado(fil_codigoThread2, tipoOperacao, req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2), idSolicitacao, String.valueOf(sequencialExame));
                                    }
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SINCONECTA && situacaoThread2.equals("C")) {
                                    SinconectaService serviceSinconecta = new SinconectaService();
                                    String codFilial = fil_codigoThread2;
                                    codRequisicao = req_codigoThread2;
                                    String reqGuia = serviceSinconecta.getRequisicaoGuia(codFilial, codRequisicao);
                                    if (serviceSinconecta.convenioIntegradoSinconecta(codFilial, con_codigoThread) && situacaoThread2.equals("C") && serviceSinconecta.getSolicitacaoTiss(codFilial, codRequisicao, exa_codigoThread2, mco_codigoThread2).booleanValue()) {
                                        SinconectaLogUtil.salvarLogSinconecta(req_codigoThread2, exa_codigoThread2, String.valueOf(mco_codigoThread2), codFilial, serviceSinconecta.getAutorizaocaoExame(codFilial, codRequisicao, exa_codigoThread2, mco_codigoThread2), reqGuia);
                                    }
                                }
                                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.WARELINEBD && !Funcoes.textoVazio(integracaoHospital)) {
                                    service = new WarelineBDService();
                                    String codFilial = fil_codigoThread2;
                                    codRequisicao = req_codigoThread2;
                                    String codExame = exa_codigoThread2;
                                    String codMaterial = String.valueOf(mco_codigoThread2);
                                    ((WarelineBDService)service).gerarLogExportacaoWarelineBD(codFilial, con_codigoThread, codRequisicao, codExame, codMaterial);
                                }
                            }
                            if (ParametrosGerais.isIntegracaoIds() && IntegracaoIDSSaude.temCodigoIDS(fil_codigoThread2, req_codigoThread2)) {
                                IntegracaoIDSSaude.adicionarLog(st, Integer.parseInt(fil_codigoThread2), Integer.parseInt(req_codigoThread2), exa_codigoThread2, mco_codigoThread2);
                            }
                            String tipoIntegracaoOperadoraConvenio = new ConvenioService().getTipoIntegracaoOperadoraSaude(fil_codigoThread2, con_codigoThread);
                            FilialVOAux filialVO = new FilialService().buscaFilial(fil_codigoThread2);
                            if (Funcoes.textoVazio(tipoIntegracaoOperadoraConvenio)) break block29;
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("U")) {
                                IntegracaoOperadoraUpy.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("V")) {
                                IntegracaoOperadoraUnimedVTRP.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("M")) {
                                IntegracaoOperadoraMKSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("D")) {
                                ipmSaudeService = new IPMSaudeService();
                                dadosReq = ipmSaudeService.getInformacaoRequisicao(fil_codigoThread2, req_codigoThread2);
                                IntegracaoOperadoraSDH.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2), "codGuia", dadosReq.getString("req_guia")});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("S")) {
                                ValeDosSinosDTO valeDosSinosDTO = new ValeDosSinosDTO(fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigo, exa_codigoThread2, String.valueOf(mco_codigoThread2));
                                IntegracaoOperadoraUnimedValeSinos.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), valeDosSinosDTO, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("P")) {
                                ipmSaudeService = new IPMSaudeService();
                                dadosReq = ipmSaudeService.getInformacaoRequisicao(fil_codigoThread2, req_codigoThread2);
                                if (!(Funcoes.objectIsNull(dadosReq) || Funcoes.textoVazio(dadosReq.getString("req_codigoipm")) || Funcoes.textoVazio(dadosReq.getString("exr_codigoipm")))) {
                                    IntegracaoOperadoraIPMSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2), "codGuia", dadosReq.getString("req_guia")});
                                }
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS.getCodigo())) {
                                IntegracaoOperadoraSimus.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR.getCodigo())) {
                                IntegracaoOperadoraPR.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE.getCodigo())) {
                                IntegracaoOperadoraGuaxupe.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, req_codigoThread2, pac_codigoThread, exa_codigoThread2, String.valueOf(mco_codigoThread2), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2)});
                                break block29;
                            }
                            if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE.getCodigo())) {
                                SLineVO vo = new SLineVO.SlineVoBuilder().filial(fil_codigo).requisicao(req_codigo).convenio(con_codigo).paciente(pac_codigo).exame(exa_codigo).material(String.valueOf(mco_codigo)).build();
                                new SLineService().inserirIntegracaoOperadora(vo);
                                break block29;
                            }
                            AbstractIntegracaoOperadora.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), fil_codigoThread2, con_codigoThread, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), "filial", fil_codigoThread2, "codreq", req_codigoThread2, "codexa", exa_codigoThread2, "codmat", String.valueOf(mco_codigoThread2));
                        }
                        catch (Exception e) {
                            try {
                                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                    }
                    Conexao.fecharStatement(st);
                }
            }).start();
        } else {
            String sit = Tipos.tipoSituacaoExame(situacao);
            retorno = "Requisi\u00e7\u00e3o: " + req_codigo + ", Exame: " + exa_codigo + " - N\u00e3o pode ser exportado por encontrar-se como \"" + sit + "\"";
            if (equip != null) {
                equip.adicionarExcecao(retorno);
                equip.novaMensagem(retorno, 1, 5000);
            }
        }
        return retorno;
    }

    public static ResultSet getTodosValidados(Statement st, boolean validarRespostasExames) throws SQLException {
        String situacao = String.valueOf(7);
        StringBuilder query = new StringBuilder();
        query.append("select a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.des_codigo, ");
        query.append(" b.con_codigo, b.req_idade, b.req_codigoapoiado, b.req_anomes, a.int_codigo, d.int_codigo, d.met_codigo, c.exr_integracaohospital ");
        if (validarRespostasExames) {
            query.append(", c.exr_resposta ");
        }
        query.append(" from interfaceexamerequisicao a ");
        if (validarRespostasExames) {
            query.append(" left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        }
        query.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        query.append(" left join examematinterface d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo and a.int_codigo = d.int_codigo ");
        query.append(" where ");
        query.append(BDUtil.montaSQLEquipamentoFilial());
        query.append(" and a.ier_situacao = ");
        query.append(situacao);
        query.append(" order by a.req_codigo");
        return Conexao.executeQuery(st, query.toString());
    }

    public static ResultSet getUnicoValidado(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, boolean validarRespostasExames) throws SQLException {
        return Exportacao.getUnicoValidadoPerformance(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, validarRespostasExames);
    }

    public static ResultSet getUnicoValidadoPerformance(Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, boolean validarRespostasExames) throws SQLException {
        String situacao = String.valueOf(7);
        StringBuilder query = new StringBuilder();
        query.append("select a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.des_codigo, d.met_codigo, ");
        query.append("b.con_codigo, b.req_idade, b.req_codigoapoiado, b.req_anomes, a.ier_situacao, a.ier_confautomatica, c.exr_situacao, c.exr_resultado, c.exr_integracaohospital ");
        if (validarRespostasExames) {
            query.append(", c.exr_resposta ");
        }
        query.append(" from interfaceexamerequisicao a ");
        query.append(" left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        query.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        query.append(" left join examematinterface d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo and a.int_codigo = d.int_codigo ");
        query.append(" where a.fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and a.int_codigo = ");
        query.append(int_codigo);
        query.append(" and a.req_codigo = ");
        query.append(req_codigo);
        query.append(" and a.exa_codigo = '");
        query.append(exa_codigo);
        query.append("' and a.mco_codigo = ");
        query.append(mco_codigo);
        query.append(" and a.ier_situacao = ");
        query.append(situacao);
        query.append(" order by a.req_codigo");
        return Conexao.executeQueryPerformance(st, query.toString());
    }

    public static void salvarParcial(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String usr_codigo, String res_parcial, boolean situacaoCompulsoria, boolean validacaoResultadoCritico) throws SQLException {
        Exportacao.salvarParcialPerformance(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, usr_codigo, res_parcial, situacaoCompulsoria, validacaoResultadoCritico);
    }

    public static void salvarParcialPerformance(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String usr_codigo, String res_parcial, boolean situacaoCompulsoria, boolean validacaoResultadoCritico) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("update examerequisicao set ");
        query.append("exr_datadigita = current_timestamp ");
        query.append(", exr_compulsorio = ").append(situacaoCompulsoria);
        query.append(", exr_dataresultadocritico = ").append(validacaoResultadoCritico ? "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date()) + "'" : "null").append(",");
        query.append(" exr_resultado = ");
        query.append(StringUtil.textoDBEscape(res_parcial));
        query.append(", exr_situacao = '");
        query.append("P");
        query.append("', usr_coddigitador = ");
        query.append(DBUtil.bdText(usr_codigo));
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = '");
        query.append(exa_codigo);
        query.append("' and mco_codigo = ");
        query.append(mco_codigo);
        DBUtil.gravaLogSituacaoExameRequisicaoPerformance(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, "P", false);
        Conexao.executeUpdatePerformance(fil_codigo, st, query.toString());
    }

    public static void salvarResultado(Statement st, String fil_codigo, String pac_codigo, String req_codigo, String exa_codigo, String mco_codigo, String usr_codigo, String resultado, String res_anterior, Date dataColeta, Date horaColeta, boolean conferido, String metCodigo, boolean situacaoCompulsoria, boolean validacaoResultadoCritico) throws SQLException, NoSuchAlgorithmException, SalvaDadosException, CertificadoException, Exception {
        StringBuilder query = new StringBuilder();
        String xmlAssinado = null;
        Date dataAssinatura = new Date();
        Map<String, String> pacienteDados = BDUtil.getDadosPacienteMaps(fil_codigo, req_codigo);
        if (conferido) {
            xmlAssinado = ResultadosUtil.assinarXML(st, fil_codigo, StringUtil.textoDB(resultado), req_codigo, exa_codigo, mco_codigo, pacienteDados.get("pac_nome"), pacienteDados.get("pac_sexo"), pacienteDados.get("pac_datanasc"), dataAssinatura);
        }
        if (Funcoes.textoVazio(usr_codigo)) {
            usr_codigo = Variaveis.login;
        }
        query.append("update examerequisicao set ");
        if (conferido) {
            query.append("exr_dataassina = current_timestamp, ");
        }
        query.append("exr_datadigita = current_timestamp, ");
        query.append("exr_compulsorio = ").append(situacaoCompulsoria).append(", ");
        query.append("exr_resultado = ");
        query.append(DBUtil.bdText(xmlAssinado != null ? xmlAssinado : resultado));
        query.append(", exr_situacao = '");
        query.append(conferido ? "C" : "L");
        query.append("',usr_coddigitador = ");
        query.append(DBUtil.bdText(usr_codigo));
        query.append(" ,met_codigo = ").append(metCodigo);
        query.append(", exr_dataresultadocritico = ").append(validacaoResultadoCritico ? "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date()) + "'" : "null");
        if (conferido) {
            query.append(", usr_codassina = ");
            query.append(DBUtil.bdText(usr_codigo));
        }
        query.append(" where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and req_codigo = ");
        query.append(req_codigo);
        query.append(" and exa_codigo = '");
        query.append(exa_codigo);
        query.append("' and mco_codigo = ");
        query.append(mco_codigo);
        DBUtil.gravaLogSituacaoExameRequisicao(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, conferido ? "C" : "L", false);
        Conexao.executeUpdate(fil_codigo, st, query);
        query.delete(0, query.length());
        String date = Funcoes.formataData("MM/dd/yyyy", dataColeta == null ? new Date() : dataColeta);
        String time = Funcoes.formataData("HH:mm:ss.SSS", horaColeta == null ? new Date() : horaColeta);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fil_codigo", fil_codigo);
        params.put("pac_codigo", pac_codigo);
        params.put("exa_codigo", exa_codigo);
        params.put("mco_codigo", mco_codigo);
        params.put("met_codigo", metCodigo);
        params.put("exc_data", date);
        params.put("exc_hora", time);
        params.put("req_codigo", req_codigo);
        params.put("exc_resultado", res_anterior);
        params.put("codigofilial", fil_codigo);
        params.put("codigopaciente", pac_codigo);
        params.put("resultadoexame", resultado);
        ExameUtil.deletaExamesControle(params, st);
        ExameUtil.insereExameControle(params, st, true);
        if (conferido) {
            ResultadosUtil.atualizaAssinaturaExameRequisicao(fil_codigo, req_codigo, exa_codigo, mco_codigo, st, dataAssinatura);
            ResultadosUtil.gravarHashResultado(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, pacienteDados.get("pac_nome"), xmlAssinado);
        }
        if (conferido) {
            Exportacao.invocaAcoesConferencia(resultado, params);
        }
    }

    public static void invocaAcoesConferencia(String xmlResultado, HashMap<String, Object> mapaDados) {
        if (Funcoes.textoVazio(xmlResultado)) {
            return;
        }
        String exame = StringUtil.getValor(xmlResultado, "exame");
        if (Funcoes.textoVazio(exame)) {
            return;
        }
        String parametros = StringUtil.getValor(exame, "parametros");
        if (Funcoes.textoVazio(parametros)) {
            return;
        }
        String acoesExames = StringUtil.getValor(parametros, "acoesexame");
        if (!Funcoes.textoVazio(acoesExames)) {
            String[] acoes;
            for (String acao : acoes = StringUtil.getValores(acoesExames, "acao")) {
                AbstractAcoes instancia;
                String nomeInterno = StringUtil.getValor(acao, "tipo");
                if (Funcoes.textoVazio(nomeInterno) || !(instancia = FabricaAcoes.getAcaoNomeInterno(nomeInterno)).getTipoEvento().equals((Object)AbstractAcoes.TiposEventosAcoes.CONFERENCIA_RESULTADO)) continue;
                instancia.setXML(acao);
                instancia.executarAcao(mapaDados);
            }
        }
    }

    public static Map<String, Object> corrigePontuacaoDecimal(Map<String, Object> dados) {
        Set<String> keyset = dados.keySet();
        for (String key : keyset) {
            if (key.matches("observacao_[012]{1}[0-9]{1}")) continue;
            String valor = String.valueOf(dados.get(key));
            valor = valor.replaceAll("\\.", ",");
            dados.put(key, valor);
        }
        return dados;
    }

    public static Map<String, Object> gambiarraNoResultado(Map<String, Object> dados) {
        Set<String> keyset = dados.keySet();
        for (String key : keyset) {
            if (key.matches("observacao_[012]{1}[0-9]{1}")) continue;
            String valor = String.valueOf(dados.get(key));
            if (valor.matches("\\d+(\\,\\d+)?")) {
                valor = "  " + valor;
            }
            dados.put(key, valor);
        }
        return dados;
    }

    public static void exportarWeb(String situacao, String resultado, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String lay_codigo, String req_anomes, String req_idade, String met_codigo, Map<String, Map<String, String>> historicos) throws Exception {
        try {
            Statement st = Conexao.getStatement();
            String nomeUsu = Variaveis.nomeUsuario;
            String baseWeb = ExportaWeb.getCodigoBaseWeb(st, fil_codigo);
            if (!Funcoes.textoVazio(baseWeb)) {
                boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, fil_codigo);
                Map<String, Object> map = ResultadosUtil.geraResultadoParaWeb(st, fil_codigo, req_codigo, exa_codigo, mco_codigo);
                ArrayList<String> list = new ArrayList<String>();
                list.add("situacaoExameRequisicao");
                list.add(situacao);
                if (!resultadoPdf) {
                    String laudo = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
                    String formatoTexto = ResultadosUtil.geraResultadoTextoParaWeb(fil_codigo, Integer.parseInt(req_idade), req_anomes, lay_codigo, exa_codigo, Integer.parseInt(mco_codigo), met_codigo, resultado, st);
                    list.add("resultadoExameRequisicao");
                    list.add(laudo);
                    list.add("resultadoTextoExameRequisicao");
                    list.add(formatoTexto);
                }
                if (situacao.equals("C")) {
                    list.add("nomeAssinaturaExameRequisicao");
                    list.add(nomeUsu);
                    list.add("assinaturaExameRequisicao");
                    list.add(Variaveis.login);
                }
                Exportacao.alterarExameRequisicaoWeb(false, st, fil_codigo, req_codigo, exa_codigo, mco_codigo, list.toArray(new String[list.size()]));
                if (map != null) {
                    Exportacao.inserirExameRequisicaoImagemWeb(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, (Map)map.get("imagens"));
                }
            }
            Exportacao.atualizaPaginaOrdemExameWeb(st, fil_codigo, req_codigo, lay_codigo, req_anomes, req_idade, historicos.get("historicoporcodigo"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void alterarExameRequisicaoWeb(boolean inserir, Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String ... campos) throws Exception {
        String baseWeb = ExportaWeb.getCodigoBaseWeb(st, fil_codigo);
        if (baseWeb != null) {
            Exportacao.alterarExameRequisicaoWeb(inserir, st, fil_codigo, req_codigo, exa_codigo, mco_codigo, baseWeb, campos);
        }
    }

    public static void alterarExameRequisicaoWeb(boolean inserir, Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String baseWeb, String ... campos) throws Exception {
        if (baseWeb != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(fil_codigo, req_codigo, st));
            tmp.add("codigoBase");
            tmp.add(baseWeb);
            tmp.add("codigoExameRequisicao");
            tmp.add(exa_codigo);
            tmp.add("materialExameRequisicao");
            tmp.add(mco_codigo);
            tmp.add("dataEnvioExameRequisicao");
            tmp.add("current_timestamp");
            for (String campo : campos) {
                tmp.add(campo);
            }
            String operacao = inserir ? "I" : "A";
            DBUtil.insereExportaWeb(fil_codigo, st, "requisicaoexame", operacao, true, tmp.toArray(new String[tmp.size()]));
        }
    }

    public static void inserirExameRequisicaoImagemWeb(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, Map<Integer, String> imagens) throws SQLException {
        String baseWeb = ExportaWeb.getCodigoBaseWeb(st, fil_codigo);
        Exportacao.inserirExameRequisicaoImagemWeb(st, fil_codigo, req_codigo, exa_codigo, mco_codigo, imagens, baseWeb);
    }

    public static void inserirExameRequisicaoImagemWeb(Statement st, String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, Map<Integer, String> imagens, String baseWeb) throws SQLException {
        if (baseWeb != null && imagens != null && !imagens.isEmpty()) {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add("codigoRequisicao");
            tmp.add(IntegracaoUtil.formataCodigoRequisicao(fil_codigo, req_codigo, st));
            tmp.add("codigoBase");
            tmp.add(baseWeb);
            tmp.add("codigoExameRequisicao");
            tmp.add(exa_codigo);
            tmp.add("materialExameRequisicao");
            tmp.add(mco_codigo);
            for (Integer img : imagens.keySet()) {
                ArrayList<String> aux = new ArrayList<String>(tmp);
                aux.add("codigoImagemExame");
                aux.add(img.toString());
                aux.add("imagemExame");
                aux.add(imagens.get(img));
                DBUtil.insereExportaWeb(fil_codigo, st, "requisicaoexameimagem", "I", aux.toArray(new String[aux.size()]));
            }
        }
    }

    public static void atualizaPaginaOrdemExameWeb(Statement st, String fil_codigo, String req_codigo, String lay_codigo, String req_anomes, String req_idade, Map<String, String> historicos) throws Exception {
        String baseWeb = ExportaWeb.getCodigoBaseWeb(st, fil_codigo);
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, fil_codigo, req_codigo, baseWeb);
    }

    public static void atualizaPaginaOrdemExameWeb(Statement st, String fil_codigo, String req_codigo, String lay_codigo, String req_anomes, String req_idade, Map<String, String> historicos, String baseWeb) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, fil_codigo, req_codigo, baseWeb);
    }

    private static ArrayList<Registro> carregarExames(String req_codigo, String lay_codigo, String req_anomes, String req_idade, Map<String, String> historicos) throws Exception {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder("select b.exa_codigo, b.exa_descricao, b.exa_salvaparcial, a.exr_situacao, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
        bui.append("a.exr_datadigita, a.exr_dataassina, a.exr_dataimpresso, a.exr_datamaterial, a.exr_vlrexame, a.exr_vlrmaterial, a.exr_descricaomaterial, a.exr_naofaturar, ");
        bui.append("a.usr_coddigitador, a.usr_codassina, a.usr_codimpressao, ");
        bui.append("c.mco_codigo, c.mco_descricao, c.mco_abreviatura, d.prz_codigo, d.emc_solicitarjejum, d.emc_pagina, d.emc_ordem, (a.exr_datafatura is not null) as ");
        bui.append("faturado");
        bui.append(" from examerequisicao a left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo ");
        }
        bui.append("where a.fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and a.req_codigo = ");
        bui.append(req_codigo);
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append(" and e.ese_default = true");
        }
        bui.append(" order by ");
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append("e.set_codigo, ");
        }
        bui.append("d.emc_pagina, d.emc_ordem, d.exa_codigo, d.mco_codigo ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        int qtdeExames = 0;
        while (rs.next()) {
            ++qtdeExames;
        }
        rs.beforeFirst();
        ArrayList<Registro> lista = new ArrayList<Registro>();
        while (rs.next()) {
            lista.add(Exportacao.carregarRegistro(rs, req_codigo, lay_codigo, req_anomes, req_idade, historicos));
        }
        Conexao.fecharStatement(st);
        return lista;
    }

    private static Registro carregarRegistro(ResultSet rs, String req_codigo, String lay_codigo, String req_anomes, String req_idade, Map<String, String> historicos) throws Exception {
        Registro reg = new Registro(rs);
        Registro tmp = Exportacao.selecionarExameDoPaciente(rs.getString("exa_codigo"), rs.getString("mco_codigo"), lay_codigo, req_anomes, req_idade);
        if (tmp != null) {
            reg.carregar(tmp);
            Map<String, Map<String, String>> his = ExameUtil.getHistoricos(rs.getString("exa_codigo"), Variaveis.filialPadrao);
            reg.setValor("historicos", his.isEmpty() ? historicos : his.get("historicoporcodigo"));
        } else {
            reg.setValor("exr_situacao", "semLayout");
        }
        reg.setValor("principios", Exportacao.getMedicamentoExame(req_codigo, rs.getString("exa_codigo"), rs.getString("mco_codigo")));
        reg.setValor("trocarModelo", Boolean.FALSE);
        return reg;
    }

    private static Registro selecionarExameDoPaciente(String exa_codigo, String mco_codigo, String lay_codigo, String req_anomes, String req_idade) throws Exception {
        Registro reg = null;
        Statement st = Conexao.getStatement();
        if (st != null) {
            int codLay = lay_codigo.matches("[0-9]+") ? Integer.parseInt(lay_codigo) : -1;
            StringBuilder bui = new StringBuilder();
            bui.append("select b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao, a.met_codigo ");
            bui.append("from examematcoleta a ");
            bui.append("left join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
            bui.append("where a.fil_codigo = ");
            bui.append(Variaveis.filialPadrao);
            bui.append(" and a.exa_codigo = '");
            bui.append(exa_codigo);
            bui.append("' and a.mco_codigo = ");
            bui.append(mco_codigo);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            int linha = 0;
            while (rs.next()) {
                boolean idadeZero;
                boolean padrao = rs.getBoolean("ela_padrao");
                int idIni = rs.getInt("ela_idadeini");
                int idFin = rs.getInt("ela_idadefim");
                String tpIni = rs.getString("ela_idadeinitipo");
                String tpFin = rs.getString("ela_idadefimtipo");
                boolean interValido = codLay == rs.getInt("lay_codigo") && Exportacao.intervaloValido(idIni, idFin, tpIni, tpFin, req_anomes, req_idade);
                boolean bl = idadeZero = codLay == rs.getInt("lay_codigo") && idIni == 0 && idFin == 0;
                if ((!padrao || linha != 0) && !idadeZero && !interValido) continue;
                linha = rs.getRow();
                if (!interValido) continue;
                break;
            }
            if (linha > 0) {
                rs.first();
                while (rs.getRow() < linha && rs.next()) {
                }
                reg = new Registro(rs);
                bui.delete(0, bui.length());
                bui.append("select a.elm_formato, b.met_codigo, b.met_descricao from examelayoutmetodo a ");
                bui.append("left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo ");
                bui.append("where a.fil_codigo = ");
                bui.append(Variaveis.filialPadrao);
                bui.append(" and a.exa_codigo = '");
                bui.append(exa_codigo);
                bui.append("' and a.mco_codigo = ");
                bui.append(mco_codigo);
                bui.append(" and a.lay_codigo = ");
                bui.append(rs.getString("lay_codigo"));
                bui.append(" and a.ela_idadeini = ");
                bui.append(rs.getString("ela_idadeini"));
                bui.append(" and a.ela_idadefim = ");
                bui.append(rs.getString("ela_idadefim"));
                bui.append(" and a.ela_idadefimtipo = '");
                bui.append(rs.getString("ela_idadefimtipo"));
                bui.append("' and a.ela_idadeinitipo = '");
                bui.append(rs.getString("ela_idadeinitipo"));
                bui.append("'");
                rs = Conexao.executeQuery(st, bui.toString());
                while (rs.next()) {
                    if (rs.getInt("met_codigo") != reg.getInt("met_codigo")) continue;
                    reg.setValor("formatoPadrao", rs.getString("elm_formato"));
                    break;
                }
                reg.setValor("metodos", new ModeloResultSet(rs, "C\u00f3digo", "met_codigo", "Descri\u00e7\u00e3o", "met_descricao"));
            }
        }
        return reg;
    }

    private static boolean intervaloValido(int idadeInicial, int idadeFinal, String tipoIni, String tipoFin, String req_anomes, String req_idade) throws Exception {
        String tipoIdade = req_anomes;
        int idadePaciente = Integer.parseInt(req_idade);
        if (tipoIdade != null) {
            int idPac = tipoIdade.equalsIgnoreCase("A") ? idadePaciente * 365 : (tipoIdade.equalsIgnoreCase("M") ? idadePaciente * 31 : idadePaciente);
            int idIni = tipoIni.equalsIgnoreCase("A") ? idadeInicial * 365 : (tipoIni.equalsIgnoreCase("M") ? idadeInicial * 31 : idadeInicial);
            int idFin = tipoFin.equalsIgnoreCase("A") ? idadeFinal * 365 : (tipoFin.equalsIgnoreCase("M") ? idadeFinal * 31 : idadeFinal);
            return idIni <= idPac && idPac <= idFin;
        }
        return false;
    }

    private static String getCabecalhoRodape(String codigoLayout) throws Exception {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder bui = new StringBuilder("select lay_cabec from layout where fil_codigo = ");
            bui.append(Variaveis.filialPadrao);
            bui.append(" and lay_codigo = ");
            bui.append(codigoLayout);
            ResultSet rs = Conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                String cabecalho = rs.getString("lay_cabec");
                Conexao.fecharStatement(st);
                return cabecalho;
            }
        }
        Conexao.fecharStatement(st);
        return "";
    }

    private static ResultSet getMedicamentoExame(String req_codigo, String exa_codigo, String mco_codigo) throws Exception {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder bui = new StringBuilder();
            bui.append("select a.mto_descricao, a.mto_indicacao, a.mto_interacao, d.prc_mensagem, d.prc_descricao, ");
            bui.append("e.exa_codigo, e.mco_codigo, e.exp_mensagem, e.exp_diminuif, e.exp_diminuia, e.exp_aumentof, e.exp_aumentoa ");
            bui.append("from medicamentos a ");
            bui.append("left join medprincipios b on a.mto_codigo = b.mto_codigo ");
            bui.append("left join requisicaomedicamento c on b.mto_codigo = c.mto_codigo and b.fil_codigo = c.fil_codigo ");
            bui.append("left join principios d on b.prc_codigo = d.prc_codigo and b.fil_codigo = d.fil_codigo ");
            bui.append("left join examesprincipios e on b.prc_codigo = e.prc_codigo ");
            bui.append("where c.req_codigo = ");
            bui.append(req_codigo);
            bui.append(" and e.fil_codigo = ");
            bui.append(Variaveis.filialPadrao);
            bui.append(" and e.exa_codigo = '");
            bui.append(exa_codigo);
            bui.append("' and e.mco_codigo = ");
            bui.append(mco_codigo);
            return Conexao.executeQuery(st, bui.toString());
        }
        return null;
    }
}

