/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.informacao.InfoPerguntaExame;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.ipmsaude.IPMSaudeService;
import jalis.integracaooperadoras.sistemas.ipmsaude.IntegracaoOperadoraIPMSaude;
import jalis.integracaooperadoras.sistemas.mksaude.IntegracaoOperadoraMKSaude;
import jalis.integracaooperadoras.sistemas.sdh.IntegracaoOperadoraSDH;
import jalis.integracaooperadoras.sistemas.simus.IntegracaoOperadoraSimus;
import jalis.integracaooperadoras.sistemas.sline.model.SLineService;
import jalis.integracaooperadoras.sistemas.sline.model.SLineVO;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.IntegracaoOperadoraGuaxupe;
import jalis.integracaooperadoras.sistemas.unimed.pr.IntegracaoOperadoraPR;
import jalis.integracaooperadoras.sistemas.unimed.sinos.IntegracaoOperadoraUnimedValeSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.upy.IntegracaoOperadoraUpy;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacao;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacaoWebIntegracao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ContadorCelulas;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.resultados.DialogoDadosRequisicao;
import jalis.laboratorio.interfaceamento.resultados.Exportacao;
import jalis.laboratorio.interfaceamento.resultados.PanelDadosBrutos;
import jalis.laboratorio.interfaceamento.resultados.PanelDadosBrutosRenderer;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.recepcao.util.SolicitarMotivoPrepIncorreto;
import jalis.laboratorio.resultados.DialogoConferenciaAutomatica;
import jalis.laboratorio.resultados.DialogoMedicamentos;
import jalis.laboratorio.resultados.DialogoObsDadosClinicos;
import jalis.laboratorio.resultados.DialogoResultadosAnteriores;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.model.bean.recepcao.ExameRequisicaoDadosBrutosBean;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.resultados.DialogoMedicamentosService;
import jalis.service.resultados.DialogoObservacaoService;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TAvisoLabel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class EditarResultado
extends JDialog
implements DigitacaoListener,
DisposeListener {
    private static final long PRONTOS_EXPORTAR = 1001003002L;
    public static final long EXPORTAR_REPETINDO = 1001003010L;
    static EditarResultado instancia;
    private GlassPaneMensagem glassPaneMensagem = new GlassPaneMensagem();
    JSplitPane jsMain = new JSplitPane(1);
    JPanel jPanelMain = new JPanel(new BorderLayout());
    JPanel jPanelDados = new JPanel(new GridBagLayout());
    JPanel jPanelFlags = new JPanel(new BorderLayout());
    JPanel jPanelBrutos = new JPanel(new BorderLayout());
    JList listDadosBrutos = new JList();
    private boolean mostraFlags = false;
    private boolean permitirContadorCelulas = false;
    private boolean permitirSalvar = true;
    private boolean mostraDadosBrutos = false;
    private boolean salvarEExportar = false;
    private Border titled = BorderFactory.createTitledBorder("");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelRequisicaoValor = new JLabel("");
    private JLabel labelPacienteValor = new JLabel("");
    private JLabel labelDataNascimento = new JLabel("Nasc.:");
    private JLabel labelDataNascimentoValor = new JLabel("");
    private JLabel labelExame = new JLabel("Exame:");
    private JLabel labelExameValor = new JLabel("");
    private JLabel labelIdade = new JLabel("Idade:");
    private JLabel labelIdadeValor = new JLabel("");
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelMaterialValor = new JLabel("");
    private JLabel labelDataColeta = new JLabel("Coleta:");
    private JLabel labelDataColetaValor = new JLabel("");
    private JLabel labelSexo = new JLabel("Sexo:");
    private TAvisoLabel labelSexoValor = new TAvisoLabel("");
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelConvenioValor = new JLabel("");
    private JLabel labelDestino = new JLabel("Destino:");
    private JLabel labelDestinoValor = new JLabel("");
    private JButton buttonDadosRequisicao = new JButton("...");
    private JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es \u25bc", 'O', null, null, null);
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem itemResultadosAnteriores = ComponenteFactory.novoJMenuItem("Resultados anteriores", null);
    private JMenuItem itemMedicamento = ComponenteFactory.novoJMenuItem("Medicamentos", null);
    private JMenuItem itemConferenciaAutomatica = ComponenteFactory.novoJMenuItem("Confer\u00eancia autom\u00e1tica", null);
    public JButton buttonPergunta = ComponenteFactory.novoJButton("Perguntas", 'P', null, null, null);
    private Color foregroundPergunta = this.buttonPergunta.getForeground();
    private Timer chamaAtencaoPerguntas = new Timer(500, action -> this.buttonPergunta.setForeground(this.buttonPergunta.getForeground() == this.foregroundPergunta ? Color.red : this.foregroundPergunta));
    private JButton jButtonObservacao = ComponenteFactory.novoJButton("Observa\u00e7\u00e3o", 'B', null, null, null);
    private Color foregroundObs = this.jButtonObservacao.getForeground();
    private Timer chamaAtencaoObs = new Timer(500, action -> this.jButtonObservacao.setForeground(this.jButtonObservacao.getForeground() == this.foregroundObs ? Color.red : this.foregroundObs));
    private JButton buttonIncorreto = ComponenteFactory.novoJButton("Prep. Incorreto", 't', null, null, null);
    private Color foregroundIncorreto = this.buttonIncorreto.getForeground();
    private Timer chamaAtencaoIncorreto = new Timer(500, action -> this.buttonIncorreto.setForeground(this.buttonIncorreto.getForeground() == this.foregroundIncorreto ? Color.red : this.foregroundIncorreto));
    private String retornoExportacao = "";
    String fil_codigo;
    String int_codigo;
    String req_codigo;
    String exa_codigo;
    String mco_codigo;
    String metCodigo;
    String rec_codigo;
    String pac_codigo;
    String pac_nome;
    String pac_sexo;
    String usr_codigo;
    String exa_descricao;
    String exr_resposta;
    String motivoIncorreto;
    AbstractInterfaceamento equip;
    Exame exame;
    Digitacao digi = null;
    String atributos;
    Map<Integer, String> res_anteriores;
    Map<String, Map<String, String>> historicos;
    JFrame parent;
    JButton jButtonExportar;
    JButton jButtonContador;
    ContadorCelulas contador;
    boolean conferido = Acesso.getAcesso(1001003007L);
    boolean fechou_salvar = false;
    boolean fechou_salvar_exportar = false;
    boolean isExportarValidados = false;
    boolean showConferenciaAutomatica = true;
    private HashMap<String, Object> mapaDadosAcoesExame = new HashMap();
    private String lay_codigo;
    private String elm_formato;
    private int met_codigo;
    private String resultadoAtual;
    private Map<String, Object> resposta;
    private boolean exportando = false;
    private transient Registro dadosReq = new Registro();

    public EditarResultado(JFrame parent, Statement st, String fil_codigo, String int_codigo, boolean isExportarValidados, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String pac_sexo, String usr_codigo, AbstractInterfaceamento equip, boolean permiteSalvar, boolean exportando, String metCodigo, GlassPaneMensagem glassPaneMensagem) {
        super(parent);
        instancia = this;
        this.glassPaneMensagem = glassPaneMensagem;
        this.isExportarValidados = isExportarValidados;
        this.mostraFlags = equip != null ? equip.mostraFlags() : false;
        this.mostraDadosBrutos = equip != null ? equip.digitarDadosBrutos() : false;
        this.parent = parent;
        try {
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.exa_codigo = exa_codigo;
            this.mco_codigo = mco_codigo;
            this.metCodigo = metCodigo;
            this.rec_codigo = rec_codigo;
            this.equip = equip;
            this.usr_codigo = usr_codigo;
            this.pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            this.pac_sexo = pac_sexo;
            this.permitirSalvar = permiteSalvar;
            this.jbInit(st, exportando);
            Laboratorio.getInstancia().addDisposeListener(this);
            this.mapaDadosAcoesExame.put("codigofilial", fil_codigo);
            this.mapaDadosAcoesExame.put("codigopaciente", this.pac_codigo);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public EditarResultado(JFrame parent, Statement st, String fil_codigo, String int_codigo, boolean isExportarValidados, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String pac_sexo, String usr_codigo, AbstractInterfaceamento equip, boolean permiteSalvar, boolean exportando, String metCodigo, boolean performance, String codigo_paciente) {
        super(parent);
        instancia = this;
        this.isExportarValidados = isExportarValidados;
        this.mostraFlags = equip != null ? equip.mostraFlags() : false;
        this.mostraDadosBrutos = equip != null ? equip.digitarDadosBrutos() : false;
        this.parent = parent;
        try {
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.exa_codigo = exa_codigo;
            this.mco_codigo = mco_codigo;
            this.metCodigo = metCodigo;
            this.rec_codigo = rec_codigo;
            this.equip = equip;
            this.usr_codigo = usr_codigo;
            this.pac_codigo = Funcoes.textoVazio(codigo_paciente) ? BDUtil.getCodigoPaciente(fil_codigo, req_codigo) : codigo_paciente;
            this.pac_sexo = pac_sexo;
            this.permitirSalvar = permiteSalvar;
            this.exportando = exportando;
            this.jbInitPerformance(st, exportando);
            this.mapaDadosAcoesExame.put("codigofilial", fil_codigo);
            this.mapaDadosAcoesExame.put("codigopaciente", this.pac_codigo);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public EditarResultado(JFrame parent, Statement st, String fil_codigo, String int_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String pac_sexo, String usr_codigo, AbstractInterfaceamento equip, boolean permitirContadorCelulas, boolean permitirSalvar, boolean exportando, String metCodigo) {
        super(parent);
        instancia = this;
        this.mostraFlags = equip != null ? equip.mostraFlags() : false;
        this.mostraDadosBrutos = equip != null ? equip.digitarDadosBrutos() : false;
        this.permitirContadorCelulas = permitirContadorCelulas;
        this.permitirSalvar = permitirSalvar;
        this.parent = parent;
        try {
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.exa_codigo = exa_codigo;
            this.mco_codigo = mco_codigo;
            this.metCodigo = metCodigo;
            this.rec_codigo = rec_codigo;
            this.equip = equip;
            this.usr_codigo = usr_codigo;
            this.pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            this.pac_sexo = pac_sexo;
            this.jbInit(st, exportando);
            Laboratorio.getInstancia().addDisposeListener(this);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public JMenuItem getItemConferenciaAutomatica() {
        return this.itemConferenciaAutomatica;
    }

    public JButton getButtonContador() {
        return this.jButtonContador;
    }

    private void jbInit(Statement st, boolean exportando) throws Exception {
        Registro rsRequisicao = BDUtil.getDadosRequisicao(this.fil_codigo, this.req_codigo);
        this.setGlassPane(this.glassPaneMensagem);
        ActionListener acaoPergunta = null;
        ActionListener acaoDadosRequisicao = null;
        ActionListener acaoExportar = null;
        ActionListener acaoContador = null;
        ActionListener acaoMedicamento = null;
        ActionListener acaoObservacao = null;
        ActionListener acaoIncorreto = null;
        ActionListener acaoConferenciaAutomatica = null;
        ActionListener acaoOpcoes = null;
        ActionListener acaoReqAnterior = null;
        if (!exportando) {
            this.getContentPane().setLayout(new BorderLayout());
            this.setResizable(false);
            this.setTitle("Resultado [" + this.exa_codigo + "] " + this.pac_nome);
            if (this.mostraDadosBrutos) {
                this.getContentPane().add((Component)this.jsMain, "Center");
                this.jsMain.add((Component)this.jPanelMain, 0);
            } else {
                this.getContentPane().add((Component)this.jPanelMain, "Center");
            }
            acaoConferenciaAutomatica = action -> {
                if (this.exame != null) {
                    String titulo = "Confer\u00eancia Autom\u00e1tica [" + this.exame.getValor("codigoexame") + "]";
                    DialogoConferenciaAutomatica dialogoConfAutomatica = new DialogoConferenciaAutomatica(Laboratorio.getInstancia(), titulo, this.fil_codigo, this.req_codigo, this.exame.getValor("codigoexame").toString(), this.mco_codigo);
                    dialogoConfAutomatica.setVisible(true);
                }
            };
            acaoExportar = action -> {
                if (!Funcoes.permiteConferirGerarPdf(this.fil_codigo)) {
                    return;
                }
                this.setSalvarEExportar(true);
                this.acaoSalvarEExportar();
            };
            acaoMedicamento = action -> {
                DialogoMedicamentos dm = DialogoMedicamentos.novaInstancia(this.parent, (ModeloResultSet)this.dadosReq.getValor("medicamentos"));
                if (this.isJDialogNotNull(dm)) {
                    dm.setVisible(true);
                }
            };
            acaoObservacao = action -> {
                String dados = Variaveis.tipoFilialPadrao.equals("A") ? this.dadosReq.getString("req_sanitariasproduto") : this.dadosReq.getString("req_dclinicos");
                DialogoObsDadosClinicos dobs = DialogoObsDadosClinicos.novaInstancia(this.parent, this.dadosReq.getString("req_obs"), dados);
                if (this.isJDialogNotNull(dobs)) {
                    dobs.setVisible(true);
                }
            };
            acaoContador = action -> this.acaoAbrirContador();
            acaoPergunta = action -> this.acaoAbrirPergunta();
            acaoDadosRequisicao = action -> this.acaoDadosRequisicao(rsRequisicao);
            acaoIncorreto = action -> this.acaoAbrirIncorreto();
            acaoReqAnterior = action -> this.visualizarResultadosAnteriores();
            acaoOpcoes = action -> this.menuOpcoes.show(this.buttonOpcoes, this.buttonOpcoes.getX(), this.buttonOpcoes.getY() + this.buttonOpcoes.getHeight() - 1);
        }
        this.exame = new Exame(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
        this.exame.putDados(ExameUtil.getDadosExameRequisicao(this.req_codigo, this.exa_codigo, this.mco_codigo, this.fil_codigo, false, false));
        this.mostraFlags = this.equip == null && this.exame.getFlags() != null && this.exame.getFlags().size() > 0 || this.equip != null && this.equip.mostraFlags();
        boolean bl = this.mostraDadosBrutos = this.equip != null && this.equip.digitarDadosBrutos();
        if (Variaveis.equip == null || !Variaveis.equip.configuracao.getNaoExibirDadosPaciente() && !exportando) {
            this.jPanelMain.add((Component)this.jPanelDados, "North");
            if (this.mostraFlags) {
                Dimension panelFlagsDimension = new Dimension(220, 550);
                this.jPanelFlags.setBorder(BorderFactory.createTitledBorder("Flags"));
                this.jPanelFlags.setPreferredSize(panelFlagsDimension);
                this.getContentPane().add((Component)new JScrollPane(this.jPanelFlags), "East");
            }
            if (this.mostraDadosBrutos) {
                Dimension panelBrutosDimension = new Dimension(520, 550);
                this.jPanelBrutos.setBorder(BorderFactory.createTitledBorder("Dados brutos"));
                this.jPanelBrutos.setPreferredSize(panelBrutosDimension);
                this.jPanelBrutos.add((Component)new JScrollPane(this.listDadosBrutos), "Center");
                this.listDadosBrutos.setCellRenderer(new PanelDadosBrutosRenderer());
                this.jsMain.add((Component)this.jPanelBrutos, 1);
            }
            Dimension d = new Dimension(100, 24);
            this.labelRequisicaoValor.setBorder(this.titled);
            this.labelRequisicaoValor.setSize(d);
            this.labelRequisicaoValor.setPreferredSize(d);
            this.labelRequisicaoValor.setMaximumSize(d);
            this.labelRequisicaoValor.setMinimumSize(d);
            d = new Dimension(10, 24);
            this.labelPacienteValor.setBorder(this.titled);
            this.labelPacienteValor.setSize(d);
            this.labelPacienteValor.setPreferredSize(d);
            d = new Dimension(100, 24);
            this.labelDataNascimentoValor.setBorder(this.titled);
            this.labelDataNascimentoValor.setSize(d);
            this.labelDataNascimentoValor.setPreferredSize(d);
            this.labelDataNascimentoValor.setMaximumSize(d);
            this.labelDataNascimentoValor.setMinimumSize(d);
            d = new Dimension(332, 24);
            this.labelExameValor.setBorder(this.titled);
            this.labelExameValor.setSize(d);
            this.labelExameValor.setPreferredSize(d);
            d = new Dimension(100, 24);
            this.labelIdadeValor.setBorder(this.titled);
            this.labelIdadeValor.setSize(d);
            this.labelIdadeValor.setPreferredSize(d);
            this.labelIdadeValor.setMaximumSize(d);
            this.labelIdadeValor.setMinimumSize(d);
            d = new Dimension(100, 24);
            this.labelMaterialValor.setBorder(this.titled);
            this.labelMaterialValor.setSize(d);
            this.labelMaterialValor.setPreferredSize(d);
            this.labelMaterialValor.setMaximumSize(d);
            this.labelMaterialValor.setMinimumSize(d);
            d = new Dimension(200, 24);
            this.labelDataColetaValor.setBorder(this.titled);
            this.labelDataColetaValor.setSize(d);
            this.labelDataColetaValor.setPreferredSize(d);
            this.labelDataColetaValor.setMaximumSize(d);
            this.labelDataColetaValor.setMinimumSize(d);
            d = new Dimension(100, 24);
            this.labelSexoValor.setBorder(this.titled);
            this.labelSexoValor.setSize(d);
            this.labelSexoValor.setPreferredSize(d);
            this.labelSexoValor.setMaximumSize(d);
            this.labelSexoValor.setMinimumSize(d);
            d = new Dimension(180, 24);
            this.labelConvenioValor.setBorder(this.titled);
            this.labelConvenioValor.setSize(d);
            this.labelConvenioValor.setPreferredSize(d);
            d = new Dimension(180, 24);
            this.labelDestinoValor.setBorder(this.titled);
            this.labelDestinoValor.setSize(d);
            this.labelDestinoValor.setPreferredSize(d);
            d = new Dimension(20, 20);
            this.buttonDadosRequisicao.setSize(d);
            this.buttonDadosRequisicao.setPreferredSize(d);
            StringBuilder aux = new StringBuilder();
            aux.append(Funcoes.preencheZero(this.fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
            aux.append(Funcoes.preencheZero(this.req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
            this.labelRequisicaoValor.setText(aux.toString());
            this.labelPacienteValor.setText(this.pac_nome);
            Object dt = BDUtil.getDataNacimentoPaciente(this.fil_codigo, this.req_codigo);
            if (dt != null) {
                this.labelDataNascimentoValor.setText(Funcoes.formataData("dd/MM/yyyy", (Date)dt));
            }
            this.exa_descricao = BDUtil.getExmDescricao(this.fil_codigo, this.exa_codigo);
            this.labelExameValor.setText(this.exa_descricao);
            this.labelIdadeValor.setText(this.getIdadeDescricao(rsRequisicao.getInt("req_idade"), rsRequisicao.getString("req_anomes")));
            this.labelMaterialValor.setText(BDUtil.getExameMatColetaDescricao(this.fil_codigo, this.exa_codigo, this.mco_codigo));
            dt = BDUtil.getExmColeta(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo);
            if (dt != null) {
                this.labelDataColetaValor.setText(Funcoes.formataData("dd/MM/yyyy HH:mm", (Date)dt));
            } else {
                this.labelDataColetaValor.setText("");
            }
            this.labelSexoValor.setText(Tipos.tipoSexo(this.pac_sexo));
            this.labelSexoValor.setGenero(EditarResultado.getGenero(this.fil_codigo, this.req_codigo));
            this.labelConvenioValor.setText(BDUtil.getNomeConvenio(this.fil_codigo, this.req_codigo));
            this.labelDestinoValor.setText(BDUtil.getNomeDestino(this.fil_codigo, this.req_codigo));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jPanelDados.add((Component)this.labelRequisicao, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jPanelDados.add((Component)this.labelRequisicaoValor, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            this.jPanelDados.add((Component)this.labelPacienteValor, gridBagConstraints);
            gridBagConstraints.gridx += 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            this.jPanelDados.add((Component)this.labelDataNascimento, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jPanelDados.add((Component)this.labelDataNascimentoValor, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.jPanelDados.add((Component)this.labelExame, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.jPanelDados.add((Component)this.labelExameValor, gridBagConstraints);
            gridBagConstraints.gridx += 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.jPanelDados.add((Component)this.labelIdade, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jPanelDados.add((Component)this.labelIdadeValor, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.jPanelDados.add((Component)this.labelMaterial, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jPanelDados.add((Component)this.labelMaterialValor, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jPanelDados.add((Component)this.labelDataColeta, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.jPanelDados.add((Component)this.labelDataColetaValor, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.jPanelDados.add((Component)this.labelSexo, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.jPanelDados.add((Component)this.labelSexoValor, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.jPanelDados.add((Component)this.labelConvenio, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            JPanel painelAux = new JPanel(new GridBagLayout());
            GridBagConstraints c2 = new GridBagConstraints();
            c2.anchor = 17;
            c2.gridx = 0;
            c2.gridy = 0;
            c2.weightx = 1.0;
            c2.fill = 2;
            painelAux.add((Component)this.labelConvenioValor, c2);
            c2.insets = new Insets(1, 1, 1, 1);
            c2.weightx = 0.0;
            ++c2.gridx;
            painelAux.add((Component)this.labelDestino, c2);
            ++c2.gridx;
            c2.weightx = 1.0;
            painelAux.add((Component)this.labelDestinoValor, c2);
            ++c2.gridx;
            c2.weightx = 0.0;
            painelAux.add((Component)this.buttonDadosRequisicao, c2);
            this.jPanelDados.add((Component)painelAux, gridBagConstraints);
            ++gridBagConstraints.gridx;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 7;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanelDados.add((Component)new JPanel(), gridBagConstraints);
        }
        if (!exportando) {
            this.jButtonExportar = ComponenteFactory.novoJButton("Salvar e Exportar", 'X', acaoExportar, null, null);
            this.jButtonContador = ComponenteFactory.novoJButton("Contador", 'C', acaoContador, null, null);
            this.buttonPergunta.addActionListener(acaoPergunta);
            this.buttonIncorreto.addActionListener(acaoIncorreto);
            this.buttonDadosRequisicao.addActionListener(acaoDadosRequisicao);
            this.jButtonObservacao.addActionListener(acaoObservacao);
            this.buttonOpcoes.addActionListener(acaoOpcoes);
            this.itemConferenciaAutomatica.addActionListener(acaoConferenciaAutomatica);
            this.itemMedicamento.addActionListener(acaoMedicamento);
            this.itemResultadosAnteriores.addActionListener(acaoReqAnterior);
        }
        Map<String, Object> dados = this.exame.getDados();
        if (this.mostraFlags && !exportando) {
            StringBuilder textoFlags = new StringBuilder();
            textoFlags.append("<html>");
            textoFlags.append("<ul>");
            for (String string : this.exame.getFlags()) {
                textoFlags.append("<li>").append(string).append("</li>");
            }
            textoFlags.append("</ul>");
            textoFlags.append("</html>");
            this.jPanelFlags.add((Component)new JLabel(textoFlags.toString()), "North");
        }
        if (this.mostraDadosBrutos && !exportando) {
            ExameRequisicaoDadosBrutosBean[] b = BDUtil.getDadosBrutosRequisicao(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo);
            DefaultListModel<PanelDadosBrutos> model = new DefaultListModel<PanelDadosBrutos>();
            if (b != null && b.length > 0) {
                for (ExameRequisicaoDadosBrutosBean bean : b) {
                    PanelDadosBrutos p = new PanelDadosBrutos(bean.getDataHora(), bean.getUsuario().getCodigo(), bean.getDadosBrutos());
                    model.addElement(p);
                }
            }
            this.listDadosBrutos.setModel(model);
        }
        this.met_codigo = BDUtil.getExameMetodo(this.fil_codigo, this.exa_codigo, this.mco_codigo, this.int_codigo);
        this.res_anteriores = ExameUtil.getResultadosAnteriores(this.fil_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, String.valueOf(this.met_codigo));
        if (rsRequisicao != null) {
            String con_codigo = rsRequisicao.getString("con_codigo");
            String des_codigo = rsRequisicao.getString("des_codigo");
            String string = rsRequisicao.getString("req_idade");
            String req_anomes = rsRequisicao.getString("req_anomes");
            Registro rs = BDUtil.getDadosExameRequisicaoJalisSemResultado(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo);
            if (rs != null) {
                boolean temResposta;
                DadosMaterial mat;
                DadosExames exa;
                String exr_situacao = rs.getString("exr_situacao");
                this.exr_resposta = rs.getString("exr_resposta");
                String string2 = this.motivoIncorreto = rs.getBoolean("exr_coletaincorreta") ? rs.getString("exr_motivocoletaincorreta") : "";
                if (this.met_codigo < 0) {
                    return;
                }
                boolean salvoParcial = exr_situacao.equalsIgnoreCase("P");
                this.lay_codigo = ExameUtil.getCodigoLayout(this.fil_codigo, con_codigo, des_codigo);
                this.elm_formato = ExameUtil.pegaLayoutIdade(this.fil_codigo, Integer.parseInt(string), req_anomes, this.lay_codigo, this.exa_codigo, Integer.parseInt(this.mco_codigo), this.met_codigo, "elm_formato");
                this.historicos = ExameUtil.getHistoricos(this.exa_codigo, this.fil_codigo);
                if (!this.historicos.isEmpty() && this.historicos.get("historicoporcodigo").isEmpty()) {
                    this.historicos = ExameUtil.getHistoricos(null, this.fil_codigo);
                }
                String exr_resultado = "";
                if (salvoParcial) {
                    exr_resultado = (String)BDUtil.getDadosExameRequisicaoJalisResultado(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo).getValor("exr_resultado");
                }
                this.atributos = salvoParcial ? exr_resultado : this.elm_formato;
                Map<String, Object> resposta = !Funcoes.textoVazio(this.exr_resposta) ? Resultado.getCamposResultado(this.exr_resposta) : null;
                this.digi = new Digitacao();
                this.digi.setTipoOrigemDigitacao(Digitacao.TipoOrigemDigitacao.DIGITACAO);
                dados.putAll(this.mapaDadosAcoesExame);
                this.digi.addDigitacaoListener(this);
                Resultado r = new Resultado(this.atributos, dados);
                Date data = (Date)this.exame.getValor("datacoletaexame");
                Date hora = (Date)this.exame.getValor("datacoletaexame");
                r.atualizarComponentes();
                this.resultadoAtual = r.getResultadoAnterior(data, hora);
                this.digi.carregarCampos(this.atributos, dados, resposta, this.historicos.get("historicoporcodigo"), this.historicos.get("historicopormnemonico"), this.res_anteriores, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, this.resultadoAtual);
                this.digi.exibirCheckBoxImprimir(false);
                this.digi.exibirBotaoSalvarParcial(false);
                this.digi.exibirBotaoFechar(true);
                this.digi.setDadosExame(this.exame.getDados());
                this.digi.adicionaListenerTabelaSimbolos(new TabelaSimbolosListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object simboloNaoLocalizado(String simbolo) {
                        Object retorno = null;
                        try {
                            Map valores = EditarResultado.this.getCamposJaDigitados(simbolo);
                            retorno = valores != null && valores.containsKey(simbolo.toUpperCase()) ? valores.get(simbolo.toUpperCase()) : null;
                            return retorno;
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(EditarResultado.this, "Erro ao buscar os resultados para consulta de express\u00e3o no resultado", e.getStackTrace(), "EditarResultado: 564");
                        }
                        finally {
                            return retorno;
                        }
                    }
                });
                if (Acesso.getAcesso(1001003002L)) {
                    this.digi.addBotao(this.jButtonExportar);
                }
                if (!this.permitirSalvar) {
                    this.jButtonExportar.setVisible(false);
                    this.digi.exibirBotaoSalvar(false);
                    this.digi.exibirBotaoSalvarParcial(false);
                }
                if (!(exa = ExameUtil.getDadosExameSimples(this.fil_codigo, this.exa_codigo, mat = new DadosMaterial(Integer.parseInt(this.mco_codigo), "", false, false))).getSalvarParcial()) {
                    this.digi.setVerificarCompleto(true);
                }
                if (this.permitirContadorCelulas || this.equip != null && this.equip.isContadorCelula()) {
                    this.digi.addBotao(this.jButtonContador);
                }
                boolean bl2 = temResposta = !Funcoes.textoVazio(this.exr_resposta);
                if (temResposta && !exportando) {
                    this.buttonPergunta.setFocusable(false);
                    this.digi.addBotao(this.buttonPergunta);
                    this.chamaAtencaoPerguntas.start();
                }
                this.carregaObservacao();
                this.carregaListaMedicamento();
                if (this.contemObservacao() && !exportando) {
                    this.jButtonObservacao.setFocusable(false);
                    this.digi.addBotao(this.jButtonObservacao);
                    this.chamaAtencaoObs.start();
                }
                if (this.possuiMotivoIncorreto()) {
                    this.digi.addBotao(this.buttonIncorreto);
                    this.chamaAtencaoIncorreto.start();
                }
                this.digi.addBotao(this.buttonOpcoes);
                if (!exportando && this.showConferenciaAutomatica) {
                    this.menuOpcoes.add(this.itemConferenciaAutomatica);
                }
                this.menuOpcoes.add(this.itemResultadosAnteriores);
                if (this.contemMedicamentos() && !exportando) {
                    this.menuOpcoes.add(this.itemMedicamento);
                }
                this.jPanelMain.add((Component)this.digi, "Center");
                Dimension dG = this.digi.getPreferredSize();
                Dimension dJ = this.getParent().getSize();
                dG = new Dimension(dG.width + 60 + (this.mostraFlags ? 208 : 0), dG.height + 158);
                if (this.mostraDadosBrutos) {
                    dG = new Dimension(dG.width + 60 + 440, dG.height + 158);
                }
                if (dG.width > dJ.width) {
                    dG.width = dJ.width;
                }
                if (dG.height > dJ.height) {
                    dG.height = dJ.height;
                }
                this.definirTeclas();
                this.setSize(dG);
                this.setPreferredSize(dG);
                this.setLocationRelativeTo(this.parent);
                this.setResizable(true);
                this.digi.setFocoPrimeiroCampo();
            }
        }
        SwingUtilities.invokeLater(() -> this.repaint());
    }

    private void visualizarResultadosAnteriores() {
        DialogoResultadosAnteriores dialogo = DialogoResultadosAnteriores.novaInstancia(this);
        if (dialogo != null) {
            boolean mostrar = false;
            mostrar = ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente() ? dialogo.setPacienteAutocopia(this, this.fil_codigo, this.pac_codigo, this.pac_nome, this.req_codigo) : dialogo.setPaciente(this, this.fil_codigo, this.pac_codigo, this.pac_nome, this.req_codigo);
            if (mostrar) {
                dialogo.setVisible(true);
            }
        }
    }

    private boolean isJDialogNotNull(JDialog jd) {
        return jd != null;
    }

    private boolean contemMedicamentos() {
        return null != this.dadosReq.getValor("medicamentos") && ((ModeloResultSet)this.dadosReq.getValor("medicamentos")).getRowCount() > 0;
    }

    private boolean contemObservacao() {
        boolean b = false;
        b = this.isFilialAlimentos() ? null != this.dadosReq.getValor("req_obs") && !this.dadosReq.getValor("req_obs").toString().isEmpty() || this.dadosReq.getValor("req_sanitariasproduto") != null && !this.dadosReq.getValor("req_sanitariasproduto").toString().isEmpty() : null != this.dadosReq.getValor("req_obs") && !this.dadosReq.getValor("req_obs").toString().isEmpty() || null != this.dadosReq.getValor("req_dclinicos") && !this.dadosReq.getValor("req_dclinicos").toString().isEmpty();
        return b;
    }

    private boolean isFilialAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private boolean isRequisicaoNulo(RequisicaoVO requisicaoVO) {
        return requisicaoVO == null;
    }

    private boolean isStatementNulo(Statement st) {
        return st == null;
    }

    private void carregaObservacao() {
        Statement st = Conexao.getStatement();
        if (!this.isStatementNulo(st)) {
            block5: {
                try {
                    RequisicaoVO requisicaoVO = new DialogoObservacaoService().carregarObservacao(st, this.fil_codigo, this.req_codigo);
                    if (this.isRequisicaoNulo(requisicaoVO)) break block5;
                    this.dadosReq.setValor("req_obs", requisicaoVO.getObservacao());
                    this.dadosReq.setValor("req_dclinicos", requisicaoVO.getDadosClinicos());
                    this.dadosReq.setValor("req_sanitariasproduto", requisicaoVO.getSanitariasProduto());
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditarResultado: 889");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    private void carregaListaMedicamento() {
        Statement st = Conexao.getStatement();
        if (!this.isStatementNulo(st)) {
            try {
                this.dadosReq.setValor("medicamentos", new DialogoMedicamentosService().carregarMedicamentos(st, this.fil_codigo, this.req_codigo));
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditarResultado: 904");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private boolean possuiResposta() {
        boolean temResposta = !Funcoes.textoVazio(this.exr_resposta);
        return this.equip != null && temResposta;
    }

    private boolean possuiMotivoIncorreto() {
        return !Funcoes.textoVazio(this.motivoIncorreto) && this.equip != null;
    }

    private void setSalvarEExportar(boolean salvarEExportar) {
        this.salvarEExportar = salvarEExportar;
    }

    private boolean isSalvarEExportar() {
        return this.salvarEExportar;
    }

    private void jbInitPerformance(Statement st, boolean exportando) throws Exception {
        Registro rsRequisicao = BDUtil.getDadosRequisicaoPerfomance(this.fil_codigo, this.req_codigo);
        this.exame = new Exame(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, true);
        this.exame.putDados(ExameUtil.getDadosExameRequisicao(this.req_codigo, this.exa_codigo, this.mco_codigo, this.fil_codigo, false, false));
        Map<String, Object> dados = this.exame.getDados();
        this.met_codigo = BDUtil.getExameMetodoPerformance(this.fil_codigo, this.exa_codigo, this.mco_codigo, this.int_codigo);
        this.res_anteriores = ExameUtil.getResultadosAnteriores(this.fil_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, String.valueOf(this.met_codigo));
        if (rsRequisicao != null) {
            String con_codigo = rsRequisicao.getString("con_codigo");
            String des_codigo = rsRequisicao.getString("des_codigo");
            String req_idade = rsRequisicao.getString("req_idade");
            String req_anomes = rsRequisicao.getString("req_anomes");
            Registro rs = BDUtil.getDadosExameRequisicaoJalisSemResultado(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo);
            if (rs != null) {
                String exr_situacao = rs.getString("exr_situacao");
                this.exr_resposta = rs.getString("exr_resposta");
                if (this.met_codigo < 0) {
                    return;
                }
                boolean salvoParcial = exr_situacao.equalsIgnoreCase("P");
                this.lay_codigo = ExameUtil.getCodigoLayout(this.fil_codigo, con_codigo, des_codigo);
                this.elm_formato = ExameUtil.pegaLayoutIdade(this.fil_codigo, Integer.parseInt(req_idade), req_anomes, this.lay_codigo, this.exa_codigo, Integer.parseInt(this.mco_codigo), this.met_codigo, "elm_formato");
                this.historicos = ExameUtil.getHistoricosPerformance(this.exa_codigo, this.fil_codigo);
                if (!this.historicos.isEmpty() && this.historicos.get("historicoporcodigo").isEmpty()) {
                    this.historicos = ExameUtil.getHistoricosPerformance(null, this.fil_codigo);
                }
                String exr_resultado = "";
                if (salvoParcial) {
                    exr_resultado = (String)BDUtil.getDadosExameRequisicaoJalisResultado(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo).getValor("exr_resultado");
                }
                this.atributos = salvoParcial ? exr_resultado : this.elm_formato;
                this.resposta = !Funcoes.textoVazio(this.exr_resposta) ? Resultado.getCamposResultado(this.exr_resposta) : null;
                this.digi = new Digitacao();
                this.digi.setTipoOrigemDigitacao(Digitacao.TipoOrigemDigitacao.DIGITACAO);
                dados.putAll(this.mapaDadosAcoesExame);
                this.digi.addDigitacaoListener(this);
                Date data = (Date)this.exame.getValor("exr_datamaterial");
                Date hora = (Date)this.exame.getValor("exr_datamaterial");
                Resultado r = new Resultado(this.atributos, dados);
                r.atualizarComponentes();
                this.resultadoAtual = r.getResultadoAnterior(data, hora);
                this.digi.carregarCampos(this.atributos, dados, this.resposta, this.historicos.get("historicoporcodigo"), this.historicos.get("historicopormnemonico"), this.res_anteriores, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, this.resultadoAtual);
                this.digi.setDadosExame(this.exame.getDados());
                if (this.exame.getValor("exa_salvaparcial") != null && !Boolean.valueOf(this.exame.getValor("exa_salvaparcial").toString()).booleanValue()) {
                    this.digi.setVerificarCompleto(true);
                }
            }
        }
    }

    public void setMostraFlags(boolean mostra) {
        this.mostraFlags = mostra;
    }

    public void setMostrarDadosBrutos(boolean mostrar) {
        this.mostraDadosBrutos = mostrar;
    }

    private Map<String, Object> getCamposJaDigitados(String simbolo) throws Exception {
        String exameAPesquisar;
        if (Funcoes.textoVazio(simbolo)) {
            return null;
        }
        String string = exameAPesquisar = simbolo.indexOf("_") > 0 ? simbolo.substring(0, simbolo.indexOf("_")) : "";
        if (Funcoes.textoVazio(exameAPesquisar)) {
            return null;
        }
        ArrayList<Registro> resultados = BDUtil.getResultadoExameRequisicaoJalis(this.fil_codigo, this.req_codigo, exameAPesquisar);
        HashMap<String, Object> campos = new HashMap<String, Object>();
        if (resultados != null && resultados.size() > 0) {
            for (Registro r : resultados) {
                String resultado = r.getString("exr_resultado");
                if (Funcoes.textoVazio(resultado)) continue;
                Map<String, Object> map = Resultado.getCamposResultado(resultado);
                for (String key : map.keySet()) {
                    campos.put((exameAPesquisar + "_" + key).toUpperCase(), map.get(key));
                }
            }
        }
        return campos.size() == 0 ? null : campos;
    }

    @Override
    public void acaoSalvar(DigitacaoEvento e) {
        if (!this.digi.verificarCondicao()) {
            Funcoes.showAlertaOK(this.parent, this.digi.getMensagemErro());
            this.digi.setFocoPrimeiroCampo();
            return;
        }
        try {
            if (!this.validaSituacaoExame()) {
                return;
            }
            if (this.digi.isModificou()) {
                ExameUtil.removeConferenciaAutomatica(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.int_codigo, "Usu\u00e1rio alterou laudo\n");
            }
            Statement st = Conexao.getStatement();
            String requisicao = this.req_codigo;
            List<BDExame> reqs = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, requisicao, this.rec_codigo);
            for (BDExame re : reqs) {
                BDUtil.getExmSituacao(this.fil_codigo, this.int_codigo, re.getRequisicao(), this.exa_codigo, this.mco_codigo, this.rec_codigo);
                this.req_codigo = re.getRequisicao();
                this.salvarExameInterfaceamento(st, true);
                BDUtil.setExmSituacaoEAssinatura(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, 7, Variaveis.login);
            }
            this.req_codigo = requisicao;
            Conexao.arquivaSQL();
            this.fechou_salvar = true;
            this.dispose();
        }
        catch (SQLException ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Digitacao getDigi() {
        return this.digi;
    }

    public void setDigi(Digitacao digi) {
        this.digi = digi;
    }

    public JMenuItem getItemMedicamento() {
        return this.itemMedicamento;
    }

    public void setButtonPerguntaVisible() {
        boolean temResposta;
        boolean bl = temResposta = !Funcoes.textoVazio(this.exr_resposta);
        if (temResposta && !this.exportando) {
            this.buttonPergunta.setFocusable(false);
            this.digi.addBotao(this.buttonPergunta);
            this.chamaAtencaoPerguntas.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acaoSalvarEExportar() {
        this.retornoExportacao = "";
        if (this.digi.resultadoNaoInformado()) {
            return;
        }
        try {
            DadosMaterial mat = new DadosMaterial(Integer.parseInt(this.mco_codigo), "", false, false);
            DadosExames exa = ExameUtil.getDadosExame(this.fil_codigo, this.exa_codigo, mat);
            this.exame.carregaDados(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, this.rec_codigo);
            this.digi.setDadosExame(this.exame.getDados());
            int sit = BDUtil.getExmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
            if (sit == 8 || sit == 11 || !this.validaSituacaoExame()) {
                return;
            }
            String resultadoAtual = "";
            resultadoAtual = this.digi.verificarCondicao() ? this.digi.getResultadoValidandoCamposRemover(true) : this.digi.getResultadoValidandoCamposRemover(false);
            if (!this.digi.verificarCondicao()) {
                this.retornoExportacao = this.digi.getMensagemErro();
                if (!this.isExportarValidados) {
                    Funcoes.showAlertaOK(this.parent, this.retornoExportacao);
                } else {
                    this.equip.adicionarExcecao("Valida\u00e7\u00e3o de resultado: Tubo: " + this.fil_codigo + "-" + this.req_codigo + "-" + this.rec_codigo + " Exame: " + this.exa_codigo + " - " + this.retornoExportacao);
                }
                this.digi.setFocoPrimeiroCampo();
            } else if (!exa.getSalvarParcial() && !this.digi.resultadoCompleto(false)) {
                this.retornoExportacao = "Valor de resultado n\u00e3o informado";
                if (!this.isExportarValidados) {
                    Funcoes.showErro(this, this.retornoExportacao);
                } else {
                    this.equip.adicionarExcecao("Valida\u00e7\u00e3o de resultado: Tubo: " + this.fil_codigo + "-" + this.req_codigo + "-" + this.rec_codigo + " Exame: " + this.exa_codigo + " - " + this.retornoExportacao);
                }
                this.digi.setFocoPrimeiroCampoVazio();
            } else {
                Resultado res = new Resultado(resultadoAtual, false);
                this.exportaExame(exa, resultadoAtual, res);
            }
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void exportaExame(DadosExames exa, String resultadoAtual, Resultado res) throws SQLException, Exception {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.digi.isModificou()) {
            ExameUtil.removeConferenciaAutomatica(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.int_codigo, "Usu?rio alterou laudo\n");
        }
        Statement st = Conexao.getStatement();
        String requisicao = this.req_codigo;
        List<BDExame> reqs = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, requisicao, this.rec_codigo);
        ArrayList<BDExame> semRepetir = new ArrayList<BDExame>();
        HashMap<String, BDExame> lista = new HashMap<String, BDExame>();
        for (BDExame re : reqs) {
            String chave;
            if (!re.getExame().equalsIgnoreCase(exa.getCodigo()) || lista.containsKey((chave = Funcoes.preencheZero(re.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + " " + re.getExame() + " " + re.getMaterial() + " " + re.getRecipiente()).toLowerCase())) continue;
            lista.put(chave.toLowerCase(), re);
            semRepetir.add(re);
        }
        if (this.isSalvarEExportar()) {
            this.usr_codigo = Variaveis.login;
        }
        for (BDExame re : semRepetir) {
            this.req_codigo = re.getRequisicao();
            int situacao = BDUtil.getExmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
            if (situacao == 8 || situacao == 11) continue;
            this.salvarExameInterfaceamento(st, true);
            BDUtil.setExmSituacao(st, this.fil_codigo, this.int_codigo, re.getRequisicao(), this.exa_codigo, this.mco_codigo, this.rec_codigo, 7);
            Exportacao.exportarExame(this.equip, st, this.fil_codigo, re.getRequisicao(), this.int_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, this.usr_codigo, res, resultadoAtual);
        }
        this.req_codigo = requisicao;
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
        this.fechou_salvar_exportar = true;
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acaoSalvarEExportarPerfomance() {
        this.retornoExportacao = "";
        Statement st = Conexao.getStatement();
        StringBuilder rollBack = new StringBuilder();
        try {
            int sitReq = BDUtil.getExmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
            if (this.exportando && (sitReq == 8 || sitReq == 11) || !this.validaSituacaoExame()) {
                return;
            }
            Map<String, Object> maps = ExportaWeb.getBaseWebEGeraPdf(st, this.fil_codigo);
            String baseWeb = (String)maps.get("fil_baseweb");
            boolean isGeraPdf = (Boolean)maps.get("fil_webpdf");
            StringBuilder sqlLogExportaPdfRollback = new StringBuilder();
            StringBuilder sqlLog = new StringBuilder();
            sqlLog.append("insert into exportapdf(est_codigo, fil_codigo, req_codigo, exa_codigo, mco_codigo, int_codigo, rec_codigo) values ( ");
            sqlLog.append(Variaveis.codigoEstacao).append(",");
            sqlLog.append(this.fil_codigo).append(",");
            sqlLog.append(this.req_codigo).append(",");
            sqlLog.append("'").append(this.exa_codigo).append("'").append(",");
            sqlLog.append(this.mco_codigo).append(",");
            sqlLog.append(this.int_codigo).append(",");
            sqlLog.append(this.rec_codigo);
            sqlLog.append(" );");
            sqlLogExportaPdfRollback.append("delete from exportapdf where fil_codigo = ").append(this.fil_codigo);
            sqlLogExportaPdfRollback.append(" and req_codigo = ").append(this.req_codigo);
            sqlLogExportaPdfRollback.append(" and exa_codigo = '").append(this.exa_codigo).append("' ");
            sqlLogExportaPdfRollback.append(" and mco_codigo = ").append(this.mco_codigo);
            if (!Funcoes.textoVazio(this.int_codigo)) {
                sqlLogExportaPdfRollback.append(" and int_codigo = ").append(this.int_codigo);
            }
            if (!Funcoes.textoVazio(this.rec_codigo)) {
                sqlLogExportaPdfRollback.append(" and rec_codigo = ").append(this.rec_codigo);
            }
            sqlLogExportaPdfRollback.append(" and est_codigo = ").append(Variaveis.codigoEstacao).append("; ");
            DadosMaterial mat = new DadosMaterial(Integer.parseInt(this.mco_codigo), "", false, false);
            DadosExames exa = new DadosExames("" + this.exame.getValor("codigoexame"), "" + this.exame.getValor("descricaoexame"), (Boolean)this.exame.getValor("exa_salvaparcial"));
            this.digi.setDadosExame(this.exame.getDados());
            String resultadoAtual = this.digi.getResultadoValidandoCamposRemover(true);
            if (!this.digi.verificarCondicao() && this.equip != null) {
                st.execute(sqlLogExportaPdfRollback.toString());
                this.retornoExportacao = this.digi.getMensagemErro();
                this.equip.adicionarExcecao("Valida\u00e7\u00e3o de resultado: Tubo: " + this.fil_codigo + "-" + this.req_codigo + "-" + this.rec_codigo + " Exame: " + this.exa_codigo + " - " + this.retornoExportacao);
            } else if (!exa.getSalvarParcial() && !this.digi.resultadoCompleto(false) && this.equip != null) {
                st.execute(sqlLogExportaPdfRollback.toString());
                this.retornoExportacao = "Valor de resultado n\u00e3o informado";
                this.equip.adicionarExcecao("Valida\u00e7\u00e3o de resultado: Tubo: " + this.fil_codigo + "-" + this.req_codigo + "-" + this.rec_codigo + " Exame: " + this.exa_codigo + " - " + this.retornoExportacao);
            } else {
                if (this.digi.isModificou()) {
                    StringBuilder log = new StringBuilder("Usu\u00e1rio alterou laudo\n");
                    log.append("Data/Hora: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.getDataHoraAtual()));
                    log.append(".\nRemovido valida\u00e7\u00e3o do exame pelo usu\u00e1rio ").append(Variaveis.login).append("\n=================\n");
                    StringBuilder buf = new StringBuilder();
                    StringBuilder where = new StringBuilder();
                    where.append(" where fil_codigo = ").append(this.fil_codigo);
                    where.append("   and req_codigo = ").append(this.req_codigo);
                    where.append("   and exa_codigo = '").append(this.exa_codigo).append("' ");
                    where.append("   and mco_codigo = ").append(this.mco_codigo);
                    where.append("   and int_codigo = ").append(this.int_codigo);
                    buf.append("update interfaceexamerequisicao set ier_logconfautomatica = coalesce(ier_logconfautomatica, '')||");
                    buf.append(StringUtil.textoDBEscape(log.toString()));
                    buf.append(" , ier_confautomatica = ").append(false);
                    buf.append((CharSequence)where);
                    Conexao.executeUpdatePerformance(this.fil_codigo, st, buf.toString());
                }
                String requisicao = this.req_codigo;
                List<BDExame> reqs = BDUtil.getReqExamesMultGuiaPerformance(this.fil_codigo, this.int_codigo, requisicao, this.rec_codigo);
                ArrayList<BDExame> semRepetir = new ArrayList<BDExame>();
                HashMap<String, BDExame> lista = new HashMap<String, BDExame>();
                for (BDExame re : reqs) {
                    String chave;
                    if (!re.getExame().equalsIgnoreCase(exa.getCodigo()) || lista.containsKey((chave = Funcoes.preencheZero(re.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + " " + re.getExame() + " " + re.getMaterial() + " " + re.getRecipiente()).toLowerCase())) continue;
                    lista.put(chave.toLowerCase(), re);
                    semRepetir.add(re);
                }
                if (this.isSalvarEExportar()) {
                    this.usr_codigo = Variaveis.login;
                }
                if (semRepetir != null && !semRepetir.isEmpty()) {
                    for (BDExame re : semRepetir) {
                        this.req_codigo = re.getRequisicao();
                        int sitMultGuias = BDUtil.getExmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
                        if (sitMultGuias == 8) continue;
                        String valor = "";
                        if (this.exame.getValor("enderecoPorta") != null) {
                            valor = this.exame.getValor("enderecoPorta").toString();
                        }
                        this.exame.clearDados();
                        if (!Funcoes.textoVazio(valor)) {
                            this.exame.setValor("enderecoPorta", valor);
                        }
                        this.exame.putDados(this.digi.getCamposInterfaceamento());
                        this.exame.putDados(this.mapaDadosAcoesExame);
                        this.exame.getDados().put("flag", StringUtil.tratarEntidadesHTML(StringUtil.getXMLDeList(this.exame.getFlags())));
                        String ier_xmlvalores = StringUtil.getXMLDeMap(this.exame.getDados());
                        BDUtil.setExmXmlValoresESituacaoPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, ier_xmlvalores, this.exame.getSituacaoExame());
                        if (this.exame.isDesmembrado()) {
                            Set<ExameMaterial> keyset = this.exame.getSituacoes_membros().keySet();
                            for (ExameMaterial f : keyset) {
                                String exa_kodigo = f.getNomeExame();
                                String mco_kodigo = f.getCodigoMaterial();
                                Integer erd_situacao = this.exame.getSituacoes_membros().get(f);
                                BDUtil.setDesmSituacaoPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, exa_kodigo, mco_kodigo, erd_situacao);
                            }
                        }
                        BDUtil.setExmSituacaoPerformance(st, this.fil_codigo, this.int_codigo, re.getRequisicao(), this.exa_codigo, this.mco_codigo, this.rec_codigo, 7, null);
                        String retorno = "";
                        ResultSet rs = Exportacao.getUnicoValidadoPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.equip == null || this.equip != null && !this.equip.configuracao.getNaoProcessarRespostasExames());
                        if (rs == null || !rs.next()) continue;
                        rollBack.append("update interfaceexamerequisicao set ier_situacao = ").append(rs.getInt("ier_situacao")).append(", ier_confautomatica = ").append(rs.getBoolean("ier_confautomatica")).append(" where fil_codigo = ").append(this.fil_codigo).append(" and req_codigo = ").append(this.req_codigo).append(" and int_codigo = ").append(this.int_codigo).append(" and mco_codigo = ").append(this.mco_codigo).append(" and exa_codigo = '").append(this.exa_codigo).append("';");
                        rollBack.append("update examerequisicao set exr_situacao = '").append(rs.getString("exr_situacao")).append("' ").append(", exr_resultado = '").append(rs.getString("exr_resultado")).append("' ").append(" where fil_codigo = ").append(this.fil_codigo).append(" and req_codigo = ").append(this.req_codigo).append(" and mco_codigo = ").append(this.mco_codigo).append(" and exa_codigo = '").append(this.exa_codigo).append("';");
                        rollBack.append(sqlLogExportaPdfRollback.toString());
                        String con_codigo = rs.getString("con_codigo");
                        String des_codigo = rs.getString("des_codigo");
                        int req_idade = rs.getInt("req_idade");
                        String req_anomes = rs.getString("req_anomes");
                        String metCodigo = rs.getString("met_codigo");
                        String situacao = BDUtil.getReqSituacaoPerformance(this.fil_codigo, this.req_codigo, this.exa_codigo, Integer.parseInt(this.mco_codigo));
                        if (Funcoes.textoVazio(situacao) || situacao.equals("P") || !this.exportando) {
                            boolean situacaoCompulsoria;
                            if (this.met_codigo < 0) {
                                st.execute(sqlLogExportaPdfRollback.toString());
                                this.equip.adicionarExcecao("N\u00e3o foi poss\u00edvel encontrar o m\u00e9todo do Exame");
                                return;
                            }
                            this.digi.getResultadoDigitacao().atualizarComponentes();
                            String resultadoAux = Funcoes.textoVazio(resultadoAtual) ? this.digi.getResultado() : resultadoAtual;
                            String string = resultadoAux = Funcoes.textoVazio(resultadoAux) ? this.elm_formato : resultadoAux;
                            if (!this.digi.getResultadoDigitacao().verificarCondicao()) {
                                retorno = "Requisi\u00e7\u00e3o: " + this.req_codigo + ", Exame: " + this.exa_codigo;
                                retorno = retorno + " - N\u00e3o pode ser exportado por n\u00e3o satisfazer as condi\u00e7\u00f5es do exame.";
                                if (this.equip != null) {
                                    this.equip.adicionarExcecao(retorno);
                                    this.equip.novaMensagem(retorno, 1, 5000);
                                }
                                st.execute(sqlLogExportaPdfRollback.toString());
                                return;
                            }
                            boolean res_completo = true;
                            if (exa.getSalvarParcial()) {
                                res_completo = this.digi.getResultadoDigitacao().resultadoCompleto(true);
                            }
                            String resultado = res_completo ? resultadoAux : this.digi.getResultadoDigitacao().getResultadoParcial();
                            boolean validacaoResultadoCritico = this.digi.verificarValidacaoResuldoCritico() == 1;
                            boolean bl = situacaoCompulsoria = this.digi.verificarValidacaoCompulsoria() == 1;
                            if (res_completo) {
                                StringBuilder query = new StringBuilder();
                                Date dataAssinatura = new Date();
                                query.append("update examerequisicao set ");
                                if (this.conferido) {
                                    query.append("exr_dataassina = current_timestamp, ");
                                }
                                query.append("exr_datadigita = current_timestamp ");
                                if (!this.conferido) {
                                    query.append(", exr_resultado = ").append(DBUtil.bdText(resultado));
                                }
                                query.append(", exr_situacao = '");
                                query.append(this.conferido ? "C" : "L");
                                query.append("',usr_coddigitador = ");
                                query.append(DBUtil.bdText(this.usr_codigo));
                                query.append(" ,met_codigo = ").append(metCodigo);
                                if (this.conferido) {
                                    query.append(", usr_codassina = ");
                                    query.append(DBUtil.bdText(this.usr_codigo));
                                }
                                query.append(", exr_dataresultadocritico = ").append(validacaoResultadoCritico ? "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date()) + "'" : "null");
                                query.append(", exr_compulsorio = ").append(situacaoCompulsoria);
                                query.append(" where fil_codigo = ");
                                query.append(this.fil_codigo);
                                query.append(" and req_codigo = ");
                                query.append(this.req_codigo);
                                query.append(" and exa_codigo = '");
                                query.append(this.exa_codigo);
                                query.append("' and mco_codigo = ");
                                query.append(this.mco_codigo);
                                DBUtil.gravaLogSituacaoExameRequisicaoPerformance(st, this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.conferido ? "C" : "L", false);
                                Conexao.executeUpdatePerformance(this.fil_codigo, st, query.toString());
                                BDUtil.setExmSituacaoEAssinaturaPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.rec_codigo, 11, this.usr_codigo);
                                BDUtil.setExmSituacaoTodosFilhosPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.rec_codigo, 11);
                                HashMap<Object, Object> mapParams = new HashMap<Object, Object>();
                                if (this.exportando || !Funcoes.textoVazio(sqlLog.toString())) {
                                    mapParams.put("insertexportapdf", sqlLog.toString());
                                }
                                query.delete(0, query.length());
                                Date data = (Date)this.exame.getValor("exr_datamaterial");
                                Date hora = (Date)this.exame.getValor("exr_datamaterial");
                                String date = Funcoes.formataData("MM/dd/yyyy", data == null ? new Date() : data);
                                String time = Funcoes.formataData("HH:mm:ss.SSS", hora == null ? new Date() : hora);
                                String resultadoDoExame = this.digi.getResultadoDigitacao().getResultadoAnterior(data, hora);
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("fil_codigo", this.fil_codigo);
                                params.put("pac_codigo", this.pac_codigo);
                                params.put("exa_codigo", this.exa_codigo);
                                params.put("mco_codigo", this.mco_codigo);
                                params.put("met_codigo", metCodigo);
                                params.put("exc_data", date);
                                params.put("exc_hora", time);
                                params.put("req_codigo", this.req_codigo);
                                params.put("exc_resultado", resultadoDoExame);
                                ExameUtil.deletaExamesControlePerformance(params, st);
                                ExameUtil.insereExameControlePerformance(params, st, true);
                                if (this.conferido) {
                                    mapParams.put("baseWeb", baseWeb);
                                    mapParams.put("roolback", rollBack.toString());
                                    mapParams.put("assinarXml", true);
                                    mapParams.put("fil_codigo", this.fil_codigo);
                                    mapParams.put("req_codigo", this.req_codigo);
                                    mapParams.put("exa_codigo", this.exa_codigo);
                                    mapParams.put("mco_codigo", this.mco_codigo);
                                    mapParams.put("int_codigo", this.int_codigo);
                                    mapParams.put("rec_codigo", this.rec_codigo);
                                    mapParams.put("usr_codigo", this.usr_codigo);
                                    mapParams.put("situacao", situacao);
                                    mapParams.put("req_idade", req_idade);
                                    mapParams.put("req_anomes", req_anomes);
                                    mapParams.put("lay_codigo", this.lay_codigo);
                                    mapParams.put("met_codigo", this.met_codigo);
                                    mapParams.put("con_codigo", con_codigo);
                                    mapParams.put("resultado", resultado);
                                    mapParams.put("pac_nome", this.pac_nome);
                                    mapParams.put("pac_sexo", this.pac_sexo);
                                    mapParams.put("dataAssinatura", dataAssinatura);
                                    mapParams.put("isGeraPdf", isGeraPdf);
                                    mapParams.put("componentes", this.digi.getResultadoDigitacao().getComponentes());
                                    ThreadInterfaceExportacaoWebIntegracao.addLog(mapParams);
                                    Exportacao.invocaAcoesConferencia(resultado, params);
                                }
                                ExameUtil.atualizaDadosConferenciaAutomaticaPerformance(this.fil_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.int_codigo);
                            } else {
                                Exportacao.salvarParcialPerformance(st, this.fil_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.usr_codigo, DBUtil.bdText(resultado), situacaoCompulsoria, validacaoResultadoCritico);
                            }
                            if (this.conferido) {
                                String tipoIntegracaoOperadoraConvenio;
                                if (ParametrosGerais.isIntegracaoIds() && IntegracaoIDSSaude.temCodigoIDS(this.fil_codigo, this.req_codigo)) {
                                    IntegracaoIDSSaude.adicionarLog(st, Integer.parseInt(this.fil_codigo), Integer.parseInt(this.req_codigo), this.exa_codigo, Integer.parseInt(this.mco_codigo));
                                }
                                if (!Funcoes.textoVazio(tipoIntegracaoOperadoraConvenio = new ConvenioService().getTipoIntegracaoOperadoraSaude(this.fil_codigo, con_codigo))) {
                                    if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("U")) {
                                        IntegracaoOperadoraUpy.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("V")) {
                                        IntegracaoOperadoraUnimedVTRP.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("M")) {
                                        IntegracaoOperadoraMKSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_LAUDO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("D")) {
                                        IntegracaoOperadoraSDH.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo, "codGuia", this.dadosReq.getString("req_guia")});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("S")) {
                                        ValeDosSinosDTO valeDosSinosDTO = new ValeDosSinosDTO(this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo);
                                        IntegracaoOperadoraUnimedValeSinos.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), valeDosSinosDTO, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("P")) {
                                        IPMSaudeService ipmSaudeService = new IPMSaudeService();
                                        Registro dadosReq = ipmSaudeService.getInformacaoRequisicao(this.fil_codigo, this.req_codigo);
                                        if (!(Funcoes.objectIsNull(dadosReq) || Funcoes.textoVazio(dadosReq.getString("req_codigoipm")) || Funcoes.textoVazio(dadosReq.getString("exr_codigoipm")))) {
                                            IntegracaoOperadoraIPMSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo, "codGuia", dadosReq.getString("req_guia")});
                                        }
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS.getCodigo())) {
                                        IntegracaoOperadoraSimus.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR.getCodigo())) {
                                        IntegracaoOperadoraPR.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE.getCodigo())) {
                                        IntegracaoOperadoraGuaxupe.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, con_codigo, this.req_codigo, this.pac_codigo, this.exa_codigo, this.mco_codigo, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo});
                                    } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE.getCodigo())) {
                                        SLineVO vo = new SLineVO.SlineVoBuilder().filial(this.fil_codigo).requisicao(this.req_codigo).convenio(con_codigo).paciente(this.pac_codigo).exame(this.exa_codigo).material(this.mco_codigo).build();
                                        new SLineService().inserirIntegracaoOperadora(vo);
                                    } else {
                                        AbstractIntegracaoOperadora.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.fil_codigo, this.dadosReq.getString("con_codigo"), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), "filial", this.fil_codigo, "codreq", this.req_codigo, "codexa", this.exa_codigo, "codmat", this.mco_codigo);
                                    }
                                }
                            }
                            BDUtil.setExmSituacaoEAssinaturaPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.rec_codigo, 11, this.usr_codigo);
                            BDUtil.setExmSituacaoTodosFilhosPerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.rec_codigo, 11);
                            HashMap<Object, Object> mapParams = new HashMap<Object, Object>();
                            if (this.exportando || !Funcoes.textoVazio(sqlLog.toString())) {
                                mapParams.put("insertexportapdf", sqlLog.toString());
                            }
                            if (this.equip != null && this.equip.configuracao != null && this.equip.configuracao.getRemoverOutrosRecipientesDaInterfaceNaExportacao()) {
                                BDUtil.cancelaExameInterfacePerformance(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.rec_codigo, 10);
                            }
                            if (!(situacao = BDUtil.getReqSituacaoPerformance(this.fil_codigo, this.req_codigo, this.exa_codigo, Integer.parseInt(this.mco_codigo))).equals("P")) {
                                ArrayList<String> interfaces = BDUtil.getInterfacesExamePerformance(this.fil_codigo, this.exa_codigo, this.mco_codigo);
                                for (String i : interfaces) {
                                    if (i.equalsIgnoreCase(this.int_codigo)) continue;
                                    BDUtil.deletarExameInterfacePerformance(st, this.fil_codigo, i, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.rec_codigo);
                                }
                            }
                            mapParams.put("baseWeb", baseWeb);
                            mapParams.put("roolback", rollBack.toString());
                            mapParams.put("fil_codigo", this.fil_codigo);
                            mapParams.put("req_codigo", this.req_codigo);
                            mapParams.put("exa_codigo", this.exa_codigo);
                            mapParams.put("mco_codigo", this.mco_codigo);
                            mapParams.put("situacao", situacao);
                            mapParams.put("req_idade", req_idade);
                            mapParams.put("req_anomes", req_anomes);
                            mapParams.put("lay_codigo", this.lay_codigo);
                            mapParams.put("met_codigo", this.met_codigo);
                            mapParams.put("con_codigo", con_codigo);
                            mapParams.put("resultado", resultado);
                            mapParams.put("assinarXml", false);
                            mapParams.put("isGeraPdf", isGeraPdf);
                            mapParams.put("int_codigo", this.int_codigo);
                            mapParams.put("rec_codigo", this.rec_codigo);
                            mapParams.put("usr_codigo", this.usr_codigo);
                            mapParams.put("historicoporcodigo", this.historicos.get("historicoporcodigo"));
                            ThreadInterfaceExportacaoWebIntegracao.addLog(mapParams);
                            HashMap<Object, Object> mapParams2 = new HashMap<Object, Object>();
                            if (this.exportando || !Funcoes.textoVazio(sqlLog.toString())) {
                                mapParams2.put("insertexportapdf", sqlLog.toString());
                            }
                            mapParams2.put("baseWeb", baseWeb);
                            mapParams2.put("roolback", rollBack.toString());
                            mapParams2.put("fil_codigo", this.fil_codigo);
                            mapParams2.put("req_codigo", this.req_codigo);
                            mapParams2.put("exa_codigo", this.exa_codigo);
                            mapParams2.put("mco_codigo", this.mco_codigo);
                            mapParams2.put("pac_codigo", this.pac_codigo);
                            mapParams2.put("situacao", situacao);
                            mapParams2.put("req_idade", req_idade);
                            mapParams2.put("req_anomes", req_anomes);
                            mapParams2.put("lay_codigo", this.lay_codigo);
                            mapParams2.put("met_codigo", this.met_codigo);
                            mapParams2.put("con_codigo", con_codigo);
                            mapParams2.put("assinarXml", false);
                            mapParams2.put("isGeraPdf", isGeraPdf);
                            mapParams2.put("int_codigo", this.int_codigo);
                            mapParams2.put("rec_codigo", this.rec_codigo);
                            mapParams2.put("usr_codigo", this.usr_codigo);
                            mapParams2.put("iSGerarOperadoraSaude", true);
                            ThreadInterfaceExportacaoWebIntegracao.addLog(mapParams2);
                            continue;
                        }
                        String sit = Tipos.tipoSituacaoExame(situacao);
                        retorno = "Requisi\u00e7\u00e3o: " + this.req_codigo + ", Exame: " + this.exa_codigo + " - N\u00e3o pode ser exportado por encontrar-se como \"" + sit + "\"";
                        if (this.equip == null) continue;
                        this.equip.adicionarExcecao(retorno);
                        this.equip.novaMensagem(retorno, 1, 5000);
                    }
                } else {
                    Conexao.executePerformance(this.fil_codigo, Conexao.getStatement(), sqlLogExportaPdfRollback.toString(), true);
                }
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
                Conexao.executePerformance(this.fil_codigo, Conexao.getStatement(), rollBack.toString(), true);
                Conexao.arquivaSQL();
                ThreadInterfaceExportacaoWebIntegracao.stopThread();
                ThreadInterfaceExportacao.stopThread();
                this.equip.adicionarExcecao(ex.getMessage());
                ex.printStackTrace();
            }
            catch (SQLException ex1) {
                this.equip.adicionarExcecao(ex1.getMessage());
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException sQLException) {
            Conexao.fecharStatement(st);
            this.fechou_salvar_exportar = true;
            this.dispose();
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            this.fechou_salvar_exportar = true;
            this.dispose();
            throw throwable;
        }
        Conexao.fecharStatement(st);
        this.fechou_salvar_exportar = true;
        this.dispose();
    }

    public static EditarResultado getInstancia() {
        return instancia;
    }

    public void adicionarComponenteMensagem(JComponent componente, String mensagem, int posicao, boolean quebrarLinha) {
        if (this.getRootPane() != null && (this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || this.getRootPane().getGlassPane() instanceof JPanel) && componente != null && mensagem != null && !Funcoes.textoVazio(mensagem)) {
            this.glassPaneMensagem.adicionarComponenteMensagem(componente, mensagem, posicao, quebrarLinha);
        }
    }

    public void setComponenteMensagemVisivel(boolean isVisible) {
        if (this.getRootPane() != null && (this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || this.getRootPane().getGlassPane() instanceof JPanel)) {
            this.glassPaneMensagem.setVisible(isVisible);
        }
    }

    public void removerComponenteMensagem(JComponent componente) {
        if (this.getRootPane() != null && (this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || this.getRootPane().getGlassPane() instanceof JPanel) && componente != null) {
            this.glassPaneMensagem.removerComponenteMensagem(componente);
        }
    }

    public String getRetornoExportacao() {
        return this.retornoExportacao;
    }

    public void setRetornoExportacao(String retornoExportacao) {
        this.retornoExportacao = retornoExportacao;
    }

    public void acaoAbrirContador() {
        Map<String, Object> dados = this.digi.getCamposInterfaceamento();
        this.contador = new ContadorCelulas(this.parent, dados);
        DialogUtil.centerAndShow(this.contador, true, false);
        if (this.contador.fechouOK()) {
            this.exame.putDados(this.contador.getResults());
            this.exame.putDados(this.mapaDadosAcoesExame);
            this.digi.carregarCampos(this.atributos, this.exame.getDados(), null, this.historicos.get("historicoporcodigo"), this.historicos.get("historicopormnemonico"), this.res_anteriores, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1);
            this.digi.revalidate();
        }
        this.digi.setFocoPrimeiroCampo();
    }

    @Override
    public void acaoSalvarParcial(DigitacaoEvento e) {
    }

    @Override
    public void acaoFechar(DigitacaoEvento e) {
        this.dispose();
    }

    public void salvarExameInterfaceamento(Statement st, boolean recarregarDados) throws SQLException {
        if (recarregarDados) {
            String valor = "";
            if (this.exame.getValor("enderecoPorta") != null) {
                valor = this.exame.getValor("enderecoPorta").toString();
            }
            this.exame.clearDados();
            if (!Funcoes.textoVazio(valor)) {
                this.exame.setValor("enderecoPorta", valor);
            }
            this.exame.putDados(this.digi.getCamposInterfaceamento());
        }
        this.exame.putDados(this.mapaDadosAcoesExame);
        this.exame.salvaDados(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
        if (this.digi.possuiCamposForaDaReferencia()) {
            BDUtil.setValorAlterado(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, 1);
        } else {
            BDUtil.setValorAlterado(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo, 0);
        }
    }

    public void salvarDadosRequisicao(Statement st) throws SQLException, NoSuchAlgorithmException, SalvaDadosException, CertificadoException, Exception {
        boolean validacaoResultadoCritico;
        DadosExames exa = ExameUtil.getDadosExame(this.fil_codigo, this.exa_codigo, new DadosMaterial(Integer.parseInt(this.mco_codigo), "", false, false));
        boolean res_completo = true;
        if (exa.getSalvarParcial()) {
            res_completo = this.digi.resultadoCompleto(true);
        }
        String resultado = res_completo ? this.digi.getResultado() : this.digi.getResultadoParcial();
        boolean situacaoCompulsoria = this.digi.verificarValidacaoCompulsoria() == 1;
        boolean bl = validacaoResultadoCritico = this.digi.verificarValidacaoResuldoCritico() == 1;
        if (res_completo) {
            Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? (Date)this.exame.getValor("dataColetaExame") : new Date();
            Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? (Date)this.exame.getValor("dataColetaExame") : new Date();
            Exportacao.salvarResultado(st, this.fil_codigo, this.pac_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.usr_codigo, resultado, this.digi.getResultadoAnterior(dataColeta, horaColeta), dataColeta, horaColeta, this.conferido, exa.getCodMetodo(), situacaoCompulsoria, validacaoResultadoCritico);
        } else {
            Exportacao.salvarParcial(st, this.fil_codigo, this.req_codigo, this.exa_codigo, String.valueOf(this.mco_codigo), this.usr_codigo, resultado, situacaoCompulsoria, validacaoResultadoCritico);
        }
    }

    public boolean fechouSalvar() {
        return this.fechou_salvar;
    }

    public boolean fechouSalvarEExportar() {
        return this.fechou_salvar_exportar;
    }

    private void definirTeclas() {
        ScreenUtil.addActionMap(this.digi, KeyStroke.getKeyStroke(10, 0, false), "enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                if (owner instanceof JButton) {
                    ((JButton)owner).doClick();
                } else if (!(owner instanceof TextoDigitacao)) {
                    EditarResultado.this.digi.setFocoProximo();
                }
            }
        });
        ScreenUtil.addActionMap(this.digi, KeyStroke.getKeyStroke(38, 0, true), "setaAcima", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = FocusManager.getCurrentManager().getFocusOwner();
                if (!(c instanceof JComboBox && ((JComboBox)c).isPopupVisible() || c instanceof TextoDigitacao)) {
                    EditarResultado.this.digi.setFocoAnterior();
                }
            }
        });
        ScreenUtil.addActionMap(this.digi, KeyStroke.getKeyStroke(40, 0, true), "setaAbaixo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = FocusManager.getCurrentManager().getFocusOwner();
                if (!(c instanceof JComboBox && ((JComboBox)c).isPopupVisible() || c instanceof TextoDigitacao)) {
                    EditarResultado.this.digi.setFocoProximo();
                }
            }
        });
    }

    @Override
    public void acaoImprimir(DigitacaoEvento e) {
    }

    public boolean isMontada() {
        return this.digi != null;
    }

    private boolean validaSituacaoExame() throws SQLException {
        if (this.equip == null) {
            return true;
        }
        this.retornoExportacao = "";
        Registro rs = BDUtil.getDadosExameRequisicaoJalisSemResultado(this.fil_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo);
        if (rs != null) {
            String exr_situacao = rs.getString("exr_situacao");
            if (exr_situacao.equalsIgnoreCase("L")) {
                this.retornoExportacao = "O Exame j\u00e1 encontra-se lan\u00e7ado";
            } else if (exr_situacao.equalsIgnoreCase("C")) {
                this.retornoExportacao = "O Exame j\u00e1 encontra-se conferido";
            } else if (exr_situacao.equalsIgnoreCase("I")) {
                this.retornoExportacao = "O Exame j\u00e1 encontra-se impresso";
            } else if (exr_situacao.equalsIgnoreCase("E")) {
                this.retornoExportacao = "O Exame j\u00e1 encontra-se entregue";
            } else {
                return true;
            }
            this.mostraMensagemValidacao(this.retornoExportacao);
        }
        return true;
    }

    private void mostraMensagemValidacao(String mensagem) {
        if (Funcoes.textoVazio(mensagem)) {
            return;
        }
        if (!this.isExportarValidados) {
            Funcoes.mensagem(this, this.retornoExportacao, 2);
            this.retornoExportacao = "";
        } else {
            this.equip.adicionarExcecao("Valida\u00e7\u00e3o de resultado: Tubo: " + this.fil_codigo + "-" + this.req_codigo + "-" + this.rec_codigo + " Exame: " + this.exa_codigo + " - " + this.retornoExportacao);
        }
    }

    private String getIdadeDescricao(int idade, String tipo) {
        if (tipo != null) {
            if (tipo.equalsIgnoreCase("A")) {
                return String.valueOf(idade) + (idade == 1 ? " ano" : " anos");
            }
            if (tipo.equalsIgnoreCase("M")) {
                return String.valueOf(idade) + (idade == 1 ? " m\u00eas" : " meses");
            }
            if (tipo.equalsIgnoreCase("D")) {
                return String.valueOf(idade) + (idade == 1 ? " dia" : " dias");
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGenero(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append(" select\tcoalesce(p.pac_genero, 0) as pac_genero ");
        query.append(" from requisicao r ");
        query.append(" left join paciente p on r.fil_codigo = p.fil_codigo and r.pac_codigo = p.pac_codigo ");
        query.append(" where r.fil_codigo = ").append(fil_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, query.toString());
        String genero = null;
        try {
            if (rs.next()) {
                genero = rs.getString("pac_genero");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharResultSet(rs);
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharResultSet(rs);
        Conexao.fecharStatement(st);
        return genero;
    }

    private void acaoAbrirPergunta() {
        if (!Funcoes.textoVazio(this.exr_resposta)) {
            InfoPerguntaExame ipergunta = new InfoPerguntaExame((Dialog)this, true, "Perguntas");
            ipergunta.setExame(this.exa_codigo, this.exa_descricao);
            ipergunta.setPerguntas(this.exr_resposta, null);
            ipergunta.setVisible(true);
        }
    }

    private void acaoAbrirIncorreto() {
        SolicitarMotivoPrepIncorreto p;
        if (!Funcoes.textoVazio(this.motivoIncorreto) && !this.isNullSolicitarMotivoPrepIncorreto(p = SolicitarMotivoPrepIncorreto.novaInstancia(this, false))) {
            p.setDescricaoMotivo(this.motivoIncorreto);
            p.setBloquearEdicao(true);
            p.setVisible(true);
        }
    }

    private boolean isNullSolicitarMotivoPrepIncorreto(SolicitarMotivoPrepIncorreto p) {
        return p == null;
    }

    private void acaoDadosRequisicao(Registro rsRequisicao) {
        DialogoDadosRequisicao dlg = new DialogoDadosRequisicao((Dialog)this, "Dados Requisi\u00e7\u00e3o", rsRequisicao);
        dlg.setVisible(true);
    }

    public boolean isPermitirContadorCelulas() {
        return this.permitirContadorCelulas;
    }

    public void setPermitirContadorCelulas(boolean permitirContadorCelulas) {
        this.permitirContadorCelulas = permitirContadorCelulas;
    }

    @Override
    @Deprecated
    public void acaoRemover(DigitacaoEvento e) {
    }
}

